/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.DataSetIllegalArgumentException;
import hec.data.IRating;
import hec.data.Interval;
import hec.data.RatingException;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.RatingSetFactory;
import hec.data.cwmsRating.RatingUtil;
import hec.data.cwmsRating.io.IndependentValuesContainer;
import hec.data.cwmsRating.io.SourceRatingContainer;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Constants;
import hec.hecmath.computation.MathExpression;
import hec.hecmath.computation.VariableSet;
import hec.io.Conversion;
import hec.io.TimeSeriesContainer;
import hec.util.TextUtil;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class SourceRating
implements IRating,
VerticalDatum,
Observer {
    protected MathExpression mathExpression = null;
    protected VariableSet vars = null;
    protected RatingSet ratings = null;
    protected String[] ratingUnits = null;
    protected String[] dataUnits = null;
    protected hec.lang.Observable observationTarget = new hec.lang.Observable();

    public SourceRating() {
    }

    public SourceRating(SourceRatingContainer src) throws RatingException {
        this.setData(src);
    }

    public SourceRating(RatingSet ratingSet, String[] ratingUnits) throws RatingException {
        this.setRatingSet(ratingSet, ratingUnits);
    }

    public SourceRating(RatingSet ratingSet, String ratingUnitsId) throws RatingException {
        this.setRatingSet(ratingSet, ratingUnitsId);
    }

    public SourceRating(RatingSet ratingSet) throws RatingException {
        this.setRatingSet(ratingSet);
    }

    void setData(SourceRatingContainer src) throws RatingException {
        block5: {
            try {
                if (src.mathExpression != null) {
                    this.setMathExpression(src.mathExpression, src.units);
                    break block5;
                }
                if (src.rsc != null) {
                    this.setRatingSet((RatingSet)RatingSetFactory.ratingSet(src.rsc), src.units);
                    break block5;
                }
                throw new RatingException("RatingSetContainer contains no data.");
            }
            catch (Exception e) {
                if (e instanceof RatingException) {
                    throw (RatingException)((Object)e);
                }
                throw new RatingException((Throwable)e);
            }
        }
    }

    SourceRatingContainer getData() {
        SourceRatingContainer src = new SourceRatingContainer();
        if (this.ratingUnits != null) {
            src.units = Arrays.copyOf(this.ratingUnits, this.ratingUnits.length);
        }
        if (this.mathExpression != null) {
            src.mathExpression = this.getMathExpression();
        } else if (this.ratings != null) {
            src.rsc = this.ratings.getData();
        }
        return src;
    }

    public String getMathExpression() {
        String mathExpressionString = null;
        if (this.mathExpression != null) {
            try {
                mathExpressionString = this.mathExpression.toNotation(Constants.Notation.INFIX);
                mathExpressionString = mathExpressionString.replaceAll("\\$([I|R]\\d+)", "$1");
            }
            catch (ComputationException e) {
                AbstractRating.logger.warning(e.getMessage());
            }
        }
        return mathExpressionString;
    }

    public void setMathExpression(String mathExpression, String[] units) throws ComputationException, RatingException {
        mathExpression = mathExpression.replaceAll("[I|R](\\d+)", "\\$I$1");
        this.mathExpression = new MathExpression(mathExpression);
        this.setRatingUnits(units);
        this.ratings = null;
    }

    public void setMathExpression(String mathExpression, String units) throws ComputationException, RatingException {
        mathExpression = mathExpression.replaceAll("[I|R](\\d+)", "\\$I$1");
        this.mathExpression = new MathExpression(mathExpression);
        this.setRatingUnits(units);
        this.ratings = null;
    }

    public RatingSet getRatingSet() {
        return this.ratings;
    }

    public void setRatingSet(RatingSet ratings, String[] units) throws RatingException {
        this.ratings = ratings;
        if (this.ratings != null) {
            this.ratings.addObserver(this);
        }
        this.setRatingUnits(units);
        this.mathExpression = null;
    }

    public void setRatingSet(RatingSet ratings, String units) throws RatingException {
        this.ratings = ratings;
        if (this.ratings != null) {
            this.ratings.addObserver(this);
        }
        this.setRatingUnits(units);
        this.mathExpression = null;
    }

    public void setRatingSet(RatingSet ratings) throws RatingException {
        this.ratings = ratings;
        if (this.ratings != null) {
            this.ratings.addObserver(this);
            this.setRatingUnits(ratings.getRatingUnits());
        }
        this.mathExpression = null;
    }

    public String getRatingUnitsString() {
        StringBuilder sb = new StringBuilder();
        if (this.ratingUnits != null) {
            sb.append(this.ratingUnits[0]);
            for (int i = 1; i < this.ratingUnits.length; ++i) {
                sb.append(i == this.ratingUnits.length - 1 ? ";" : ",").append(this.ratingUnits[i]);
            }
        }
        return sb.toString();
    }

    protected void setRatingUnits(String[] units) throws RatingException {
        if (this.ratings != null) {
            for (AbstractRating r : this.ratings.getRatings()) {
                r.setRatingUnits(units);
            }
        }
        if (this.mathExpression != null) {
            int varCount = this.mathExpression.getVariables().getVariableCount();
            if (units != null && units.length != varCount + 1) {
                throw new RatingException(String.format("Expected %d units for math expression (%s), got %d", varCount + 1, this.mathExpression.toString(), units.length));
            }
        }
        this.ratingUnits = units == null ? this.getRatingSet().getRatingUnits() : units;
        this.setDataUnits(this.getDataUnits());
    }

    protected void setRatingUnits(String units) throws RatingException {
        if (units == null) {
            this.setRatingUnits(this.getRatingSet().getRatingUnits());
        } else {
            this.setRatingUnits(TextUtil.split((String)units.replace(";", ","), (String)","));
        }
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        return this.ratings == null ? null : this.ratings.getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        return this.ratings == null ? null : this.ratings.getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.toNativeVerticalDatum();
    }

    public boolean toNGVD29() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.toNGVD29();
    }

    public boolean toNAVD88() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.toNAVD88();
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.toVerticalDatum(datum);
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.forceVerticalDatum(datum);
    }

    public double getCurrentOffset() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.getCurrentOffset();
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.getCurrentOffset();
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.getNGVD29Offset();
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.getNAVD88Offset();
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        return this.ratings.isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        return this.ratings == null ? null : this.ratings.getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String initStr) throws VerticalDatumException {
        if (this.ratings == null) {
            throw new VerticalDatumException("Source rating has no ratings");
        }
        this.ratings.setVerticalDatumInfo(initStr);
    }

    public String getName() {
        return this.ratings == null ? (this.mathExpression == null ? null : this.mathExpression.toString()) : this.ratings.getName();
    }

    public void setName(String name) throws RatingException {
        if (this.ratings == null) {
            throw new RatingException("Source rating has no ratings");
        }
        this.ratings.setName(name);
    }

    public String[] getRatingParameters() {
        return this.ratings == null ? null : this.ratings.getRatingParameters();
    }

    public String[] getRatingUnits() {
        return this.ratingUnits == null ? null : this.ratingUnits;
    }

    public String[] getDataUnits() {
        return this.dataUnits == null ? this.getRatingUnits() : this.dataUnits;
    }

    public void setDataUnits(String[] units) throws RatingException {
        if (this.ratings != null) {
            this.ratings.setDataUnits(units);
        }
        if (this.mathExpression != null) {
            int varCount = this.mathExpression.getVariables().getVariableCount();
            if (units != null && units.length != varCount + 1) {
                throw new RatingException(String.format("Expected %d units for math expression (%s), got %d", varCount + 1, this.mathExpression.toString(), units.length));
            }
        }
        this.dataUnits = units == null ? null : units;
    }

    public long getDefaultValueTime() {
        return this.ratings == null ? Long.MIN_VALUE : this.ratings.getDefaultValueTime();
    }

    public void setDefaultValueTime(long defaultValueTime) {
        if (this.ratings != null) {
            this.ratings.setDefaultValueTime(defaultValueTime);
        }
    }

    public void resetDefaultValuetime() {
        this.setDefaultValueTime(Long.MIN_VALUE);
    }

    public long getRatingTime() {
        return this.ratings == null ? null : Long.valueOf(this.ratings.getRatingTime());
    }

    public void setRatingTime(long ratingTime) {
        if (this.ratings != null) {
            this.ratings.setRatingTime(ratingTime);
        }
    }

    public void resetRatingTime() {
        this.setRatingTime(Long.MIN_VALUE);
    }

    public double[][] getRatingExtents() throws RatingException {
        if (this.ratings == null) {
            throw new RatingException("Source rating has no ratings");
        }
        return this.ratings.getRatingExtents();
    }

    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        if (this.ratings == null) {
            throw new RatingException("Source rating has no ratings");
        }
        return this.ratings.getRatingExtents(ratingTime);
    }

    public long[] getEffectiveDates() {
        return this.ratings == null ? null : this.ratings.getEffectiveDates();
    }

    public long[] getCreateDates() {
        return this.ratings == null ? null : this.ratings.getCreateDates();
    }

    public double rate(double indVal) throws RatingException {
        double result = -3.4028234663852886E38;
        if (this.ratings != null) {
            result = this.ratings.rate(indVal);
        } else if (this.mathExpression != null) {
            try {
                VariableSet vars = this.mathExpression.getVariables();
                vars.reset();
                vars.getVariable("$I1").setValue(indVal);
                result = this.mathExpression.evaluate();
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return result;
    }

    public double rateOne(double ... indVals) throws RatingException {
        return this.rateOne2(indVals);
    }

    public double rateOne2(double[] indVals) throws RatingException {
        double result = -3.4028234663852886E38;
        if (this.ratings != null) {
            result = this.ratings.rateOne(indVals);
        } else if (this.mathExpression != null) {
            try {
                VariableSet vars = this.mathExpression.getVariables();
                vars.reset();
                for (int i = 0; i < vars.getVariableCount(); ++i) {
                    vars.getVariable("$I" + (i + 1)).setValue(indVals[i]);
                }
                result = this.mathExpression.evaluate();
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return result;
    }

    public double[] rate(double[] indVals) throws RatingException {
        double[] results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(indVals);
        } else if (this.mathExpression != null) {
            try {
                VariableSet vars = this.mathExpression.getVariables();
                vars.reset();
                results = new double[indVals.length];
                for (int i = 0; i < indVals.length; ++i) {
                    vars.getVariable("$I1").setValue(indVals[i]);
                    results[i] = this.mathExpression.evaluate();
                }
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public double[] rate(double[][] indVals) throws RatingException {
        double[] results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(indVals);
        } else if (this.mathExpression != null) {
            try {
                int i;
                for (i = 0; i < indVals.length; ++i) {
                    if (indVals[i] != null && indVals[i].length == indVals[0].length) continue;
                    throw new RatingException("Inconsistent independent values set");
                }
                if (this.vars == null) {
                    this.vars = this.mathExpression.getVariables();
                }
                results = new double[indVals.length];
                for (i = 0; i < indVals.length; ++i) {
                    for (int j = 0; j < indVals[0].length; ++j) {
                        this.vars.getVariable("$I" + (j + 1)).setValue(indVals[i][j]);
                    }
                    results[i] = this.mathExpression.evaluate();
                }
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public double rate(long valTime, double indVal) throws RatingException {
        double result = -3.4028234663852886E38;
        if (this.ratings != null) {
            result = this.ratings.rate(valTime, indVal);
        } else if (this.mathExpression != null) {
            try {
                VariableSet vars = this.mathExpression.getVariables();
                vars.reset();
                vars.getVariable("$I1").setValue(indVal);
                result = this.mathExpression.evaluate();
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return result;
    }

    public double rateOne(long valTime, double ... indVals) throws RatingException {
        return this.rateOne2(valTime, indVals);
    }

    public double rateOne2(long valTime, double[] indVals) throws RatingException {
        double result = -3.4028234663852886E38;
        if (this.ratings != null) {
            result = this.ratings.rateOne(valTime, indVals);
        } else if (this.mathExpression != null) {
            try {
                VariableSet vars = this.mathExpression.getVariables();
                vars.reset();
                for (int i = 0; i < vars.getVariableCount(); ++i) {
                    vars.getVariable("$I" + (i + 1)).setValue(indVals[i]);
                }
                result = this.mathExpression.evaluate();
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return result;
    }

    public double[] rate(long valTime, double[] indVals) throws RatingException {
        double[] results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(valTime, indVals);
        } else if (this.mathExpression != null) {
            results = this.rate(indVals);
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public double[] rate(long[] valTimes, double[] indVals) throws RatingException {
        double[] results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(valTimes, indVals);
        } else if (this.mathExpression != null) {
            results = this.rate(indVals);
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public double[] rate(long valTime, double[][] indVals) throws RatingException {
        double[] results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(valTime, indVals);
        } else if (this.mathExpression != null) {
            results = this.rate(indVals);
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public double[] rate(long[] valTimes, double[][] indVals) throws RatingException {
        double[] results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(valTimes, indVals);
        } else if (this.mathExpression != null) {
            results = this.rate(indVals);
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public TimeSeriesContainer rate(TimeSeriesContainer tsc) throws RatingException {
        TimeSeriesContainer results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(tsc);
        } else if (this.mathExpression != null) {
            results = new TimeSeriesContainer();
            tsc.clone(results);
            double[] values = Arrays.copyOf(tsc.values, tsc.values.length);
            try {
                Units.convertUnits((double[])values, (String)tsc.units, (String)this.ratingUnits[0]);
            }
            catch (UnitsConversionException e) {
                throw new RatingException((Throwable)e);
            }
            results.values = this.rate(values);
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public TimeSeriesContainer rate(TimeSeriesContainer[] tscs) throws RatingException {
        TimeSeriesContainer results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(tscs);
        } else if (this.mathExpression != null) {
            results = new TimeSeriesContainer();
            tscs[0].clone(results);
            TimeZone tz = TimeZone.getTimeZone(String.format("Etc/GMT+%+d", -tscs[0].timeZoneRawOffset));
            IndependentValuesContainer ivc = RatingUtil.tscsToIvc(tscs, this.ratingUnits, tz, true, true);
            VariableSet vars = this.mathExpression.getVariables();
            results.numberValues = ivc.valTimes.length;
            results.times = new int[results.numberValues];
            results.values = new double[results.numberValues];
            try {
                for (int i = 0; i < results.numberValues; ++i) {
                    results.times[i] = Conversion.toMinutes((long)ivc.valTimes[i]);
                    vars.reset();
                    for (int v = 0; v < vars.getVariableCount(); ++v) {
                        vars.getVariable("$I" + (v + 1)).setValue(ivc.indVals[v][i]);
                    }
                    results.values[i] = this.mathExpression.evaluate();
                }
            }
            catch (ComputationException e) {
                throw new RatingException((Throwable)e);
            }
            if (results.numberValues != tscs[0].numberValues) {
                int intvl;
                if (results.numberValues == 0) {
                    results.startTime = 0;
                    results.endTime = 0;
                } else {
                    results.startTime = results.times[0];
                    results.endTime = results.times[results.times.length - 1];
                }
                if (results.numberValues == 1) {
                    intvl = 0;
                } else {
                    intvl = results.times[1] = results.times[0];
                    for (int i = 2; i < results.numberValues; ++i) {
                        if (results.times[i] - results.times[i - 1] == intvl) continue;
                        intvl = 0;
                        break;
                    }
                }
                Interval cwmsIntvl = null;
                try {
                    cwmsIntvl = new Interval(intvl);
                }
                catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                    // empty catch block
                }
                String intvlStr = cwmsIntvl == null ? "0" : cwmsIntvl.getInterval();
                String[] parts = TextUtil.split((String)results.fullName, (String)"/");
                if (parts.length == 8) {
                    if (intvlStr.equals("0")) {
                        double numPerDay;
                        intvlStr = results.numberValues < 2 ? "IR-MONTH" : ((numPerDay = (double)results.numberValues / ((double)(results.endTime - results.startTime) / 1440.0)) > 100.0 ? "IR-DAY" : (numPerDay > 3.3333333333333335 ? "IR-MONTH" : (numPerDay > 0.273972602739726 ? "IR-YEAR" : (numPerDay > 0.0273972602739726 ? "IR-DECADE" : "IR-CENTURY"))));
                    } else {
                        parts[5] = intvlStr = intvlStr.toUpperCase().replaceFirst("S$", "").replace("MINUTE", "MIN").replace("MONTH", "MON");
                    }
                    results.fullName = TextUtil.join((String)"/", (String[])parts);
                } else {
                    parts = TextUtil.split((String)results.fullName, (String)".");
                    if (parts.length == 6) {
                        parts[3] = intvlStr;
                        results.fullName = TextUtil.join((String)".", (String[])parts);
                    }
                }
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public TimeSeriesMath rate(TimeSeriesMath tsm) throws RatingException {
        TimeSeriesMath results = null;
        if (this.ratings != null) {
            results = this.ratings.rate(tsm);
        } else if (this.mathExpression != null) {
            try {
                TimeSeriesContainer tsc = this.rate((TimeSeriesContainer)tsm.getData());
                results = new TimeSeriesMath(tsc);
            }
            catch (HecMathException e) {
                throw new RatingException((Throwable)e);
            }
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return results;
    }

    public TimeSeriesMath rate(TimeSeriesMath[] tsms) throws RatingException {
        TimeSeriesMath results = null;
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[tsms.length];
        try {
            for (int i = 0; i < tscs.length; ++i) {
                tscs[i] = (TimeSeriesContainer)tsms[i].getData();
            }
            TimeSeriesContainer tsc = this.rate(tscs);
            results = new TimeSeriesMath(tsc);
        }
        catch (HecMathException e) {
            throw new RatingException((Throwable)e);
        }
        return results;
    }

    public double reverseRate(double depVal) throws RatingException {
        double result = -3.4028234663852886E38;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        result = this.ratings.reverseRate(depVal);
        return result;
    }

    public double[] reverseRate(double[] depVals) throws RatingException {
        double[] results = null;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        results = this.ratings.reverseRate(depVals);
        return results;
    }

    public double reverseRate(long valTime, double depVal) throws RatingException {
        double result = -3.4028234663852886E38;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        result = this.ratings.reverseRate(valTime, depVal);
        return result;
    }

    public double[] reverseRate(long valTime, double[] depVals) throws RatingException {
        double[] results = null;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        results = this.ratings.reverseRate(valTime, depVals);
        return results;
    }

    public double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        double[] results = null;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        results = this.ratings.reverseRate(valTimes, depVals);
        return results;
    }

    public TimeSeriesContainer reverseRate(TimeSeriesContainer tsc) throws RatingException {
        TimeSeriesContainer results = null;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        results = this.ratings.reverseRate(tsc);
        return results;
    }

    public TimeSeriesMath reverseRate(TimeSeriesMath tsm) throws RatingException {
        TimeSeriesMath results = null;
        if (this.ratings == null) {
            if (this.mathExpression != null) {
                throw new RatingException("Cannot reverse rate a source rating formula");
            }
            throw new RatingException("Source rating has no information.");
        }
        results = this.ratings.reverseRate(tsm);
        return results;
    }

    public int getIndParamCount() throws RatingException {
        int count = Integer.MIN_VALUE;
        if (this.ratings != null) {
            count = this.ratings.getIndParamCount();
        } else if (this.mathExpression != null) {
            count = this.mathExpression.getVariables().getVariableCount();
        } else {
            throw new RatingException("Source rating has no information.");
        }
        return count;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((SourceRating)obj).getData());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        SourceRating sourceRating = this;
        synchronized (sourceRating) {
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer o) {
        hec.lang.Observable observable = this.observationTarget;
        synchronized (observable) {
            this.observationTarget.addObserver(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer o) {
        hec.lang.Observable observable = this.observationTarget;
        synchronized (observable) {
            this.observationTarget.deleteObserver(o);
        }
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        VerticalDatumContainer retval = null;
        if (this.ratings != null) {
            retval = this.ratings.getVerticalDatumContainer();
        }
        return retval;
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) {
        if (this.ratings != null) {
            this.ratings.setVerticalDatumContainer(vdc);
        }
    }
}

