/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.NotMonotonicRatingException;
import hec.data.RatingException;
import hec.data.RatingOutOfRangeException;
import hec.data.Units;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingConst;
import hec.data.cwmsRating.RatingTemplate;
import hec.data.cwmsRating.RatingValue;
import hec.data.cwmsRating.SequenceProperties;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingValueContainer;
import hec.data.cwmsRating.io.TableRatingContainer;
import hec.data.cwmsRating.io.VirtualRatingContainer;
import hec.lang.Observable;
import hec.util.TextUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class TableRating
extends AbstractRating {
    protected RatingValue[] values = null;
    protected RatingValue[] extensionValues = null;
    protected RatingValue[] effectiveValues = null;
    protected TableRating reversed = null;
    protected RatingConst.RatingMethod inRangeMethod = RatingConst.RatingMethod.LINEAR;
    protected RatingConst.RatingMethod outRangeLowMethod = RatingConst.RatingMethod.ERROR;
    protected RatingConst.RatingMethod outRangeHighMethod = RatingConst.RatingMethod.ERROR;
    protected SequenceProperties props = null;

    protected TableRating() {
    }

    static void setBehaviors(TableRatingContainer trc, RatingConst.RatingMethod[] inRangeMethods, RatingConst.RatingMethod[] outRangeLowMethods, RatingConst.RatingMethod[] outRangeHighMethods, int offset) {
        trc.inRangeMethod = inRangeMethods[offset].name();
        trc.outRangeLowMethod = outRangeLowMethods[offset].name();
        trc.outRangeHighMethod = outRangeHighMethods[offset].name();
        if (offset < inRangeMethods.length - 1) {
            for (int i = 0; i < trc.values.length; ++i) {
                TableRating.setBehaviors(trc.values[i].depTable, inRangeMethods, outRangeLowMethods, outRangeHighMethods, offset + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBehaviors(RatingTemplate template) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            TableRatingContainer trc = this.getData();
            TableRating.setBehaviors(trc, template.getInRangeMethods(), template.getOutRangeLowMethods(), template.getOutRangeHighMethods(), 0);
            this.setData(trc);
        }
    }

    protected TableRating(RatingValue[] values, RatingValue[] extensionValues, RatingConst.RatingMethod inRangeMethod, RatingConst.RatingMethod outRangeLowMethod, RatingConst.RatingMethod outRangeHighMethod) throws RatingException {
        this.init(values, extensionValues, inRangeMethod, outRangeLowMethod, outRangeHighMethod, null, null, null, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, true, null);
    }

    public TableRating(TableRatingContainer trc) throws RatingException {
        int i;
        RatingValue[] values = null;
        RatingValue[] extensionValues = null;
        if (trc.values != null) {
            values = new RatingValue[trc.values.length];
            for (i = 0; i < trc.values.length; ++i) {
                values[i] = new RatingValue(trc.values[i]);
            }
        }
        if (trc.extensionValues != null) {
            extensionValues = new RatingValue[trc.extensionValues.length];
            for (i = 0; i < trc.extensionValues.length; ++i) {
                extensionValues[i] = new RatingValue(trc.extensionValues[i]);
            }
        }
        this.init(values, extensionValues, RatingConst.RatingMethod.fromString(trc.inRangeMethod == null ? "LINEAR" : trc.inRangeMethod), RatingConst.RatingMethod.fromString(trc.outRangeLowMethod == null ? "ERROR" : trc.outRangeLowMethod), RatingConst.RatingMethod.fromString(trc.outRangeHighMethod == null ? "ERROR" : trc.outRangeHighMethod), trc.officeId, trc.ratingSpecId, trc.unitsId, trc.effectiveDateMillis, trc.transitionStartDateMillis, trc.createDateMillis, trc.active, trc.description);
        if (trc.getVerticalDatumContainer() != null) {
            this.vdc = trc.getVerticalDatumContainer().clone();
        }
    }

    @Deprecated
    public TableRating(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        VirtualRatingContainer container = service.createVirtualRatingContainer(xmlText);
        this.setData(container);
    }

    public TableRating(RatingValue[] values, RatingValue[] extensionValues, RatingConst.RatingMethod inRangeMethod, RatingConst.RatingMethod outRangeLowMethod, RatingConst.RatingMethod outRangeHighMethod, String officeId, String ratingSpecId, String unitsId, long effectiveDate, long createDate, boolean active, String description) throws RatingException {
        this.init(values, extensionValues, inRangeMethod, outRangeLowMethod, outRangeHighMethod, officeId, ratingSpecId, unitsId, effectiveDate, Long.MIN_VALUE, createDate, active, description);
    }

    public TableRating(RatingValue[] values, RatingValue[] extensionValues, RatingConst.RatingMethod inRangeMethod, RatingConst.RatingMethod outRangeLowMethod, RatingConst.RatingMethod outRangeHighMethod, String officeId, String ratingSpecId, String unitsId, long effectiveDate, long transitionStartDate, long createDate, boolean active, String description) throws RatingException {
        this.init(values, extensionValues, inRangeMethod, outRangeLowMethod, outRangeHighMethod, officeId, ratingSpecId, unitsId, effectiveDate, transitionStartDate, createDate, active, description);
    }

    protected boolean eq(double v1, double v2) {
        return Math.abs(v2 - v1) < 1.0E-8;
    }

    protected boolean ne(double v1, double v2) {
        return !this.eq(v1, v2);
    }

    protected boolean gt(double v1, double v2) {
        return !this.eq(v1, v2) && v1 > v2;
    }

    protected boolean ge(double v1, double v2) {
        return this.eq(v1, v2) || v1 > v2;
    }

    protected boolean lt(double v1, double v2) {
        return !this.eq(v1, v2) && v1 < v2;
    }

    protected boolean le(double v1, double v2) {
        return this.eq(v1, v2) || v1 < v2;
    }

    public double rate(double pIndVal) throws RatingException {
        double[] ind_vals = new double[]{pIndVal};
        return this.rate(ind_vals, 0);
    }

    public double rateOne(double ... pIndVals) throws RatingException {
        return this.rate(pIndVals, 0);
    }

    public double rateOne2(double[] pIndVals) throws RatingException {
        return this.rate(pIndVals, 0);
    }

    public double[] rate(double[] pIndVals) throws RatingException {
        double[] rated = new double[pIndVals.length];
        for (int i = 0; i < pIndVals.length; ++i) {
            rated[i] = this.rate(pIndVals[i]);
        }
        return rated;
    }

    public double[] rate(double[][] pIndVals) throws RatingException {
        for (int i = 1; i < pIndVals.length; ++i) {
            if (pIndVals[i].length == pIndVals[0].length) continue;
            throw new RatingException("Independent value sets have varying lengths.");
        }
        if (pIndVals[0].length != this.getIndParamCount()) {
            throw new RatingException(String.format("Data has %d independent parameters; rating %s requires %d", pIndVals.length, this.ratingSpecId, this.getIndParamCount()));
        }
        double[] rated = new double[pIndVals.length];
        for (int i = 0; i < pIndVals.length; ++i) {
            rated[i] = this.rate(pIndVals[i], 0);
        }
        return rated;
    }

    protected double rate(double[] pIndVals, int p_offset) throws RatingException {
        String[] ratingUnits = this.getRatingUnits();
        if (ratingUnits == null) {
            throw new RatingException("Rating units have not been set");
        }
        String[] dataUnits = this.getDataUnits();
        if (dataUnits == null) {
            return this.rate(pIndVals, ratingUnits, ratingUnits, p_offset);
        }
        for (int i = 0; i < ratingUnits.length; ++i) {
            if (TextUtil.equals((CharSequence)dataUnits[i], (CharSequence)ratingUnits[i])) {
                ratingUnits[i] = null;
                dataUnits[i] = null;
                continue;
            }
            if (Units.canConvertBetweenUnits((String)dataUnits[i], (String)ratingUnits[i])) continue;
            String msg = String.format("Cannot convert from \"%s\" to \"%s\".", dataUnits[i], ratingUnits[i]);
            if (!this.allowUnsafe) {
                throw new RatingException(msg);
            }
            if (!this.warnUnsafe) continue;
            logger.warning(msg + "  Rating will be performed on unconverted values.");
        }
        return this.rate(pIndVals, dataUnits, ratingUnits, p_offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double rate(double[] pIndVals, String[] dataUnits, String[] ratingUnits, int p_offset) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            double dep_val;
            block63: {
                RatingConst.RatingMethod extrap_method;
                int hi;
                int lo;
                boolean out_range_high;
                boolean out_range_low;
                double ind_val;
                block64: {
                    block62: {
                        ind_val = pIndVals[p_offset];
                        if (ind_val == -3.4028234663852886E38) {
                            return -3.4028234663852886E38;
                        }
                        ind_val = this.convertUnits(ind_val, dataUnits[p_offset], ratingUnits[p_offset]);
                        out_range_low = false;
                        out_range_high = false;
                        lo = 0;
                        hi = this.effectiveValues.length - 1;
                        extrap_method = null;
                        dep_val = -3.4028234663852886E38;
                        if (this.props.hasIncreasing() || this.values.length == 1) {
                            if (this.lt(ind_val, this.effectiveValues[lo].getIndValue())) {
                                out_range_low = true;
                                hi = lo + 1;
                            } else if (this.gt(ind_val, this.effectiveValues[hi].getIndValue())) {
                                out_range_high = true;
                                lo = hi - 1;
                            } else {
                                while (hi - lo > 1) {
                                    int mid = (lo + hi) / 2;
                                    double mid_ind_val = this.effectiveValues[mid].getIndValue();
                                    if (this.lt(ind_val, mid_ind_val)) {
                                        hi = mid;
                                        continue;
                                    }
                                    lo = mid;
                                }
                            }
                        } else if (this.props.hasDecreasing()) {
                            if (this.gt(ind_val, this.effectiveValues[lo].getIndValue())) {
                                out_range_low = true;
                                hi = lo;
                                lo = hi + 1;
                            } else if (this.lt(ind_val, this.effectiveValues[hi].getIndValue())) {
                                out_range_high = true;
                                lo = hi;
                                hi = lo - 1;
                            } else {
                                while (hi - lo > 1) {
                                    int mid = (lo + hi) / 2;
                                    double mid_ind_val = this.effectiveValues[mid].getIndValue();
                                    if (this.gt(ind_val, mid_ind_val)) {
                                        hi = mid;
                                        continue;
                                    }
                                    lo = mid;
                                }
                            }
                        } else {
                            throw new RatingException("Table does not monotonically increase or decrease");
                        }
                        if (!out_range_low) break block62;
                        switch (this.outRangeLowMethod) {
                            case NULL: {
                                dep_val = -3.4028234663852886E38;
                                break block63;
                            }
                            case ERROR: {
                                throw new RatingOutOfRangeException(RatingOutOfRangeException.OutOfRangeEnum.OUT_OF_RANGE_LOW);
                            }
                            case LINEAR: 
                            case LOGARITHMIC: 
                            case LIN_LOG: 
                            case LOG_LIN: {
                                extrap_method = this.outRangeLowMethod;
                                break block64;
                            }
                            case PREVIOUS: {
                                throw new RatingException("No previous value in table.");
                            }
                            case NEXT: 
                            case NEAREST: 
                            case CLOSEST: {
                                dep_val = this.effectiveValues[0].hasDepValue() ? this.effectiveValues[0].getDepValue() : this.effectiveValues[0].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                                break block63;
                            }
                            case LOWER: {
                                if (this.props.hasIncreasing()) {
                                    throw new RatingException("No lower value in table.");
                                }
                                dep_val = this.effectiveValues[0].hasDepValue() ? this.effectiveValues[0].getDepValue() : this.effectiveValues[0].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                                break block63;
                            }
                            case HIGHER: {
                                if (this.props.hasDecreasing()) {
                                    throw new RatingException("No higher value in table.");
                                }
                                dep_val = this.effectiveValues[0].hasDepValue() ? this.effectiveValues[0].getDepValue() : this.effectiveValues[0].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                                break block63;
                            }
                            default: {
                                throw new RatingException("Unexpected behavior specified : " + this.outRangeLowMethod + " : " + this.outRangeLowMethod.description());
                            }
                        }
                    }
                    if (!out_range_high) break block64;
                    switch (this.outRangeHighMethod) {
                        case NULL: {
                            dep_val = -3.4028234663852886E38;
                            break block63;
                        }
                        case ERROR: {
                            throw new RatingOutOfRangeException(RatingOutOfRangeException.OutOfRangeEnum.OUT_OF_RANGE_HIGH);
                        }
                        case LINEAR: 
                        case LOGARITHMIC: 
                        case LIN_LOG: 
                        case LOG_LIN: {
                            extrap_method = this.outRangeHighMethod;
                            break;
                        }
                        case NEXT: {
                            throw new RatingException("No next value in table.");
                        }
                        case PREVIOUS: 
                        case NEAREST: 
                        case CLOSEST: {
                            dep_val = this.effectiveValues[this.effectiveValues.length - 1].hasDepValue() ? this.effectiveValues[this.effectiveValues.length - 1].getDepValue() : this.effectiveValues[this.effectiveValues.length - 1].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                            break block63;
                        }
                        case LOWER: {
                            if (this.props.hasDecreasing()) {
                                throw new RatingException("No lower value in table.");
                            }
                            dep_val = this.effectiveValues[this.effectiveValues.length - 1].hasDepValue() ? this.effectiveValues[this.effectiveValues.length - 1].getDepValue() : this.effectiveValues[this.effectiveValues.length - 1].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                            break block63;
                        }
                        case HIGHER: {
                            if (this.props.hasIncreasing()) {
                                throw new RatingException("No higher value in table.");
                            }
                            dep_val = this.effectiveValues[this.effectiveValues.length - 1].hasDepValue() ? this.effectiveValues[this.effectiveValues.length - 1].getDepValue() : this.effectiveValues[this.effectiveValues.length - 1].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                            break block63;
                        }
                        default: {
                            throw new RatingException("Unexpected behavior specified : " + this.outRangeHighMethod + " : " + this.outRangeHighMethod.description());
                        }
                    }
                }
                double lo_ind_val = this.effectiveValues[lo].getIndValue();
                double hi_ind_val = this.effectiveValues[hi].getIndValue();
                if (this.eq(ind_val, lo_ind_val)) {
                    dep_val = this.effectiveValues[lo].hasDepValue() ? this.effectiveValues[lo].getDepValue() : this.effectiveValues[lo].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                } else if (this.eq(ind_val, hi_ind_val)) {
                    dep_val = this.effectiveValues[hi].hasDepValue() ? this.effectiveValues[hi].getDepValue() : this.effectiveValues[hi].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                } else {
                    double hi_dep_val;
                    double lo_dep_val = this.effectiveValues[lo].hasDepValue() ? this.effectiveValues[lo].getDepValue() : this.effectiveValues[lo].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                    double d = hi_dep_val = this.effectiveValues[hi].hasDepValue() ? this.effectiveValues[hi].getDepValue() : this.effectiveValues[hi].getDepValues().rate(pIndVals, dataUnits, ratingUnits, p_offset + 1);
                    if (lo_dep_val == -3.4028234663852886E38 || hi_dep_val == -3.4028234663852886E38) {
                        return -3.4028234663852886E38;
                    }
                    RatingConst.RatingMethod method = out_range_low || out_range_high ? extrap_method : this.inRangeMethod;
                    switch (method) {
                        case NULL: {
                            return -3.4028234663852886E38;
                        }
                        case ERROR: {
                            throw new RatingException("No such value in table.");
                        }
                        case PREVIOUS: {
                            dep_val = lo_dep_val;
                            break;
                        }
                        case NEXT: {
                            dep_val = hi_dep_val;
                            break;
                        }
                        case LOWER: {
                            dep_val = this.props.hasIncreasing() ? lo_dep_val : hi_dep_val;
                            break;
                        }
                        case HIGHER: {
                            dep_val = this.props.hasDecreasing() ? lo_dep_val : hi_dep_val;
                            break;
                        }
                        case CLOSEST: {
                            dep_val = this.lt(Math.abs(ind_val - lo_ind_val), Math.abs(hi_ind_val - ind_val)) ? lo_dep_val : hi_dep_val;
                            break;
                        }
                        default: {
                            boolean ind_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LOG_LIN;
                            boolean dep_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LIN_LOG;
                            double x = ind_val;
                            double x1 = lo_ind_val;
                            double x2 = hi_ind_val;
                            double y1 = lo_dep_val;
                            double y2 = hi_dep_val;
                            if (ind_log) {
                                x = Math.log10(x);
                                x1 = Math.log10(x1);
                                x2 = Math.log10(x2);
                                if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(x1) || Double.isInfinite(x1) || Double.isNaN(x2) || Double.isInfinite(x2)) {
                                    x = ind_val;
                                    x1 = lo_ind_val;
                                    x2 = hi_ind_val;
                                    dep_log = false;
                                }
                            }
                            if (dep_log) {
                                y1 = Math.log10(y1);
                                y2 = Math.log10(y2);
                                if (Double.isNaN(y1) || Double.isInfinite(y1) || Double.isNaN(y2) || Double.isInfinite(y2)) {
                                    x = ind_val;
                                    x1 = lo_ind_val;
                                    x2 = hi_ind_val;
                                    y1 = lo_dep_val;
                                    y2 = hi_dep_val;
                                    dep_log = false;
                                }
                            }
                            double y = y1 + (x - x1) / (x2 - x1) * (y2 - y1);
                            if (dep_log) {
                                y = Math.pow(10.0, y);
                            }
                            dep_val = y;
                            break;
                        }
                    }
                }
            }
            if (p_offset == 0 && dep_val != -3.4028234663852886E38) {
                dep_val = this.convertUnits(dep_val, ratingUnits[ratingUnits.length - 1], dataUnits[dataUnits.length - 1]);
            }
            return dep_val;
        }
    }

    public double rate(long valTime, double pIndVal) throws RatingException {
        return this.rate(pIndVal);
    }

    public double rateOne(long valTime, double ... pIndVals) throws RatingException {
        return this.rateOne(pIndVals);
    }

    public double rateOne2(long valTime, double[] pIndVals) throws RatingException {
        return this.rateOne(pIndVals);
    }

    public double[] rate(long valTime, double[] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    public double[] rate(long[] valTimes, double[] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    public double[] rate(long valTime, double[][] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    public double[] rate(long[] valTimes, double[][] pIndVals) throws RatingException {
        return this.rate(pIndVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            long[] times = null;
            if (valTimes == null) {
                times = new long[depVals.length];
                Arrays.fill(times, this.defaultValueTime);
            } else {
                times = valTimes;
            }
            if (times.length != depVals.length) {
                throw new RatingException("Different numbers of times and values.");
            }
            double[] indVals = new double[times.length];
            for (int i = 0; i < times.length; ++i) {
                indVals[i] = this.reverseRate(times[i], depVals[i]);
            }
            return indVals;
        }
    }

    @Override
    public TableRatingContainer getData() {
        TableRatingContainer trc = new TableRatingContainer();
        this.getData(trc);
        return trc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(AbstractRatingContainer rc) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (!(rc instanceof TableRatingContainer)) {
                throw new RatingException("setData() requires a TableRatingContainer object.");
            }
            try {
                super._setData(rc);
                TableRatingContainer trc = (TableRatingContainer)rc;
                if (this.values != null) {
                    for (RatingValue value : this.values) {
                        value.deleteObserver(this);
                    }
                }
                if (this.extensionValues != null) {
                    for (RatingValue value : this.extensionValues) {
                        value.deleteObserver(this);
                    }
                }
                RatingValue[] values = new RatingValue[trc.values.length];
                for (int i = 0; i < trc.values.length; ++i) {
                    values[i] = new RatingValue(trc.values[i]);
                }
                RatingValue[] extensionValues = null;
                if (trc.extensionValues != null) {
                    extensionValues = new RatingValue[trc.extensionValues.length];
                    for (int i = 0; i < trc.extensionValues.length; ++i) {
                        extensionValues[i] = new RatingValue(trc.extensionValues[i]);
                    }
                } else {
                    extensionValues = null;
                }
                this.init(values, extensionValues, RatingConst.RatingMethod.fromString(trc.inRangeMethod == null ? "LOGARITHMIC" : trc.inRangeMethod), RatingConst.RatingMethod.fromString(trc.outRangeLowMethod == null ? "ERROR" : trc.outRangeLowMethod), RatingConst.RatingMethod.fromString(trc.outRangeHighMethod == null ? "ERROR" : trc.outRangeHighMethod), trc.officeId, trc.ratingSpecId, trc.unitsId, trc.effectiveDateMillis, trc.transitionStartDateMillis, trc.createDateMillis, trc.active, trc.description);
                this.observationTarget.setChanged();
                this.observationTarget.notifyObservers();
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    @Override
    @Deprecated
    public String toXmlString(CharSequence indent, int indentLevel) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, indentLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLookupMethods() {
        TableRating tableRating = this;
        synchronized (tableRating) {
            return this.getData().getLookupMethods();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupMethods(String xml) {
        TableRating tableRating = this;
        synchronized (tableRating) {
            try {
                Document doc = new SAXBuilder().build((Reader)new StringReader(xml));
                Element elem = doc.getRootElement();
                if (elem.getName().equals("lookup-behaviors")) {
                    this.inRangeMethod = RatingConst.RatingMethod.fromString(elem.getChildText("in-range"));
                    this.outRangeLowMethod = RatingConst.RatingMethod.fromString(elem.getChildText("out-range-low"));
                    this.outRangeHighMethod = RatingConst.RatingMethod.fromString(elem.getChildText("out-range-high"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public double reverseRate(long valTime, double depVal) throws RatingException {
        if (this.reversed == null) {
            this.reverse();
        }
        return this.reversed.rate(valTime, depVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndParamCount() throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            return this.ratingSpecId == null ? (this.values == null ? 0 : TableRating.getIndParamCount(this.values)) : this.getRatingParameters().length - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (this.ratingSpecId == null) {
                throw new RatingException("Only top level ratings can return rating extents.");
            }
            double[][] extents = new double[2][this.getIndParamCount() + 1];
            Arrays.fill(extents[0], Double.POSITIVE_INFINITY);
            Arrays.fill(extents[1], Double.NEGATIVE_INFINITY);
            this.getRatingExtents(extents, 0);
            String[] dataUnits = this.getDataUnits();
            String[] ratingUnits = this.getRatingUnits();
            for (int i = 0; i < extents[0].length; ++i) {
                if (TextUtil.equals((CharSequence)dataUnits[i], (CharSequence)ratingUnits[i])) continue;
                extents[0][i] = this.convertUnits(extents[0][i], ratingUnits[i], dataUnits[i]);
                extents[1][i] = this.convertUnits(extents[1][i], ratingUnits[i], dataUnits[i]);
            }
            return extents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getRatingExtents(double[][] extents, int level) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (this.values == null || this.values.length == 0) {
                throw new RatingException("Empty rating.");
            }
            if (this.props.hasIncreasing) {
                if (this.lt(this.values[0].indValue, extents[0][level])) {
                    extents[0][level] = this.values[0].indValue;
                }
                if (this.gt(this.values[this.values.length - 1].indValue, extents[1][level])) {
                    extents[1][level] = this.values[this.values.length - 1].indValue;
                }
            } else {
                if (this.lt(this.values[this.values.length - 1].indValue, extents[0][level])) {
                    extents[0][level] = this.values[this.values.length - 1].indValue;
                }
                if (this.gt(this.values[0].indValue, extents[1][level])) {
                    extents[1][level] = this.values[0].indValue;
                }
            }
            boolean isLeaf = this.values[0].hasDepValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (isLeaf) {
                    if (this.lt(this.values[i].depValue, extents[0][level + 1])) {
                        extents[0][level + 1] = this.values[i].depValue;
                    }
                    if (!this.gt(this.values[i].depValue, extents[1][level + 1])) continue;
                    extents[1][level + 1] = this.values[i].depValue;
                    continue;
                }
                this.values[i].depTable.getRatingExtents(extents, level + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (this.ratingSpecId == null) {
                throw new RatingException("Only top level ratings can be named.");
            }
            super.setName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getData(TableRatingContainer trc) {
        TableRating tableRating = this;
        synchronized (tableRating) {
            int i;
            super.getData(trc);
            if (this.values != null) {
                trc.values = new RatingValueContainer[this.values.length];
                for (i = 0; i < this.values.length; ++i) {
                    trc.values[i] = this.values[i].getData();
                }
            }
            if (this.extensionValues != null) {
                trc.extensionValues = new RatingValueContainer[this.extensionValues.length];
                for (i = 0; i < this.extensionValues.length; ++i) {
                    trc.extensionValues[i] = this.extensionValues[i].getData();
                }
            }
            trc.inRangeMethod = this.inRangeMethod.toString();
            trc.outRangeLowMethod = this.outRangeLowMethod.toString();
            trc.outRangeHighMethod = this.outRangeHighMethod.toString();
        }
    }

    protected static int getIndParamCount(RatingValue[] values) throws RatingException {
        if (values == null || values.length == 0) {
            throw new RatingException("No rating values!");
        }
        int indParamCount = values[0].hasDepValue() ? 1 : 1 + values[0].getDepValues().getIndParamCount();
        for (int i = 1; i < values.length; ++i) {
            int thisIndParamCount;
            int n = thisIndParamCount = values[i].hasDepValue() ? 1 : 1 + values[i].getDepValues().getIndParamCount();
            if (thisIndParamCount == indParamCount) continue;
            throw new RatingException("Rating values have inconsistent independent parameter counts.");
        }
        return indParamCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reverse() throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (this.getIndParamCount() > 1) {
                throw new RatingException("Cannot reverse a TableRating with more than one independent parameter");
            }
            TableRatingContainer trc = this.getData();
            if (trc.values != null) {
                for (RatingValueContainer rvc : trc.values) {
                    double temp = rvc.indValue;
                    rvc.indValue = rvc.depValue;
                    rvc.depValue = temp;
                }
            }
            String[] units = TextUtil.split((String)trc.unitsId, (String)";", (String)"L");
            trc.unitsId = TextUtil.join((String)";", (String[])new String[]{units[1], units[0]});
            if (trc.inRangeMethod.equals(RatingConst.RatingMethod.LIN_LOG.toString())) {
                trc.inRangeMethod = RatingConst.RatingMethod.LOG_LIN.toString();
            } else if (trc.inRangeMethod.equals(RatingConst.RatingMethod.LOG_LIN.toString())) {
                trc.inRangeMethod = RatingConst.RatingMethod.LIN_LOG.toString();
            }
            if (trc.outRangeLowMethod.equals(RatingConst.RatingMethod.LIN_LOG.toString())) {
                trc.outRangeLowMethod = RatingConst.RatingMethod.LOG_LIN.toString();
            } else if (trc.outRangeLowMethod.equals(RatingConst.RatingMethod.LOG_LIN.toString())) {
                trc.outRangeLowMethod = RatingConst.RatingMethod.LIN_LOG.toString();
            }
            if (trc.outRangeHighMethod.equals(RatingConst.RatingMethod.LIN_LOG.toString())) {
                trc.outRangeHighMethod = RatingConst.RatingMethod.LOG_LIN.toString();
            } else if (trc.outRangeHighMethod.equals(RatingConst.RatingMethod.LOG_LIN.toString())) {
                trc.outRangeHighMethod = RatingConst.RatingMethod.LIN_LOG.toString();
            }
            this.reversed = new TableRating(trc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(RatingValue[] values, RatingValue[] extensionValues, RatingConst.RatingMethod inRangeMethod, RatingConst.RatingMethod outRangeLowMethod, RatingConst.RatingMethod outRangeHighMethod, String officeId, String ratingSpecId, String ratingUnitsId, long effectiveDate, long transitionStartDate, long createDate, boolean active, String description) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            double[] ind_vals = null;
            if (values != null && values.length > 0) {
                TableRating.getIndParamCount(values);
                ind_vals = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ind_vals[i] = values[i].getIndValue();
                }
                this.props = new SequenceProperties(ind_vals);
                if (this.props.hasUndefined() || this.props.hasConstant() || this.props.hasIncreasing() && this.props.hasDecreasing()) {
                    throw new NotMonotonicRatingException("Specifed values do not monotonically increase or decrease, cannot use for rating.");
                }
            }
            RatingValue[] effectiveValues = null;
            if (extensionValues != null) {
                int j;
                int i;
                if (ratingSpecId == null) {
                    throw new RatingException("Only top-level table ratings can have extension values.");
                }
                if (TableRating.getIndParamCount(extensionValues) != TableRating.getIndParamCount(extensionValues)) {
                    throw new RatingException("Rating extension has different number of parameters than rating.");
                }
                ind_vals = new double[extensionValues.length];
                for (int i2 = 0; i2 < extensionValues.length; ++i2) {
                    ind_vals[i2] = extensionValues[i2].getIndValue();
                }
                SequenceProperties extensionProps = new SequenceProperties(ind_vals);
                if (extensionProps.hasUndefined() || extensionProps.hasConstant() || extensionProps.hasIncreasing() && extensionProps.hasDecreasing()) {
                    throw new NotMonotonicRatingException("Specifed extension values do not monotonically increase or decrease, cannot use for rating.");
                }
                if (extensionProps.hasIncreasing() != this.props.hasIncreasing()) {
                    throw new RatingException("Extension values are ordered in opposite direction of rating values.");
                }
                double first = values[0].getIndValue();
                double last = values[values.length - 1].getIndValue();
                Vector<RatingValue> effective = new Vector<RatingValue>();
                if (this.props.hasIncreasing()) {
                    for (i = 0; i < extensionValues.length && this.lt(extensionValues[i].getIndValue(), first); ++i) {
                        effective.add(extensionValues[i]);
                    }
                    for (j = 0; j < values.length; ++j) {
                        effective.add(values[j]);
                    }
                    while (i < extensionValues.length && this.le(extensionValues[i].getIndValue(), last)) {
                        ++i;
                    }
                    while (i < extensionValues.length) {
                        effective.add(extensionValues[i]);
                        ++i;
                    }
                } else {
                    for (i = 0; i < extensionValues.length && this.lt(extensionValues[i].getIndValue(), first); ++i) {
                        effective.add(extensionValues[i]);
                    }
                    for (j = 0; j < values.length; ++j) {
                        effective.add(values[j]);
                    }
                    while (i < extensionValues.length && this.ge(extensionValues[i].getIndValue(), last)) {
                        ++i;
                    }
                    while (i < extensionValues.length) {
                        effective.add(extensionValues[i]);
                        ++i;
                    }
                }
                effectiveValues = effective.toArray(new RatingValue[effective.size()]);
            }
            switch (inRangeMethod) {
                case NEAREST: {
                    throw new RatingException(inRangeMethod + " is not a valid in range method.");
                }
            }
            switch (outRangeLowMethod) {
                case PREVIOUS: {
                    throw new RatingException("Out of range low method " + outRangeLowMethod + " cannot be used in this context");
                }
                case LOWER: {
                    if (this.props == null || !this.props.hasIncreasing()) break;
                    throw new RatingException("Out of range low method " + outRangeLowMethod + " cannot be used in this context");
                }
                case HIGHER: {
                    if (this.props == null || !this.props.hasDecreasing()) break;
                    throw new RatingException("Out of range low method " + outRangeLowMethod + " cannot be used in this context");
                }
            }
            switch (outRangeHighMethod) {
                case NEXT: {
                    throw new RatingException("Out of range high method " + outRangeHighMethod + " cannot be used in this context");
                }
                case LOWER: {
                    if (!this.props.hasDecreasing()) break;
                    throw new RatingException("Out of range high method " + outRangeHighMethod + " cannot be used in this context");
                }
                case HIGHER: {
                    if (!this.props.hasIncreasing()) break;
                    throw new RatingException("Out of range high method " + outRangeHighMethod + " cannot be used in this context");
                }
            }
            if (this.observationTarget == null) {
                this.observationTarget = new Observable();
            }
            this.values = values;
            this.extensionValues = extensionValues;
            this.effectiveValues = effectiveValues == null ? values : effectiveValues;
            this.reversed = null;
            this.inRangeMethod = inRangeMethod;
            this.outRangeLowMethod = outRangeLowMethod;
            this.outRangeHighMethod = outRangeHighMethod;
            this.setOfficeId(officeId);
            this.setRatingSpecId(ratingSpecId);
            this.setRatingUnitsId(ratingUnitsId);
            this.setEffectiveDate(effectiveDate);
            this.setTransitionStartDate(transitionStartDate);
            this.setCreateDate(createDate);
            this.setActive(active);
            this.setDescription(description);
            if (this.values != null) {
                for (RatingValue value : this.values) {
                    value.addObserver(this);
                }
                if (this.extensionValues != null) {
                    for (RatingValue extensionValue : this.extensionValues) {
                        extensionValue.addObserver(this);
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public RatingValue[] getValues(Integer defaultInterval) {
        return this.getRatingValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatingValue[] getEffectiveValues() {
        TableRating tableRating = this;
        synchronized (tableRating) {
            return this.effectiveValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatingValue[] getRatingValues() {
        TableRating tableRating = this;
        synchronized (tableRating) {
            return this.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatingValue[] getExtensionValues() {
        TableRating tableRating = this;
        synchronized (tableRating) {
            return this.extensionValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRatingValues(RatingValue[] values) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (values == null) {
                throw new RatingException("Cannot set rating values to null");
            }
            RatingValueContainer[] rvcs = new RatingValueContainer[values.length];
            for (int i = 0; i < values.length; ++i) {
                rvcs[i] = values[i].getData();
            }
            TableRatingContainer trc = this.getData();
            trc.values = rvcs;
            this.setData(trc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtensionValues(RatingValue[] values) throws RatingException {
        TableRating tableRating = this;
        synchronized (tableRating) {
            if (this.getIndParamCount() > 1) {
                throw new RatingException("Cannot set extension values for rating with more than one independent value");
            }
            RatingValueContainer[] rvcs = null;
            if (values != null) {
                rvcs = new RatingValueContainer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    rvcs[i] = values[i].getData();
                }
            }
            TableRatingContainer trc = this.getData();
            trc.extensionValues = rvcs;
            this.setData(trc);
        }
    }

    @Override
    public TableRating getInstance(AbstractRatingContainer ratingContainer) throws RatingException {
        if (!(ratingContainer instanceof TableRatingContainer)) {
            throw new UnsupportedOperationException("Table Ratings only support Table Rating Containers.");
        }
        return new TableRating((TableRatingContainer)ratingContainer);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((TableRating)obj).getData());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }
}

