/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.IRating;
import hec.data.Parameter;
import hec.data.RatingException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingUtil;
import hec.data.cwmsRating.io.IndependentValuesContainer;
import hec.heclib.util.HecTime;
import hec.io.Conversion;
import hec.io.TimeSeriesContainer;
import hec.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeSeriesRater {
    protected IRating ratingObj;
    protected boolean allowUnsafe = true;
    protected boolean warnUnsafe = true;

    protected TimeSeriesRater() {
    }

    public TimeSeriesRater(IRating ratingObj) {
        this.ratingObj = ratingObj;
    }

    public TimeSeriesRater(IRating ratingObj, boolean allowUnsafe, boolean warnUnsafe) {
        this.ratingObj = ratingObj;
        this.allowUnsafe = allowUnsafe;
        this.warnUnsafe = warnUnsafe;
    }

    public TimeSeriesContainer rate(TimeSeriesContainer[] tscs) throws RatingException {
        TimeSeriesRater timeSeriesRater = this;
        synchronized (timeSeriesRater) {
            String[] dataUnits = this.ratingObj.getDataUnits();
            String[] newDataUnits = new String[dataUnits.length];
            String[] ratingUnits = this.ratingObj.getRatingUnits();
            String[] params = this.ratingObj.getRatingParameters();
            int ratedInterval = tscs[0].interval;
            try {
                String msg;
                if (tscs.length != this.ratingObj.getIndParamCount()) {
                    throw new RatingException(String.format("%d data sets specified, %d required.", tscs.length, this.ratingObj.getIndParamCount()));
                }
                for (int i = 1; i < tscs.length; ++i) {
                    if (tscs[i].interval == tscs[0].interval) continue;
                    String msg2 = "TimeSeriesContainers have inconsistent intervals.";
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg2);
                    }
                    if (this.warnUnsafe) {
                        AbstractRating.logger.warning(msg2 + "  Rated values will be irregular interval.");
                    }
                    ratedInterval = 0;
                    break;
                }
                String tzid = tscs[0].timeZoneID;
                for (int i = 1; i < tscs.length; ++i) {
                    if (TextUtil.equals((CharSequence)tscs[i].timeZoneID, (CharSequence)tzid)) continue;
                    msg = "TimeSeriesContainers have inconsistent time zones.";
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        AbstractRating.logger.warning(msg + "  Value times will be treated as UTC.");
                    }
                    tzid = null;
                    break;
                }
                TimeZone tz = null;
                if (tzid != null && !(tz = TimeZone.getTimeZone(tzid)).getID().equals(tzid)) {
                    msg = String.format("TimeSeriesContainers have invalid time zone \"%s\".", tzid);
                    if (!this.allowUnsafe) {
                        throw new RatingException(msg);
                    }
                    if (this.warnUnsafe) {
                        AbstractRating.logger.warning(msg + "  Value times will be treated as UTC.");
                    }
                    tz = null;
                }
                for (int i = 0; i < tscs.length; ++i) {
                    Parameter tscParam;
                    block29: {
                        tscParam = null;
                        try {
                            tscParam = new Parameter(tscs[i].parameter);
                        }
                        catch (Throwable t) {
                            if (!this.allowUnsafe) {
                                throw new RatingException(t);
                            }
                            if (!this.warnUnsafe) break block29;
                            AbstractRating.logger.warning(t.getMessage());
                        }
                    }
                    if (tscParam != null && !tscParam.getParameter().equals(params[i])) {
                        String msg3 = String.format("Parameter \"%s\" does not match rating parameter \"%s\".", tscParam.getParameter(), params[i]);
                        if (!this.allowUnsafe) {
                            throw new RatingException(msg3);
                        }
                        if (this.warnUnsafe) {
                            AbstractRating.logger.warning(msg3);
                        }
                    }
                    newDataUnits[i] = tscs[i].units;
                }
                newDataUnits[tscs.length] = dataUnits[tscs.length];
                this.ratingObj.setDataUnits(newDataUnits);
                IndependentValuesContainer ivc = RatingUtil.tscsToIvc(tscs, ratingUnits, tz, this.allowUnsafe, this.warnUnsafe);
                double[] depVals = this.ratingObj.rate(ivc.valTimes, ivc.indVals);
                this.ratingObj.setDataUnits(dataUnits);
                TimeSeriesContainer ratedTsc = new TimeSeriesContainer();
                tscs[0].clone(ratedTsc);
                ratedTsc.interval = ratedInterval;
                if (ivc.valTimes.length == tscs[0].times.length) {
                    ratedTsc.times = Arrays.copyOf(tscs[0].times, tscs[0].times.length);
                } else {
                    ratedTsc.times = new int[ivc.valTimes.length];
                    if (tz == null) {
                        for (int i = 0; i < ivc.valTimes.length; ++i) {
                            ratedTsc.times[i] = Conversion.toMinutes((long)ivc.valTimes[i]);
                        }
                    } else {
                        Calendar cal = Calendar.getInstance();
                        cal.setTimeZone(tz);
                        SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy, HH:mm");
                        HecTime t = new HecTime();
                        for (int i = 0; i < ivc.valTimes.length; ++i) {
                            cal.setTimeInMillis(ivc.valTimes[i]);
                            t.set(sdf.format(cal.getTime()));
                            ratedTsc.times[i] = t.value();
                        }
                    }
                }
                ratedTsc.values = depVals;
                ratedTsc.numberValues = ratedTsc.times.length;
                String paramStr = params[params.length - 1];
                ratedTsc.fullName = tscs[0].subParameter == null ? TextUtil.replaceAll((String)tscs[0].fullName, (String)tscs[0].parameter, (String)paramStr, (String)"IL") : TextUtil.replaceAll((String)tscs[0].fullName, (String)String.format("%s-%s", tscs[0].parameter, tscs[0].subParameter), (String)paramStr, (String)"IL");
                String[] parts = TextUtil.split((String)paramStr, (String)"-", (String)"L", (int)2);
                ratedTsc.parameter = parts[0];
                ratedTsc.subParameter = parts.length > 1 ? parts[1] : null;
                ratedTsc.units = dataUnits[tscs.length];
                return ratedTsc;
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeriesContainer reverseRate(TimeSeriesContainer tsc) throws RatingException {
        TimeSeriesRater timeSeriesRater = this;
        synchronized (timeSeriesRater) {
            TimeZone tz = null;
            if (tsc.timeZoneID != null && !(tz = TimeZone.getTimeZone(tsc.timeZoneID)).getID().equals(tsc.timeZoneID)) {
                String msg = String.format("TimeSeriesContainers have invalid time zone \"%s\".", tsc.timeZoneID);
                if (!this.allowUnsafe) {
                    throw new RatingException(msg);
                }
                if (this.warnUnsafe) {
                    AbstractRating.logger.warning(msg + "  Value times will be treated as UTC.");
                }
                tz = null;
            }
            TimeSeriesContainer[] tscs = new TimeSeriesContainer[]{tsc};
            String[] units = new String[]{tsc.units};
            IndependentValuesContainer ivc = RatingUtil.tscsToIvc(tscs, units, tz, this.allowUnsafe, this.warnUnsafe);
            TimeSeriesContainer ratedTsc = new TimeSeriesContainer();
            tsc.clone(ratedTsc);
            double[] depVals = new double[ivc.indVals.length];
            for (int i = 0; i < depVals.length; ++i) {
                depVals[i] = ivc.indVals[i][0];
            }
            ratedTsc.values = this.ratingObj.reverseRate(ivc.valTimes, depVals);
            String paramStr = TextUtil.split((String)TextUtil.split((String)this.ratingObj.getName(), (String)".", (String)"L")[1], (String)";", (String)"L")[1];
            ratedTsc.fullName = tsc.subParameter == null ? TextUtil.replaceAll((String)tsc.fullName, (String)tsc.parameter, (String)paramStr, (String)"IL") : TextUtil.replaceAll((String)tsc.fullName, (String)String.format("%s-%s", tsc.parameter, tsc.subParameter), (String)paramStr, (String)"IL");
            String[] parts = TextUtil.split((String)paramStr, (String)"-", (String)"L", (int)2);
            ratedTsc.parameter = parts[0];
            ratedTsc.subParameter = parts.length > 1 ? parts[1] : null;
            String[] dataUnits = this.ratingObj.getDataUnits();
            ratedTsc.units = dataUnits == null ? this.ratingObj.getRatingUnits()[0] : dataUnits[0];
            return ratedTsc;
        }
    }
}

