/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.RatingValue;
import hec.data.cwmsRating.SourceRating;
import hec.data.cwmsRating.VirtualRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingXmlCompatUtil;
import hec.data.cwmsRating.io.SourceRatingContainer;
import hec.data.cwmsRating.io.TransitionalRatingContainer;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.computation.Condition;
import hec.hecmath.computation.MathExpression;
import hec.hecmath.computation.VariableSet;
import hec.lang.Observable;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransitionalRating
extends AbstractRating {
    protected Condition[] conditions = null;
    protected MathExpression[] evaluations = null;
    protected SourceRating[] sourceRatings = null;

    public TransitionalRating() {
        this.init();
    }

    public TransitionalRating(TransitionalRatingContainer trrc) throws RatingException {
        this.init();
        this.setData(trrc);
    }

    @Deprecated
    public TransitionalRating(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        TransitionalRatingContainer container = service.createTransitionalRatingContainer(xmlText);
        this.setData(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            if (this.observationTarget == null) {
                this.observationTarget = new Observable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Condition[] getConditions() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            return this.conditions == null ? null : Arrays.copyOf(this.conditions, this.conditions.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConditionStrings() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            String[] conditionStrings = null;
            if (this.conditions != null) {
                conditionStrings = new String[this.conditions.length];
                for (int i = 0; i < this.conditions.length; ++i) {
                    conditionStrings[i] = this.conditions[i].toString().replaceAll("\\$", "");
                }
            }
            return conditionStrings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConditions(Condition[] conditions) {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            this.conditions = conditions == null ? null : Arrays.copyOf(conditions, conditions.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConditions(String[] conditionStrings) throws ComputationException {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            Condition[] conditions = null;
            if (conditionStrings != null) {
                conditions = new Condition[conditionStrings.length];
                for (int i = 0; i < conditionStrings.length; ++i) {
                    conditions[i] = new Condition(TextUtil.replaceAll((String)conditionStrings[i], (String)"(^|\\W)(i|r)([1-9])", (String)"$1\\$$2$3", (String)"i"));
                }
            }
            this.conditions = conditions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathExpression[] getEvaluations() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            return this.evaluations == null ? null : Arrays.copyOf(this.evaluations, this.evaluations.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEvaluationStrings() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            String[] evaluationStrings = null;
            if (this.evaluations != null) {
                evaluationStrings = new String[this.evaluations.length];
                for (int i = 0; i < this.evaluations.length; ++i) {
                    evaluationStrings[i] = this.evaluations[i].toString().replaceAll("\\$", "");
                }
            }
            return evaluationStrings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvaluations(MathExpression[] evaluations) {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            this.evaluations = evaluations == null ? null : Arrays.copyOf(evaluations, evaluations.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvaluations(String[] evaluationStrings) throws ComputationException {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            MathExpression[] evaluations = null;
            if (evaluationStrings != null) {
                evaluations = new MathExpression[evaluationStrings.length];
                for (int i = 0; i < evaluationStrings.length; ++i) {
                    evaluations[i] = new MathExpression(TextUtil.replaceAll((String)evaluationStrings[i], (String)"(^|\\W)(i|r)([1-9])", (String)"$1\\$$2$3", (String)"i"));
                }
            }
            this.evaluations = evaluations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceRating[] getSourceRatings() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            return this.sourceRatings == null ? null : Arrays.copyOf(this.sourceRatings, this.sourceRatings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRatings(SourceRating[] sources) throws RatingException {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            this.findCycles(sources, new ArrayList<String>());
            this.sourceRatings = Arrays.copyOf(sources, sources.length);
            for (SourceRating sr : sources) {
                sr.addObserver(this);
            }
        }
    }

    public void findCycles() throws RatingException {
        this.findCycles(new ArrayList<String>());
    }

    protected void findCycles(List<String> specIds) throws RatingException {
        this.findCycles(this.sourceRatings, specIds);
    }

    protected void findCycles(SourceRating[] sources, List<String> specIds) throws RatingException {
        String specId = this.getOfficeId() + "/" + this.getRatingSpecId();
        if (specIds.contains(specId)) {
            StringBuilder sb = new StringBuilder("Cycle detected in source ratings. Cycle path is:");
            for (String pathSpecId : specIds) {
                sb.append(pathSpecId.equals(specId) ? "\n -->" : "\n    ").append(pathSpecId);
            }
            sb.append("\n -->").append(specId);
            throw new RatingException(sb.toString());
        }
        specIds.add(specId);
        if (sources != null) {
            for (SourceRating sr : sources) {
                AbstractRating[] ratings;
                RatingSet rs;
                if (sr == null || (rs = sr.getRatingSet()) == null || (ratings = rs.getRatings()) == null) continue;
                for (AbstractRating ar : ratings) {
                    if (ar instanceof VirtualRating) {
                        ((VirtualRating)ar).findCycles(new ArrayList<String>(specIds));
                    }
                    if (!(ar instanceof TransitionalRating)) continue;
                    ((TransitionalRating)ar).findCycles(new ArrayList<String>(specIds));
                }
            }
        }
    }

    @Override
    @Deprecated
    public String toXmlString(CharSequence indent, int indentLevel) throws RatingException {
        return RatingXmlCompatUtil.getInstance().toXml(this, indent, indentLevel);
    }

    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        throw new RatingException("getRatingExtents is not supported for transitional ratings");
    }

    public double rate(double indVal) throws RatingException {
        return this.rate(this.defaultValueTime, indVal);
    }

    public double rateOne(double ... indVals) throws RatingException {
        long[] valTimes = new long[]{this.defaultValueTime};
        double[][] _indVals = new double[indVals.length][];
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i] = new double[]{indVals[i]};
        }
        return this.rate(valTimes, (double[][])_indVals)[0];
    }

    public double rateOne2(double[] indVals) throws RatingException {
        long[] valTimes = new long[]{this.defaultValueTime};
        double[][] _indVals = new double[indVals.length][];
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i] = new double[]{indVals[i]};
        }
        return this.rate(valTimes, (double[][])_indVals)[0];
    }

    public double[] rate(double[] indVals) throws RatingException {
        return this.rate(this.defaultValueTime, indVals);
    }

    public double[] rate(double[][] indVals) throws RatingException {
        return this.rate(this.defaultValueTime, indVals);
    }

    public double rate(long valTime, double indVal) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[][] indVals = new double[][]{{indVal}};
        return this.rate(valTimes, (double[][])indVals)[0];
    }

    public double rateOne(long valTime, double ... indVals) throws RatingException {
        return this.rateOne2(valTime, indVals);
    }

    public double rateOne2(long valTime, double[] indVals) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[][] _indVals = new double[indVals.length][];
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i] = new double[]{indVals[i]};
        }
        return this.rate(valTimes, (double[][])_indVals)[0];
    }

    public double[] rate(long valTime, double[] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    public double[] rate(long[] valTimes, double[] indVals) throws RatingException {
        return this.rate(valTimes, (double[][])new double[][]{indVals});
    }

    public double[] rate(long valTime, double[][] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] rate(long[] valTimes, double[][] indVals) throws RatingException {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            if (indVals.length != this.getIndParamCount()) {
                throw new RatingException(String.format("Expected %d value sets, got %d", this.getIndParamCount(), indVals.length));
            }
            if (valTimes == null) {
                throw new RatingException("No value times supplied");
            }
            for (int i = 0; i < indVals.length; ++i) {
                if (indVals[i].length == valTimes.length) continue;
                throw new RatingException("Inconsistent times and values arrays");
            }
            double[] depVals = new double[valTimes.length];
            int indParamCount = this.getIndParamCount();
            double[] _indVals = null;
            int inputNumber = -1;
            int ratingNumber = -1;
            int conditionNumber = -1;
            try {
                for (int i = 0; i < valTimes.length; ++i) {
                    int ip;
                    int evaluationNumber = -1;
                    for (conditionNumber = 0; conditionNumber < this.conditions.length; ++conditionNumber) {
                        VariableSet cvs = this.conditions[conditionNumber].getVariables();
                        for (String cvname : cvs.getVariableNames()) {
                            switch (cvname.charAt(1)) {
                                case 'I': {
                                    inputNumber = Integer.parseInt(cvname.substring(2)) - 1;
                                    if (inputNumber >= 0 && inputNumber < indParamCount) break;
                                    throw new RatingException(String.format("Variable \"%s\" specifies invalid independent parameter number", cvname));
                                }
                                case 'R': {
                                    inputNumber = -1;
                                    ratingNumber = Integer.parseInt(cvname.substring(2)) - 1;
                                    if (this.sourceRatings != null && ratingNumber >= 0 && ratingNumber < this.sourceRatings.length) break;
                                    throw new RatingException(String.format("Variable \"%s\" specifies invalid rating number", cvname));
                                }
                                default: {
                                    throw new RatingException("Unexpected variable name in condition: " + cvname);
                                }
                            }
                            if (inputNumber == -1) {
                                if (_indVals == null) {
                                    _indVals = new double[indParamCount];
                                }
                                for (ip = 0; ip < indParamCount; ++ip) {
                                    _indVals[ip] = indVals[ip][i];
                                    cvs.setValue(cvname, this.sourceRatings[ratingNumber].rateOne2(valTimes[i], _indVals));
                                }
                                continue;
                            }
                            cvs.setValue(cvname, indVals[inputNumber][i]);
                        }
                        if (this.conditions[conditionNumber].test()) break;
                    }
                    evaluationNumber = conditionNumber;
                    VariableSet evs = this.evaluations[evaluationNumber].getVariables();
                    for (String evname : evs.getVariableNames()) {
                        switch (evname.charAt(1)) {
                            case 'I': {
                                inputNumber = Integer.parseInt(evname.substring(2)) - 1;
                                if (inputNumber >= 0 && inputNumber < indParamCount) break;
                                throw new RatingException(String.format("Variable \"%s\" specifies invalid independent parameter number", evname));
                            }
                            case 'R': {
                                inputNumber = -1;
                                ratingNumber = Integer.parseInt(evname.substring(2)) - 1;
                                if (this.sourceRatings != null && ratingNumber >= 0 && ratingNumber < this.sourceRatings.length) break;
                                throw new RatingException(String.format("Variable \"%s\" specifies invalid rating number", evname));
                            }
                            default: {
                                throw new RatingException("Unexpected variable name in condition: " + evname);
                            }
                        }
                        if (inputNumber == -1) {
                            if (_indVals == null) {
                                _indVals = new double[indParamCount];
                            }
                            for (ip = 0; ip < indParamCount; ++ip) {
                                _indVals[ip] = indVals[ip][i];
                                evs.setValue(evname, this.sourceRatings[ratingNumber].rateOne2(valTimes[i], _indVals));
                            }
                            continue;
                        }
                        evs.setValue(evname, indVals[inputNumber][i]);
                    }
                    depVals[i] = this.evaluations[evaluationNumber].evaluate();
                }
            }
            catch (Throwable t) {
                if (t instanceof RatingException) {
                    throw (RatingException)t;
                }
                throw new RatingException(t);
            }
            return depVals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransitionalRatingContainer getData() {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            int i;
            TransitionalRatingContainer trrc = new TransitionalRatingContainer();
            super.getData(trrc);
            if (this.conditions != null) {
                trrc.conditions = new String[this.conditions.length];
                for (i = 0; i < this.conditions.length; ++i) {
                    trrc.conditions[i] = this.conditions[i].toString().replaceAll("\\$((I|R)\\d+)", "$1");
                }
            }
            if (this.evaluations != null) {
                trrc.evaluations = new String[this.evaluations.length];
                for (i = 0; i < this.evaluations.length; ++i) {
                    trrc.evaluations[i] = this.evaluations[i].toString().replaceAll("\\$((I|R)\\d+)", "$1");
                }
            }
            if (this.sourceRatings != null) {
                trrc.sourceRatings = new SourceRatingContainer[this.sourceRatings.length];
                trrc.sourceRatingIds = new String[this.sourceRatings.length];
                for (i = 0; i < this.sourceRatings.length; ++i) {
                    trrc.sourceRatings[i] = this.sourceRatings[i].getData();
                    trrc.sourceRatingIds[i] = trrc.sourceRatings[i].rsc.ratingSpecContainer.specId;
                }
            }
            return trrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(AbstractRatingContainer rc) throws RatingException {
        TransitionalRating transitionalRating = this;
        synchronized (transitionalRating) {
            int i;
            if (!(rc instanceof TransitionalRatingContainer)) {
                throw new RatingException("Expected TransitionalRatingContainer, got " + rc.getClass().getName());
            }
            TransitionalRatingContainer trrc = (TransitionalRatingContainer)rc;
            if (trrc.conditions != null && trrc.conditions.length > 0 && trrc.evaluations != null && trrc.evaluations.length > 0 && trrc.evaluations.length - trrc.conditions.length != 1) {
                throw new RatingException("Transitional rating container has inconsistent number of conditions and evaluations");
            }
            super._setData(trrc);
            this.conditions = null;
            this.evaluations = null;
            this.sourceRatings = null;
            if (trrc.conditions != null && trrc.conditions.length > 0) {
                this.conditions = new Condition[trrc.conditions.length];
                try {
                    for (i = 0; i < trrc.conditions.length; ++i) {
                        this.conditions[i] = new Condition(trrc.conditions[i].toUpperCase().replaceAll("((I|R)\\d+)", "\\$$1"));
                    }
                }
                catch (ComputationException e) {
                    throw new RatingException((Throwable)e);
                }
            }
            if (trrc.evaluations != null && trrc.evaluations.length > 0) {
                this.evaluations = new MathExpression[trrc.evaluations.length];
                try {
                    for (i = 0; i < trrc.evaluations.length; ++i) {
                        this.evaluations[i] = new MathExpression(trrc.evaluations[i].toUpperCase().replaceAll("((I|R)\\d+)", "\\$$1"));
                    }
                }
                catch (ComputationException e) {
                    throw new RatingException((Throwable)e);
                }
            }
            if (trrc.sourceRatings != null && trrc.sourceRatingIds.length > 0) {
                this.sourceRatings = new SourceRating[trrc.sourceRatings.length];
                for (i = 0; i < trrc.sourceRatings.length; ++i) {
                    this.sourceRatings[i] = new SourceRating(trrc.sourceRatings[i]);
                }
            }
            this.findCycles();
        }
    }

    @Override
    public double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        throw new RatingException("Cannot reverse through a transitional rating");
    }

    @Override
    public RatingValue[] getValues(Integer defaultInterval) {
        throw new UnsupportedOperationException("getValues is not supported for transitional ratings");
    }

    @Override
    public AbstractRating getInstance(AbstractRatingContainer ratingContainer) throws RatingException {
        if (!(ratingContainer instanceof TransitionalRatingContainer)) {
            throw new UnsupportedOperationException("Transitional Ratings only support Transitional Rating Containers.");
        }
        return new TransitionalRating((TransitionalRatingContainer)ratingContainer);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((TransitionalRating)obj).getData());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }
}

