/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.DataSetException;
import hec.data.RatingException;
import hec.data.RoundingException;
import hec.data.UsgsRounder;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.AbstractRatingSet;
import hec.data.cwmsRating.RatingConst;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.RatingSetFactory;
import hec.data.cwmsRating.RatingSpec;
import hec.data.cwmsRating.RatingValue;
import hec.data.cwmsRating.TableRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingSetContainer;
import hec.data.cwmsRating.io.RatingSpecContainer;
import hec.data.cwmsRating.io.RatingValueContainer;
import hec.data.cwmsRating.io.RatingXmlCompatUtil;
import hec.data.cwmsRating.io.TableRatingContainer;
import hec.data.cwmsRating.io.UsgsStreamTableRatingContainer;
import hec.data.location.LocationTemplate;
import hec.data.rating.IRatingSpecification;
import hec.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class UsgsStreamTableRating
extends TableRating {
    protected RatingSet shifts = null;
    protected TableRating offsets = null;
    protected UsgsRounder shiftRounder = null;

    public UsgsStreamTableRating(RatingValue[] values, RatingValue[] extensionValues, RatingConst.RatingMethod in_range_method, RatingConst.RatingMethod out_range_low_method, RatingConst.RatingMethod out_range_high_method, String officeId, String ratingSpecId, String unitsId, long effectiveDate, long createDate, RatingSet shifts, TableRating offsets, boolean active, String description) throws RatingException {
        super(values, extensionValues, in_range_method, out_range_low_method, out_range_high_method, officeId, ratingSpecId, unitsId, effectiveDate, createDate, active, description);
        if (this.getIndParamCount() > 1) {
            throw new RatingException("UsgsStreamTableRating objects allow only one indendent parameter.");
        }
        this.setShifts(shifts);
        this.setOffsets(offsets);
    }

    public UsgsStreamTableRating(UsgsStreamTableRatingContainer urc) throws RatingException {
        int i;
        RatingValue[] values = urc.values == null ? null : new RatingValue[urc.values.length];
        RatingValue[] extensionValues = null;
        if (values != null) {
            for (i = 0; i < values.length; ++i) {
                values[i] = new RatingValue(urc.values[i]);
            }
        }
        if (urc.extensionValues != null) {
            extensionValues = new RatingValue[urc.extensionValues.length];
            for (i = 0; i < extensionValues.length; ++i) {
                extensionValues[i] = new RatingValue(urc.extensionValues[i]);
            }
        }
        super.init(values, extensionValues, RatingConst.RatingMethod.fromString(urc.inRangeMethod == null ? "LOGARITHMIC" : urc.inRangeMethod), RatingConst.RatingMethod.fromString(urc.outRangeLowMethod == null ? "ERROR" : urc.outRangeLowMethod), RatingConst.RatingMethod.fromString(urc.outRangeHighMethod == null ? "ERROR" : urc.outRangeHighMethod), urc.officeId, urc.ratingSpecId, urc.unitsId, urc.effectiveDateMillis, urc.transitionStartDateMillis, urc.createDateMillis, urc.active, urc.description);
        if (urc.offsets != null) {
            this.offsets = new TableRating(urc.offsets);
            if (urc.unitsId != null && urc.unitsId.length() > 0) {
                String heightUnit = TextUtil.split((String)urc.unitsId, (String)";")[0];
                this.offsets.ratingUnitsId = String.format("%s;%s", heightUnit, heightUnit);
            }
            this.offsets.addObserver(this);
        }
        if (urc.shifts != null) {
            this.setShifts(RatingSetFactory.ratingSet(urc.shifts));
            if (urc.unitsId != null && urc.unitsId.length() > 0) {
                String heightUnit = TextUtil.split((String)urc.unitsId, (String)";")[0];
                for (AbstractRating shift : this.getShifts().getRatings()) {
                    shift.ratingUnitsId = String.format("%s;%s", heightUnit, heightUnit);
                }
            }
            this.shifts.addObserver(this);
        }
    }

    @Deprecated
    public UsgsStreamTableRating(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        UsgsStreamTableRatingContainer container = service.createUsgsStreamTableRatingContainer(xmlText);
        this.setData(container);
    }

    @Override
    public double rate(double indVal) throws RatingException {
        return this.rate(this.defaultValueTime, indVal);
    }

    @Override
    public double rateOne(double ... indVals) throws RatingException {
        if (indVals.length != 1) {
            throw new RatingException("UsgsStreamTableRating objects allow only one indendent parameter.");
        }
        return this.rate(indVals)[0];
    }

    @Override
    public double[] rate(double[] indVals) throws RatingException {
        return this.rate(this.defaultValueTime, indVals);
    }

    @Override
    public double[] rate(double[][] indVals) throws RatingException {
        return this.rate(this.defaultValueTime, indVals);
    }

    @Override
    protected double rate(double[] indVals, int offset) throws RatingException {
        if (indVals.length != 1) {
            throw new RatingException("UsgsStreamTableRating objects allow only one indendent parameter.");
        }
        return this.rateOne(this.defaultValueTime, indVals);
    }

    @Override
    public double rate(long valTime, double indVal) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[] indVals = new double[]{indVal};
        return this.rate(valTimes, indVals)[0];
    }

    @Override
    public double rateOne(long valTime, double ... indVals) throws RatingException {
        if (indVals.length != 1) {
            throw new RatingException("UsgsStreamTableRating objects allow only one indendent parameter.");
        }
        return this.rate(valTime, indVals[0]);
    }

    @Override
    public double[] rate(long valTime, double[] indVals) throws RatingException {
        if (this.shifts != null && this.shifts.getRatingCount() > 1 && valTime == Long.MIN_VALUE) {
            throw new RatingException("Value times must be specified or default time must be set when shifts are present.");
        }
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] rate(long[] valTimes, double[] indVals) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            if (valTimes.length != indVals.length) {
                throw new RatingException("Different numbers of values and times.");
            }
            double[] Y = new double[indVals.length];
            block28: for (int i = 0; i < indVals.length; ++i) {
                RatingConst.RatingMethod extrap_method;
                int hi;
                int lo;
                boolean out_range_high;
                boolean out_range_low;
                double ind_val;
                block46: {
                    block45: {
                        if (valTimes[i] == Long.MIN_VALUE && this.shifts != null && this.shifts.getRatingCount() > 0) {
                            throw new RatingException("Value time is undefined in the presence of dated shifts - cannot rate.");
                        }
                        double shift = this.getShiftFromUnshifted(valTimes[i], indVals[i]);
                        ind_val = indVals[i] + shift;
                        out_range_low = false;
                        out_range_high = false;
                        lo = 0;
                        hi = this.effectiveValues.length - 1;
                        extrap_method = null;
                        if (this.lt(ind_val, this.effectiveValues[lo].getIndValue())) {
                            out_range_low = true;
                        } else if (this.gt(ind_val, this.effectiveValues[hi].getIndValue())) {
                            out_range_high = true;
                        } else {
                            while (hi - lo > 1) {
                                int mid = (lo + hi) / 2;
                                double mid_ind_val = this.effectiveValues[mid].getIndValue();
                                if (this.lt(ind_val, mid_ind_val)) {
                                    hi = mid;
                                    continue;
                                }
                                lo = mid;
                            }
                        }
                        if (!out_range_low) break block45;
                        switch (this.outRangeLowMethod) {
                            case NULL: {
                                Y[i] = -3.4028234663852886E38;
                                continue block28;
                            }
                            case ERROR: {
                                throw new RatingException("Value is out of range low.");
                            }
                            case LINEAR: 
                            case LOGARITHMIC: 
                            case LIN_LOG: 
                            case LOG_LIN: {
                                extrap_method = this.outRangeLowMethod;
                                break block46;
                            }
                            case PREVIOUS: {
                                throw new RatingException("No previous value in table.");
                            }
                            case NEXT: 
                            case NEAREST: 
                            case HIGHER: 
                            case CLOSEST: {
                                Y[i] = this.effectiveValues[0].getDepValue();
                                continue block28;
                            }
                            case LOWER: {
                                throw new RatingException("No lower value in table.");
                            }
                            default: {
                                throw new RatingException("Unexpected behavior specified : " + this.outRangeLowMethod + " : " + this.outRangeLowMethod.description());
                            }
                        }
                    }
                    if (out_range_high) {
                        switch (this.outRangeHighMethod) {
                            case NULL: {
                                Y[i] = -3.4028234663852886E38;
                                continue block28;
                            }
                            case ERROR: {
                                throw new RatingException("Value is out of range high.");
                            }
                            case LINEAR: 
                            case LOGARITHMIC: 
                            case LIN_LOG: 
                            case LOG_LIN: {
                                extrap_method = this.outRangeHighMethod;
                                break;
                            }
                            case NEXT: {
                                throw new RatingException("No next value in table.");
                            }
                            case PREVIOUS: 
                            case NEAREST: 
                            case CLOSEST: 
                            case LOWER: {
                                Y[i] = this.effectiveValues[this.effectiveValues.length - 1].getDepValue();
                                continue block28;
                            }
                            case HIGHER: {
                                throw new RatingException("No higher value in table.");
                            }
                            default: {
                                throw new RatingException("Unexpected behavior specified : " + this.outRangeHighMethod + " : " + this.outRangeHighMethod.description());
                            }
                        }
                    }
                }
                double lo_ind_val = this.effectiveValues[lo].getIndValue();
                double hi_ind_val = this.effectiveValues[hi].getIndValue();
                RatingConst.RatingMethod method = out_range_low || out_range_high ? extrap_method : this.inRangeMethod;
                switch (method) {
                    case NULL: {
                        Y[i] = -3.4028234663852886E38;
                        continue block28;
                    }
                    case ERROR: {
                        throw new RatingException("No such value in table.");
                    }
                    default: {
                        double lo_dep_val = this.effectiveValues[lo].getDepValue();
                        double hi_dep_val = this.effectiveValues[hi].getDepValue();
                        if (this.eq(ind_val, lo_ind_val)) {
                            Y[i] = lo_dep_val;
                            continue block28;
                        }
                        if (this.eq(ind_val, hi_ind_val)) {
                            Y[i] = hi_dep_val;
                            continue block28;
                        }
                        switch (method) {
                            case PREVIOUS: 
                            case LOWER: {
                                Y[i] = lo_dep_val;
                                continue block28;
                            }
                            case NEXT: 
                            case HIGHER: {
                                Y[i] = hi_dep_val;
                                continue block28;
                            }
                            case CLOSEST: {
                                Y[i] = this.lt(Math.abs(ind_val - lo_ind_val), Math.abs(hi_ind_val - ind_val)) ? lo_dep_val : hi_dep_val;
                                continue block28;
                            }
                        }
                        boolean ind_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LIN_LOG;
                        boolean dep_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LOG_LIN;
                        double x = ind_val;
                        double x1 = lo_ind_val;
                        double x2 = hi_ind_val;
                        double y1 = lo_dep_val;
                        double y2 = hi_dep_val;
                        if (ind_log) {
                            double offset = this.getOffset(Math.min(x, x1));
                            x = Math.log10(x - offset);
                            x1 = Math.log10(x1 - offset);
                            x2 = Math.log10(x2 - offset);
                            if (Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(x1) || Double.isInfinite(x1) || Double.isNaN(x2) || Double.isInfinite(x2)) {
                                x = ind_val;
                                x1 = lo_ind_val;
                                x2 = hi_ind_val;
                                dep_log = false;
                            }
                        }
                        if (dep_log) {
                            y1 = Math.log10(y1);
                            y2 = Math.log10(y2);
                            if (Double.isNaN(y1) || Double.isInfinite(y1) || Double.isNaN(y2) || Double.isInfinite(y2)) {
                                x = ind_val;
                                x1 = lo_ind_val;
                                x2 = hi_ind_val;
                                y1 = lo_dep_val;
                                y2 = hi_dep_val;
                                dep_log = false;
                            }
                        }
                        double y = y1 + (x - x1) / (x2 - x1) * (y2 - y1);
                        if (dep_log) {
                            y = Math.pow(10.0, y);
                        }
                        Y[i] = y;
                    }
                }
            }
            return Y;
        }
    }

    @Override
    public double[] rate(long valTime, double[][] indVals) throws RatingException {
        if (this.shifts != null && this.shifts.getRatingCount() > 1 && valTime == Long.MIN_VALUE) {
            throw new RatingException("Value times must be specified or default time must be set when shifts are present.");
        }
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    @Override
    public double[] rate(long[] valTimes, double[][] indVals) throws RatingException {
        double[] vals = new double[indVals.length];
        for (int i = 1; i < indVals.length; ++i) {
            if (indVals[i].length != 1) {
                throw new RatingException("UsgsStreamTableRating objects allow only one indendent parameter.");
            }
            vals[i] = indVals[i][0];
        }
        return this.rate(valTimes, vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double reverseRate(long valTime, double depVal) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            RatingConst.RatingMethod method;
            RatingConst.RatingMethod extrap_method;
            double shifted;
            int hi;
            int lo;
            boolean out_range_high;
            boolean out_range_low;
            double flow;
            block58: {
                block57: {
                    flow = depVal;
                    out_range_low = false;
                    out_range_high = false;
                    lo = 0;
                    hi = this.values.length - 1;
                    shifted = -3.4028234663852886E38;
                    extrap_method = null;
                    if (this.props.hasIncreasing()) {
                        if (this.lt(flow, this.effectiveValues[lo].getDepValue())) {
                            out_range_low = true;
                        } else if (this.gt(flow, this.effectiveValues[hi].getDepValue())) {
                            out_range_high = true;
                        } else {
                            while (hi - lo > 1) {
                                int mid = (lo + hi) / 2;
                                double midFlow = this.effectiveValues[mid].getDepValue();
                                if (this.lt(flow, midFlow)) {
                                    hi = mid;
                                    continue;
                                }
                                lo = mid;
                            }
                        }
                    } else if (this.gt(flow, this.effectiveValues[lo].getDepValue())) {
                        out_range_low = true;
                    } else if (this.lt(flow, this.effectiveValues[hi].getDepValue())) {
                        out_range_high = true;
                    } else {
                        while (hi - lo > 1) {
                            int mid = (lo + hi) / 2;
                            double midFlow = this.effectiveValues[mid].getDepValue();
                            if (this.gt(flow, midFlow)) {
                                hi = mid;
                                continue;
                            }
                            lo = mid;
                        }
                    }
                    if (!out_range_low) break block57;
                    switch (this.outRangeLowMethod) {
                        case NULL: {
                            return -3.4028234663852886E38;
                        }
                        case ERROR: {
                            throw new RatingException("Value is out of range low.");
                        }
                        case LINEAR: 
                        case LOGARITHMIC: 
                        case LIN_LOG: 
                        case LOG_LIN: {
                            extrap_method = this.outRangeLowMethod;
                            break block58;
                        }
                        case PREVIOUS: {
                            throw new RatingException("No previous value in table.");
                        }
                        case NEXT: 
                        case NEAREST: 
                        case CLOSEST: {
                            flow = this.effectiveValues[0].getDepValue();
                            extrap_method = this.outRangeLowMethod;
                            break block58;
                        }
                        case LOWER: {
                            if (this.props.hasIncreasing()) {
                                throw new RatingException("No lower value in table.");
                            }
                            flow = this.effectiveValues[0].getDepValue();
                            extrap_method = this.outRangeLowMethod;
                            break block58;
                        }
                        case HIGHER: {
                            if (this.props.hasDecreasing()) {
                                throw new RatingException("No higher value in table.");
                            }
                            flow = this.effectiveValues[0].getDepValue();
                            extrap_method = this.outRangeLowMethod;
                            break block58;
                        }
                        default: {
                            throw new RatingException("Unexpected behavior specified : " + this.outRangeLowMethod + " : " + this.outRangeLowMethod.description());
                        }
                    }
                }
                if (out_range_high) {
                    switch (this.outRangeHighMethod) {
                        case NULL: {
                            return -3.4028234663852886E38;
                        }
                        case ERROR: {
                            throw new RatingException("Value is out of range high.");
                        }
                        case LINEAR: 
                        case LOGARITHMIC: 
                        case LIN_LOG: 
                        case LOG_LIN: {
                            extrap_method = this.outRangeHighMethod;
                            break;
                        }
                        case NEXT: {
                            throw new RatingException("No next value in table.");
                        }
                        case PREVIOUS: 
                        case NEAREST: 
                        case CLOSEST: {
                            flow = this.effectiveValues[this.effectiveValues.length - 1].getDepValue();
                            extrap_method = this.outRangeHighMethod;
                            break;
                        }
                        case LOWER: {
                            if (this.props.hasDecreasing()) {
                                throw new RatingException("No lower value in table.");
                            }
                            flow = this.effectiveValues[this.effectiveValues.length - 1].getDepValue();
                            extrap_method = this.outRangeHighMethod;
                            break;
                        }
                        case HIGHER: {
                            if (this.props.hasIncreasing()) {
                                throw new RatingException("No higher value in table.");
                            }
                            flow = this.effectiveValues[this.effectiveValues.length - 1].getDepValue();
                            extrap_method = this.outRangeHighMethod;
                            break;
                        }
                        default: {
                            throw new RatingException("Unexpected behavior specified : " + this.outRangeHighMethod + " : " + this.outRangeHighMethod.description());
                        }
                    }
                }
            }
            double loHeight = this.effectiveValues[lo].getIndValue();
            double hiHeight = this.effectiveValues[hi].getIndValue();
            double loFlow = this.effectiveValues[lo].getDepValue();
            double hiFlow = this.effectiveValues[hi].getDepValue();
            RatingConst.RatingMethod ratingMethod = method = out_range_low || out_range_high ? extrap_method : this.inRangeMethod;
            if (method == null) {
                throw new RatingException("Internal error, cannot determine rating method for reverse rate function with value: " + depVal);
            }
            switch (method) {
                case NULL: {
                    return -3.4028234663852886E38;
                }
                case ERROR: {
                    throw new RatingException("No such value in table.");
                }
                case PREVIOUS: {
                    shifted = loHeight;
                    break;
                }
                case NEXT: {
                    shifted = hiHeight;
                    break;
                }
                case LOWER: {
                    shifted = this.props.hasIncreasing() ? loHeight : hiHeight;
                    break;
                }
                case HIGHER: {
                    shifted = this.props.hasIncreasing() ? hiHeight : loHeight;
                    break;
                }
                case CLOSEST: {
                    shifted = this.lt(Math.abs(flow - loFlow), Math.abs(hiHeight - hiFlow)) ? loHeight : hiHeight;
                    break;
                }
            }
            if (shifted == -3.4028234663852886E38) {
                boolean ind_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LIN_LOG;
                boolean dep_log = method == RatingConst.RatingMethod.LOGARITHMIC || method == RatingConst.RatingMethod.LOG_LIN;
                double y = flow;
                double x1 = loHeight;
                double x2 = hiHeight;
                double y1 = loFlow;
                double y2 = hiFlow;
                double offset = 0.0;
                if (ind_log) {
                    if (this.offsets != null && this.offsets.values != null && this.offsets.values.length > 0) {
                        offset = this.offsets.values.length == 1 ? this.offsets.values[0].getDepValue() : this.offsets.rate(loHeight);
                    }
                    x1 = Math.log10(x1 - offset);
                    x2 = Math.log10(x2 - offset);
                    if (Double.isNaN(x1) || Double.isInfinite(x1) || Double.isNaN(x2) || Double.isInfinite(x2)) {
                        x1 = loHeight;
                        x2 = hiHeight;
                        ind_log = false;
                        dep_log = false;
                    }
                }
                if (dep_log) {
                    y = Math.log10(y);
                    y1 = Math.log10(y1);
                    y2 = Math.log10(y2);
                    if (Double.isNaN(y) || Double.isInfinite(y) || Double.isNaN(y1) || Double.isInfinite(y1) || Double.isNaN(y2) || Double.isInfinite(y2)) {
                        y = flow;
                        x1 = loHeight;
                        x2 = hiHeight;
                        y1 = loFlow;
                        y2 = hiFlow;
                        ind_log = false;
                    }
                }
                shifted = x1 + (y - y1) / (y2 - y1) * (x2 - x1);
                if (ind_log) {
                    shifted = Math.pow(10.0, shifted) + offset;
                }
            }
            double shift = this.getShiftFromShifted(valTime, shifted);
            double unshifted = shifted - shift;
            return unshifted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatingSet getShifts() throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            AbstractRatingSet retval = null;
            if (this.shifts != null) {
                retval = RatingSetFactory.ratingSet(this.shifts.getData());
                TableRating tr = (TableRating)((RatingSet)retval).getRatings()[0];
                if (tr.effectiveDate == this.effectiveDate) {
                    TableRatingContainer trc = tr.getData();
                    if (trc.values.length == 1 && trc.values[0].indValue == 0.0 && trc.values[0].depValue == 0.0) {
                        ((RatingSet)retval).removeRating(this.effectiveDate);
                    }
                }
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShifts(RatingSet shifts) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            if (shifts != null) {
                RatingSetContainer rsc = shifts.getData();
                TableRatingContainer trc = (TableRatingContainer)rsc.abstractRatingContainers[0];
                if (trc.values == null || trc.values.length == 0) {
                    this.shifts = shifts;
                } else {
                    AbstractRatingSet _shifts = RatingSetFactory.ratingSet(rsc);
                    AbstractRating[] arcs = ((RatingSet)_shifts).getRatings();
                    TableRatingContainer trc1 = (TableRatingContainer)arcs[0].getData();
                    if (trc1.effectiveDateMillis < this.effectiveDate) {
                        throw new RatingException("Effective date of first shift pre-dates base rating");
                    }
                    if (trc1.effectiveDateMillis > this.effectiveDate) {
                        TableRatingContainer trc0 = new TableRatingContainer();
                        trc1.clone(trc0);
                        trc0.effectiveDateMillis = this.effectiveDate;
                        RatingValueContainer rvc = new RatingValueContainer();
                        rvc.indValue = 0.0;
                        rvc.depValue = 0.0;
                        trc0.values = new RatingValueContainer[]{rvc};
                        ((RatingSet)_shifts).addRating(new TableRating(trc0));
                        this.shifts = _shifts;
                    } else {
                        this.shifts = shifts;
                    }
                }
            } else {
                this.shifts = shifts;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRating getOffsets() {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            return this.offsets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffsets(TableRating offsets) {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            this.offsets = offsets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestEffectiveDate(long valTime) {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            long latestEffectiveDate = this.effectiveDate;
            if (this.shifts != null) {
                for (AbstractRating rating : this.shifts.getRatings()) {
                    long shiftEffectiveDate;
                    if (!rating.isActive() || (shiftEffectiveDate = rating.getEffectiveDate()) > valTime || shiftEffectiveDate <= latestEffectiveDate) continue;
                    latestEffectiveDate = rating.getEffectiveDate();
                }
            }
            return latestEffectiveDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsgsStreamTableRatingContainer getData() {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            UsgsStreamTableRatingContainer ustrc = new UsgsStreamTableRatingContainer();
            this.getData(ustrc);
            if (this.shifts != null) {
                try {
                    ustrc.shifts = this.getShifts().getData();
                }
                catch (RatingException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            if (this.offsets != null) {
                ustrc.offsets = this.offsets.getData();
            }
            return ustrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRatingTime(long ratingTime) {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            super.setRatingTime(ratingTime);
            if (this.shifts != null) {
                this.shifts.setRatingTime(ratingTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRatingTime() {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            super.resetRatingTime();
            if (this.shifts != null) {
                this.shifts.resetRatingTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(AbstractRatingContainer rc) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            int i;
            if (!(rc instanceof UsgsStreamTableRatingContainer)) {
                throw new RatingException("setData() requires a UsgsStreamTableRatingContainer object.");
            }
            UsgsStreamTableRatingContainer ustrc = (UsgsStreamTableRatingContainer)rc;
            if (this.values != null) {
                for (RatingValue value : this.values) {
                    value.deleteObserver(this);
                }
            }
            if (this.extensionValues != null) {
                for (RatingValue value : this.extensionValues) {
                    value.deleteObserver(this);
                }
            }
            RatingValue[] values = new RatingValue[ustrc.values.length];
            RatingValue[] extensionValues = null;
            for (i = 0; i < ustrc.values.length; ++i) {
                values[i] = new RatingValue(ustrc.values[i]);
            }
            if (ustrc.extensionValues != null) {
                extensionValues = new RatingValue[ustrc.extensionValues.length];
                for (i = 0; i < ustrc.extensionValues.length; ++i) {
                    extensionValues[i] = new RatingValue(ustrc.extensionValues[i]);
                }
            }
            this.init(values, extensionValues, RatingConst.RatingMethod.fromString(ustrc.inRangeMethod), RatingConst.RatingMethod.fromString(ustrc.outRangeLowMethod), RatingConst.RatingMethod.fromString(ustrc.outRangeHighMethod), ustrc.officeId, ustrc.ratingSpecId, ustrc.unitsId, ustrc.effectiveDateMillis, ustrc.transitionStartDateMillis, ustrc.createDateMillis, ustrc.active, ustrc.description);
            this.setShifts(ustrc.shifts == null ? null : RatingSetFactory.ratingSet(ustrc.shifts));
            this.setOffsets(ustrc.offsets == null ? null : new TableRating(ustrc.offsets));
            this.observationTarget.setChanged();
            this.observationTarget.notifyObservers();
        }
    }

    @Override
    @Deprecated
    public String toXmlString(CharSequence indent, int indentLevel) throws RatingException {
        return RatingXmlCompatUtil.getInstance().toXml(this, indent, indentLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double getShiftFromUnshifted(long valTime, double height) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            double shift = 0.0;
            try {
                if (this.shiftRounder == null) {
                    this.shiftRounder = this.ratingSpec == null ? new UsgsRounder((CharSequence)"2223456782") : this.ratingSpec.getIndRoundingSpecs()[0];
                }
                if (this.shifts != null && this.shifts.getActiveRatingCount() > 0) {
                    shift = this.shifts.rate(height, valTime);
                    shift = this.shiftRounder.round(shift, true);
                }
            }
            catch (RoundingException e) {
                throw new RatingException((Throwable)e);
            }
            return shift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double getShiftFromShifted(long valTime, double height) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            double shift = 0.0;
            if (this.shifts != null && this.shifts.getActiveRatingCount() > 0) {
                double shift1 = this.getShiftFromUnshifted(valTime, height);
                double unshifted = height - shift1;
                double shift2 = this.getShiftFromUnshifted(valTime, unshifted);
                double mean = (shift1 + shift2) / 2.0;
                double diff = Math.abs(shift2 - shift1);
                int i = 0;
                int limit = 100;
                for (i = 0; i < limit && diff * 1.0E8 > Math.abs(mean); ++i) {
                    shift1 = shift2;
                    unshifted = height - shift1;
                    shift2 = this.getShiftFromUnshifted(valTime, unshifted);
                    mean = (shift1 + shift2) / 2.0;
                    diff = Math.abs(shift2 - shift1);
                }
                shift = mean;
                if (i == limit) {
                    logger.warning("Could not converge on shift for shifted value " + height + " in " + limit + " iterations.");
                }
            }
            return shift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double getOffset(double indVal) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            double offset = 0.0;
            if (this.offsets != null && this.offsets.values != null && this.offsets.values.length > 0) {
                TableRatingContainer trc = this.offsets.getData();
                if (trc.values.length == 1) {
                    offset = trc.values[0].depValue;
                } else {
                    if (this.offsets.ratingUnitsId == null) {
                        this.offsets.ratingUnitsId = this.ratingUnitsId;
                    }
                    offset = this.offsets.rate(indVal);
                }
            }
            return offset;
        }
    }

    @Override
    public double[][] getRatingExtents() throws RatingException {
        return this.getRatingExtents(this.getRatingTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            double[][] extents = super.getRatingExtents(ratingTime);
            double[] dArray = extents[0];
            dArray[0] = dArray[0] - this.getShiftFromShifted(ratingTime, extents[0][0]);
            double[] dArray2 = extents[1];
            dArray2[0] = dArray2[0] - this.getShiftFromShifted(ratingTime, extents[1][0]);
            return extents;
        }
    }

    @Override
    public UsgsStreamTableRating getInstance(AbstractRatingContainer ratingContainer) throws RatingException {
        if (!(ratingContainer instanceof UsgsStreamTableRatingContainer)) {
            throw new UnsupportedOperationException("USGS Stream Table Ratings only support USGS Stream Table Rating Containers.");
        }
        return new UsgsStreamTableRating((UsgsStreamTableRatingContainer)ratingContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RatingSetContainer createShiftsRatingSetContainer(Date shiftDate, List<RatingValueContainer> stageShiftValues, boolean shiftActive) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            RatingSpecContainer ratingSpecContainer;
            RatingSetContainer retvalShifts = new RatingSetContainer();
            retvalShifts.ratingSpecContainer = ratingSpecContainer = new RatingSpecContainer();
            String locationRefId = null;
            try {
                IRatingSpecification ratingSpecification = this.getRatingSpecification();
                LocationTemplate locationRef = ratingSpecification.getLocationRef();
                if (locationRef != null) {
                    locationRefId = locationRef.getLocationId();
                }
            }
            catch (DataSetException e) {
                throw new RatingException((Throwable)e);
            }
            ratingSpecContainer.locationId = locationRefId;
            ratingSpecContainer.inRangeMethod = "LINEAR";
            ratingSpecContainer.outRangeLowMethod = "NEAREST";
            ratingSpecContainer.outRangeHighMethod = "NEAREST";
            ratingSpecContainer.indParams = new String[1];
            ratingSpecContainer.indParams[0] = "Stage";
            ratingSpecContainer.depParam = "Stage-Shift";
            ratingSpecContainer.parametersId = String.format("%s;%s", ratingSpecContainer.indParams[0], ratingSpecContainer.depParam);
            ratingSpecContainer.templateVersion = "Standard";
            ratingSpecContainer.templateId = String.format("%s.%s", ratingSpecContainer.parametersId, ratingSpecContainer.templateVersion);
            ratingSpecContainer.inRangeMethods = new String[1];
            ratingSpecContainer.inRangeMethods[0] = "LINEAR";
            ratingSpecContainer.outRangeLowMethods = new String[1];
            ratingSpecContainer.outRangeLowMethods[0] = "NEAREST";
            ratingSpecContainer.outRangeHighMethods = new String[1];
            ratingSpecContainer.outRangeHighMethods[0] = "NEAREST";
            ratingSpecContainer.indRoundingSpecs = new String[1];
            ratingSpecContainer.indRoundingSpecs[0] = "4444444449";
            ratingSpecContainer.depRoundingSpec = "4444444449";
            retvalShifts.abstractRatingContainers = new TableRatingContainer[1];
            String unitsId = this.getRatingUnitsId();
            String shiftUnit = TextUtil.split((String)TextUtil.split((String)unitsId, (String)";")[0], (String)",")[0];
            TableRatingContainer shiftTableRatingContainer = new TableRatingContainer();
            retvalShifts.abstractRatingContainers[0] = shiftTableRatingContainer;
            shiftTableRatingContainer.ratingSpecId = String.format("%s.%s.%s", ratingSpecContainer.locationId, retvalShifts.ratingSpecContainer.templateId, "Production");
            shiftTableRatingContainer.unitsId = String.format("%s;%s", shiftUnit, shiftUnit);
            shiftTableRatingContainer.effectiveDateMillis = shiftDate.getTime();
            shiftTableRatingContainer.createDateMillis = Long.MIN_VALUE;
            shiftTableRatingContainer.active = shiftActive;
            shiftTableRatingContainer.values = new RatingValueContainer[stageShiftValues.size()];
            stageShiftValues.toArray(shiftTableRatingContainer.values);
            shiftTableRatingContainer.inRangeMethod = "LINEAR";
            shiftTableRatingContainer.outRangeLowMethod = "NEAREST";
            shiftTableRatingContainer.outRangeHighMethod = "NEAREST";
            return retvalShifts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableRating addShift(RatingSet shiftsRef, Date shiftDate, List<RatingValueContainer> stageShiftValues, boolean shiftActive) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            String unitsId = this.getRatingUnitsId();
            String shiftUnit = TextUtil.split((String)TextUtil.split((String)unitsId, (String)";")[0], (String)",")[0];
            String locationRefId = null;
            try {
                IRatingSpecification ratingSpecification = this.getRatingSpecification();
                LocationTemplate locationRef = ratingSpecification.getLocationRef();
                if (locationRef != null) {
                    locationRefId = locationRef.getLocationId();
                }
            }
            catch (DataSetException e) {
                throw new RatingException((Throwable)e);
            }
            String locationId = locationRefId;
            RatingSpec ratingSpec = shiftsRef.getRatingSpec();
            String templateId = ratingSpec.getTemplateId();
            TableRatingContainer shiftTableRatingContainer = new TableRatingContainer();
            shiftTableRatingContainer.ratingSpecId = String.format("%s.%s.%s", locationId, templateId, "Production");
            shiftTableRatingContainer.unitsId = String.format("%s;%s", shiftUnit, shiftUnit);
            shiftTableRatingContainer.effectiveDateMillis = shiftDate.getTime();
            shiftTableRatingContainer.createDateMillis = Long.MIN_VALUE;
            shiftTableRatingContainer.active = shiftActive;
            shiftTableRatingContainer.values = new RatingValueContainer[stageShiftValues.size()];
            stageShiftValues.toArray(shiftTableRatingContainer.values);
            shiftTableRatingContainer.inRangeMethod = "LINEAR";
            shiftTableRatingContainer.outRangeLowMethod = "NEAREST";
            shiftTableRatingContainer.outRangeHighMethod = "NEAREST";
            TableRating shiftTableRating = new TableRating(shiftTableRatingContainer);
            shiftsRef.addRating(shiftTableRating);
            return shiftTableRating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRating addShift(Date shiftDate, List<RatingValueContainer> stageShiftValues, boolean shiftActive) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            TableRating retval = null;
            RatingSet shiftsRef = this.getShifts();
            long shiftDateTime = shiftDate.getTime();
            if (shiftsRef != null && shiftsRef.getRatingsMap().containsKey(shiftDateTime)) {
                StringBuilder sb = new StringBuilder();
                SimpleDateFormat gmtDateFormat = new SimpleDateFormat("HHmm ddMMMyyyy z");
                gmtDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                String strShiftDateTime = gmtDateFormat.format(this.effectiveDate);
                sb.append(this.getRatingSpecId()).append(" already contains a shift at: ").append(strShiftDateTime);
                throw new RatingException(sb.toString());
            }
            RatingSetContainer shiftsRatingSetContainer = null;
            if (shiftsRef == null) {
                shiftsRatingSetContainer = this.createShiftsRatingSetContainer(shiftDate, stageShiftValues, shiftActive);
                shiftsRef = RatingSetFactory.ratingSet(shiftsRatingSetContainer);
                this.setShifts(shiftsRef);
            } else {
                this.addShift(shiftsRef, shiftDate, stageShiftValues, shiftActive);
            }
            retval = (TableRating)shiftsRef.getRating(shiftDateTime);
            return retval;
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((UsgsStreamTableRating)obj).getData());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEffectiveDate(long effectiveDate) throws RatingException {
        UsgsStreamTableRating usgsStreamTableRating = this;
        synchronized (usgsStreamTableRating) {
            if (this.shifts != null) {
                for (long shiftEffectiveDate : this.shifts.getEffectiveDates()) {
                    if (effectiveDate <= shiftEffectiveDate) continue;
                    throw new RatingException("Effective date is later than existing shift effective date");
                }
            }
            super.setEffectiveDate(effectiveDate);
        }
    }
}

