/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating;

import hec.data.RatingException;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingSet;
import hec.data.cwmsRating.RatingValue;
import hec.data.cwmsRating.SourceRating;
import hec.data.cwmsRating.TransitionalRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.SourceRatingContainer;
import hec.data.cwmsRating.io.VirtualRatingContainer;
import hec.lang.Observable;
import hec.util.TextUtil;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VirtualRating
extends AbstractRating {
    protected String connectionsString = null;
    protected Map<String, Set<String>> connectionsMap = null;
    protected SourceRating[] sourceRatings = null;
    protected String[] dataUnits;
    protected String[] ratingUnits;
    protected String depParamConn = null;
    protected boolean isNormalized = false;
    String[][] inputs = null;
    String[] outputs = null;

    protected static void parseConnectionPoint(String connectionPoint, int[] results) {
        results[1] = -1;
        results[0] = -1;
        switch (connectionPoint.charAt(0)) {
            case 'I': {
                results[1] = connectionPoint.codePointAt(1) - 49;
                break;
            }
            case 'R': {
                results[0] = connectionPoint.codePointAt(1) - 49;
                switch (connectionPoint.charAt(2)) {
                    case 'I': {
                        results[1] = connectionPoint.codePointAt(3) - 49;
                    }
                }
            }
        }
    }

    public static String getConnectionsComplete(Map<String, Set<String>> connMap, String depParamConn) {
        HashSet conns = new HashSet();
        for (String conn1 : connMap.keySet()) {
            for (String string : connMap.get(conn1)) {
                HashSet<String> set = new HashSet<String>();
                set.add(conn1);
                set.add(string);
                conns.add(set);
            }
        }
        String[][] connArray = new String[conns.size()][];
        int i = 0;
        for (Set set : conns) {
            connArray[i] = set.toArray(new String[2]);
            Arrays.sort(connArray[i]);
            if (connArray[i][0].endsWith("D")) {
                String temp = connArray[i][0];
                connArray[i][0] = connArray[i][1];
                connArray[i][1] = temp;
            }
            ++i;
        }
        Arrays.sort(connArray, new Comparator<String[]>(){

            @Override
            public int compare(String[] arg0, String[] arg1) {
                int result = arg0[0].compareTo(arg1[0]);
                if (result == 0) {
                    result = arg0[1].compareTo(arg1[1]);
                }
                return result;
            }
        });
        StringBuilder sb = new StringBuilder();
        for (String[] conn : connArray) {
            if (conn[0].indexOf(73) == 0) {
                sb.append(conn[1]).append("=").append(conn[0]).append(",");
                continue;
            }
            sb.append(conn[0]).append("=").append(conn[1]).append(",");
        }
        sb.append("D=").append(depParamConn);
        return sb.toString();
    }

    public static String getConnectionsNormalized(Map<String, Set<String>> connMap, String depParamConn) {
        String completeConnections = VirtualRating.getConnectionsComplete(connMap, depParamConn);
        HashMap<String, String> skipped = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String pair : TextUtil.split((String)completeConnections, (String)",")) {
            String[] parts = TextUtil.split((String)pair, (String)"=");
            if (parts[1].charAt(0) == 'I') {
                if (!skipped.containsKey(parts[1])) {
                    skipped.put(parts[1], parts[0]);
                    continue;
                }
            } else if (parts[0].equals("D")) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(pair);
        }
        StringBuilder re_added = new StringBuilder();
        if (skipped.size() > 1) {
            int i;
            boolean done = false;
            Object[] inputs = skipped.keySet().toArray(new String[skipped.size()]);
            Object[] conns = skipped.values().toArray(new String[skipped.size()]);
            skipped.clear();
            for (i = 0; i < conns.length; ++i) {
                skipped.put(conns[i], inputs[i]);
            }
            block2: do {
                conns = skipped.keySet().toArray(new String[skipped.size()]);
                inputs = skipped.values().toArray(new String[skipped.size()]);
                Arrays.sort(inputs);
                Arrays.sort(conns);
                done = true;
                for (i = 0; i < conns.length; ++i) {
                    if (inputs[i] == skipped.get(conns[i])) continue;
                    if (re_added.length() > 0) {
                        re_added.append(",");
                    }
                    re_added.append((String)conns[i]).append("=").append((String)skipped.get(conns[i]));
                    skipped.remove(conns[i]);
                    done = false;
                    continue block2;
                }
            } while (!done);
        }
        if (re_added.length() > 0) {
            re_added.append(",").append((CharSequence)sb);
            sb = re_added;
        }
        if (sb.length() == 0) {
            sb.append("R1I1=I1");
        }
        return sb.toString();
    }

    public VirtualRating() {
        this.init();
    }

    public VirtualRating(VirtualRatingContainer vrc) throws RatingException {
        this.init();
        this.setData(vrc);
    }

    @Deprecated
    public VirtualRating(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        VirtualRatingContainer container = service.createVirtualRatingContainer(xmlText);
        this.setData(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (this.observationTarget == null) {
                this.observationTarget = new Observable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnections() {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            return this.connectionsString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnections(String connections) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (connections == null || connections.length() == 0) {
                this.connectionsString = null;
                this.connectionsMap = null;
            } else {
                int n;
                HashMap<String, Set<String>> connMap = new HashMap<String, Set<String>>();
                for (String pair : connections.trim().toUpperCase().split("\\s*,\\s*")) {
                    String[] parts = pair.split("\\s*=\\s*");
                    if (parts.length != 2) {
                        throw new RatingException("Invalid connections string: " + connections);
                    }
                    if (!connMap.containsKey(parts[0])) {
                        connMap.put(parts[0], new HashSet());
                    }
                    if (!((Set)connMap.get(parts[0])).add(parts[1])) {
                        AbstractRating.logger.warning(String.format("Connection %s specified more than once", pair));
                    }
                    if (!connMap.containsKey(parts[1])) {
                        connMap.put(parts[1], new HashSet());
                    }
                    if (((Set)connMap.get(parts[1])).add(parts[0])) continue;
                    AbstractRating.logger.warning(String.format("Connection %s specified more than once", pair));
                }
                this.depParamConn = connMap.containsKey("D") ? (String)((Set)connMap.get("D")).iterator().next() : null;
                ArrayList<CallSite> unconnectedList = new ArrayList<CallSite>();
                Object connectionPoint = null;
                for (int r = 0; r < this.sourceRatings.length; ++r) {
                    for (int p = 0; p < this.sourceRatings[r].getIndParamCount(); ++p) {
                        connectionPoint = "R" + (r + 1) + "I" + (p + 1);
                        if (connMap.containsKey(connectionPoint)) continue;
                        unconnectedList.add((CallSite)connectionPoint);
                    }
                    connectionPoint = "R" + (r + 1) + "D";
                    if (connMap.containsKey(connectionPoint)) continue;
                    unconnectedList.add((CallSite)connectionPoint);
                }
                Vector<Object> automaticConnections = new Vector<Object>();
                if (unconnectedList.size() > (this.depParamConn == null ? 1 : 0)) {
                    for (int i = 0; i < Math.min(unconnectedList.size(), this.getIndParamCount()); ++i) {
                        String indParam = "I" + (i + 1);
                        connectionPoint = (String)unconnectedList.get(0);
                        if (!connMap.containsKey(connectionPoint)) {
                            connMap.put((String)connectionPoint, new HashSet());
                        }
                        ((Set)connMap.get(connectionPoint)).add(indParam);
                        if (!connMap.containsKey(indParam)) {
                            automaticConnections.add(indParam);
                            connMap.put(indParam, new HashSet());
                        }
                        ((Set)connMap.get(indParam)).add(connectionPoint);
                        unconnectedList.remove(connectionPoint);
                    }
                }
                if (this.depParamConn == null) {
                    automaticConnections.add("D");
                }
                if (unconnectedList.size() > (this.depParamConn == null ? 1 : 0)) {
                    StringBuilder sb = new StringBuilder("Virtual rating is under-connected : \n\tunconnected internal parameters are: ");
                    boolean first = true;
                    for (String string : unconnectedList) {
                        sb.append(first ? "" : ", ").append(string);
                        first = false;
                    }
                    sb.append("\n\tautomatic connections are: ");
                    for (int i = 0; i < automaticConnections.size(); ++i) {
                        sb.append(i > 0 ? ", " : "").append((String)automaticConnections.get(i));
                    }
                    throw new RatingException(sb.toString());
                }
                for (int i = 0; i < this.getIndParamCount(); ++i) {
                    if (connMap.containsKey("I" + (i + 1))) continue;
                    throw new RatingException(String.format("Independent parameter %s is not connected", i + 1));
                }
                if (this.depParamConn == null) {
                    this.depParamConn = (String)unconnectedList.get(0);
                }
                StringBuffer sb = new StringBuffer();
                int[] cpInfo = new int[]{-1, -1};
                int r = cpInfo[0];
                int n2 = cpInfo[1];
                for (int i = 0; i < this.getIndParamCount(); ++i) {
                    int n3;
                    String indParam = "I" + (i + 1);
                    if (!this.depParamConn.equals(this.walkConnections(connMap, indParam))) {
                        throw new RatingException(String.format("Connection path does not connect rating independent parameter %d with rating dependend parameter (%s)", i + 1, this.depParamConn));
                    }
                    VirtualRating.parseConnectionPoint((String)((Set)connMap.get(indParam)).iterator().next(), cpInfo);
                    r = cpInfo[0];
                    n3 = cpInfo[1] < 0 ? (n3 = this.sourceRatings[r].getIndParamCount()) : cpInfo[1];
                    sb.append(i == 0 ? "" : ",").append(this.sourceRatings[r].ratingUnits[n3]);
                }
                VirtualRating.parseConnectionPoint(this.depParamConn, cpInfo);
                r = cpInfo[0];
                int n4 = cpInfo[1] < 0 ? (n = this.sourceRatings[r].ratingUnits.length - 1) : cpInfo[1];
                sb.append(";").append(this.sourceRatings[r].ratingUnits[n4]);
                this.setRatingUnitsId(sb.toString());
                this.connectionsMap = connMap;
                this.connectionsString = connections;
                this.isNormalized = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize() throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            HashSet set;
            int i;
            int i2;
            final Pattern pat = Pattern.compile("(R|I)(\\d+)(D|I(\\d+))");
            int[] newPos = new int[this.sourceRatings.length];
            Arrays.fill(newPos, -1);
            Matcher m = pat.matcher(this.depParamConn);
            if (!m.matches()) {
                throw new RatingException("Unexpected dependent parameter connection: " + this.depParamConn);
            }
            int dep = Integer.parseInt(m.group(2)) - 1;
            newPos[dep] = this.sourceRatings.length - 1;
            int nextPos = 0;
            block3: for (int i3 = 0; i3 < this.getIndParamCount(); ++i3) {
                String input = "I" + (i3 + 1);
                Set<String> set2 = this.connectionsMap.get(input);
                if (set2 == null) continue;
                String[] conns = set2.toArray(new String[set2.size()]);
                if (conns.length > 1) {
                    Arrays.sort(conns, new Comparator<String>(){

                        @Override
                        public int compare(String arg0, String arg1) {
                            Matcher m = pat.matcher(arg0);
                            if (m.matches()) {
                                int i = Integer.parseInt(m.group(2)) - 1;
                                m = pat.matcher(arg1);
                                if (m.matches()) {
                                    int j = Integer.parseInt(m.group(2)) - 1;
                                    return VirtualRating.this.sourceRatings[i].getName().compareTo(VirtualRating.this.sourceRatings[j].getName());
                                }
                                return arg0.compareTo(arg1);
                            }
                            return arg0.compareTo(arg1);
                        }
                    });
                }
                for (int j = 0; j < conns.length; ++j) {
                    m = pat.matcher(conns[j]);
                    if (!m.matches()) {
                        throw new RatingException("Unexpected independent parameter connection for " + input + ": " + (String)conns[0]);
                    }
                    int ind = Integer.parseInt(m.group(2)) - 1;
                    if (newPos[ind] != -1) continue;
                    newPos[ind] = nextPos++;
                    continue block3;
                }
            }
            Object[][] sourcePos = new Object[this.sourceRatings.length][2];
            for (i2 = 0; i2 < this.sourceRatings.length; ++i2) {
                sourcePos[i2][0] = this.sourceRatings[i2].getName();
                sourcePos[i2][1] = new Integer(i2);
            }
            Arrays.sort(sourcePos, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] arg0, Object[] arg1) {
                    String s0 = (String)arg0[0];
                    String s1 = (String)arg1[0];
                    return s0.compareTo(s1);
                }
            });
            for (i2 = 0; i2 < sourcePos.length; ++i2) {
                int pos = (Integer)sourcePos[i2][1];
                if (newPos[pos] != -1) continue;
                newPos[pos] = nextPos++;
            }
            SourceRating[] newSourceRatings = new SourceRating[this.sourceRatings.length];
            HashMap<String, Set<String>> newConnectionsMap = new HashMap<String, Set<String>>();
            for (String conn1 : this.connectionsMap.keySet()) {
                HashSet<String> set3 = new HashSet<String>();
                for (String conn2 : (HashSet)this.connectionsMap.get(conn1)) {
                    set3.add(conn2);
                }
                newConnectionsMap.put(conn1, set3);
            }
            for (i = 0; i < newPos.length; ++i) {
                newSourceRatings[newPos[i]] = this.sourceRatings[i];
                String _old = "R" + (i + 1);
                String _new = "r" + (newPos[i] + 1);
                for (String conn1 : newConnectionsMap.keySet().toArray(new String[newConnectionsMap.size()])) {
                    if (!conn1.startsWith(_old)) continue;
                    set = (HashSet)newConnectionsMap.get(conn1);
                    newConnectionsMap.remove(conn1);
                    conn1 = conn1.replaceAll(_old, _new);
                    newConnectionsMap.put(conn1, set);
                }
            }
            for (i = 0; i < newPos.length; ++i) {
                String _old = "R" + (i + 1);
                String _new = "r" + (newPos[i] + 1);
                for (String conn1 : newConnectionsMap.keySet().toArray(new String[newConnectionsMap.size()])) {
                    set = (HashSet)newConnectionsMap.get(conn1);
                    if (set == null) continue;
                    for (String conn2 : set.toArray(new String[set.size()])) {
                        if (!conn2.startsWith(_old)) continue;
                        set.remove(conn2);
                        set.add(conn2.replaceAll(_old, _new));
                        newConnectionsMap.put(conn1, set);
                    }
                }
            }
            for (String conn1 : newConnectionsMap.keySet().toArray(new String[newConnectionsMap.size()])) {
                Set set4 = (Set)newConnectionsMap.get(conn1);
                for (String conn2 : set4.toArray(new String[set4.size()])) {
                    set4.remove(conn2);
                    set4.add(conn2.toUpperCase());
                }
                newConnectionsMap.remove(conn1);
                conn1 = conn1.toUpperCase();
                newConnectionsMap.put(conn1, set4);
            }
            String _old = "R" + (dep + 1);
            String _new = "R" + (newPos[dep] + 1);
            String newDepParamConn = this.depParamConn.replaceAll(_old, _new);
            String newConnections = VirtualRating.getConnectionsNormalized(newConnectionsMap, newDepParamConn);
            this.setSourceRatings(newSourceRatings);
            this.setConnections(newConnections);
            this.connectionsMap = newConnectionsMap;
            this.depParamConn = newDepParamConn;
            this.isNormalized = true;
        }
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public VirtualRating normalizedCopy() throws RatingException {
        try {
            VirtualRating vr = new VirtualRating(this.getData());
            vr.normalize();
            return vr;
        }
        catch (Exception e) {
            throw new RatingException("Cannot create normalized copy.", (Throwable)e);
        }
    }

    public String getConnectionsComplete() {
        return VirtualRating.getConnectionsComplete(this.connectionsMap, this.depParamConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceRating[] getSourceRatings() {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            return this.sourceRatings == null ? null : Arrays.copyOf(this.sourceRatings, this.sourceRatings.length);
        }
    }

    public String[] getSourceRatingNames() {
        String[] names = null;
        if (this.sourceRatings != null) {
            names = new String[this.sourceRatings.length];
            for (int i = 0; i < this.sourceRatings.length; ++i) {
                names[i] = this.sourceRatings[i].getName();
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRatings(SourceRating[] sources) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (sources == null) {
                this.inputs = null;
                this.outputs = null;
                this.sourceRatings = null;
            } else {
                SourceRating[] clonedSources = Arrays.copyOf(sources, sources.length);
                String[][] newInputs = new String[clonedSources.length][];
                String[] newOutputs = new String[clonedSources.length];
                this.findCycles(clonedSources, new ArrayList<String>());
                for (int i = 0; i < clonedSources.length; ++i) {
                    newInputs[i] = new String[clonedSources[i].getIndParamCount()];
                    newOutputs[i] = "R" + (i + 1) + "D";
                    for (int j = 0; j < clonedSources[i].getIndParamCount(); ++j) {
                        newInputs[i][j] = "R" + (i + 1) + "I" + (j + 1);
                    }
                }
                for (SourceRating source : clonedSources) {
                    source.addObserver(this);
                }
                this.inputs = newInputs;
                this.outputs = newOutputs;
                this.sourceRatings = clonedSources;
            }
            this.isNormalized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String walkConnections(Map<String, Set<String>> map, String startingPoint) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            Object endingPoint = null;
            Set<String> connections = map.get(startingPoint);
            if (connections == null || startingPoint.equals("D")) {
                endingPoint = startingPoint;
            } else {
                int[] cpInfo = new int[]{-1, -1};
                VirtualRating.parseConnectionPoint(startingPoint, cpInfo);
                int startingPointRating = cpInfo[0];
                int startingPointPoint = cpInfo[1];
                ArrayList<String> endingPoints = new ArrayList<String>();
                for (String connectionPoint : connections) {
                    if (connectionPoint.equals("D")) {
                        endingPoint = startingPoint;
                        break;
                    }
                    String connectionPoint1 = null;
                    VirtualRating.parseConnectionPoint(connectionPoint, cpInfo);
                    int r = cpInfo[0];
                    int p = cpInfo[1];
                    if (r < 0) {
                        if (startingPointPoint == -1) {
                            String partialInput = "R" + (startingPointRating + 1) + "I";
                            for (int i = 0; i < 9; ++i) {
                                String input = partialInput + (i + 1);
                                if (map.containsKey(input) && (map.get(input).size() != 1 || !map.get(input).toArray(new String[1])[0].equals("D"))) continue;
                                endingPoint = input;
                                break;
                            }
                        }
                        if (endingPoint != null) break;
                        throw new RatingException(String.format("Connection path from %s leads to independent parameter", startingPoint));
                    }
                    if (r >= this.sourceRatings.length) {
                        throw new RatingException(String.format("Connection path from %s specifies rating beyond source rating count", startingPoint));
                    }
                    if (r == startingPointRating) {
                        throw new RatingException("Connection path specifies a connection from one rating to itself");
                    }
                    if (p < 0) {
                        if (this.sourceRatings[r].mathExpression != null) {
                            throw new RatingException(String.format("Connection path from %s would reverse throgh a math expression", startingPoint));
                        }
                        if (this.sourceRatings[r].getIndParamCount() > 1) {
                            throw new RatingException(String.format("Connection path from %s would reverse through a multiple-independent-parameter rating", startingPoint));
                        }
                        connectionPoint1 = "R" + (r + 1) + "I1";
                    } else {
                        connectionPoint1 = "R" + (r + 1) + "D";
                    }
                    endingPoints.add(this.walkConnections(map, connectionPoint1));
                    if (endingPoints.size() > 1 && !((String)endingPoints.get(endingPoints.size() - 1)).equals(endingPoints.get(0))) {
                        throw new RatingException(String.format("Connection point %s leads to multiple termination points", connectionPoint1));
                    }
                    endingPoint = (String)endingPoints.get(0);
                }
            }
            return endingPoint;
        }
    }

    public void findCycles() throws RatingException {
        this.findCycles(new ArrayList<String>());
    }

    protected void findCycles(List<String> specIds) throws RatingException {
        this.findCycles(this.sourceRatings, specIds);
    }

    protected void findCycles(SourceRating[] sources, List<String> specIds) throws RatingException {
        String specId = this.getOfficeId() + "/" + this.getRatingSpecId();
        if (specIds.contains(specId)) {
            StringBuilder sb = new StringBuilder("Cycle detected in source ratings. Cycle path is:");
            for (String pathSpecId : specIds) {
                sb.append(pathSpecId.equals(specId) ? "\n -->" : "\n    ").append(pathSpecId);
            }
            sb.append("\n -->").append(specId);
            throw new RatingException(sb.toString());
        }
        specIds.add(specId);
        if (sources != null) {
            for (SourceRating sr : sources) {
                AbstractRating[] ratings;
                RatingSet rs;
                if (sr == null || (rs = sr.getRatingSet()) == null || (ratings = rs.getRatings()) == null) continue;
                for (AbstractRating ar : ratings) {
                    if (ar instanceof VirtualRating) {
                        ((VirtualRating)ar).findCycles(new ArrayList<String>(specIds));
                    }
                    if (!(ar instanceof TransitionalRating)) continue;
                    ((TransitionalRating)ar).findCycles(new ArrayList<String>(specIds));
                }
            }
        }
    }

    @Override
    @Deprecated
    public String toXmlString(CharSequence indent, int indentLevel) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this.getData(), indent, indentLevel);
    }

    public double[][] getRatingExtents(long ratingTime) throws RatingException {
        throw new RatingException("getRatingExtents is not supported for virtual ratings");
    }

    public double rate(double indVal) throws RatingException {
        return this.rate(this.defaultValueTime, indVal);
    }

    public double rateOne(double ... indVals) throws RatingException {
        return this.rateOne2(indVals);
    }

    public double rateOne2(double[] indVals) throws RatingException {
        long[] valTimes = new long[]{this.defaultValueTime};
        double[][] _indVals = new double[indVals.length][];
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i] = new double[]{indVals[i]};
        }
        return this.rate(valTimes, (double[][])_indVals)[0];
    }

    public double[] rate(double[] indVals) throws RatingException {
        return this.rate(this.defaultValueTime, indVals);
    }

    public double[] rate(double[][] indVals) throws RatingException {
        return this.rate(this.defaultValueTime, indVals);
    }

    public double rate(long valTime, double indVal) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[][] indVals = new double[][]{{indVal}};
        return this.rate(valTimes, (double[][])indVals)[0];
    }

    public double rateOne(long valTime, double ... indVals) throws RatingException {
        return this.rateOne2(valTime, indVals);
    }

    public double rateOne2(long valTime, double[] indVals) throws RatingException {
        long[] valTimes = new long[]{valTime};
        double[][] _indVals = new double[indVals.length][];
        for (int i = 0; i < indVals.length; ++i) {
            _indVals[i] = new double[]{indVals[i]};
        }
        return this.rate(valTimes, (double[][])_indVals)[0];
    }

    public double[] rate(long valTime, double[] indVals) throws RatingException {
        long[] valTimes = new long[indVals.length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    public double[] rate(long[] valTimes, double[] indVals) throws RatingException {
        return this.rate(valTimes, (double[][])new double[][]{indVals});
    }

    public double[] rate(long valTime, double[][] indVals) throws RatingException {
        long[] valTimes = new long[indVals[0].length];
        Arrays.fill(valTimes, valTime);
        return this.rate(valTimes, indVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] rate(long[] valTimes, double[][] indVals) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (indVals.length != this.getIndParamCount()) {
                throw new RatingException(String.format("Expected %d value sets, got %d", this.getIndParamCount(), indVals.length));
            }
            if (valTimes == null) {
                throw new RatingException("No value times supplied");
            }
            HashMap<Object, double[]> cpValues = new HashMap<Object, double[]>();
            String[] dataUnits = this.dataUnits == null ? this.getRatingUnits() : this.dataUnits;
            int[] cpInfo = new int[]{-1, -1};
            int r = cpInfo[0];
            int p = cpInfo[1];
            for (int i = 0; i < indVals.length; ++i) {
                if (indVals[i] == null) {
                    throw new RatingException(String.format("Independent paramter %d has no values", i + 1));
                }
                if (indVals[i].length != valTimes.length) {
                    throw new RatingException("Inconsistent times and values arrays");
                }
                cpValues.put("I" + (i + 1), indVals[i]);
            }
            HashSet sources = new HashSet(cpValues.keySet());
            while (!cpValues.containsKey(this.depParamConn)) {
                String[] populated = cpValues.keySet().toArray(new String[0]);
                for (String source : populated) {
                    VirtualRating.parseConnectionPoint(source, cpInfo);
                    r = cpInfo[0];
                    p = cpInfo[1] < 0 ? this.sourceRatings[r].dataUnits.length - 1 : cpInfo[1];
                    String srcUnit = r < 0 ? dataUnits[p] : this.sourceRatings[r].dataUnits[p];
                    Set<String> dests = this.connectionsMap.get(source);
                    for (String dest : dests) {
                        if (sources.contains(dest)) continue;
                        sources.add(source);
                        VirtualRating.parseConnectionPoint(dest, cpInfo);
                        r = cpInfo[0];
                        p = cpInfo[1] < 0 ? this.sourceRatings[r].dataUnits.length - 1 : cpInfo[1];
                        String dstUnit = this.sourceRatings[r].dataUnits[p];
                        if (dstUnit.equals(srcUnit)) {
                            cpValues.put(dest, (double[])cpValues.get(source));
                            continue;
                        }
                        double[] srcVals = (double[])cpValues.get(source);
                        double[] dstVals = Arrays.copyOf(srcVals, srcVals.length);
                        try {
                            Units.convertUnits((double[])dstVals, (String)srcUnit, (String)dstUnit);
                        }
                        catch (UnitsConversionException e) {
                            throw new RatingException((Throwable)e);
                        }
                        cpValues.put(dest, dstVals);
                    }
                }
                for (String source : sources) {
                    cpValues.remove(source);
                }
                for (r = 0; r < this.sourceRatings.length; ++r) {
                    int paramCount = this.sourceRatings[r].getIndParamCount();
                    for (p = 0; p < paramCount && cpValues.containsKey("R" + (r + 1) + "I" + (p + 1)); ++p) {
                    }
                    if (p == paramCount) {
                        int len = ((double[])cpValues.get(this.inputs[r][0])).length;
                        double[][] _indVals = new double[len][];
                        for (int i = 0; i < len; ++i) {
                            _indVals[i] = new double[paramCount];
                            for (p = 0; p < paramCount; ++p) {
                                double[] vals = (double[])cpValues.get(this.inputs[r][p]);
                                _indVals[i][p] = vals[i];
                            }
                        }
                        double[] results = this.sourceRatings[r].rate(valTimes, (double[][])_indVals);
                        cpValues.put(this.outputs[r], results);
                        for (p = 0; p < paramCount; ++p) {
                            cpValues.remove(this.inputs[r][p]);
                        }
                        continue;
                    }
                    if (!cpValues.containsKey(this.outputs[r])) continue;
                    double[] depVals = (double[])cpValues.get(this.outputs[r]);
                    cpValues.put(this.inputs[r][0], this.sourceRatings[r].reverseRate(valTimes, depVals));
                    cpValues.remove(this.outputs[r]);
                }
            }
            return (double[])cpValues.get(this.depParamConn);
        }
    }

    @Override
    public VirtualRatingContainer getData() {
        VirtualRatingContainer vrc = new VirtualRatingContainer();
        this.getData(vrc);
        return vrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getData(AbstractRatingContainer arc) {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (!(arc instanceof VirtualRatingContainer)) {
                throw new UnsupportedOperationException("Virtual Ratings only support Virtual Rating Containers.");
            }
            VirtualRatingContainer vrc = (VirtualRatingContainer)arc;
            super.getData(vrc);
            vrc.connections = this.connectionsString;
            if (this.sourceRatings != null && this.sourceRatings.length > 0) {
                vrc.sourceRatings = new SourceRatingContainer[this.sourceRatings.length];
                for (int i = 0; i < this.sourceRatings.length; ++i) {
                    vrc.sourceRatings[i] = this.sourceRatings[i].getData();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(AbstractRatingContainer arc) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (!(arc instanceof VirtualRatingContainer)) {
                throw new RatingException("Expected VirtualRatingContainer, got " + arc.getClass().getName());
            }
            super._setData(arc);
            VirtualRatingContainer vrc = (VirtualRatingContainer)arc;
            if (vrc.sourceRatings != null && vrc.sourceRatings.length > 0) {
                SourceRating[] sourceRatings = new SourceRating[vrc.sourceRatings.length];
                for (int i = 0; i < vrc.sourceRatings.length; ++i) {
                    sourceRatings[i] = new SourceRating(vrc.sourceRatings[i]);
                }
                this.setSourceRatings(sourceRatings);
            }
            this.setConnections(vrc.connections);
            this.findCycles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] reverseRate(long[] valTimes, double[] depVals) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            if (this.getIndParamCount() > 1) {
                throw new RatingException("Cannot reverse through a rating with more than one independent paramter");
            }
            for (int i = 0; i < this.sourceRatings.length; ++i) {
                if (this.sourceRatings[i].mathExpression != null) {
                    throw new RatingException("Cannot reverse through a virtual rating that contains a math expression for a source rating");
                }
                if (this.sourceRatings[i].getIndParamCount() <= 1) continue;
                throw new RatingException("Cannot reverse through a virutual rating that contains a source rating with more than one independent paramter");
            }
            double[][] cpValues = new double[2][];
            int unrated = 1;
            int rated = 0;
            int[] cpInfo = new int[]{-1, -1};
            int r = cpInfo[0];
            int p = cpInfo[1];
            Object ratedConn = this.depParamConn;
            String unratedConn = null;
            String terminus = this.connectionsMap.get("I1").iterator().next();
            String[] dataUnits = this.dataUnits == null ? this.getRatingUnits() : this.dataUnits;
            String ratedUnit = dataUnits[dataUnits.length - 1];
            String unratedUnit = null;
            cpValues[0] = depVals;
            boolean first = true;
            while (!((String)ratedConn).equals(terminus)) {
                Object values;
                ++rated;
                rated %= 2;
                ++unrated;
                unrated %= 2;
                if (first) {
                    first = false;
                    unratedConn = ratedConn;
                    VirtualRating.parseConnectionPoint(this.depParamConn, cpInfo);
                    r = cpInfo[0];
                    p = cpInfo[1];
                    unratedUnit = this.sourceRatings[r].dataUnits[p < 0 ? 1 : p];
                    ratedUnit = dataUnits[dataUnits.length - 1];
                } else {
                    VirtualRating.parseConnectionPoint((String)ratedConn, cpInfo);
                    r = cpInfo[0];
                    p = cpInfo[1];
                    ratedUnit = r < 0 ? dataUnits[p] : this.sourceRatings[r].dataUnits[p < 0 ? 1 : p];
                    unratedConn = this.connectionsMap.get(ratedConn).iterator().next();
                    VirtualRating.parseConnectionPoint(unratedConn, cpInfo);
                    r = cpInfo[0];
                    p = cpInfo[1];
                    unratedUnit = this.sourceRatings[r].dataUnits[p < 0 ? 1 : p];
                }
                if (!unratedUnit.equals(ratedUnit)) {
                    values = Arrays.copyOf(cpValues[unrated], cpValues[unrated].length);
                    try {
                        Units.convertUnits((double[])values, (String)ratedUnit, (String)unratedUnit);
                    }
                    catch (UnitsConversionException e) {
                        throw new RatingException((Throwable)e);
                    }
                    cpValues[unrated] = (double[])values;
                }
                if (p < 0) {
                    cpValues[rated] = this.sourceRatings[r].reverseRate(valTimes, cpValues[unrated]);
                    ratedConn = "R" + (r + 1) + "I1";
                    continue;
                }
                values = new double[cpValues[unrated].length][];
                for (int i = 0; i < cpValues[unrated].length; ++i) {
                    values[i] = new double[]{cpValues[unrated][i]};
                }
                cpValues[rated] = this.sourceRatings[r].rate(valTimes, (double[][])values);
                ratedConn = "R" + (r + 1) + "D";
            }
            VirtualRating.parseConnectionPoint(terminus, cpInfo);
            r = cpInfo[0];
            p = cpInfo[1];
            ratedUnit = this.sourceRatings[r].dataUnits[p < 0 ? this.sourceRatings[r].dataUnits.length - 1 : p];
            unratedUnit = dataUnits[0];
            if (!ratedUnit.equals(unratedUnit)) {
                try {
                    Units.convertUnits((double[])cpValues[rated], (String)ratedUnit, (String)unratedUnit);
                }
                catch (UnitsConversionException e) {
                    throw new RatingException((Throwable)e);
                }
            }
            return cpValues[rated];
        }
    }

    @Override
    public RatingValue[] getValues(Integer defaultInterval) {
        throw new UnsupportedOperationException("getValues is not supported for virtual ratings");
    }

    @Override
    public AbstractRating getInstance(AbstractRatingContainer ratingContainer) throws RatingException {
        if (!(ratingContainer instanceof VirtualRatingContainer)) {
            throw new UnsupportedOperationException("Virtual Ratings only support Virtual Rating Containers.");
        }
        return new VirtualRating((VirtualRatingContainer)ratingContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataUnitsId(String dataUnitsId) {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            super.setDataUnitsId(dataUnitsId);
            this.dataUnits = TextUtil.split((String)dataUnitsId.replace(";", ","), (String)",");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataUnits(String[] units) throws RatingException {
        VirtualRating virtualRating = this;
        synchronized (virtualRating) {
            super.setDataUnits(units);
            this.dataUnits = units == null ? null : Arrays.copyOf(units, units.length);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.getData().equals(((VirtualRating)obj).getData());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.getData().hashCode();
    }

    @Override
    public void storeToDatabase(Connection conn, boolean overwriteExisting) throws RatingException {
        if (!this.isNormalized()) {
            this.normalizedCopy().storeToDatabase(conn, overwriteExisting);
        } else {
            super.storeToDatabase(conn, overwriteExisting);
        }
    }
}

