/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating.io;

import hec.data.RatingException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.VirtualRatingContainer;
import hec.util.TextUtil;
import java.util.Objects;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class AbstractRatingContainer
implements VerticalDatum,
Comparable<AbstractRatingContainer> {
    public String officeId = null;
    public String ratingSpecId = null;
    public String unitsId = null;
    public boolean active = false;
    public long effectiveDateMillis = Long.MIN_VALUE;
    public long transitionStartDateMillis = Long.MIN_VALUE;
    public long createDateMillis = Long.MIN_VALUE;
    public String description = null;
    protected VerticalDatumContainer vdc = null;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRatingContainer that = (AbstractRatingContainer)o;
        return this.active == that.active && this.effectiveDateMillis == that.effectiveDateMillis && this.transitionStartDateMillis == that.transitionStartDateMillis && this.createDateMillis == that.createDateMillis && Objects.equals(this.officeId, that.officeId) && Objects.equals(this.ratingSpecId, that.ratingSpecId) && Objects.equals(this.unitsId, that.unitsId) && Objects.equals(this.description, that.description) && Objects.equals(this.vdc, that.vdc);
    }

    public int hashCode() {
        return Objects.hash(this.officeId, this.ratingSpecId, this.unitsId, this.active, this.effectiveDateMillis, this.transitionStartDateMillis, this.createDateMillis, this.description, this.vdc);
    }

    public void clone(AbstractRatingContainer other) {
        other.officeId = this.officeId;
        other.ratingSpecId = this.ratingSpecId;
        if (!(other instanceof VirtualRatingContainer)) {
            other.unitsId = this.unitsId;
        }
        other.active = this.active;
        other.effectiveDateMillis = this.effectiveDateMillis;
        other.transitionStartDateMillis = this.transitionStartDateMillis;
        other.createDateMillis = this.createDateMillis;
        other.description = this.description;
        if (this.vdc != null) {
            other.vdc = this.vdc.clone();
        }
    }

    public AbstractRatingContainer clone() {
        AbstractRatingContainer other = this.getInstance();
        this.clone(other);
        return other;
    }

    public String toString() {
        try {
            return String.format("%s/%s", this.officeId, this.ratingSpecId);
        }
        catch (Throwable t) {
            return super.toString();
        }
    }

    public boolean hasVerticalDatum() {
        return this.vdc != null;
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        throw new VerticalDatumException("Method is not implemented for " + this.getClass().getName());
    }

    public boolean toNGVD29() throws VerticalDatumException {
        throw new VerticalDatumException("Method is not implemented for " + this.getClass().getName());
    }

    public boolean toNAVD88() throws VerticalDatumException {
        throw new VerticalDatumException("Method is not implemented for " + this.getClass().getName());
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        boolean change = false;
        if (!this.vdc.getCurrentVerticalDatum().equalsIgnoreCase(datum)) {
            switch (datum.toUpperCase()) {
                case "NGVD29": {
                    change = this.toNGVD29();
                    break;
                }
                case "NAVD88": {
                    change = this.toNAVD88();
                    break;
                }
                case "NATIVE": {
                    change = this.toNativeVerticalDatum();
                    break;
                }
                case "LOCAL": {
                    if (!this.vdc.nativeDatum.equals("LOCAL")) {
                        throw new VerticalDatumException("Object does not have LOCAL vertical datum");
                    }
                    change = this.toNativeVerticalDatum();
                    break;
                }
                default: {
                    if (!this.vdc.nativeDatum.equals("LOCAL") || !TextUtil.equals((CharSequence)datum, (CharSequence)this.vdc.localDatumName)) {
                        throw new VerticalDatumException("Unexpected datum: " + datum);
                    }
                    change = this.toNativeVerticalDatum();
                }
            }
        }
        return change;
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        datum = datum.trim().toUpperCase();
        boolean change = false;
        if (change) {
            switch (datum) {
                case "NGVD29": 
                case "NAVD88": {
                    change = !this.vdc.currentDatum.equals(datum);
                    this.vdc.currentDatum = datum;
                    break;
                }
                case "NATIVE": {
                    change = !this.vdc.currentDatum.equals(this.vdc.getNativeVerticalDatum());
                    this.vdc.currentDatum = this.vdc.getNativeVerticalDatum();
                    break;
                }
                case "LOCAL": {
                    if (!this.vdc.nativeDatum.equals("LOCAL")) {
                        throw new VerticalDatumException("Object does not have LOCAL vertical datum");
                    }
                    change = !this.vdc.currentDatum.equals(this.vdc.localDatumName);
                    this.vdc.currentDatum = this.vdc.localDatumName;
                    break;
                }
                default: {
                    if (!this.vdc.nativeDatum.equals("LOCAL") || !TextUtil.equals((CharSequence)datum, (CharSequence)this.vdc.localDatumName)) {
                        throw new VerticalDatumException("Unexpected datum: " + datum);
                    }
                    change = !this.vdc.currentDatum.equals(this.vdc.getNativeVerticalDatum());
                    this.vdc.currentDatum = this.vdc.getNativeVerticalDatum();
                }
            }
        }
        return change;
    }

    public double getCurrentOffset() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getCurrentOffset();
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNGVD29Offset();
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNAVD88Offset();
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        return this.vdc.getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        if (this.vdc == null) {
            this.vdc = new VerticalDatumContainer(xmlStr);
        } else {
            this.vdc.setVerticalDatumInfo(xmlStr);
        }
    }

    public AbstractRatingContainer getInstance() {
        return new AbstractRatingContainer();
    }

    public AbstractRating newRating() throws RatingException {
        throw new RatingException("Cannot call newRating() on AbstractRatingContainer class");
    }

    @Deprecated
    public static AbstractRatingContainer buildFromXml(String xmlStr) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.createAbstractRatingContainer(xmlStr);
    }

    @Deprecated
    public String toXml(CharSequence indent) {
        return this.toXml(indent, 0);
    }

    @Deprecated
    public String toXml(CharSequence indent, int level) {
        return RatingContainerXmlCompatUtil.getInstance().toXml(this, indent, level);
    }

    public void addOffset(int paramNum, double offset) throws RatingException {
        throw new RatingException("This method is not implemented for " + this.getClass().getName());
    }

    protected String[][] getParamsAndUnits() {
        String[][] paramsAndUnits = new String[2][];
        String parametersId = TextUtil.split((String)this.ratingSpecId, (String)".")[1];
        paramsAndUnits[0] = TextUtil.split((String)TextUtil.replaceAll((String)parametersId, (String)";", (String)","), (String)",");
        paramsAndUnits[1] = TextUtil.split((String)TextUtil.replaceAll((String)this.unitsId, (String)";", (String)","), (String)",");
        return paramsAndUnits;
    }

    @Override
    public int compareTo(AbstractRatingContainer o) {
        int result = this.toString().compareTo(o.toString());
        if (result == 0) {
            result = (int)Math.signum(this.effectiveDateMillis - o.effectiveDateMillis);
        }
        return result;
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        return this.vdc;
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) {
        this.vdc = vdc;
    }
}

