/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating.io;

import hec.data.cwmsRating.io.TableRatingContainer;
import java.util.ArrayList;

public class RatingValueContainer {
    public double indValue = -3.4028234663852886E38;
    public double depValue = -3.4028234663852886E38;
    public String note = null;
    public TableRatingContainer depTable = null;

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj != null && obj.getClass() == this.getClass()) {
            RatingValueContainer other = (RatingValueContainer)obj;
            if (other.indValue == this.indValue && other.depValue == this.depValue && other.note == null == (this.note == null) && (this.note == null || other.note.equals(this.note)) && other.depTable == null == (this.depTable == null) && (this.depTable == null || other.depTable.equals(this.depTable))) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + 3 * (int)(this.indValue * 1000.0) + 5 * (int)(this.depValue * 1000.0) + 7 * (this.note == null ? 1 : this.note.hashCode()) + 11 * (this.depTable == null ? 1 : this.depTable.hashCode());
    }

    public void clone(RatingValueContainer other) {
        other.indValue = this.indValue;
        other.depValue = this.depValue;
        other.note = this.note;
        if (this.depTable == null) {
            other.depTable = null;
        } else {
            other.depTable = new TableRatingContainer();
            this.depTable.clone(other.depTable);
        }
    }

    public static RatingValueContainer[] makeContainers(double[][] points, String[] notes, String[] inRangeMethods, String[] outRangeLowMethods, String[] outRangeHighMethods) {
        return RatingValueContainer.makeContainers(points, notes, 0, points.length, 0, points[0].length, inRangeMethods, outRangeLowMethods, outRangeHighMethods);
    }

    public static RatingValueContainer[] makeContainers(double[][] points, String[] notes, int top, int depth, int left, int width, String[] inRangeMethods, String[] outRangeLowMethods, String[] outRangeHighMethods) {
        RatingValueContainer[] rvcs = null;
        if (width == 2) {
            rvcs = new RatingValueContainer[depth];
            for (int i = 0; i < depth; ++i) {
                rvcs[i] = new RatingValueContainer();
                rvcs[i].indValue = points[top + i][left + 0];
                rvcs[i].depValue = points[top + i][left + 1];
                if (notes == null) continue;
                rvcs[i].note = notes[top + i];
            }
        } else {
            double lastIndValue = points[top][left];
            ArrayList<Integer> breakpoints = new ArrayList<Integer>();
            breakpoints.add(0);
            for (int i = 1; i < depth; ++i) {
                if (points[top + i][left] == lastIndValue) continue;
                breakpoints.add(i);
                lastIndValue = points[top + i][left];
            }
            int count = breakpoints.size();
            rvcs = new RatingValueContainer[count];
            for (int i = 0; i < count; ++i) {
                rvcs[i] = new RatingValueContainer();
                rvcs[i].indValue = points[top + (Integer)breakpoints.get(i)][left];
                rvcs[i].depTable = new TableRatingContainer();
                int sub_depth = i == count - 1 ? depth - (Integer)breakpoints.get(i) : (Integer)breakpoints.get(i + 1) - (Integer)breakpoints.get(i);
                if (inRangeMethods != null) {
                    rvcs[i].depTable.inRangeMethod = inRangeMethods[left + 1];
                }
                if (outRangeLowMethods != null) {
                    rvcs[i].depTable.outRangeLowMethod = outRangeLowMethods[left + 1];
                }
                if (outRangeHighMethods != null) {
                    rvcs[i].depTable.outRangeHighMethod = outRangeHighMethods[left + 1];
                }
                rvcs[i].depTable.values = RatingValueContainer.makeContainers(points, notes, top + (Integer)breakpoints.get(i), sub_depth, left + 1, width - 1, inRangeMethods, outRangeLowMethods, outRangeHighMethods);
            }
        }
        return rvcs;
    }
}

