/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating.io;

import hec.data.RatingException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingConst;
import hec.data.cwmsRating.TableRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingValueContainer;
import java.io.Reader;
import java.io.StringReader;
import mil.army.usace.hec.metadata.VerticalDatumException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class TableRatingContainer
extends AbstractRatingContainer {
    public RatingValueContainer[] values = null;
    public RatingValueContainer[] extensionValues = null;
    public String inRangeMethod = null;
    public String outRangeLowMethod = null;
    public String outRangeHighMethod = null;

    public TableRatingContainer() {
    }

    @Deprecated
    public TableRatingContainer(Element element) throws RatingException {
        this.populateFromXml(element);
    }

    @Deprecated
    public TableRatingContainer(String xmlText) throws RatingException {
        this.populateFromXml(xmlText);
    }

    public void populateFromXml(Element ratingElement) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        TableRatingContainer tableRatingContainer = service.createTableRatingContainer(ratingElement);
        tableRatingContainer.clone(this);
    }

    @Deprecated
    public void populateFromXml(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        TableRatingContainer tableRatingContainer = service.createTableRatingContainer(xmlText);
        tableRatingContainer.clone(this);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj != null && obj.getClass() == this.getClass() && super.equals(obj)) {
            TableRatingContainer other = (TableRatingContainer)obj;
            if (other.values == null == (this.values == null)) {
                int i;
                if (this.values != null) {
                    if (other.values.length == this.values.length) {
                        for (i = 0; i < this.values.length; ++i) {
                            if (other.values[i].equals(this.values[i])) {
                                continue;
                            }
                            break;
                        }
                    }
                } else if (other.extensionValues == null == (this.extensionValues == null)) {
                    if (this.extensionValues != null) {
                        if (other.extensionValues.length == this.extensionValues.length) {
                            for (i = 0; i < this.extensionValues.length; ++i) {
                                if (other.extensionValues[i].equals(this.extensionValues[i])) {
                                    continue;
                                }
                                break;
                            }
                        }
                    } else if (!(other.inRangeMethod == null != (this.inRangeMethod == null) || this.inRangeMethod != null && !other.inRangeMethod.equalsIgnoreCase(this.inRangeMethod) || other.outRangeLowMethod == null != (this.outRangeLowMethod == null) || this.outRangeLowMethod != null && !other.outRangeLowMethod.equalsIgnoreCase(this.outRangeLowMethod) || other.outRangeHighMethod == null != (this.outRangeHighMethod == null) || this.outRangeHighMethod != null && !other.outRangeHighMethod.equalsIgnoreCase(this.outRangeHighMethod))) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int i;
        int hashCode = this.getClass().getName().hashCode() + super.hashCode() + 3 * (this.inRangeMethod == null ? 1 : this.inRangeMethod.hashCode()) + 5 * (this.outRangeLowMethod == null ? 1 : this.outRangeLowMethod.hashCode()) + 7 * (this.outRangeHighMethod == null ? 1 : this.outRangeHighMethod.hashCode());
        if (this.values == null) {
            hashCode += 11;
        } else {
            hashCode += 13 * this.values.length;
            for (i = 0; i < this.values.length; ++i) {
                hashCode += 17 * (this.values[i] == null ? i + 1 : this.values[i].hashCode());
            }
        }
        if (this.extensionValues == null) {
            hashCode += 19;
        } else {
            hashCode += 23 * this.extensionValues.length;
            for (i = 0; i < this.extensionValues.length; ++i) {
                hashCode += 29 * (this.extensionValues[i] == null ? i + 1 : this.extensionValues[i].hashCode());
            }
        }
        return hashCode;
    }

    @Override
    public void clone(AbstractRatingContainer other) {
        int i;
        if (!(other instanceof TableRatingContainer)) {
            throw new IllegalArgumentException("Clone-to object must be a TableRatingContainer.");
        }
        super.clone(other);
        TableRatingContainer trc = (TableRatingContainer)other;
        trc.inRangeMethod = this.inRangeMethod;
        trc.outRangeLowMethod = this.outRangeLowMethod;
        trc.outRangeHighMethod = this.outRangeHighMethod;
        if (this.values == null) {
            trc.values = null;
        } else {
            trc.values = new RatingValueContainer[this.values.length];
            for (i = 0; i < this.values.length; ++i) {
                trc.values[i] = new RatingValueContainer();
                this.values[i].clone(trc.values[i]);
            }
        }
        if (this.extensionValues == null) {
            trc.extensionValues = null;
        } else {
            trc.extensionValues = new RatingValueContainer[this.extensionValues.length];
            for (i = 0; i < this.extensionValues.length; ++i) {
                trc.extensionValues[i] = new RatingValueContainer();
                this.extensionValues[i].clone(trc.extensionValues[i]);
            }
        }
    }

    @Override
    public AbstractRatingContainer getInstance() {
        return new TableRatingContainer();
    }

    @Override
    public AbstractRating newRating() throws RatingException {
        TableRating rating = new TableRating(this);
        return rating;
    }

    @Override
    @Deprecated
    public String toXml(CharSequence indent) {
        return this.toXml(indent, 0);
    }

    @Override
    @Deprecated
    public String toXml(CharSequence indent, int level) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level);
    }

    public String getLookupMethods() {
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<lookup-behaviors>\n\t<in-range>%s</in-range>\n\t<out-range-low>%s</out-range-low>\n\t<out-range-high>%s</out-range-high>\n</lookup-behaviors>", this.inRangeMethod, this.outRangeLowMethod, this.outRangeHighMethod);
    }

    public void setLookupMethods(String xml) {
        try {
            Document doc = new SAXBuilder().build((Reader)new StringReader(xml));
            Element elem = doc.getRootElement();
            if (elem.getName().equals("lookup-behaviors")) {
                this.inRangeMethod = RatingConst.RatingMethod.fromString(elem.getChildText("in-range")).name();
                this.outRangeLowMethod = RatingConst.RatingMethod.fromString(elem.getChildText("out-range-low")).name();
                this.outRangeHighMethod = RatingConst.RatingMethod.fromString(elem.getChildText("out-range-high")).name();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        boolean change = false;
        double offset = this.vdc.getCurrentOffset();
        if (offset != 0.0) {
            change = true;
            String[][] paramsAndUnits = this.getParamsAndUnits();
            String[] params = paramsAndUnits[0];
            String[] units = paramsAndUnits[1];
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].startsWith("Elev")) continue;
                int paramNum = i == params.length - 1 ? -1 : i;
                offset = this.vdc.getCurrentOffset(units[i]);
                try {
                    this.addOffset(paramNum, -offset);
                    continue;
                }
                catch (RatingException e) {
                    throw new VerticalDatumException((Throwable)e);
                }
            }
            this.vdc.toNativeVerticalDatum();
        }
        return change;
    }

    @Override
    public boolean toNGVD29() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        boolean change = false;
        if (!this.vdc.getCurrentVerticalDatum().equals("NGVD29")) {
            change = true;
            String[][] paramsAndUnits = this.getParamsAndUnits();
            String[] params = paramsAndUnits[0];
            String[] units = paramsAndUnits[1];
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].startsWith("Elev")) continue;
                int paramNum = i == params.length - 1 ? -1 : i;
                double offset1 = this.vdc.getNGVD29Offset(units[i]);
                double offset2 = this.vdc.getCurrentOffset(units[i]);
                try {
                    this.addOffset(paramNum, offset1 - offset2);
                    continue;
                }
                catch (RatingException e) {
                    throw new VerticalDatumException((Throwable)e);
                }
            }
            this.vdc.toNGVD29();
        }
        return change;
    }

    @Override
    public boolean toNAVD88() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("Object does not have vertical datum information");
        }
        boolean change = false;
        if (!this.vdc.getCurrentVerticalDatum().equals("NAVD88")) {
            change = true;
            String[][] paramsAndUnits = this.getParamsAndUnits();
            String[] params = paramsAndUnits[0];
            String[] units = paramsAndUnits[1];
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].startsWith("Elev")) continue;
                int paramNum = i == params.length - 1 ? -1 : i;
                double offset1 = this.vdc.getNAVD88Offset(units[i]);
                double offset2 = this.vdc.getCurrentOffset(units[i]);
                try {
                    this.addOffset(paramNum, offset1 - offset2);
                    continue;
                }
                catch (RatingException e) {
                    throw new VerticalDatumException((Throwable)e);
                }
            }
            this.vdc.toNAVD88();
        }
        return change;
    }

    @Override
    public void addOffset(int paramNum, double offset) throws RatingException {
        int i;
        if (this.values != null) {
            for (i = 0; i < this.values.length; ++i) {
                if (paramNum == 0) {
                    this.values[i].indValue += offset;
                    continue;
                }
                if (paramNum == -1) {
                    if (this.values[i].depTable == null) {
                        this.values[i].depValue += offset;
                        continue;
                    }
                    this.values[i].depTable.addOffset(paramNum, offset);
                    continue;
                }
                if (this.values[i].depTable == null) {
                    throw new RatingException("Invalid parameter number");
                }
                this.values[i].depTable.addOffset(paramNum - 1, offset);
            }
        }
        if (this.extensionValues != null) {
            for (i = 0; i < this.extensionValues.length; ++i) {
                if (paramNum == 0) {
                    this.extensionValues[i].indValue += offset;
                    continue;
                }
                if (paramNum == -1) {
                    if (this.extensionValues[i].depTable == null) {
                        this.extensionValues[i].depValue += offset;
                        continue;
                    }
                    this.extensionValues[i].depTable.addOffset(paramNum, offset);
                    continue;
                }
                if (this.extensionValues[i].depTable == null) {
                    throw new RatingException("Invalid parameter number");
                }
                this.extensionValues[i].depTable.addOffset(paramNum - 1, offset);
            }
        }
    }
}

