/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating.io;

import hec.data.RatingException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.TransitionalRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingSetContainer;
import hec.data.cwmsRating.io.RatingSpecContainer;
import hec.data.cwmsRating.io.RatingTemplateContainer;
import hec.data.cwmsRating.io.SourceRatingContainer;
import hec.data.cwmsRating.io.VirtualRatingContainer;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import mil.army.usace.hec.metadata.VerticalDatumException;
import org.jdom.Element;

public class TransitionalRatingContainer
extends AbstractRatingContainer {
    public transient String[] sourceRatingIds = null;
    public String[] conditions = null;
    public String[] evaluations = null;
    public SourceRatingContainer[] sourceRatings = null;

    public TransitionalRatingContainer() {
    }

    @Deprecated
    public TransitionalRatingContainer(Element ratingElement) throws RatingException {
        this.populateFromXml(ratingElement);
    }

    @Deprecated
    public TransitionalRatingContainer(String xmlText) throws RatingException {
        this.populateFromXml(xmlText);
    }

    @Deprecated
    public void populateFromXml(Element ratingElement) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        TransitionalRatingContainer transitionalRatingContainer = service.createTransitionalRatingContainer(ratingElement);
        transitionalRatingContainer.clone(this);
    }

    @Deprecated
    public void populateFromXml(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        TransitionalRatingContainer transitionalRatingContainer = service.createTransitionalRatingContainer(xmlText);
        transitionalRatingContainer.clone(this);
    }

    public void populateSourceRatings(Map<String, SortedSet<AbstractRatingContainer>> ratings, Map<String, RatingSpecContainer> specs, Map<String, RatingTemplateContainer> templates) throws RatingException {
        if (this.sourceRatingIds != null) {
            ArrayList<SourceRatingContainer> srList = new ArrayList<SourceRatingContainer>();
            for (String specId : this.sourceRatingIds) {
                SourceRatingContainer src = new SourceRatingContainer();
                srList.add(src);
                RatingSpecContainer rspc = new RatingSpecContainer();
                String[] parts = TextUtil.split((String)specId, (String)".");
                String templateId = TextUtil.join((String)".", (String[])new String[]{parts[1], parts[2]});
                specs.get(specId).clone(rspc);
                templates.get(templateId).clone(rspc);
                RatingSetContainer rsc = new RatingSetContainer();
                rsc.ratingSpecContainer = rspc;
                for (AbstractRatingContainer arc : rsc.abstractRatingContainers = ratings.get(specId).toArray(new AbstractRatingContainer[0])) {
                    if (arc instanceof VirtualRatingContainer) {
                        VirtualRatingContainer vrc = (VirtualRatingContainer)arc;
                        vrc.populateSourceRatings(ratings, specs, templates);
                        continue;
                    }
                    if (!(arc instanceof TransitionalRatingContainer)) continue;
                    TransitionalRatingContainer trrc = (TransitionalRatingContainer)arc;
                    trrc.populateSourceRatings(ratings, specs, templates);
                }
                src.rsc = rsc;
                src.units = TextUtil.split((String)src.rsc.abstractRatingContainers[0].unitsId.replace(";", ","), (String)",");
            }
            this.sourceRatings = srList.toArray(new SourceRatingContainer[0]);
        }
    }

    @Override
    public void clone(AbstractRatingContainer other) {
        int i;
        if (!(other instanceof TransitionalRatingContainer)) {
            throw new IllegalArgumentException("Clone-to object must be a TransitionalRatingContainer.");
        }
        TransitionalRatingContainer trc = (TransitionalRatingContainer)other;
        super.clone(trc);
        if (this.conditions != null) {
            trc.conditions = Arrays.copyOf(this.conditions, this.conditions.length);
        }
        if (this.evaluations != null) {
            trc.evaluations = Arrays.copyOf(this.evaluations, this.evaluations.length);
        }
        if (this.sourceRatings != null) {
            trc.sourceRatings = new SourceRatingContainer[this.sourceRatings.length];
            for (i = 0; i < this.sourceRatings.length; ++i) {
                trc.sourceRatings[i] = new SourceRatingContainer();
                this.sourceRatings[i].clone(trc.sourceRatings[i]);
            }
        }
        if (this.sourceRatingIds != null) {
            trc.sourceRatingIds = new String[this.sourceRatingIds.length];
            for (i = 0; i < this.sourceRatingIds.length; ++i) {
                trc.sourceRatingIds[i] = this.sourceRatingIds[i];
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransitionalRatingContainer that = (TransitionalRatingContainer)o;
        return Arrays.equals(this.sourceRatingIds, that.sourceRatingIds) && Arrays.equals(this.conditions, that.conditions) && Arrays.equals(this.evaluations, that.evaluations) && Arrays.equals(this.sourceRatings, that.sourceRatings);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.sourceRatingIds);
        result = 31 * result + Arrays.hashCode(this.conditions);
        result = 31 * result + Arrays.hashCode(this.evaluations);
        result = 31 * result + Arrays.hashCode(this.sourceRatings);
        return result;
    }

    @Override
    public AbstractRatingContainer clone() {
        TransitionalRatingContainer trc = new TransitionalRatingContainer();
        this.clone(trc);
        return trc;
    }

    @Override
    public AbstractRatingContainer getInstance() {
        return new TransitionalRatingContainer();
    }

    @Override
    public AbstractRating newRating() throws RatingException {
        return new TransitionalRating(this);
    }

    @Override
    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toNativeVerticalDatum();
            }
        }
        return super.toNativeVerticalDatum();
    }

    @Override
    public boolean toNGVD29() throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toNGVD29();
            }
        }
        return super.toNGVD29();
    }

    @Override
    public boolean toNAVD88() throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toNAVD88();
            }
        }
        return super.toNAVD88();
    }

    @Override
    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toVerticalDatum(datum);
            }
        }
        return super.toVerticalDatum(datum);
    }

    @Override
    public void addOffset(int paramNum, double offset) throws RatingException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.addOffset(paramNum, offset);
            }
        }
    }

    @Override
    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.setVerticalDatumInfo(xmlStr);
            }
        }
        super.setVerticalDatumInfo(xmlStr);
    }

    @Override
    @Deprecated
    public String toXml(CharSequence indent) {
        return this.toXml(indent, 0);
    }

    @Override
    @Deprecated
    public String toXml(CharSequence indent, int level) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level);
    }

    @Deprecated
    public void getSoucreRatingsXml(CharSequence indent, int level, Set<String> templateStrings, Set<String> specStrings, List<String> ratingStrings) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        service.getSourceRatingsXml(this, indent, level, templateStrings, specStrings, ratingStrings);
    }
}

