/*
 * Decompiled with CFR 0.152.
 */
package hec.data.cwmsRating.io;

import hec.data.RatingException;
import hec.data.cwmsRating.AbstractRating;
import hec.data.cwmsRating.RatingSpec;
import hec.data.cwmsRating.VirtualRating;
import hec.data.cwmsRating.io.AbstractRatingContainer;
import hec.data.cwmsRating.io.RatingContainerXmlCompatUtil;
import hec.data.cwmsRating.io.RatingSetContainer;
import hec.data.cwmsRating.io.RatingSpecContainer;
import hec.data.cwmsRating.io.RatingTemplateContainer;
import hec.data.cwmsRating.io.SourceRatingContainer;
import hec.data.cwmsRating.io.TransitionalRatingContainer;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.army.usace.hec.metadata.VerticalDatumException;
import org.jdom.Element;

public class VirtualRatingContainer
extends AbstractRatingContainer {
    public transient String[] sourceRatingIds = null;
    public SourceRatingContainer[] sourceRatings = null;
    public String connections = null;

    public VirtualRatingContainer() {
    }

    @Deprecated
    public VirtualRatingContainer(Element ratingElement) throws RatingException {
        this.populateFromXml(ratingElement);
    }

    @Deprecated
    public VirtualRatingContainer(String xmlText) throws RatingException {
        this.populateFromXml(xmlText);
    }

    @Deprecated
    public void populateFromXml(Element ratingElement) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        VirtualRatingContainer virtualRatingContainer = service.createVirtualRatingContainer(ratingElement);
        virtualRatingContainer.clone(this);
    }

    @Deprecated
    public void populateFromXml(String xmlText) throws RatingException {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        VirtualRatingContainer virtualRatingContainer = service.createVirtualRatingContainer(xmlText);
        virtualRatingContainer.clone(this);
    }

    public void populateSourceRatings(Map<String, SortedSet<AbstractRatingContainer>> ratings, Map<String, RatingSpecContainer> specs, Map<String, RatingTemplateContainer> templates) throws RatingException {
        int i;
        String[] parts;
        ArrayList<SourceRatingContainer> srList = new ArrayList<SourceRatingContainer>();
        ArrayList<String> specsToUse = new ArrayList<String>();
        HashMap<String, String> unitsBySpecId = new HashMap<String, String>();
        for (String specId : this.sourceRatingIds) {
            parts = TextUtil.split((String)specId, (String)"{");
            specId = parts[0].trim();
            unitsBySpecId.put(specId, TextUtil.split((String)parts[1], (String)"}")[0].trim());
            specsToUse.add(specId);
        }
        for (String specId : specsToUse) {
            SourceRatingContainer src = new SourceRatingContainer();
            srList.add(src);
            if (RatingSpec.isValidRatingSpecId(specId)) {
                RatingSpecContainer rspc = new RatingSpecContainer();
                parts = TextUtil.split((String)specId, (String)".");
                String string = TextUtil.join((String)".", (String[])new String[]{parts[1], parts[2]});
                specs.get(specId).clone(rspc);
                templates.get(string).clone(rspc);
                RatingSetContainer rsc = new RatingSetContainer();
                rsc.ratingSpecContainer = rspc;
                for (AbstractRatingContainer arc : rsc.abstractRatingContainers = ratings.get(specId).toArray(new AbstractRatingContainer[0])) {
                    if (arc instanceof VirtualRatingContainer) {
                        VirtualRatingContainer vrc = (VirtualRatingContainer)arc;
                        vrc.populateSourceRatings(ratings, specs, templates);
                        continue;
                    }
                    if (!(arc instanceof TransitionalRatingContainer)) continue;
                    TransitionalRatingContainer trrc = (TransitionalRatingContainer)arc;
                    trrc.populateSourceRatings(ratings, specs, templates);
                }
                src.rsc = rsc;
            } else {
                src.mathExpression = TextUtil.split((String)specId, (String)"/", (int)2)[1].trim();
            }
            String units = (String)unitsBySpecId.get(specId);
            units = units.replace(";", ",");
            parts = TextUtil.split((String)units, (String)",");
            src.units = parts;
        }
        this.sourceRatings = srList.toArray(new SourceRatingContainer[0]);
        int indParamCount = TextUtil.split((String)this.ratingSpecId, (String)",").length;
        Object[] units = new String[indParamCount + 1];
        Arrays.fill(units, null);
        Pattern connectionPattern = Pattern.compile("(I(\\d+)|R(\\d+)(I(\\d+)|D)|D)");
        Matcher[] m = new Matcher[2];
        HashSet<String> connected = new HashSet<String>();
        block11: for (String connectionPair : TextUtil.split((String)this.connections, (String)",")) {
            int matchedIdx;
            String[] parts2 = TextUtil.split((String)connectionPair, (String)"=");
            if (parts2.length != 2) {
                throw new RatingException("Invalid connection string: " + this.connections);
            }
            connected.add(parts2[0]);
            connected.add(parts2[1]);
            m[0] = connectionPattern.matcher(parts2[0]);
            m[1] = connectionPattern.matcher(parts2[1]);
            if (!m[0].matches() || !m[1].matches()) {
                throw new RatingException("Invalid connection string: " + this.connections);
            }
            int n = m[0].group(1).charAt(0) == 'I' ? 0 : (matchedIdx = m[1].group(1).charAt(0) == 'I' ? 1 : -1);
            if (matchedIdx != -1) {
                int inputIdx = Integer.parseInt(m[matchedIdx].group(2));
                int connectedIdx = (matchedIdx + 1) % 2;
                if (m[connectedIdx].group(1).charAt(0) != 'R') {
                    throw new RatingException("Invalid connection string: " + this.connections);
                }
                int ratingIdx = Integer.parseInt(m[connectedIdx].group(3));
                switch (m[connectedIdx].group(4).charAt(0)) {
                    case 'I': {
                        int ratingInput = Integer.parseInt(m[connectedIdx].group(5));
                        units[inputIdx - 1] = this.sourceRatings[ratingIdx - 1].units[ratingInput - 1];
                        break;
                    }
                    case 'D': {
                        units[inputIdx - 1] = this.sourceRatings[ratingIdx - 1].units[this.sourceRatings[ratingIdx - 1].units.length - 1];
                        break;
                    }
                    default: {
                        throw new RatingException("Invalid connection string: " + this.connections);
                    }
                }
                continue;
            }
            int n2 = m[0].group(1).charAt(0) == 'D' ? 0 : (matchedIdx = m[1].group(1).charAt(0) == 'D' ? 1 : -1);
            if (matchedIdx == -1) continue;
            int connectedIdx = (matchedIdx + 1) % 2;
            if (m[connectedIdx].group(1).charAt(0) != 'R') {
                throw new RatingException("Invalid connection string: " + this.connections);
            }
            int ratingIdx = Integer.parseInt(m[connectedIdx].group(3));
            switch (m[connectedIdx].group(4).charAt(0)) {
                case 'I': {
                    int ratingInput = Integer.parseInt(m[connectedIdx].group(5));
                    units[indParamCount] = this.sourceRatings[ratingIdx - 1].units[ratingInput - 1];
                    continue block11;
                }
                case 'D': {
                    units[indParamCount] = this.sourceRatings[ratingIdx - 1].units[this.sourceRatings[ratingIdx - 1].units.length - 1];
                    continue block11;
                }
                default: {
                    throw new RatingException("Invalid connection string: " + this.connections);
                }
            }
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (i = 0; i < units.length; ++i) {
            if (units[i] != null) continue;
            linkedList.add(i);
        }
        block13: for (i = 0; i < this.sourceRatings.length; ++i) {
            for (int j = 0; j < this.sourceRatings[i].units.length - 1; ++j) {
                if (connected.contains("R" + (i + 1) + "I" + (j + 1))) continue;
                units[((Integer)linkedList.get((int)0)).intValue()] = this.sourceRatings[i].units[j];
                linkedList.remove();
                if (linkedList.peek() == null) break block13;
            }
        }
        if (linkedList.peek() != null) {
            for (i = 0; i < this.sourceRatings.length; ++i) {
                if (connected.contains("R" + (i + 1) + "D")) continue;
                units[((Integer)linkedList.get((int)0)).intValue()] = this.sourceRatings[i].units[this.sourceRatings[i].units.length - 1];
                if (linkedList.peek() == null) break;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < units.length; ++i2) {
            sb.append(i2 == 0 ? "" : (i2 == units.length - 1 ? ";" : ",")).append((String)units[i2]);
        }
        this.unitsId = sb.toString();
    }

    @Override
    public void clone(AbstractRatingContainer other) {
        int i;
        if (!(other instanceof VirtualRatingContainer)) {
            throw new IllegalArgumentException("Clone-to object must be a VirtualRatingContainer.");
        }
        VirtualRatingContainer vrc = (VirtualRatingContainer)other;
        super.clone(vrc);
        vrc.connections = this.connections;
        if (this.sourceRatings != null) {
            vrc.sourceRatings = new SourceRatingContainer[this.sourceRatings.length];
            for (i = 0; i < this.sourceRatings.length; ++i) {
                vrc.sourceRatings[i] = new SourceRatingContainer();
                this.sourceRatings[i].clone(vrc.sourceRatings[i]);
            }
        }
        if (this.sourceRatingIds != null) {
            vrc.sourceRatingIds = new String[this.sourceRatingIds.length];
            for (i = 0; i < this.sourceRatingIds.length; ++i) {
                vrc.sourceRatingIds[i] = this.sourceRatingIds[i];
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualRatingContainer that = (VirtualRatingContainer)o;
        return Arrays.equals(this.sourceRatingIds, that.sourceRatingIds) && Arrays.equals(this.sourceRatings, that.sourceRatings) && Objects.equals(this.connections, that.connections);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.connections);
        result = 31 * result + Arrays.hashCode(this.sourceRatingIds);
        result = 31 * result + Arrays.hashCode(this.sourceRatings);
        return result;
    }

    @Override
    public AbstractRatingContainer clone() {
        VirtualRatingContainer vrc = new VirtualRatingContainer();
        this.clone(vrc);
        return vrc;
    }

    @Override
    public AbstractRatingContainer getInstance() {
        return new VirtualRatingContainer();
    }

    @Override
    public AbstractRating newRating() throws RatingException {
        VirtualRating rating = new VirtualRating(this);
        return rating;
    }

    @Override
    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toNativeVerticalDatum();
            }
        }
        return super.toNativeVerticalDatum();
    }

    @Override
    public boolean toNGVD29() throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toNGVD29();
            }
        }
        return super.toNGVD29();
    }

    @Override
    public boolean toNAVD88() throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toNAVD88();
            }
        }
        return super.toNAVD88();
    }

    @Override
    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.toVerticalDatum(datum);
            }
        }
        return super.toVerticalDatum(datum);
    }

    @Override
    public void addOffset(int paramNum, double offset) throws RatingException {
        throw new RatingException("The addOffset(int, double) method is not available for virtual ratings");
    }

    @Override
    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        for (SourceRatingContainer src : this.sourceRatings) {
            if (src.rsc == null) continue;
            for (AbstractRatingContainer arc : src.rsc.abstractRatingContainers) {
                if (arc.vdc == null) continue;
                arc.setVerticalDatumInfo(xmlStr);
            }
        }
        super.setVerticalDatumInfo(xmlStr);
    }

    @Override
    public String toXml(CharSequence indent) {
        return this.toXml(indent, 0);
    }

    @Override
    public String toXml(CharSequence indent, int level) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        return service.toXml(this, indent, level);
    }

    public void getSoucreRatingsXml(CharSequence indent, int level, Set<String> templateStrings, Set<String> specStrings, List<String> ratingStrings) {
        RatingContainerXmlCompatUtil service = RatingContainerXmlCompatUtil.getInstance();
        service.getSourceRatingsXml(this, indent, level, templateStrings, specStrings, ratingStrings);
    }
}

