/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.script.gui;

import com.google.common.flogger.FluentLogger;
import hec.client.LookAndFeel;
import hec.io.JavaDocParser;
import hec.lang.annotation.Scriptable;
import hec.script.ScriptEngine;
import hec.script.gui.ITreeBuilder;
import hec.script.gui.ScriptTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mil.army.usace.hec.script.gui.FolderNode;
import mil.army.usace.hec.script.gui.JDocHelpDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import rma.lang.Modifiable;
import rma.swing.EditableComponent;
import rma.swing.EnabledJPanel;
import rma.swing.FormManagementListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.util.Compare;
import rma.util.MethodCompare;
import rma.util.RMAIO;
import rma.util.RMASort;
import rma.util.RMAUtil;

public class AbstractScriptBuilderPanel
extends EnabledJPanel {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    public static final String GET_TIME_SERIES_METHOD = "getTimeSeries";
    public static final String GET_STATE_VARIABLE_METHOD = "getStateVariable";
    public static final String FUNCTION_OPT = "Function";
    public static final String TABLE_LOOKUP_OPT = "Table Lookup";
    public static final String NEW_NODE = "node";
    public static final String NODE_TYPE_ATTR = "type";
    public static final String NODE_NAME_ATTR = "name";
    public static final String TOOL_TIP_ATTR = "tooltip";
    public static final String CLASS_ATTR = "Class";
    public static final String OBJ_NAME_ATTR = "objName";
    public static final String M = "getScriptableMethodNames";
    protected DraggableTree _tree;
    protected RmaJTextField _functionText;
    protected ScriptTextArea _scriptText;
    protected RTextScrollPane _scriptTextScrollPane;
    protected JButton _insertIntoScriptBtn;
    protected JButton _compileScriptBtn;
    protected JButton _runScriptBtn;
    protected JLabel _functionInfoText;
    protected JSplitPane _splitter;
    private ReflectMultiListener _listener;
    private JPopupMenu _popupMenu;
    private JMenuItem _copyMenuItem;
    private JMenuItem _cutMenuItem;
    private JMenuItem _pasteMenuItem;
    private JMenuItem _selectAllMenuItem;
    private JCheckBoxMenuItem _lineWrapMenuItem;
    protected JDocHelpDialog _helpDialog;
    protected List _excludedMethods = new ArrayList();
    private boolean _listenersAdded;
    private Document _oldDoc;
    private JPanel _rightPanel;
    private Runnable _caretFixer;
    private File _externalScriptFile;
    private long _lastModTime;
    protected JButton _externalEditorBtn;
    private WindowFocusListener _focusListener;
    private Action _copyAction;
    private Action _cutAction;
    private Action _pasteAction;
    private Action _selectAllAction;
    private Action _printAction;
    private JPanel _buttonPanel;
    private SearchListener _searchListener;
    private FindDialog _findDlg;
    private ReplaceDialog _replaceDlg;

    public AbstractScriptBuilderPanel() {
        this.buildControls();
        this.buildActions();
        this._excludedMethods.add("getFieldObject");
        this._excludedMethods.add("setFieldObject");
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._listener = new ReflectMultiListener();
        this._splitter = new JSplitPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this._splitter, gbc);
        EnabledJPanel leftPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._tree = new DraggableTree();
        this._tree.setRootVisible(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        leftPanel.add((Component)new JScrollPane(this._tree), gbc);
        this._insertIntoScriptBtn = new JButton("Insert in Script");
        this._insertIntoScriptBtn.setMnemonic('I');
        this._insertIntoScriptBtn.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        leftPanel.add((Component)this._insertIntoScriptBtn, gbc);
        this._splitter.setLeftComponent((Component)leftPanel);
        this._rightPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._functionText = new RmaJTextField(){

            public void setEnabled(boolean b) {
                if (!b) {
                    super.setEnabled(b);
                }
            }
        };
        this._functionText.setEditable(false);
        this._functionText.setModifiable(false);
        this._functionText.setToolTipText("Method Definition");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._rightPanel.add((Component)this._functionText, gbc);
        this._scriptText = new ScriptTextArea(25, 60){

            public String getToolTipText(MouseEvent e) {
                return AbstractScriptBuilderPanel.this.getScriptTextToolTip(e);
            }

            public int getTabSize() {
                return 4;
            }
        };
        this._scriptText.setWrapStyleWord(true);
        this._scriptText.setToolTipText("sdlfj");
        this._scriptText.setDragEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractScriptBuilderPanel.this._scriptText.setTabSize(4);
                AbstractScriptBuilderPanel.this._scriptText.updateUI();
            }
        });
        this._scriptText.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equalsIgnoreCase("tabSize")) {
                    AbstractScriptBuilderPanel.this._scriptText.updateUI();
                }
            }
        });
        this._scriptTextScrollPane = new RTextScrollPane((RTextArea)this._scriptText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._rightPanel.add((Component)this._scriptTextScrollPane, gbc);
        this._buttonPanel = this.buildButtons();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this._rightPanel.add((Component)this._buttonPanel, gbc);
        this._splitter.setRightComponent(this._rightPanel);
        this.addListeners();
        this.updateMenus();
    }

    private void initFindReplaceDialogs() {
        Window w;
        if (this._findDlg == null && (w = SwingUtilities.windowForComponent((Component)((Object)this))) instanceof JDialog) {
            this._findDlg = new FindDialog((Dialog)((JDialog)w), this._searchListener);
            this._replaceDlg = new ReplaceDialog((Dialog)((JDialog)w), this._searchListener);
            SearchContext context = this._findDlg.getSearchContext();
            this._replaceDlg.setSearchContext(context);
        }
    }

    protected JPanel buildButtons() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this._compileScriptBtn = new JButton("Compile Script");
        this._compileScriptBtn.setMnemonic('C');
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        buttonPanel.add((Component)this._compileScriptBtn, gbc);
        this._externalEditorBtn = new JButton("Launch Editor");
        this._externalEditorBtn.setMnemonic('E');
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        if (System.getProperty("ScriptEditorExe") != null) {
            buttonPanel.add((Component)this._externalEditorBtn, gbc);
        }
        this._runScriptBtn = new JButton("Run Script");
        this._runScriptBtn.setMnemonic('R');
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        if (System.getProperty("RunScriptBtn") != null) {
            buttonPanel.add((Component)this._runScriptBtn, gbc);
        }
        return buttonPanel;
    }

    protected void buildActions() {
        this._copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.copy();
            }
        };
        this._copyAction.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/Copy.gif"));
        this._cutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.cut();
            }
        };
        this._cutAction.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/Cut.gif"));
        this._pasteAction = new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.paste();
            }
        };
        this._pasteAction.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/paste.gif"));
        this._selectAllAction = new AbstractAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.selectAll();
            }
        };
        this._printAction = new AbstractAction("Print"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.print();
            }
        };
        this._printAction.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/Print.gif"));
    }

    public void addActionButton(Action action) {
        if (action == null) {
            return;
        }
        int gridx = this._buttonPanel.getComponentCount();
        JButton btn = new JButton(action);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._buttonPanel.add((Component)btn, gbc);
    }

    public RSyntaxTextArea getScriptTextArea() {
        return this._scriptText;
    }

    public JTree getTree() {
        return this._tree;
    }

    protected void addListeners() {
        if (this._listenersAdded) {
            return;
        }
        this._searchListener = new SearchListener(){

            public void searchEvent(SearchEvent e) {
                if (e.getType() == SearchEvent.Type.REPLACE_ALL) {
                    SearchResult result = SearchEngine.replaceAll((RTextArea)AbstractScriptBuilderPanel.this._scriptText, (SearchContext)e.getSearchContext());
                    if (result.getCount() > 0) {
                        AbstractScriptBuilderPanel.this.setModified(true);
                    }
                } else if (e.getType() == SearchEvent.Type.REPLACE) {
                    SearchResult result = SearchEngine.replace((RTextArea)AbstractScriptBuilderPanel.this._scriptText, (SearchContext)e.getSearchContext());
                    if (result.getCount() > 0) {
                        AbstractScriptBuilderPanel.this.setModified(true);
                    }
                } else if (e.getType() == SearchEvent.Type.FIND) {
                    SearchEngine.find((JTextArea)((Object)AbstractScriptBuilderPanel.this._scriptText), (SearchContext)e.getSearchContext());
                }
            }

            public String getSelectedText() {
                return AbstractScriptBuilderPanel.this._scriptText.getSelectedText();
            }
        };
        this._insertIntoScriptBtn.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._insertIntoScriptBtn, "insertNodeInScript"));
        this._compileScriptBtn.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._compileScriptBtn, "compileScript"));
        this._runScriptBtn.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._runScriptBtn, "runScript"));
        AbstractAction helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.displayTreeHelp();
            }
        };
        this._tree.getActionMap().put("help", helpAction);
        this._tree.getInputMap().put(KeyStroke.getKeyStroke(112, 0), "help");
        AbstractAction findAction = new AbstractAction("Find"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.findAction();
            }
        };
        this._scriptText.getActionMap().put("Find", findAction);
        this._scriptText.getInputMap().put(KeyStroke.getKeyStroke("control F"), "Find");
        AbstractAction replaceAction = new AbstractAction("Replace"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.replaceAction();
            }
        };
        this._scriptText.getActionMap().put("Replace", replaceAction);
        this._scriptText.getInputMap().put(KeyStroke.getKeyStroke("control R"), "Replace");
        AbstractAction goToLineAction = new AbstractAction("GoToLine"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.gotoLineAction();
            }
        };
        this._scriptText.getActionMap().put("GoToLine", goToLineAction);
        this._scriptText.getInputMap().put(KeyStroke.getKeyStroke("control L"), "GoToLine");
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ScriptTreeNode node = AbstractScriptBuilderPanel.this._tree.getSelectedNode();
                    if (node == null) {
                        return;
                    }
                    AbstractScriptBuilderPanel.this.insertNodeInScript();
                }
            }
        });
        this._externalEditorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptBuilderPanel.this.launchExternalEditor();
            }
        });
        this._rightPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbstractScriptBuilderPanel.this.launchExternalEditor();
            }
        });
        this._listenersAdded = true;
    }

    protected void gotoLineAction() {
        String line = JOptionPane.showInputDialog((Component)((Object)this), "Enter line-number to (1.." + this._scriptText.getLineCount() + ")", "Go To Line", -1);
        if (line != null) {
            try {
                int ln = Integer.parseInt(line) - 1;
                if (ln >= 0 && ln < this._scriptText.getLineCount()) {
                    this._scriptText.scrollRectToVisible(this._scriptText.modelToView(this._scriptText.getLineStartOffset(ln)));
                    this._scriptText.setCaretPosition(this._scriptText.getLineStartOffset(ln));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void findAction() {
        if (this._findDlg == null) {
            this.initFindReplaceDialogs();
        }
        if (this._findDlg != null) {
            String selText = this._scriptText.getSelectedText();
            if (selText != null && !selText.isEmpty()) {
                this._findDlg.setSearchString(selText);
            }
            this._findDlg.setLocationRelativeTo((Component)((Object)this));
            this._findDlg.setVisible(true);
        }
    }

    public void replaceAction() {
        if (this._replaceDlg == null) {
            this.initFindReplaceDialogs();
        }
        if (this._replaceDlg != null) {
            String selText = this._scriptText.getSelectedText();
            if (selText != null && !selText.isEmpty()) {
                this._replaceDlg.setSearchString(selText);
            }
            this._replaceDlg.setLocationRelativeTo((Component)((Object)this));
            this._replaceDlg.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchExternalEditor() {
        Process proc;
        BufferedWriter writer;
        String editor = System.getProperty("ScriptEditorExe");
        if (editor == null) {
            return;
        }
        if (this._externalScriptFile != null) {
            return;
        }
        File f = null;
        try {
            f = File.createTempFile("script", ".py");
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Exception creating temporary file ");
            return;
        }
        f.deleteOnExit();
        try {
            writer = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Exception opening temporary file " + f.getAbsolutePath());
            return;
        }
        String txt = this._scriptText.getText();
        try {
            writer.write(txt);
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Exception writing to temporary file " + f.getAbsolutePath());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        this._lastModTime = f.lastModified();
        this._externalScriptFile = f;
        Object[] cmd = new String[]{editor, f.getAbsolutePath()};
        try {
            proc = Runtime.getRuntime().exec((String[])cmd);
        }
        catch (IOException e1) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e1)).log("Exception launching external editor " + Arrays.toString(cmd));
            return;
        }
        this._externalEditorBtn.setEnabled(false);
        this.waitForProcess(proc);
        Window w = SwingUtilities.windowForComponent((Component)((Object)this));
        this._focusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (AbstractScriptBuilderPanel.this._externalScriptFile == null) {
                    return;
                }
                long lastMod = AbstractScriptBuilderPanel.this._externalScriptFile.lastModified();
                if (lastMod > AbstractScriptBuilderPanel.this._lastModTime) {
                    AbstractScriptBuilderPanel.this.loadScriptFromExternalFile();
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        };
        w.addWindowFocusListener(this._focusListener);
    }

    private void waitForProcess(final Process proc) {
        Thread t = new Thread("Waiting for Editor Thread"){

            @Override
            public void run() {
                try {
                    int rv = proc.waitFor();
                    System.out.println("run:editor exited with a " + rv);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            long lastMod = AbstractScriptBuilderPanel.this._externalScriptFile.lastModified();
                            if (lastMod > AbstractScriptBuilderPanel.this._lastModTime) {
                                AbstractScriptBuilderPanel.this.loadScriptFromExternalFile();
                            }
                            AbstractScriptBuilderPanel.this._externalScriptFile = null;
                            AbstractScriptBuilderPanel.this._externalEditorBtn.setEnabled(true);
                            Window w = SwingUtilities.windowForComponent((Component)((Object)AbstractScriptBuilderPanel.this));
                            w.removeWindowFocusListener(AbstractScriptBuilderPanel.this._focusListener);
                        }
                    });
                }
                catch (InterruptedException e) {
                    System.out.println("run:InterruptedException " + e);
                }
            }
        };
        t.setPriority(3);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadScriptFromExternalFile() {
        BufferedReader reader;
        if (this._externalScriptFile == null) {
            return;
        }
        try {
            reader = new BufferedReader(new FileReader(this._externalScriptFile));
        }
        catch (FileNotFoundException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Exception opening external script file " + this._externalScriptFile);
            return;
        }
        int caretPos = this._scriptText.getCaretPosition();
        StringBuilder buf = new StringBuilder((int)this._externalScriptFile.length());
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Exception reading external script file " + this._externalScriptFile);
            return;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        if (buf.length() > 0) {
            String s = buf.toString();
            this._scriptText.setText(s);
            if (caretPos < s.length()) {
                try {
                    this._scriptText.setCaretPosition(caretPos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._lastModTime = this._externalScriptFile.lastModified();
        }
    }

    public void undo() {
        this._scriptText.undoLastAction();
        this.updateMenus();
    }

    public void redo() {
        this._scriptText.redoLastAction();
        this.updateMenus();
    }

    public void discardAllEdits() {
        this._scriptText.discardAllEdits();
        this.updateMenus();
    }

    protected void updateMenus() {
    }

    protected void popupMenu(Point p) {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
            this._copyMenuItem = new JMenuItem(this._copyAction);
            this._popupMenu.add(this._copyMenuItem);
            this._cutMenuItem = new JMenuItem(this._cutAction);
            this._popupMenu.add(this._cutMenuItem);
            this._pasteMenuItem = new JMenuItem(this._pasteAction);
            this._popupMenu.add(this._pasteMenuItem);
            this._selectAllMenuItem = new JMenuItem(this._selectAllAction);
            this._popupMenu.add(this._selectAllMenuItem);
            this._popupMenu.addSeparator();
            this._lineWrapMenuItem = new JCheckBoxMenuItem("WordWrap");
            this._lineWrapMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._lineWrapMenuItem, "lineWrapAction"));
            this._popupMenu.add(this._lineWrapMenuItem);
        }
        this._lineWrapMenuItem.setSelected(this._scriptText.getLineWrap());
        boolean enabled = this._scriptText.getSelectedText() != null;
        this._copyAction.setEnabled(enabled);
        this._cutAction.setEnabled(enabled);
        enabled = this._scriptText.isEditable();
        if (!enabled) {
            this._cutAction.setEnabled(false);
            this._pasteAction.setEnabled(false);
        }
        this._popupMenu.show((Component)((Object)this._scriptText), p.x, p.y);
    }

    protected void copy() {
        this._scriptText.copy();
    }

    protected void cut() {
        this._scriptText.cut();
    }

    protected void paste() {
        this._scriptText.paste();
    }

    protected void selectAll() {
        this._scriptText.selectAll();
    }

    protected void print() {
        try {
            this._scriptText.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
    }

    protected void lineWrapAction() {
        this._scriptText.setLineWrap(this._lineWrapMenuItem.isSelected());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void displayTreeHelp() {
        ScriptTreeNode node = this._tree.getSelectedNode();
        String title = null;
        String helpText = null;
        File theFile = null;
        if (node == null) {
            TreePath path = this._tree.getSelectionPath();
            if (path == null) {
                ((FluentLogger.Api)logger.atFine()).log("displayTreeHelp: no path selected");
                return;
            }
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof FolderNode)) return;
            FolderNode fnode = (FolderNode)obj;
            String clsName = fnode.getClassname();
            if (clsName == null) {
                ((FluentLogger.Api)logger.atFine()).log("displayTreeHelp: no class name");
                return;
            }
            try {
                JavaDocParser parser = JavaDocParser.createParser(Class.forName(clsName));
                theFile = parser.getJavaDocFile();
                title = clsName;
            }
            catch (ClassNotFoundException ncfe) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)ncfe)).log("Exception finding class for " + clsName);
                return;
            }
        } else {
            title = node.toString();
            helpText = node.getHelpText();
        }
        if (title == null || helpText == null && theFile == null) {
            return;
        }
        if (this._helpDialog == null) {
            Window w = SwingUtilities.windowForComponent((Component)((Object)this));
            this._helpDialog = w instanceof Dialog ? new JDocHelpDialog((Dialog)w) : new JDocHelpDialog((Frame)w);
        }
        if (helpText != null) {
            this._helpDialog.pushJDoc(title, helpText);
        } else {
            this._helpDialog.pushJDoc(title, theFile);
        }
        this._helpDialog.setVisible(true);
    }

    public void clearScriptText() {
        this._scriptText.setText("");
    }

    public void setScriptText(String text) {
        if (text == null) {
            this.clearScriptText();
            return;
        }
        this._scriptText.setText(text);
        this._scriptText.discardAllEdits();
        this.fixCaretPosition();
    }

    public boolean getConvertTabsToSpaces() {
        return this._scriptText.getTabsEmulated();
    }

    public void setConvertTabsToSpaces(boolean convert) {
        this._scriptText.setTabsEmulated(convert);
        if (convert) {
            this._scriptText.convertTabsToSpaces();
        }
    }

    public void setShowWhiteSpace(boolean showWhitespace) {
        this._scriptText.setWhitespaceVisible(showWhitespace);
        this._scriptText.setPaintTabLines(showWhitespace);
    }

    public boolean getShowWhitespace() {
        return this._scriptText.isWhitespaceVisible();
    }

    public void setScriptTextReader(Reader reader) {
        if (reader == null) {
            this.clearScriptText();
            return;
        }
        try {
            this._scriptText.read(reader, null);
            this._scriptText.discardAllEdits();
        }
        catch (IOException ioe) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)ioe)).log("Exception reading file ");
        }
        this.fixCaretPosition();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractScriptBuilderPanel.this._scriptText.setCaretPosition(0);
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).withCause((Throwable)e)).log("Exception setting script caret position");
                }
            }
        });
    }

    protected void fixCaretPosition() {
        if (this._caretFixer == null) {
            this._caretFixer = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractScriptBuilderPanel.this._scriptText.setCaretPosition(0);
                    }
                    catch (Exception e) {
                        ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).withCause((Throwable)e)).log("Exception setting script caret position");
                    }
                }
            };
        }
        EventQueue.invokeLater(this._caretFixer);
    }

    public String getScriptText() {
        if (this._scriptText.getTabsEmulated()) {
            this._scriptText.convertTabsToSpaces();
        }
        return this._scriptText.getText();
    }

    protected void addPublicMethods(DefaultMutableTreeNode child, Class cls, String objName) {
        Class current = cls;
        ArrayList children = new ArrayList(50);
        this.addConstructors(child, cls, objName);
        ArrayList constants = new ArrayList();
        try {
            do {
                this.addPublicMethods(children, current, objName);
                current = current.getSuperclass();
                this.addConstants(child, cls, cls.getName(), constants);
            } while (current != null && !Object.class.equals(current) && !"Object".equals(current.getName()) && !current.getName().startsWith("java") && current != null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        RMASort.quickSort(children);
        int size = children.size();
        for (int i = 0; i < children.size(); ++i) {
            child.add((MutableTreeNode)children.get(i));
        }
    }

    protected void addConstructors(DefaultMutableTreeNode node, Class cls, String objName) {
        if (node == null || cls == null) {
            return;
        }
        JavaDocParser jdocParser = JavaDocParser.createParser((Class)cls);
        Constructor<?>[] ctors = cls.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Constructor<?> ctor = ctors[i];
            String name = ctor.getName();
            String toolTip = jdocParser.getContructorSyntax(ctor);
            String jDocUrl = jdocParser.getJavaDocUrl(ctor);
            String helpText = jdocParser.getJavaDoc(ctor);
            if (!ctor.isAnnotationPresent(Scriptable.class) && !cls.isAnnotationPresent(Scriptable.class)) continue;
            if (toolTip == null) {
                // empty if block
            }
            if (helpText == null) {
                helpText = toolTip;
            }
            if (!ctor.isAnnotationPresent(Scriptable.class) && !cls.isAnnotationPresent(Scriptable.class)) continue;
            String methodCall = JavaDocParser.getConstructorCall(ctor);
            node.add((MutableTreeNode)new ScriptTreeNode((Object)methodCall, methodCall, toolTip, jDocUrl, objName));
        }
    }

    private void addPublicMethods(List childList, Class cls, String objName) {
        if (childList == null || cls == null) {
            return;
        }
        JavaDocParser jdocParser = JavaDocParser.createParser((Class)cls);
        Object[] methods = cls.getDeclaredMethods();
        RMASort.quickSort((Object[])methods, (boolean)true, (Compare)new MethodCompare());
        String clsName = cls.getName();
        int idx = clsName.lastIndexOf(46);
        if (idx > -1) {
            clsName = clsName.substring(idx + 1);
        }
        for (int i = 0; i < methods.length; ++i) {
            Object method = methods[i];
            if (!Modifier.isPublic(((Method)method).getModifiers()) || this._excludedMethods.contains(((Method)method).getName())) continue;
            String methodCall = JavaDocParser.getMethodCall((Method)method);
            String javaDoc = jdocParser.getJavaDoc((Method)method);
            String methodSyntax = javaDoc == null ? methodCall : JavaDocParser.getMethodSyntaxFromJavaDoc((String)javaDoc);
            Object toolTip = methodSyntax;
            String helpText = javaDoc;
            String jDocUrl = jdocParser.getJavaDocUrl((Method)method);
            if (toolTip == null) {
                String retType = JavaDocParser.getTypeName(((Method)method).getReturnType());
                toolTip = "void".equalsIgnoreCase(retType) ? "<html><>Method returns <b>void</b>" : "<html><>Method returns a <b>" + retType + "</b>";
                if (((Method)method).getExceptionTypes().length > 0) {
                    toolTip = (String)toolTip + "<br>" + AbstractScriptBuilderPanel.getExceptions((Method)method);
                }
                toolTip = (String)toolTip + "</html>";
            }
            if (helpText == null) {
                helpText = toolTip;
            }
            if (!((AccessibleObject)method).isAnnotationPresent(Scriptable.class) && !cls.isAnnotationPresent(Scriptable.class)) continue;
            String prefix = objName;
            if (Modifier.isStatic(((Method)method).getModifiers())) {
                prefix = clsName;
            }
            childList.add(new ScriptTreeNode((Object)methodCall, methodCall, (String)toolTip, jDocUrl, prefix));
        }
    }

    protected void addConstants(DefaultMutableTreeNode child, Class cls, String objName, List constants) {
        Field[] fields = cls.getDeclaredFields();
        JavaDocParser jdocParser = JavaDocParser.createParser((Class)cls);
        for (int i = 0; i < fields.length; ++i) {
            String name;
            Field field = fields[i];
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || constants.contains(name = field.getName())) continue;
            Object toolTip = jdocParser.getFieldSyntax(field);
            String helpText = jdocParser.getJavaDoc(field);
            String jDocUrl = jdocParser.getJavaDocUrl(field);
            if (toolTip == null) {
                String retType = JavaDocParser.getTypeName(field.getType());
                toolTip = "void".equalsIgnoreCase(retType) ? "<html><>Field is a <b>void</b>" : "<html><>Field " + name + " is a <b>" + retType + "</b>";
                toolTip = (String)toolTip + "</html>";
            }
            if (helpText == null) {
                helpText = toolTip;
            }
            if (helpText != null && !helpText.contains("Scriptable API")) continue;
            String fieldCall = name;
            constants.add(name);
            child.add((MutableTreeNode)new ScriptTreeNode((Object)name, fieldCall, (String)toolTip, jDocUrl, objName));
        }
    }

    protected void expandTopLevel() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        Enumeration<TreeNode> kids = root.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)kids.nextElement();
            this._tree.expandPath(new TreePath(kid.getPath()));
        }
    }

    public boolean loadTree(String configFileName) {
        this.createTreeBuilder(configFileName).buildTree();
        this.expandTopLevel();
        return true;
    }

    protected static String getExceptions(Method m) {
        Class<?>[] exceptions = m.getExceptionTypes();
        if (exceptions.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(" throws <b>");
            for (int k = 0; k < exceptions.length; ++k) {
                sb.append(exceptions[k].getName());
                if (k >= exceptions.length - 1) continue;
                sb.append("</b>,<b>");
            }
            sb.append("</b>");
            return sb.toString();
        }
        return "";
    }

    protected String getScriptTextToolTip(MouseEvent e) {
        int origPos = this._scriptText.viewToModel(e.getPoint());
        if (origPos > -1) {
            char c;
            String s;
            int pos = origPos;
            int start = -1;
            int end = -1;
            while (pos > 0) {
                try {
                    s = this._scriptText.getText(pos, 1);
                }
                catch (BadLocationException ble) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).withCause((Throwable)ble)).log("Exception getting text");
                    break;
                }
                c = s.charAt(0);
                if (!Character.isLetter(c)) break;
                start = --pos;
            }
            pos = origPos;
            int length = this._scriptText.getText().length();
            while (pos < length) {
                try {
                    s = this._scriptText.getText(pos, 1);
                }
                catch (BadLocationException ble) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).withCause((Throwable)ble)).log("Exception getting text");
                    break;
                }
                c = s.charAt(0);
                if (!Character.isLetter(c)) break;
                end = ++pos;
            }
            if (start == -1 || end == -1) {
                return null;
            }
            try {
                String func = this._scriptText.getText(start, end - start);
                if (func.startsWith("get")) {
                    return "<html>returns an Object of type <b>" + func.substring(3) + "</b></html>";
                }
                return null;
            }
            catch (BadLocationException ble) {
                return null;
            }
        }
        return null;
    }

    protected void compileScript() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (ScriptEngine.engine().compile(this._scriptText.getText(), (Component)((Object)this._scriptText)) == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Script Compiled Successfully", "", 1);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void insertNodeInScript() {
        ScriptTreeNode lNode = this._tree.getSelectedNode();
        if (lNode == null) {
            return;
        }
        String s = lNode.getFunctionString();
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(new StringSelection(s), null);
        this._scriptText.paste();
    }

    private void expandAllTreeNodes() {
        for (int row = 0; row < this._tree.getRowCount(); ++row) {
            this._tree.expandRow(row);
        }
    }

    public boolean isModified() {
        return this._scriptText.isModified();
    }

    public void setModified(boolean modified) {
        this._scriptText.setModified(modified);
    }

    public ITreeBuilder createTreeBuilder(String fileName) {
        return new TreeBuilder(fileName);
    }

    @Deprecated
    public void setUseAnnotations(boolean useAnnotations) {
    }

    public boolean usingAnnotations() {
        return true;
    }

    public Action getCopyAction() {
        return this._copyAction;
    }

    public Action getCutAction() {
        return this._cutAction;
    }

    public Action getPasteAction() {
        return this._pasteAction;
    }

    public Action getSelectAllAction() {
        return this._selectAllAction;
    }

    public Action getPrintAction() {
        return this._printAction;
    }

    public JPanel getRightPanel() {
        return this._rightPanel;
    }

    public boolean runScript() {
        if (this._scriptText.getText() == null) {
            return false;
        }
        String scriptName = "";
        System.out.println("runScript: running :" + scriptName);
        try {
            int rv = ScriptEngine.engine().execute(this._scriptText.getText(), System.getProperty("user.name"), scriptName, null, true);
            return rv == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        LookAndFeel.setLookAndFeel();
        AbstractScriptBuilderPanel panel = new AbstractScriptBuilderPanel();
        panel.loadTree(args[0]);
        frame.getContentPane().add((Component)((Object)panel));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public class DraggableTree
    extends JTree
    implements DragGestureListener,
    DragSourceListener,
    TreeSelectionListener {
        protected TreePath _selectedTreePath = null;
        protected ScriptTreeNode _selectedNode = null;
        private DragSource _dragSource = null;
        private Action _copyAction;

        public DraggableTree() {
            this.addTreeSelectionListener(this);
            this._dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dgr = this._dragSource.createDefaultDragGestureRecognizer(this, 1, this);
            dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
            this.setToolTipText("");
            this._copyAction = new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptTreeNode node = DraggableTree.this.getSelectedNode();
                    if (node == null) {
                        return;
                    }
                    String fs = node.getFunctionString();
                    if (fs == null) {
                        return;
                    }
                    Clipboard cb = DraggableTree.this.getToolkit().getSystemClipboard();
                    StringSelection s = new StringSelection(fs);
                    cb.setContents(s, s);
                }
            };
            KeyStroke keystroke = KeyStroke.getKeyStroke(67, 2);
            this._copyAction.putValue("AcceleratorKey", keystroke);
            this.getInputMap().put(keystroke, "copy");
            this.getActionMap().put("copy", this._copyAction);
            this.addListeners();
        }

        public void addListeners() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if ((e.isMetaDown() || SwingUtilities.isRightMouseButton(e)) && (row = DraggableTree.this.getRowForLocation(e.getX(), e.getY())) != -1) {
                        DraggableTree.this.setSelectionRow(row);
                        ScriptTreeNode node = DraggableTree.this.getSelectedNode();
                        if (node == null) {
                            return;
                        }
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(DraggableTree.this._copyAction);
                        popup.show(DraggableTree.this, e.getX(), e.getY());
                    }
                }
            });
        }

        public ScriptTreeNode getSelectedNode() {
            return this._selectedNode;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            DragSourceContext context = dsde.getDragSourceContext();
            int myaction = dsde.getDropAction();
            if ((myaction & 2) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            this._selectedTreePath = evt.getNewLeadSelectionPath();
            if (this._selectedTreePath == null) {
                this._selectedNode = null;
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._selectedTreePath.getLastPathComponent();
            this._selectedNode = node instanceof ScriptTreeNode ? (ScriptTreeNode)node : null;
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            DragSourceContext context = dsde.getDragSourceContext();
            int myaction = dsde.getDropAction();
            if ((myaction & 2) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
            DragSourceContext context = dsde.getDragSourceContext();
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            ScriptTreeNode dragNode = this.getSelectedNode();
            if (dragNode != null) {
                ScriptTreeNode lnode = dragNode;
                String funcString = lnode.getFunctionString();
                if (funcString == null) {
                    return;
                }
                StringSelection transferable = new StringSelection(funcString);
                if (transferable == null) {
                    return;
                }
                Cursor cursor = DragSource.DefaultMoveNoDrop;
                int action = e.getDragAction();
                if (action == 2) {
                    cursor = DragSource.DefaultMoveNoDrop;
                }
                this._dragSource.startDrag(e, cursor, transferable, this);
            } else {
                System.out.println("invalid node to drag");
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
                return "<html>Node class is " + node.getClass().getName() + "<br>Contains object of type " + node.getUserObject().getClass().getName() + "</html>";
            }
            if (node instanceof ScriptTreeNode) {
                return RMAIO.toHtmlString((String)((ScriptTreeNode)node).getToolTipText());
            }
            if (node instanceof FolderNode) {
                return RMAIO.toHtmlString((String)((FolderNode)node).getToolTipText());
            }
            return null;
        }
    }

    public class ScriptTextArea
    extends RSyntaxTextArea
    implements Modifiable,
    EditableComponent,
    FormManagementListener {
        private boolean _modified;
        private boolean _forwardModifiedEvents;
        private boolean _modifiable;
        private SyntaxScheme _defaultScheme;
        private SyntaxScheme _disabledScheme;

        public ScriptTextArea(int rows, int cols) {
            super(rows, cols);
            this._forwardModifiedEvents = true;
            this._modifiable = true;
            this.addListeners();
            this.setSyntaxEditingStyle("text/python");
            this.setMarkOccurrences(true);
            this.setMarkOccurrencesColor(Color.ORANGE);
            this.setAutoIndentEnabled(true);
            this.setBracketMatchingEnabled(true);
            this._defaultScheme = this.getSyntaxScheme();
            this._disabledScheme = (SyntaxScheme)this._defaultScheme.clone();
            int stylesCnt = this._disabledScheme.getStyleCount();
            for (int i = 0; i < stylesCnt; ++i) {
                if (this._disabledScheme.getStyle(i) == null) continue;
                this._disabledScheme.getStyle((int)i).foreground = Color.DARK_GRAY;
            }
        }

        private void addListeners() {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (RmaJTextField.isCursorKey((int)e.getKeyCode())) {
                        return;
                    }
                    int modifiers = e.getModifiers();
                    if ((modifiers & 8) > 0 || (modifiers & 2) > 0) {
                        return;
                    }
                    ScriptTextArea.this.setModified(true);
                }
            });
        }

        public boolean isModified() {
            return this._modified;
        }

        public void setModified(boolean b) {
            this._modified = b;
            if (b && this.forwardModifiedEvents()) {
                RMAUtil.setParentModified((Component)((Object)this));
            }
        }

        public boolean forwardModifiedEvents() {
            return this._forwardModifiedEvents;
        }

        public void setFowardModifiedEvents(boolean b) {
            this._forwardModifiedEvents = b;
        }

        public void setIsEditable(boolean b) {
            if (this._modifiable) {
                this.setEditable(b);
            }
        }

        public void setModifiable(boolean b) {
            this._modifiable = b;
        }

        public boolean isModifiable() {
            return this._modifiable;
        }

        public void clearPerformed() {
            this.setText("");
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (!enabled) {
                Color bg = this.getParent().getBackground();
                this.setBackground(bg);
                this.setSyntaxScheme(this._disabledScheme);
            } else {
                this.setBackground(UIManager.getColor("TextArea.background"));
                this.setSyntaxScheme(this._defaultScheme);
            }
        }
    }

    public class TreeBuilder
    extends DefaultHandler
    implements ITreeBuilder {
        protected String _fileName;
        protected DefaultMutableTreeNode _root;
        protected DefaultMutableTreeNode _current;

        public TreeBuilder(String fileName) {
            this._fileName = fileName;
        }

        public boolean buildTree() {
            InputStream is = this.getClass().getResourceAsStream(this._fileName);
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._fileName);
            }
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(this._fileName);
            }
            if (is == null) {
                System.out.println("buildTree: failed to find file " + this._fileName);
                return false;
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            }
            catch (Exception ioe) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)ioe)).log("buildTree: error getting buffered Reader on " + this._fileName);
                return false;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)this);
            }
            catch (Throwable t) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause(t)).log("buildTree: error parsing file " + this._fileName);
                return false;
            }
            return true;
        }

        @Override
        public void startDocument() throws SAXException {
            this._current = this._root = new DefaultMutableTreeNode("Root");
        }

        @Override
        public void endDocument() throws SAXException {
            ((DefaultTreeModel)AbstractScriptBuilderPanel.this._tree.getModel()).setRoot(this._root);
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            block12: {
                try {
                    String type = null;
                    String clsName = null;
                    String name = null;
                    String objName = null;
                    if (lName.length() == 0) {
                        lName = qName;
                    }
                    if (!AbstractScriptBuilderPanel.NEW_NODE.equalsIgnoreCase(lName)) break block12;
                    FolderNode node = new FolderNode();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (aName.length() == 0) {
                            aName = attrs.getQName(i);
                        }
                        if (AbstractScriptBuilderPanel.NODE_NAME_ATTR.equalsIgnoreCase(aName)) {
                            name = attrs.getValue(i);
                            node.setUserObject(name);
                            continue;
                        }
                        if (AbstractScriptBuilderPanel.NODE_TYPE_ATTR.equalsIgnoreCase(aName)) {
                            type = attrs.getValue(i);
                            continue;
                        }
                        if (AbstractScriptBuilderPanel.CLASS_ATTR.equalsIgnoreCase(aName)) {
                            clsName = attrs.getValue(i);
                            node.setClassname(clsName);
                            continue;
                        }
                        if (AbstractScriptBuilderPanel.TOOL_TIP_ATTR.equalsIgnoreCase(aName)) {
                            node.setToolTipText(attrs.getValue(i));
                            continue;
                        }
                        if (!AbstractScriptBuilderPanel.OBJ_NAME_ATTR.equalsIgnoreCase(aName)) continue;
                        objName = attrs.getValue(i);
                    }
                    if (AbstractScriptBuilderPanel.FUNCTION_OPT.equalsIgnoreCase(type) && clsName != null) {
                        try {
                            AbstractScriptBuilderPanel.this.addPublicMethods(node, Class.forName(clsName), objName);
                        }
                        catch (ClassNotFoundException nfe) {
                            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)nfe)).log("failed to find class " + clsName);
                        }
                    }
                    this._current.add(node);
                    this._current = node;
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("startElement Exception ");
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            this._current = (DefaultMutableTreeNode)this._current.getParent();
        }
    }
}

