/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.script.gui;

import hec.io.JavaDocParser;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class JDocHelpDialog
extends RmaJDialog {
    private JButton _prevButton;
    private JButton _nextButton;
    private WebView _webview;
    private ButtonCmdPanel _cmdPanel;
    private JFXPanel _browserFxPanel;

    public JDocHelpDialog(Dialog parent) {
        super(parent);
        this.buildControls();
    }

    public JDocHelpDialog(Frame parent) {
        super(parent);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDocHelpDialog.this.prevJavaDoc();
            }
        };
        prevAction.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/backbutton.gif"));
        prevAction.putValue("Name", "Prev");
        prevAction.putValue("ShortDescription", "Previously Viewed Page");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)buttonPanel, gbc);
        this._prevButton = new JButton(prevAction);
        this._prevButton.setVerticalTextPosition(3);
        this._prevButton.setHorizontalTextPosition(0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weighty = 0.1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        buttonPanel.add((Component)this._prevButton, gbc);
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDocHelpDialog.this.nextJavaDoc();
            }
        };
        nextAction.putValue("SmallIcon", RmaImage.getImageIcon((String)"Images/forwardbutton.gif"));
        nextAction.putValue("Name", "Next");
        nextAction.putValue("ShortDescription", "Next Viewed Page");
        this._nextButton = new JButton(nextAction);
        this._nextButton.setVerticalTextPosition(3);
        this._nextButton.setHorizontalTextPosition(0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        buttonPanel.add((Component)this._nextButton, gbc);
        this._browserFxPanel = new JFXPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)this._browserFxPanel, gbc);
        this._cmdPanel = new ButtonCmdPanel(256);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        JDocHelpDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.setMinimumSize(new Dimension(500, 400));
        this.setSize(new Dimension(800, 400));
        this.setLocationRelativeTo(this.getParent());
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.getActionMap().put("prev", prevAction);
        contentPane.getInputMap(2).put(KeyStroke.getKeyStroke(37, 8), "prev");
        contentPane.getActionMap().put("next", nextAction);
        contentPane.getInputMap(2).put(KeyStroke.getKeyStroke(39, 8), "next");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JDocHelpDialog.this.createScene();
            }
        });
    }

    private void createScene() {
        Pane browserView = this.createBrowser();
        this._browserFxPanel.setScene(new Scene((Parent)browserView));
    }

    private Pane createBrowser() {
        this._webview = new WebView();
        WebEngine eng = this._webview.getEngine();
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(5.0));
        grid.setVgap(5.0);
        grid.setHgap(5.0);
        GridPane.setConstraints((Node)this._webview, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        grid.getChildren().addAll((Object[])new Node[]{this._webview});
        eng.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> arg0, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JDocHelpDialog.this.updateButtonState();
                }
            }
        });
        eng.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                URL url;
                String title;
                System.out.println("changed:" + newValue);
                if (newValue.indexOf(124) > -1 && !newValue.toLowerCase().startsWith("file:")) {
                    newValue = "file:///".concat(newValue);
                }
                if ((title = null) == null) {
                    title = JDocHelpDialog.this.getTitle(newValue);
                }
                JDocHelpDialog.this.setTitle(title);
                try {
                    url = new URL(newValue);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
                if (url == null) {
                    String string = JavaDocParser.getJavaDocHome();
                }
                JDocHelpDialog.this.linkActivated(url);
            }
        });
        return grid;
    }

    protected String getTitle(String path) {
        int idx = path.toLowerCase().indexOf("javadocs");
        if (idx > -1) {
            String clsName = path.substring(idx + 9);
            if ((idx = clsName.lastIndexOf(46)) > -1) {
                clsName = clsName.substring(0, idx);
            }
            clsName = clsName.replace('/', '.');
            clsName = clsName.replace('\\', '.');
            return clsName;
        }
        String name = RMAIO.getFileNameNoExtension((String)path);
        return name;
    }

    void nextJavaDoc() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebHistory history = JDocHelpDialog.this._webview.getEngine().getHistory();
                int max = history.getMaxSize();
                int current = history.getCurrentIndex();
                if (current >= max) {
                    JDocHelpDialog.this._nextButton.setEnabled(false);
                    return;
                }
                history.go(1);
            }
        });
    }

    void prevJavaDoc() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebHistory history = JDocHelpDialog.this._webview.getEngine().getHistory();
                int current = history.getCurrentIndex();
                if (current == 0) {
                    JDocHelpDialog.this._prevButton.setEnabled(false);
                    return;
                }
                history.go(-1);
            }
        });
    }

    public void pushJDoc(String title, String urlStr) {
        if (urlStr == null) {
            return;
        }
        this.fillForm(urlStr);
    }

    public void pushJDoc(String title, File htmlFile) {
        try {
            String path = htmlFile.toURL().toString();
            this.fillForm(path);
        }
        catch (Exception e) {
            System.out.println("pushJDoc: Exception " + e);
        }
    }

    public void pushJDoc(String title, URL url) {
        if (url == null) {
            return;
        }
        String path = url.toString();
        this.fillForm(path);
    }

    protected void fillForm(final String path) {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JDocHelpDialog.this._webview.getEngine().load(path);
                }
            });
        }
        catch (Exception ioe) {
            System.out.println("fillForm: Error loading URL " + path + " Error:" + ioe);
        }
    }

    private void updateButtonState() {
        this._prevButton.setEnabled(false);
        this._nextButton.setEnabled(false);
        WebHistory history = this._webview.getEngine().getHistory();
        ObservableList entries = history.getEntries();
        if (entries.isEmpty()) {
            return;
        }
        int idx = history.getCurrentIndex();
        int cnt = entries.size();
        if (idx == 0) {
            if (cnt > 1) {
                this._nextButton.setEnabled(true);
            }
        } else if (idx == cnt - 1) {
            this._prevButton.setEnabled(true);
        } else {
            this._nextButton.setEnabled(true);
            this._prevButton.setEnabled(true);
        }
    }

    protected void linkActivated(URL u) {
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JDocHelpDialog dlg = new JDocHelpDialog(new Frame());
                dlg.setVisible(true);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            URL url = new URL("file:///j|/ResSim/dev/apps/javaDocs/hec/hecmath/TimeSeriesMath.html");
                            dlg.pushJDoc("info", url);
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    class PageLoader
    implements Runnable {
        URL _url;
        Cursor _cursor;

        PageLoader(URL u, Cursor c) {
            this._url = u;
            this._cursor = c;
        }

        @Override
        public void run() {
        }
    }
}

