/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclinepaint;

import com.google.common.collect.Range;
import com.rma.paint.isoclinepaint.Gradient;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import rma.lang.RmaMath;
import rma.util.ColorContour;
import rma.util.TwoColorColorContour;

public class ColorGradient
implements Gradient<Double, Color> {
    Map<Range, ColorContour> colorContourMap;
    List<Double> colorRange;
    Color undefinedColor = Color.black;
    Double undefinedValue = Double.NEGATIVE_INFINITY;
    List<Color> interpGrad = null;

    public ColorGradient(List<Double> colorRange, List<Color> colors) {
        this.colorRange = colorRange;
        this.colorContourMap = new HashMap<Range, ColorContour>();
        for (int i = 0; i < colors.size() - 1; ++i) {
            Color c0 = colors.get(i);
            Color c1 = i + 1 < colors.size() ? colors.get(i + 1) : c0;
            Double v0 = colorRange.get(i);
            Double v1 = i + 1 < colorRange.size() ? colorRange.get(i + 1) : v0;
            Range r = Range.closed((Comparable)v0, (Comparable)v1);
            TwoColorColorContour cc = new TwoColorColorContour();
            cc.setMaxColor(c1);
            cc.setMinColor(c0);
            cc.setMaxValue(v1.doubleValue());
            cc.setMinValue(v0.doubleValue());
            this.colorContourMap.put(r, (ColorContour)cc);
        }
    }

    public List<Double> getColorRange() {
        TreeSet<Double> set = new TreeSet<Double>();
        Set<Range> keySet = this.colorContourMap.keySet();
        for (Range range : keySet) {
            set.add((Double)range.lowerEndpoint());
            set.add((Double)range.upperEndpoint());
        }
        Double[] toArray = set.toArray(new Double[set.size()]);
        return Arrays.asList(toArray);
    }

    public void setUndefinedColor(Color undefinedColor) {
        Objects.requireNonNull(undefinedColor, "Cannont set a NULL undefined color in ColorGradient");
        this.undefinedColor = undefinedColor;
    }

    public void setUndefinedValue(Double undefinedValue) {
        Objects.requireNonNull(this.undefinedColor, "Cannont set a NULL undefined value in ColorGradient");
        this.undefinedValue = undefinedValue;
    }

    @Override
    public Color compute(Double input) {
        if (input == null || input.equals(this.undefinedValue)) {
            return this.undefinedColor;
        }
        Set<Range> keySet = this.colorContourMap.keySet();
        for (Range next : keySet) {
            if (!next.contains((Comparable)input)) continue;
            ColorContour get = this.colorContourMap.get(next);
            return get.getColor(input.doubleValue());
        }
        return this.undefinedColor;
    }

    public Color compute2(Double input) {
        List<Double> range = this.colorRange;
        double width = range.get(range.size() - 1) - range.get(0);
        double s = range.get(0);
        if (this.interpGrad == null) {
            this.interpGrad = new ArrayList<Color>();
            boolean z = false;
            for (int i = 0; i < 10000; ++i) {
                this.interpGrad.add(this.compute(s + (double)i * (width / 10000.0)));
            }
        }
        if (input == null || input.equals(this.undefinedValue)) {
            return this.undefinedColor;
        }
        double pct = (input - s) / width;
        if (pct < 0.0 || pct > 1.0) {
            return this.undefinedColor;
        }
        double idx = pct * (double)(this.interpGrad.size() - 1);
        double lIdx = Math.floor(idx);
        double hIdx = Math.ceil(idx);
        Color lc = this.interpGrad.get((int)lIdx);
        Color hc = this.interpGrad.get((int)hIdx);
        if (lIdx == hIdx) {
            return lc;
        }
        int r = (int)RmaMath.linearInterpolate((double)lIdx, (double)lc.getRed(), (double)hIdx, (double)hc.getRed(), (double)idx);
        int g = (int)RmaMath.linearInterpolate((double)lIdx, (double)lc.getGreen(), (double)hIdx, (double)hc.getGreen(), (double)idx);
        int b = (int)RmaMath.linearInterpolate((double)lIdx, (double)lc.getBlue(), (double)hIdx, (double)hc.getBlue(), (double)idx);
        return new Color(r, g, b);
    }

    public static void main(String[] args) {
        List<Color> colors = Arrays.asList(Color.blue, Color.red, Color.green, Color.orange, Color.black);
        List<Double> range = Arrays.asList(0.0, 30.0, 40.0, 45.0, 50.0);
        ColorGradient cg = new ColorGradient(range, colors);
        double[] inputValues = new double[5000000];
        for (int i = 0; i < 5000000; ++i) {
            inputValues[i] = Math.random() * (double)(range.size() - 1);
        }
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < inputValues.length; ++i) {
            cg.compute(inputValues[i]);
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Time = " + (double)(t1 - t0) / 1000.0);
        t0 = System.currentTimeMillis();
        for (int i = 0; i < inputValues.length; ++i) {
            cg.compute2(inputValues[i]);
        }
        t1 = System.currentTimeMillis();
        System.out.println("Time = " + (double)(t1 - t0) / 1000.0);
    }
}

