/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclinepaint;

import com.rma.paint.isoclinepaint.Function;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import rma.util.RMAConst;

public class DoubleArrayFunction
implements Function<Double, Double> {
    NavigableMap<Double, Double> functionMap = new TreeMap<Double, Double>();

    public DoubleArrayFunction(double[][] function) {
        for (int j = 0; j < function[0].length; ++j) {
            this.functionMap.put(function[0][j], function[1][j]);
        }
    }

    @Override
    public Double compute(Double x) {
        Map.Entry<Double, Double> ceilingEntry = this.functionMap.ceilingEntry(x);
        Map.Entry<Double, Double> floorEntry = this.functionMap.floorEntry(x);
        if (ceilingEntry == null) {
            return floorEntry.getValue();
        }
        if (floorEntry == null) {
            return ceilingEntry.getValue();
        }
        if (ceilingEntry.equals(floorEntry)) {
            return ceilingEntry.getValue();
        }
        double x1 = floorEntry.getKey();
        double x2 = ceilingEntry.getKey();
        double y1 = floorEntry.getValue();
        double y2 = ceilingEntry.getValue();
        if (!(RMAConst.isValidValue((double)x1) && RMAConst.isValidValue((double)x2) && RMAConst.isValidValue((double)y1) && RMAConst.isValidValue((double)y2))) {
            return Double.NEGATIVE_INFINITY;
        }
        return (x - x1) * (y2 - y1) / (x2 - x1) + y1;
    }
}

