/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclinepaint;

import com.rma.paint.isoclinepaint.BiFunction;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.media.jai.InterpolationBilinear;

public class IsoclineFunction
implements BiFunction<Double, Double, Double> {
    NavigableMap<Double, NavigableMap<Double, Double>> _gridFunctions = new TreeMap<Double, NavigableMap<Double, Double>>();

    public IsoclineFunction(List<LocalDateTime> dates, List<double[][]> functions) {
        for (int i = 0; i < dates.size(); ++i) {
            LocalDateTime time = dates.get(i);
            double[][] function = functions.get(i);
            TreeMap<Double, Double> functionMap = new TreeMap<Double, Double>();
            for (int j = 0; j < function[0].length; ++j) {
                functionMap.put(function[0][j], function[1][j]);
            }
            this._gridFunctions.put(Double.valueOf(time.toEpochSecond(ZoneOffset.UTC)), functionMap);
        }
    }

    public Object[][] getTimeSeries(double depth) {
        Object[][] timeSeries = new Object[2][this._gridFunctions.size()];
        Set keySet = this._gridFunctions.keySet();
        int idx = 0;
        for (Double time : keySet) {
            NavigableMap get = (NavigableMap)this._gridFunctions.get(time);
            timeSeries[0][idx] = LocalDateTime.ofEpochSecond(time.longValue(), 0, ZoneOffset.UTC);
            double value = this.compute(time, depth);
            timeSeries[1][idx] = 0.0 == value ? Double.valueOf(Double.NEGATIVE_INFINITY) : Double.valueOf(value);
            ++idx;
        }
        return timeSeries;
    }

    public double[][] ceilFunction(LocalDateTime date) {
        Map.Entry<Double, NavigableMap<Double, Double>> ceilingEntry = this._gridFunctions.ceilingEntry(Double.valueOf(date.toEpochSecond(ZoneOffset.UTC)));
        return this.functionEntryToFunction(ceilingEntry);
    }

    public double[][] floorFunction(LocalDateTime date) {
        Map.Entry<Double, NavigableMap<Double, Double>> floorEntry = this._gridFunctions.floorEntry(Double.valueOf(date.toEpochSecond(ZoneOffset.UTC)));
        return this.functionEntryToFunction(floorEntry);
    }

    private double[][] functionEntryToFunction(Map.Entry<Double, NavigableMap<Double, Double>> entry) {
        NavigableMap<Double, Double> value;
        NavigableMap<Double, Double> navigableMap = value = entry != null ? entry.getValue() : null;
        if (value == null) {
            return null;
        }
        Set entrySet = value.entrySet();
        double[][] function = new double[2][entrySet.size()];
        Iterator iterator = entrySet.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            function[0][idx] = (Double)next.getKey();
            function[1][idx] = (Double)next.getValue();
            ++idx;
        }
        return function;
    }

    @Override
    public Double compute(Double x, Double y) {
        double yfrac;
        Double floorTime = this._gridFunctions.floorKey(x);
        Double ceilingTime = this._gridFunctions.ceilingKey(x);
        if (floorTime == null) {
            return 0.0;
        }
        if (ceilingTime == null) {
            return 0.0;
        }
        NavigableMap x0 = (NavigableMap)this._gridFunctions.get(floorTime);
        NavigableMap x1 = (NavigableMap)this._gridFunctions.get(ceilingTime);
        Double y00 = x0.floorKey(y);
        Double y01 = x0.ceilingKey(y);
        if (y00 == null) {
            return 0.0;
        }
        if (y01 == null) {
            return 0.0;
        }
        Double z01 = (Double)x0.get(y01);
        Double z00 = (Double)x0.get(y00);
        Double y10 = x1.floorKey(y);
        Double y11 = x1.ceilingKey(y);
        if (y10 == null) {
            return 0.0;
        }
        if (y11 == null) {
            return 0.0;
        }
        Double z11 = (Double)x1.get(y11);
        Double z10 = (Double)x1.get(y10);
        InterpolationBilinear bilinearInterpolation = new InterpolationBilinear();
        double xfrac = floorTime - ceilingTime == 0.0 ? 1.0 : (x - floorTime) / Math.abs(ceilingTime - floorTime);
        double d = yfrac = y11 - y10 == 0.0 ? 1.0 : (y - y10) / Math.abs(y11 - y10);
        if (xfrac < 0.0 || yfrac < 0.0) {
            // empty if block
        }
        if ((double)z00.floatValue() == Double.NEGATIVE_INFINITY || (double)z10.floatValue() == Double.NEGATIVE_INFINITY || (double)z01.floatValue() == Double.NEGATIVE_INFINITY || (double)z11.floatValue() == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (z00.floatValue() == 0.0f || z10.floatValue() == 0.0f || z01.floatValue() == 0.0f || z11.floatValue() == 0.0f) {
            return 0.0;
        }
        float interpolate = bilinearInterpolation.interpolate(z00.floatValue(), z10.floatValue(), z01.floatValue(), z11.floatValue(), (float)xfrac, (float)yfrac);
        return interpolate;
    }

    private class Cache {
        Double z11;
        Double z10;
        Double z01;
        Double z00;

        private Cache() {
        }
    }
}

