/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclinepaint;

import com.rma.paint.isoclinepaint.BiFunction;
import com.rma.paint.isoclinepaint.Gradient;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.lang.RmaMath;
import rma.util.RMAConst;

public class IsoclinePaintContext
implements PaintContext {
    private final Gradient<Double, Color> _cc;
    private final BiFunction<Double, Double, Double> _function;
    private final Rectangle2D _userBounds;
    private final Rectangle2D.Double _worldBounds;
    ExecutorService _threadPool;
    float[] colorComp = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    WritableRaster tileRaster = null;

    IsoclinePaintContext(Rectangle2D userBounds, Rectangle2D.Double worldBounds, BiFunction<Double, Double, Double> function, Gradient<Double, Color> cc) {
        this._userBounds = userBounds;
        this._worldBounds = worldBounds;
        this._function = function;
        this._cc = cc;
        this._threadPool = Executors.newFixedThreadPool(1000);
    }

    @Override
    public void dispose() {
        this._threadPool.shutdown();
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        if (this.tileRaster == null || this.tileRaster.getWidth() < w || this.tileRaster.getHeight() < h) {
            this.tileRaster = this.getColorModel().createCompatibleWritableRaster(w, h);
        }
        ArrayList<Future<Result>> futureList = new ArrayList<Future<Result>>();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int xloc = i + x;
                int yloc = j + y;
                double wxloc = RmaMath.linearInterpolate((double)this._userBounds.getMinX(), (double)this._worldBounds.getMinX(), (double)this._userBounds.getMaxX(), (double)this._worldBounds.getMaxX(), (double)xloc);
                double wyloc = RmaMath.linearInterpolate((double)this._userBounds.getMinY(), (double)this._worldBounds.getMaxY(), (double)this._userBounds.getMaxY(), (double)this._worldBounds.getMinY(), (double)yloc);
                Future<Result> submit = this._threadPool.submit(new ComputeCallable(i, j, wxloc, wyloc, this._function, this._cc));
                futureList.add(submit);
            }
        }
        for (Future future : futureList) {
            Result r = null;
            try {
                r = (Result)future.get();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(IsoclinePaintContext.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(IsoclinePaintContext.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (r == null) continue;
            this.colorComp[0] = r.c.getRed();
            this.colorComp[1] = r.c.getGreen();
            this.colorComp[2] = r.c.getBlue();
            this.colorComp[3] = r.c.getAlpha();
            this.tileRaster.setPixel(r.i, r.j, this.colorComp);
        }
        return this.tileRaster;
    }

    private class ComputeCallable
    implements Callable<Result> {
        private final int _rasterlocy;
        private final int _rasterlocx;
        private final double _wxloc;
        private final double _wyloc;
        BiFunction<Double, Double, Double> _function;
        Gradient<Double, Color> _cc;

        public ComputeCallable(int rasterlocx, int rasterlocy, double wxloc, double wyloc, BiFunction<Double, Double, Double> f, Gradient<Double, Color> cc) {
            this._rasterlocx = rasterlocx;
            this._rasterlocy = rasterlocy;
            this._wxloc = wxloc;
            this._wyloc = wyloc;
            this._function = f;
            this._cc = cc;
        }

        @Override
        public Result call() throws Exception {
            Double compute = this._function.compute(this._wxloc, this._wyloc);
            compute = compute != null && RMAConst.isValidValue((double)compute) ? compute : 0.0;
            Color compute1 = (Color)this._cc.compute(compute);
            Result r = new Result();
            r.i = this._rasterlocx;
            r.j = this._rasterlocy;
            r.c = compute1;
            return r;
        }
    }

    private class Result {
        int i = 0;
        int j = 0;
        Color c;

        private Result() {
        }
    }
}

