/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.error;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.error.ErrorEvent;
import org.jdesktop.swingx.error.ErrorListener;

public class ErrorSupport {
    private List<ErrorListener> listeners;
    private Object source;

    public ErrorSupport(Object source) {
        this.source = source;
        this.listeners = new ArrayList<ErrorListener>();
    }

    public void addErrorListener(ErrorListener listener) {
        this.listeners.add(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.listeners.remove(listener);
    }

    public ErrorListener[] getErrorListeners() {
        return this.listeners.toArray(new ErrorListener[0]);
    }

    public void fireErrorEvent(Throwable throwable) {
        final ErrorEvent evt = new ErrorEvent(throwable, this.source);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ErrorListener el : ErrorSupport.this.listeners) {
                    el.errorOccured(evt);
                }
            }
        });
    }
}

