/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalButtonUI;

public class DropButtonUI
extends MetalButtonUI {
    protected static Icon m_Arrow = null;
    protected static Icon m_DisabledArrow = null;

    protected DropButtonUI() {
        if (m_Arrow == null) {
            m_Arrow = this.getDropArrow(true);
            m_DisabledArrow = this.getDropArrow(false);
        }
    }

    public Color getTextColor() {
        return UIManager.getColor("Button.foreground");
    }

    public int getArrowIconWidth() {
        if (m_Arrow == null) {
            return 0;
        }
        return m_Arrow.getIconWidth();
    }

    protected Icon getDropArrow(boolean enabled) {
        if (enabled) {
            if (m_Arrow == null) {
                m_Arrow = this.getDropArrow(this.getTextColor());
            }
            return m_Arrow;
        }
        if (m_DisabledArrow == null) {
            m_DisabledArrow = this.getDropArrow(this.getDisabledTextColor());
        }
        return m_DisabledArrow;
    }

    protected Icon getDropArrow(Color c) {
        BufferedImage bi = new BufferedImage(12, 6, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(c);
        g.fillPolygon(new int[]{2, 5, 9, 1}, new int[]{1, 5, 1, 1}, 4);
        g.dispose();
        return new ImageIcon(bi);
    }
}

