/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXDropButton;
import org.jdesktop.swingx.plaf.DropButtonUI;

public class BasicDropButtonUI
extends DropButtonUI {
    protected MouseListener m_ClickListener;
    protected boolean m_IsHovering;
    protected BufferedImage m_Gradient;
    protected PopupMenuListener m_PopupMenuListener;
    private JPopupMenu m_TmpMenu;
    private boolean m_PopupVisible;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDropButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        final JXDropButton btn = (JXDropButton)b;
        this.m_ClickListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (btn.getAction() == null || e.getX() >= BasicDropButtonUI.this.getActionX(btn)) {
                    e.consume();
                    BasicDropButtonUI.this.showPopup(btn);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (btn.getAction() == null || e.getX() >= BasicDropButtonUI.this.getActionX(btn)) {
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BasicDropButtonUI.this.m_IsHovering = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BasicDropButtonUI.this.m_IsHovering = false;
            }
        };
        btn.addMouseListener(this.m_ClickListener);
        this.m_PopupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BasicDropButtonUI.this.m_PopupVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                BasicDropButtonUI.this.m_PopupVisible = false;
            }
        };
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(this.m_ClickListener);
        if (this.m_TmpMenu != null) {
            this.m_TmpMenu.removePopupMenuListener(this.m_PopupMenuListener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JXDropButton btn = (JXDropButton)c;
        if (this.m_PopupVisible) {
            this.paintButtonPressed(g, btn);
        }
        super.paint(g, c);
        if (btn.getParent() != null && btn.getAction() != null && btn.getPopupMenu() != null && btn.getModel().isArmed()) {
            if (this.m_Gradient == null) {
                List gradient = (List)UIManager.get("Button.gradient");
                float ratio1 = ((Number)gradient.get(0)).floatValue();
                float ratio2 = ((Number)gradient.get(1)).floatValue();
                Color c1 = (Color)gradient.get(2);
                Color c2 = (Color)gradient.get(3);
                Color c3 = (Color)gradient.get(4);
                int h = 10;
                int w = 1;
                this.m_Gradient = new BufferedImage(1, 10, 2);
                Graphics2D g2d = (Graphics2D)this.m_Gradient.getGraphics();
                int mid = (int)(ratio1 * (float)h);
                int mid2 = (int)(ratio2 * (float)h);
                if (mid > 0) {
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, mid, c2, true));
                    g2d.fillRect(0, 0, w, mid);
                }
                if (mid2 > 0) {
                    g2d.setColor(c2);
                    g2d.fillRect(0, mid, w, mid2);
                }
                if (mid > 0) {
                    g2d.setPaint(new GradientPaint(0.0f, (float)mid + (float)mid2, c2, 0.0f, (float)mid * 2.0f + (float)mid2, c1, true));
                    g2d.fillRect(0, mid + mid2, w, mid);
                }
                if (h - mid * 2 - mid2 > 0) {
                    g2d.setPaint(new GradientPaint(0.0f, (float)mid * 2.0f + (float)mid2, c1, 0.0f, h, c3, true));
                    g2d.fillRect(0, mid * 2 + mid2, w, h - mid * 2 - mid2);
                }
                g2d.dispose();
            }
            g.drawImage(this.m_Gradient, this.getActionX(btn), 0, btn.getInsets().right + this.getArrowIconWidth(), btn.getHeight(), null);
        }
        if (btn.getPopupMenu() != null) {
            int x = this.getActionX(btn);
            int y = btn.getHeight() / 2 - 2;
            if (btn.getAction() != null && this.m_IsHovering && !this.m_PopupVisible) {
                Color tmp = g.getColor();
                g.setColor(this.getTextColor());
                g.drawLine(x, 0, x, btn.getHeight());
                g.setColor(tmp);
            }
            x += (btn.getWidth() - x) / 2 - this.getArrowIconWidth() / 2;
            this.getDropArrow(btn.isEnabled()).paintIcon(btn, g, x, y);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled() && b.getAction() != null && ((JXDropButton)b).getPopupMenu() != null && !this.m_PopupVisible) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            int width = this.getActionX((JXDropButton)b);
            g.fillRect(0, 1, width, size.height - 2);
        } else {
            super.paintButtonPressed(g, b);
        }
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        if (c instanceof JXDropButton && ((JXDropButton)c).getPopupMenu() != null) {
            iconRect.x -= iconRect.x - c.getInsets().left;
        }
        super.paintIcon(g, c, iconRect);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (c instanceof JXDropButton && ((JXDropButton)c).getPopupMenu() != null) {
            JXDropButton btn = (JXDropButton)c;
            textRect.x -= textRect.x - c.getInsets().left;
            textRect.x = textRect.x + (btn.getIcon() == null ? 0 : btn.getIcon().getIconWidth() + btn.getIconTextGap());
        }
        super.paintText(g, c, textRect, text);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (c instanceof JXDropButton && ((JXDropButton)c).getPopupMenu() != null) {
            d.width += this.getArrowIconWidth();
        }
        return d;
    }

    protected void showPopup(JXDropButton btn) {
        if (!btn.isEnabled()) {
            return;
        }
        JPopupMenu menu = btn.getPopupMenu();
        if (menu == null) {
            return;
        }
        if (this.m_TmpMenu == null) {
            this.m_TmpMenu = menu;
            this.m_TmpMenu.addPopupMenuListener(this.m_PopupMenuListener);
        } else if (this.m_TmpMenu != menu) {
            this.m_TmpMenu.removePopupMenuListener(this.m_PopupMenuListener);
            this.m_TmpMenu = menu;
            this.m_TmpMenu.addPopupMenuListener(this.m_PopupMenuListener);
        }
        if (menu.isVisible() || this.m_PopupVisible) {
            menu.setVisible(false);
        } else {
            menu.show(btn, 0, btn.getHeight());
        }
    }

    protected int getActionX(JXDropButton btn) {
        return btn.getWidth() - btn.getInsets().right - this.getArrowIconWidth() + 2;
    }
}

