/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jdesktop.swingx.JXDropButton;

public class WindowsDropButtonUI
extends BasicButtonUI {
    protected static Icon m_Arrow = null;
    protected static Icon m_DisabledArrow = null;
    protected MouseListener m_ClickListener;
    protected boolean m_IsHovering;
    protected PopupMenuListener m_PopupMenuListener;
    private JPopupMenu m_TmpMenu;
    private boolean m_PopupVisible;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsDropButtonUI();
    }

    protected WindowsDropButtonUI() {
        if (m_Arrow == null) {
            m_Arrow = this.getDropArrow(true);
            m_DisabledArrow = this.getDropArrow(false);
        }
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setModel(new WindowsDropButtonModel(b));
    }

    public Color getTextColor() {
        return UIManager.getColor("Button.foreground");
    }

    public Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledForeground");
    }

    public Color getSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public int getArrowIconWidth() {
        if (m_Arrow == null) {
            return 0;
        }
        return m_Arrow.getIconWidth();
    }

    protected Icon getDropArrow(boolean enabled) {
        if (enabled) {
            if (m_Arrow == null) {
                m_Arrow = this.getDropArrow(this.getTextColor());
            }
            return m_Arrow;
        }
        if (m_DisabledArrow == null) {
            m_DisabledArrow = this.getDropArrow(this.getDisabledTextColor());
        }
        return m_DisabledArrow;
    }

    protected Icon getDropArrow(Color c) {
        BufferedImage bi = new BufferedImage(12, 6, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(c);
        g.fillPolygon(new int[]{2, 5, 9, 1}, new int[]{1, 5, 1, 1}, 4);
        g.dispose();
        return new ImageIcon(bi);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        final JXDropButton btn = (JXDropButton)b;
        this.m_ClickListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (btn.getAction() == null || e.getX() >= WindowsDropButtonUI.this.getActionX(btn)) {
                    e.consume();
                    WindowsDropButtonUI.this.showPopup(btn);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (btn.getAction() == null || e.getX() >= WindowsDropButtonUI.this.getActionX(btn)) {
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WindowsDropButtonUI.this.m_IsHovering = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WindowsDropButtonUI.this.m_IsHovering = false;
            }
        };
        btn.addMouseListener(this.m_ClickListener);
        this.m_PopupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                WindowsDropButtonUI.this.m_PopupVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                WindowsDropButtonUI.this.m_PopupVisible = false;
            }
        };
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(this.m_ClickListener);
        if (this.m_TmpMenu != null) {
            this.m_TmpMenu.removePopupMenuListener(this.m_PopupMenuListener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JXDropButton btn = (JXDropButton)c;
        super.paint(g, c);
        if (this.m_PopupVisible) {
            this.paintButtonPressed(g, btn);
        }
        if (btn.getPopupMenu() != null) {
            int x = this.getActionX(btn);
            int y = btn.getHeight() / 2 - 2;
            if (btn.getAction() != null && this.m_IsHovering && !this.m_PopupVisible) {
                Color tmp = g.getColor();
                g.setColor(this.getTextColor());
                g.drawLine(x, btn.getInsets().top, x, btn.getHeight() - btn.getInsets().bottom);
                g.setColor(tmp);
            }
            x += (btn.getWidth() - x) / 2 - this.getArrowIconWidth() / 2;
            this.getDropArrow(btn.getModel().isEnabled()).paintIcon(btn, g, x, y);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        super.paintButtonPressed(g, b);
        if (b.isContentAreaFilled() && b.getAction() != null && ((JXDropButton)b).getPopupMenu() != null && !this.m_PopupVisible) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            int x = this.getActionX((JXDropButton)b);
            g.fillRect(x, 2, b.getInsets().right - 2, size.height - 4);
        }
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        if (c instanceof JXDropButton && ((JXDropButton)c).getPopupMenu() != null) {
            iconRect.x -= iconRect.x - c.getInsets().left;
        }
        super.paintIcon(g, c, iconRect);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (c instanceof JXDropButton && ((JXDropButton)c).getPopupMenu() != null) {
            JXDropButton btn = (JXDropButton)c;
            textRect.x -= textRect.x - c.getInsets().left;
            textRect.x = textRect.x + (btn.getIcon() == null ? 0 : btn.getIcon().getIconWidth() + btn.getIconTextGap());
        }
        super.paintText(g, c, textRect, text);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (c instanceof JXDropButton && ((JXDropButton)c).getPopupMenu() != null) {
            d.width += this.getArrowIconWidth();
        }
        return d;
    }

    protected void showPopup(JXDropButton btn) {
        if (!btn.isEnabled()) {
            return;
        }
        JPopupMenu menu = btn.getPopupMenu();
        if (menu == null) {
            return;
        }
        if (this.m_TmpMenu == null) {
            this.m_TmpMenu = menu;
            this.m_TmpMenu.addPopupMenuListener(this.m_PopupMenuListener);
        } else if (this.m_TmpMenu != menu) {
            this.m_TmpMenu.removePopupMenuListener(this.m_PopupMenuListener);
            this.m_TmpMenu = menu;
            this.m_TmpMenu.addPopupMenuListener(this.m_PopupMenuListener);
        }
        if (menu.isVisible() || this.m_PopupVisible) {
            menu.setVisible(false);
        } else {
            menu.show(btn, 0, btn.getHeight());
        }
    }

    protected int getActionX(JXDropButton btn) {
        return btn.getWidth() - btn.getInsets().right;
    }

    private class WindowsDropButtonModel
    extends DefaultButtonModel {
        public WindowsDropButtonModel(AbstractButton btn) {
            DefaultButtonModel model = (DefaultButtonModel)btn.getModel();
            this.setActionCommand(model.getActionCommand());
            this.setArmed(model.isArmed());
            this.setEnabled(model.isEnabled());
            this.setSelected(model.isSelected());
            this.setPressed(model.isPressed());
            this.setRollover(model.isRollover());
            this.setMnemonic(model.getMnemonic());
            this.setGroup(model.getGroup());
        }

        @Override
        public boolean isPressed() {
            return WindowsDropButtonUI.this.m_PopupVisible || super.isPressed();
        }

        @Override
        public boolean isRollover() {
            return WindowsDropButtonUI.this.m_PopupVisible || super.isRollover();
        }

        @Override
        public boolean isArmed() {
            return WindowsDropButtonUI.this.m_PopupVisible || super.isArmed();
        }
    }
}

