/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services;

import org.junit.Assert;
import org.junit.Test;
import usace.metrics.noop.NoOpCounter;
import usace.metrics.noop.NoOpHistogram;
import usace.metrics.noop.NoOpMeter;
import usace.metrics.noop.NoOpMetrics;
import usace.metrics.noop.NoOpTimer;
import usace.metrics.services.AbstractMetricsUnitTest;
import usace.metrics.services.Counter;
import usace.metrics.services.Histogram;
import usace.metrics.services.Meter;
import usace.metrics.services.Metrics;
import usace.metrics.services.MetricsService;
import usace.metrics.services.Timer;
import usace.metrics.services.config.MetricsInvalidValueException;

public abstract class MetricsApiTest
extends AbstractMetricsUnitTest {
    protected abstract Class<? extends Metrics> getExpectedMetricsClass();

    protected abstract Class<? extends Meter> getExpectedMeterClass();

    protected abstract Class<? extends Histogram> getExpectedHistogramClass();

    protected abstract Class<? extends Counter> getExpectedCounterClass();

    protected abstract Class<? extends Timer> getExpectedTimerClass();

    @Test
    public void testMetricsClass() {
        MetricsService service = this.createSavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Assert.assertNotNull((Object)metrics);
        Assert.assertEquals(this.getExpectedMetricsClass(), metrics.getClass());
    }

    @Test
    public void testMeterClass() {
        MetricsService service = this.createSavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Meter meter = metrics.createMeter();
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals(this.getExpectedMeterClass(), meter.getClass());
    }

    @Test
    public void testHistogramClass() {
        MetricsService service = this.createSavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Histogram hist = metrics.createHistogram();
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals(this.getExpectedHistogramClass(), hist.getClass());
    }

    @Test
    public void testCounterClass() {
        MetricsService service = this.createSavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Counter counter = metrics.createCounter();
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals(this.getExpectedCounterClass(), counter.getClass());
    }

    @Test
    public void testTimerClass() {
        MetricsService service = this.createSavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Timer timer = metrics.createTimer();
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals(this.getExpectedTimerClass(), timer.getClass());
    }

    @Test
    public void testMetricsCreateMetrics() {
        MetricsService service = this.createSavableMetricsService();
        String start = "path";
        String end = "myPath";
        Metrics metrics = service.createMetrics(new String[]{start});
        Metrics secondMetrics = metrics.createMetrics(new String[]{end});
        Assert.assertNotNull((Object)secondMetrics);
    }

    @Test
    public void testMetricsClass_disabled() {
        MetricsService service = this.createDisabledMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Assert.assertNotNull((Object)metrics);
        Assert.assertEquals(NoOpMetrics.class, metrics.getClass());
    }

    @Test
    public void testMeterClass_disabled() {
        MetricsService service = this.createDisabledMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Meter meter = metrics.createMeter();
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals(NoOpMeter.class, meter.getClass());
    }

    @Test
    public void testHistogramClass_disabled() {
        MetricsService service = this.createDisabledMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Histogram hist = metrics.createHistogram();
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals(NoOpHistogram.class, hist.getClass());
    }

    @Test
    public void testCounterClass_disabled() {
        MetricsService service = this.createDisabledMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Counter counter = metrics.createCounter();
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals(NoOpCounter.class, counter.getClass());
    }

    @Test
    public void testTimerClass_disabled() {
        MetricsService service = this.createDisabledMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"path"});
        Timer timer = metrics.createTimer();
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals(NoOpTimer.class, timer.getClass());
    }

    @Test
    public void testCreateMetrics_disabled() {
        MetricsService service = this.createDisabledMetricsService();
        String start = "path";
        String end = "myPath";
        Metrics metrics = service.createMetrics(new String[]{start});
        Metrics secondMetrics = metrics.createMetrics(new String[]{end});
        Assert.assertNotNull((Object)secondMetrics);
    }

    @Test(expected=MetricsInvalidValueException.class)
    public void testCreateMetrics_empty() {
        Metrics metrics = this.createMetrics();
        Metrics nullMetrics = metrics.createMetrics(new String[0]);
    }

    @Test
    public void testCreateMetrics_blank() {
        MetricsService service = this.createUnsavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{""});
        Assert.assertNotNull((Object)metrics);
    }
}

