/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import usace.metrics.noop.NoOpCounter;
import usace.metrics.noop.NoOpHistogram;
import usace.metrics.noop.NoOpMeter;
import usace.metrics.noop.NoOpMetrics;
import usace.metrics.noop.NoOpTimer;
import usace.metrics.services.AbstractMetric;
import usace.metrics.services.AbstractMetricsUnitTest;
import usace.metrics.services.Counter;
import usace.metrics.services.Histogram;
import usace.metrics.services.Meter;
import usace.metrics.services.Metrics;
import usace.metrics.services.Timer;

public class MetricsServiceProviderTest
extends AbstractMetricsUnitTest {
    @Test
    public void testMetricsClass() throws Exception {
        Metrics createMetrics = this.createMetrics();
        this.println("Creating Metrics class of type: ", createMetrics.getClass().getSimpleName());
        Assert.assertTrue((boolean)(createMetrics instanceof NoOpMetrics));
    }

    @Test
    public void testTimer() throws Exception {
        Metrics metrics = this.createMetrics();
        Timer metric = metrics.createTimer();
        this.println("Creating Timer of type: ", metric.getClass().getSimpleName());
        Assert.assertTrue((boolean)(metric instanceof NoOpTimer));
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testMeter() throws Exception {
        Metrics metrics = this.createMetrics();
        Meter metric = metrics.createMeter();
        this.println("Creating Meter of type: ", metric.getClass().getSimpleName());
        Assert.assertTrue((boolean)(metric instanceof NoOpMeter));
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testCounter() throws Exception {
        Metrics metrics = this.createMetrics();
        Counter metric = metrics.createCounter();
        this.println("Creating Counter of type: ", metric.getClass().getSimpleName());
        Assert.assertTrue((boolean)(metric instanceof NoOpCounter));
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testHistogram() throws Exception {
        Metrics metrics = this.createMetrics();
        Histogram metric = metrics.createHistogram();
        this.println("Creating Histogram of type: ", metric.getClass().getSimpleName());
        Assert.assertTrue((boolean)(metric instanceof NoOpHistogram));
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testTimerStart() throws Exception {
        Metrics metrics = this.createMetrics();
        Timer metric = metrics.createTimer();
        Assert.assertTrue((metric.start() != null ? 1 : 0) != 0);
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testTimerClose() throws Exception {
        Metrics metrics = this.createMetrics();
        Timer metric = metrics.createTimer();
        Timer.Context context = metric.start();
        context.close();
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testMeterMark() throws Exception {
        Metrics metrics = this.createMetrics();
        Meter metric = metrics.createMeter();
        metric.mark();
        if (metric instanceof NoOpMeter) {
            Assert.assertTrue((metric.getCount() == 0L ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((metric.getCount() == 1L ? 1 : 0) != 0);
        }
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testMeterMarkLong() throws Exception {
        Metrics metrics = this.createMetrics();
        Meter metric = metrics.createMeter();
        metric.mark(1000L);
        if (metric instanceof NoOpMeter) {
            Assert.assertTrue((metric.getCount() == 0L ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Count " + metric.getCount() + " is not equal to 1000L!"), (metric.getCount() == 1000L ? 1 : 0) != 0);
        }
        metrics.remove((AbstractMetric)metric);
    }

    public void testHistogramUpdateInt() throws Exception {
        Metrics metrics = this.createMetrics();
        Histogram metric = metrics.createHistogram();
        metric.update(100);
        metrics.remove((AbstractMetric)metric);
    }

    public void testHistogramUpdateLong() throws Exception {
        Metrics metrics = this.createMetrics();
        Histogram metric = metrics.createHistogram();
        metric.update(10000L);
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testCounterDec() throws Exception {
        Metrics metrics = this.createMetrics();
        Counter metric = metrics.createCounter();
        metric.dec();
        if (metric instanceof NoOpCounter) {
            Assert.assertTrue((metric.getCount() == 0L ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((metric.getCount() == -1L ? 1 : 0) != 0);
        }
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testCounterDecLong() throws Exception {
        Metrics metrics = this.createMetrics();
        Counter metric = metrics.createCounter();
        metric.dec(100L);
        if (metric instanceof NoOpCounter) {
            Assert.assertTrue((metric.getCount() == 0L ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((metric.getCount() == -100L ? 1 : 0) != 0);
        }
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testCounterInc() throws Exception {
        Metrics metrics = this.createMetrics();
        Counter metric = metrics.createCounter();
        metric.inc();
        if (metric instanceof NoOpCounter) {
            Assert.assertTrue((metric.getCount() == 0L ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((metric.getCount() == 1L ? 1 : 0) != 0);
        }
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testCounterIncLong() throws Exception {
        Metrics metrics = this.createMetrics();
        Counter metric = metrics.createCounter();
        metric.inc(100L);
        if (metric instanceof NoOpCounter) {
            Assert.assertTrue((metric.getCount() == 0L ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((metric.getCount() == 100L ? 1 : 0) != 0);
        }
        metrics.remove((AbstractMetric)metric);
    }

    @Test
    public void testMetricRemoval() throws Exception {
        Metrics metrics = this.createMetrics();
        ArrayList<String> failures = new ArrayList<String>();
        Counter metric = metrics.createCounter();
        if (!metrics.remove((AbstractMetric)metric)) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!metrics.remove((AbstractMetric)(metric = metrics.createMeter()))) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!metrics.remove((AbstractMetric)(metric = metrics.createHistogram()))) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!metrics.remove((AbstractMetric)(metric = metrics.createTimer()))) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!failures.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : failures) {
                sb.append(s);
                sb.append("\n");
            }
            Assert.fail((String)sb.toString());
        }
    }
}

