/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import usace.metrics.services.AbstractMetric;
import usace.metrics.services.AbstractMetricsUnitTest;
import usace.metrics.services.Counter;
import usace.metrics.services.Metrics;
import usace.metrics.services.MetricsInitializationException;
import usace.metrics.services.MetricsService;

public class MetricsServiceTest
extends AbstractMetricsUnitTest {
    @Test(expected=MetricsInitializationException.class)
    public void testNullInit() {
        MetricsService service = new MetricsService(null);
        Assert.fail((String)("Created service with null configuration." + service));
    }

    @Test
    public void testSetFilter() {
        MetricsService service = this.createUnsavableMetricsService();
        service.setFilter(name -> true);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testSetFilter_null() {
        MetricsService service = this.createUnsavableMetricsService();
        service.setFilter(null);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testGetConfig() {
        MetricsService service = this.createUnsavableMetricsService();
        Assert.assertNotNull((Object)service.getConfig());
    }

    @Test
    public void testCreateMetrics() {
        MetricsService service = this.createUnsavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"Success"});
        Assert.assertNotNull((Object)metrics);
    }

    @Test
    public void testCreateMetricsFromMetrics() {
        MetricsService service = this.createUnsavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"Success"});
        Metrics childMetrics = service.createMetrics(metrics, new String[]{"Another Success"});
        Assert.assertNotNull((Object)childMetrics);
    }

    @Test
    public void testCreateMetricsFromMetrics_nullMetrics() {
        MetricsService service = this.createUnsavableMetricsService();
        Metrics childMetrics = service.createMetrics((Metrics)null, new String[]{"Another Success"});
        Assert.assertNotNull((Object)childMetrics);
    }

    @Test
    public void testCreateMetricsFromMetrics_emptyPath() {
        MetricsService service = this.createUnsavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"Success"});
        Metrics childMetrics = service.createMetrics(metrics, new String[0]);
        Assert.assertNotNull((Object)childMetrics);
    }

    @Test
    public void testCreateMetricsFromMetrics_blankPath() {
        MetricsService service = this.createUnsavableMetricsService();
        Metrics metrics = service.createMetrics(new String[]{"Success"});
        Metrics childMetrics = service.createMetrics(metrics, new String[]{""});
        Assert.assertNotNull((Object)childMetrics);
    }

    @Test
    public void testMetricRemoval() {
        Metrics metrics = this.createMetrics();
        ArrayList<String> failures = new ArrayList<String>();
        Counter metric = metrics.createCounter();
        if (!metrics.remove((AbstractMetric)metric)) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!metrics.remove((AbstractMetric)(metric = metrics.createMeter()))) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!metrics.remove((AbstractMetric)(metric = metrics.createHistogram()))) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!metrics.remove((AbstractMetric)(metric = metrics.createTimer()))) {
            failures.add("Did not successfully remove " + metric.getClass().getSimpleName());
        }
        if (!failures.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : failures) {
                sb.append(s);
                sb.append("\n");
            }
            Assert.fail((String)sb.toString());
        }
    }
}

