/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services.config;

import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.junit.Assert;
import org.junit.Test;
import usace.metrics.services.config.MetricsConfig;
import usace.metrics.services.config.MetricsConfigBuilder;

public class MetricsConfigBuilderTest {
    @Test
    public void testDefaultSettings() throws BackingStoreException {
        String systemPrefix = "testing_defaults";
        boolean prefsEnabled = true;
        Preferences prefs = this.getCleanPreferences();
        prefs.putBoolean("metrics-enabled", prefsEnabled);
        System.setProperty("metrics-file-prefix", systemPrefix);
        MetricsConfig config = MetricsConfigBuilder.forDefaultSettings((Preferences)prefs);
        System.setProperty("metrics-enabled", "false");
        Assert.assertEquals((Object)prefsEnabled, (Object)config.isMetricsEnabled());
        Assert.assertEquals((Object)systemPrefix, (Object)config.getFilePrefix());
    }

    @Test
    public void testWithPreferenceOptions() throws BackingStoreException {
        boolean prefsEnabled = true;
        Preferences prefs = Preferences.userRoot().node("metrics_test");
        prefs.clear();
        prefs.putBoolean("metrics-enabled", prefsEnabled);
        MetricsConfig config = new MetricsConfigBuilder().withPreferenceOptions(prefs).build();
        Assert.assertEquals((Object)prefsEnabled, (Object)config.isMetricsEnabled());
    }

    @Test
    public void testWithSystemOptions() {
        String systemPrefix = "testing_prefix";
        System.setProperty("metrics-file-prefix", systemPrefix);
        MetricsConfig config = new MetricsConfigBuilder().withSystemPropertyOptions().build();
        Assert.assertEquals((Object)systemPrefix, (Object)config.getFilePrefix());
    }

    @Test
    public void testWithPropertiesOptions() {
        String fileLocation = "file_location";
        Properties properties = new Properties();
        properties.setProperty("metrics-file-location", fileLocation);
        MetricsConfig config = new MetricsConfigBuilder().withPropertiesFile(properties).build();
        Assert.assertEquals((Object)fileLocation, (Object)config.getPreferredFileLocation());
    }

    @Test
    public void testOrdering() throws BackingStoreException {
        String filePrefix = "testing_defaults";
        boolean enabled = true;
        String fileLocation = "file_location";
        Properties properties = new Properties();
        Preferences prefs = this.getCleanPreferences();
        prefs.putBoolean("metrics-enabled", enabled);
        properties.setProperty("metrics-file-location", fileLocation);
        System.setProperty("metrics-file-prefix", filePrefix);
        System.setProperty("metrics-enabled", "false");
        properties.setProperty("metrics-enabled", "false");
        properties.setProperty("metrics-file-prefix", "This is not the right prefix.");
        MetricsConfig config = new MetricsConfigBuilder().withPreferenceOptions(prefs).withSystemPropertyOptions().withPropertiesFile(properties).build();
        Assert.assertEquals((Object)enabled, (Object)config.isMetricsEnabled());
        Assert.assertEquals((Object)filePrefix, (Object)config.getFilePrefix());
        Assert.assertEquals((Object)fileLocation, (Object)config.getPreferredFileLocation());
    }

    private Preferences getCleanPreferences() throws BackingStoreException {
        String node = "metrics_test";
        Preferences prefs = Preferences.userRoot().node(node);
        prefs.removeNode();
        return Preferences.userRoot().node(node);
    }
}

