/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import usace.metrics.services.config.AbstractConfigUnitTest;
import usace.metrics.services.config.MetricsConfig;
import usace.metrics.services.config.MetricsInvalidValueException;

public class MetricsConfigTest
extends AbstractConfigUnitTest {
    @Test(expected=MetricsInvalidValueException.class)
    public void testSetFilePrefix_blank() {
        MetricsConfig service = this.createSavableConfig();
        service.setFilePrefix("");
        Assert.fail();
    }

    @Test(expected=MetricsInvalidValueException.class)
    public void testSetFilePrefix_null() {
        MetricsConfig service = this.createSavableConfig();
        service.setFilePrefix(null);
        Assert.fail();
    }

    @Test
    public void testSetFilePrefix_text() {
        MetricsConfig service = this.createSavableConfig();
        Assert.assertTrue((boolean)service.setFilePrefix("prefix_text"));
    }

    @Test
    public void testSetFilePrefix_text_notSavable() {
        MetricsConfig service = this.createUnsavableConfig();
        Assert.assertFalse((boolean)service.setFilePrefix("prefix_text"));
    }

    @Test
    public void testSetMaxFilesStore_0() {
        MetricsConfig service = this.createSavableConfig();
        int stored = 0;
        Assert.assertTrue((boolean)service.setMaxFilesStored(stored));
    }

    @Test
    public void testSetMaxFilesStore_0_Unsavable() {
        MetricsConfig service = this.createUnsavableConfig();
        int stored = 0;
        Assert.assertFalse((boolean)service.setMaxFilesStored(stored));
    }

    @Test
    public void testSetMaxFilesStore_max() {
        MetricsConfig service = this.createSavableConfig();
        int stored = Integer.MAX_VALUE;
        service.setMaxFilesStored(stored);
        Assert.assertEquals((long)service.getMaxFilesStored(), (long)stored);
    }

    @Test(expected=MetricsInvalidValueException.class)
    public void testSetMaxFilesStore_negative() {
        MetricsConfig service = this.createSavableConfig();
        service.setMaxFilesStored(-1);
        Assert.fail();
    }

    @Test
    public void testSetMetricsEnabled() {
        MetricsConfig service = this.createSavableConfig();
        Assert.assertTrue((boolean)service.setMetricsEnabled(true));
        Assert.assertTrue((boolean)service.isMetricsEnabled());
    }

    @Test
    public void testSetMetricsEnabled_false() {
        MetricsConfig service = this.createSavableConfig();
        service.setMetricsEnabled(false);
        Assert.assertFalse((boolean)service.isMetricsEnabled());
    }

    @Test
    public void testSetPreferredFileLocation() {
        MetricsConfig service = this.createSavableConfig();
        String prefLoc = "File";
        service.setPreferredFileLocation(prefLoc);
        String serviceLoc = service.getPreferredFileLocation();
        boolean startsWith = serviceLoc.startsWith(prefLoc);
        Assert.assertTrue((String)("Expected the preferred file location to start with \"" + prefLoc + "\" but got \"" + serviceLoc), (boolean)startsWith);
    }

    @Test(expected=MetricsInvalidValueException.class)
    public void testSetPreferredFileLocation_blank() {
        MetricsConfig service = this.createSavableConfig();
        service.setPreferredFileLocation("");
        Assert.fail();
    }

    @Test
    public void testSetCsvDelimiter_comma() {
        MetricsConfig service = this.createSavableConfig();
        String delim = ",";
        service.setCsvDelimiter(delim);
        Assert.assertEquals((Object)service.getCsvDelimiter(), (Object)delim);
    }

    @Test(expected=MetricsInvalidValueException.class)
    public void testSetCsvDelimiter_null() {
        MetricsConfig service = this.createSavableConfig();
        service.setCsvDelimiter(null);
        Assert.fail();
    }

    @Test(expected=MetricsInvalidValueException.class)
    public void testSetCsvDelimiter_blank() {
        MetricsConfig service = this.createUnsavableConfig();
        service.setCsvDelimiter("");
        Assert.fail();
    }

    @Test
    public void testCustomApp_enabledFalse() {
        MetricsConfig config = this.createTestAppConfig(new HashMap<String, Object>(), "App", Paths.get("", new String[0]), false);
        config.setMetricsEnabled(true);
        Assert.assertFalse((boolean)config.isMetricsEnabled());
    }

    @Test
    public void testCustomApp_enabledTrue() {
        MetricsConfig config = this.createTestAppConfig(new HashMap<String, Object>(), "App", Paths.get("", new String[0]), true);
        config.setMetricsEnabled(true);
        Assert.assertTrue((boolean)config.isMetricsEnabled());
    }

    @Test
    public void testCustomApp_Path() {
        String pathText = "TestPath";
        String prefLoc = "PrefLoc";
        Path path = Paths.get(pathText, new String[0]);
        MetricsConfig config = this.createTestAppConfig(new HashMap<String, Object>(), "App", path, true);
        config.setPreferredFileLocation(prefLoc);
        Path filePath = config.getMetricsFileLocation();
        filePath = filePath.toAbsolutePath();
        Assert.assertTrue((boolean)filePath.toString().contains(pathText));
        Assert.assertTrue((boolean)filePath.toString().contains(prefLoc));
    }

    @Test
    public void testCustomApp_PathNull() {
        String prefLoc = "PrefLoc";
        MetricsConfig config = this.createTestAppConfig(new HashMap<String, Object>(), "App", null, true);
        config.setPreferredFileLocation(prefLoc);
        Path filePath = config.getMetricsFileLocation();
        filePath = filePath.toAbsolutePath();
        Assert.assertTrue((boolean)filePath.endsWith(prefLoc));
    }
}

