/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.event.ModifiableListener;
import hec.lang.LockFailedException;
import hec.lang.ModelReference;
import hec.model.AltItem;
import hec.model.ModelConstants;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import rma.lang.Modifiable;

public abstract class AbstractSimRunTreeNode
extends DefaultMutableTreeNode
implements TreeWillExpandListener,
ActionListener,
ModelConstants,
ModifiableListener {
    public static final String MODIFIED_FLAG_STRING = "";
    protected Vector _models;
    protected JTree _tree;
    protected int _nextPos = 1;
    protected HashMap _modifiedAlts = new HashMap();

    public AbstractSimRunTreeNode(JTree parent) {
        this._tree = parent;
    }

    protected Vector getModels() {
        ClientApp.app();
        SupplementalRmiWorkspace wksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
        try {
            this._models = wksp.getModels(ClientApp.app().getAppType());
            return this._models;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        Object[] nodes = model.getPathToRoot(this);
        TreePath myPath = new TreePath(nodes);
        if (event.getPath().equals(myPath)) {
            if (this.isActiveRun()) {
                return;
            }
            if (this.hasActiveTrial()) {
                throw new ExpandVetoException(event);
            }
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
    }

    protected boolean setRunLocked(SimulationRun run, boolean lockit) {
        try {
            if (run == null) {
                return false;
            }
            if (lockit) {
                return run.setModelsLocked(4);
            }
            if (run.areManagersModified()) {
                run.saveManagers();
            }
            return run.setModelsLocked(5);
        }
        catch (LockFailedException e) {
            JOptionPane.showMessageDialog(this._tree, e.getMessage(), "Locked Failed", 0);
            return false;
        }
    }

    public boolean isActiveRun() {
        return false;
    }

    public boolean hasActiveTrial() {
        return false;
    }

    public void buildModelMenus(SimulationRun run, String menuName, JMenu menu, boolean useMouseListener) {
        this.buildModelMenus(run, menuName, menu);
    }

    public void buildModelMenus(SimulationRun run, String menuName, JMenu menu) {
        if (run == null) {
            return;
        }
        Vector<AltItem> altList = run.getAltList();
        if (altList == null || altList.size() < 1) {
            return;
        }
        run.removeModifiableListener(this);
        run.addModifiableListener(this);
        for (int i = 0; i < altList.size(); ++i) {
            AltItem altItem = altList.elementAt(i);
            if (altItem == null || altItem.getAltIndex() == -1) continue;
            ProgramOrderItem poi = this.getProgramOrderItem(altItem);
            String modText = MODIFIED_FLAG_STRING;
            if (poi == null) continue;
            String programName = altItem.getProgram();
            String upperCaseProgramName = programName.toUpperCase();
            String string = modText = this._modifiedAlts.get(upperCaseProgramName) != null ? MODIFIED_FLAG_STRING : MODIFIED_FLAG_STRING;
            if (poi.isStandardModel()) {
                if ("RSS".equalsIgnoreCase(upperCaseProgramName)) {
                    upperCaseProgramName = "ResSim";
                } else if (programName.toLowerCase().startsWith("hfp")) {
                    upperCaseProgramName = "HMS";
                }
            } else {
                upperCaseProgramName = altItem.getProgram();
                modText = this._modifiedAlts.get(upperCaseProgramName.toUpperCase()) != null ? MODIFIED_FLAG_STRING : MODIFIED_FLAG_STRING;
            }
            programName = upperCaseProgramName.concat(modText);
            AltItemJMenuItem menuItem = new AltItemJMenuItem(programName, altItem);
            menuItem.setName(menuName);
            if (menu.getText().equalsIgnoreCase("compute")) {
                menuItem.setToolTipText("Hold Ctrl key to force recompute");
            } else {
                menuItem.setToolTipText(this.getToolTipText(run, menuItem));
            }
            menuItem.addMouseListener(new MyMouseAdapter(menuItem));
            menu.add(menuItem);
        }
    }

    protected String getToolTipText(SimulationRun run, AltItemJMenuItem menuItem) {
        AltItem altItem = menuItem.getAltItem();
        ModelAlt modelAlt = run.getModelAlt(altItem);
        if (modelAlt != null) {
            return modelAlt.getName();
        }
        return null;
    }

    public ProgramOrderItem getProgramOrderItem(AltItem altItem) {
        if (altItem == null) {
            return null;
        }
        String programName = altItem.getProgram();
        if (programName == null) {
            return null;
        }
        if (programName.equalsIgnoreCase("RSS")) {
            return ProgramOrderItem.RSS_MODEL;
        }
        if (programName.equalsIgnoreCase("RAS")) {
            return ProgramOrderItem.RAS_MODEL;
        }
        if (programName.equalsIgnoreCase("FIA")) {
            return ProgramOrderItem.FIA_MODEL;
        }
        if (programName.equalsIgnoreCase("ResPRM")) {
            return ProgramOrderItem.RESPRM_MODEL;
        }
        if (this._models == null) {
            this.getModels();
            if (this._models == null) {
                return null;
            }
        }
        for (int i = 0; i < this._models.size(); ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)this._models.get(i);
            if (poi == null || !poi.getName().equalsIgnoreCase(programName)) continue;
            return poi;
        }
        return null;
    }

    protected void expand() {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        Object[] nodes = model.getPathToRoot(this);
        TreePath myPath = new TreePath(nodes);
        this._tree.expandPath(myPath);
    }

    public int getNextPosition() {
        return this._nextPos++;
    }

    public void modifiedStateChanged(Modifiable obj, boolean modified) {
        System.out.println("AbstractSimRunTreeNode.modifedStateChanged: got " + obj + " modified=" + modified);
        if (obj instanceof ModelAlt) {
            ModelAlt malt = (ModelAlt)obj;
            ModelReference mref = malt.getModelRef();
            String wkspName = mref.wkspName.toUpperCase();
            System.out.println("modifedStateChanged: wkspName=" + wkspName);
            if (modified) {
                this._modifiedAlts.put(wkspName, wkspName);
            } else {
                this._modifiedAlts.remove(wkspName);
            }
        }
    }

    public class AltItemJMenuItem
    extends JMenuItem {
        AltItem _altItem;

        public AltItemJMenuItem(String label, AltItem altItem) {
            super(label);
            this._altItem = altItem;
        }

        public AltItem getAltItem() {
            return this._altItem;
        }
    }

    public class MyMouseAdapter
    extends MouseAdapter {
        private JMenuItem _menuItem;

        public MyMouseAdapter(JMenuItem mi) {
            this._menuItem = mi;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this._menuItem.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                AbstractSimRunTreeNode.this.actionPerformed(new ActionEvent(this._menuItem, 1001, this._menuItem.getActionCommand(), e.getModifiers()));
            }
        }
    }
}

