/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import com.google.common.flogger.FluentLogger;
import hec.client.RunObserver;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.CreateSimulationDialog;
import hec.clientapp.client.DefaultSimulationRunDetailsPanel;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.ManagerChooser;
import hec.clientapp.client.ManagerInfoDialog;
import hec.clientapp.client.PopupMenuHandler;
import hec.clientapp.client.RMIProgressDialog;
import hec.clientapp.client.RMIProgressFile;
import hec.clientapp.client.RmiProgressImpl;
import hec.clientapp.client.RmiTextFileReaderJDialog;
import hec.clientapp.client.SelectActiveRunDialog;
import hec.clientapp.client.SimModeOptionsPanel;
import hec.clientapp.client.SimRunManagerWindow;
import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationMode;
import hec.clientapp.client.SimulationRunDetailsPanel;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTree;
import hec.clientapp.client.SimulationTreeCellRenderer;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.client.WorkspaceInfoDialog;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationExtract;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.model.StreamAlignment;
import hec.dssgui.ListSelection;
import hec.event.ActiveRunChangeListener;
import hec.heclib.util.HecTime;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.MapMouseAdapter;
import hec.map.MapToolPanel;
import hec.map.MousePanAdapter;
import hec.map.PointerMouseAdapter;
import hec.model.RunInfo;
import hec.model.RunTimeWindow;
import hec.model.UserInterface;
import hec.properties.HECProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.rmi.client.RMIProgressDisplay;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.DefaultJPanel;
import rma.swing.ProgressIndicator;
import rma.swing.RmaInsets;
import rma.swing.event.NodeSelectedListener;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.CheckBoxNode;
import rma.swing.tree.NodeSelectionListener;
import rma.util.RMAIO;

public abstract class AbstractSimulationMode
extends ClientMode
implements SimulationMode,
ActiveRunChangeListener,
ActionListener,
RunObserver,
NodeSelectedListener {
    public static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String RELOAD_LAST_SIMULATION_PROP = "SimulationModule.reloadLastSim";
    public static final String DONT_SAVE_TREE_STATE_PROP = "SimulationModule.dontSaveTreeState";
    public static final String ALWAYS_RECOMPUTE_PROP = "SimulationModule.forceRecompute";
    public static final String REUSE_COMPUTE_DIALOG_PROP = "SimulationModule.reuseComputeDialog";
    protected JLabel _startLabel;
    protected JLabel _lookbackLabel;
    protected JLabel _labelLookback;
    protected JLabel _endLabel;
    protected JLabel _simulationNameLabel;
    protected JLabel _simulationLabel;
    protected JLabel _modeLabel;
    protected JButton _executeButton;
    protected JMenuItem _editMenuItem;
    protected JMenuItem _activeRunMenuItem;
    protected JMenuItem _editAlternativeMenuItem;
    protected JMenuItem _saveMenuItem;
    protected JMenuItem _runManagerMenuItem;
    protected JMenuItem _infoMenuItem;
    protected JMenu _reportsMenu;
    protected JMenu _alternativeMenu;
    protected JMenu _simMenu;
    protected ClientMode.ManagerReopenMenu _reopenMenu;
    protected JMenuItem _closeMenuItem;
    protected CreateSimulationDialog m_simulationDialog = null;
    protected RmiFileCallBackImpl _simulationCallback;
    protected NodeSelectionListener _nodeSelectionListener;
    protected SimulationTreeNode _rootNode;
    protected SimulationTree _simulationTree;
    protected SimulationPeriod _simulation;
    protected RmiProgressImpl _progress;
    protected WorkspaceInfoDialog _infoDialog;
    protected StreamAlignment _alignment;
    protected Object _lastComputeStatus;
    protected ReflectMultiListener _listener;
    protected Vector _openedNetworks = new Vector();
    SimModeOptionsPanel _optionsPanel;
    protected boolean _simTreeOptionsInitd = false;
    protected boolean _saveSimTreeSettings = false;
    protected boolean _forceRecompute = false;
    protected boolean _reuseComputeDialog = false;
    private String _simType;
    private List<RunObserver> _runObservers = new ArrayList<RunObserver>();
    private List<ActiveRunChangeListener> _activeRunListeners = new ArrayList<ActiveRunChangeListener>();
    private SimRunManagerWindow _runManagerWindow;
    private boolean _stopRuns;
    private Map _popupMenuMap = new HashMap();
    private SimulationRunDetailsPanel _simRunDetailsPanel;

    public AbstractSimulationMode(HecClientFrame frame, String simType) {
        super(frame);
        this._simType = simType;
        this._listener = new ReflectMultiListener();
        this.createModeMenu();
        this.createModePanel();
        this.createModeToolbar();
    }

    public AbstractSimulationMode(HecClientFrame frame) {
        this(frame, "Simulation");
    }

    protected void createModeMenu() {
        JMenuItem menuItem = new JMenuItem("Script List ...", 76);
        menuItem.setName("Script_List");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "editScriptList"));
        this.addEditMenuItem(menuItem);
        this.addEditMenuSeparator();
        this._activeRunMenuItem = new JMenuItem("Set Active Alternative", 65);
        this._activeRunMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._activeRunMenuItem, "selectActiveRun"));
        this.addEditMenuItem(this._activeRunMenuItem);
        this._simMenu = new JMenu("Simulation");
        this._simMenu.setMnemonic('S');
        menuItem = new JMenuItem("New...", 78);
        menuItem.setName("SimPer_New");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "displayCreateSimulationDialog"));
        this._simMenu.add(menuItem);
        menuItem = new JMenuItem("Open...", 79);
        menuItem.setName("SimPer_Open");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "menuSimulationOpenAction"));
        this._simMenu.add(menuItem);
        this._reopenMenu = new ClientMode.ManagerReopenMenu(this, "Re-Open", 5, "Simulation");
        this._reopenMenu.setMnemonic('R');
        this._reopenMenu.setName("SimPer_ReOpen");
        this._reopenMenu.setVisible(false);
        this._simMenu.add(this._reopenMenu);
        this._closeMenuItem = new JMenuItem("Close", 67);
        this._closeMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._closeMenuItem, "menuSimulationCloseAction"));
        this._simMenu.add(this._closeMenuItem);
        this._simMenu.addSeparator();
        this._editMenuItem = new JMenuItem("Edit...", 69);
        this._editMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._editMenuItem, "editSimulation"));
        this._simMenu.add(this._editMenuItem);
        this._saveMenuItem = new JMenuItem("Save", 83);
        this._saveMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._saveMenuItem, "saveSimulation"));
        this._simMenu.add(this._saveMenuItem);
        menuItem = new JMenuItem("Delete...", 68);
        menuItem.setName("SimPer_Delete");
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "menuSimulationDeleteAction"));
        this._simMenu.add(menuItem);
        this._infoMenuItem = new JMenuItem("Info...", 73);
        this._infoMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._infoMenuItem, "menuSimulationInfoAction"));
        this._simMenu.add(this._infoMenuItem);
        this._runManagerMenuItem = new JMenuItem("Run Manager...", 82);
        this._runManagerMenuItem.setName("runManager");
        this._runManagerMenuItem.setEnabled(false);
        this._runManagerMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._runManagerMenuItem, "displayRunManagerDialog"));
        this._simMenu.add(this._runManagerMenuItem);
        this.addMenu(this._simMenu);
        this._alternativeMenu = new JMenu("Alternative");
        this._alternativeMenu.setMnemonic('A');
        this._editAlternativeMenuItem = new JMenuItem("Edit...", 69);
        this._editAlternativeMenuItem.setName("Sim_Alternative");
        this._editAlternativeMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._editAlternativeMenuItem, "displayAlternativeEditor"));
        this._alternativeMenu.add(this._editAlternativeMenuItem);
        this.addMenu(this._alternativeMenu);
        this._reportsMenu = new JMenu("Reports");
        this._reportsMenu.setMnemonic('R');
    }

    protected void createModePanel() {
        JPanel simulationControlPanel = new JPanel(new GridBagLayout());
        this._modeLabel = new JLabel("    Simulation Control    ");
        this._modeLabel.setOpaque(true);
        this._modeLabel.setBackground(new Color(0, 128, 128));
        this._modeLabel.setForeground(Color.white);
        this._modeLabel.setFont(new Font("Dialog", 1, 14));
        this._modeLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        simulationControlPanel.add((Component)this._modeLabel, gbc);
        this._simulationNameLabel = new JLabel("Simulation: ", 4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)this._simulationNameLabel, gbc);
        this._startLabel = new JLabel("                                    ");
        this._startLabel.setName("");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)this._startLabel, gbc);
        this._labelLookback = new JLabel("Lookback: ", 4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)this._labelLookback, gbc);
        this._lookbackLabel = new JLabel("     ");
        this._lookbackLabel.setName("");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)this._lookbackLabel, gbc);
        JLabel label = new JLabel("End: ", 4);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)label, gbc);
        this._endLabel = new JLabel("     ");
        this._endLabel.setName("");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)this._endLabel, gbc);
        JSeparator separator = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)0);
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        simulationControlPanel.add((Component)separator, gbc);
        this._rootNode = this.createRootNode();
        this._simulationTree = this.createSimulationTree(this._rootNode);
        this._simulationTree.addActiveRunChangeListener(this);
        this._rootNode.setTree(this._simulationTree);
        this._simulationTree.addActiveRunChangeListener(this);
        this._nodeSelectionListener = new NodeSelectionListener(this._simulationTree){

            public void mousePressed(MouseEvent e) {
                if (ClientApp.Workspace() == null) {
                    return;
                }
                super.mousePressed(e);
            }
        };
        this._nodeSelectionListener.addNodeSelectedListener((NodeSelectedListener)this);
        this._simulationTree.addMouseListener((MouseListener)this._nodeSelectionListener);
        this._simulationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object lastPathComponent = null;
                TreePath path = AbstractSimulationMode.this._simulationTree.getSelectionPath();
                if (path != null) {
                    lastPathComponent = path.getLastPathComponent();
                }
                if (lastPathComponent instanceof SimulationRunTreeNode) {
                    SimulationRunTreeNode treeNode;
                    SimulationRun run = null;
                    if (lastPathComponent instanceof SimTrialRunTreeNode) {
                        treeNode = (SimTrialRunTreeNode)lastPathComponent;
                        run = ((SimTrialRunTreeNode)treeNode).getTrialSimulationRun();
                    } else {
                        treeNode = (SimulationRunTreeNode)lastPathComponent;
                        run = treeNode.getSimulationRun();
                    }
                    SimulationPeriod period = ((SimulationRunTreeNode)lastPathComponent).getSimulation();
                    if (AbstractSimulationMode.this._simRunDetailsPanel != null) {
                        AbstractSimulationMode.this._simRunDetailsPanel.fillPanel(period, run);
                    }
                } else if (AbstractSimulationMode.this._simRunDetailsPanel != null) {
                    AbstractSimulationMode.this._simRunDetailsPanel.fillPanel(null, null);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)2, (int)0, (int)2, (int)0);
        gbc.weighty = 1.1;
        gbc.weightx = 1.0;
        gbc.gridheight = 1;
        simulationControlPanel.add((Component)new JScrollPane(this._simulationTree), gbc);
        this._simRunDetailsPanel = this.createSimulationRunDetailsPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)2, (int)0, (int)2, (int)0);
        simulationControlPanel.add((Component)((Object)this._simRunDetailsPanel), gbc);
        this._executeButton = new JButton("Compute");
        this._executeButton.setToolTipText("Hold Ctrl key to force recompute");
        this._executeButton.setMnemonic('C');
        this._executeButton.setName("ForecastRun");
        this._executeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AbstractSimulationMode.this._executeButton.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                    int modifiers = e.getModifiers();
                    if (AbstractSimulationMode.this.getForceRecompute()) {
                        modifiers |= 2;
                    }
                    AbstractSimulationMode.this.actionPerformed(new ActionEvent(AbstractSimulationMode.this._executeButton, 1001, AbstractSimulationMode.this._executeButton.getActionCommand(), modifiers));
                }
            }
        });
        Dimension d = new Dimension();
        d.height = 25;
        d.width = 200;
        this._executeButton.setPreferredSize(d);
        this._executeButton.setMaximumSize(d);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)2, (int)0);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        simulationControlPanel.add((Component)this._executeButton, gbc);
        JPanel panel = new JPanel(new BorderLayout()){
            Dimension dd;
            {
                this.dd = null;
            }

            @Override
            public Dimension getPreferredSize() {
                if (this.dd == null) {
                    this.dd = super.getPreferredSize();
                }
                return this.dd;
            }
        };
        this.createScriptPanel();
        this._scriptPanel.setBorderWhenActive(new TitledBorder("Scripts"));
        panel.add((Component)this._scriptPanel.getScrollPane(), "Center");
        JSplitPane splitPane = new JSplitPane(0, simulationControlPanel, panel);
        splitPane.setResizeWeight(0.4);
        simulationControlPanel.setBorder(null);
        panel.setBorder(null);
        splitPane.setBorder(null);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this.addControlPanelComponent(splitPane, gbc);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    AbstractSimulationMode.this.displayTimeWindowPopup(e);
                }
            }
        };
        this._simulationNameLabel.addMouseListener(ml);
        this._startLabel.addMouseListener(ml);
        this._endLabel.addMouseListener(ml);
        this._lookbackLabel.addMouseListener(ml);
        this._labelLookback.addMouseListener(ml);
        label.addMouseListener(ml);
    }

    protected SimulationRunDetailsPanel createSimulationRunDetailsPanel() {
        return new DefaultSimulationRunDetailsPanel();
    }

    protected void displayTimeWindowPopup(MouseEvent e) {
        if (this.getSimulation() == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Copy TimeWindow");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimulationMode.this.copyTimeWindow();
            }
        });
        popup.add(mi);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void copyTimeWindow() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection s = null;
        StringBuffer buf = new StringBuffer();
        buf.append("TimeWindow:");
        buf.append("\n");
        buf.append(RMAIO.removeChar((String)this._lookbackLabel.getText(), (char)' '));
        buf.append("\n");
        buf.append(RMAIO.removeChar((String)this._startLabel.getText(), (char)' '));
        buf.append("\n");
        buf.append(RMAIO.removeChar((String)this._endLabel.getText(), (char)' '));
        buf.append("\n");
        s = new StringSelection(buf.toString());
        cb.setContents(s, s);
    }

    protected void createModeToolbar() {
        this.setMapTools(new MapToolPanel(this._frame.getMapPanel()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        JToggleButton button = new JToggleButton();
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr.up = "Images/Point.gif";
        bgstr.down = "Images/Point.gif";
        bgstr.over = "Images/Point.gif";
        bgstr.on = "Images/Point.gif";
        bgstr.toolTipText = "Pointer Tool";
        bgstr.borderPainted = true;
        Class<? extends MapMouseAdapter> adapterClass = this.getPointerMouseToolClass();
        if (adapterClass != null) {
            bgstr.adapter = adapterClass.getName();
            this._mapTools.addToolButton(button, bgstr);
        }
        button = new JToggleButton();
        bgstr = new ButtonGifStrings();
        bgstr.up = "Images/ZoomUp.gif";
        bgstr.down = "Images/ZoomDown.gif";
        bgstr.over = "Images/ZoomUp.gif";
        bgstr.on = "Images/ZoomDown.gif";
        bgstr.toolTipText = "Zoom Tool";
        bgstr.borderPainted = true;
        bgstr.adapter = "hec.map.MouseZoomAdapter";
        bgstr.cursorType = 1;
        this._mapTools.addToolButton(button, bgstr);
        if (this.hasPanMouseAdapter()) {
            button = new JToggleButton();
            bgstr = MousePanAdapter.buildDefaultButtonGifStrings();
            gbc.weighty = 1.0;
            this._mapTools.addToolButton(button, bgstr);
        }
        this._mapTools.forceSelectButton(0);
    }

    protected boolean hasPanMouseAdapter() {
        return true;
    }

    protected Class<? extends MapMouseAdapter> getPointerMouseToolClass() {
        return PointerMouseAdapter.class;
    }

    protected SimulationTree createSimulationTree(SimulationTreeNode rootNode) {
        SimulationTree tree = new SimulationTree(rootNode);
        tree.setCellRenderer((TreeCellRenderer)((Object)new SimulationTreeCellRenderer()));
        return tree;
    }

    protected SimulationTreeNode createRootNode() {
        return new SimulationTreeNode();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem mitem;
        Object obj = e.getSource();
        if (obj == this._executeButton) {
            boolean recomputeAll = (e.getModifiers() & 2) != 0;
            this.computeRun(this.getActiveRun(), -1, recomputeAll);
        } else if (obj instanceof JMenuItem && "reopen".equals((mitem = (JMenuItem)obj).getActionCommand())) {
            String path = mitem.getName();
            if (path == null) {
                return;
            }
            Identifier id = new Identifier(path);
            id.setName(mitem.getText());
            this.openSimulation(id);
        }
    }

    @Override
    public boolean objectPopupMenu(NamedType obj, LocalPt pt) {
        PopupMenuHandler handler = this.getPopupMenuHandler(obj);
        if (handler != null) {
            handler.objectPopupMenu(new NamedType[]{obj}, pt);
            return true;
        }
        return false;
    }

    @Override
    public boolean objectPopupMenu(NamedType[] objs, LocalPt pt) {
        return this.getPopupMenuHandler(objs[0]).objectPopupMenu(objs, pt);
    }

    protected abstract void updateMenus();

    public abstract PopupMenuHandler getPopupMenuHandler();

    public PopupMenuHandler getPopupMenuHandler(NamedType obj) {
        if (obj == null) {
            return null;
        }
        Object popupObj = this._popupMenuMap.get(obj.getClass());
        if (!(popupObj instanceof PopupMenuHandler)) {
            return this.getPopupMenuHandler();
        }
        return (PopupMenuHandler)popupObj;
    }

    public void addPopupMenuHandler(Class dataClass, PopupMenuHandler handler) {
        this._popupMenuMap.put(dataClass, handler);
    }

    public void removePopupMenuHandler(NamedType obj) {
        if (obj != null) {
            this._popupMenuMap.remove(obj.getClass());
        }
    }

    protected abstract void closeAlternativeEditor();

    protected abstract String getWorkspaceType();

    protected abstract String getSimulationType();

    protected abstract SimulationExtract getExtractModel();

    @Override
    public void updateWorkspace() {
        super.updateWorkspace();
        this.updateManagerMaps();
    }

    @Override
    public void resetWorkspace() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return;
        }
        this._alignment = null;
        this.setActiveSimRun(null);
        super.resetWorkspace();
        this._reopenMenu.setWorkspacePath(wksp.getWorkspacePath());
        this._reopenMenu.loadMenus();
        if ("true".equalsIgnoreCase(ClientApp.app().getAppProp(RELOAD_LAST_SIMULATION_PROP)) && this._reopenMenu.getMenuComponentCount() > 0) {
            JMenuItem mitem = (JMenuItem)this._reopenMenu.getMenuComponent(0);
            String path = mitem.getName();
            if (path == null) {
                return;
            }
            Identifier id = new Identifier(path);
            id.setName(mitem.getText());
            this.openSimulation(id);
        }
        this._reportsMenu.setEnabled(false);
        this.loadScripts();
    }

    @Override
    public boolean workspaceClosing() {
        if (!this.setSimulation(null)) {
            return false;
        }
        this._reopenMenu.saveMenus();
        this.modeClosing();
        return true;
    }

    @Override
    public void updateManagerMaps() {
        if (!this.isCurrentMode()) {
            return;
        }
        this.setActiveSimRun(this._simulationTree.getActiveRun());
        this.updateComputeButton();
        SimulationPeriod sim = this.getSimulation();
        this.setSimulationDisplayTimes(sim);
        this.addManagerMaps();
        this.updateMenus();
        this._frame.getMapPanel().paintMap();
    }

    public void addManagerMaps() {
        Vector<Manager> vec = new Vector<Manager>();
        if (this._alignment != null) {
            vec.addElement(this._alignment);
        }
        if (this.getActiveRun() != null) {
            vec.addElement(this.getActiveRun());
        }
        this._frame.getMapPanel().resetManagerMaps(vec);
        this._frame.setGlyphStateFromToolbar();
    }

    @Override
    public SimulationPeriod getSimulation() {
        return this._simulation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSimulation(SimulationPeriod period) {
        try {
            this._frame.setWaitCursor();
            SimulationPeriod simulation = this.getSimulation();
            this.closeAlternativeEditor();
            if (simulation != null && period != simulation) {
                if (this.checkAndSaveManagerChanges(ClientApp.app().getAppType(), simulation, simulation.getClass().getName(), "Simulation", false) < 1) {
                    boolean bl = false;
                    return bl;
                }
                if (this.isCurrentMode()) {
                    this._frame.getMapPanel().resetManagerMaps(null);
                }
                ClientApp.Workspace().unloadManager(ClientApp.app().getAppType(), simulation.getIdentifier());
                simulation.unloading();
                System.gc();
            }
            if (simulation != null) {
                this.unlockManager(simulation, "Failed to unlock Simulation " + simulation.getName(), this._simulationCallback, null, 2);
            }
            if (this.isCurrentMode()) {
                this._frame.getMapPanel().resetManagerMaps(null);
            }
            this._alignment = null;
            this.setActiveSimRun(null);
            if (period != null) {
                RmiFileCallBackImpl[] callbackHolder = new RmiFileCallBackImpl[1];
                if (this.lockManager(period, "Failed to lock Simulation " + period.getName(), null, null, callbackHolder, 3)) {
                    this._simulationCallback = callbackHolder[0];
                    this._simulation = period;
                    this._frame.printStatus("Loading Simulation...");
                    this._runManagerMenuItem.setEnabled(true);
                    this._alignment = this._simulation.getStreamAlignment();
                }
            } else {
                this._simulation = null;
            }
            this._rootNode.setSimulation(period);
            DefaultTreeModel model = (DefaultTreeModel)this._simulationTree.getModel();
            model.nodeChanged(this._rootNode);
            model.nodeStructureChanged(this._rootNode);
            this._simulationTree.revalidate();
            this._reportsMenu.setEnabled(this._simulation != null);
            this.activeRunChanged(new ChangeEvent(this._simulationTree));
            SimulationRun activeRun = this.getActiveRun();
            if (activeRun != null) {
                activeRun.setModified(false);
                SimulationRunTreeNode node = this._rootNode.getActiveNode();
                if (node != null) {
                    Object[] path = node.getPath();
                    this._simulationTree.setSelectionPath(new TreePath(path));
                }
            } else if (this._rootNode.getChildCount() > 0) {
                Object[] path = ((DefaultMutableTreeNode)this._rootNode.getChildAt(0)).getPath();
                this._simulationTree.setSelectionPath(new TreePath(path));
            }
            this._alternativeMenu.setEnabled(this._simulation != null);
            if (this._runManagerWindow != null && this._runManagerWindow.isVisible()) {
                this._runManagerWindow.fillForm(this);
            } else {
                this._runManagerWindow = null;
            }
            if (this.isCurrentMode()) {
                this.updateManagerMaps();
                this._frame.validate();
                this._frame.invalidate();
                this._frame.repaint();
            }
        }
        finally {
            this._frame.setDefaultCursor();
        }
        return true;
    }

    protected void setSimulationDisplayTimes(Simulation simulation) {
        if (simulation == null) {
            this._lookbackLabel.setText("");
            this._startLabel.setText("");
            this._endLabel.setText("");
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy, HHmm");
            HecTime temp = new HecTime();
            TimeZone dataTimeZone = ClientApp.Workspace().getWatershedTimeZone();
            TimeZone displayTimeZone = ClientApp.app().getClientTimeZone();
            dateFormat.setTimeZone(displayTimeZone);
            temp.set(simulation.getLookbackDateString());
            Date date = temp.getJavaDate(dataTimeZone.getRawOffset() / 60000);
            this._lookbackLabel.setText(dateFormat.format(date));
            temp.set(simulation.getStartDateString());
            date = temp.getJavaDate(dataTimeZone.getRawOffset() / 60000);
            this._startLabel.setText(dateFormat.format(date));
            temp.set(simulation.getEndDateString());
            date = temp.getJavaDate(dataTimeZone.getRawOffset() / 60000);
            this._endLabel.setText(dateFormat.format(date));
        }
    }

    @Override
    public void setClientTimeZone(TimeZone tz) {
        this.setSimulationDisplayTimes(this.getSimulation());
    }

    @Override
    public void openSimulation() {
        this.menuSimulationOpenAction();
    }

    public boolean openSimulation(String simulationName) {
        if (simulationName == null) {
            return false;
        }
        SimulationPeriod currentSim = this.getSimulation();
        if (currentSim != null && simulationName.equals(currentSim.getName())) {
            return true;
        }
        Vector<Identifier> idList = ClientApp.Workspace().getManagerIDList(ClientApp.app().getAppType(), SimulationPeriod.class.getName());
        if (idList == null || idList.size() == 0) {
            System.out.println("openSimulation: no Simulations in watershed");
            return false;
        }
        for (int i = 0; i < idList.size(); ++i) {
            Identifier id = idList.get(i);
            if (!simulationName.equals(id.getName())) continue;
            this.openSimulation(id);
            return true;
        }
        System.out.println("openSimulation: simulation " + simulationName + " not found");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuSimulationOpenAction() {
        if (ClientApp.Workspace() == null) {
            ClientApp.app().postError("You must first open a Watershed", "Error");
            return;
        }
        SimulationPeriod newmanager = (SimulationPeriod)this.chooseManager(this.getWorkspaceType(), this.getSimulation(), "hec.clientapp.model.SimulationPeriod", this._simType);
        if (newmanager == null || newmanager.getReadOnly()) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Failed to load Simulation: " + newmanager);
            return;
        }
        if (this._simulation == newmanager) {
            return;
        }
        String[] stringArrayBindingSites = null;
        try {
            this._frame.setWaitCursor();
            try {
                stringArrayBindingSites = ClientApp.app().getAppServer().getBindingSites();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            newmanager.loadWorkspace(!ClientApp.app().networked ? null : stringArrayBindingSites[0], ClientApp.Workspace().getWorkspacePath());
            this.setSimulation(newmanager);
            this._reopenMenu.addMenuItem(newmanager.getIdentifier());
        }
        catch (RuntimeException rte) {
            String msg = rte.getMessage();
            String msg2 = new MessageFormat(msg).format(new Object[]{"simulation", "Simulation"});
            ClientApp.app().errMsgBox(new Msg("Error opening Simulation  " + msg2, 1));
            return;
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSimulation(Identifier newid) {
        this._frame.setWaitCursor();
        try {
            SimulationPeriod newSimulation = (SimulationPeriod)ClientApp.Workspace().openManager(ClientApp.app().getAppType(), newid);
            if (newSimulation == null || newSimulation.getReadOnly()) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Failed to load Simulation: " + newSimulation);
                ClientApp.app().postError("Failed to load Simulation: " + newSimulation + ". See Console Log for more details.", "Error");
                this._reopenMenu.deleteMenuItem(newid);
                return;
            }
            String[] stringArrayBindingSites = null;
            try {
                stringArrayBindingSites = ClientApp.app().getAppServer().getBindingSites();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                newSimulation.loadWorkspace(!ClientApp.app().networked ? null : stringArrayBindingSites[0], ClientApp.Workspace().getWorkspacePath());
            }
            catch (RuntimeException rte) {
                String msg = rte.getMessage();
                String msg2 = new MessageFormat(msg).format(new Object[]{"simulation", "Simulation"});
                ClientApp.app().errMsgBox(new Msg("Error opening Simulation  " + msg2, 1));
                this._frame.setDefaultCursor();
                return;
            }
            this.setSimulation(newSimulation);
            this._reopenMenu.addMenuItem(newid);
            this.updateManagerMaps();
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    @Override
    public void createNewSimulation() {
        this.displayCreateSimulationDialog();
    }

    public SimulationPeriod createSimulation(String name, String desc, String lookbackDateTime, String startDateTime, String endDateTime, int timeStep, int timeStepIncrement, String[] selectedAlternatives) {
        if (ClientApp.Workspace() == null) {
            System.out.println("createSimulation:no Watershed opened");
            return null;
        }
        if (this.simulationExists(name)) {
            System.out.println("createSimulation:Simulation " + name + " already exists");
            return null;
        }
        HecTime lbTime = new HecTime(lookbackDateTime);
        HecTime sdTime = new HecTime(startDateTime);
        HecTime edTime = new HecTime(endDateTime);
        if (lbTime.greaterThan(sdTime)) {
            System.out.println("createSimulation:Invalid lookback/start date-time lookback=" + lbTime + " start=" + sdTime);
            return null;
        }
        if (edTime.lessThan(sdTime)) {
            System.out.println("createSimulation:Invalid start/end date-time start=" + sdTime + " end=" + edTime);
            return null;
        }
        Vector<Identifier> idList = ClientApp.Workspace().getManagerIDList(this.getWorkspaceType(), "hec.clientapp.model.SimulationPeriod");
        SimulationPeriod simulation = (SimulationPeriod)super.createNewManager(this.getWorkspaceType(), null, "hec.clientapp.model.SimulationPeriod", SimulationPeriod.FILE_EXT, this.getSimulationType(), idList, name);
        if (simulation != null) {
            System.out.println("createSimulation:created simulation " + simulation.getName());
            this.finishCreatingSimulation(simulation, desc, lookbackDateTime, startDateTime, endDateTime, timeStep, timeStepIncrement, selectedAlternatives, true);
            ClientApp.Workspace().saveManager(simulation);
        } else {
            System.out.println("createSimulation:failed to create simulation " + name);
        }
        return simulation;
    }

    public void displayCreateSimulationDialog() {
        if (ClientApp.Workspace() == null) {
            ClientApp.app().postError("You must first open a Watershed", "Error");
            return;
        }
        System.out.println("displayCreateSimulationDialog:*** starting new simulation ***");
        Vector<Identifier> idList = ClientApp.Workspace().getManagerIDList(this.getWorkspaceType(), "hec.clientapp.model.SimulationPeriod");
        SimulationPeriod simulation = (SimulationPeriod)super.createNewManager(this.getWorkspaceType(), null, "hec.clientapp.model.SimulationPeriod", SimulationPeriod.FILE_EXT, this.getSimulationType(), idList);
        if (simulation == null) {
            this._frame.repaint();
            return;
        }
        this.finishCreatingSimulation(simulation, this.m_simulationDialog.getDescription(), this.m_simulationDialog.getLookbackDate(), this.m_simulationDialog.getStartDate(), this.m_simulationDialog.getEndDate(), this.m_simulationDialog.getTimestep(), this.m_simulationDialog.getTimeStepType(), this.m_simulationDialog.getSelectedRuns(), this.m_simulationDialog.runSimulationExtract());
    }

    protected void finishCreatingSimulation(final SimulationPeriod simulation, final String description, final String lookbackDate, final String startDate, final String endDate, final int timeStep, final int timeStepIncrement, final String[] selectedRuns, final boolean runSimulationExtract) {
        this._frame.setWaitCursor();
        simulation.setSimulationRunClass(this.getSimulationRunClass());
        simulation.setSimulationAppType(ClientApp.app().getAppType());
        simulation.setKeyLength(this.getAlternativeKeyLength());
        simulation.setMaxAlternativeNameLength(this.getMaxAlternativeKeyLength());
        final ProgressIndicator pi = new ProgressIndicator((JFrame)((Object)this._frame), 100L, "Creating " + this._simType);
        simulation.setUserInterface((UserInterface)pi);
        this._reopenMenu.addMenuItem(simulation.getIdentifier());
        pi.setRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    SimulationTreeNode simNode;
                    pi.printMessage("Setting " + AbstractSimulationMode.this._simType + " Information...");
                    pi.setProgress(5);
                    simulation.setDescription(description);
                    simulation.getIdentifier().setDescription(description);
                    simulation.setStartDate(startDate);
                    simulation.setEndDate(endDate);
                    simulation.setLookbackDate(lookbackDate);
                    pi.setProgress(10);
                    pi.printMessage("Loading " + AbstractSimulationMode.this._simType + " Workapce to Copy");
                    simulation.setModified(true);
                    simulation.setTimeStep(timeStep, timeStepIncrement);
                    String[] stringArrayBindingSites = null;
                    try {
                        stringArrayBindingSites = ClientApp.app().getAppServer().getBindingSites();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    try {
                        simulation.loadWorkspace(!ClientApp.app().networked ? null : stringArrayBindingSites[0], ClientApp.app().getAppStartDir());
                    }
                    catch (RuntimeException rte) {
                        pi.setProgress(100);
                        pi.computeComplete();
                        String msg = rte.getMessage();
                        String msg2 = new MessageFormat(msg).format(new Object[]{"simulation", "Simulation"});
                        ClientApp.app().errMsgBox(new Msg("Error opening Simulation  " + msg2, 1));
                        return;
                    }
                    if (selectedRuns != null) {
                        for (int i = 0; i < selectedRuns.length; ++i) {
                            System.out.println("adding " + AbstractSimulationMode.this._simType + " run " + selectedRuns[i]);
                        }
                    } else {
                        System.out.println("run:no SimulationRuns to add to " + simulation.getName());
                    }
                    try {
                        simulation.setSimulationRunClass(AbstractSimulationMode.this.getSimulationRunClass());
                        simulation.setAlternatives(selectedRuns);
                    }
                    catch (Exception e) {
                        System.out.println("Error setting alternatives in new Simulation " + e);
                        ClientApp.app().postError("Error occurred during creation of " + AbstractSimulationMode.this._simType, "Error");
                        e.printStackTrace();
                        AbstractSimulationMode.this._frame.setDefaultCursor();
                        pi.computeComplete();
                        return;
                    }
                    pi.setProgress(50);
                    simulation.setSimulationRunClass(AbstractSimulationMode.this.getSimulationRunClass());
                    simulation.writeFile(simulation.getIdentifier());
                    simulation.setReloadOk(false);
                    simulation.setUserInterface(AbstractSimulationMode.this._frame);
                    AbstractSimulationMode.this.setSimulation(simulation);
                    Object root = AbstractSimulationMode.this._simulationTree.getModel().getRoot();
                    if (root instanceof SimulationTreeNode && (simNode = (SimulationTreeNode)root).getChildCount() > 0) {
                        SimulationRunTreeNode child = (SimulationRunTreeNode)simNode.getChildAt(0);
                        SimulationRun simRun = child.getSimulationRun();
                        AbstractSimulationMode.this.setActiveRun(simRun);
                    }
                    pi.setProgress(75);
                    if (runSimulationExtract) {
                        pi.printMessage("Running Time Series Extract");
                        AbstractSimulationMode.this.runSimulationExtract();
                    }
                    AbstractSimulationMode.this.createModelRunFiles(simulation);
                    pi.setProgress(100);
                    AbstractSimulationMode.this._frame.setDefaultCursor();
                    pi.computeComplete();
                    System.out.println("finishCreatingSimulation:*** new Simulation Created ***");
                }
                catch (Throwable t) {
                    System.out.println("finishCreatingSimulation: error creating simulation " + t);
                    pi.computeComplete();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog((Component)((Object)AbstractSimulationMode.this._frame), "Error creating Simulation " + t, "Error", 0);
                        }
                    });
                }
            }
        });
        pi.setVisible(true);
        this._frame.repaint();
    }

    protected void createModelRunFiles(SimulationPeriod simulation) {
    }

    @Override
    public void closeSimulation() {
        SimulationPeriod simulation = this.getSimulation();
        if (simulation == null) {
            return;
        }
        this.setSimulation(null);
    }

    public void menuSimulationCloseAction() {
        this.closeSimulation();
    }

    public abstract void runSimulationExtract();

    @Override
    public void editSimulation() {
        final SimulationPeriod simulation = this.getSimulation();
        if (simulation == null) {
            ClientApp.app().postWarning("Please open a Simulation first", "");
            return;
        }
        RmiFileCallBackImpl[] callbackHolder = new RmiFileCallBackImpl[1];
        if (!this.lockManager(simulation, "Failed to lock Simulation " + simulation.getName() + " for editing.", null, null, callbackHolder)) {
            return;
        }
        this._simulationCallback = callbackHolder[0];
        if (this.m_simulationDialog == null) {
            this.m_simulationDialog = this.getSimulationDialog((Frame)((Object)this._frame), true);
        }
        this.m_simulationDialog.setEditMode(1);
        this.m_simulationDialog.setTablePanelBorderTitle(this.getTablePanelBorder());
        this.m_simulationDialog.fillForm(simulation);
        this.m_simulationDialog.setVisible(true);
        this.unlockManager(simulation, "Failed to unlock Simulation " + simulation.getName(), this._simulationCallback, null);
        if (this.m_simulationDialog.isCanceled()) {
            return;
        }
        final ProgressIndicator pi = new ProgressIndicator((JFrame)((Object)this._frame), 100L, "Updating " + this._simType);
        simulation.setUserInterface((UserInterface)pi);
        pi.setRunnable(new Runnable(){

            @Override
            public void run() {
                pi.printMessage("Updating " + AbstractSimulationMode.this._simType + " Information...");
                RunTimeWindow rtw = simulation.getRunTimeWindow();
                boolean recomputeAll = false;
                if (!AbstractSimulationMode.this.m_simulationDialog.getLookbackDate().equals(rtw.getLookbackTime())) {
                    recomputeAll = true;
                } else if (!AbstractSimulationMode.this.m_simulationDialog.getEndDate().equals(rtw.getEndTime())) {
                    recomputeAll = true;
                }
                simulation.setDescription(AbstractSimulationMode.this.m_simulationDialog.getDescription());
                simulation.getIdentifier().setDescription(simulation.getDescription());
                simulation.setComputeAll(recomputeAll);
                simulation.setModified(true);
                simulation.setTimeStep(AbstractSimulationMode.this.m_simulationDialog.getTimestep(), AbstractSimulationMode.this.m_simulationDialog.getTimeStepType());
                ClientApp.app().getAppStartDir();
                String[] selectedRuns = AbstractSimulationMode.this.m_simulationDialog.getSelectedRuns();
                pi.setProgress(5);
                pi.printMessage("Setting Selected " + AbstractSimulationMode.this._simType + " Runs...");
                simulation.setAlternatives(selectedRuns);
                simulation.setLookbackDate(AbstractSimulationMode.this.m_simulationDialog.getLookbackDate());
                simulation.setEndDate(AbstractSimulationMode.this.m_simulationDialog.getEndDate());
                simulation.writeFile(simulation.getIdentifier());
                simulation.setUserInterface(ClientApp.frame());
                AbstractSimulationMode.this.setSimulation(simulation);
                pi.setProgress(10);
                if (AbstractSimulationMode.this.m_simulationDialog.runSimulationExtract()) {
                    pi.printMessage("Running Time Series Extract");
                    AbstractSimulationMode.this.runSimulationExtract();
                }
                AbstractSimulationMode.this._frame.setDefaultCursor();
                pi.computeComplete();
                AbstractSimulationMode.this.simulationEditComplete();
            }
        });
        pi.setVisible(true);
        this._simulationTree.revalidate();
        this._frame.repaint();
    }

    protected void simulationEditComplete() {
    }

    @Override
    public void saveSimulation() {
        SimulationPeriod simulation = this.getSimulation();
        if (simulation == null) {
            return;
        }
        if (!ClientApp.Workspace().saveManager(ClientApp.app().getAppType(), simulation)) {
            this.menuSimulationSaveAsAction();
        }
    }

    public void menuSimulationDeleteAction() {
        Identifier id;
        int i;
        ManagerChooser chooser = new ManagerChooser((Frame)((Object)this._frame), true);
        chooser.setMode(2);
        chooser.setMultipleSelectionsAllowed(true);
        chooser.setTitle("Delete " + this._simType);
        chooser.setManagerType(ClientApp.app().getAppType(), "hec.clientapp.model.SimulationPeriod", this._simType, this._simType.toLowerCase());
        chooser.setDeleteConfirmMessage("<html>Do you really want to delete " + this._simType + " <br><b>", "</b> and all its files?</html>");
        chooser.setVisible(true);
        if (!chooser.ok()) {
            return;
        }
        Vector idList = chooser.getIdentifierList();
        int size = idList.size();
        if (size == 0) {
            System.out.println("No " + this._simType + " selected to delete");
            return;
        }
        for (i = 0; i < size; ++i) {
            id = (Identifier)idList.get(i);
            SimulationPeriod current = this.getSimulation();
            if (current == null || !current.getIdentifier().getPath().equals(id.getPath())) continue;
            this.setSimulation(null);
        }
        for (i = 0; i < size; ++i) {
            try {
                ClientApp.Workspace().getDssFileManager().closeAndClear();
            }
            catch (RemoteException e) {
                System.out.println("menuSimulationDeleteAction: RemoteException closing DSS files" + e);
            }
            id = (Identifier)idList.get(i);
            boolean success = ClientApp.Workspace().deleteManager(ClientApp.app().getAppType(), id);
            if (!success) {
                System.out.println("Unable to delete specified system " + id.getPath());
                continue;
            }
            this._reopenMenu.deleteMenuItem(id);
        }
        this.updateManagerMaps();
    }

    public boolean deleteSimulation(String simulationName) {
        if (simulationName == null) {
            return false;
        }
        ManagerProxy proxy = this.findSimulationProxy(simulationName);
        if (proxy == null) {
            System.out.println("deleteSimulation:failed to find ManagerProxy for " + simulationName);
            return false;
        }
        SimulationPeriod currentSim = this.getSimulation();
        if (currentSim != null && currentSim == proxy.getManager()) {
            this.setSimulation(null);
        }
        Identifier id = proxy.getId();
        return ClientApp.Workspace().deleteManager(this.getWorkspaceType(), id);
    }

    private ManagerProxy findSimulationProxy(String simulationName) {
        if (simulationName == null) {
            return null;
        }
        if (ClientApp.Workspace() == null) {
            return null;
        }
        Vector<ManagerProxy> simProxyList = ClientApp.Workspace().getManagerProxyList(this.getWorkspaceType(), SimulationPeriod.class.getName());
        if (simProxyList == null) {
            return null;
        }
        for (int i = 0; i < simProxyList.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)simProxyList.get(i);
            if (proxy == null || !simulationName.equals(proxy.getName())) continue;
            return proxy;
        }
        return null;
    }

    public boolean simulationExists(String simulationName) {
        return this.findSimulationProxy(simulationName) != null;
    }

    void menuSimulationSaveAsAction() {
        ManagerChooser chooser = new ManagerChooser((Frame)((Object)this._frame), true);
        chooser.setMode(1);
        chooser.setTitle("Save " + this._simType);
        chooser.setManagerType(ClientApp.app().getAppType(), "hec.clientapp.model.SimulationPeriod", ClientApp.app().getAppType(), this._simType);
        chooser.setVisible(true);
        Identifier id = chooser.getIdentifier();
        if (id == null) {
            return;
        }
        boolean success = ClientApp.Workspace().saveManagerAs(this.getSimulation(), id);
        if (!success) {
            System.out.println("Unable to save system");
        }
    }

    public void activeRunChanged(ChangeEvent evt) {
        if (evt.getSource() == this._simulationTree && (this._simulationTree.getActiveRun() == null || this._simulationTree.getActiveRun() != this.getActiveRun())) {
            this.updateComputeButton();
            this.updateManagerMaps();
            this.fireActiveRunChanged();
        }
    }

    protected void fireActiveRunChanged() {
        int size = this._activeRunListeners.size();
        SimulationRun run = this.getActiveRun();
        ChangeEvent e = new ChangeEvent(this);
        for (int i = 0; i < size; ++i) {
            ActiveRunChangeListener listener = this._activeRunListeners.get(i);
            listener.activeRunChanged(e);
        }
    }

    public void addActiveRunChangedListener(ActiveRunChangeListener listener) {
        if (listener == null) {
            return;
        }
        this._activeRunListeners.add(listener);
    }

    public void removeActiveRunChangedListener(ActiveRunChangeListener listener) {
        this._activeRunListeners.remove(listener);
    }

    @Override
    protected Identifier getUserSpecifiedName(String typename, Vector idlist, String defaultname) {
        if (typename.equals(this.getSimulationType())) {
            if (defaultname != null) {
                Identifier newid = new Identifier();
                newid.setName(defaultname);
                newid.setDescription("");
                return newid;
            }
            return this.getUserSpecifiedSimulationName(typename, idlist, defaultname);
        }
        return null;
    }

    protected Identifier getUserSpecifiedSimulationName(String typename, Vector idlist, String defaultname) {
        if (this.m_simulationDialog == null) {
            this.m_simulationDialog = this.getSimulationDialog((Frame)((Object)ClientApp.frame()), true);
            this.m_simulationDialog.setTitle(this.getSimulationEditorTitle());
        }
        this.m_simulationDialog.setEditMode(0);
        this.m_simulationDialog.fillForm(ClientApp.app().getAppType(), this.getSimulationRunClass());
        if (this.getDefaultTimeStep() != null) {
            this.m_simulationDialog.setDefaultTimeStep(this.getDefaultTimeStep());
        }
        this.m_simulationDialog.setLocationRelativeTo((Component)ClientApp.frame().getMapPanel());
        this.m_simulationDialog.setVisible(true);
        if (this.m_simulationDialog.isCanceled()) {
            return null;
        }
        Identifier newid = new Identifier();
        newid.setName(this.m_simulationDialog.getName());
        newid.setDescription("");
        return newid;
    }

    protected String getSimulationEditorTitle() {
        return this._simType + " Editor";
    }

    public RMIProgressDialog getComputeDialog() {
        if (this._progress == null) {
            return null;
        }
        return this._progress.getDialog();
    }

    public void stopSimRunComputes() {
        this._stopRuns = true;
        RMIProgressDisplay display = this._progress.getDisplay();
        if (display instanceof RMIProgressDialog) {
            RMIProgressDialog dlg = (RMIProgressDialog)display;
            dlg.closeButtonAction();
        }
    }

    public void computeRuns(SimulationRun[] runs, int lastModel, boolean recomputeAll) {
        this.computeRuns(runs, lastModel, recomputeAll, null);
    }

    public void computeRuns(final SimulationRun[] runs, final int lastModel, final boolean recomputeAll, final RunObserver runObs) {
        if (runs == null) {
            System.out.println("computeRuns: no runs to compute");
            return;
        }
        final Object lock = new Object();
        this._stopRuns = false;
        final RunObserver ro = new RunObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runComplete(Object obj) {
                Object object = lock;
                synchronized (object) {
                    AbstractSimulationMode.this._progress.getDialog().setVisible(false);
                    lock.notify();
                }
            }
        };
        Thread runThread = new Thread("Simulation Compute"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                Object object = lock;
                synchronized (object) {
                    for (int i = 0; i < runs.length && !AbstractSimulationMode.this._stopRuns; ++i) {
                        if (!AbstractSimulationMode.this.computeRun(runs[i], lastModel, recomputeAll)) continue;
                        if (AbstractSimulationMode.this._progress != null) {
                            AbstractSimulationMode.this._progress.addRunObserver(ro);
                        }
                        try {
                            lock.wait();
                            continue;
                        }
                        catch (InterruptedException ie) {
                            System.out.println("InterruptedException " + ie);
                        }
                    }
                    if (runObs != null) {
                        runObs.runComplete(null);
                    }
                }
                AbstractSimulationMode.this._simulation.writeFile(AbstractSimulationMode.this._simulation.getIdentifier());
            }
        };
        runThread.setPriority(4);
        runThread.start();
    }

    @Override
    public boolean computeRun(SimulationRun run, int lastModel, boolean recomputeAll) {
        return this.computeRun(run, lastModel, recomputeAll, false);
    }

    protected Font getComputeWindowFont() {
        return null;
    }

    public boolean computeRun(final SimulationRun run, final int lastModel, boolean recomputeAll, boolean waitForCompute) {
        RMIProgressFile rpf;
        Thread t;
        this._lastComputeStatus = null;
        if (this._simulation == null) {
            return false;
        }
        System.out.println("computeRun: run=" + run + " lastModel=" + lastModel + " recomputeAll=" + recomputeAll);
        Dimension size = null;
        Point location = null;
        if (this._progress != null && this._progress.getDialog() != null && this._progress.getDialog().isVisible()) {
            if (!this._reuseComputeDialog) {
                this._progress.getDialog().toFront();
                return false;
            }
            size = this._progress.getDialog().getSize();
            location = this._progress.getDialog().getLocation();
            this._progress.getDialog().setVisible(false);
        }
        RemoteWrapper _pdWrap = new RemoteWrapper();
        try {
            this._progress = this.createComputeProgress(run, (Frame)((Object)(waitForCompute ? null : this._frame)));
            if (!waitForCompute) {
                this._progress.getDialog().setTextAreaFont(this.getComputeWindowFont());
            }
            if (run.getAltList().size() > 1) {
                this._progress.setNumberTasks(run.getAltList().size());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this._progress.getDialog() != null) {
            this._executeButton.setEnabled(false);
        }
        this._progress.makeCall();
        if (this._progress.getDialog() != null) {
            if (size != null) {
                this._progress.getDialog().setSize(size);
            }
            if (location != null) {
                this._progress.getDialog().setLocation(location);
            }
        }
        ClientApp.Workspace().saveWorkspace(false);
        if (ClientApp.app().networked) {
            this._progress.exportServer();
            _pdWrap.setExported(true);
        }
        _pdWrap.setRemote((Remote)((Object)this._progress));
        try {
            this._progress.addRemoteWrapper(_pdWrap);
        }
        catch (RemoteException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error adding remote wrapper for: " + _pdWrap);
        }
        this._progress.setRunObserver(this);
        for (int i = 0; i < this._runObservers.size(); ++i) {
            this._progress.addRunObserver(this._runObservers.get(i));
        }
        this._simulation.setUserInterface(_pdWrap);
        this._simulation.setComputeAll(recomputeAll);
        String title = ClientApp.Workspace().getName() + "-" + run.toString();
        this._progress.setCompute(new Runnable(){

            @Override
            public void run() {
                AbstractSimulationMode.this._simulation.setComputeDisplay(AbstractSimulationMode.this._progress.getDisplay());
                AbstractSimulationMode.this._simulation.computeRun(run, lastModel);
                AbstractSimulationMode.this._simulation.writeFile(AbstractSimulationMode.this._simulation.getIdentifier());
            }
        }, title);
        this._progress.makeCall();
        if (this._progress._pd instanceof RMIProgressFile && (t = (rpf = (RMIProgressFile)this._progress._pd).getThread()) != null) {
            try {
                t.join(600000L);
            }
            catch (Exception e) {
                System.out.println("computeRun: Exception on Join()" + e);
            }
        }
        return true;
    }

    protected RmiProgressImpl createComputeProgress(SimulationRun run, Frame parent) {
        try {
            return new RmiProgressImpl(parent);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void displayAlternativeEditor() {
        this.displayAlternativeEditor(null);
    }

    public abstract void displayAlternativeEditor(String var1);

    protected abstract String getSimulationRunClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dssVue_Action() {
        this._frame.setWaitCursor();
        try {
            boolean networked = ClientApp.app().networked;
            ListSelection selectFrame = new ListSelection("", 2, true, false, networked);
            String basePath = ClientApp.app().getAppStartDir();
            SimulationPeriod sim = this.getSimulation();
            if (sim != null) {
                String simPath = sim.getSimulationPath();
                String path = simPath + "/simulation.dss";
                selectFrame.setDSSFilename(path);
            } else {
                selectFrame.setDirectory(basePath);
            }
            selectFrame.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    protected Vector getRunNames(boolean onlySelectedNames, String model) {
        Vector<RunInfo> runNames = new Vector<RunInfo>();
        ClientWorkspace wksp = ClientApp.Workspace();
        if (wksp == null) {
            return runNames;
        }
        SimulationPeriod sim = this.getSimulation();
        if (sim == null) {
            return runNames;
        }
        Vector runs = onlySelectedNames ? this._simulationTree.getSelectedRuns() : this._simulationTree.getSimulationRuns();
        for (int i = 0; i < runs.size(); ++i) {
            SimulationRun run = (SimulationRun)((Object)runs.get(i));
            if (run == null) continue;
            String simRunName = run.toString();
            Vector<String> v = run.getModelNames(model);
            for (int j = 0; j < v.size(); ++j) {
                RunInfo ri = new RunInfo(v.get(j), simRunName);
                if (runNames.contains(v.get(j))) continue;
                runNames.add(ri);
            }
        }
        return runNames;
    }

    public boolean hasWriteLock() {
        return this.getActiveRun() != null;
    }

    public void getMenuLogFiles(JMenu menu, String directory, String filter, String actionCommand, boolean useTreeCheckboxes, boolean convertNames) {
        SimulationPeriod simulation = this.getSimulation();
        menu.removeAll();
        if (simulation == null) {
            System.out.println("getMenuLogsFiles: no " + this._simType + " selected");
            return;
        }
        RmiFileManager fileMgr = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (fileMgr == null) {
            System.out.println("getMenuLogsFiles: ERROR no RmiFileManager! ");
            return;
        }
        try {
            Vector<String> v = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(filter, ",");
            while (tokenizer.hasMoreTokens()) {
                v.add(tokenizer.nextToken());
            }
            String dir = simulation.getSimulationPath() + "/" + directory;
            Vector idList = fileMgr.getRemoteFileIDList(ClientApp.app().getUser(), dir, v);
            if (idList == null) {
                return;
            }
            if (useTreeCheckboxes) {
                // empty if block
            }
            for (int i = 0; i < idList.size(); ++i) {
                Identifier id = (Identifier)idList.get(i);
                if (id == null) continue;
                String name = id.getName();
                name = RMAIO.getFileNameNoExtension((String)name);
                JMenuItem menuItem = new JMenuItem(name);
                menuItem.setName(id.getPath());
                menuItem.setActionCommand(actionCommand);
                menuItem.addActionListener(this);
                menu.add(menuItem);
            }
        }
        catch (RemoteException re) {
            System.out.println("getMenuLogFiles: RMI Error getting directory listing from FileManager " + re);
            return;
        }
    }

    protected void updateComputeButton() {
        SimulationPeriod simulation = this.getSimulation();
        if (simulation == null) {
            this._executeButton.setText("Compute");
            this._executeButton.setEnabled(false);
            this._editMenuItem.setEnabled(false);
            this._activeRunMenuItem.setEnabled(false);
            this._saveMenuItem.setEnabled(false);
            this._infoMenuItem.setEnabled(false);
            this._runManagerMenuItem.setEnabled(false);
            this._closeMenuItem.setEnabled(false);
        } else {
            SimulationRun run = this._simulationTree.getActiveRun();
            boolean enabled = run != null;
            this._editMenuItem.setEnabled(true);
            this._activeRunMenuItem.setEnabled(true);
            this._saveMenuItem.setEnabled(true);
            this._infoMenuItem.setEnabled(true);
            this._closeMenuItem.setEnabled(true);
            this._runManagerMenuItem.setEnabled(true);
            this._executeButton.setEnabled(enabled);
            if (!enabled) {
                this._executeButton.setText("Compute");
            } else {
                this._executeButton.setText("Compute " + run.getUserName());
            }
        }
    }

    public void selectActiveRun() {
        SelectActiveRunDialog dialog = new SelectActiveRunDialog((Frame)((Object)this._frame), true);
        dialog.setSimulation(this.getSimulation());
        dialog.setActiveRun(this.getActiveRun());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        SimulationRun run = dialog.getSelectedSimulationRun();
        if (run == null) {
            return;
        }
        this._simulationTree.setActiveRun(run);
    }

    public void setActiveRun(SimulationRun run) {
        if (run == null) {
            return;
        }
        this._simulationTree.setActiveRun(run);
    }

    public SimulationRun[] getSimulationRuns() {
        Vector v = this._simulationTree.getSimulationRuns();
        SimulationRun[] runs = new SimulationRun[v.size()];
        v.copyInto((Object[])runs);
        return runs;
    }

    public SimulationRun[] getSelectedSimulationRuns() {
        Vector v = this._simulationTree.getSelectedRuns();
        SimulationRun[] runs = new SimulationRun[v.size()];
        if (v.size() == 0) {
            return runs;
        }
        v.copyInto((Object[])runs);
        return runs;
    }

    public SimulationRun getSimulationRun(String simRun) {
        Vector v = this._simulationTree.getSimulationRuns();
        SimulationRun[] runs = new SimulationRun[v.size()];
        v.copyInto((Object[])runs);
        for (int x = 0; x < v.size(); ++x) {
            String comp = v.get(x).toString();
            if (!comp.equals(simRun)) continue;
            return (SimulationRun)((Object)v.get(x));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewLog(String logName) {
        if (logName == null) {
            return;
        }
        this._frame.setWaitCursor();
        try {
            Identifier id = new Identifier(logName);
            RmiTextFileReaderJDialog logDisplayDialog = new RmiTextFileReaderJDialog((Frame)((Object)this._frame), false, id.getName());
            logDisplayDialog.setHTTPText(id.getPath().endsWith(".html"));
            logDisplayDialog.fillForm(id);
            logDisplayDialog.setLocationRelativeTo((Component)((Object)this._frame));
            logDisplayDialog.setVisible(true);
        }
        finally {
            this._frame.setDefaultCursor();
        }
    }

    public void runComplete(Object obj) {
        ((FluentLogger.Api)LOGGER.atInfo()).log("%s", obj);
        this._lastComputeStatus = obj;
        if (this.getActiveRun() != null) {
            this._executeButton.setEnabled(true);
        }
        this.updateMenus();
    }

    public Object getComputeStatus() {
        return this._lastComputeStatus;
    }

    @Override
    public void modeOpening() {
        boolean enabled = this.getSimulation() != null;
        this._alternativeMenu.setEnabled(enabled);
        this._reportsMenu.setEnabled(enabled);
        super.modeOpening();
    }

    @Override
    public String getTimeWindowString() {
        String tsstr = null;
        if (this.getSimulation() == null) {
            return null;
        }
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        if (this.getTimeWindow(startTime, endTime)) {
            tsstr = startTime.dateAndTime(104) + ";" + endTime.dateAndTime(104);
        }
        return tsstr;
    }

    @Override
    public boolean getTimeWindow(HecTime start, HecTime end) {
        SimulationPeriod simulation = this.getSimulation();
        if (simulation == null) {
            return false;
        }
        simulation.getTimeWindow(start, end);
        this.setStartTime(start);
        this.setEndTime(end);
        return super.getTimeWindow(start, end);
    }

    protected int getAlternativeKeyLength() {
        return 11;
    }

    protected int getMaxAlternativeKeyLength() {
        return 10;
    }

    protected String getDefaultTimeStep() {
        return null;
    }

    public void nodeSelected(CheckBoxNode node) {
    }

    public String getDSSFilename() {
        SimulationPeriod sp = this.getSimulation();
        if (sp == null) {
            return null;
        }
        return sp.getOutputDSSFilePath();
    }

    public String[] getFParts() {
        Vector runs = this._simulationTree.getSimulationRuns();
        int size = runs.size();
        String[] fparts = new String[size];
        for (int i = 0; i < size; ++i) {
            SimulationRun run = (SimulationRun)((Object)runs.elementAt(i));
            fparts[i] = run.getName();
        }
        return fparts;
    }

    public String[] getSelectedFParts() {
        Vector runs = this._simulationTree.getSelectedRuns();
        int size = runs.size();
        String[] fparts = new String[size];
        for (int i = 0; i < size; ++i) {
            SimulationRun run = (SimulationRun)((Object)runs.elementAt(i));
            fparts[i] = run.getName();
        }
        return fparts;
    }

    public abstract SimulationRun getActiveRun();

    protected abstract void setActiveSimRun(SimulationRun var1);

    @Override
    public void managerInfo() {
        SimulationPeriod sim = this.getSimulation();
        if (sim != null) {
            int opt = JOptionPane.showOptionDialog((Component)((Object)this._frame), "Do you want to see Manager information for the Watershed or the " + this._simType + "?", "Select Manager Information Location", 0, 3, null, new Object[]{"Watershed", this._simType}, "Watershed");
            if (opt == 0) {
                super.managerInfo();
            } else if (opt == 1) {
                ManagerInfoDialog dialog = new ManagerInfoDialog((Frame)((Object)ClientApp.frame()), sim);
                dialog.setVisible(true);
            }
            return;
        }
        super.managerInfo();
    }

    public void menuSimulationInfoAction() {
        SimulationPeriod sim = this.getSimulation();
        if (sim == null) {
            return;
        }
        if (this._infoDialog == null) {
            this._infoDialog = new WorkspaceInfoDialog((Frame)((Object)this._frame), false);
        }
        this._infoDialog.fillForm(sim.getManagerRmiWorkspace());
        this._infoDialog.setTitle(this._simType + " Information");
        this._infoDialog.setVisible(true);
    }

    protected CreateSimulationDialog getSimulationDialog(Frame parent, boolean modal) {
        CreateSimulationDialog dialog = new CreateSimulationDialog(parent, modal);
        dialog.setTablePanelBorderTitle(this.getTablePanelBorder());
        return dialog;
    }

    protected String getTablePanelBorder() {
        return "Alternatives";
    }

    protected SimModeOptionsPanel getOptionsPanel() {
        return this._optionsPanel;
    }

    protected void setOptionsPanel(SimModeOptionsPanel op) {
        this._optionsPanel = op;
    }

    @Override
    public DefaultJPanel[] getModuleOptionsPanels() {
        DefaultJPanel[] panels = new DefaultJPanel[1];
        if (this._optionsPanel == null) {
            this._optionsPanel = new SimModeOptionsPanel();
        }
        panels[0] = this._optionsPanel;
        this._simTreeOptionsInitd = false;
        return panels;
    }

    public boolean getSaveSimTreeState() {
        if (!this._simTreeOptionsInitd) {
            this.initSimOptions();
        }
        return this._saveSimTreeSettings;
    }

    @Override
    public boolean getForceRecompute() {
        if (!this._simTreeOptionsInitd) {
            this.initSimOptions();
        }
        return this._forceRecompute;
    }

    protected void initSimOptions() {
        HECProperties props = ClientApp.app().getProperties();
        if (props == null) {
            return;
        }
        String s = props.getProp(DONT_SAVE_TREE_STATE_PROP);
        this._saveSimTreeSettings = s == null ? true : "false".equalsIgnoreCase(s);
        s = props.getProp(ALWAYS_RECOMPUTE_PROP);
        this._forceRecompute = "true".equalsIgnoreCase(s);
        s = props.getProp(REUSE_COMPUTE_DIALOG_PROP);
        this._reuseComputeDialog = "true".equalsIgnoreCase(s);
    }

    @Override
    public SimulationRunTreeNode newSimulationRunTreeNode(SimulationRun run, JTree tree) {
        if (run instanceof SimulationTrialRun) {
            return new SimTrialRunTreeNode((SimulationTrialRun)run, tree);
        }
        return new SimulationRunTreeNode(run, tree);
    }

    public SimulationTree getSimulationTree() {
        return this._simulationTree;
    }

    public void addMenuToReports(JMenu menu) {
        if (menu == null) {
            return;
        }
        this._reportsMenu.add(menu);
    }

    public void addMenuToSimulation(JMenuItem menu) {
        if (menu == null) {
            return;
        }
        this._simMenu.add(menu);
    }

    public void addRunObserver(RunObserver ro) {
        if (ro == null) {
            return;
        }
        this._runObservers.add(ro);
    }

    public void removeRunObserver(RunObserver ro) {
        this._runObservers.remove(ro);
        if (this._progress != null) {
            this._progress.removeRunObserver(ro);
        }
    }

    public void displayRunManagerDialog() {
        if (this._runManagerWindow != null && this._runManagerWindow.isVisible()) {
            this._runManagerWindow.setExtendedState(0);
            this._runManagerWindow.toFront();
        } else {
            this._runManagerWindow = new SimRunManagerWindow(this.getSimulationType());
            this._runManagerWindow.fillForm(this);
            this._runManagerWindow.setVisible(true);
        }
    }

    protected SimulationRunDetailsPanel getSimRunDetailsPanel() {
        return this._simRunDetailsPanel;
    }
}

