/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.appInterface.FileOpener;
import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.stream.ShapeFileSelector;
import hec.map.importer.ShapeSource;
import java.awt.Frame;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAFilenameFilter;

public class AiShapeFileSelector
implements ShapeFileSelector {
    private int[] _allowableShapeTypes;

    public AiShapeFileSelector(int ... allowableShapeTypes) {
        this._allowableShapeTypes = allowableShapeTypes;
    }

    public ShapeSource selectShapeSource() {
        boolean isValidMap;
        ArrayList<RMAFilenameFilter> filters = new ArrayList<RMAFilenameFilter>();
        filters.add(new RMAFilenameFilter("*.shp", "Arc Shapefile (*.shp)"));
        RmiFileDialog chooser = new RmiFileDialog((Frame)((Object)ClientApp.frame()), true, ClientApp.Workspace().getWorkspacePath(), filters);
        AiShapeMap shapeMap = null;
        do {
            isValidMap = true;
            chooser.setTitle("Choose Shapefile");
            chooser.setVisible(true);
            if (chooser.isCanceled()) {
                return null;
            }
            if (chooser.getIdentifier() == null) continue;
            Identifier id1 = null;
            Identifier id0 = chooser.getIdentifier();
            try {
                id1 = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), id0);
            }
            catch (RemoteException re) {
                System.out.println("Caught remote exception opening map " + id0.getPath() + " exception " + re);
                return null;
            }
            if (id1 == null) {
                return null;
            }
            MapObject map = MapObjectFactory.newMapObject((FileOpener)ClientApp.Workspace(), (Identifier)id1);
            if (!(map instanceof AiShapeMap)) {
                return null;
            }
            isValidMap = true;
            shapeMap = (AiShapeMap)map;
            try {
                shapeMap.load();
            }
            catch (IOException e) {
                System.out.println("selectShapeSource:error loading shape map " + id1.getPath() + " Error:" + e);
                e.printStackTrace();
            }
            if (this.isValidShapeType(shapeMap.getType())) continue;
            ClientApp.app().postWarning("Invalid ShapeFile type selected", "Invalid File");
            isValidMap = false;
        } while (!isValidMap);
        return shapeMap;
    }

    private boolean isValidShapeType(int type) {
        if (this._allowableShapeTypes == null) {
            return true;
        }
        for (int i = 0; i < this._allowableShapeTypes.length; ++i) {
            if (type != this._allowableShapeTypes[i]) continue;
            return true;
        }
        return false;
    }
}

