/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.appInterface.AppDaddy;
import hec.appInterface.Application;
import hec.appInterface.FileOpener;
import hec.appInterface.Workspace;
import hec.client.LoginIfc;
import hec.client.LookAndFeel;
import hec.client.NewWorkspaceSummaryDialog;
import hec.client.PlugInLoader;
import hec.client.RunObserver;
import hec.client.WatershedSummaryFormat;
import hec.clientapp.client.ClientCache;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientScheduler;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.DialogSaveAsWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.HecPlotDialogCreator;
import hec.clientapp.client.HecPopupPlotCreator;
import hec.clientapp.client.JDialogLoadWorkspace;
import hec.clientapp.client.LoginInfo;
import hec.clientapp.client.NewWorkspaceDlg;
import hec.clientapp.client.RMIProgressFile;
import hec.clientapp.client.RmiCall;
import hec.clientapp.client.RmiProgressImpl;
import hec.clientapp.client.ShortcutsAccessory;
import hec.clientapp.client.SplashWindow;
import hec.clientapp.client.WkspVersionChecker;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.HecDataTypeFactory;
import hec.clientapp.properties.HECGlobalProperties;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.RmiAppImpl;
import hec.clientapp.util.DssUtilities;
import hec.clientapp.util.VersionUtilities;
import hec.data.Units;
import hec.dataTable.TimeSeriesDataModel;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.PlotDialogCreator;
import hec.gfx2d.PlotDialogFactory;
import hec.gfx2d.PopupPlotCreator;
import hec.heclib.util.Heclib;
import hec.io.Console;
import hec.io.FileLock;
import hec.io.HecOutputStream;
import hec.io.Identifier;
import hec.lang.ApplicationProperties;
import hec.lang.ClientAppCheck;
import hec.lang.UserId;
import hec.lang.WorkspaceExistsException;
import hec.map.appInterface.MapApplicationFrame;
import hec.model.RunProxy;
import hec.model.WatershedLocation;
import hec.properties.HECProperties;
import hec.properties.LoginProperties;
import hec.properties.SystemProperties;
import hec.script.ScriptEngine;
import hec.security.ApplicationPermission;
import hec.security.ApplicationPermissionCollection;
import hec.security.UserProfile;
import hec.tcu.TcuAcceptTermsDialog;
import hec.tcu.TcuInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import mil.army.usace.hec.rmi.client.HecPlotDefaults;
import mil.army.usace.hec.rmi.csinterface.Naming;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import mil.army.usace.hec.rmi.server.LimitedPortServerSocketFactory;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileManagerImpl;
import mil.army.usace.hec.rmi.server.SinglePortRangedServerSocketFactory;
import rma.services.ServiceLookup;
import rma.services.tz.TimeZoneDisplayService;
import rma.services.units.UnitsDisplayService;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.util.MessageBox;
import rma.util.RMAConst;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ParameterLoggingMarker;
import rma.util.logging.marking.UnitsLoggingMarker;

public abstract class ClientApp
implements Serializable,
Application,
FileOpener {
    private static final MarkingClassLogger UNITS_LOGGER = MarkingClassLogger.forMarkingClass(UnitsLoggingMarker.class);
    private static final MarkingClassLogger PARAMETER_LOGGER = MarkingClassLogger.forMarkingClass(ParameterLoggingMarker.class);
    private static final Logger logger = Logger.getLogger(ClientApp.class.getName());
    protected static final String STANDALONE_ARG = "standalone";
    protected static final String NETWORKED_ARG = "networked";
    protected static final int SCRIPT_FAILURE_NO_SCRIPT_SPECIFIED = 100;
    protected RemoteWrapper _wkspFileManager;
    protected RemoteWrapper _fileManager;
    protected RemoteWrapper _fileManagerCachedRemote = null;
    protected Vector<RunProxy> _runs;
    protected static ClientApp _app = null;
    protected static ClientWorkspace _Workspace = null;
    protected static HecClientFrame _clientFrame = null;
    protected RmiApp _appServer = null;
    protected String _appServerUrl = null;
    protected RmiLogin _loginServer = null;
    protected String _loginUrl = null;
    protected ClientCache _clientCache = null;
    public boolean networked;
    private boolean _standalone;
    protected UserProfile _profile;
    protected String _userName;
    protected String _password;
    protected static RemoteWrapper _msgHandler = null;
    RemoteWrapper _pdWrap = null;
    RmiCall _openwksp = null;
    protected int _rmiPort = 8089;
    protected String _protectedDir = null;
    protected String _workingDir = null;
    protected String _forecastDir = null;
    protected String _appStartDir = null;
    protected String _dssListDefaultDir = null;
    protected static String _localUserDir = null;
    protected int _selectedDir = 0;
    protected boolean _showConfirmOnExit = false;
    protected boolean _openLastWatershed = false;
    protected boolean _disableBeep = true;
    protected static String _workspaceDir = null;
    protected String _loginServerDisplayName;
    protected boolean _startedFromMain = true;
    protected Preferences _preferences;
    protected static boolean _isOsWindows = false;
    protected static final int WKSP_SAVE_NUM = 5;
    String appTitle = "";
    ClientScheduler _scheduler = null;
    boolean _openExistingWksp = false;
    private transient int _unitSystem = Integer.MIN_VALUE;
    private transient TimeZone _timeZone = TimeZone.getDefault();
    private HECGlobalProperties m_globalProperties = null;
    private HECProperties _appProperties = null;
    protected String _baseWkspDirectory = "/base";
    private List<Class<? extends DefaultJPanel>> _optionsPanelClasses = new ArrayList<Class<? extends DefaultJPanel>>();
    private static HecOutputStream _output = null;
    protected static Console _console = null;
    private static boolean _canExitJVM = true;
    protected static boolean _noFrame = false;
    private static String _tcuVersion;
    private static boolean _firstTimeForVersion;

    public ClientApp(LoginInfo loginInfo) {
        ClientAppCheck.setHaveClientApp((boolean)true);
        AppDaddy.setApp((Application)this);
        this.printVersionInformation();
        this.setDSSVersion();
        SystemProperties.load();
        RMAIO.getVersionStamp();
        if (loginInfo == null || loginInfo.profile == null) {
            System.out.println("Failed to get loginInfo or UserProfile. exiting...");
            System.exit(1);
        }
        this._clientCache = new ClientCache(this, loginInfo.serverURL);
        this._profile = loginInfo.profile;
        ClientCache.setCacheMode(loginInfo.cacheMode);
        this.networked = loginInfo.networked;
        this._standalone = loginInfo.standalone;
        if (this.networked) {
            System.setProperty("NO_PREDEFINED_WKSP", Boolean.FALSE.toString());
        } else {
            this._standalone = true;
        }
        this._loginServerDisplayName = loginInfo.serverName;
        this._userName = this._profile.getUserId();
        this._password = this._profile.getPassword();
        this._wkspFileManager = new RemoteWrapper();
        this._fileManager = new RemoteWrapper();
        PreferencesManager.setUserDirectory((String)this._profile.getUserName());
        this.setFileManager();
        this.setAppServer(loginInfo.serverURL);
        this.loadDirectories("hec.properties.HECProperties");
        G2dPanel.registerPopupPlotCreator((PopupPlotCreator)new HecPopupPlotCreator());
        PlotDialogFactory.registerPlotDialogCreator((PlotDialogCreator)new HecPlotDialogCreator());
        if (Boolean.getBoolean("NO_PREDEFINED_WKSP")) {
            this.setBaseWkspDirectory(null);
        }
    }

    public static void setApp(ClientApp app) {
        _app = app;
        if (!_app.isCommandLine()) {
            ClientApp._app._scheduler = new ClientScheduler();
        }
        _app.init();
    }

    public Map getWatershedDefaultsMap() {
        return null;
    }

    public Action[] getModeToolBarActions(String modeName) {
        return null;
    }

    public static String getLocalUserDir() {
        return _localUserDir;
    }

    public static boolean isOsWindows() {
        return _isOsWindows;
    }

    protected void init() {
        int level;
        String mlevel;
        block7: {
            this._preferences = Preferences.userNodeForPackage(this.getClass());
            String osName = System.getProperty("os.name");
            _isOsWindows = osName.toLowerCase().startsWith("windows");
            boolean cachingEnabled = this._clientCache.getCachingEnabled();
            String defaultDir = this._clientCache.getDefaultCacheDirectory();
            String cacheDir = this._preferences.get("client.cacheDirectory", defaultDir);
            this._clientCache.setCachingEnabled(cachingEnabled, cacheDir);
            HecFileImpl.setCachingEnabled((boolean)cachingEnabled);
            String cwmsHome = this._preferences.get("CWMS_HOME", null);
            if (cwmsHome != null) {
                System.setProperty("CWMS_HOME", cwmsHome);
            }
            try {
                int delay;
                this.m_globalProperties = new HECGlobalProperties();
                this.getGlobalProperties();
                String s = this.m_globalProperties.getProp("client.showConfirmOnExit");
                if (s != null) {
                    this._showConfirmOnExit = "true".equalsIgnoreCase(s);
                }
                if ((s = this.m_globalProperties.getProp("client.loadLastWatershed")) != null) {
                    this._openLastWatershed = "true".equalsIgnoreCase(s);
                }
                this._disableBeep = (s = this.m_globalProperties.getProp("client.disableBell")) == null ? true : "true".equalsIgnoreCase(s);
                s = this.m_globalProperties.getProp("client.tooltip.delay");
                if (s != null && RMAConst.isValidValue((int)(delay = RMAIO.parseInt((String)s)))) {
                    ToolTipManager.sharedInstance().setDismissDelay(delay);
                }
            }
            catch (Exception e) {
                if (!this.networked) break block7;
                String message = "Error attempting to access server.\nError: " + e.toString();
                JOptionPane.showMessageDialog(null, message, "Error accessing server", 0);
            }
        }
        if (!this.networked && (mlevel = this.m_globalProperties.getProp("HecLib.mlevel")) != null && !RMAConst.isUndefinedValue((int)(level = RMAIO.parseInt((String)mlevel)))) {
            Heclib.zset((String)"MLEVEL", (String)"", (int)level);
        }
    }

    public static ClientApp app() {
        return _app;
    }

    public static void setWorkspace(ClientWorkspace wksp) {
        if (_Workspace != null && wksp == null && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "setWorkspace(null) called", new Throwable());
        }
        _Workspace = wksp;
        if (_clientFrame != null) {
            if (wksp != null) {
                _clientFrame.workspaceOpening();
            } else {
                _clientFrame.workspaceClosing();
            }
        }
        if (_Workspace != null) {
            RmiFileManager fm = null;
            try {
                fm = _Workspace.getData().getFileManager();
                ClientApp._app._wkspFileManager.setRemote((Remote)fm);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            PreferencesManager.setFileManager((RmiFileManager)fm);
            PreferencesManager.setWorkspaceName((String)_Workspace.getTitleName());
        } else {
            PreferencesManager.setWorkspaceName(null);
            PreferencesManager.setFileManager((RmiFileManager)((RmiFileManager)ClientApp._app._fileManager.getRemote()));
            ClientApp._app._wkspFileManager.setRemote(null);
        }
        PlotDefaultsManager.setDefaults((PlotDefaults)new HecPlotDefaults());
        try {
            DataTypeFactory.setFactory((DataTypeFactory)new HecDataTypeFactory());
        }
        catch (Exception e) {
            System.out.println("Workspace:failed to create DataTypeFactory " + e);
        }
    }

    public static ClientWorkspace Workspace() {
        return _Workspace;
    }

    public Workspace getWorkspace() {
        return _Workspace;
    }

    public static String getWorkspaceDir() {
        if (_Workspace != null) {
            return _Workspace.getWkspDir();
        }
        return _workspaceDir;
    }

    public static void setClientFrame(HecClientFrame frame) {
        _clientFrame = frame;
        PlugInLoader.loadPlugIns();
    }

    public int getClientUnitSystem() {
        if (this._unitSystem == Integer.MIN_VALUE) {
            this._unitSystem = 1;
        }
        return this._unitSystem;
    }

    public TimeZone getClientTimeZone() {
        if (this._timeZone == null) {
            return null;
        }
        return (TimeZone)this._timeZone.clone();
    }

    public void setClientUnitSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem((int)unitSystem)) {
            System.out.println("ERROR <ClientApp.setClientUnitSystem()> : I invalid unit system - " + unitSystem);
            System.out.println("ERROR <ClientApp.setClientUnitSystem()> : Valid Unit Systems (2) SI (1) English");
            return;
        }
        this._unitSystem = unitSystem;
        UnitsDisplayService uds = ServiceLookup.getUnitsDisplayService();
        uds.setDisplayUnitSystem(unitSystem);
        if (ClientApp.frame() != null) {
            ClientMode[] modes = ClientApp.frame().getModes();
            for (int i = 0; i < modes.length; ++i) {
                modes[i].setClientUnitSystem(unitSystem);
            }
        }
    }

    public void setClientTimeZone(TimeZone tz) {
        this._timeZone = tz;
        TimeZoneDisplayService tzs = ServiceLookup.getTimeZoneDisplayService();
        tzs.setTimeZone(this._timeZone);
        TimeSeriesDataModel.setGlobalViewTimeZone((TimeZone)tz);
        if (ClientApp.frame() == null) {
            return;
        }
        ClientMode[] modes = ClientApp.frame().getModes();
        for (int i = 0; i < modes.length; ++i) {
            modes[i].setClientTimeZone(tz);
        }
    }

    public static HecClientFrame frame() {
        return _clientFrame;
    }

    public MapApplicationFrame getFrame() {
        return _clientFrame;
    }

    public RmiApp getCaviServer() {
        return this._appServer;
    }

    public RemoteWrapper getFileManager() {
        RemoteWrapper fileMgr = this._fileManager;
        if (this.networked && ClientApp.Workspace() != null) {
            if (this._wkspFileManager.getRemote() == null) {
                try {
                    RmiFileManager fm = ClientApp.Workspace().getData().getFileManager();
                    this._wkspFileManager.setRemote((Remote)fm);
                }
                catch (RemoteException re) {
                    this.postError("Error getting filemanager. Exception is " + re, "Error");
                }
            }
            fileMgr = this._wkspFileManager;
        } else if (this.networked) {
            if (this._fileManager.getRemote() == null) {
                Object stringUrl = this._loginUrl.substring(0, this._loginUrl.lastIndexOf(47) + 1);
                stringUrl = (String)stringUrl + "FileManager";
                try {
                    RmiFileManager fmi = (RmiFileManager)Naming.lookup((String)stringUrl);
                    this._fileManager.setRemote((Remote)fmi);
                }
                catch (Exception e) {
                    this.postError("Failed to find the file manager on the net " + e, "Error");
                }
            }
            fileMgr = this._fileManager;
        } else if (ClientApp.getCacheMode() == ClientCache.CACHED_DBI_NETWORKED && this._fileManagerCachedRemote == null) {
            Object stringUrl = this._loginUrl.substring(0, this._loginUrl.lastIndexOf(47) + 1);
            stringUrl = (String)stringUrl + "FileManager";
            try {
                RmiFileManager fmi = (RmiFileManager)Naming.lookup((String)stringUrl);
                this._fileManagerCachedRemote = new RemoteWrapper();
                this._fileManagerCachedRemote.setRemote((Remote)fmi);
            }
            catch (Exception e) {
                this.postError("Failed to find the file manager on the net " + e, "Error");
            }
        }
        return fileMgr;
    }

    public RemoteWrapper getFileManagerCachedRemote() {
        return this._fileManagerCachedRemote;
    }

    public RmiApp setRmiApp(String rmiAppClass, String url) {
        RmiApp rmiApp = null;
        if (url != null) {
            try {
                rmiApp = (RmiApp)((Object)Naming.lookup((String)url));
            }
            catch (Exception e) {
                this.errMsgBox(new Msg("Error getting rmi app " + e, 1));
                e.printStackTrace(System.out);
            }
        } else {
            try {
                Class<?> cl = Class.forName(rmiAppClass + "Impl");
                Object obj = cl.newInstance();
                if (obj instanceof RmiAppImpl) {
                    RmiAppImpl rmiAppImpl = (RmiAppImpl)obj;
                    rmiAppImpl.setFileManager(this._fileManager);
                    this.setAppVersion(rmiAppImpl);
                    rmiApp = rmiAppImpl;
                }
            }
            catch (Exception e) {
                this.errMsgBox(new Msg("Error creating standalone rmi app: " + e.getMessage(), 1));
                e.printStackTrace(System.out);
            }
        }
        return rmiApp;
    }

    private void setAppVersion(RmiAppImpl rmiAppImpl) {
        String fullVersion;
        Properties props = RMAIO.getAppVersionProperties(this.getClass());
        if (props != null && (fullVersion = props.getProperty("fullVersion", null)) != null) {
            rmiAppImpl.setAppVersion(fullVersion);
        }
    }

    public RunProxy getRun(Identifier id) {
        String runName;
        if (this._runs == null) {
            this._runs = new Vector();
        }
        RunProxy run = null;
        String idName = id.getName();
        for (int ii = 0; ii < this._runs.size() && !(runName = (run = this._runs.elementAt(ii)).getName()).equals(idName); ++ii) {
        }
        if (run == null) {
            run = new RunProxy(id);
            this._runs.addElement(run);
        }
        return run;
    }

    public void setFileManager() {
        if (!this.networked) {
            try {
                RmiFileManagerImpl fmi = new RmiFileManagerImpl(this._rmiPort);
                this._fileManager = new RemoteWrapper((Remote)fmi);
                this._fileManager.setName("FileManager");
            }
            catch (Exception e) {
                this.errMsgBox(new Msg("Error setting File Manager. Exception: " + e.getMessage(), 1));
                e.printStackTrace(System.out);
            }
        }
    }

    public String getUser() {
        return this._userName;
    }

    public String getPassword() {
        return this._password;
    }

    public String getUserName() {
        if (this._profile == null) {
            return this.getUser();
        }
        return this._profile.getUserName();
    }

    public UserProfile getUserProfile() {
        return this._profile;
    }

    public void errMsg(Msg msg) {
        System.out.println(msg.toString());
    }

    public void postWarning(String msg, String title) {
        this.postMessage(msg, title, 2);
    }

    public void postError(String msg, String title) {
        this.postMessage(msg, title, 0);
    }

    public void postMessage(String msg, String title, int type) {
        if (ClientApp.frame() != null && ClientApp.frame().isVisible()) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg, title, type);
        }
        String prefix = "";
        switch (type) {
            case 0: {
                prefix = "Error:";
                break;
            }
            case 2: {
                prefix = "Warning:";
                break;
            }
            case 1: {
                prefix = "Info:";
                break;
            }
        }
        System.out.println(prefix + msg);
    }

    public void errMsgBox(Msg msg) {
        this.postMessage(msg.getBody(), "Error", 0);
    }

    public RemoteWrapper getMsgHandler() {
        return _msgHandler;
    }

    public void printMessage(String msg) {
        if (this._pdWrap != null && this._pdWrap.getRemote() != null) {
            try {
                ((RmiProgress)this._pdWrap.getRemote()).printMessage(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void printStatus(String msg) {
        if (this._pdWrap != null && this._pdWrap.getRemote() != null) {
            try {
                ((RmiProgress)this._pdWrap.getRemote()).printStatus(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setProgress(int prog) {
        if (this._pdWrap != null && this._pdWrap.getRemote() != null) {
            try {
                ((RmiProgress)this._pdWrap.getRemote()).setProgress(prog);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void openWorkspace(RemoteWrapper serverWrap, RemoteWrapper dataWrap, String type) {
        Vector vectorWorkspaceIds = null;
        String[] stringArrayBindingSites = null;
        RmiApp server = (RmiApp)((Object)serverWrap.getRemote());
        try {
            vectorWorkspaceIds = server.getWorkspaces(ClientApp.app().getUser(), this._appStartDir + this._baseWkspDirectory);
            stringArrayBindingSites = server.getBindingSites();
        }
        catch (RemoteException re) {
            this.errMsgBox(new Msg("Error getting data to populate open Workspace dialog  " + re, 1));
            re.printStackTrace(System.out);
        }
        JDialogLoadWorkspace jdialog = new JDialogLoadWorkspace((Frame)((Object)_clientFrame));
        jdialog.setTitle("Open " + type + " Watershed");
        ClientApp clientApp = this;
        jdialog.setLocal(clientApp._clientCache.getCacheMode() == 5);
        jdialog.setStandAlone(!this.networked);
        jdialog.setCurrentWorkspace(ClientApp.Workspace().getName());
        jdialog.setAvailableWorkspaces(vectorWorkspaceIds);
        jdialog.setAvailableBindingSites(stringArrayBindingSites);
        jdialog.setVisible(true);
        if (!jdialog.getCanceled()) {
            this._openExistingWksp = true;
            this._dssListDefaultDir = null;
            Identifier chosenWorkspaceId = jdialog.getChosenWorkspace();
            String chosenBindingSite = jdialog.getChosenBindingSite();
            RmiWorkspace data = (RmiWorkspace)dataWrap.getRemote();
            if (data != null) {
                try {
                    data.closeWorkspace(ClientApp.app().getUser());
                }
                catch (RemoteException re) {
                    this.errMsgBox(new Msg("Error saving Watershed from data interface  " + re, 1));
                    re.printStackTrace(System.out);
                }
            }
            try {
                if (jdialog.getLocal()) {
                    data = server.openWorkspace(ClientApp.app().getUser(), chosenWorkspaceId, null, null);
                    dataWrap.setRemote((Remote)data);
                } else {
                    data = server.openWorkspace(ClientApp.app().getUser(), chosenWorkspaceId, chosenBindingSite, null);
                    dataWrap.setRemote((Remote)data);
                }
            }
            catch (RemoteException re) {
                this.errMsgBox(new Msg("Error opening Watershed " + re, 1));
                re.printStackTrace(System.out);
            }
            ClientApp.Workspace().getManagerProxies();
            ClientApp.Workspace().getWorkspaceMaps();
        }
    }

    protected void closeWorkspace(RemoteWrapper data, String type) {
        if (data.getRemote() != null) {
            ClientApp.Workspace().setWorkspaceMaps();
            try {
                RmiWorkspace RmiWorkspace2 = (RmiWorkspace)data.getRemote();
                RmiWorkspace2.closeWorkspace(this._userName);
            }
            catch (Exception e) {
                this.errMsgBox(new Msg("Error Closing " + type + " Workspace " + e, 1));
                e.printStackTrace(System.out);
            }
            data.setRemote(null);
        }
    }

    protected void newWorkspace(RemoteWrapper serverWrap, RemoteWrapper dataWrap, String type, int unitsId, int gmtOffset) {
        String name = "Untitled";
        Identifier id = new Identifier();
        id.setName(name);
        this._openExistingWksp = true;
        this._dssListDefaultDir = null;
        RmiWorkspace data = (RmiWorkspace)dataWrap.getRemote();
        if (data != null) {
            try {
                data.closeWorkspace(this._userName);
            }
            catch (RemoteException re) {
                this.errMsgBox(new Msg("Close Workspace Error  " + re, 1));
            }
        }
        RmiApp server = (RmiApp)((Object)serverWrap.getRemote());
        if (ClientCache.getCacheMode() == 5 || !this.networked) {
            try {
                data = server.newWorkspace(this._userName, id, this._appStartDir + this._baseWkspDirectory, unitsId, gmtOffset);
            }
            catch (Exception re) {
                try {
                    String errorResponse = server.getError();
                    if (errorResponse == null || errorResponse.equals("")) {
                        errorResponse = "Error creating new Local Workspace";
                    }
                    new MessageBox(errorResponse, "New Workspace Error").setVisible(true);
                    server.setError("");
                }
                catch (RemoteException re2) {
                    System.out.println("Error getting error response from server  " + re2);
                }
                this.errMsgBox(new Msg("Error creating New Local Workspace  " + re, 1));
            }
            dataWrap.setRemote((Remote)data);
        } else {
            try {
                data = server.newWorkspace(this._userName, id, this._appStartDir + this._baseWkspDirectory, unitsId, gmtOffset);
            }
            catch (Exception re) {
                try {
                    String errorResponse = server.getError();
                    if (errorResponse == null || errorResponse.equals("")) {
                        errorResponse = "Error creating new Local Workspace";
                    }
                    new MessageBox(errorResponse, "New Workspace Error").setVisible(true);
                    server.setError("");
                }
                catch (RemoteException re2) {
                    System.out.println("Error getting error response from server  " + re2);
                }
                this.errMsgBox(new Msg("Error creating New Local Workspace  " + re, 1));
            }
            dataWrap.setRemote((Remote)data);
        }
    }

    protected boolean saveAsWorkspace(Frame parent, RemoteWrapper dataWrap, String type) {
        String name = null;
        String description = null;
        String fileName = null;
        Identifier id = null;
        RmiWorkspace data = (RmiWorkspace)dataWrap.getRemote();
        try {
            id = data.getIdentifier();
        }
        catch (RemoteException re) {
            this.errMsgBox(new Msg("Error getting Workspace Identifier for saveAsWorkspace  " + re, 1));
            return false;
        }
        if (parent == null) {
            parent = new Frame();
            parent.setLocation(300, 300);
        }
        DialogSaveAsWorkspace dialog = new DialogSaveAsWorkspace(parent, id, true);
        dialog.setTitle("Save " + type + " Workspace As...");
        dialog.setVisible(true);
        name = dialog.getName();
        description = dialog.getDescription();
        fileName = dialog.getFileName();
        id.setName(name);
        id.setDescription(description);
        id.setPath(fileName);
        try {
            data.setIdentifier(this._userName, id);
        }
        catch (RemoteException re) {
            this.errMsgBox(new Msg("Error setting Workspace Identifier for saveAsWorkspace  " + re, 1));
        }
        return this.saveWorkspace(dataWrap);
    }

    protected boolean saveWorkspace(RemoteWrapper dataWrap) {
        RmiWorkspace data = (RmiWorkspace)dataWrap.getRemote();
        try {
            data.saveWorkspace(this._userName);
            return true;
        }
        catch (RemoteException re) {
            this.errMsgBox(new Msg("Error with saving in Save As Workspace  " + re, 1));
            return false;
        }
    }

    public RmiApp getAppServer() {
        return this._appServer;
    }

    public String getAppServerUrl() {
        return this._appServerUrl;
    }

    public String getLoginServerUrl() {
        return this._loginUrl;
    }

    public String getFileManagerUrl() {
        return "";
    }

    public RmiLogin getLoginServer() {
        return this._loginServer;
    }

    public RmiProgress getProgressDialog() {
        if (this._pdWrap != null) {
            return (RmiProgress)this._pdWrap.getRemote();
        }
        return null;
    }

    public void setAppServer(String stringUrl) {
        RmiAppImpl impl;
        if (this.networked && stringUrl != null) {
            this._rmiPort = this.getRmiPort(stringUrl);
            try {
                this._appServer = (RmiApp)((Object)Naming.lookup((String)stringUrl));
                this._appServerUrl = stringUrl;
            }
            catch (Exception e) {
                System.out.println("setAppServer: Exception: " + e.getMessage());
                e.printStackTrace(System.out);
            }
            this._loginUrl = stringUrl.substring(0, stringUrl.lastIndexOf(47) + 1);
            this._loginUrl = this._loginUrl + "LoginServer";
            this.setDssServer();
        } else if (ClientApp.getCacheMode() == ClientCache.CACHED_DBI_NETWORKED && stringUrl != null) {
            this._rmiPort = this.getRmiPort(stringUrl);
            try {
                impl = this.startStandAloneServer(this._rmiPort);
                impl.setFileManager(this._fileManager);
                this._appServer = impl;
            }
            catch (Exception e) {
                System.out.println("setAppServer: Exception: " + e.getMessage());
                e.printStackTrace(System.out);
            }
            this._loginUrl = stringUrl.substring(0, stringUrl.lastIndexOf(47) + 1);
            this._loginUrl = this._loginUrl + "LoginServer";
            this.setDssServer();
        } else {
            try {
                impl = this.startStandAloneServer(this._rmiPort);
                impl.setFileManager(this._fileManager);
                this._appServer = impl;
            }
            catch (Exception e) {
                System.out.println("setAppServer: Exception: " + e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        if (this._appServer != null) {
            try {
                PreferencesManager.setBaseDirectory((String)this._appServer.getServerProperty(ApplicationProperties.getAppHomeVariable()));
            }
            catch (RemoteException re) {
                System.out.println("setAppServer:Failed to get server property " + re);
            }
        }
    }

    public RmiAppImpl startStandAloneServer(int port) throws RemoteException {
        RmiAppImpl impl = new RmiAppImpl(port);
        this.setAppVersion(impl);
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRmiPort(String url) {
        int rmiPort = this._rmiPort;
        try {
            if (url == null || url.equals("")) {
                int n = rmiPort = this._rmiPort;
                return n;
            }
            String tmp = url.substring(0, url.lastIndexOf(47));
            tmp = tmp.substring(tmp.lastIndexOf(58) + 1);
            int n = rmiPort = Integer.parseInt(tmp);
            return n;
        }
        finally {
            if (Boolean.getBoolean("rma.rmi.server.logCalls")) {
                System.out.println("getRmiPort: returning" + rmiPort);
            }
        }
    }

    public int getRmiPort() {
        return this._rmiPort;
    }

    protected void setDssServer() {
        if (HecDataManagerRemote.getDSSManagerUrl() == null) {
            Object dssUrl = this._loginUrl.substring(0, this._loginUrl.lastIndexOf(47) + 1);
            dssUrl = (String)dssUrl + "DssFileManager";
            HecDataManagerRemote.setDSSManagerUrl((String)dssUrl);
        }
    }

    public Vector getWatershedLocations(boolean convert) {
        Vector<WatershedLocation> v;
        block9: {
            WatershedLocation wl;
            boolean cacheDir;
            block8: {
                if (this.networked) {
                    try {
                        Vector v2 = this._appServer.getWatershedLocations(convert);
                        return v2;
                    }
                    catch (RemoteException re) {
                        System.out.println("getWatershedLocations: RMI Error getting list of available watershed locations from server " + re);
                        return new Vector(0);
                    }
                }
                v = new Vector<WatershedLocation>();
                int cnt = RMAIO.parseInt((String)this.getGlobalProperties().getProp("watershed.directory.count", "0"));
                cacheDir = false;
                for (int i = 0; i < cnt; ++i) {
                    String dirPropName;
                    String dirProp = this.m_globalProperties.getProp("watershed.directory" + i);
                    if (dirProp == null || dirProp.length() < 1 || (dirPropName = this.m_globalProperties.getProp("watershed.directory" + i + ".name")) == null || dirPropName.length() < 1) continue;
                    wl = new WatershedLocation(dirPropName, dirProp);
                    v.add(wl);
                    if (!dirPropName.equalsIgnoreCase("Cached")) continue;
                    cacheDir = true;
                }
                if (ClientCache.getCacheMode() == ClientCache.CACHED_NO_NETWORK) break block8;
                ClientApp clientApp = this;
                if (clientApp._clientCache.getCacheMode() != ClientCache.CACHED_DBI_NETWORKED) break block9;
            }
            if (this._clientCache.getCacheDirectory().length() > 0 && !cacheDir) {
                wl = new WatershedLocation("Cached", this._clientCache.getCacheWatershedDir());
                v.add(wl);
            }
        }
        return v;
    }

    public void setWatershedLocations(Vector watershedLocations) {
        if (watershedLocations == null) {
            this.m_globalProperties.setProp("watershed.directory.count", "0");
            return;
        }
        int cnt = watershedLocations.size();
        for (int i = 0; i < cnt; ++i) {
            WatershedLocation nt = (WatershedLocation)watershedLocations.get(i);
            this.m_globalProperties.setProp("watershed.directory" + i, nt.getDescription());
            this.m_globalProperties.setProp("watershed.directory" + i + ".name", nt.getName());
        }
        this.m_globalProperties.setProp("watershed.directory.count", "" + cnt);
    }

    public boolean newWorkspace() {
        String dir;
        int gmtOffset;
        int unitSystemId;
        String description;
        String name;
        NewWorkspaceSummaryDialog summary;
        NewWorkspaceDlg dialog = new NewWorkspaceDlg((Frame)((Object)_clientFrame), true);
        dialog.setTitle(this.appTitle + "Create New Watershed");
        Vector v = this.getWatershedLocations(true);
        dialog.setWatershedLocations(v);
        DefaultJPanel watershedDataAccessoryPanel = _clientFrame.getWatershedDataAccessoryPanel();
        dialog.addAccessoryPanel(watershedDataAccessoryPanel);
        int results = 1;
        WatershedSummaryFormat message = new WatershedSummaryFormat();
        do {
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return false;
            }
            name = dialog.getName();
            description = dialog.getDescription();
            String timeZone = dialog.getTimeZoneText();
            unitSystemId = dialog.getUnitSystemId();
            gmtOffset = dialog.getGmtOffset();
            dir = dialog.getWatershedLocation();
            String[] args = new String[5];
            args[0] = name;
            args[1] = description;
            if (args[1] != null) {
                args[1] = description.replaceAll("\n", "<br>");
            }
            args[2] = unitSystemId == 1 ? "English" : "SI";
            args[3] = timeZone;
            args[4] = dir + this._baseWkspDirectory + "/" + RMAIO.userNameToFileName((String)name);
            summary = new NewWorkspaceSummaryDialog((Frame)((Object)_clientFrame), null, true);
            summary.setSize(475, 350);
            summary.setLocationRelativeTo((Component)_clientFrame.getMapPanel());
            summary.setText(message.format((Object)args));
            summary.setVisible(true);
        } while ((results = summary.getResults()) == 2);
        if (results == 1) {
            return false;
        }
        if (_Workspace != null && !_Workspace.checkAndSaveChanges()) {
            return false;
        }
        boolean success = this.newWorkspace(dir, name, description, unitSystemId, gmtOffset);
        if (success && watershedDataAccessoryPanel != null) {
            watershedDataAccessoryPanel.savePanel();
        }
        return success;
    }

    public boolean newWorkspace(String dir, String name, String description, int unitSystemId, int gmtOffset) {
        Identifier id = new Identifier();
        name = RMAIO.userNameToFileName((String)name);
        id.setName(name);
        id.setDescription(description);
        RmiApp server = this._appServer;
        RmiWorkspace rmiwksp = null;
        _workspaceDir = dir;
        try {
            rmiwksp = server.newWorkspace(this._userName, id, dir + this._baseWkspDirectory, unitSystemId, gmtOffset);
        }
        catch (WorkspaceExistsException wee) {
            this.errMsgBox(new Msg(wee.toString()));
            return false;
        }
        catch (Exception re) {
            String errorResponse = null;
            try {
                errorResponse = server.getError();
                if (errorResponse == null || errorResponse.equals("")) {
                    errorResponse = "Error creating new Workspace";
                }
                server.setError("");
                this.postError(errorResponse, "New Workspace Error");
            }
            catch (RemoteException re2) {
                System.out.println("Error getting error response from server  " + re2);
            }
            this.postError("Error creating New Watershed " + re, "New Watershed Error");
        }
        if (rmiwksp == null) {
            return false;
        }
        this.setAppStartDir(dir);
        try {
            rmiwksp.saveWorkspace(this._userName);
        }
        catch (RemoteException re) {
            this.errMsgBox(new Msg("Error with saving in Save As Workspace  " + re, 1));
            return false;
        }
        if (_Workspace != null) {
            _Workspace.close();
        }
        this._clientCache.resetCache();
        ClientWorkspace clwksp = new ClientWorkspace(this, rmiwksp);
        ClientApp.setWorkspace(clwksp);
        try {
            id = rmiwksp.getIdentifier();
            if (id != null) {
                this.setLastWorkspace(id.getName(), id.getPath());
            }
        }
        catch (RemoteException re) {
            System.out.println("newWorkspace(): failed to get id from rmiwksp " + re);
        }
        this._openExistingWksp = false;
        return true;
    }

    public void closeOpenDialogs() {
        RmaJDialog dlg;
        int i;
        Vector openPlots = G2dDialog.getVisibleDialogs();
        Vector openFrames = RmaJFrame.getOpenWindows();
        Vector openDialogs = RmaJDialog.getOpenWindows();
        for (i = 0; openFrames != null && i < openFrames.size(); ++i) {
            RmaJFrame frame = (RmaJFrame)openFrames.get(i);
            if (!frame.isSystemClosable()) continue;
            frame.setVisible(false);
            frame.dispose();
        }
        for (i = 0; openDialogs != null && i < openDialogs.size(); ++i) {
            dlg = (RmaJDialog)openDialogs.get(i);
            if (!dlg.isSystemClosable()) continue;
            dlg.setVisible(false);
            dlg.dispose();
        }
        for (i = 0; openPlots != null && i < openPlots.size(); ++i) {
            dlg = (G2dDialog)openPlots.elementAt(i);
            dlg.setVisible(false);
            dlg.dispose();
        }
    }

    public boolean openWorkspace(Identifier chosenWorkspaceId) {
        return this.openWorkspace(chosenWorkspaceId, false);
    }

    public boolean openWorkspace(Identifier chosenWorkspaceId, boolean waitForOpenToFinish) {
        if (chosenWorkspaceId == null) {
            return false;
        }
        if (!this.okToOpenWorkspace(chosenWorkspaceId)) {
            return false;
        }
        if (_Workspace != null && !_Workspace.checkAndSaveChanges()) {
            return false;
        }
        RmiApp server = this._appServer;
        _workspaceDir = RMAIO.getDirectoryFromPath((String)chosenWorkspaceId.getPath()).replace("\\", "/");
        RmiProgressImpl pd = null;
        this._pdWrap = new RemoteWrapper();
        try {
            pd = new RmiProgressImpl((Frame)((Object)(waitForOpenToFinish ? null : ClientApp.frame())));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.networked) {
            pd.exportServer();
            this._pdWrap.setExported(true);
        }
        this._pdWrap.setRemote((Remote)((Object)pd));
        try {
            pd.addRemoteWrapper(this._pdWrap);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, e, () -> "Error adding remote wrapper: " + this._pdWrap);
        }
        String[] stringArrayBindingSites = null;
        Vector wksplocs = this.getWatershedLocations(true);
        try {
            stringArrayBindingSites = server.getBindingSites();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String path = chosenWorkspaceId.getPath();
        this.updateAppStartDir(wksplocs, path);
        this._openExistingWksp = true;
        this._dssListDefaultDir = null;
        this.closeOpenDialogs();
        System.out.println("ClientApp Thread=" + Thread.currentThread().toString());
        pd.openWorkspace(chosenWorkspaceId, !this.networked ? null : stringArrayBindingSites[0], !this.networked, server, this._pdWrap);
        pd.makeCall();
        System.out.println("openWorkspace:workspace=" + ClientApp.Workspace());
        System.out.println("openWorkspace:ps._pd is a " + pd._pd.getClass().getName());
        if (pd._pd instanceof RMIProgressFile) {
            System.out.println("openWorkspace:getting Progress thread...");
            RMIProgressFile rpf = (RMIProgressFile)pd._pd;
            pd.addRunObserver(new RunObserver(){

                public void runComplete(Object obj) {
                    System.out.println("runComplete:workspace " + ClientApp.Workspace() + " opened.");
                }
            });
            Thread t = rpf.getThread();
            if (t != null) {
                try {
                    System.out.println("openWorkspace:waiting on Progress thread...");
                    t.join(600000L);
                }
                catch (Exception e) {
                    System.out.println("openWatershed: exception on Join()" + e);
                }
                System.out.println("openWorkspace:waiting on Progress thread - done");
            }
        }
        this.setLastWorkspace(chosenWorkspaceId.getName(), chosenWorkspaceId.getPath());
        return true;
    }

    private boolean okToOpenWorkspace(Identifier chosenWorkspaceId) {
        WkspVersionChecker checker = new WkspVersionChecker(chosenWorkspaceId);
        return checker.shouldOpenWorkspace();
    }

    protected void updateAppStartDir(Vector wksplocs, String path) {
        if (wksplocs != null) {
            String dir = RMAIO.getDirectoryFromPath((String)path);
            if ((dir = RMAIO.getDirectoryFromPath((String)dir)).endsWith("base")) {
                dir = RMAIO.getDirectoryFromPath((String)dir);
            }
            dir = dir.concat("/");
            for (int i = 0; i < wksplocs.size(); ++i) {
                WatershedLocation wl = (WatershedLocation)wksplocs.get(i);
                String wlPath = wl.getDirectory() + "/";
                if (!RMAIO.pathsEqual((String)dir, (String)wlPath)) continue;
                this.setAppStartDir(wl.getDirectory());
                break;
            }
        } else {
            int idx;
            String base = this.getBaseWkspDirectory();
            if (base != null && (idx = path.indexOf(base)) != -1) {
                this.setAppStartDir(path.substring(0, idx));
            }
        }
    }

    private boolean openStandaloneWorkspace() {
        return this.openStandaloneWorkspace(null);
    }

    private boolean openStandaloneWorkspace(String predefinedWorkspaceName) {
        File f = this.getDefaultWatershedFolder();
        JFileChooser chooser = new JFileChooser(f);
        ShortcutsAccessory shortcuts = new ShortcutsAccessory(chooser, "demo");
        chooser.setAccessory(shortcuts);
        shortcuts.setFileShortcutAllowed(false);
        Dimension d = new Dimension(600, 400);
        chooser.setMinimumSize(d);
        chooser.setPreferredSize(d);
        chooser.setFileFilter((FileFilter)new RMAFilenameFilter("wksp", "Watershed Files"));
        int state = chooser.showOpenDialog((Component)((Object)ClientApp.frame()));
        if (state == 1 || state == -1) {
            return false;
        }
        File wkspFile = chooser.getSelectedFile();
        String watershedDir = this.getWatershedDir(wkspFile);
        return this.openStandaloneWorkspace(wkspFile, watershedDir, false);
    }

    public File getDefaultWatershedFolder() {
        ClientWorkspace workspace = ClientApp.Workspace();
        String defaultPath = null;
        if (workspace != null) {
            defaultPath = workspace.getWorkspacePath();
            defaultPath = RMAIO.getDirectoryFromPath((String)defaultPath);
        } else {
            defaultPath = this.getLastWorkspacePath(0);
            if (defaultPath != null) {
                defaultPath = RMAIO.getDirectoryFromPath((String)defaultPath);
                defaultPath = RMAIO.getDirectoryFromPath((String)defaultPath);
            } else {
                Vector watershedLocations = ClientApp.app().getWatershedLocations(false);
                if (watershedLocations != null && !watershedLocations.isEmpty()) {
                    WatershedLocation wl = (WatershedLocation)watershedLocations.get(0);
                    defaultPath = wl.getDirectory();
                } else {
                    defaultPath = System.getProperty("user.home");
                }
            }
        }
        return new File(defaultPath);
    }

    public boolean openStandaloneWorkspace(File wkspFile, String watershedDir, boolean waitForOpenToFinish) {
        if (wkspFile == null) {
            return false;
        }
        String path = wkspFile.getAbsolutePath().replace('\\', "/".charAt(0));
        Identifier chosenWorkspaceId = new Identifier(path);
        if (!this.okToOpenWorkspace(chosenWorkspaceId)) {
            return false;
        }
        if (_Workspace != null && !_Workspace.checkAndSaveChanges()) {
            return false;
        }
        this._openExistingWksp = true;
        this._dssListDefaultDir = null;
        if (!this.setWorkspaceIDInfo(chosenWorkspaceId)) {
            System.out.println("openStandaloneWorkspace: failed to setWorkspace ID Info");
            return false;
        }
        this.closeOpenDialogs();
        this.setAppStartDir(watershedDir);
        Object rmiwksp = null;
        RmiProgressImpl pd = null;
        this._pdWrap = new RemoteWrapper();
        try {
            pd = new RmiProgressImpl((Frame)((Object)(waitForOpenToFinish ? null : ClientApp.frame())));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.networked) {
            pd.exportServer();
            this._pdWrap.setExported(true);
        }
        this._pdWrap.setRemote((Remote)((Object)pd));
        try {
            pd.addRemoteWrapper(this._pdWrap);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, e, () -> "Error adding remote wrapper: " + this._pdWrap);
        }
        pd.openWorkspace(chosenWorkspaceId, null, true, this._appServer, this._pdWrap);
        this.setLastWorkspace(chosenWorkspaceId.getName(), chosenWorkspaceId.getPath());
        pd.makeCall();
        return true;
    }

    protected String getWatershedDir(File wkspFile) {
        File parent = wkspFile.getParentFile().getParentFile();
        if (parent.getPath().endsWith("base")) {
            parent = parent.getParentFile();
        }
        String watershedDir = parent.getAbsolutePath().replace('\\', "/".charAt(0));
        return watershedDir;
    }

    public boolean openWorkspace() {
        return this.openWorkspace("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openWorkspace(String preDefinedWorkspaceName) {
        JDialogLoadWorkspace jdialog = null;
        RmiApp server = this._appServer;
        if (Boolean.getBoolean("NO_PREDEFINED_WKSP")) {
            return this.openStandaloneWorkspace(preDefinedWorkspaceName);
        }
        try {
            ClientApp.frame().setWaitCursor();
            String[] stringArrayBindingSites = null;
            try {
                _clientFrame.getMapPanel().printStatus("Building list of workspaces...");
                _clientFrame.setCursor(Cursor.getPredefinedCursor(3));
                _clientFrame.setCursor(Cursor.getDefaultCursor());
                stringArrayBindingSites = server.getBindingSites();
            }
            catch (RemoteException re) {
                this.errMsgBox(new Msg("Error getting data to populate open Workspace dialog\nCheck Servers.\n" + re, 1));
                _clientFrame.setCursor(Cursor.getDefaultCursor());
                re.printStackTrace(System.out);
            }
            _clientFrame.getMapPanel().printStatus("");
            jdialog = new JDialogLoadWorkspace((Frame)((Object)_clientFrame));
            jdialog.setTitle(this.appTitle + "Open Watershed");
            if (ClientCache.getCacheMode() == 5) {
                jdialog.setLocal(true);
            } else if (ClientCache.getCacheMode() == ClientCache.CACHED_NO_NETWORK || ClientCache.getCacheMode() == ClientCache.CACHED_DBI_NETWORKED) {
                System.out.println(this._clientCache.getCacheDirectory());
                jdialog.setLocal(true);
            }
            jdialog.setStandAlone(!this.networked);
            String currentname = "";
            if (_Workspace != null) {
                currentname = _Workspace.getTitleName();
            }
            jdialog.setCurrentWorkspace(currentname);
            jdialog.setAvailableBindingSites(stringArrayBindingSites);
            jdialog.setAppServer(server);
        }
        finally {
            ClientApp.frame().setDefaultCursor();
        }
        if (preDefinedWorkspaceName.length() > 0) {
            Identifier workspaceId = jdialog.setChosenWorkspace(preDefinedWorkspaceName);
            if (workspaceId == null) {
                return false;
            }
        } else {
            jdialog.setVisible(true);
        }
        if (jdialog.getCanceled()) {
            return false;
        }
        if (_Workspace != null && !_Workspace.checkAndSaveChanges()) {
            return false;
        }
        this._openExistingWksp = true;
        this._dssListDefaultDir = null;
        Identifier chosenWorkspaceId = jdialog.getChosenWorkspace();
        if (!this.okToOpenWorkspace(chosenWorkspaceId)) {
            return false;
        }
        String chosenBindingSite = jdialog.getChosenBindingSite();
        String watershedDir = jdialog.getWatershedLocation();
        this.setAppStartDir(watershedDir);
        this.closeOpenDialogs();
        RmiProgressImpl pd = null;
        this._pdWrap = new RemoteWrapper();
        try {
            pd = new RmiProgressImpl((Frame)((Object)ClientApp.frame()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.networked) {
            pd.exportServer();
            this._pdWrap.setExported(true);
        }
        this._pdWrap.setRemote((Remote)((Object)pd));
        try {
            pd.addRemoteWrapper(this._pdWrap);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, e, () -> "Error adding remote wrapper: " + this._pdWrap);
        }
        pd.openWorkspace(chosenWorkspaceId, chosenBindingSite, jdialog.getLocal(), server, this._pdWrap);
        this.setLastWorkspace(chosenWorkspaceId.getName(), chosenWorkspaceId.getPath());
        pd.makeCall();
        return true;
    }

    public boolean saveWorkspace() {
        if (_Workspace == null) {
            return false;
        }
        return _Workspace.saveWorkspace();
    }

    public boolean saveWorkspaceOnExit() {
        if (_Workspace == null) {
            return false;
        }
        return _Workspace.saveWorkspaceOnExit();
    }

    public boolean hasWorkspace() {
        if (_Workspace == null) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), "You must open an existing workspace or create a new workspace before performing this action.", "", 1);
            return false;
        }
        return true;
    }

    public void loadDirectories(String propClass) {
    }

    public void saveDirectories(String appStartDir, String protectedDir, String workingDir, String forecastDir, int selectedDir, String propClass) {
        Class<?> c;
        this._appStartDir = appStartDir;
        this._protectedDir = protectedDir;
        this._workingDir = workingDir;
        this._forecastDir = forecastDir;
        this._selectedDir = selectedDir;
        try {
            c = Class.forName(propClass);
        }
        catch (ClassNotFoundException nfe) {
            System.out.println("Class " + propClass + " not found");
            return;
        }
        try {
            HECProperties p = (HECProperties)c.newInstance();
            p.setProp("ProtectedDirectory", this._protectedDir);
            p = (HECProperties)c.newInstance();
            p.setProp("WorkingDirectory", this._workingDir);
            p = (HECProperties)c.newInstance();
            p.setProp("ForecastDirectory", this._forecastDir);
            p = (HECProperties)c.newInstance();
            p.setProp("SelectedDirectory", String.valueOf(this._selectedDir));
        }
        catch (Exception ie) {
            System.out.println("Failed to save properties for class " + propClass);
        }
    }

    @Deprecated
    public String getProtectedDir() {
        return this.getAppStartDir();
    }

    @Deprecated
    public String getWorkingDir() {
        return this.getAppStartDir();
    }

    @Deprecated
    public String getForecastDir() {
        return this.getAppStartDir();
    }

    public String getAppStartDir() {
        if (this._appStartDir == null) {
            if (this.networked || this._appServer != null) {
                try {
                    this._appStartDir = this._appServer.getServerProperty(ApplicationProperties.getAppHomeVariable());
                    return this._appStartDir;
                }
                catch (RemoteException re) {
                    System.out.println("getAppStartDir: RMI Error getting Application Home directory from server " + re);
                    this._appStartDir = System.getProperty("user.dir").replace('\\', '/');
                    return this._appStartDir;
                }
            }
            this._appStartDir = System.getProperty("user.dir").replace('\\', '/');
            return this._appStartDir;
        }
        return this._appStartDir.replace('\\', '/');
    }

    public int getSelectedDir() {
        return this._selectedDir;
    }

    public String getDssListDefaultDir() {
        if (this._dssListDefaultDir != null) {
            return this._dssListDefaultDir;
        }
        if (_Workspace != null) {
            return _Workspace.getWorkspacePath();
        }
        return this.getAppStartDir();
    }

    public void setDssListDefaultDir(String dssListDefaultDir) {
        this._dssListDefaultDir = dssListDefaultDir;
    }

    public void setForecastDir(String forecastDir) {
        this._forecastDir = forecastDir;
    }

    public void setAppStartDir(String setToDir) {
        this._appStartDir = setToDir == null || setToDir.equals("") ? new String(System.getProperty("user.dir")) : setToDir.replace('\\', '/');
        if (this._appStartDir.charAt(this._appStartDir.length() - 1) == '/') {
            this._appStartDir = this._appStartDir.substring(0, this._appStartDir.length() - 1);
        }
        System.out.println("setAppStartDir:set to " + this._appStartDir);
    }

    public void setWorkspaceSaveNumber(int menuCnt) {
        if (RMAConst.isUndefinedValue((int)menuCnt) || menuCnt < 0) {
            menuCnt = 5;
        }
        HECProperties properties = this.getPropertiesObject();
        properties.setProp("watershedSaveNumber", String.valueOf(menuCnt));
        properties.saveProperties();
        if (ClientApp.frame() != null) {
            ClientApp.frame().setSavedMenus(this.getLastWorkspaceNames());
        }
    }

    public int getWorkspaceSaveNumber() {
        HECProperties properties = this.getPropertiesObject();
        int wkspSaveNum = 5;
        if (properties != null) {
            wkspSaveNum = RMAIO.parseInt((String)properties.getProp("watershedSaveNumber"), (int)wkspSaveNum);
        }
        return wkspSaveNum;
    }

    public String[] getLastWorkspaceNames() {
        return this.getPropArray("lastWorkspaceName", this.getWorkspaceSaveNumber());
    }

    public String[] getLastWorkspacePaths() {
        return this.getPropArray("lastWorkspacePath", this.getWorkspaceSaveNumber());
    }

    public String getLastWorkspaceName(int num) {
        HECProperties properties = this.getPropertiesObject();
        if (properties == null) {
            return null;
        }
        return properties.getProp("lastWorkspaceName" + num);
    }

    public String getLastWorkspacePath(int num) {
        HECProperties properties = this.getPropertiesObject();
        if (properties == null) {
            return null;
        }
        return properties.getProp("lastWorkspacePath" + num);
    }

    public void setLastWorkspace(String lastWorkspaceName, String lastWorkspacePath) {
        int wkspSaveNum = this.getWorkspaceSaveNumber();
        Vector<String> lastWkspName = this.getPropList("lastWorkspaceName", wkspSaveNum);
        Vector<String> lastWkspPath = this.getPropList("lastWorkspacePath", wkspSaveNum);
        Vector<String> newWkspName = new Vector<String>(wkspSaveNum);
        Vector<String> newWkspPath = new Vector<String>(wkspSaveNum);
        if (this.checkLastWorkspace(lastWkspName, lastWkspPath, lastWorkspaceName, lastWorkspacePath)) {
            this.setPropList("lastWorkspaceName", lastWkspName);
            this.setPropList("lastWorkspacePath", lastWkspPath);
            if (ClientApp.frame() != null) {
                ClientApp.frame().setSavedMenus(lastWkspName);
            }
            return;
        }
        newWkspName.add(0, lastWorkspaceName);
        newWkspPath.add(0, lastWorkspacePath);
        newWkspName.addAll(lastWkspName);
        newWkspPath.addAll(lastWkspPath);
        if (newWkspPath.size() > wkspSaveNum) {
            newWkspName.setSize(wkspSaveNum);
            newWkspPath.setSize(wkspSaveNum);
        }
        this.setPropList("lastWorkspaceName", newWkspName);
        this.setPropList("lastWorkspacePath", newWkspPath);
        if (ClientApp.frame() != null) {
            ClientApp.frame().setSavedMenus(newWkspName);
        }
    }

    protected Vector<String> getPropList(String propName, int propNum) {
        String prop;
        Vector<String> propList = new Vector<String>(propNum);
        HECProperties props = this.getPropertiesObject();
        if (props == null) {
            return propList;
        }
        for (int i = 0; i < propNum && (prop = props.getProp(propName + i)) != null; ++i) {
            propList.add(prop);
        }
        return propList;
    }

    protected String[] getPropArray(String propName, int propNum) {
        String prop;
        String[] propArray = new String[propNum];
        HECProperties props = this.getPropertiesObject();
        if (props == null) {
            return null;
        }
        for (int i = 0; i < propArray.length && (prop = props.getProp(propName + i)) != null; ++i) {
            propArray[i] = prop;
        }
        return propArray;
    }

    protected static void setPropArray(String propClass, String propName, String[] propArray) {
        Class<?> c;
        try {
            c = Class.forName(propClass);
        }
        catch (ClassNotFoundException nfe) {
            System.out.println("Class " + propClass + " not found");
            return;
        }
        try {
            HECProperties p = (HECProperties)c.newInstance();
            if (p != null) {
                ClientApp.setPropArray(p, propName, propArray);
            }
        }
        catch (Exception ie) {
            System.out.println("Failed to save properties for class " + propClass);
        }
    }

    private static void setPropArray(HECProperties p, String propName, String[] propArray) {
        try {
            for (int i = 0; i < propArray.length && propArray[i] != null; ++i) {
                p.setProp(propName + i, propArray[i]);
            }
        }
        catch (Exception ie) {
            System.out.println("Failed to save properties for class " + p.getClass());
        }
    }

    protected void setPropList(String propName, Vector propList) {
        Object obj;
        if (propList == null || propName == null) {
            return;
        }
        HECProperties props = this.getPropertiesObject();
        if (props == null) {
            return;
        }
        int size = propList.size();
        for (int i = 0; i < size && (obj = propList.get(i)) != null; ++i) {
            props.setProp(propName + i, obj.toString());
        }
    }

    protected boolean checkLastWorkspace(String[] wkspNames, String[] wkspPaths, String lastName, String lastPath) {
        int i;
        if (wkspNames == null || wkspPaths == null || lastName == null || lastPath == null) {
            return false;
        }
        boolean foundMatch = false;
        for (i = 0; i < wkspNames.length; ++i) {
            if (wkspNames[i] == null) {
                return foundMatch;
            }
            if (!wkspNames[i].equals(lastName) || i >= wkspPaths.length) continue;
            if (wkspPaths[i] == null) {
                return foundMatch;
            }
            if (!wkspPaths[i].equals(lastPath)) continue;
            foundMatch = true;
            break;
        }
        if (foundMatch && i != 0) {
            String[] newWkspNames = new String[wkspNames.length];
            String[] newWkspPaths = new String[wkspPaths.length];
            newWkspNames[0] = wkspNames[i];
            newWkspPaths[0] = wkspPaths[i];
            System.arraycopy(wkspNames, 0, newWkspNames, 1, i);
            System.arraycopy(wkspPaths, 0, newWkspPaths, 1, i);
            if (i != wkspNames.length - 1) {
                System.arraycopy(wkspNames, i + 1, newWkspNames, i + 1, wkspNames.length - 1 - i);
                System.arraycopy(wkspPaths, i + 1, newWkspPaths, i + 1, wkspPaths.length - 1 - i);
            }
        }
        return foundMatch;
    }

    protected boolean checkLastWorkspace(Vector wkspNames, Vector wkspPaths, String lastName, String lastPath) {
        Object obj;
        int i;
        if (wkspNames == null || wkspPaths == null || lastName == null || lastPath == null) {
            return false;
        }
        boolean foundMatch = false;
        int namesSize = wkspNames.size();
        int pathsSize = wkspPaths.size();
        for (i = 0; i < namesSize; ++i) {
            obj = wkspNames.get(i);
            if (obj == null) {
                return foundMatch;
            }
            if (!obj.toString().equals(lastName) || i >= pathsSize) continue;
            obj = wkspPaths.get(i);
            if (obj == null) {
                return foundMatch;
            }
            if (!obj.toString().equals(lastPath)) continue;
            foundMatch = true;
            break;
        }
        if (foundMatch && i != 0) {
            obj = wkspNames.remove(i);
            wkspNames.add(0, obj);
            obj = wkspPaths.remove(i);
            wkspPaths.add(0, obj);
        }
        return foundMatch;
    }

    protected static String[] getServers(String selectedServerString, String[] newServers) {
        String[] oldServers = null;
        if (selectedServerString != null && !selectedServerString.equals("")) {
            boolean found = false;
            for (int i = 0; i < newServers.length; ++i) {
                if (newServers[i] == null || newServers[i].indexOf(selectedServerString) == -1) continue;
                found = true;
                break;
            }
            if (!found) {
                oldServers = new String[newServers.length + 1];
                System.arraycopy(newServers, 0, oldServers, 1, newServers.length);
                oldServers[0] = selectedServerString;
            } else {
                oldServers = newServers;
            }
        }
        return oldServers;
    }

    public String getLoginServerDisplayName() {
        return this._loginServerDisplayName;
    }

    public void setServerDisplayName(String name) {
        this._loginServerDisplayName = name;
    }

    public String getHelpFile() {
        return null;
    }

    public abstract DataListContainer getDataListContainer(RmiDataListContainer var1);

    public void setAppTitle(String lbl) {
        if (lbl == null) {
            return;
        }
        this.appTitle = lbl;
    }

    public void setUserProperty(String prop, String value) {
        if (prop == null || value == null) {
            return;
        }
        this.getGlobalProperties().setProp(prop, value);
    }

    public String getUserProperty(String prop) {
        return this.getGlobalProperties().getProp(prop);
    }

    public HECGlobalProperties getGlobalProperties() {
        if (!this.m_globalProperties.isLoaded()) {
            this.m_globalProperties.loadProperties();
        }
        return this.m_globalProperties;
    }

    public HECProperties getProperties() {
        return this.getPropertiesObject();
    }

    public String getPropertiesClassString() {
        return null;
    }

    public void putAppProp(String prop, String value) {
        HECProperties props = this.getPropertiesObject();
        if (props == null) {
            return;
        }
        props.setProp(prop, value);
    }

    public String getAppProp(String prop) {
        HECProperties props = this.getPropertiesObject();
        if (props == null) {
            return null;
        }
        return props.getProp(prop);
    }

    public DefaultJPanel[] getGlobalPanels() {
        return null;
    }

    public DefaultJPanel[] getOptionPanels() {
        ArrayList<DefaultJPanel> l = new ArrayList<DefaultJPanel>();
        for (int i = 0; i < this._optionsPanelClasses.size(); ++i) {
            Class<? extends DefaultJPanel> cls = this._optionsPanelClasses.get(i);
            try {
                DefaultJPanel panel = cls.newInstance();
                l.add(panel);
                continue;
            }
            catch (InstantiationException e) {
                System.out.println("getGlobalPanels: InstantiationException " + e);
                continue;
            }
            catch (IllegalAccessException e) {
                System.out.println("getGlobalPanels: IllegalAccessException " + e);
            }
        }
        if (l.size() == 0) {
            return null;
        }
        DefaultJPanel[] panels = new DefaultJPanel[l.size()];
        return l.toArray(panels);
    }

    public <T extends DefaultJPanel> void addOptionPanelClass(Class<T> panelCls) {
        if (panelCls == null) {
            return;
        }
        this._optionsPanelClasses.add(panelCls);
    }

    public boolean isCachingEnabled() {
        return this._clientCache.getCachingEnabled();
    }

    public boolean setCachingEnabled(boolean cachingEnabled, String cacheDir) {
        if (cachingEnabled && (cacheDir == null || cacheDir.length() < 1)) {
            return false;
        }
        this._preferences.putBoolean("client.cacheEnabled", cachingEnabled);
        this._preferences.put("client.cacheDirectory", cacheDir);
        HecFileImpl.setCachingEnabled((boolean)cachingEnabled);
        this._clientCache.setCachingEnabled(cachingEnabled, cacheDir);
        return true;
    }

    public void setShowConfirmOnExit(boolean b) {
        this._showConfirmOnExit = b;
        this.getGlobalProperties().setProp("client.showConfirmOnExit", String.valueOf(b));
    }

    public void setOpenLastWatershed(boolean b) {
        this._openLastWatershed = b;
        this.getGlobalProperties().setProp("client.loadLastWatershed", "" + b);
    }

    public boolean getShowConfirmOnExit() {
        return this._showConfirmOnExit;
    }

    public boolean getOpenLastWatershed() {
        return this._openLastWatershed;
    }

    public boolean getDisableBeep() {
        return this._disableBeep;
    }

    public void setDisableBeep(boolean disableBeep) {
        this._disableBeep = disableBeep;
        this.getGlobalProperties().setProp("client.disableBell", "" + disableBeep);
    }

    public ClientScheduler getScheduler() {
        return this._scheduler;
    }

    public void setBaseWkspDirectory(String newBase) {
        if (newBase == null) {
            newBase = "";
        }
        this._baseWkspDirectory = newBase;
    }

    public String getBaseWkspDirectory() {
        return this._baseWkspDirectory;
    }

    public static String getStandaloneString() {
        return "Local";
    }

    public String getAppPermissionString() {
        return "";
    }

    public static LoginInfo getLoginInfo(String dialogTitle, boolean networked, String runAppPermission) {
        return ClientApp.getLoginInfo(dialogTitle, networked, true, false, runAppPermission);
    }

    public static LoginInfo getLoginInfo(String dialogTitle, boolean networked, boolean standAloneAllowed, String runAppPermission) {
        return ClientApp.getLoginInfo(dialogTitle, networked, true, false, runAppPermission);
    }

    public static LoginInfo getLoginInfo(String dialogTitle, boolean networked, boolean standAloneAllowed, boolean cachingAllowed, String runAppPermission) {
        boolean doSystemExit = true;
        return ClientApp.getLoginInfo(dialogTitle, networked, standAloneAllowed, cachingAllowed, runAppPermission, doSystemExit);
    }

    public static LoginInfo getLoginInfo(String dialogTitle, boolean networked, boolean standAloneAllowed, boolean cachingAllowed, String runAppPermission, boolean doSystemExit) {
        URL obj = ClientApp.class.getResource("/hec/client.policy");
        if (obj != null) {
            String policyFile = ((Object)obj).toString();
            System.setProperty("java.security.policy", policyFile);
        }
        SinglePortRangedServerSocketFactory factory = new SinglePortRangedServerSocketFactory();
        RemoteWrapper.setServerSocketFactory((RMIServerSocketFactory)factory);
        RemoteWrapper.setClientSocketFactory((RMIClientSocketFactory)new LimitedPortServerSocketFactory());
        LookAndFeel.setLookAndFeel();
        _console = Console.getConsole();
        LoginProperties loginProps = new LoginProperties();
        int numberOfServers = new Integer(loginProps.getProp("numberOfServers", "0"));
        String[] server = new String[numberOfServers];
        for (int ii = 0; ii < numberOfServers; ++ii) {
            server[ii] = loginProps.getProp("server.RMIServer" + ii);
        }
        String user = loginProps.getProp("client.LastLoginUser");
        if (user == null) {
            user = System.getProperty("user.name");
        }
        String selectedServerString = loginProps.getProp("server.ChoosenRMIServer");
        UserId.buildUserId();
        Class<?> dialogCls = null;
        try {
            dialogCls = Class.forName("hec.login.gui.LoginJDialog");
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("LoginDialog class not found " + cfe);
            System.out.println("This application can not be run in networked mode ");
            JOptionPane.showMessageDialog(null, "This application can not be run in networked mode", "Error", 0);
            if (!doSystemExit) {
                return null;
            }
            System.exit(2);
        }
        LoginIfc dialog = null;
        try {
            dialog = (LoginIfc)dialogCls.newInstance();
        }
        catch (Exception e) {
            System.out.println("Failed to create a new LoginDialog " + e);
            System.out.println("This application can not be run in networked mode ");
            JOptionPane.showMessageDialog(null, "This application can not be run in networked mode", "Error", 0);
            if (!doSystemExit) {
                return null;
            }
            System.exit(3);
        }
        dialog.setUsername(user);
        dialog.setPassword("");
        dialog.setServers(server);
        dialog.setStandAloneAllowed(standAloneAllowed);
        dialog.setRunAppPermission(runAppPermission);
        if (selectedServerString != null && !selectedServerString.equals("")) {
            dialog.setSelectedServer(selectedServerString);
        }
        boolean standalone = !networked;
        dialog.setStandAlone(standalone);
        dialog.setTitle(dialogTitle);
        dialog.setLabel(dialogTitle);
        dialog.setVisible(true);
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.cacheMode = dialog.getCacheMode();
        standalone = dialog.getStandAlone();
        String chosenCacheMode = dialog.getCacheModeString();
        loginInfo.networked = !standalone;
        loginInfo.profile = dialog.getUserProfile();
        loginInfo.serverURL = dialog.getSelectedServerUrl();
        loginInfo.serverName = dialog.getSelectedServerName();
        selectedServerString = dialog.getSelectedServerString();
        String[] newServers = dialog.getServerStrings();
        String[] oldServers = ClientApp.getServers(selectedServerString, newServers);
        if (oldServers != null) {
            ClientApp.setPropArray((HECProperties)loginProps, "server.RMIServer", oldServers);
            loginProps.setProp("numberOfServers", String.valueOf(oldServers.length));
        } else if (newServers != null) {
            ClientApp.setPropArray((HECProperties)loginProps, "server.RMIServer", newServers);
            loginProps.setProp("numberOfServers", String.valueOf(newServers.length));
        }
        if (loginInfo.serverName != null) {
            loginProps.setProp("server.ChoosenRMIServer", loginInfo.serverName);
            if (loginInfo.cacheMode != 5) {
                loginProps.setProp("client.chosenCacheMode", chosenCacheMode);
            }
        }
        if (dialog.isCanceled()) {
            if (!doSystemExit) {
                return null;
            }
            System.exit(0);
        }
        if (loginInfo.profile == null) {
            if (!doSystemExit) {
                return null;
            }
            System.exit(1);
        }
        UserId.setUserId((String)loginInfo.profile.getUserId(), (long)loginInfo.profile.getServerSessionKey());
        loginProps.setProp("client.LastLoginUser", dialog.getUsername());
        return loginInfo;
    }

    public static LoginInfo getLoginInfo() {
        return ClientApp.getLoginInfo(null);
    }

    public static LoginInfo getLoginInfo(String splashText) {
        return ClientApp.getLoginInfo(splashText, null);
    }

    public static LoginInfo getLoginInfo(String appName, String splashImage) {
        return ClientApp.getLoginInfo(appName, splashImage, null);
    }

    public static LoginInfo getLoginInfo(String appName, String splashImage, Class clientAppClass) {
        return ClientApp.getLoginInfo(appName, splashImage, clientAppClass, true);
    }

    public static LoginInfo getLoginInfo(String appName, String splashImage, Class clientAppClass, boolean showUIScreens) {
        Object tcuInfo;
        LookAndFeel.setLookAndFeel();
        if (showUIScreens) {
            tcuInfo = TcuInfo.getTcuInfo((int)1);
            tcuInfo.setAppName(appName);
            ClientApp.displayTCUAcceptDialog(appName, clientAppClass, tcuInfo);
        }
        _console = Console.getConsole();
        if (showUIScreens) {
            tcuInfo = new SplashWindow(appName, null, 10000, splashImage, clientAppClass);
        }
        LoginInfo loginInfo = new LoginInfo();
        ApplicationPermissionCollection[] permissions = new ApplicationPermissionCollection[1];
        ApplicationPermissionCollection apc = new ApplicationPermissionCollection();
        apc.add((Permission)ApplicationPermission.ALL_PERMISSION);
        permissions[0] = apc;
        loginInfo.networked = false;
        loginInfo.cacheMode = 5;
        loginInfo.profile = new UserProfile(System.getProperty("user.name"), "");
        loginInfo.serverURL = "";
        loginInfo.serverName = "";
        HecSecurityManager hsm = HecSecurityManager.getSecurityManager();
        if (hsm == null) {
            hsm = new HecSecurityManager(permissions);
        } else {
            hsm.setPermissions(permissions);
        }
        LookAndFeel.setLookAndFeel();
        return loginInfo;
    }

    public boolean hasConsoleWindow() {
        if (_console != null) {
            return _console.hasConsoleWindow();
        }
        return false;
    }

    public void showConsole() {
        if (_console != null) {
            _console.showConsole();
        }
    }

    protected HECProperties getPropertiesObject() {
        if (this._appProperties == null) {
            Class<?> propClass;
            String propClassString = this.getPropertiesClassString();
            if (propClassString == null) {
                return null;
            }
            try {
                propClass = Class.forName(propClassString);
            }
            catch (ClassNotFoundException cfe) {
                System.out.println("getPropertiesObject: Failed to find class " + propClassString);
                return null;
            }
            try {
                this._appProperties = (HECProperties)propClass.newInstance();
            }
            catch (Exception e) {
                System.out.println("getPropertiesObject: Failed to create Properties object " + propClassString + " " + e);
            }
        }
        if (this._appProperties != null && !this._appProperties.isLoaded()) {
            this._appProperties.loadProperties();
        }
        return this._appProperties;
    }

    public String getSimulationDSSFilename() {
        return "simulation.dss";
    }

    public boolean isCommandLine() {
        return false;
    }

    public Identifier downLoadUnitsFile() {
        String unitsFile = null;
        try {
            unitsFile = this._appServer.getServerProperty("UNITS_FILE");
        }
        catch (RemoteException re) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)UNITS_LOGGER.atFine()).withCause((Throwable)re)).log("WARNING Communications error with Application server");
            return null;
        }
        if (unitsFile == null) {
            ((MarkingClassLogger.Api)UNITS_LOGGER.atFine()).log("WARNING App Server doesn't define it's UNITS_FILE");
            return null;
        }
        Identifier id = new Identifier(unitsFile);
        Identifier cachedId = this._clientCache.openCachedFile(id);
        if (cachedId == null) {
            ((MarkingClassLogger.Api)UNITS_LOGGER.atFine()).log("WARNING Failed to open Units file %s", (Object)unitsFile);
            return null;
        }
        if (cachedId == id) {
            ((MarkingClassLogger.Api)UNITS_LOGGER.atFine()).log("WARNING Failed to cache Units File");
            return null;
        }
        return cachedId;
    }

    public Identifier downLoadParameterFile() {
        String parameterFile = null;
        try {
            parameterFile = this._appServer.getServerProperty("PARAMETER_FILE");
        }
        catch (RemoteException re) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)PARAMETER_LOGGER.atFine()).withCause((Throwable)re)).log("WARNING Communications error with Application server");
            return null;
        }
        if (parameterFile == null) {
            ((MarkingClassLogger.Api)PARAMETER_LOGGER.atFine()).log("WARNING App Server doesn't define it's PARAMETER_FILE");
            return null;
        }
        Identifier id = new Identifier(parameterFile);
        Identifier cachedId = this._clientCache.openCachedFile(id);
        if (cachedId == null) {
            ((MarkingClassLogger.Api)PARAMETER_LOGGER.atFine()).log("WARNING Failed to open Parameter file %s", (Object)parameterFile);
            return null;
        }
        if (cachedId == id) {
            ((MarkingClassLogger.Api)PARAMETER_LOGGER.atFine()).log("WARNING Failed to cache Parameter File");
            return null;
        }
        return cachedId;
    }

    public ClientCache getCache() {
        return this._clientCache;
    }

    public static int getCacheMode() {
        return ClientCache.getCacheMode();
    }

    public boolean isModelFile(String file) {
        if (this._dssListDefaultDir == null && this._forecastDir == null) {
            return false;
        }
        if (this._forecastDir != null && file.indexOf(this._forecastDir) >= 0) {
            return true;
        }
        return this._dssListDefaultDir != null && file.indexOf(this._dssListDefaultDir) >= 0;
    }

    public Identifier openFile(Identifier pathId, boolean useCache) {
        if (useCache) {
            return this._clientCache.openCachedFile(pathId);
        }
        return this.openRemoteFileID(pathId);
    }

    public Identifier openRemoteFileID(Identifier pathId) {
        Identifier id = null;
        try {
            id = ((RmiFileManager)this.getFileManager().getRemote()).openFile(this.getUser(), pathId);
        }
        catch (RemoteException re) {
            System.out.println("openRemoteFileID:Error Getting Remote File Identifier  " + re);
        }
        return id;
    }

    public Identifier createFile(Identifier pathId) {
        Identifier id = null;
        try {
            id = ((RmiFileManager)this.getFileManager().getRemote()).newFile(this.getUser(), pathId);
        }
        catch (RemoteException re) {
            System.out.println("createFile: Error creating Remote File " + re);
        }
        return id;
    }

    protected boolean setWorkspaceIDInfo(Identifier workspaceId) {
        if (workspaceId == null) {
            return false;
        }
        Identifier openId = this.openRemoteFileID(workspaceId);
        if (openId == null) {
            return false;
        }
        BufferedReader reader = null;
        try {
            String line;
            if (openId.getFile() == null) {
                return false;
            }
            reader = openId.getFile().getBufferedReader();
            if (reader == null) {
                return false;
            }
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String type = RMAIO.getType((String)line, (String)"=");
                String param = RMAIO.getParam((String)line, (String)"=");
                if (type.compareTo("WorkspaceName") == 0) {
                    workspaceId.setName(param);
                    continue;
                }
                if (type.compareTo("WorkspaceDescription") != 0) continue;
                workspaceId.setDescription(param);
                if (workspaceId.getName().length() == 0) continue;
            }
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("setWorkspaceIDInfo:IOError reading " + workspaceId.getPath() + " Error:" + ioe);
            return false;
        }
        return true;
    }

    public boolean isStandalone() {
        return this._standalone;
    }

    public String getServerProperty(String key) {
        try {
            return this._appServer.getServerProperty(key);
        }
        catch (RemoteException re) {
            System.out.println("getServerPropery(" + key + ") RMI Error " + re);
            return null;
        }
    }

    public String parsePathName(String path) {
        try {
            return this._appServer.parsePathName(path);
        }
        catch (RemoteException re) {
            System.out.println("parsePathName: RMI Error " + re);
            return path;
        }
    }

    public String getApplicationProperty(String key) {
        return this.getServerProperty(key);
    }

    public boolean isNetworked() {
        return this.networked;
    }

    public List<Identifier> getFileList(String path, String filter) {
        try {
            return ((RmiFileManager)_app.getFileManager().getRemote()).getRemoteFileIDList(ClientApp.app().getUser(), path, filter);
        }
        catch (RemoteException re) {
            System.out.println("getDriveList: RMI error getting file list for " + path + " Error:" + re);
            return null;
        }
    }

    public List<Identifier> getDriveList() {
        try {
            return ((RmiFileManager)_app.getFileManager().getRemote()).getRemoteDriveIDList(ClientApp.app().getUser());
        }
        catch (RemoteException re) {
            System.out.println("getDriveList: RMI error getting drive list " + re);
            return null;
        }
    }

    public boolean unlockFile(Identifier id, FileLock flock) {
        try {
            return ((RmiFileManager)_app.getFileManager().getRemote()).unlockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("unlockFile: RMI Error unlocking " + id.getPath() + " Error:" + re);
            return false;
        }
    }

    public boolean lockFile(Identifier id, FileLock flock) {
        try {
            return ((RmiFileManager)_app.getFileManager().getRemote()).lockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("lockFile: RMI Error unlocking " + id.getPath() + " Error:" + re);
            return false;
        }
    }

    public WatershedLocation getWatershedLocation() {
        if (ClientApp.Workspace() == null) {
            return null;
        }
        Vector wlList = this.getWatershedLocations(true);
        String wkspDir = ClientApp.Workspace().getWorkspacePath();
        for (int i = 0; i < wlList.size(); ++i) {
            WatershedLocation wl = (WatershedLocation)wlList.get(i);
            if (!wkspDir.startsWith(wl.getDirectory() + "/")) continue;
            return wl;
        }
        return null;
    }

    public static String getUserDisplayUrl() {
        if (!ClientApp.frame().isVisible()) {
            return null;
        }
        String display = System.getProperty("HecDisplay");
        Object stringUrl = null;
        if (display == null || display.equals("")) {
            try {
                stringUrl = InetAddress.getLocalHost().getHostAddress() + ":0";
            }
            catch (UnknownHostException uhe) {
                System.out.println("Can't find my host address " + uhe);
            }
        } else {
            stringUrl = display;
        }
        return stringUrl;
    }

    public static String getVersionString() {
        int idx;
        String[] versionInfo = RMAIO.getVersionStamp();
        if (versionInfo != null && versionInfo[0] != null && (idx = versionInfo[0].indexOf(".")) > -1 && (idx = versionInfo[0].indexOf(".", idx + 1)) > -1) {
            return versionInfo[0].substring(0, idx);
        }
        return "1.2";
    }

    public static void setCanExitJVM(boolean canExit) {
        _canExitJVM = canExit;
    }

    public static boolean canExitJVM() {
        return _canExitJVM;
    }

    private static final void displayTCUAcceptDialog(String title, Class cls, TcuInfo tcuInfo) {
        int accepted;
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Properties properties = RMAIO.getAppVersionProperties((Class)cls);
        String version = properties == null ? ClientApp.getVersionString() : properties.getProperty("shortVersion", "");
        Preferences pref = Preferences.userNodeForPackage(cls);
        Preferences tcuNode = pref.node("TCU");
        Preferences versionNode = tcuNode.node(version);
        if (versionNode != null && (accepted = versionNode.getInt("ReadTCU", 0)) == 0) {
            TcuAcceptTermsDialog dialog = new TcuAcceptTermsDialog(null, tcuInfo);
            if (dialog.tcuAccepted()) {
                ClientApp.setFirstTimeForVersion(true, version);
                versionNode.putInt("ReadTCU", 1);
            } else {
                System.exit(0);
            }
        }
    }

    protected static void setFirstTimeForVersion(boolean firstTime, String version) {
        _tcuVersion = version;
        _firstTimeForVersion = firstTime;
    }

    public static boolean isFirstTimeForVersion() {
        return _firstTimeForVersion;
    }

    public static String getFirstTimeTcuVersion() {
        return _tcuVersion;
    }

    public Preferences getAppPreferences() {
        return this._preferences;
    }

    protected static int launchScript(String jythonFile, String[] args) throws Throwable {
        if (jythonFile == null || jythonFile.length() == 0) {
            return 100;
        }
        try {
            if (args != null) {
                ScriptEngine.init((String[])args);
            }
            return ScriptEngine.engine().execute(jythonFile, System.getProperty("user.name"), RMAIO.getFileNameNoExtension((String)jythonFile));
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            System.out.println("launchScript:Error running " + jythonFile + " Error:" + e);
            throw e;
        }
    }

    private void printVersionInformation() {
        VersionUtilities.printVersionInformationFor(this.getApplicationName(), this.getClass());
    }

    public abstract String getApplicationName();

    protected void setDSSVersion() {
        DssUtilities.setupDSSDefaultsForApp(this.getApplicationName());
    }
}

