/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.util.FileUtilities;
import hec.util.ProgressDialog;
import hec.util.ZipUtility;
import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.FileCachingLoggingMarker;

public class ClientCache {
    private static final MarkingClassLogger FILE_CACHE_LOGGER = MarkingClassLogger.forMarkingClass(FileCachingLoggingMarker.class);
    public static final int CACHED_NO_NETWORK = CacheMode.CACHED_NO_NETWORK.getMode();
    public static final int CACHED_DBI_NETWORKED = CacheMode.CACHED_DBI_NETWORKED.getMode();
    public static final int NORMAL_CACHED = CacheMode.NORMAL_CACHED.getMode();
    public static final int RELOAD_CACHE = CacheMode.RELOAD_CACHE.getMode();
    public static final int NO_CACHE = CacheMode.NO_CACHE.getMode();
    public static final int LOCAL = 5;
    public static final String[] CACHE_MODES = new String[]{CacheMode.CACHED_NO_NETWORK.getName(), CacheMode.CACHED_DBI_NETWORKED.getName(), CacheMode.NORMAL_CACHED.getName(), CacheMode.RELOAD_CACHE.getName(), CacheMode.NO_CACHE.getName()};
    public static final String[] CACHE_TOOL_TIPS = new String[]{CacheMode.CACHED_NO_NETWORK.getTooltip(), CacheMode.CACHED_DBI_NETWORKED.getTooltip(), CacheMode.NORMAL_CACHED.getTooltip(), CacheMode.RELOAD_CACHE.getTooltip(), CacheMode.NO_CACHE.getTooltip()};
    protected static int _cacheMode = 5;
    protected String _cachedIndexFilename = "shared/cachedFiles.txt";
    protected String _remoteIndexFilename = "shared/remoteFiles.txt";
    protected Hashtable<String, String> _cachedFiles;
    protected Hashtable<String, String> _remoteFiles;
    ClientApp _app;
    String _cacheRootDir;
    String _cacheWatershedDir;
    String _url;
    ProgressDialog _progressBar = null;

    public ClientCache(ClientApp app, String url) {
        this._app = app;
        this._url = url;
        this.resetCache();
    }

    public ClientCache(ClientApp app) {
        this._app = app;
        this._url = null;
        this.resetCache();
    }

    public void resetCache() {
        this._cachedFiles = new Hashtable();
        this._remoteFiles = new Hashtable();
        this._cacheRootDir = this.getDefaultCacheDirectory();
        this._cacheWatershedDir = null;
    }

    public static void setCacheMode(int cacheMode) {
        _cacheMode = cacheMode;
    }

    public static int getCacheMode() {
        return _cacheMode;
    }

    public static boolean isLocal() {
        if (_cacheMode == 5) {
            return true;
        }
        if (_cacheMode == CACHED_NO_NETWORK) {
            return true;
        }
        return _cacheMode == CACHED_DBI_NETWORKED;
    }

    public void loadWorkspaceCacheLists() {
        if (_cacheMode == NORMAL_CACHED || _cacheMode == RELOAD_CACHE) {
            ClientCache clientCache = this;
            String baseDir = clientCache._app.getWorkspaceDir();
            try {
                String[] remoteNames = this.getRemoteNames();
                if (remoteNames == null || remoteNames.length == 0) {
                    return;
                }
                String localFileNameList = baseDir + "/" + this._cachedIndexFilename;
                String localWkspFiles = this.getCachedFilePath(localFileNameList);
                if (localWkspFiles != null) {
                    File localFile;
                    this._remoteFiles = this.getHashedFileList(remoteNames);
                    if (_cacheMode == NORMAL_CACHED && (localFile = new File(localWkspFiles)).exists()) {
                        this._cachedFiles = this.getCachedFileList(this._remoteFiles, localFile);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("ClientCache: getCompressedFileNamesAndInfo: RMI error getting file list for " + baseDir + " Error:" + e);
            }
            if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                this.saveRemoteList();
            }
        }
    }

    protected String[] getRemoteNames() {
        if (_cacheMode == NORMAL_CACHED || _cacheMode == RELOAD_CACHE) {
            ClientCache clientCache = this;
            String baseDir = clientCache._app.getWorkspaceDir();
            try {
                if (baseDir == null) {
                    return null;
                }
                String[] exclude = new String[]{".bak"};
                byte[] compressedNames = ((RmiFileManager)this._app.getFileManager().getRemote()).getCompressedFileNamesAndInfo(this._app.getUser(), baseDir, exclude);
                if (compressedNames == null || compressedNames.length == 0) {
                    return null;
                }
                String[] remoteNames = ClientCache.uncompressFileNames(compressedNames, baseDir);
                return remoteNames;
            }
            catch (Exception e) {
                System.out.println("ClientCache: getCompressedFileNamesAndInfo: RMI error getting file list for " + baseDir + " Error:" + e);
            }
        }
        return null;
    }

    public void setCachingEnabled(boolean cachingEnabled, String cacheRootDir) {
        if (cacheRootDir.length() > 0) {
            this._cacheRootDir = cacheRootDir;
        }
    }

    public String getCacheDirectory() {
        return this._cacheRootDir;
    }

    public boolean getCachingEnabled() {
        block3: {
            block2: {
                if (_cacheMode == 5) break block2;
                if (_cacheMode != NO_CACHE) break block3;
            }
            return false;
        }
        return true;
    }

    public static String[] uncompressFileNames(byte[] compressedFileNames, String baseDir) {
        if (compressedFileNames == null || compressedFileNames.length < 2) {
            return null;
        }
        Vector<String> names = new Vector<String>();
        byte[] uncompressed = ZipUtility.unzip((byte[])compressedFileNames);
        if (uncompressed != null) {
            int beg = 0;
            for (int i = 0; i < uncompressed.length; ++i) {
                if (uncompressed[i] != 10) continue;
                int len = i - beg;
                Object name = new String(uncompressed, beg, len);
                int idx = ((String)name).indexOf(" ");
                if (idx > 0 && baseDir != null) {
                    ++idx;
                    if ((idx = ((String)name).indexOf(" ", idx)) > 0) {
                        name = ++idx < ((String)name).length() ? ((String)name).substring(0, idx) + baseDir + "/" + ((String)name).substring(idx) : (String)name + baseDir;
                    }
                }
                names.add((String)name);
                beg = i + 1;
            }
        }
        return names.toArray(new String[0]);
    }

    public boolean downloadFile(Identifier remoteId, Identifier localId) {
        boolean success = this.downloadFile(remoteId, localId, false);
        if (success) {
            this.addFileToCache(localId);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(Identifier remoteId, Identifier localId, boolean translateCrLf) {
        if (remoteId == null) {
            System.out.println("ClientCache: downloadFile: no remote file id specified or remote file is null");
            return false;
        }
        HecFile remoteFile = remoteId.getFile();
        if (remoteFile == null) {
            try {
                remoteId = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), remoteId);
                if (remoteId == null) {
                    System.out.println("ClientCache: downloadFile: no remote file id specified or remote file is null");
                    return false;
                }
                remoteFile = remoteId.getFile();
            }
            catch (RemoteException re) {
                System.out.println("openWatershed:rmi error opening file " + remoteId.getPath() + " " + re);
                return false;
            }
            if (remoteFile == null) {
                System.out.println("ClientCache: downloadFile: no remote file id specified or remote file is null");
                return false;
            }
        }
        if (remoteFile instanceof HecFileImpl) {
            ((HecFileImpl)remoteFile).setCacheLocalFile(false);
        }
        if (localId == null) {
            System.out.println("ClientCache: downloadFile: no local file id specified");
            return false;
        }
        File localFile = (File)localId.getFile();
        if (localFile == null && (localFile = new File(localId.getPath())) == null) {
            System.out.println("ClientCache: downloadFile: no local file specified");
            return false;
        }
        if (remoteFile.isDirectory()) {
            localFile.mkdirs();
            return true;
        }
        if (!localFile.exists()) {
            File parentDir = localFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.exists()) {
                System.out.println("ClientCache: downloadFile: failed to create local directory " + parentDir.getAbsolutePath());
                return false;
            }
        }
        if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
            String name = remoteId.getFile() != null ? remoteId.getFile().getPath() : remoteId.getPath();
            System.out.println("ClientCache: downloadFile from: " + name);
            name = localId.getFile() != null ? localId.getFile().getPath() : localId.getPath();
            System.out.println("ClientCache: downloadFile to:   " + name);
        }
        ByteArrayInputStream reader = null;
        FileOutputStream writer = null;
        try {
            int len;
            reader = remoteId.getFile().getByteArrayInputStream();
            writer = new FileOutputStream(localId.getPath());
            if (reader == null) {
                if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                    String name = remoteId.getFile() != null ? remoteId.getFile().getPath() : remoteId.getPath();
                    System.out.println("ClientCache: downloadFile:Failed to get stream for source file\n" + name);
                }
                boolean name = false;
                return name;
            }
            if (!ClientApp.isOsWindows()) {
                translateCrLf = false;
            }
            byte[] bytes = new byte[32768];
            boolean first = true;
            int fileType = 0;
            while ((len = reader.read(bytes)) > 0) {
                if (translateCrLf) {
                    if (first) {
                        first = false;
                        fileType = FileUtilities.getUnixPcFileType((byte[])bytes, (int)len);
                        if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                            if (fileType == 0) {
                                System.out.println("Binary file download: " + remoteId.getFile().getPath());
                            } else if (fileType == 1) {
                                System.out.println("Text file download (LF to CR/LF): " + remoteId.getFile().getPath());
                            } else if (fileType == 2) {
                                System.out.println("Text file download (raw): " + remoteId.getFile().getPath());
                            }
                        }
                        if (fileType == 2) {
                            fileType = 0;
                        }
                    }
                    if (fileType > 0) {
                        int[] newLen = new int[1];
                        bytes = FileUtilities.translateUnixPcFile((int)fileType, (byte[])bytes, (int)len, (int[])newLen);
                        len = newLen[0];
                    }
                }
                writer.write(bytes, 0, len);
            }
            writer.flush();
        }
        catch (IOException ioe) {
            System.out.println("ClientCache: downloadFile: failed to download " + remoteId.getPath() + "\nto " + localId.getPath());
            System.out.println("ClientCache: downloadFile: Error " + ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe2) {
                return false;
            }
        }
        return true;
    }

    public boolean downloadFile(String remoteName, String localName, boolean translateCrLf) {
        File localFile = new File(localName);
        Identifier localId = new Identifier(localFile.getAbsolutePath().replace('\\', '/'));
        if (ClientApp.app() == null) {
            return false;
        }
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (fm == null) {
            return false;
        }
        String user = ClientApp.app().getUser();
        try {
            Identifier id;
            Identifier newId;
            if (fm.fileExists(remoteName) && (newId = fm.openFile(user, id = new Identifier(remoteName))) != null) {
                boolean success = this.downloadFile(newId, localId, translateCrLf);
                return success;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to download file " + remoteName);
            System.out.println(e);
        }
        return false;
    }

    public void downloadAllWithProgress() {
        this._progressBar = new ProgressDialog((Dialog)null, 1, false);
        this._progressBar.setTitle("Download Files");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ClientCache.this.downloadAll(true);
            }
        };
        this._progressBar.setRunnable(run);
        this._progressBar.setVisible(true);
        this._progressBar.toFront();
    }

    public int downloadAll(boolean force) {
        int count;
        block10: {
            String user = ClientApp.app().getUser();
            count = 0;
            RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            String[] remoteNames = this.getWatershedFiles();
            if (this._progressBar != null) {
                this._progressBar.setCurrentSize(remoteNames.length);
            }
            try {
                for (int i = 0; i < remoteNames.length; ++i) {
                    int idx;
                    Identifier cid;
                    Identifier id;
                    Identifier newId;
                    if (!fm.fileExists(remoteNames[i]) || (newId = fm.openFile(user, id = new Identifier(remoteNames[i]))) == null || (cid = this.openCachedFile(newId, force, true)) == null) continue;
                    ++count;
                    if (this._progressBar == null) continue;
                    this._progressBar.setCurrentValue(count);
                    String mess = count + " of " + remoteNames.length;
                    if (i < remoteNames.length - 1 && (idx = remoteNames[i + 1].lastIndexOf(47)) > 0) {
                        mess = mess + "; downloading " + remoteNames[i + 1].substring(idx + 1);
                    }
                    this._progressBar.setString(mess);
                    if (this._progressBar.canceled()) break;
                }
                if (this._progressBar != null) {
                    this._progressBar.setVisible(false);
                    if (this._progressBar.canceled()) {
                        String mess = "Download canceled.\n " + count + " files downloaded.";
                        JOptionPane.showMessageDialog(null, mess, "Download", 1);
                    } else if (count == remoteNames.length) {
                        String mess = count + " of " + remoteNames.length + " downloaded";
                        JOptionPane.showMessageDialog(null, mess, "Download", 1);
                    } else {
                        String mess = count + " of " + remoteNames.length + " downloaded";
                        JOptionPane.showMessageDialog(null, mess, "Download", 2);
                    }
                    this.saveCachedList();
                    return count;
                }
            }
            catch (Exception e) {
                System.out.println("Error in downloading files");
                System.out.println(e);
                if (this._progressBar == null) break block10;
                this._progressBar.setVisible(false);
                this._progressBar = null;
                JOptionPane.showMessageDialog(null, "Error during download:\n" + e.toString(), "Download", 0);
            }
        }
        return count;
    }

    public boolean uploadFile(String localName, String remoteName, boolean translateCrLf) {
        return this.uploadFile(localName, remoteName, translateCrLf, 0);
    }

    public boolean uploadFile(String localName, String remoteName, boolean translateCrLf, int runningSize) {
        if (ClientApp.app() == null) {
            return false;
        }
        File localFile = new File(localName);
        if (!localFile.exists()) {
            return false;
        }
        Identifier localId = new Identifier(localFile.getAbsolutePath().replace('\\', '/'));
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (fm == null) {
            return false;
        }
        String user = ClientApp.app().getUser();
        try {
            Identifier id = new Identifier(remoteName);
            Identifier newId = fm.newFile(user, id);
            if (newId == null) {
                newId = fm.openFile(user, id);
            }
            if (newId.getFile().exists() && newId.isReadOnly()) {
                System.out.println("Upload file - File Does Not have Write Access!\n" + remoteName);
                return false;
            }
            if (newId != null) {
                boolean success = this.uploadFile(localId, newId, translateCrLf, runningSize);
                return success;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to upload file " + localName);
            System.out.println(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(Identifier localId, Identifier remoteId, boolean translateCrLf, int runningSize) {
        if (remoteId == null || remoteId.getFile() == null) {
            System.out.println("ClientCache: uploadFile: no remote file id specified or remote file is null");
            return false;
        }
        HecFile remoteFile = remoteId.getFile();
        if (remoteFile instanceof HecFileImpl) {
            ((HecFileImpl)remoteFile).setCacheLocalFile(false);
        }
        if (localId == null) {
            System.out.println("ClientCache: uploadFile: no local file id specified");
            return false;
        }
        File localFile = (File)localId.getFile();
        if (localFile == null && (localFile = new File(localId.getPath())) == null) {
            System.out.println("ClientCache: uploadFile: no local file specified");
            return false;
        }
        if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
            System.out.println("ClientCache: uploadFile from: " + localId.getPath());
            System.out.println("ClientCache: uploadFile to:   " + remoteId.getPath());
        }
        if (localFile.isDirectory()) {
            remoteId.getFile().mkdirs();
            return true;
        }
        FileInputStream reader = null;
        ByteArrayOutputStream writer = null;
        try {
            int len;
            reader = new FileInputStream(localFile);
            remoteId.getFile().setUseCompression(false);
            writer = remoteId.getFile().getByteArrayOutputStream();
            if (reader == null) {
                if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                    System.out.println("ClientCache: uploadFile: Failed to get stream for source file\n" + localFile.getPath());
                }
                boolean bl = false;
                return bl;
            }
            if (writer == null) {
                if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                    System.out.println("ClientCache: uploadFile: Failed to get stream for remote file\n" + remoteId.getFile().getPath());
                }
                boolean bl = false;
                return bl;
            }
            if (!ClientApp.isOsWindows()) {
                translateCrLf = false;
            }
            byte[] bytes = new byte[32768];
            boolean first = true;
            int fileType = 0;
            while ((len = reader.read(bytes)) > 0) {
                runningSize += len;
                byte[] translatedBytes = bytes;
                if (translateCrLf) {
                    if (first) {
                        first = false;
                        fileType = FileUtilities.getUnixPcFileType((byte[])bytes, (int)len);
                        if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                            if (fileType == 0) {
                                System.out.println("Binary file uploadFile: " + localFile.getPath());
                            } else if (fileType == 1) {
                                System.out.println("Text file uploadFile (raw): " + localFile.getPath());
                            } else if (fileType == 2) {
                                System.out.println("Text file uploadFile (CR/LF to LF): " + localFile.getPath());
                            }
                        }
                        if (fileType == 1) {
                            fileType = 0;
                        }
                    }
                    if (fileType > 0) {
                        int[] newLen = new int[1];
                        translatedBytes = FileUtilities.translateUnixPcFile((int)fileType, (byte[])bytes, (int)len, (int[])newLen);
                        len = newLen[0];
                    }
                }
                writer.write(translatedBytes, 0, len);
                if (this._progressBar == null) continue;
                this._progressBar.setCurrentValue(runningSize);
            }
            writer.flush();
        }
        catch (Exception ioe) {
            System.out.println("ClientCache: uploadFile: failed to upload " + localFile.getPath() + "\nto " + remoteId.getPath());
            System.out.println("ClientCache: uploadFile: Error " + ioe);
            ioe.printStackTrace();
            if (this._progressBar != null) {
                String message = "Error uploading file " + localFile.getPath() + "\nto " + remoteId.getPath() + "\nError: " + ioe.toString();
                JOptionPane.showMessageDialog(null, message, "Error during file transfer", 0);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe2) {
                return false;
            }
        }
        return true;
    }

    public int getNumberWatershedFiles() {
        if (this._remoteFiles.size() > 0) {
            return this._remoteFiles.size();
        }
        String[] remoteNames = this.getRemoteNames();
        if (remoteNames != null) {
            return remoteNames.length;
        }
        return 0;
    }

    public String[] getWatershedFiles() {
        String[] remoteNames = this.getRemoteNames();
        if (remoteNames == null || remoteNames.length == 0) {
            return null;
        }
        Vector<String> names = new Vector<String>(remoteNames.length);
        boolean count = false;
        for (int i = 0; i < remoteNames.length; ++i) {
            int idx1;
            String line = remoteNames[i];
            if (line.startsWith("#") || (idx1 = line.indexOf(" ")) <= 0 || idx1 >= line.length() - 2) continue;
            int idx2 = idx1 + 1;
            if ((idx2 = line.indexOf(" ", idx2)) <= 0 || idx2 >= line.length() - 2) continue;
            String filename = line.substring(idx2 + 1);
            names.add(filename);
        }
        return names.toArray(new String[1]);
    }

    public int getNumberCachedFiles() {
        return this._cachedFiles.size();
    }

    public Identifier openCachedFile(Identifier remoteId) {
        return this.openCachedFile(remoteId, false, false);
    }

    protected Identifier openCachedFile(Identifier remoteId, boolean forceDownload, boolean translateCrLf) {
        String remotePath;
        if (remoteId == null) {
            return null;
        }
        if (!this._app.isNetworked()) {
            return this.checkRemoteID(remoteId);
        }
        String cacheDir = this.getCacheWatershedDir();
        if (cacheDir == null) {
            return this.checkRemoteID(remoteId);
        }
        HecFile file = remoteId.getFile();
        if (file != null && !file.isNetworked() && !file.exists()) {
            remoteId.setFile(null);
        }
        if (!this.useCachedFile(remotePath = remoteId.getPath().replace('\\', '/'))) {
            return this.checkRemoteID(remoteId);
        }
        String localPath = this.getCachedFilePath(remotePath);
        if (localPath == null) {
            return this.checkRemoteID(remoteId);
        }
        File localFile = new File(localPath);
        Identifier localId = new Identifier(localFile.getAbsolutePath().replace('\\', '/'));
        boolean download = forceDownload;
        if (_cacheMode == RELOAD_CACHE) {
            download = true;
        }
        if (!localFile.exists()) {
            download = true;
        }
        if (!this.isFileCached(remotePath)) {
            download = true;
        }
        if (download) {
            boolean gotLocal;
            if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                System.out.println("ClientCache: Attempting download of file " + remoteId.getPath() + "\nto " + localId.getPath());
            }
            if (!(gotLocal = this.downloadFile(remoteId, localId, translateCrLf))) {
                if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                    System.out.println("ClientCache: Download file failed, using remote ID");
                }
                return this.checkRemoteID(remoteId);
            }
            this.addFileToCache(localId.getPath());
            if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                System.out.println("ClientCache: Download success, using local copy");
            }
        } else if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
            System.out.println("ClientCache: Using locally cached file " + localId.getPath());
            System.out.println("ClientCache: instead of remote         " + remoteId.getPath());
        }
        HecFileImpl localHecFile = new HecFileImpl(new FilePath(localId.getPath(), remoteId.getPath()));
        localId.setFile((HecFile)localHecFile);
        return localId;
    }

    public String getCachedFilePath(String remotePath) {
        if (_cacheMode == 5) {
            return null;
        }
        if (remotePath == null) {
            return null;
        }
        if (this._app == null || this._app.getAppStartDir() == null) {
            return null;
        }
        Object cachePath = remotePath;
        if (((String)cachePath).startsWith(this._app.getAppStartDir())) {
            cachePath = remotePath.substring(this._app.getAppStartDir().length() + 1, remotePath.length());
        } else {
            Object tmpPath = null;
            Object lastGoodPath = null;
            StringTokenizer tokenizer = new StringTokenizer(this._app.getAppStartDir(), "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken() + "/";
                if (tmpPath == null) {
                    if ("/".equals("/") && !token.startsWith("/")) {
                        token = "/" + token;
                    }
                    tmpPath = token;
                } else {
                    tmpPath = ((String)tmpPath).concat(token);
                }
                if (!((String)cachePath).startsWith((String)tmpPath)) break;
                lastGoodPath = tmpPath;
            }
            if (lastGoodPath == null) {
                if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                    System.out.println("ClientCache: getCachedFilePath: failed to build local path for " + remotePath);
                }
                return null;
            }
            cachePath = ((String)cachePath).substring(((String)lastGoodPath).length(), ((String)cachePath).length());
        }
        String cacheDir = this.getCacheWatershedDir();
        cachePath = cacheDir + "/" + (String)cachePath;
        cachePath = ((String)cachePath).replace("\\", "/");
        return cachePath;
    }

    public String getDefaultCacheDirectory() {
        String appData;
        String osName;
        String appName = this._app.getClass().toString();
        int period = appName.lastIndexOf(".");
        if (period > 0) {
            appName = appName.substring(period + 1);
        }
        String localUserDir = (osName = System.getProperty("os.name")).toLowerCase().startsWith("windows") ? ((appData = System.getenv("APPDATA")) != null ? appData + File.separator + appName : System.getProperty("user.home") + File.separator + "Application Data" + File.separator + appName) : System.getProperty("user.home") + File.separator + appName;
        String defaultDir = localUserDir + File.separator + "cache";
        if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
            System.out.println("ClientCache: getDefaultCacheDirectory: user.home is " + System.getProperty("user.home"));
            System.out.println("ClientCache: getDefaultCacheDirectory: Dir is " + defaultDir);
        }
        return defaultDir;
    }

    public void setCacheWatershedDir(String cacheWatershedDir) {
        this._cacheWatershedDir = cacheWatershedDir;
    }

    public String getCacheWatershedDir() {
        if (this._cacheWatershedDir == null) {
            String defaultDir;
            Object cacheRootDir = this.getCacheDirectory();
            if (((String)cacheRootDir).startsWith(defaultDir = this.getDefaultCacheDirectory())) {
                if (this._url == null) {
                    this._url = this._app.getAppServerUrl();
                }
                if (this._url != null && this._url.length() > 0) {
                    int idx;
                    String server = RMAIO.removeNonPrintable((String)this._url);
                    if ((server = RMAIO.removeChar((String)server, (char)' ')).startsWith("//") && (idx = server.indexOf("/", 2)) > 0) {
                        server = server.substring(2, idx);
                    }
                    server = RMAIO.removeChar((String)server, (char)File.separatorChar);
                    server = RMAIO.removeChar((String)server, (char)':');
                    server = RMAIO.removeChar((String)server, (char)',');
                    server = RMAIO.removeChar((String)server, (char)'.');
                    server = RMAIO.removeChar((String)server, (char)'*');
                    server = RMAIO.removeChar((String)server, (char)'?');
                    server = RMAIO.removeChar((String)server, (char)'>');
                    server = RMAIO.removeChar((String)server, (char)'<');
                    cacheRootDir = (String)cacheRootDir + File.separator + server;
                }
                this._cacheWatershedDir = (String)cacheRootDir + File.separator + "Watershed";
            } else {
                this._cacheWatershedDir = this._cacheRootDir + File.separator + "Watershed";
            }
        }
        return this._cacheWatershedDir;
    }

    public boolean useCachedFile(String filename) {
        if (_cacheMode == CACHED_NO_NETWORK) {
            return true;
        }
        if (_cacheMode == CACHED_DBI_NETWORKED) {
            return true;
        }
        return _cacheMode != NO_CACHE;
    }

    public boolean isFileCached(String filename) {
        String modTime;
        int idx = (filename = filename.toLowerCase()).indexOf("watershed/");
        if (idx > 0) {
            filename = filename.substring(idx);
        }
        return (modTime = this._cachedFiles.get(filename)) != null;
    }

    public boolean addFileToCache(Identifier id) {
        String path = id.getPath();
        return this.addFileToCache(path);
    }

    public boolean addFileToCache(String filename) {
        String modTime;
        int idx = (filename = filename.toLowerCase()).indexOf("watershed/");
        if (idx > 0) {
            filename = filename.substring(idx);
        }
        if ((modTime = this._remoteFiles.get(filename)) == null) {
            return false;
        }
        this._cachedFiles.put(filename, modTime);
        return true;
    }

    public void saveCachedList() {
        if (this._cachedFiles == null || this._cachedFiles.isEmpty()) {
            return;
        }
        if (_cacheMode != NORMAL_CACHED && _cacheMode != RELOAD_CACHE) {
            return;
        }
        if (ClientCache.isLocal()) {
            return;
        }
        Object filename = this._app.getWorkspace().getWorkspacePath() + "/" + this._cachedIndexFilename;
        if ((filename = this.getCachedFilePath((String)filename)) == null) {
            return;
        }
        try {
            File file = new File((String)filename);
            PrintWriter writer = new PrintWriter(file);
            writer.println("# Cached files:  Last mod time (remote), file name");
            writer.println("#");
            Enumeration<String> keys = this._cachedFiles.keys();
            while (keys.hasMoreElements()) {
                String path = keys.nextElement().toLowerCase();
                String modTime = this._cachedFiles.get(path);
                writer.println(modTime + " " + path);
            }
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveRemoteList() {
        if (this._remoteFiles == null || this._remoteFiles.isEmpty()) {
            return;
        }
        ClientCache clientCache = this;
        Object filename = clientCache._app.getWorkspaceDir() + "/" + this._remoteIndexFilename;
        filename = this.getCachedFilePath((String)filename);
        File file = new File((String)filename);
        try {
            if (!file.exists()) {
                File parentDir = file.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                if (!parentDir.exists()) {
                    System.out.println("ClientCache: saveRemoteList: failed to create local directory " + parentDir.getAbsolutePath());
                    return;
                }
            }
            PrintWriter writer = new PrintWriter(file);
            writer.println("# Remote files:  Last mod time (remote), file name");
            writer.println("#  This file is not used - only for info/debug");
            writer.println("#");
            Enumeration<String> keys = this._remoteFiles.keys();
            while (keys.hasMoreElements()) {
                String path = keys.nextElement();
                String modTime = this._remoteFiles.get(path);
                writer.println(modTime + " " + path);
            }
            writer.close();
            if (((MarkingClassLogger.Api)FILE_CACHE_LOGGER.atFine()).isEnabled()) {
                System.out.println("ClientCache: Remote file list (debug only) saved to " + (String)filename);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Hashtable getCachedFileList(Hashtable<String, String> remoteHashtable, File local) {
        Hashtable<String, String> cachedFiles = new Hashtable<String, String>();
        try {
            Hashtable localHashtable = this.getHashedFileList(local);
            Enumeration keys = localHashtable.keys();
            while (keys.hasMoreElements()) {
                String localTime;
                String path = ((String)keys.nextElement()).toLowerCase();
                String remoteTime = remoteHashtable.get(path);
                if (remoteTime == null || (localTime = (String)localHashtable.get(path)) == null || !remoteTime.equals(localTime)) continue;
                cachedFiles.put(path, remoteTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cachedFiles;
    }

    protected Hashtable getHashedFileList(File file) {
        Hashtable<String, String> hashedFiles = new Hashtable<String, String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                int i;
                if ((line = line.toLowerCase()).startsWith("#") || (i = line.indexOf(" ")) <= 0 || i >= line.length() - 2) continue;
                hashedFiles.put(line.substring(i + 1), line.substring(0, i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashedFiles;
    }

    protected Hashtable getHashedFileList(String[] list) {
        Hashtable<String, String> hashedFiles = new Hashtable<String, String>();
        for (int j = 0; j < list.length; ++j) {
            int idx1;
            String line = list[j];
            if (line.startsWith("#") || (idx1 = line.indexOf(" ")) <= 0 || idx1 >= line.length() - 2) continue;
            int idx2 = idx1 + 1;
            if ((idx2 = line.indexOf(" ", idx2)) <= 0 || idx2 >= line.length() - 2) continue;
            String filename = line.substring(idx2 + 1);
            int idx = filename.indexOf("watershed/");
            if (idx > 0) {
                filename = filename.substring(idx);
            }
            hashedFiles.put(filename.toLowerCase(), line.substring(0, idx1));
        }
        return hashedFiles;
    }

    protected Identifier checkRemoteID(Identifier remoteId) {
        if (remoteId.getFile() == null) {
            Identifier openId = this._app.openRemoteFileID(remoteId);
            if (openId == null) {
                return remoteId;
            }
            remoteId = openId;
        }
        return remoteId;
    }

    public void downloadWithProgress(final String[] remoteNames, final String[] localNames, final boolean translateCrLf) {
        this._progressBar = new ProgressDialog((Dialog)null, 1, false);
        this._progressBar.setTitle("Download Files");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ClientCache.this.download(remoteNames, localNames, translateCrLf);
            }
        };
        this._progressBar.setRunnable(run);
        this._progressBar.setVisible(true);
        this._progressBar.toFront();
    }

    public void downloadWithProgress(final Identifier[] remoteIds, final String localDirectory, final boolean translateCrLf) {
        this._progressBar = new ProgressDialog((Dialog)null, 1, false);
        this._progressBar.setTitle("Download Files");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ClientCache.this.download(remoteIds, localDirectory, translateCrLf);
            }
        };
        this._progressBar.setRunnable(run);
        this._progressBar.setVisible(true);
        this._progressBar.toFront();
    }

    public String[] expandRemoteFilenames(Identifier[] ids) throws Exception {
        Vector<String> allRemoteNames = new Vector<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].isDirectory()) {
                String remoteDirectory = ids[i].getPath();
                String[] exclude = new String[]{};
                byte[] compressedNames = ((RmiFileManager)this._app.getFileManager().getRemote()).getCompressedFileNamesAndInfo(this._app.getUser(), remoteDirectory, exclude);
                if (compressedNames == null || compressedNames.length == 0) {
                    return null;
                }
                String[] remoteNames = ClientCache.uncompressFileNames(compressedNames, remoteDirectory);
                for (int j = 0; j < remoteNames.length; ++j) {
                    String name = remoteNames[j];
                    int idx = name.indexOf(" ");
                    if (idx > 0) {
                        ++idx;
                        if ((idx = name.indexOf(" ", idx)) > 0 && ++idx < name.length()) {
                            name = name.substring(idx);
                        }
                    }
                    allRemoteNames.add(name);
                }
                continue;
            }
            allRemoteNames.add(ids[i].getPath());
        }
        return allRemoteNames.toArray(new String[0]);
    }

    public static void getLocalNames(Identifier[] remoteIds, String localDir, Vector<String> remoteNames, Vector<String> localNames) {
        int i;
        String localDirectory = localDir.replace('\\', '/');
        Vector<String> remoteDirectories = new Vector<String>();
        for (i = 0; i < remoteIds.length; ++i) {
            if (remoteIds[i].isDirectory()) {
                String[] remotes = null;
                try {
                    String name = remoteIds[i].getPath();
                    remotes = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).getAllFileNames("", name);
                    if (remotes == null || remotes.length == 0) {
                        String dir = remoteIds[i].getPath();
                        remoteNames.add(remoteIds[i].getPath());
                        remoteDirectories.add(dir);
                        continue;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error in accessing server files:\n" + e.toString(), "Download Error", 0);
                    return;
                }
                String dir = remoteIds[i].getPath();
                for (int j = 0; j < remotes.length; ++j) {
                    remoteNames.add(remotes[j]);
                    remoteDirectories.add(dir);
                }
                continue;
            }
            remoteNames.add(remoteIds[i].getPath());
            remoteDirectories.add("");
        }
        for (i = 0; i < remoteNames.size(); ++i) {
            String remoteDirectory = (String)remoteDirectories.elementAt(i);
            String name = remoteDirectory.length() > 0 ? (remoteDirectory.length() < remoteNames.elementAt(i).length() ? remoteNames.elementAt(i).substring(remoteDirectory.length() + 1) : "") : RMAIO.getFileFromPath((String)remoteNames.elementAt(i));
            String localName = localDirectory + "/" + name;
            localNames.add(localName.replace('/', '\\'));
        }
    }

    public int download(Identifier[] remoteIds, String localDirectory, boolean translateCrLf) {
        block13: {
            try {
                Vector<String> remoteNames = new Vector<String>();
                Vector<String> localNames = new Vector<String>();
                ClientCache.getLocalNames(remoteIds, localDirectory, remoteNames, localNames);
                if (this._progressBar != null) {
                    this._progressBar.setCurrentSize(remoteNames.size());
                }
                int count = 0;
                Vector<String> errors = new Vector<String>();
                for (int i = 0; i < remoteNames.size(); ++i) {
                    if (remoteNames.elementAt(i) != null && localNames.elementAt(i) != null) {
                        boolean success = this.downloadFile(remoteNames.elementAt(i), localNames.elementAt(i), translateCrLf);
                        if (success) {
                            ++count;
                        } else {
                            errors.add(remoteNames.elementAt(i));
                        }
                    }
                    if (this._progressBar == null) continue;
                    this._progressBar.setCurrentValue(count);
                    this._progressBar.setString(count + " of " + remoteNames.size() + " downloaded");
                    if (this._progressBar.canceled()) break;
                }
                if (this._progressBar != null) {
                    this._progressBar.setVisible(false);
                    if (this._progressBar.canceled()) {
                        String mess = "Download canceled.\n " + count + " files downloaded.";
                        JOptionPane.showMessageDialog(null, mess, "Download", 1);
                    } else if (count == remoteNames.size()) {
                        String mess = count == 1 ? remoteNames.elementAt(0) + " downloaded to\n" + localNames.elementAt(0) : count + " of " + remoteNames.size() + " downloaded";
                        JOptionPane.showMessageDialog(null, mess, "Download", 1);
                    } else {
                        String mess = count + " of " + remoteNames.size() + " downloaded\n" + errors.size() + " files failed to downloaded:";
                        for (int i = 0; i < errors.size(); ++i) {
                            mess = mess + "\n" + errors.elementAt(i).toString();
                            if (i <= 10) continue;
                            int n = errors.size() - i;
                            mess = mess + "\n.... (" + n + " more)";
                        }
                        JOptionPane.showMessageDialog(null, mess, "Download", 2);
                    }
                    return count;
                }
            }
            catch (Exception e) {
                System.out.println("Error in downloading files");
                System.out.println(e);
                if (this._progressBar == null) break block13;
                this._progressBar.setVisible(false);
                this._progressBar = null;
                JOptionPane.showMessageDialog(null, "Error during download:\n" + e.toString(), "Download", 0);
            }
        }
        return 0;
    }

    public int download(String[] remoteNames, String[] localNames, boolean translateCrLf) {
        block13: {
            try {
                if (this._progressBar != null) {
                    this._progressBar.setCurrentSize(remoteNames.length);
                }
                int count = 0;
                Vector<String> errors = new Vector<String>();
                for (int i = 0; i < remoteNames.length; ++i) {
                    int idx;
                    boolean success = this.downloadFile(remoteNames[i], localNames[i], translateCrLf);
                    if (success) {
                        ++count;
                    } else {
                        errors.add(remoteNames[i]);
                    }
                    if (this._progressBar == null) continue;
                    this._progressBar.setCurrentValue(count);
                    String mess = count + " of " + remoteNames.length;
                    if (i < remoteNames.length - 1 && (idx = remoteNames[i + 1].lastIndexOf(47)) > 0) {
                        mess = mess + "; downloading " + remoteNames[i + 1].substring(idx + 1);
                    }
                    this._progressBar.setString(mess);
                    if (this._progressBar.canceled()) break;
                }
                if (this._progressBar != null) {
                    this._progressBar.setVisible(false);
                    if (this._progressBar.canceled()) {
                        String mess = "Download canceled.\n " + count + " files downloaded.";
                        JOptionPane.showMessageDialog(null, mess, "Download", 1);
                    } else if (count == remoteNames.length) {
                        String mess = count == 1 ? remoteNames[0] + " downloaded to\n" + localNames[0] : count + " of " + remoteNames.length + " downloaded";
                        JOptionPane.showMessageDialog(null, mess, "Download", 1);
                    } else {
                        String mess = count + " of " + remoteNames.length + " downloaded\n" + errors.size() + " files failed to downloaded:";
                        for (int i = 0; i < errors.size(); ++i) {
                            mess = mess + "\n" + errors.elementAt(i).toString();
                            if (i <= 10) continue;
                            int n = errors.size() - i;
                            mess = mess + "\n.... (" + n + " more)";
                        }
                        JOptionPane.showMessageDialog(null, mess, "Download", 2);
                    }
                    return count;
                }
            }
            catch (Exception e) {
                System.out.println("Error in downloading files");
                System.out.println(e);
                if (this._progressBar == null) break block13;
                this._progressBar.setVisible(false);
                this._progressBar = null;
                JOptionPane.showMessageDialog(null, "Error during download:\n" + e.toString(), "Download", 0);
            }
        }
        return 0;
    }

    public void uploadWithProgress(final File[] files, final String remoteDirectory, final boolean translateCrLf) {
        this._progressBar = new ProgressDialog((Dialog)null, 1, false);
        this._progressBar.setTitle("Upload Files");
        this._progressBar.setSize(400, 130);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ClientCache.this.upload(files, remoteDirectory, translateCrLf);
            }
        };
        this._progressBar.setRunnable(run);
        this._progressBar.setVisible(true);
    }

    public static void getRemoteNames(File[] localFiles, String remoteDir, Vector<String> localNames, Vector<String> remoteNames) {
        int i;
        String remoteDirectory = remoteDir.replace('\\', '/');
        Vector<String> localDirectories = new Vector<String>();
        for (i = 0; i < localFiles.length; ++i) {
            if (localFiles[i].isDirectory()) {
                Vector dirFiles = FileUtilities.listAllFiles((File)localFiles[i]);
                String dir = localFiles[i].getPath();
                for (int j = 0; j < dirFiles.size(); ++j) {
                    localNames.add(((File)dirFiles.elementAt(j)).getPath());
                    localDirectories.add(dir);
                }
                continue;
            }
            localNames.add(localFiles[i].getPath());
            localDirectories.add("");
        }
        for (i = 0; i < localNames.size(); ++i) {
            String localDirectory = (String)localDirectories.elementAt(i);
            String name = localDirectory.length() > 0 ? (localDirectory.length() < localNames.elementAt(i).length() ? localNames.elementAt(i).substring(localDirectory.length() + 1) : "") : RMAIO.getFileFromPath((String)localNames.elementAt(i));
            String remoteName = remoteDirectory + "/" + name;
            remoteNames.add(remoteName.replace('\\', '/'));
        }
    }

    public void upload(File[] files, String remoteDir, boolean translateCrLf) {
        String mess;
        int opt;
        int currentCount = 0;
        int runningSize = 0;
        if (files.length == 0) {
            return;
        }
        long[] size = this.getFileSizes(files);
        long totalSize = 0L;
        for (int i = 0; i < size.length; ++i) {
            totalSize += size[i];
        }
        long availableSize = files[0].getUsableSpace();
        if (totalSize > availableSize && (opt = JOptionPane.showConfirmDialog(null, mess = "Warning - Insufficent space to transfer files.\nSpace required: " + totalSize + "  Space available: " + availableSize + "\nDo you wish to continue anyway?", "Insufficent Disk Space", 0, 0)) == 1) {
            return;
        }
        Vector<String> errors = new Vector<String>();
        Vector<String> localNames = new Vector<String>();
        Vector<String> remoteNames = new Vector<String>();
        ClientCache.getRemoteNames(files, remoteDir, localNames, remoteNames);
        if (this._progressBar != null) {
            this._progressBar.setCurrentSize((int)totalSize);
        }
        for (int i = 0; i < localNames.size(); ++i) {
            if (this._progressBar == null) continue;
            this._progressBar.setCurrentValue(runningSize);
            String mess2 = currentCount + 1 + " of " + localNames.size();
            if (i < localNames.size()) {
                int idx = localNames.elementAt(i).toString().lastIndexOf(47);
                if (idx > 0) {
                    mess2 = mess2 + "; uploading " + localNames.elementAt(i).toString().substring(idx + 1);
                } else {
                    idx = localNames.elementAt(i).toString().lastIndexOf(92);
                    if (idx > 0) {
                        mess2 = mess2 + "; uploading " + localNames.elementAt(i).toString().substring(idx + 1);
                    }
                }
            }
            this._progressBar.setString(mess2);
            boolean success = this.uploadFile(localNames.elementAt(i), remoteNames.elementAt(i), translateCrLf, runningSize);
            if (success) {
                ++currentCount;
                if (size.length > i) {
                    runningSize = (int)((long)runningSize + size[i]);
                }
            } else {
                errors.add(files[i].getPath());
            }
            if (this._progressBar.canceled()) break;
        }
        if (this._progressBar != null) {
            this._progressBar.setVisible(false);
            if (this._progressBar.canceled()) {
                String mess3 = "Upload canceled.\n " + currentCount + " files uploaded.";
                JOptionPane.showMessageDialog(null, mess3, "Upload", 1);
            } else if (currentCount == localNames.size()) {
                String mess4 = currentCount + " of " + localNames.size() + " uploaded";
                JOptionPane.showMessageDialog(null, mess4, "Upload", 1);
            } else {
                String mess5 = currentCount + " of " + localNames.size() + " uploaded\n" + errors.size() + " files failed to upload:";
                for (int i = 0; i < errors.size(); ++i) {
                    mess5 = mess5 + "\n" + errors.elementAt(i).toString();
                    if (i <= 10) continue;
                    int n = errors.size() - i;
                    mess5 = mess5 + "\n.... (" + n + " more)";
                }
                JOptionPane.showMessageDialog(null, mess5, "Upload", 2);
            }
            this._progressBar = null;
        }
    }

    public long[] getFileSizes(File[] files) {
        if (files.length == 1 && files[0].isDirectory()) {
            Vector v = FileUtilities.listAllFiles((File)files[0]);
            files = v.toArray(new File[0]);
        }
        long[] sizes = new long[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            sizes[i] = file.length();
        }
        return sizes;
    }

    public static enum CacheMode {
        CACHED_NO_NETWORK(0, "Cached only - no network", "Uses only cached watershed and data files on your PC only.  No network access will be made."),
        CACHED_DBI_NETWORKED(1, "Cached with network", "Uses only cached watershed files, but updates data from network servers."),
        NORMAL_CACHED(2, "Normal", "Uses local cached files when present, other files from the server and saves to local cache."),
        RELOAD_CACHE(3, "Reload cache", "Always uses watershed files from the server and saves them to local cache."),
        NO_CACHE(4, "No caching", "No caching");

        public final int mode;
        public final String name;
        public final String tooltip;

        private CacheMode(int mode, String name, String tooltip) {
            this.mode = mode;
            this.name = name;
            this.tooltip = tooltip;
        }

        public int getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            return this.getName();
        }
    }
}

