/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.appInterface.ToolBarButtonManager;
import hec.client.MoverDialog;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.ManagerChooser;
import hec.clientapp.client.ManagerInfoDialog;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.ToolBarButtonManagerImpl;
import hec.clientapp.script.ScriptJPanel;
import hec.data.TimeSeriesDataEditorListener;
import hec.dataTable.HecDataTableFrame;
import hec.dataTable.HecDataTableToExcel;
import hec.dssgui.ListSelection;
import hec.dssgui.SaveAs;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dPanelProp;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.HecDataConversion;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerTimeZoneCheck;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapToolPanel;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.MousePanAdapter;
import hec.map.ToolBarButtonItem;
import hec.map.appInterface.MapApplicationModule;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.script.ScriptIdentifier;
import hec.script.ScriptJButton;
import hec.script.ScriptManager;
import hec.script.ScriptableObject;
import hec.server.NameDialog;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGlyphButtonInfo;
import rma.swing.RmaImage;
import rma.swing.RmaJAttributeToolbarButton;
import rma.swing.RmaJPopupMenu;
import rma.swing.RmaJToolbarButton;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;

public class ClientMode
implements ActionListener,
ScriptableObject,
TimeSeriesDataEditorListener,
CallBackInterface,
MapApplicationModule,
Observer {
    protected String _menuName = "";
    protected GridBagLayout _controlGridBag = new GridBagLayout();
    protected JPanel _controlPanel = new ClientModePanel();
    protected JMenu _menu = null;
    protected Vector _menus = null;
    protected List _editMenu = null;
    protected List _toolsMenu;
    protected List _viewMenu;
    protected Font _textFont = UIManager.getFont("TextField.font");
    protected ReflectMultiListener _reflectMultiListener = new ReflectMultiListener();
    protected MapToolPanel _mapTools = null;
    protected HecClientFrame _frame = null;
    public static final int CANCEL_SAVE = 0;
    public static final int OK_SAVE = 1;
    public static final int YES_TO_ALL_SAVE = 2;
    protected Vector _selectedObjects = new Vector();
    protected String _plotName = null;
    protected String _plotPropertiesPath = null;
    protected HecTime _startTime = new HecTime();
    protected HecTime _endTime = new HecTime();
    protected Vector _previousPlotIconData = null;
    protected int _lookbackTime = 0;
    protected int _lookbackInterval = 0;
    protected int _lookaheadTime = 0;
    protected int _lookaheadInterval = 0;
    protected boolean _useRelativeTime = false;
    protected boolean _displayOptionsChanged = false;
    protected boolean _first = true;
    protected int _secondsZoneOffsetDifference = 0;
    protected JLabel _currentLabel = new JLabel("Current:");
    protected HecTime _currentTime = new HecTime(0);
    protected boolean _workspaceLoaded = false;
    protected ToolBarPanel _toolBar = new ToolBarPanel();
    protected boolean _enabled = true;
    LocalPt _popupPoint = null;
    Object _popupObj = null;
    protected ImageIcon _lockIcon;
    protected ImageIcon _unlockIcon;
    protected ToolBarButtonManagerImpl _toolbarManager;
    protected int _modePermission = 4;
    protected ScriptJPanel _scriptPanel;

    public ClientMode(HecClientFrame frame) {
        this._frame = frame;
        this._controlPanel.setLayout(this._controlGridBag);
        this._lockIcon = RmaImage.getImageIcon((String)"Images/smallLock.gif");
        this._toolbarManager = new ToolBarButtonManagerImpl(this);
        this._frame.getMapPanel().addObserver((Observer)this);
    }

    public ClientMode(HecClientFrame frame, String permissionName) {
        this(frame);
        this._modePermission = HecSecurityManager.getSecurityManager().getActionForPermission(permissionName);
    }

    public ReflectMultiListener getReflectMultiListener() {
        return this._reflectMultiListener;
    }

    public void setPopupPoint(LocalPt pt) {
        this._popupPoint = pt;
    }

    public LocalPt getPopupPoint() {
        return this._popupPoint;
    }

    public void setPopupObject(Object obj) {
        this._popupObj = obj;
    }

    public Object getPopupObject() {
        return this._popupObj;
    }

    public void setFrame(HecClientFrame frame) {
        this._frame = frame;
    }

    public HecClientFrame getFrame() {
        return this._frame;
    }

    public MapToolPanel mapTools() {
        return this._mapTools;
    }

    public void setMapTools(MapToolPanel tools) {
        this._mapTools = tools;
        this._mapTools.setEnabled(false);
    }

    public JPanel panel() {
        return this._controlPanel;
    }

    public ToolBarButtonManager getToolBarButtonManager() {
        return this._toolbarManager;
    }

    public void addControlPanelComponent(Component c, GridBagConstraints gbc) {
        c.setFont(this._textFont);
        this._controlGridBag.setConstraints(c, gbc);
        this._controlPanel.add(c);
    }

    public String menuName() {
        return this._menuName;
    }

    public void setMenuName(String name) {
        this._menuName = name;
    }

    public JMenu menu() {
        return this._menu;
    }

    public Vector menus() {
        if (this._menus == null) {
            this._menus = new Vector();
            if (this.menu() != null) {
                this._menus.addElement(this.menu());
            }
        }
        return this._menus;
    }

    public void setMenu(JMenu menu) {
        this._menu = menu;
    }

    public void addMenu(JMenu menu) {
        if (this._menus == null) {
            this._menus = new Vector();
        }
        this._menus.addElement(menu);
    }

    public List getEditMenuItems() {
        return this._editMenu;
    }

    public void addEditMenuItem(JMenuItem menuItem) {
        if (this._editMenu == null) {
            this._editMenu = new ArrayList();
        }
        this._editMenu.add(menuItem);
    }

    public void addEditMenuSeparator() {
        if (this._editMenu == null) {
            this._editMenu = new ArrayList();
        }
        this._editMenu.add(new JSeparator());
    }

    public void insertEditMenuItem(JMenuItem menuItem, int pos) {
        if (this._editMenu == null) {
            this._editMenu = new ArrayList();
        }
        this._editMenu.add(pos, menuItem);
    }

    public List getViewMenuItems() {
        return this._viewMenu;
    }

    public void addViewMenuItem(JMenuItem menuItem) {
        if (this._viewMenu == null) {
            this._viewMenu = new ArrayList();
        }
        this._viewMenu.add(menuItem);
    }

    public void addViewMenuSeparator() {
        if (this._viewMenu == null) {
            this._viewMenu = new ArrayList();
        }
        this._viewMenu.add(new JSeparator());
    }

    public List getToolsMenuItems() {
        return this._toolsMenu;
    }

    public void addToolsMenuItem(JMenuItem menuItem) {
        if (this._toolsMenu == null) {
            this._toolsMenu = new ArrayList();
        }
        this._toolsMenu.add(menuItem);
    }

    public void addToolsMenuSeparator() {
        if (this._toolsMenu == null) {
            this._toolsMenu = new ArrayList();
        }
        this._toolsMenu.add(new JSeparator());
    }

    public boolean hasCommandPanelComponents() {
        return this._controlPanel.getComponentCount() != 0;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    public void updateWorkspace() {
    }

    public void resetWorkspace() {
        this._workspaceLoaded = true;
        this.loadScripts();
    }

    public void updateManagerMaps() {
    }

    public void dssVue_Action() {
        boolean networked = ClientApp.app().networked;
        ListSelection selectFrame = new ListSelection("HecDssVue", 2, true, false, networked);
        String defaultDir = ClientApp.app().getDssListDefaultDir();
        if (!networked) {
            defaultDir = defaultDir.replace('/', File.separatorChar);
        }
        if (defaultDir != null && defaultDir.length() > 5) {
            selectFrame.setDirectory(defaultDir);
        }
        selectFrame.setVisible(true);
    }

    public int checkAndSaveManagerChanges(String modelname, Manager manager, String classname, String typename) {
        return this.checkAndSaveManagerChanges(modelname, manager, classname, typename, true);
    }

    protected int checkAndSaveManagerChanges(String modelname, Manager manager, String classname, String typename, boolean yes2all) {
        Object[] allOpts = new Object[]{"Yes", "Yes To All", "No", "Cancel"};
        Object[] partOpts = new Object[]{"Yes", "No", "Cancel"};
        if (manager == null || !manager.isModified()) {
            return 1;
        }
        String managerName = manager.getName();
        if (manager instanceof StreamAlignment) {
            managerName = "Stream Alignment";
        }
        Object[] options = yes2all ? allOpts : partOpts;
        int opt = 0;
        if (ClientApp.frame().isVisible()) {
            opt = JOptionPane.showOptionDialog((Component)((Object)ClientApp.frame()), "Save changes to " + typename + " " + managerName + "?", "", -1, 3, null, options, options[0]);
        }
        if (!yes2all && opt > 0) {
            ++opt;
        }
        switch (opt) {
            case 3: {
                return 0;
            }
            case 0: 
            case 1: {
                boolean saveMgr = false;
                saveMgr = modelname == null || modelname.equals("") ? ClientApp.Workspace().saveManager(manager) : ClientApp.Workspace().saveManager(modelname, manager);
                if (!saveMgr) {
                    int ans = 0;
                    if (ClientApp.frame().isVisible()) {
                        ans = JOptionPane.showOptionDialog((Component)((Object)ClientApp.frame()), "Saving changes to " + typename + " " + managerName + " failed. Continue?", "Error", -1, 0, null, options, options[0]);
                    }
                    if (ans == 0) {
                        return 1;
                    }
                    return 0;
                }
                if (opt == 0) {
                    return 1;
                }
                return 2;
            }
            case 2: {
                if (manager.reLoadFile()) break;
                int ans = 0;
                if (ClientApp.frame().isVisible()) {
                    ans = JOptionPane.showOptionDialog((Component)((Object)ClientApp.frame()), "Reloading " + typename + " " + manager.getName() + " failed. Continue?", "Error", -1, 0, null, options, options[0]);
                }
                if (ans == 0) {
                    return 1;
                }
                return 0;
            }
        }
        return 1;
    }

    protected Identifier getUserSpecifiedName(String typename, Vector idlist) {
        return this.getUserSpecifiedName(typename, idlist, null);
    }

    protected Identifier getUserSpecifiedName(String typename, Vector idlist, String defaultname) {
        NameDialog namedlg = new NameDialog((Frame)((Object)this._frame), true);
        String workspaceName = "";
        workspaceName = ClientApp.Workspace() != null ? ClientApp.Workspace().getTitleName() + " - " : "";
        namedlg.setTitle(workspaceName + "Create a New " + typename);
        namedlg.setNameLabel("Name:");
        if (defaultname != null) {
            namedlg.setName(defaultname);
        }
        String name = "";
        String descr = "";
        boolean done = false;
        block0: while (!done) {
            namedlg.setVisible(true);
            if (namedlg.isCanceled()) {
                return null;
            }
            name = namedlg.getName().trim();
            descr = namedlg.getDescription().trim();
            if (name.length() == 0) {
                return null;
            }
            done = true;
            for (int i = 0; i < idlist.size(); ++i) {
                Identifier id = (Identifier)idlist.elementAt(i);
                if (!name.equalsIgnoreCase(id.getName())) continue;
                JOptionPane.showMessageDialog((Component)((Object)this._frame), name + " is used by another " + typename + ", enter a unique name.", "Name Conflict", 0);
                done = false;
                continue block0;
            }
        }
        namedlg.dispose();
        Identifier newid = new Identifier();
        newid.setName(name);
        newid.setDescription(descr);
        return newid;
    }

    protected Manager createNewManager(String modelname, Manager currentmanager, String classname, String extension, String typename, Vector idlist) {
        return this.createNewManager(modelname, currentmanager, classname, extension, typename, idlist, null);
    }

    protected Manager createNewManager(String modelname, Manager currentmanager, String classname, String extension, String typename, Vector idlist, String defaultname) {
        if (this.checkAndSaveManagerChanges(modelname, currentmanager, classname, typename) < 1) {
            return null;
        }
        Identifier newid = this.getUserSpecifiedName(typename, idlist, defaultname);
        if (newid == null) {
            return null;
        }
        String name = newid.getName();
        if (name == null || name.length() == 0) {
            return null;
        }
        Identifier id = ClientApp.Workspace().getManagerIdentifier(modelname, classname, name, extension);
        id.setDescription(newid.getDescription());
        Manager newmanager = ClientApp.Workspace().newManager(modelname, classname);
        boolean success = ClientApp.Workspace().saveManagerAs(modelname, newmanager, id);
        if (!success) {
            ClientApp.app().errMsgBox(new Msg("Unable to save " + typename, 1));
            return null;
        }
        return newmanager;
    }

    protected Manager chooseManager(String modelname, Manager currentmanager, String classname, String typename) {
        Manager newmanager = null;
        if (this.checkAndSaveManagerChanges(modelname, currentmanager, classname, typename) < 1) {
            return null;
        }
        this._frame.setWaitCursor();
        ManagerChooser chooser = new ManagerChooser((Frame)((Object)this._frame), true, 4, 1L);
        String title = ClientApp.Workspace().getTitleName();
        chooser.setTitle(title + " - Open " + typename);
        chooser.setManagerType(modelname, classname, "");
        this._frame.setDefaultCursor();
        chooser.setVisible(true);
        if (!chooser.ok()) {
            return null;
        }
        Identifier id = chooser.getIdentifier();
        if (id != null) {
            newmanager = ClientApp.Workspace().openManager(modelname, id);
        }
        chooser.dispose();
        if (newmanager == null) {
            JOptionPane.showMessageDialog((Component)((Object)this._frame), "Failed to load " + typename + " " + id.getName(), "Open Failed", 0);
        }
        return newmanager;
    }

    protected Manager chooseManager(String modelname, Manager currentmanager, String classname, String typename, String filter) {
        Manager newmanager = null;
        if (this.checkAndSaveManagerChanges(modelname, currentmanager, classname, typename) < 1) {
            return null;
        }
        this._frame.setWaitCursor();
        ManagerChooser chooser = new ManagerChooser((Frame)((Object)this._frame), true, 4, 1L);
        chooser.setNameFilter(filter);
        String title = ClientApp.Workspace().getTitleName();
        chooser.setTitle(title + " - Open " + typename);
        chooser.setManagerType(modelname, classname, "");
        this._frame.setDefaultCursor();
        chooser.setVisible(true);
        if (!chooser.ok()) {
            return null;
        }
        Identifier id = chooser.getIdentifier();
        if (id != null) {
            newmanager = ClientApp.Workspace().openManager(modelname, id);
        }
        chooser.dispose();
        if (newmanager == null) {
            JOptionPane.showMessageDialog((Component)((Object)this._frame), "Failed to load " + typename + " " + id.getName(), "Open Failed", 0);
        }
        return newmanager;
    }

    public boolean validateManagers() {
        return true;
    }

    public boolean objectPopupMenu(NamedType[] objs, LocalPt pt) {
        if (objs != null && objs.length > 0) {
            return this.objectPopupMenu(objs[0], pt);
        }
        return false;
    }

    public boolean objectPopupMenu(NamedType obj, LocalPt pt) {
        return false;
    }

    public boolean objectDoubleClick(NamedType obj, LocalPt pt) {
        return false;
    }

    public void modeOpening() {
        this._displayOptionsChanged = false;
    }

    public void modeClosing() {
    }

    public void workspaceOpening() {
        if (this._mapTools != null) {
            this._mapTools.setEnabled(true);
        }
    }

    public boolean workspaceClosing() {
        return true;
    }

    public MapToolPanel getMapTools() {
        return this._mapTools;
    }

    public void workspaceClosed() {
        if (this._mapTools != null) {
            this._mapTools.setEnabled(false);
        }
    }

    public String getPlotName() {
        return this._plotName;
    }

    public void setPlotName(String name) {
        this._plotName = name;
    }

    public String getPlotPropertiesPath() {
        return this._plotPropertiesPath;
    }

    public void setPlotPropertiesPath(String path) {
        this._plotPropertiesPath = path;
    }

    public G2dPanelProp loadPlotProperties(String path) {
        if (path == null) {
            return null;
        }
        Identifier id = new Identifier(path);
        Identifier id2 = null;
        try {
            id2 = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), id);
            if (id2 == null || id2.getFile() == null) {
                return null;
            }
        }
        catch (RemoteException e) {
            return null;
        }
        HecFile file = id2.getFile();
        G2dPanelProp prop = new G2dPanelProp();
        BufferedReader buffR = file.getBufferedReader();
        prop.readProperties(buffR);
        try {
            buffR.close();
        }
        catch (Exception e) {
            System.out.println("Error Closing Properties Template");
            System.out.println(e.getMessage());
        }
        return prop;
    }

    public String getTimeWindowString() {
        return null;
    }

    public void plot(String[] name) {
    }

    public boolean canOpen() {
        return true;
    }

    public boolean switchModeOk() {
        return true;
    }

    public void createToolBar() {
        if (this._toolBar == null) {
            this._toolBar = new ToolBarPanel();
        }
        String offIcn = "Images/streamUnSelect.gif";
        String onIcn = "Images/streamSelect.gif";
        this.addToolBarButton(new RmaGlyphButtonInfo(offIcn, onIcn, StreamAlignmentGlyph.class.getName(), "ALL", "Stream Alignment"));
        this.addToolBarSeparator();
    }

    public void updateFrameToolBar() {
        this._toolbarManager.load();
    }

    public JPanel getToolBarItems() {
        return this._toolBar;
    }

    public void addToolBarButton(RmaGlyphButtonInfo buttonInfo) {
        Object button = buttonInfo.getAttributeSetName() == null ? new RmaJToolbarButton(buttonInfo) : new RmaJAttributeToolbarButton(buttonInfo, this.toString());
        button.addActionListener((ActionListener)this._frame.getMapPanel());
        this._toolBar.add((Component)button);
    }

    public void addToolBarSeparator() {
    }

    public void addToolBarComponent(JComponent c) {
        this._toolBar.add(c);
    }

    protected MapToolPanel createModeToolbar(boolean pointer, boolean tsIcons, boolean zoom, boolean pan, int lastButton, int defaultSelection) {
        ButtonGifStrings bgstr;
        JToggleButton button;
        MapToolPanel tools = new MapToolPanel(this._frame.getMapPanel());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        int numberComponents = 0;
        if (pointer) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Point.gif";
            bgstr.down = "Images/Point.gif";
            bgstr.over = "Images/Point.gif";
            bgstr.on = "Images/Point.gif";
            bgstr.borderPainted = true;
            bgstr.adapter = "hec.map.PointerMouseAdapter";
            gbc.insets = new Insets(0, 0, 0, 0);
            if (lastButton == numberComponents) {
                gbc.weighty = 1.0;
            }
            tools.addToolButton(button, bgstr);
            ++numberComponents;
        }
        if (tsIcons) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/Icons/model.gif";
            bgstr.down = "Images/Icons/modelSel.gif";
            bgstr.over = "Images/Icons/model.gif";
            bgstr.on = "Images/Icons/modelSel.gif";
            bgstr.adapter = "hec.dssmapgui.client.DmgTSMouseAdapter";
            bgstr.borderPainted = true;
            gbc.insets = new Insets(0, 0, 0, 0);
            if (lastButton == numberComponents) {
                gbc.weighty = 1.0;
            }
            tools.addToolButton(button, bgstr);
            ++numberComponents;
        }
        if (zoom) {
            button = new JToggleButton();
            bgstr = new ButtonGifStrings();
            bgstr.up = "Images/ZoomUp.gif";
            bgstr.down = "Images/ZoomDown.gif";
            bgstr.over = "Images/ZoomUp.gif";
            bgstr.on = "Images/ZoomDown.gif";
            bgstr.borderPainted = true;
            bgstr.adapter = "hec.map.MouseZoomAdapter";
            gbc.insets = new Insets(5, 0, 0, 0);
            if (lastButton == numberComponents) {
                gbc.weighty = 1.0;
            }
            tools.addToolButton(button, bgstr);
            ++numberComponents;
        }
        if (pan) {
            button = new JToggleButton();
            bgstr = MousePanAdapter.buildDefaultButtonGifStrings();
            gbc.insets = new Insets(0, 0, 0, 0);
            if (lastButton == numberComponents) {
                gbc.weighty = 1.0;
            }
            tools.addToolButton(button, bgstr);
            ++numberComponents;
        }
        if (defaultSelection > -1 && defaultSelection < numberComponents) {
            tools.selectButton(defaultSelection);
        }
        return tools;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public String getScriptableName() {
        if (this._controlPanel == null || this._controlPanel.getComponentCount() < 1) {
            return "ClientMode";
        }
        Component comp = this._controlPanel.getComponent(0);
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        return "ClientMode";
    }

    public Vector getScriptableTypes() {
        return null;
    }

    public Vector getScriptableObjectsForType(String c) {
        return null;
    }

    public ScriptableObject getScriptableObjectByName(String name) {
        return null;
    }

    public void saveState() {
    }

    public int deleteValues(Map timeSeriesTimeWindowMap) {
        Logger logger = Logger.getLogger(ClientMode.class.getName());
        logger.log(Level.FINE, "Delete values No-Op");
        return 0;
    }

    public boolean save(Serializable object) {
        if (object instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsContainer = (TimeSeriesContainer)object;
            RetrieveStatus status = new RetrieveStatus();
            this.saveTS(tsContainer, new RetrieveStatus());
            if (status.seriousError) {
                ClientApp.app().postWarning(status.message.toString(), "Error");
            } else {
                ClientApp.app().postMessage(tsContainer.fullName + " saved.", "Data set saved", 1);
                return true;
            }
        }
        return false;
    }

    public boolean saveAs(Serializable object) {
        if (object instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsContainer = (TimeSeriesContainer)object;
            SaveAs saveDialog = new SaveAs((Frame)((Object)this._frame), new DSSPathname(tsContainer.fullName));
            saveDialog.showOptions(false, false);
            saveDialog.setVisible(true);
            if (!saveDialog.canceled()) {
                tsContainer.fullName = saveDialog.getPathname().getPathname();
                this.save((Serializable)tsContainer);
                return true;
            }
        }
        return false;
    }

    public void plot(List objects) {
        Vector containers = new Vector(objects);
        if (containers.size() > 0) {
            if (HecClientFrame._unitSystem != 0) {
                HecDataConversion.convertUnits(containers, (int)HecClientFrame._unitSystem);
            }
            TimeSeriesContainerTimeZoneCheck.checkTimezone(containers);
            G2dDialog gfxdlg = new G2dDialog((Frame)((Object)this._frame), "", false, containers, (Vector)null);
            gfxdlg.setVisible(true);
        }
    }

    public void tabulate(List objects) {
        Vector containers = new Vector(objects);
        if (containers.size() > 0) {
            if (HecClientFrame._unitSystem != 0) {
                HecDataConversion.convertUnits(containers, (int)HecClientFrame._unitSystem);
            }
            HecDataTableFrame table = new HecDataTableFrame((Object)this._frame);
            this._frame.setTablePreferences(table);
            table.setData(containers);
            table.setVisible(true);
        }
    }

    protected int saveTS(TimeSeriesContainer timeSeriesContainer, RetrieveStatus status) {
        DSSManager dssmanager = null;
        try {
            dssmanager = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
        }
        catch (Exception e) {
            status.message.append("Unable to access DSS Data Manager");
            status.seriousError = true;
            return -1;
        }
        if (dssmanager == null) {
            status.message.append("Unable to access DSS Data Manager");
            status.seriousError = true;
            return -1;
        }
        try {
            return dssmanager.write((DataContainer)timeSeriesContainer);
        }
        catch (Exception e) {
            status.message.append("Unable to access DSS Data Manager");
            status.seriousError = true;
            return -1;
        }
    }

    protected G2dDialog plot0(Vector dssNameList, String title, boolean setVisible, Vector colorVec, RetrieveStatus status) {
        G2dDialog gfxdlg = null;
        String timeWindow = this.getTimeWindowString();
        if (timeWindow == null) {
            status.message.append("No Time Window Set");
            status.seriousError = true;
            return null;
        }
        Vector containers = new Vector();
        if (dssNameList.size() > 0) {
            this.readDssDataSets(dssNameList, timeWindow, containers, status);
            if (status.seriousError) {
                return null;
            }
            if (containers.size() > 0) {
                if (HecClientFrame._unitSystem != 0) {
                    HecDataConversion.convertUnits(containers, (int)HecClientFrame._unitSystem);
                }
                TimeSeriesContainerTimeZoneCheck.checkTimezone(containers);
                gfxdlg = new G2dDialog((Frame)((Object)this._frame), title, false, containers, colorVec);
                if (setVisible) {
                    gfxdlg.setVisible(true);
                }
            }
        }
        return gfxdlg;
    }

    protected G2dDialog plot1(Vector dssNameList, String title, boolean setVisible, G2dPanelProp prop, RetrieveStatus status) {
        G2dDialog gfxdlg = null;
        String timeWindow = this.getTimeWindowString();
        if (timeWindow == null) {
            status.message.append("No Time Window Set");
            status.seriousError = true;
            return null;
        }
        if (prop == null) {
            String path = this.getPlotPropertiesPath();
            prop = this.loadPlotProperties(path);
        }
        Vector containers = new Vector();
        if (dssNameList.size() > 0) {
            this.readDssDataSets(dssNameList, timeWindow, containers, status);
            if (status.seriousError) {
                return null;
            }
            if (containers.size() > 0) {
                if (HecClientFrame._unitSystem != 0) {
                    HecDataConversion.convertUnits(containers, (int)HecClientFrame._unitSystem);
                }
                gfxdlg = new G2dDialog((Frame)((Object)this._frame), title, false, containers, prop);
                if (setVisible) {
                    gfxdlg.setVisible(true);
                }
            }
        }
        return gfxdlg;
    }

    protected HecDataTableFrame tabulateTimeSeries(Vector dssNameList, boolean setVisible, RetrieveStatus status) {
        HecDataTableFrame table = null;
        String timeWindow = this.getTimeWindowString();
        if (timeWindow == null) {
            status.message.append("No Time Window Set");
            status.seriousError = true;
            return null;
        }
        Vector containers = new Vector();
        this.readDssDataSets(dssNameList, timeWindow, containers, status);
        if (status.seriousError) {
            return null;
        }
        if (containers.size() > 0) {
            if (HecClientFrame._unitSystem != 0) {
                HecDataConversion.convertUnits(containers, (int)HecClientFrame._unitSystem);
            }
            table = new HecDataTableFrame((Object)this._frame);
            this._frame.setTablePreferences(table);
            int istat = table.setData(containers);
            if (istat == 0) {
                Object obj = containers.elementAt(0);
                String timezone = ((TimeSeriesContainer)obj).timeZoneID;
                if (timezone != null && timezone.length() > 2) {
                    String current;
                    String view;
                    String title = timezone;
                    TimeZone clientTimeZone = ClientApp.app().getClientTimeZone();
                    if (clientTimeZone != null && ((view = clientTimeZone.getDisplayName(false, 0)) != null || view.length() >= 0)) {
                        title = view;
                    }
                    if ((current = table.getTableTitleText()) == null || current.length() < 1) {
                        table.setTableTitleText(title);
                    }
                }
                table.allowEditing(false);
                if (setVisible) {
                    table.show();
                }
            }
        }
        return table;
    }

    protected void tabulateInExcel(Vector dssNameList, RetrieveStatus status) {
        String timeWindow = this.getTimeWindowString();
        if (timeWindow == null) {
            status.message.append("No Time Window Set");
            status.seriousError = true;
            return;
        }
        Vector containers = new Vector();
        this.readDssDataSets(dssNameList, timeWindow, containers, status);
        if (status.seriousError) {
            return;
        }
        if (containers.size() > 0) {
            if (HecClientFrame._unitSystem != 0) {
                HecDataConversion.convertUnits(containers, (int)HecClientFrame._unitSystem);
            }
            HecDataTableToExcel excelTable = new HecDataTableToExcel();
            try {
                excelTable.runExcel(containers);
            }
            catch (Exception e) {
                ClientApp.app().postWarning(e.getMessage(), "");
            }
        }
    }

    public int readDssDataSets(Vector datalist, String timeWindow, Vector containers, RetrieveStatus status) {
        Object obj;
        DSSManager dssmanager = null;
        try {
            dssmanager = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
        }
        catch (Exception e) {
            status.message.append("Unable to access DSS Data Manager");
            status.seriousError = true;
            return -1;
        }
        if (dssmanager == null) {
            status.message.append("Unable to access DSS Data Manager");
            status.seriousError = true;
            return -1;
        }
        TimeZone watershedTimeZone = ClientApp.Workspace().getWatershedTimeZone();
        TimeZone displayTimeZone = ClientApp.app().getClientTimeZone();
        int numberSetsRead = 0;
        int numberSetsNotRead = 0;
        Enumeration e = datalist.elements();
        while (e.hasMoreElements()) {
            DataReference dataSet = (DataReference)e.nextElement();
            DSSIdentifier dssId = new DSSIdentifier(dataSet.getFilename(), dataSet.getPath());
            dssId.setTimeWindow(timeWindow);
            if (displayTimeZone != null) {
                String displayTimeZoneID = displayTimeZone.getID();
                dssId.setTimeZoneID(displayTimeZoneID);
            }
            int type = 0;
            try {
                String file = dataSet.getFilename();
                type = dssmanager.recordType(file, dataSet.getPath());
            }
            catch (RemoteException re) {
                status.message.append("Error in ClientMode.readDssDataSets() with DSSManager  " + re);
                status.seriousError = true;
                return -1;
            }
            if (type == -1) {
                status.message.append("Unable to access file " + dataSet.getFilename());
                status.message.append("\n for " + dataSet.getPath());
                continue;
            }
            if (type >= 100 && type < 200) {
                try {
                    TimeSeriesContainer timeSeriesContainer = dssmanager.readTS(dssId, false, true);
                    if (timeSeriesContainer != null && timeSeriesContainer.values != null && timeSeriesContainer.values.length > 0) {
                        if (timeSeriesContainer.timeZoneID == null) {
                            timeSeriesContainer.timeZoneID = watershedTimeZone.getID();
                            timeSeriesContainer.timeZoneRawOffset = watershedTimeZone.getRawOffset();
                        }
                        TimeSeriesContainer tsc = new TimeSeriesContainer();
                        timeSeriesContainer.clone(tsc);
                        containers.add(tsc);
                        ++numberSetsRead;
                        continue;
                    }
                    if (numberSetsNotRead == 0) {
                        status.message.append("Data not found for the following:");
                        status.message.append("\nTime window:  " + timeWindow);
                    }
                    ++numberSetsNotRead;
                    status.message.append("\n" + dataSet.getFilename() + ":" + dataSet.getPath());
                    continue;
                }
                catch (FileNotFoundException fne) {
                    status.message.append("DSS file not found." + fne);
                    status.seriousError = true;
                    return -1;
                }
                catch (RemoteException re) {
                    status.message.append("Error in ClientMode with DSSManager  " + re);
                    status.seriousError = true;
                    return -1;
                }
            }
            if (type < 200 || type >= 300) continue;
            try {
                PairedDataContainer pairedDataContainer = dssmanager.readPairedDataContainer(dssId);
                if (pairedDataContainer != null && pairedDataContainer.xOrdinates != null) {
                    PairedDataContainer pdc = new PairedDataContainer();
                    pairedDataContainer.clone(pdc);
                    containers.add(pdc);
                    ++numberSetsRead;
                    continue;
                }
                if (numberSetsNotRead == 0) {
                    status.message.append("Data not found for the following:");
                }
                ++numberSetsNotRead;
                status.message.append("\n" + dataSet.getFilename() + ":" + dataSet.getPath());
            }
            catch (RemoteException re) {
                status.message.append("Error in ClientMode with DSSManager  " + re);
                status.seriousError = true;
                return -1;
            }
        }
        status.numberDataSetsRequested += numberSetsNotRead + numberSetsRead;
        status.numberDataSetsRead += numberSetsRead;
        if (numberSetsRead == 0) {
            return 0;
        }
        if (displayTimeZone != null) {
            String displayZoneId = displayTimeZone.getID();
            for (int i = 0; i < containers.size(); ++i) {
                obj = containers.elementAt(i);
                if (!(obj instanceof TimeSeriesContainer)) continue;
                TimeSeriesContainer tsc = (TimeSeriesContainer)obj;
                if (tsc.timeZoneID == null || tsc.numberValues <= 0 || tsc.timeZoneID.equals(displayZoneId) || tsc.fileName.indexOf("forecast.dss") <= -1) continue;
                int minutesDiff = (displayTimeZone.getRawOffset() - tsc.timeZoneRawOffset) / 60000;
                tsc.timeZoneID = displayZoneId;
                tsc.timeZoneRawOffset = displayTimeZone.getRawOffset();
                tsc.startTime += minutesDiff;
                tsc.endTime += minutesDiff;
                int j = 0;
                while (j < tsc.numberValues) {
                    int n = j++;
                    tsc.times[n] = tsc.times[n] + minutesDiff;
                }
            }
        }
        int unitSystem = this._frame.getDisplayUnitSystem();
        for (int i = 0; i < containers.size(); ++i) {
            obj = containers.elementAt(i);
            if (!(obj instanceof TimeSeriesContainer)) continue;
            TimeSeriesContainer tsc = (TimeSeriesContainer)obj;
            int dataUnitSystem = HecDataConversion.getUnitSystem((String)tsc.units);
            if (unitSystem == dataUnitSystem || dataUnitSystem == 0) continue;
            HecDataConversion.convertUnits((TimeSeriesContainer)tsc, (int)unitSystem);
        }
        return 0;
    }

    public void showErrors(String message) {
        System.out.println(message);
        ClientApp.app().postWarning(message.toString(), "");
    }

    public void setLookbackTime(int lookbackTime, int lookbackInterval, int iconUpdateInterval) {
        this._lookbackTime = lookbackTime;
        this._lookbackInterval = lookbackInterval;
    }

    public void setLookaheadTime(int lookaheadTime, int lookaheadInterval) {
        this._lookaheadTime = lookaheadTime;
        this._lookaheadInterval = lookaheadInterval;
    }

    public void setTimeWindow(HecTime start, HecTime end) {
        this.setStartTime(start);
        this.setEndTime(end);
    }

    public void setStartTime(HecTime start) {
        this._startTime.set(start);
    }

    public void setEndTime(HecTime end) {
        this._endTime.set(end);
    }

    public void setUseRelativeTime(boolean useRelativeTime) {
        this._useRelativeTime = useRelativeTime;
    }

    public boolean getTimeWindow(HecTime startTime, HecTime endTime) {
        if (!this._useRelativeTime) {
            startTime.set(this._startTime);
            endTime.set(this._endTime);
        } else if (this._lookbackTime != 0 || this._lookaheadTime != 0) {
            int startInc = startTime.timeIncrement();
            int endInc = endTime.timeIncrement();
            startTime.setTimeIncrement(2);
            startTime.setCurrent();
            int hoursBack = this._lookbackTime;
            if (this._lookbackInterval == 1) {
                hoursBack *= 24;
            }
            startTime.subtract(hoursBack);
            endTime.setTimeIncrement(2);
            endTime.setCurrent();
            int hoursAhead = this._lookaheadTime;
            if (this._lookaheadInterval == 1) {
                hoursAhead *= 24;
            }
            endTime.add(hoursAhead);
            endTime.add(1);
            startTime.setTimeIncrement(startInc);
            endTime.setTimeIncrement(endInc);
        } else {
            startTime.setUndefined();
            endTime.setUndefined();
        }
        return startTime.isDefined() && endTime.isDefined();
    }

    public void setWorkspaceLoaded(boolean flag) {
        this._workspaceLoaded = flag;
    }

    public boolean getWorkspaceLoaded() {
        return this._workspaceLoaded;
    }

    public void unlock() {
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._menuName;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean b) {
        this._enabled = b;
    }

    public boolean isCurrentMode() {
        return ClientApp.frame().getCurrentMode() == this;
    }

    public boolean hasWriteLock(MapGlyph g) {
        return true;
    }

    public boolean lockManager(Manager mgr, String errString, Manager dependentMgr, JCheckBoxMenuItem menuItem, RmiFileCallBackImpl[] callbackHolder) {
        return this.lockManager(mgr, errString, dependentMgr, menuItem, callbackHolder, 6);
    }

    public boolean lockManager(Manager mgr, String errString, Manager dependentMgr, JCheckBoxMenuItem menuItem, RmiFileCallBackImpl[] callbackHolder, int lockType) {
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (mgr == null) {
            return false;
        }
        try {
            Identifier id = mgr.getIdentifier();
            FileLock fLock = new FileLock(ClientApp.app().getUser(), lockType);
            boolean b = fm.lockFile(id, fLock);
            if (!b) {
                if (dependentMgr != null) {
                    FileLock unFLock = FileLock.getUnlockForLock((FileLock)fLock);
                    fm.unlockFile(dependentMgr.getIdentifier(), unFLock);
                }
                System.out.println(errString + mgr.getName());
                if (menuItem != null) {
                    menuItem.setSelected(false);
                }
                if (this._frame.isVisible()) {
                    int opt = JOptionPane.showOptionDialog((Component)((Object)this._frame), errString + mgr.getName(), "Lock Failed", 0, 2, null, new Object[]{"OK", "More Info"}, "OK");
                    if (opt == 0) {
                        return false;
                    }
                    FileLockInfoJDialog dialog = new FileLockInfoJDialog((Frame)((Object)this._frame));
                    dialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
                    dialog.setUserId(ClientApp.app().getUser());
                    Vector v = null;
                    try {
                        v = fm.getLockers(id);
                    }
                    catch (RemoteException re) {
                        System.out.println("Failed to get Lock info for Manager " + re);
                    }
                    dialog.fillForm(id, v);
                    dialog.pack();
                    dialog.setVisible(true);
                }
                return false;
            }
            callbackHolder[0] = this.setCallback(mgr);
            return true;
        }
        catch (RemoteException re) {
            System.out.println("RMI Error with FileManager locking manager " + mgr.getName() + " error " + re);
            if (menuItem != null) {
                menuItem.setSelected(false);
            }
            return false;
        }
    }

    public boolean unlockManager(Manager mgr, String errString, RmiFileCallBackImpl callback, JCheckBoxMenuItem menuItem) {
        return this.unlockManager(mgr, errString, callback, menuItem, 7);
    }

    public boolean unlockManager(Manager mgr, String errString, RmiFileCallBackImpl callback, JCheckBoxMenuItem menuItem, int unlockType) {
        if (mgr == null) {
            return true;
        }
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        FileLock fLock = new FileLock(ClientApp.app().getUser(), unlockType);
        try {
            Identifier id = mgr.getIdentifier();
            if (!fm.unlockFile(id, fLock)) {
                System.out.println(errString + mgr.getName());
                if (menuItem != null) {
                    menuItem.setSelected(true);
                }
                return false;
            }
            this.removeCallback(callback, id);
            return true;
        }
        catch (RemoteException re) {
            System.out.println("RMI Error with FileManager unlocking " + mgr.getName() + " " + re);
            if (menuItem != null) {
                menuItem.setSelected(true);
            }
            return false;
        }
    }

    protected RmiFileCallBackImpl setCallback(Manager mgr) {
        RmiFileCallBackImpl callBack;
        Identifier id = mgr.getIdentifier();
        if (id == null || id.getFile() == null) {
            return null;
        }
        try {
            callBack = new RmiFileCallBackImpl((CallBackInterface)this);
        }
        catch (RemoteException e) {
            System.out.println("Error creating callback exception: " + e);
            e.printStackTrace(System.out);
            return null;
        }
        RemoteWrapper wrap = new RemoteWrapper((Remote)callBack);
        HecFile file = id.getFile();
        if (file instanceof HecFileImpl) {
            ((HecFileImpl)file).setCallBack(wrap);
        }
        return callBack;
    }

    protected void removeCallback(RmiFileCallBackImpl callback, Identifier id) {
        if (id == null || id.getFile() == null || callback == null) {
            return;
        }
        RemoteWrapper wrap = new RemoteWrapper((Remote)callback);
        HecFile file = id.getFile();
        if (file instanceof HecFileImpl) {
            ((HecFileImpl)file).removeCallBack(wrap);
        }
    }

    public void notify(String s) {
        System.out.println("notify:" + s);
    }

    public boolean checkModePermission(int permission) {
        return permission <= this._modePermission;
    }

    public int getModePermission() {
        return this._modePermission;
    }

    public void updateCurrentTime() {
        this._currentTime.setCurrent();
        this._currentTime.subtract(this._secondsZoneOffsetDifference);
        this._currentLabel.setText("Current: " + this._currentTime.dateAndTime(7));
    }

    public void setClientTimeZone(TimeZone tz) {
        this._displayOptionsChanged = true;
    }

    protected ScriptJPanel createScriptPanel() {
        if (this._scriptPanel != null) {
            return this._scriptPanel;
        }
        this._scriptPanel = new ScriptJPanel();
        this._scriptPanel.setPopupMenuEnabled(false);
        this._scriptPanel.setMaxButtonsPerColumn(5);
        this._scriptPanel.setSize(300, 300);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ClientApp.Workspace() == null) {
                    return;
                }
                if (!ClientMode.this._scriptPanel.isEnabled()) {
                    return;
                }
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    RmaJPopupMenu popup = new RmaJPopupMenu();
                    JMenuItem menuItem = new JMenuItem("Edit Script List");
                    menuItem.addActionListener((ActionListener)ClientMode.this._reflectMultiListener.add((Object)ClientMode.this, (Object)menuItem, "editScriptList"));
                    popup.add(menuItem);
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        };
        this._scriptPanel.addMouseListener(ma);
        this._scriptPanel.setLayout(new GridBagLayout());
        return this._scriptPanel;
    }

    public void editScriptList() {
        if (ClientApp.Workspace() == null) {
            return;
        }
        if (this._scriptPanel == null) {
            return;
        }
        ScriptManager sm = ClientApp.Workspace().getScriptManager();
        Vector allScripts = sm.getScriptIdsForMode(this.toString());
        Vector displayedScripts = new Vector(allScripts.size());
        for (int i = 0; i < allScripts.size(); ++i) {
            if (!((ScriptIdentifier)allScripts.get(i)).isDisplayedInSelector()) continue;
            displayedScripts.add(allScripts.get(i));
        }
        Component[] comps = this._scriptPanel.getComponents();
        Vector<ScriptIdentifier> selectedScripts = new Vector<ScriptIdentifier>(comps.length);
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof ScriptJButton)) continue;
            selectedScripts.add(((ScriptJButton)comps[i]).getScriptIdentifier());
        }
        MoverDialog mover = new MoverDialog((Frame)((Object)this._frame), true, "Edit Scripts");
        mover.setDescVisible(false);
        mover.setSelectedListLabel("Selected Scripts");
        mover.setAvailableListLabel("Available Scripts");
        mover.setData(displayedScripts, selectedScripts);
        mover.setVisible(true);
        if (mover.isCanceled()) {
            return;
        }
        Vector newScripts = mover.getSelectedObjectsVector();
        this._scriptPanel.setScriptIdentifiers(newScripts);
        this._frame.repaint();
        BufferedWriter writer = PreferencesManager.getBufferedWriter((int)0, (String)(RMAIO.userNameToFileName((String)this.toString()) + "Scripts"));
        if (writer != null) {
            try {
                HecAsciiSerializer ser = new HecAsciiSerializer(writer);
                ser.serializeObject((Object)newScripts);
                writer.close();
            }
            catch (Exception e) {
                System.out.println("editScriptList: Error saving Script List " + e);
            }
        }
    }

    protected void loadScripts() {
        if (this._scriptPanel == null) {
            return;
        }
        Vector selectedScripts = new Vector();
        BufferedReader reader = PreferencesManager.getBufferedReader((int)0, (String)(RMAIO.userNameToFileName((String)this.toString()) + "Scripts"));
        if (reader != null) {
            try {
                HecAsciiDeserializer ser = new HecAsciiDeserializer(reader);
                ser.deserializeObject(selectedScripts);
                reader.close();
                this._scriptPanel.setScriptIdentifiers(selectedScripts);
            }
            catch (Exception e) {
                System.out.println("loadScripts: Error loading Module's Script List " + e);
            }
        } else {
            this._scriptPanel.setScriptIdentifiers(null);
        }
    }

    public void managerInfo() {
        ManagerInfoDialog dialog = new ManagerInfoDialog((Frame)((Object)ClientApp.frame()), ClientApp.Workspace());
        dialog.setVisible(true);
    }

    public void refreshMode() {
    }

    protected String getPropsFileName() {
        return ClientApp.app().getAppType() + "/" + ClientApp.app().getAppType() + "." + this.toString() + "Module.properties";
    }

    protected String getPropsPrefix() {
        return ClientApp.app().getAppType() + "." + this.toString();
    }

    public DefaultJPanel[] getModuleOptionsPanels() {
        return null;
    }

    public void setClientUnitSystem(int unitSystem) {
        this._displayOptionsChanged = true;
    }

    public class ClientModePanel
    extends JPanel {
        @Override
        public void setEnabled(boolean b) {
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] == null) continue;
                if (comps[i] instanceof JScrollPane) {
                    Component c = ((JScrollPane)comps[i]).getViewport().getView();
                    if (!(c instanceof JComponent)) continue;
                    ((JComponent)comps[i]).setEnabled(b);
                    continue;
                }
                if (!(comps[i] instanceof JComponent)) continue;
                ((JComponent)comps[i]).setEnabled(b);
            }
            super.setEnabled(b);
        }
    }

    public class ToolBarPanel
    extends JPanel {
        Vector _toolBarItems = new Vector();

        @Override
        public void setEnabled(boolean b) {
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setEnabled(b);
            }
        }

        public void read(BufferedReader reader) {
            ToolBarButtonItem item;
            this._toolBarItems.clear();
            Component[] comps = this.getComponents();
            for (int i = comps.length - 1; i >= 0; --i) {
                if (!(comps[i] instanceof RmaJToolbarButton)) continue;
                this.remove(i);
            }
            if (reader == null) {
                return;
            }
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("ToolBarButtonItemBegin")) continue;
                    item = new ToolBarButtonItem();
                    item.read(reader);
                    this._toolBarItems.add(item);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ModelDrawingAttributeSet aset = null;
            MapPanel mapPanel = ClientMode.this._frame.getMapPanel();
            for (int i = 0; i < this._toolBarItems.size(); ++i) {
                ModeDrawingAttributeSet mdas;
                aset = null;
                item = (ToolBarButtonItem)this._toolBarItems.get(i);
                if (item.getGlyphId() == null) continue;
                Identifier glyphId = item.getGlyphId();
                MapGlyph glyph = mapPanel.findGlyphOfClass(glyphId.getClassName());
                if (item.getChildGlyphId() != null) {
                    glyphId = item.getChildGlyphId();
                    if (glyph != null) {
                        glyph = glyph.findGlyphOfClass(glyphId.getClassName());
                    }
                }
                if ((mdas = ModeDrawingAttributeSet.getModeAttributeSet((String)ClientMode.this.toString())) != null) {
                    aset = mdas.getModelAttributeSet(item.getName());
                }
                if (aset == null && glyph != null && item.getAttributeName() != null) {
                    aset = glyph.getAttributeSet();
                }
                RmaGlyphButtonInfo glyphInfo = new RmaGlyphButtonInfo(item.getUnselectedIconName(), item.getSelectedIconName(), glyphId.getClassName(), item.getAttributeName(), "Tool Tip Text");
                if (aset != null) {
                    glyphInfo.setAttributeSetName(aset.getName());
                } else if (item.getAttributeName() != null) {
                    glyphInfo.setAttributeSetName(item.getName());
                }
                glyphInfo.setToolTip(item.getToolTipText());
                ClientMode.this.addToolBarButton(glyphInfo);
            }
        }
    }

    public class RetrieveStatus {
        public StringBuffer message = new StringBuffer();
        public boolean seriousError = false;
        public int numberDataSetsRead = 0;
        public int numberDataSetsRequested = 0;
    }

    protected class ManagerReopenMenu
    extends JMenu {
        private List<Identifier> _openedIdentifiers;
        private int _numberOfItems;
        private boolean _loaded;
        private String _propsPrefix;
        private String _path;
        private String _managerType;

        public ManagerReopenMenu(String label, int numberOfItems, String managerType) {
            super(label);
            this._openedIdentifiers = new ArrayList<Identifier>();
            this._numberOfItems = 5;
            this._loaded = false;
            this._propsPrefix = null;
            this._path = null;
            this._managerType = managerType;
            if (numberOfItems > 0) {
                this._numberOfItems = numberOfItems;
            }
        }

        public void setWorkspacePath(String path) {
            this._path = path;
        }

        public void setPropsPrefix(String prefix) {
            this._propsPrefix = prefix;
        }

        private void rebuildReopenMenu() {
            this.removeAll();
            for (int i = 0; i < this._openedIdentifiers.size(); ++i) {
                Identifier id = this._openedIdentifiers.get(i);
                String[] rssPathParts = id.getPath().split("/rss");
                String[] prmPathParts = id.getPath().split("/resprm");
                String idrssPath = rssPathParts[0];
                String idprmPath = prmPathParts[0];
                if (!this._path.equals(idrssPath) && !this._path.equals(idprmPath)) continue;
                final ManagerProxy proxy = ClientApp.Workspace().getManagerProxy("rss", id);
                final Identifier fId = id;
                JMenuItem menuItem = new JMenuItem(id.getName()){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        if (fId != null) {
                            String desc = "";
                            if (proxy != null) {
                                desc = proxy.getDescription();
                            }
                            String txt = "<html><b>" + ManagerReopenMenu.this._managerType + " Name:</b> " + fId.getName() + "<br><b>" + ManagerReopenMenu.this._managerType + " File:</b> " + fId.getPath() + "<br><b>Description:</b> " + desc + "<br><b>Last Modified On:</b> " + new Date(fId.lastModified());
                            return txt;
                        }
                        return super.getToolTipText(e);
                    }
                };
                menuItem.setActionCommand("reopen");
                menuItem.addActionListener(ClientMode.this);
                menuItem.setName(id.getPath());
                menuItem.setToolTipText(id.getPath());
                this.add(menuItem);
            }
            this.setVisible(this._openedIdentifiers.size() > 0);
            this._loaded = true;
        }

        public Properties loadMenus() {
            MenuLoader loader = new MenuLoader();
            if (SwingUtilities.isEventDispatchThread()) {
                loader.run();
                return loader.properties;
            }
            try {
                SwingUtilities.invokeAndWait(loader);
                return loader.properties;
            }
            catch (InterruptedException e) {
                System.out.println("loadMenus:InterruptedException occurred " + e);
            }
            catch (InvocationTargetException e) {
                System.out.println("loadMenus:invocation exception loading menus " + e.getCause());
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("loadMenus:exception loading menus " + e);
                e.printStackTrace();
            }
            return null;
        }

        public Properties saveMenus() {
            Properties props = new Properties();
            return this.saveMenus(props);
        }

        public Properties saveMenus(Properties props) {
            if (!this._loaded) {
                return props;
            }
            Object prefix = ClientMode.this.getPropsPrefix();
            if (this._propsPrefix != null) {
                prefix = (String)prefix + this._propsPrefix;
            }
            for (int i = 0; i < this._openedIdentifiers.size(); ++i) {
                Identifier id = this._openedIdentifiers.get(i);
                props.setProperty((String)prefix + ".reopenMenu" + i + ".label", id.getName());
                props.setProperty((String)prefix + ".reopenMenu" + i + ".path", id.getPath());
            }
            props.setProperty((String)prefix + ".reopenMenu.count", String.valueOf(this._openedIdentifiers.size()));
            PreferencesManager.setProperties((int)0, (String)ClientMode.this.getPropsFileName(), (Properties)props, (String)(ClientApp.app().getAppType() + " " + ClientMode.this.toString() + " Module properties"));
            return props;
        }

        public void addMenuItem(Identifier id) {
            if (id == null) {
                return;
            }
            if (this._openedIdentifiers.contains(id)) {
                this._openedIdentifiers.remove(id);
            }
            this._openedIdentifiers.add(0, id);
            while (this._openedIdentifiers.size() > this._numberOfItems) {
                this._openedIdentifiers.remove(this._openedIdentifiers.size() - 1);
            }
            this.rebuildReopenMenu();
        }

        public void deleteMenuItem(Identifier id) {
            if (id == null) {
                return;
            }
            if (this._openedIdentifiers.remove(id)) {
                this.rebuildReopenMenu();
            }
        }

        private class MenuLoader
        implements Runnable {
            Properties properties;

            private MenuLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String cntStr;
                    ManagerReopenMenu.this._openedIdentifiers.clear();
                    System.out.println("MenuLoader.run:props file name = " + ClientMode.this.getPropsFileName());
                    Properties props = PreferencesManager.getProperties((int)0, (String)ClientMode.this.getPropsFileName());
                    if (props == null) {
                        this.properties = null;
                        return;
                    }
                    Object prefix = ClientMode.this.getPropsPrefix();
                    if (ManagerReopenMenu.this._propsPrefix != null) {
                        prefix = (String)prefix + ManagerReopenMenu.this._propsPrefix;
                    }
                    if ((cntStr = props.getProperty((String)prefix + ".reopenMenu.count")) == null) {
                        this.properties = props;
                        return;
                    }
                    int cnt = RMAIO.parseInt((String)cntStr, (int)-1);
                    RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                    for (int i = 0; i < cnt; ++i) {
                        String label = props.getProperty((String)prefix + ".reopenMenu" + i + ".label");
                        String path = props.getProperty((String)prefix + ".reopenMenu" + i + ".path");
                        if (label == null || path == null) continue;
                        Identifier id = new Identifier(path);
                        id.setName(label);
                        Identifier openId = null;
                        try {
                            openId = fm.openFile(UserId.getUserId(), id);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        if (openId != null) {
                            ManagerReopenMenu.this._openedIdentifiers.add(openId);
                            continue;
                        }
                        ManagerReopenMenu.this._openedIdentifiers.add(id);
                    }
                    ManagerReopenMenu.this._loaded = true;
                    this.properties = props;
                }
                finally {
                    ManagerReopenMenu.this.rebuildReopenMenu();
                }
            }
        }
    }
}

