/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.DSSPropertiesPanel;
import hec.lang.UserId;
import hec.map.transform.CoordinateInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;
import rma.util.JarInfo;
import rma.util.RMAIO;

public class ClientPropertiesJDialog
extends RmaJDialog {
    Insets insets = new Insets(5, 5, 0, 0);
    private JLabel _portNumber;
    private JLabel _userId;
    private JLabel _clientUrl;
    private JLabel _wkspName;
    private JLabel _wkspPath;
    private JLabel _wkspUnits;
    private JLabel _wkspTimezone;
    private JLabel _wkspMoneyUnits;
    private JLabel _wkspCoordinateSys;
    private JLabel _loginUrl;
    private JLabel _appUrl;
    private JLabel _fileMgrUrl;
    private JLabel _baseDir;
    private JLabel _mode;
    private JLabel _loginName;
    private JLabel _preferenceDir;
    private RmaJList properties;
    private JButton editButton;
    private JButton delButton;
    private RmaJList _wkspUsers;
    private boolean networked = false;
    private JLabel _clientJavaVersion;
    private JLabel _serverJavaVersion;
    private JPanel _clientPanel;
    private JPanel _userPanel;
    private JPanel _watershedPanel;
    private JPanel _serverPanel;
    private DSSPropertiesPanel _dssPanel;
    private JTabbedPane _tabbedPane;
    private JPanel _sysPropsPanel;
    private JList _clientJarsList;
    private JList _serverJarsList;
    private JLabel _clientTimeZone;
    private JLabel _serverTimeZone;
    private JButton _browseWkspBtn;

    public ClientPropertiesJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        Insets panelInsets = new Insets(5, 5, 0, 5);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(500, 550);
        this.setLocation();
        this.setTitle("Application Properties");
        this.setOKButtonSearchString("Close");
        this.registerEnterKey(true);
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        gbc.insets = panelInsets;
        this.getContentPane().add((Component)this._tabbedPane, gbc);
        this._watershedPanel = this.getWkspInfoPanel();
        this._tabbedPane.addTab("Watershed", this._watershedPanel);
        this._userPanel = this.getUserInfoPanel();
        this._tabbedPane.addTab("User", this._userPanel);
        this._clientPanel = this.getClientInfoPanel();
        this._tabbedPane.addTab("Client", this._clientPanel);
        this._serverPanel = this.getServerInfoPanel();
        this._tabbedPane.addTab("Server", this._serverPanel);
        this._sysPropsPanel = this.getJavaInfoPanel();
        this._tabbedPane.addTab("System Properties", this._sysPropsPanel);
        this._dssPanel = new DSSPropertiesPanel();
        this._tabbedPane.addTab("DSS Info", (Component)((Object)this._dssPanel));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)buttonPanel, gbc);
        JButton saveButton = new JButton("Save...");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        buttonPanel.add((Component)saveButton, gbc);
        JButton printButton = new JButton("Print...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        buttonPanel.add((Component)printButton, gbc);
        JButton closeButton = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        buttonPanel.add((Component)closeButton, gbc);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientPropertiesJDialog.this.setVisible(false);
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientPropertiesJDialog.this.savePropertiesAction();
            }
        });
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientPropertiesJDialog.this.printPropertiesAction();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printPropertiesAction() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            File f = File.createTempFile("props", ".txt");
            f.deleteOnExit();
            this.savePropertiesAction(f);
            JTextArea textArea = new JTextArea();
            textArea.setFont(new Font("Dialog", 0, 10));
            BufferedReader reader = new BufferedReader(new FileReader(f));
            textArea.read(reader, "");
            String str_footer = "Page {0,number}";
            MessageFormat footer = new MessageFormat(str_footer);
            textArea.print(null, footer);
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            e.printStackTrace();
        }
        catch (PrinterException e) {
            System.out.println("PrinterException " + e);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void savePropertiesAction() {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        int opt = chooser.showSaveDialog((Component)((Object)this));
        if (opt != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f.exists() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "File " + f.getAbsolutePath() + " already exists.\nOverwrite?", "File Exists", 0)) != 0) {
            return;
        }
        this.savePropertiesAction(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePropertiesAction(File f) {
        BufferedWriter writer;
        try {
            writer = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException e) {
            System.out.println("savePropertiesAction:IOException " + e);
            return;
        }
        try {
            writer.write("Application Properties for " + ClientApp.frame().getAppTitle());
            writer.newLine();
            writer.write("Date:" + new Date().toString());
            writer.newLine();
            writer.newLine();
            this.savePanel(writer, this._clientPanel);
            this.savePanel(writer, this._userPanel);
            this.savePanel(writer, this._watershedPanel);
            this.savePanel(writer, this._serverPanel);
            this.savePanel(writer, this._sysPropsPanel);
            this.savePanel(writer, (JPanel)((Object)this._dssPanel));
        }
        catch (IOException ioe) {
            System.out.println("savePropertiesAction:error writing " + ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void savePanel(BufferedWriter writer, JPanel panel) throws IOException {
        int i;
        int idx = this._tabbedPane.indexOfComponent(panel);
        String title = this._tabbedPane.getTitleAt(idx);
        writer.write(title + " Properties");
        writer.newLine();
        Component[] comps = panel.getComponents();
        boolean foundLabel = false;
        for (i = 0; i < comps.length; ++i) {
            JLabel label;
            if (!(comps[i] instanceof JLabel) || (label = (JLabel)comps[i]).getLabelFor() == null) continue;
            Component labelFor = label.getLabelFor();
            writer.write("\t");
            writer.write(label.getText());
            if (labelFor instanceof JLabel) {
                foundLabel = true;
                label = (JLabel)labelFor;
                writer.write(label.getText());
                writer.newLine();
                continue;
            }
            if (!(labelFor instanceof JList)) continue;
            JList list = (JList)labelFor;
            ListModel model = list.getModel();
            for (int m = 0; m < model.getSize(); ++m) {
                Object obj = model.getElementAt(m);
                if (obj == null) continue;
                if (m > 0) {
                    writer.write("\t\t\t");
                }
                writer.write(obj.toString());
                writer.newLine();
            }
        }
        if (!foundLabel) {
            for (i = 0; i < comps.length; ++i) {
                JScrollPane sp;
                Component comp;
                if (!(comps[i] instanceof JScrollPane) || !((comp = (sp = (JScrollPane)comps[i]).getViewport().getView()) instanceof JList)) continue;
                JList list = (JList)comp;
                ListModel model = list.getModel();
                for (int m = 0; m < model.getSize(); ++m) {
                    Object obj = model.getElementAt(m);
                    if (obj == null) continue;
                    writer.write("\t");
                    writer.write(obj.toString());
                    writer.newLine();
                }
            }
        }
    }

    public void clearForm() {
        super.clearForm();
        this._portNumber.setText("");
        this._userId.setText("");
        this._clientUrl.setText("");
        this._wkspName.setText("");
        this._wkspPath.setText("");
        this._browseWkspBtn.setEnabled(false);
        this._wkspUnits.setText("");
        this._wkspTimezone.setText("");
        this._wkspMoneyUnits.setText("");
        this._loginUrl.setText("");
        this._appUrl.setText("");
        this._fileMgrUrl.setText("");
        this._baseDir.setText("");
        this._clientTimeZone.setText("");
        this._mode.setText("");
        this._loginName.setText("");
        this._preferenceDir.setText("");
        this._wkspCoordinateSys.setText("");
        this._clientJavaVersion.setText("");
        this._dssPanel.clearForm();
        ((RmaListModel)this._wkspUsers.getModel()).removeAllElements();
        ((RmaListModel)this._clientJarsList.getModel()).removeAllElements();
        ((RmaListModel)this._serverJarsList.getModel()).removeAllElements();
    }

    public void fillForm(ClientApp app) {
        this.clearForm();
        if (app == null) {
            return;
        }
        this._mode.setText(app.networked ? "Networked" : "Local");
        this.networked = app.networked;
        String userId = UserId.getUserId();
        String appUser = app.getUser();
        this._userId.setText(app.getUser());
        this._userId.setToolTipText(userId);
        this._baseDir.setText(app.getAppStartDir());
        TimeZone tz = ClientApp.app().getClientTimeZone();
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        Date dt = new Date();
        boolean inDayLightSavings = tz.inDaylightTime(dt);
        this._clientTimeZone.setText(tz.getDisplayName(inDayLightSavings, 0, Locale.getDefault()));
        if (ClientApp.Workspace() != null) {
            this._wkspName.setText(ClientApp.Workspace().getTitleName());
            this._wkspPath.setText(ClientApp.Workspace().getWorkspacePath());
            this._wkspPath.setToolTipText(this._wkspPath.getText());
            this._browseWkspBtn.setEnabled(true);
            int unitSys = ClientApp.Workspace().getUnitSystem();
            if (unitSys == 1) {
                this._wkspUnits.setText("English");
            } else if (unitSys == 2) {
                this._wkspUnits.setText("SI");
            } else {
                this._wkspUnits.setText("Not Defined");
            }
            int offset = ClientApp.Workspace().getGmtOffset();
            this._wkspTimezone.setText("GMT " + offset + ":00");
            try {
                Vector v = ClientApp.Workspace().getData().getUsers();
                if (v != null) {
                    ((RmaListModel)this._wkspUsers.getModel()).addAll((Collection)v);
                }
            }
            catch (RemoteException re) {
                System.out.println("fillForm: RMI Error getting list of users " + re);
            }
            CoordinateInfo ci = ClientApp.Workspace().getCoordSys();
            if (ci != null) {
                this._wkspCoordinateSys.setText(ci.getType());
            }
        } else {
            this._browseWkspBtn.setEnabled(false);
            this._wkspName.setText("No Watershed Opened");
            this._wkspPath.setText("N/A");
            this._wkspUnits.setText("N/A");
            this._wkspTimezone.setText("N/A");
            this._wkspMoneyUnits.setText("N/A");
            this._wkspPath.setToolTipText("Not Applicable with no watershed");
        }
        this._preferenceDir.setText(PreferencesManager.getDirectoryForLocation((int)1));
        this._loginName.setText(app.getUserName());
        this._clientJavaVersion.setText(System.getProperty("java.version"));
        if (app.networked) {
            this._portNumber.setText("" + app.getRmiPort());
            this._loginUrl.setText(app.getLoginServerUrl());
            this._appUrl.setText(app.getAppServerUrl());
            String appUrlStr = this._appUrl.getText();
            Object fmUrl = appUrlStr.substring(0, appUrlStr.lastIndexOf(47) + 1);
            fmUrl = (String)fmUrl + "FileManager";
            this._fileMgrUrl.setText((String)fmUrl);
            String ver = ClientApp.app().getServerProperty("java.version");
            this._serverJavaVersion.setText(ver);
            try {
                tz = ClientApp.app().getAppServer().getTimeZone();
            }
            catch (RemoteException e) {
                System.out.println("RemoteException " + e);
                e.printStackTrace();
            }
            if (tz != null) {
                inDayLightSavings = tz.inDaylightTime(dt);
                this._serverTimeZone.setText(tz.getDisplayName(inDayLightSavings, 0, Locale.getDefault()));
            }
        } else {
            this._clientUrl.setText("N/A");
            this._clientUrl.setToolTipText("Not Applicable in Local Mode");
            this._portNumber.setText("N/A");
            this._portNumber.setToolTipText("Not Applicable in Local Mode");
            this._loginUrl.setText("N/A");
            this._loginUrl.setToolTipText("Not Applicable in Local Mode");
            this._appUrl.setText("N/A");
            this._appUrl.setToolTipText("Not Applicable in Local Mode");
            this._fileMgrUrl.setText("N/A");
            this._fileMgrUrl.setToolTipText("Not Applicable in Local Mode");
            this._serverJavaVersion.setText("N/A");
            this._serverJavaVersion.setToolTipText("Not Applicable in Local Mode");
            ((RmaListModel)this._serverJarsList.getModel()).addElement((Object)"N/A");
            this._serverTimeZone.setText("N/A");
            this._serverTimeZone.setToolTipText("Not Applicable in Local Mode");
        }
        this.fillProperties();
        this.fillClientJarVersions();
        this._dssPanel.fillPanel();
        this.pack();
    }

    void fillClientJarVersions() {
        String classpath = System.getProperty("java.class.path");
        StringTokenizer token = new StringTokenizer(classpath, File.pathSeparator);
        RmaListModel newModel = new RmaListModel(true);
        while (token.hasMoreTokens()) {
            String path = token.nextToken();
            String jarName = RMAIO.getFileFromPath((String)path);
            JarInfo jarInfo = new JarInfo(jarName, path, "", "");
            if (jarInfo == null || jarInfo.jarVersion == null || jarInfo.jarVersion.length() == 0 || "unknown".equalsIgnoreCase(jarInfo.jarVersion)) continue;
            newModel.addElement((Object)(jarName + ":" + jarInfo.jarVersion));
        }
        this._clientJarsList.setModel(newModel);
    }

    void fillProperties() {
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        RmaListModel model = (RmaListModel)this.properties.getModel();
        model.clear();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String prop = props.getProperty(key);
            model.addElement((Object)(key + "=" + prop));
        }
        this.editButton.setEnabled(false);
        this.delButton.setEnabled(false);
    }

    private JPanel getClientInfoPanel() {
        JPanel clientInfo = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Port: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        clientInfo.add((Component)label, gbc);
        this._portNumber = new JLabel();
        label.setLabelFor(this._portNumber);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        clientInfo.add((Component)this._portNumber, gbc);
        label = new JLabel("Base Directory: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        clientInfo.add((Component)label, gbc);
        this._baseDir = new JLabel();
        label.setLabelFor(this._baseDir);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        clientInfo.add((Component)this._baseDir, gbc);
        label = new JLabel("Mode: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        clientInfo.add((Component)label, gbc);
        this._mode = new JLabel();
        label.setLabelFor(this._mode);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        clientInfo.add((Component)this._mode, gbc);
        label = new JLabel("Client URL: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        clientInfo.add((Component)label, gbc);
        this._clientUrl = new JLabel();
        label.setLabelFor(this._clientUrl);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = this.insets;
        clientInfo.add((Component)this._clientUrl, gbc);
        label = new JLabel("TimeZone:");
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        clientInfo.add((Component)label, gbc);
        this._clientTimeZone = new JLabel();
        label.setLabelFor(this._clientTimeZone);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        clientInfo.add((Component)this._clientTimeZone, gbc);
        label = new JLabel("Java Version: ");
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        clientInfo.add((Component)label, gbc);
        this._clientJavaVersion = new JLabel();
        label.setLabelFor(this._clientJavaVersion);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        clientInfo.add((Component)this._clientJavaVersion, gbc);
        label = new JLabel("Jar Versions: ");
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        clientInfo.add((Component)label, gbc);
        this._clientJarsList = new JList(new RmaListModel(true));
        label.setLabelFor(this._clientJarsList);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.weighty = 0.1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        clientInfo.add((Component)new JScrollPane(this._clientJarsList), gbc);
        return clientInfo;
    }

    private JPanel getWkspInfoPanel() {
        JPanel wkspInfo = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Watershed Name: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspName = new JLabel();
        label.setLabelFor(this._wkspName);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)this._wkspName, gbc);
        label = new JLabel("Watershed Path: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspPath = new JLabel();
        label.setLabelFor(this._wkspPath);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)this._wkspPath, gbc);
        this._browseWkspBtn = new JButton("...");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 5);
        wkspInfo.add((Component)this._browseWkspBtn, gbc);
        label = new JLabel("Watershed Units: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspUnits = new JLabel();
        label.setLabelFor(this._wkspUnits);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)this._wkspUnits, gbc);
        label = new JLabel("Watershed Timezone: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspTimezone = new JLabel();
        label.setLabelFor(this._wkspTimezone);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)this._wkspTimezone, gbc);
        label = new JLabel("Watershed Monetary Units: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspMoneyUnits = new JLabel();
        label.setLabelFor(this._wkspMoneyUnits);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)this._wkspMoneyUnits, gbc);
        label = new JLabel("Watershed Coordinate System: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspCoordinateSys = new JLabel();
        label.setLabelFor(this._wkspCoordinateSys);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)this._wkspCoordinateSys, gbc);
        label = new JLabel("Current Watershed Users:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        wkspInfo.add((Component)label, gbc);
        this._wkspUsers = new RmaJList((ListModel)new RmaListModel(true)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                d.width = 200;
                return d;
            }
        };
        label.setLabelFor((Component)this._wkspUsers);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 10, 10);
        wkspInfo.add((Component)new JScrollPane((Component)this._wkspUsers), gbc);
        this._browseWkspBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientPropertiesJDialog.this.browseWkspFolder();
            }
        });
        return wkspInfo;
    }

    protected void browseWkspFolder() {
        if (ClientApp.app().isNetworked()) {
            return;
        }
        File f = new File(this._wkspPath.getText());
        try {
            Runtime.getRuntime().exec("explorer.exe " + f.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("browseWkspFolder:Exception " + e);
        }
    }

    private JPanel getServerInfoPanel() {
        JPanel serverInfo = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("App Server URL: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        serverInfo.add((Component)label, gbc);
        this._appUrl = new JLabel();
        label.setLabelFor(this._appUrl);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        serverInfo.add((Component)this._appUrl, gbc);
        label = new JLabel("FileManager URL: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        serverInfo.add((Component)label, gbc);
        this._fileMgrUrl = new JLabel();
        label.setLabelFor(this._fileMgrUrl);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        serverInfo.add((Component)this._fileMgrUrl, gbc);
        label = new JLabel("LoginServer URL: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        serverInfo.add((Component)label, gbc);
        this._loginUrl = new JLabel();
        label.setLabelFor(this._loginUrl);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = this.insets;
        serverInfo.add((Component)this._loginUrl, gbc);
        label = new JLabel("TimeZone:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        serverInfo.add((Component)label, gbc);
        this._serverTimeZone = new JLabel();
        label.setLabelFor(this._serverTimeZone);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = this.insets;
        serverInfo.add((Component)this._serverTimeZone, gbc);
        label = new JLabel("Server Java Version: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        serverInfo.add((Component)label, gbc);
        this._serverJavaVersion = new JLabel();
        label.setLabelFor(this._serverJavaVersion);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = this.insets;
        serverInfo.add((Component)this._serverJavaVersion, gbc);
        label = new JLabel("Jar Versions: ");
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        serverInfo.add((Component)label, gbc);
        this._serverJarsList = new JList(new RmaListModel(true));
        label.setLabelFor(this._serverJarsList);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 0.1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        serverInfo.add((Component)new JScrollPane(this._serverJarsList), gbc);
        return serverInfo;
    }

    private JPanel getJavaInfoPanel() {
        JPanel javaInfo = new JPanel(new GridBagLayout());
        this.properties = new RmaJList((ListModel)new RmaListModel(true)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 100;
                d.height = 100;
                return d;
            }
        };
        this.properties.setSelectionMode(0);
        this.properties.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int idx = ClientPropertiesJDialog.this.properties.getSelectedIndex();
                boolean enabled = false;
                if (idx > -1) {
                    enabled = !ClientPropertiesJDialog.this.isSystemProperty((String)ClientPropertiesJDialog.this.properties.getSelectedValue());
                }
                ClientPropertiesJDialog.this.editButton.setEnabled(enabled);
                ClientPropertiesJDialog.this.delButton.setEnabled(enabled);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        JScrollPane sp = new JScrollPane((Component)this.properties);
        javaInfo.add((Component)sp, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        javaInfo.add((Component)buttonPanel, gbc);
        JButton newButton = new JButton("New ...");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 0);
        buttonPanel.add((Component)newButton, gbc);
        this.editButton = new JButton("Edit ...");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 0);
        buttonPanel.add((Component)this.editButton, gbc);
        this.delButton = new JButton("Delete");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 0);
        buttonPanel.add((Component)this.delButton, gbc);
        String permStr = ClientApp.app().getAppPermissionString();
        if (permStr != null && permStr.length() > 0 && HecSecurityManager.getSecurityManager().checkPermission(permStr, "configure") >= 4) {
            ReflectMultiListener listener = new ReflectMultiListener();
            newButton.addActionListener((ActionListener)listener.add((Object)this, (Object)newButton, "newProperty"));
            this.editButton.addActionListener((ActionListener)listener.add((Object)this, (Object)this.editButton, "editProperty"));
            this.delButton.addActionListener((ActionListener)listener.add((Object)this, (Object)this.delButton, "deleteProperty"));
        } else {
            newButton.setVisible(false);
            this.editButton.setVisible(false);
            this.delButton.setVisible(false);
        }
        return javaInfo;
    }

    public void newProperty() {
        PropDialog dialog = new PropDialog();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        String propName = dialog.getPropertyName();
        String propValue = dialog.getPropertyValue();
        System.setProperty(propName, propValue);
        this.fillProperties();
        this.properties.setSelectedValue((Object)(propName + "=" + propValue), true);
    }

    public void editProperty() {
        String property = (String)this.properties.getSelectedValue();
        if (property == null) {
            return;
        }
        PropDialog dialog = new PropDialog();
        String propName = RMAIO.getType((String)property, (String)"=");
        String propValue = RMAIO.getParam((String)property, (String)"=");
        if (this.isSystemProperty(propName)) {
            return;
        }
        dialog.fillForm(propName, propValue);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        System.setProperty(dialog.getPropertyName(), dialog.getPropertyValue());
        int idx = this.properties.getSelectedIndex();
        this.fillProperties();
        this.properties.setSelectedIndex(idx);
    }

    public void deleteProperty() {
        String property = (String)this.properties.getSelectedValue();
        if (property == null) {
            return;
        }
        String prop = RMAIO.getType((String)property, (String)"=");
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete the propery " + prop, "Confirm Property Delete", 0);
        if (opt == 0) {
            int idx = this.properties.getSelectedIndex();
            System.getProperties().remove(prop);
            this.fillProperties();
            if (idx < this.properties.getModel().getSize()) {
                this.properties.setSelectedIndex(idx);
            }
        }
    }

    boolean isSystemProperty(String propName) {
        if (propName == null) {
            return false;
        }
        return propName.startsWith("user.") || propName.startsWith("java.") || propName.startsWith("sun.") || propName.startsWith("os.") || propName.startsWith("file.") || propName.startsWith("line.") || propName.startsWith("awt.") || propName.startsWith("path.");
    }

    private JPanel getUserInfoPanel() {
        JPanel userInfo = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("User ID: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        userInfo.add((Component)label, gbc);
        this._userId = new JLabel();
        label.setLabelFor(this._userId);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        userInfo.add((Component)this._userId, gbc);
        label = new JLabel("Login: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        userInfo.add((Component)label, gbc);
        this._loginName = new JLabel();
        label.setLabelFor(this._loginName);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        userInfo.add((Component)this._loginName, gbc);
        label = new JLabel("User Preference Directory: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = this.insets;
        userInfo.add((Component)label, gbc);
        this._preferenceDir = new JLabel();
        label.setLabelFor(this._preferenceDir);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        userInfo.add((Component)this._preferenceDir, gbc);
        return userInfo;
    }

    public class PropDialog
    extends RmaJDialog {
        RmaJTextField propertyName;
        RmaJTextField propertyValue;
        boolean _canceled;

        public PropDialog() {
            super((Dialog)((Object)ClientPropertiesJDialog.this), true);
            this.getContentPane().setLayout(new GridBagLayout());
            JLabel label = new JLabel("Property:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = ClientPropertiesJDialog.this.insets;
            this.getContentPane().add((Component)label, gbc);
            this.propertyName = new RmaJTextField(30);
            this.propertyName.setTrimWhiteSpace(true);
            this.propertyName.setEmptyOk(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = ClientPropertiesJDialog.this.insets;
            this.getContentPane().add((Component)this.propertyName, gbc);
            label = new JLabel("Property Value:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = ClientPropertiesJDialog.this.insets;
            this.getContentPane().add((Component)label, gbc);
            this.propertyValue = new RmaJTextField(30);
            this.propertyValue.setTrimWhiteSpace(true);
            this.propertyName.setEmptyOk(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = ClientPropertiesJDialog.this.insets;
            this.getContentPane().add((Component)this.propertyValue, gbc);
            ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 16;
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.insets = ClientPropertiesJDialog.this.insets;
            this.getContentPane().add((Component)cmdPanel, gbc);
            cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                public void buttonCmdActionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 8: {
                            PropDialog.this._canceled = false;
                            PropDialog.this.setVisible(false);
                            break;
                        }
                        case 4: {
                            PropDialog.this._canceled = true;
                            PropDialog.this.setVisible(false);
                        }
                    }
                }
            });
            this.setTitle("New System Property");
            this.pack();
            this.setLocation();
            this.setResizable(false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PropDialog.this._canceled = true;
                    PropDialog.this.setVisible(false);
                }
            });
        }

        public boolean isCanceled() {
            return this._canceled;
        }

        public String getPropertyName() {
            return this.propertyName.getText();
        }

        public String getPropertyValue() {
            return this.propertyValue.getText();
        }

        public void fillForm(String name, String value) {
            this.propertyName.setText(name);
            this.propertyValue.setText(value);
            this.setTitle("Edit System Property");
        }
    }
}

