/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.LogPrintStream;
import hec.lang.UserId;
import hec.model.JobTask;
import hec.model.SchedulableJob;
import hec.model.Scheduler;
import hec.script.ClientScriptJobTask;
import hec.script.ScriptJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.util.RMAIO;

public class ClientScheduler
implements Scheduler {
    protected RMIScheduler _rmiScheduler;
    private String _name = "Scheduler";
    private String _logdir = null;
    private Vector _listenerList = new Vector();
    private LogPrintStream _logFileStream;
    private PrintStream _log;
    private Date _date = new Date();
    private Timer _timer = new Timer(true);
    private Vector _currentTasks = new Vector();
    private Identifier _stateId = null;
    private boolean _isModified = false;
    private int _tzOffset;

    public ClientScheduler() {
        this.openLog();
        this.logMessage(this._name + " started");
        if (RMAIO.getJavaVersion() >= 2) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ClientScheduler.this.writeJobs(ClientScheduler.this._stateId);
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            RmiApp rmiApp = ClientApp.app().getAppServer();
            this._rmiScheduler = rmiApp.getScheduler();
            if (this._rmiScheduler == null) {
                this.logMessage("init: failed to get RMIScheduler from RmiApp");
            }
        }
        catch (RemoteException re) {
            this.logMessage("init: Error getting RmiScheduler " + re);
        }
        this._tzOffset = TimeZone.getDefault().getRawOffset() / 3600000;
        this.logMessage("init: system TimeZone offset is " + this._tzOffset + " hours");
        try {
            RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            RmiApp rmiApp = ClientApp.app().getAppServer();
            String cwmsHome = rmiApp.getServerProperty("CWMS_HOME");
            if (cwmsHome == null) {
                return;
            }
            Object path = cwmsHome;
            String userId = ClientApp.app().getUser();
            userId = RMAIO.userNameFromUserId((String)userId);
            String dir = System.getProperty("schedulerEntries.directory", "dated/scheduler/");
            path = (String)path + "/" + dir + userId + this._name + ".entries";
            Identifier id = new Identifier((String)path);
            this._stateId = fm.openFile(UserId.getUserId(), id);
            if (this._stateId == null) {
                this._stateId = fm.newFile(UserId.getUserId(), id);
            } else {
                this.readJobs(this._stateId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean scheduleTask(JobTask task, long startMillis, int tzOffset) {
        boolean added = false;
        if (task == null || task.getJob() == null) {
            return added;
        }
        SchedulableJob job = task.getJob();
        if (job == null) {
            return added;
        }
        added = true;
        int tzDiff = tzOffset - this._tzOffset;
        this.logMessage("scheduleTask: " + task.getName() + " tzoffset=" + tzOffset);
        SimpleTimeZone tz = new SimpleTimeZone(tzDiff * 3600000, "foo");
        GregorianCalendar cal = new GregorianCalendar(tz);
        Date startDate = new Date(startMillis += (long)(tzDiff * 3600000));
        cal.setTime(startDate);
        cal.setTimeZone(tz);
        startDate = cal.getTime();
        task.setParent((Scheduler)this);
        if (job.isRecurring()) {
            this._timer.scheduleAtFixedRate((TimerTask)task, startDate, job.getPeriod());
            this.logMessage("scheduleTask: scheduled recurring job " + task.getName() + " for " + startDate + " interval " + job.getIntervalString() + "(" + job.getPeriod() + " ms) tz diff=" + tzDiff);
        } else {
            this._timer.schedule((TimerTask)task, startDate);
            this.logMessage("scheduleTask: scheduled job " + task.getName() + " for " + startDate + " tz diff=" + tzDiff);
        }
        return added;
    }

    protected boolean scheduleTask(JobTask task) {
        boolean added = false;
        if (task == null || task.getJob() == null) {
            return added;
        }
        SchedulableJob job = task.getJob();
        if (job == null) {
            return added;
        }
        this.logMessage("scheduleTask: job=" + task.getName() + " jobTime=" + job.getStartDate());
        return this.scheduleTask(task, job.getStartDate().getTime(), task.getJob().getTimezoneOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleJob(SchedulableJob job, boolean remote) {
        boolean added = false;
        if (job == null) {
            this.logMessage("scheduleJob: recieved null job");
            return added;
        }
        if (!job.isValid()) {
            this.logMessage("scheduleJob: WARNING recieved invalid job" + job);
            return added;
        }
        if (remote) {
            try {
                if (this._rmiScheduler != null) {
                    return this._rmiScheduler.scheduleJob(job);
                }
                this.logMessage("scheduleTask: null RMIScheduler");
                return false;
            }
            catch (RemoteException re) {
                this.logMessage("scheduleTask: Error scheduling remote job " + job.getName() + " error " + re);
                return false;
            }
        }
        ClientScriptJobTask task = null;
        if (job instanceof ScriptJob) {
            task = new ClientScriptJobTask((ScriptJob)job);
            added = this.scheduleTask((JobTask)task);
        } else {
            this.logMessage("scheduleJob: received job of unsupported type " + job.getClass());
        }
        if (added) {
            Vector vector = this._currentTasks;
            synchronized (vector) {
                this._currentTasks.addElement(task);
            }
            this.writeJobs(this._stateId);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteJob(String jobName) {
        boolean deleted = false;
        if (jobName == null || jobName.length() < 1) {
            this.logMessage("deleteJob: recieved null or empty jobname to delete");
            return deleted;
        }
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                JobTask jobTask = (JobTask)this._currentTasks.elementAt(i);
                if (!jobTask.getName().equals(jobName)) continue;
                jobTask.cancel();
                this._currentTasks.remove(jobTask);
                this.logMessage("deleteJob: removed job " + jobName);
                deleted = true;
                break;
            }
            if (deleted) {
                this.writeJobs(this._stateId);
            }
        }
        if (!deleted) {
            try {
                if (this._rmiScheduler == null) {
                    this.logMessage("deleteJob: null RMIScheduler");
                    return false;
                }
                deleted = this._rmiScheduler.deleteJob(jobName);
            }
            catch (RemoteException re) {
                this.logMessage("deleteJob: error trying to delete job " + jobName + " with RMIScheduler " + re);
            }
        }
        return deleted;
    }

    public Vector jobsStatus() {
        Vector v = (Vector)this._currentTasks.clone();
        try {
            if (this._rmiScheduler != null) {
                v.addAll(this._rmiScheduler.jobsStatus());
            } else {
                this.logMessage("jobsStatus: null RMIScheduler");
            }
        }
        catch (RemoteException re) {
            this.logMessage("jobsStatus: error getting jobsStatus from RmiScheduler " + re);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setJobPaused(String jobName, boolean paused) throws RemoteException {
        Object job = null;
        if (jobName == null || jobName.length() < 1) {
            this.logMessage("pauseJob: recieved null or empty jobname");
            return false;
        }
        JobTask jobTask = null;
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                jobTask = (JobTask)this._currentTasks.elementAt(i);
                if (!jobTask.getName().equals(jobName)) continue;
                jobTask.setPaused(paused);
                break;
            }
        }
        if (jobTask != null) {
            return true;
        }
        try {
            if (this._rmiScheduler != null) {
                return this._rmiScheduler.setJobPaused(jobName, paused);
            }
            this.logMessage("setJobPaused: null RMIScheduler");
            return false;
        }
        catch (RemoteException e) {
            System.out.println("setJobPaused: RMI error with RmiScheduler " + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulableJob getJob(String jobName) {
        SchedulableJob job = null;
        if (jobName == null || jobName.length() < 1) {
            this.logMessage("getJob: recieved null or empty jobname");
            return job;
        }
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                JobTask jobTask = (JobTask)this._currentTasks.elementAt(i);
                if (!jobTask.getName().equals(jobName)) continue;
                job = jobTask.getJob();
                break;
            }
        }
        if (job == null) {
            try {
                if (this._rmiScheduler == null) {
                    this.logMessage("getJob: null RMIScheduler");
                    return null;
                }
                job = this._rmiScheduler.getJob(jobName);
            }
            catch (RemoteException re) {
                this.logMessage("getJob: error getting job " + jobName + " from RMIScheduler " + re);
            }
        }
        return job;
    }

    private void openLog() {
        try {
            this._logdir = System.getProperty("logfile.directory", "dated/logs");
            this._logdir = RMAIO.parsePathName((String)this._logdir);
            String logName = this._name;
            logName = System.getProperty("logfile.schedulerFileName", this._name);
            String logTimeCycle = System.getProperty("logfile.timeCycle", "dy");
            boolean useUTC = Boolean.getBoolean("logfile.useUTC");
            System.out.println("setupLogfile(): dir=" + this._logdir + " name=" + logName + " cycle=" + logTimeCycle);
            this._logFileStream = new LogPrintStream(this._logdir, logName, logTimeCycle, !useUTC, false);
            this._log = new PrintStream((OutputStream)this._logFileStream);
        }
        catch (Exception ioe) {
            System.out.println("ClientScheduler: failed to open logfile " + ioe);
        }
    }

    public void logException(Throwable t) {
        if (t == null) {
            return;
        }
        t.printStackTrace(this._log);
    }

    public void logMessage(String msg) {
        if (this._log == null) {
            System.out.println(this._name + ":" + msg);
            return;
        }
        try {
            this._date.setTime(System.currentTimeMillis());
            this._log.println(this._date.toString() + ":" + msg);
        }
        catch (Exception ioe) {
            System.out.println(this._name + ":Error writing to log " + ioe);
            System.out.println(this._name + ":" + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readJobs(Identifier id) {
        if (id == null) {
            return;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return;
        }
        try {
            this.logMessage("readJobs: reading from " + file.getPath());
            BufferedReader reader = file.getBufferedReader();
            HecAsciiDeserializer serializer = new HecAsciiDeserializer(reader);
            serializer.deserializeObject((Object)this._currentTasks);
            reader.close();
        }
        catch (Exception e) {
            this.logMessage("readJobs: error reading jobs " + e);
        }
        this.logMessage("readJobs: read in " + this._currentTasks.size() + " jobs");
        long timeNow = System.currentTimeMillis();
        Vector vector = this._currentTasks;
        synchronized (vector) {
            int size = this._currentTasks.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this._currentTasks.elementAt(i);
                JobTask task = (JobTask)obj;
                SchedulableJob job = task.getJob();
                if (job == null) continue;
                if (job.getStartDate().getTime() < timeNow && !job.isRecurring()) {
                    this.logMessage("readJobs: dropped non recurring task " + job.getName() + " scheduled to start before now");
                    if (task.getStatus().equals("Client not logged in")) continue;
                    task.setJobStatus("", "Client not logged in");
                    continue;
                }
                if (!job.isRecurring() && task.getLastRunTime() > 0L) continue;
                if (job.isRecurring() && job.getStartDate().getTime() < timeNow) {
                    long millis;
                    for (millis = job.getStartDate().getTime() + job.getPeriod(); millis < timeNow; millis += job.getPeriod()) {
                    }
                    this.scheduleTask(task, millis, job.getTimezoneOffset());
                    continue;
                }
                this.scheduleTask(task);
            }
        }
    }

    protected void writeJobs(Identifier id) {
        if (id == null) {
            return;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return;
        }
        BufferedWriter writer = file.getBufferedWriter();
        try {
            this.logMessage("writeJobs: saving to " + file.getPath());
            HecAsciiSerializer serializer = new HecAsciiSerializer(writer);
            serializer.serializeObject((Object)this._currentTasks);
            writer.close();
            this._isModified = false;
        }
        catch (Exception e) {
            this.logMessage("writeJobs: error writing jobs to " + id.getPath() + " error " + e);
            e.printStackTrace(this._log);
        }
    }

    public void setModified(boolean b) {
        this._isModified = b;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public String getName() {
        return this._name;
    }

    public String getLogDirectory() {
        return this._logdir;
    }

    public RMIScheduler getRMIScheduler() {
        return this._rmiScheduler;
    }
}

