/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.FileOpener;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientCache;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.WkspCallBack;
import hec.clientapp.io.WatershedInfoFile;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWkspCallBack;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.script.ScriptManagerImpl;
import hec.clientapp.server.RmiWkspCallBackImpl;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.WorkspaceNameFactory;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.map.ModeDrawingAttributeSet;
import hec.map.WorldRect;
import hec.map.appInterface.MapWorkspace;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.transform.CoordinateInfo;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataListLoader;
import hec.model.WkspExportOptions;
import hec.script.ScriptEngine;
import hec.script.ScriptManager;
import hec.util.ExportResults;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.lang.Modifiable;
import rma.util.RMAIO;
import rma.util.WildCardFileFilter;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.MapPropLoggingMarker;
import rma.util.logging.marking.WorkspaceLoadTimeLoggingMarker;

public class ClientWorkspace
implements ManagerProxyListContainer,
WkspCallBack,
Modifiable,
MapWorkspace,
FileOpener {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final MarkingClassLogger MAP_PROP_LOGGER = MarkingClassLogger.forMarkingClass(MapPropLoggingMarker.class);
    private static final MarkingClassLogger WORKSPACE_LOAD_TIME_LOGGER = MarkingClassLogger.forMarkingClass(WorkspaceLoadTimeLoggingMarker.class);
    private static final String UNTITLED = "Untitled";
    protected ClientApp _app;
    protected RmiWorkspace _rmiWorkspace;
    protected ManagerProxyList _managerVector = new ManagerProxyList();
    Hashtable _managerGroup = new Hashtable();
    protected Vector<MapObject> _mapVector = new Vector();
    protected transient boolean _modified = false;
    protected String lnseparator = null;
    protected CoordinateInfo _coordinateInfo = null;
    protected DataListContainer _dataListContainer = null;
    protected Hashtable _childWorkspaces = new Hashtable();
    protected ScriptManager _scriptManager;
    private transient int _unitSystem = Integer.MIN_VALUE;
    private transient int _gmtOffset = Integer.MIN_VALUE;
    String gmtFormat = "GMT{0}{1}:00";
    private RemoteWrapper _callBackWrapper;
    private String _workspacePath;
    private String _workspaceName;
    private String _workspaceTitleName;
    private Identifier _wkspIdentifier;
    private boolean _closed;
    private WatershedInfoFile _watershedInfoFile;

    public ClientWorkspace(ClientApp app, RemoteWrapper data) {
        RmiWorkspace rmiWorkspace = (RmiWorkspace)data.getRemote();
        this.loadWorkspace(app, rmiWorkspace);
    }

    public ClientWorkspace(ClientApp app, RmiWorkspace data) {
        this.loadWorkspace(app, data);
    }

    public ClientWorkspace() {
    }

    public void loadWorkspace(ClientApp app, RmiWorkspace data) {
        block7: {
            ClientCache cache;
            block6: {
                this._app = app;
                this._rmiWorkspace = data;
                cache = this._app.getCache();
                cache.setCacheWatershedDir(null);
                cache.loadWorkspaceCacheLists();
                if (cache.getCacheMode() == ClientCache.NORMAL_CACHED) break block6;
                if (cache.getCacheMode() != ClientCache.RELOAD_CACHE) break block7;
            }
            try {
                Identifier workspaceId = this._rmiWorkspace.getIdentifier();
                Identifier identifier = cache.openCachedFile(workspaceId);
            }
            catch (Exception workspaceId) {
                // empty catch block
            }
        }
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Start");
        if (ClientApp.frame() != null) {
            ClientApp.frame().getMapPanel().viewport().setToolTipText("");
        }
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("getting ManagerProxies...");
        long t1 = System.currentTimeMillis();
        this.getManagerProxies();
        long t2 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("getting ManagerProxies took: %s ms", t2 - t1);
        this.getWorkspaceMaps();
        t1 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("getting MapIdentifiers took: %s ms", t2 - t1);
        this._scriptManager = new ScriptManagerImpl(this);
        t2 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("creating ScriptManager took: %s ms", t2 - t1);
        this.setupDataListContainer();
        t1 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("setting up dataListContainer took: %s ms", t2 - t1);
        this.initCallBack();
        t2 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("init callback took: %s ms", t2 - t1);
    }

    protected void initCallBack() {
        RmiWkspCallBackImpl callBack = null;
        try {
            callBack = new RmiWkspCallBackImpl(this);
        }
        catch (RemoteException re) {
            System.out.println("initCallBack:failed to create RmiWkspCallBackImpl " + re);
        }
        this._callBackWrapper = callBack.getRemoteReference();
        if (ClientApp.app().networked) {
            callBack.exportServer();
        }
        this.setCallback(this._callBackWrapper, this._rmiWorkspace);
    }

    @Override
    public CommonDataList getCommonDataList(String theDataObjectClass, String theModel) {
        if (this._dataListContainer == null) {
            System.out.println("Error retrieving DataList in ClientWorkspace.getCommonDataList");
            System.out.println("DataListContainer is not available");
            System.out.println("DataObjectClass: " + theDataObjectClass);
            return null;
        }
        return this._dataListContainer.getDataList(theDataObjectClass, theModel);
    }

    @Override
    public int getUnitSystem() {
        if (this._unitSystem != Integer.MIN_VALUE) {
            return this._unitSystem;
        }
        try {
            int unitSystem;
            this._unitSystem = unitSystem = this._rmiWorkspace.getUnitSystem();
            return this._unitSystem;
        }
        catch (Exception re) {
            System.out.println("ERROR: <ClientWorkspace.getUnitSystem()> Remote Exception occurred when getting the current Unit System!");
            System.out.println(re.getMessage());
            return this._unitSystem;
        }
    }

    @Override
    public int getGmtOffset() {
        if (this._gmtOffset != Integer.MIN_VALUE) {
            return this._gmtOffset;
        }
        try {
            this._gmtOffset = this._rmiWorkspace.getGmtOffset();
            return this._gmtOffset;
        }
        catch (Exception ex) {
            System.out.println("ERROR: <ClientWorkspace.getGmtOffset()> Remote Exception occurred when getting the current GMT Offset!");
            System.out.println(ex.getMessage());
            return this._gmtOffset;
        }
    }

    private void setupDataListContainer() {
        try {
            RmiDataListContainer rdlc = this._rmiWorkspace.getDataList();
            if (rdlc != null) {
                this._dataListContainer = this._app.getDataListContainer(rdlc);
                this._dataListContainer.setContainer(this);
                DataListLoader.setDataListContainer((CommonDataListContainer)this._dataListContainer);
            } else {
                System.out.println("ClientWorkspace: failed to get DataListContainer from " + this._rmiWorkspace);
            }
        }
        catch (Exception re) {
            System.out.println("ClientWorkspace: failed to get RmiDataListContainer  " + re);
        }
    }

    public void close() {
        MapGlyph glyph;
        if (ClientApp.frame() != null) {
            ClientApp.frame().getMapPanel().viewport().setToolTipText(null);
        }
        this._coordinateInfo = null;
        if (this._dataListContainer != null) {
            this._dataListContainer.workspaceClosing();
        }
        for (int i = 0; i < this._mapVector.size(); ++i) {
            MapObject mo = this._mapVector.elementAt(i);
            mo.unload();
        }
        if (ClientApp.frame() != null && (glyph = ClientApp.frame().getMapPanel().findGlyphOfClass(StreamAlignmentGlyph.class.getName())) != null) {
            glyph.close();
        }
        ModeDrawingAttributeSet.workspaceClosing();
        if (this._rmiWorkspace != null) {
            this._app.getCache().saveCachedList();
            Enumeration e = this._managerGroup.elements();
            while (e.hasMoreElements()) {
                ManagerProxyList proxylist = (ManagerProxyList)e.nextElement();
                proxylist.closeWorkspace();
            }
            try {
                this._rmiWorkspace.removeCallBack((RmiWkspCallBack)this._callBackWrapper.getRemote());
            }
            catch (RemoteException re) {
                System.out.println("close: Error removing callback from RmiWorkspace " + re);
            }
            try {
                this._rmiWorkspace.closeWorkspace(this._app.getUser());
            }
            catch (RemoteException re) {
                System.out.println("Error closing Workspace from data interface  " + re);
                re.printStackTrace();
            }
        }
        this._childWorkspaces.clear();
        ScriptEngine.clear();
        if (this._scriptManager != null) {
            this._scriptManager.close();
        }
        this._scriptManager = new ScriptManagerImpl(this);
        if (this._watershedInfoFile != null) {
            this._watershedInfoFile.close();
        }
        this._closed = true;
    }

    public boolean checkAndSaveChanges() {
        if (ClientApp.frame() != null) {
            return ClientApp.frame().workspaceClosing();
        }
        return true;
    }

    public RmiWorkspace getData() {
        return this._rmiWorkspace;
    }

    public List<MapObject> getMaps() {
        return Collections.unmodifiableList(this._mapVector);
    }

    public Vector getManagerVector() {
        return this._managerVector;
    }

    public String getSharedDirectory() {
        RmiWorkspace data = this._rmiWorkspace;
        if (data == null) {
            return null;
        }
        String path = null;
        if (this._workspacePath == null) {
            try {
                path = data.getWorkspacePath();
            }
            catch (Exception e) {
                System.out.println("Local Workspace unable to get Workspace path");
                return null;
            }
        } else {
            path = this._workspacePath;
        }
        return path + "/shared";
    }

    public String getWorkspacePath() {
        RmiWorkspace data = this._rmiWorkspace;
        if (data == null) {
            return null;
        }
        if (this._workspacePath == null) {
            try {
                this._workspacePath = data.getWorkspacePath();
            }
            catch (Exception e) {
                System.out.println("Local Workspace unable to get Remote Workspace path " + e);
            }
        }
        return this._workspacePath;
    }

    public String getTemplateDirectory() {
        RmiWorkspace data = this._rmiWorkspace;
        if (data == null) {
            return null;
        }
        String path = null;
        if (this._workspacePath == null) {
            try {
                path = data.getWorkspacePath();
                return path + "/templates";
            }
            catch (Exception e) {
                System.out.println("Local Workspace unable to get Workspace path");
                return null;
            }
        }
        path = this._workspacePath;
        return path + "/templates";
    }

    public String getWorkspaceConfigFile(String model) {
        RmiWorkspace wksp = null;
        wksp = model == null || model.length() == 0 || model.equalsIgnoreCase("main") ? this._rmiWorkspace : this.getChildWorkspace(model);
        try {
            if (wksp != null) {
                return wksp.getWorkspaceFile();
            }
        }
        catch (RemoteException re) {
            System.out.println("getWorkspaceConfigFile: error getting config file " + re);
        }
        return null;
    }

    public boolean saveAllModifiedManagers() {
        boolean worked = this._managerVector.saveAllModifiedManagers(this._app.getUser());
        Enumeration e = this._managerGroup.elements();
        while (e.hasMoreElements()) {
            ManagerProxyList list = (ManagerProxyList)e.nextElement();
            worked = list.saveAllModifiedManagers(this._app.getUser()) && worked;
        }
        worked = this._dataListContainer.saveAll(this._app.getUser()) && worked;
        return worked;
    }

    public boolean saveAllManagers() {
        boolean worked = this._managerVector.saveAllManagers(this._app.getUser());
        Enumeration e = this._managerGroup.elements();
        while (e.hasMoreElements()) {
            ManagerProxyList list = (ManagerProxyList)e.nextElement();
            worked = list.saveAllManagers(this._app.getUser()) && worked;
        }
        worked = this._dataListContainer.saveAll(this._app.getUser()) && worked;
        return worked;
    }

    public boolean saveWorkspaceOnExit() {
        if (this._rmiWorkspace == null) {
            return false;
        }
        try {
            if (this.isModified()) {
                this.setWorkspaceMaps();
            }
            this._rmiWorkspace.saveWorkspace(this._app.getUser());
            return true;
        }
        catch (RemoteException re) {
            System.out.println("Error with saving in Save Workspace on Exit " + re);
            return false;
        }
    }

    public boolean saveWorkspace() {
        return this.saveWorkspace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveWorkspace(boolean saveAllManagers) {
        if (this._rmiWorkspace == null) {
            return false;
        }
        HecClientFrame frame = ClientApp.frame();
        if (frame != null) {
            frame.setWaitCursor();
        }
        boolean worked = saveAllManagers ? this.saveAllManagers() : this.saveAllModifiedManagers();
        try {
            if (this.isModified()) {
                this.setWorkspaceMaps();
            }
            this._rmiWorkspace.saveWorkspace(this._app.getUser());
            this.setModified(false);
            boolean bl = worked;
            return bl;
        }
        catch (RemoteException re) {
            System.out.println("Error with saving in Save As Workspace  " + re);
            boolean bl = false;
            return bl;
        }
        finally {
            if (frame != null) {
                frame.setDefaultCursor();
            }
        }
    }

    @Override
    public Vector<ManagerProxy> getManagerProxyList(String modelname, String className) {
        ManagerProxyList proxyList = this.getManagerProxyList(modelname);
        if (proxyList == null) {
            return null;
        }
        int size = proxyList.size();
        Vector<ManagerProxy> v = new Vector<ManagerProxy>(size);
        for (int i = 0; i < size; ++i) {
            ManagerProxy proxy = (ManagerProxy)proxyList.get(i);
            if (proxy == null || !proxy.getClassName().equals(className)) continue;
            v.add(proxy);
        }
        return v;
    }

    @Override
    public ManagerProxyList getManagerProxyList(String modelname) {
        ManagerProxyList list = null;
        String stdModelName = WorkspaceNameFactory.getWorkspaceName((String)modelname);
        list = (ManagerProxyList)this._managerGroup.get(stdModelName);
        if (list != null) {
            return list;
        }
        return this.loadManagerProxyList(stdModelName);
    }

    public ManagerProxyList loadManagerProxyList(String modelname) {
        String stdModelName = WorkspaceNameFactory.getWorkspaceName((String)modelname);
        ManagerProxyList list = null;
        RmiWorkspace childwksp = this.getChildWorkspace(stdModelName);
        try {
            list = childwksp.getManagers();
            list.setManagerProxyListContainer(this);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ManagerProxy proxy = (ManagerProxy)list.get(i);
                    if (proxy == null) continue;
                    proxy.setProxyList(list);
                    proxy.setUserInterface(ClientApp.frame());
                }
                this._managerGroup.put(stdModelName, list);
            }
        }
        catch (Exception e) {
            System.out.println("loadManagerProxyList:Error getting manager list from childworkspace " + modelname);
        }
        return list;
    }

    @Override
    public RmiWorkspace getChildWorkspace(String modelname) {
        if (this._rmiWorkspace == null || modelname == null) {
            return null;
        }
        String stdModelName = WorkspaceNameFactory.getWorkspaceName((String)modelname);
        RmiWorkspace child = null;
        if (stdModelName.equals("") || stdModelName.equals("main")) {
            return this._rmiWorkspace;
        }
        child = (RmiWorkspace)this._childWorkspaces.get(stdModelName);
        if (child != null) {
            return child;
        }
        try {
            child = this._rmiWorkspace.getChildWorkspace(stdModelName);
            if (child == null) {
                System.out.println("getChildWorkspace: failed to get child workspace for " + modelname);
                return null;
            }
            this.setCallback(this._callBackWrapper, child);
            this._childWorkspaces.put(stdModelName, child);
            RmiDataListContainer rdlc = child.getDataList();
            if (rdlc != null && this._dataListContainer != null) {
                this._dataListContainer.addDataLists(rdlc.getDataLists(), stdModelName);
            }
            return child;
        }
        catch (Exception e) {
            System.out.println("Error getting childworkspace " + modelname + " " + e);
            e.printStackTrace();
            return child;
        }
    }

    public ManagerProxy getManager(Identifier id) {
        return this._managerVector.getManager(id);
    }

    public ManagerProxy getManager(String modelname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManager(id);
    }

    @Override
    public ManagerProxy getManagerProxy(String modelname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManager(id);
    }

    @Override
    public ManagerProxy getManagerProxy(String modelname, String className, int index) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManagerProxy(className, index);
    }

    @Deprecated
    public Manager loadManager(String classname, Identifier id) {
        try {
            return this._managerVector.loadManager(classname, id);
        }
        catch (Exception e) {
            System.out.println("Error loading manager " + id.getPath() + " error " + e);
            e.printStackTrace();
            return null;
        }
    }

    public Manager loadManager(String modelname, String classname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        try {
            return list.loadManager(classname, id);
        }
        catch (Exception e) {
            System.out.println("Error loading manager " + id.getPath() + " error " + e);
            e.printStackTrace();
            return null;
        }
    }

    public Manager loadManagerByName(String modelname, String classname, String name) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        try {
            return list.loadManagerByName(classname, name);
        }
        catch (Exception e) {
            System.out.println("Error loading manager " + name + " error " + e);
            e.printStackTrace();
            return null;
        }
    }

    public Manager newManager(String classname) {
        Manager mgr = this._managerVector.newManager(classname);
        if (mgr != null) {
            this.setModified(true);
        }
        return mgr;
    }

    @Override
    public Manager newManager(String modelname, String classname) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        Manager mgr = list.newManager(classname);
        if (mgr != null) {
            this.setModified(true);
        }
        return mgr;
    }

    @Override
    public Manager openManager(String modelname, String className, int index) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(className, index);
    }

    @Override
    public Manager openManager(Identifier id) {
        return this._managerVector.openManager(id);
    }

    public Manager openManager(String relpath) {
        return this._managerVector.openManager(relpath);
    }

    @Override
    public Manager openManager(String modelname, Identifier id) {
        if (modelname == null || modelname.equals("main")) {
            return this.openManager(id);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(id);
    }

    @Override
    public Manager openManager(String modelname, String relpath) {
        if (modelname == null || modelname.equals("main")) {
            return this.openManager(relpath);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(relpath);
    }

    @Override
    public Manager openManagerByName(String modelname, String classname, String name) {
        ManagerProxyList list = null;
        list = modelname == null || modelname.equals("main") ? this._managerVector : this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        try {
            return list.loadManagerByName(classname, name);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameManager(String modelname, Manager mgr, Identifier newId) {
        if (mgr == null || newId == null) {
            return false;
        }
        RmiFileCallBackImpl[] callback = new RmiFileCallBackImpl[1];
        boolean locked = false;
        try {
            if (ClientApp.frame().getCurrentMode().lockManager(mgr, "Failed to Lock Manager for renaming", null, null, callback)) {
                locked = true;
                try {
                    Identifier origId = new Identifier(mgr.getIdentifier());
                    String user = ClientApp.app().getUser();
                    boolean b = this._rmiWorkspace.renameManager(user, modelname, ((Object)((Object)mgr)).getClass().getName(), mgr.getIndex(), newId);
                    if (b) {
                        if (locked) {
                            locked = ClientApp.frame().getCurrentMode().unlockManager(mgr, "Failed to unlock Manager during renaming", callback[0], null);
                        }
                        ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).removeFile(user, origId);
                        ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).deleteFile(origId.getPath());
                        mgr.setIdentifier(newId);
                        ManagerProxy proxy = this.getManager(origId);
                        if (proxy != null) {
                            proxy.setId(newId);
                        }
                        System.out.println("Renamed: " + origId.getPath());
                        System.out.println("     To: " + newId.getPath());
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (RemoteException re) {
                    System.out.println("renameManager: RMI Error renaming manager " + re);
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (locked) {
                ClientApp.frame().getCurrentMode().unlockManager(mgr, "Failed to unlock Manager during renaming", callback[0], null);
            }
        }
    }

    @Override
    public void unloadManager(String modelname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return;
        }
        list.unloadManager(id);
    }

    public boolean saveManager(Manager mgr) {
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return false;
            }
        }
        return this._managerVector.saveManager(this._app.getUser(), mgr);
    }

    @Override
    public boolean saveManager(String modelname, Manager mgr) {
        ManagerProxyList list;
        if (mgr == null) {
            return false;
        }
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                System.out.println("ClientWorkspace.saveManager: no workspace path to save " + modelname + " model manager " + mgr.getName());
                return false;
            }
        }
        if ((list = this.getManagerProxyList(modelname)) == null) {
            System.out.println("ClientWorkspace.saveManager: failed to find ProxyList " + modelname);
            return false;
        }
        return list.saveManager(this._app.getUser(), mgr);
    }

    public boolean saveManagerAs(String modelname, Manager mgrFrom, Manager mgrTo) {
        ManagerProxyList list;
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return false;
            }
        }
        if ((list = this.getManagerProxyList(modelname)) == null) {
            return false;
        }
        return list.saveManagerAs(this._app.getUser(), mgrFrom, mgrTo);
    }

    public boolean saveManagerAs(Manager mgr, Identifier id) {
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return false;
            }
        }
        return this._managerVector.saveManagerAs(this._app.getUser(), mgr, id);
    }

    @Override
    public boolean saveManagerAs(String modelname, Manager mgr, Identifier id) {
        ManagerProxyList list;
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                System.out.println("saveManagerAs: Error workspace path is null");
                return false;
            }
        }
        if ((list = this.getManagerProxyList(modelname)) == null) {
            System.out.println("saveManagerAs: no managerProxyList for " + modelname);
            return false;
        }
        return list.saveManagerAs(this._app.getUser(), mgr, id);
    }

    public boolean deleteManager(Identifier id) {
        this.setModified(true);
        return this._managerVector.deleteManager(id);
    }

    public boolean deleteManager(String modelname, Identifier id) {
        return this.deleteManager(modelname, id, true);
    }

    /*
     * Exception decompiling
     */
    public boolean deleteManager(String modelname, Identifier id, boolean deleteFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Vector<Identifier> getManagerIDList(String className) {
        return this._managerVector.getManagerIDList(className);
    }

    @Override
    public Vector<Identifier> getManagerIDList(String modelname, String className) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManagerIDList(className);
    }

    public String getName() {
        if (this._workspaceName == null) {
            if (this._rmiWorkspace != null) {
                try {
                    this._workspaceName = this._rmiWorkspace.getName();
                }
                catch (Exception e) {
                    System.out.println("getName: Error accessing rmi workspace " + e);
                    return UNTITLED;
                }
            } else {
                return UNTITLED;
            }
        }
        return this._workspaceName;
    }

    public String getTitleName() {
        if (this._workspaceTitleName == null) {
            if (this._rmiWorkspace != null) {
                try {
                    this._workspaceTitleName = this._rmiWorkspace.getTitleName();
                }
                catch (Exception e) {
                    System.out.println("getTitleName:Error accessing rmi workspace" + e);
                    return UNTITLED;
                }
            } else {
                return UNTITLED;
            }
        }
        return this._workspaceTitleName;
    }

    public String getDescription() {
        String descr = "";
        if (this._rmiWorkspace != null) {
            try {
                descr = this._rmiWorkspace.getDescription();
            }
            catch (Exception e) {
                System.out.println("Error accessing rmi workspace");
            }
        }
        return descr;
    }

    public boolean setDescription(String description) {
        if (this._rmiWorkspace != null) {
            try {
                this._rmiWorkspace.setDescription(ClientApp.app().getUser(), description);
                this.setModified(true);
                return true;
            }
            catch (Exception e) {
                System.out.println("setDescription: Error set Workspace description " + e);
            }
        }
        return false;
    }

    public Vector<Identifier> getLocalFileIDList(String path, String stringFilter) {
        WildCardFileFilter filter = null;
        if (stringFilter != null) {
            filter = new WildCardFileFilter(stringFilter);
        }
        Vector<Identifier> vectorList = new Vector<Identifier>();
        File dir = new File(path);
        if (dir == null) {
            return vectorList;
        }
        File file = null;
        if (dir.isDirectory()) {
            String[] stringList = null;
            stringList = filter == null ? dir.list() : dir.list((FilenameFilter)filter);
            if (stringList == null) {
                return vectorList;
            }
            for (int ii = 0; ii < stringList.length; ++ii) {
                String fileRelativePath = path + "/" + stringList[ii];
                Identifier pathId = new Identifier(fileRelativePath);
                pathId.setName(stringList[ii]);
                file = new File(fileRelativePath);
                pathId.initToFile(file);
                vectorList.addElement(pathId);
                file = null;
            }
        }
        return vectorList;
    }

    public List getFileList(String path, String filter) {
        return this._app.getFileList(path, filter);
    }

    public List getDriveList() {
        return this._app.getDriveList();
    }

    public Vector getRemoteFileIDList(String path, String filter) {
        RmiWorkspace data = this._rmiWorkspace;
        try {
            return data.getRemoteFileIDList(this._app.getUser(), path, filter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Identifier getRemoteFileID(String path) {
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return null;
            }
        }
        Identifier id = null;
        RmiWorkspace data = this._rmiWorkspace;
        Object newPath = null;
        try {
            newPath = data.isFullPath(path) ? path : this.getWorkspacePath() + "/" + path;
            Identifier pathId = new Identifier((String)newPath);
            id = data.openFile(this._app.getUser(), pathId);
        }
        catch (RemoteException re) {
            System.out.println("Error Getting Remote File Identifier  " + re);
            re.printStackTrace();
        }
        return id;
    }

    public MapIdentifier openCachedMapFileID(MapIdentifier mapId) {
        Identifier id = this.openCachedFileID((Identifier)mapId);
        MapIdentifier cachedMapId = new MapIdentifier(mapId);
        cachedMapId.setIdentifier(id);
        cachedMapId.setPath(mapId.getPath());
        return cachedMapId;
    }

    public Identifier openCachedFileID(Identifier pathId) {
        ClientCache cache;
        HecFile file;
        if (pathId == null) {
            return pathId;
        }
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return pathId;
            }
        }
        if ((file = pathId.getFile()) != null && (cache = this._app.getCache()) != null) {
            if (!(cache.isLocal() || file.isNetworked() || file.exists())) {
                pathId.setFile(null);
                file = null;
            }
        }
        if (pathId == null) {
            System.out.println("openCachedFileID: failed to open Remote File ");
            return pathId;
        }
        if (!ClientApp.app().isCachingEnabled() || !pathId.getPath().startsWith(ClientApp.app().getAppStartDir())) {
            if (pathId.getFile() == null) {
                return this.openRemoteFileID(pathId);
            }
            return pathId;
        }
        return this._app.getCache().openCachedFile(pathId);
    }

    public Identifier openRemoteFileID(Identifier pathId) {
        return this.openFile(pathId, false);
    }

    public Identifier openFile(Identifier pathId, boolean useCache) {
        if (useCache) {
            return this.openCachedFileID(pathId);
        }
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return null;
            }
        }
        Identifier id = null;
        RmiWorkspace data = this._rmiWorkspace;
        try {
            RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            if (fm != null) {
                id = fm.openFile(this._app.getUser(), pathId);
            }
        }
        catch (RemoteException re) {
            System.out.println("Error Getting Remote File Identifier  " + re);
            re.printStackTrace();
        }
        return id;
    }

    public Identifier newRemoteFileID(String path) {
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return null;
            }
        }
        Identifier id = null;
        RmiWorkspace data = this._rmiWorkspace;
        Object newPath = null;
        try {
            newPath = data.isFullPath(path) ? path : this.getWorkspacePath() + "/" + path;
            Identifier pathId = new Identifier((String)newPath);
            id = data.newFile(this._app.getUser(), pathId);
        }
        catch (RemoteException re) {
            System.out.println("Error Getting Remote File Identifier  " + re);
            re.printStackTrace();
        }
        return id;
    }

    public Identifier newRemoteFileID(Identifier pathId) {
        return this.createFile(pathId);
    }

    public Identifier createFile(Identifier pathId) {
        if (this.getWorkspacePath() == null) {
            ClientApp.app().saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return null;
            }
        }
        Identifier id = null;
        RmiWorkspace data = this._rmiWorkspace;
        try {
            id = data.newFile(this._app.getUser(), pathId);
        }
        catch (RemoteException re) {
            System.out.println("createFile:Error Getting Remote File Identifier  " + re);
            re.printStackTrace();
        }
        return id;
    }

    public Identifier getManagerIdentifier(String type, String classname, String name) {
        Identifier id = null;
        String sep = "/";
        String path = this.getWorkspacePath() + sep + type + sep + name;
        id = new Identifier(path);
        id.setName(name);
        return id;
    }

    public Identifier getManagerIdentifier(String type, String classname, String name, String ext) {
        Identifier id = null;
        String filename = RMAIO.userNameToFileName((String)name.trim());
        String sep = "/";
        String path = this.getWorkspacePath() + sep + type + sep + filename + (String)(ext.length() > 0 && ext.charAt(0) == '.' ? ext : "." + ext);
        id = new Identifier(path);
        id.setName(name);
        id.setClassName(classname);
        return id;
    }

    public void setManagerProxies() {
        RmiWorkspace di;
        if (this._rmiWorkspace != null && (di = this._rmiWorkspace) != null) {
            try {
                di.setManagers(this._app.getUser(), this._managerVector);
            }
            catch (RemoteException re) {
                System.out.println("Exception: " + re);
                re.printStackTrace();
            }
        }
    }

    public void getManagerProxies() {
        RmiWorkspace di;
        if (this._rmiWorkspace != null && (di = this._rmiWorkspace) != null) {
            try {
                this._managerVector = di.getManagers();
                if (this._managerVector != null) {
                    for (int i = 0; i < this._managerVector.size(); ++i) {
                        ManagerProxy proxy = (ManagerProxy)this._managerVector.elementAt(i);
                        if (proxy == null) continue;
                        proxy.setProxyList(this._managerVector);
                        proxy.setUserInterface(ClientApp.frame());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("ClientWorkspace failed to get manager proxy list! " + e);
            }
        }
        this._managerVector.setManagerProxyListContainer(this);
    }

    public void getWorkspaceMaps() {
        this._mapVector.removeAllElements();
        this._app.printStatus("Retrieving Map Information...");
        RmiWorkspace data = this._rmiWorkspace;
        Vector mapIdVec = null;
        try {
            mapIdVec = data.getMaps();
        }
        catch (RemoteException re) {
            System.out.println("Error getting Workspace's list of Maps  " + re);
            re.printStackTrace();
        }
        ((MarkingClassLogger.Api)MAP_PROP_LOGGER.atFine()).log("got %s maps to load", mapIdVec.size());
        for (int ii = 0; ii < mapIdVec.size(); ++ii) {
            MapIdentifier mapId = (MapIdentifier)mapIdVec.elementAt(ii);
            MapIdentifier cachedId = this.openCachedMapFileID(mapId);
            MapObject map = MapObjectFactory.newMapObject((FileOpener)this, (Identifier)cachedId);
            if (map == null) continue;
            this._mapVector.addElement(map);
        }
        ((MarkingClassLogger.Api)MAP_PROP_LOGGER.atFine()).log("loaded %s maps", this._mapVector.size());
    }

    public void setWorkspaceMaps() {
        Vector<MapIdentifier> mapIds = new Vector<MapIdentifier>(this._mapVector.size());
        for (int ii = 0; ii < this._mapVector.size(); ++ii) {
            MapObject mo = this._mapVector.get(ii);
            if (mo == null || mo.getMapIdentifier() == null) continue;
            mapIds.add(mo.getMapIdentifier());
        }
        try {
            this._rmiWorkspace.setMaps(this._app.getUser(), mapIds);
        }
        catch (Exception e) {
            System.out.println("Error setting Workspace's list of maps.  " + e);
        }
    }

    public boolean addMap(MapIdentifier id) {
        if (id == null) {
            return false;
        }
        MapObject mo = this.findMap(id);
        if (mo != null) {
            Msg msg = new Msg("Map " + id.toString() + " is already loaded.");
            ClientApp.app().errMsgBox(msg);
            return false;
        }
        try {
            id.setMapShown(true);
            MapIdentifier cachedId = this.openCachedMapFileID(id);
            mo = MapObjectFactory.newMapObject((FileOpener)this, (Identifier)cachedId);
            if (mo == null || this._rmiWorkspace == null) {
                return false;
            }
            id.setModifiedTime(System.currentTimeMillis());
            this._rmiWorkspace.addMap(this._app.getUser(), id);
            this._mapVector.addElement(mo);
            this.setModified(true);
            return true;
        }
        catch (Exception e) {
            System.out.println("Error adding map " + id + ".  " + e);
            return false;
        }
    }

    public boolean removeMap(MapIdentifier mapId) {
        if (mapId == null) {
            return false;
        }
        try {
            MapObject map = this.findMap(mapId);
            if (map == null) {
                return false;
            }
            map.unload();
            this._rmiWorkspace.removeMap(this._app.getUser(), mapId);
            this._mapVector.remove(map);
            this.setModified(true);
            return true;
        }
        catch (Exception e) {
            System.out.println("Error removing map " + mapId + ".  " + e);
            return false;
        }
    }

    public boolean setMapOrder(List orderedMapIds) {
        if (orderedMapIds.size() != this._mapVector.size()) {
            return false;
        }
        boolean needToReorder = false;
        for (int ii = 0; ii < this._mapVector.size(); ++ii) {
            MapObject mo = this._mapVector.get(ii);
            MapIdentifier notordered = mo.getMapIdentifier();
            MapIdentifier ordered = (MapIdentifier)orderedMapIds.get(ii);
            if (ordered.equals((Object)notordered)) continue;
            needToReorder = true;
            break;
        }
        if (!needToReorder) {
            return false;
        }
        Vector<MapObject> tmp = new Vector<MapObject>(this._mapVector.size());
        for (int ii = 0; ii < orderedMapIds.size(); ++ii) {
            MapIdentifier mapId;
            MapObject mo;
            Object o = orderedMapIds.get(ii);
            if (!(o instanceof MapIdentifier) || (mo = this.findMap(mapId = (MapIdentifier)o)) == null) continue;
            tmp.add(mo);
        }
        this._mapVector.clear();
        this._mapVector.addAll(tmp);
        this.setWorkspaceMaps();
        this.setModified(true);
        return true;
    }

    public List getManagerOrder() {
        try {
            return this._rmiWorkspace.getManagerOrder();
        }
        catch (RemoteException re) {
            System.out.println("getManagerOrder: RMI error getting manager order list from RmiWorkspace " + re);
            return null;
        }
    }

    public boolean setManagerOrder(List managerOrderList) {
        boolean b = false;
        try {
            b = this._rmiWorkspace.setManagerOrder(ClientApp.app().getUser(), managerOrderList);
            if (b) {
                this.setModified(true);
            }
        }
        catch (RemoteException re) {
            System.out.println("setManagerOrder: RMI error setting manager order list on RmiWorkspace " + re);
        }
        return b;
    }

    public boolean setExtents(WorldRect e) {
        try {
            RmiWorkspace data = this._rmiWorkspace;
            if (data.setExtents(this._app.getUser(), e)) {
                this.setModified(true);
                return true;
            }
            System.out.println("Failed to update Extents");
        }
        catch (RemoteException re) {
            System.out.println("Error setting the Extents on ClientWorkspace  " + re);
            re.printStackTrace();
        }
        return false;
    }

    public boolean setCoordSys(CoordinateInfo coordSys) {
        this._coordinateInfo = null;
        try {
            if (this._rmiWorkspace.setCoordSys(this._app.getUser(), coordSys)) {
                this.setModified(true);
                return true;
            }
            System.out.println("Failed to udpate Coordinate System Information");
        }
        catch (RemoteException re) {
            System.out.println("Error setting the Coord System on ClientWorkspace  " + re);
            re.printStackTrace();
        }
        return false;
    }

    public boolean setGrowToExtents(boolean growToEx) {
        try {
            if (this._rmiWorkspace.setGrowToExtents(this._app.getUser(), growToEx)) {
                this.setModified(true);
                return true;
            }
            System.out.println("Failed to set grow to extents flag");
        }
        catch (RemoteException re) {
            System.out.println("Error setting the GrowToExtents Flag on ClientWorkspace  " + re);
            re.printStackTrace();
        }
        return false;
    }

    public WorldRect getExtents() {
        try {
            RmiWorkspace data = this._rmiWorkspace;
            return data.getExtents();
        }
        catch (Exception e) {
            return null;
        }
    }

    public CoordinateInfo getCoordSys() {
        if (this._coordinateInfo != null) {
            return this._coordinateInfo;
        }
        try {
            RmiWorkspace data = this._rmiWorkspace;
            this._coordinateInfo = data.getCoordSys();
            return this._coordinateInfo;
        }
        catch (Exception e) {
            System.out.println("getCoordSys:Error retrieving CoordinateInfo " + e);
            return null;
        }
    }

    public boolean getGrowToExtents() {
        try {
            RmiWorkspace data = this._rmiWorkspace;
            return data.getGrowToExtents();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getIconQualityInformation() {
        try {
            return this._rmiWorkspace.getIconQualityInformation();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean copyFile(String oldpath, String newpath) {
        BufferedInputStream in;
        try {
            in = new BufferedInputStream(new FileInputStream(oldpath));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newpath));
            int len = 1024;
            byte[] b = new byte[len];
            int ibytes = 0;
            ibytes = in.read(b, 0, len);
            while (ibytes > -1) {
                out.write(b, 0, ibytes);
                ibytes = in.read(b, 0, len);
            }
            out.flush();
            in.close();
            out.close();
        }
        catch (IOException eio) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean flag) {
        this._modified = flag;
    }

    @Override
    public String makeAbsolutePath(String relPath) {
        if (relPath == null || relPath.equals("")) {
            return relPath;
        }
        if (this.isFullPath(relPath = RMAIO.parsePathName((String)relPath))) {
            return relPath;
        }
        if ((relPath = relPath.replace('\\', '/')).charAt(0) == '.') {
            relPath = relPath.substring(1);
        }
        String absPath = this.getWorkspacePath() + (relPath.charAt(0) == "/".charAt(0) ? "" : "/") + relPath;
        return absPath;
    }

    public boolean isFullPath(String path) {
        if (path == null || path.equals("")) {
            return true;
        }
        path = RMAIO.parsePathName((String)path);
        return (path = path.replace('\\', '/')).substring(0, 1).equals("/") || path.charAt(1) == ':' && path.substring(2, 3).equals("/");
    }

    public String getRelativePath(String path) {
        return RMAIO.getRelativePath((String)this.getWorkspacePath(), (String)path);
    }

    public String lnSeparator() {
        if (this.lnseparator == null) {
            try {
                this.lnseparator = this._rmiWorkspace.lnSeparator();
                return this.lnseparator;
            }
            catch (Exception e) {
                e.printStackTrace();
                return System.getProperty("line.separator");
            }
        }
        return this.lnseparator;
    }

    public DataListContainer getDataListContainer() {
        return this._dataListContainer;
    }

    public String getServerProperty(String prop) {
        String servProp = null;
        try {
            servProp = this._rmiWorkspace.getProperty(prop);
        }
        catch (RemoteException re) {
            System.out.println("ClientWorkspace.getServerProperty: failed to get ServerProperty " + prop + " Error " + re);
        }
        return servProp;
    }

    public String getWkspDir() {
        try {
            Identifier remoteWkspId = this._rmiWorkspace.getIdentifier();
            String path = remoteWkspId.getPath().replace('\\', '/');
            String dir = RMAIO.getDirectoryFromPath((String)path);
            return dir;
        }
        catch (Exception e) {
            return null;
        }
    }

    public TimeZone getWatershedTimeZone() {
        int offset = this.getGmtOffset();
        Object[] args = new Object[2];
        args[0] = offset < 0 ? "-" : "+";
        int tempOffset = Math.abs(offset);
        args[1] = Integer.toString(tempOffset).length() > 1 ? new Integer(tempOffset) : "0" + tempOffset;
        return new SimpleTimeZone(offset * 60 * 60 * 1000, MessageFormat.format(this.gmtFormat, args));
    }

    public TimeZone getTimeZone() {
        return this.getTimeZone(null);
    }

    public TimeZone getTimeZone(String modelname) {
        return this.getWatershedTimeZone();
    }

    public ScriptManager getScriptManager() {
        return this._scriptManager;
    }

    public void setScriptManager(ScriptManager scriptManager) {
        this._scriptManager = scriptManager;
    }

    public boolean downLoadFile(Identifier remoteId, Identifier localId) {
        return this._app.getCache().downloadFile(remoteId, localId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upLoadFile(Identifier localId, Identifier remoteId) {
        if (remoteId == null || remoteId.getFile() == null) {
            System.out.println("upLoadFile: no remote file id specified or remote file is null");
            return false;
        }
        if (localId == null) {
            System.out.println("upLoadFile: no local file id specified");
            return false;
        }
        System.out.println("upLoadFile: uploading " + localId.getPath() + " to " + remoteId.getPath());
        FileInputStream reader = null;
        ByteArrayOutputStream writer = null;
        try {
            int len;
            reader = new FileInputStream(localId.getPath());
            writer = remoteId.getFile().getByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((len = reader.read(bytes)) > -1) {
                writer.write(bytes, 0, len);
            }
            writer.flush();
        }
        catch (IOException ioe) {
            System.out.println("upLoadFile: failed to upload " + localId.getPath() + " to " + remoteId.getPath());
            System.out.println("upLoadFile: Error " + ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return remoteId.getFile().length() == new File(localId.getPath()).length();
    }

    public MapObject findMap(MapIdentifier mapid) {
        for (int ii = 0; ii < this._mapVector.size(); ++ii) {
            MapObject mo;
            MapObject o = this._mapVector.get(ii);
            if (!(o instanceof MapObject) || !(mo = o).mapIdentifierEquals(mapid)) continue;
            return mo;
        }
        return null;
    }

    protected void setCallback(RemoteWrapper callBackWrap, RmiWorkspace wksp) {
        try {
            RmiWkspCallBack callBack = (RmiWkspCallBack)callBackWrap.getRemote();
            wksp.addCallBack(callBack);
        }
        catch (Exception e) {
            System.out.println("Error adding callback to RmiWorkspace " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void managerChanged(int changeType, ManagerProxy proxy, String model) {
        switch (changeType) {
            case 0: {
                this.managerAdded(proxy, model);
                break;
            }
            case 1: {
                this.managerRemoved(proxy, model);
                break;
            }
            case 2: {
                this.managerRenamed(proxy, model);
            }
        }
    }

    protected void managerRenamed(ManagerProxy proxy, String model) {
        ManagerProxy origProxy;
        if (proxy == null || model == null) {
            return;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return;
        }
        System.out.println("managerRenamed: got Proxy for " + proxy + " model " + model);
        if (proxyList.contains(proxy) && proxy.getIndex() > -1 && (origProxy = proxyList.getManagerProxy(model, proxy.getClassName(), proxy.getIndex())) != null) {
            origProxy.renameManager(proxy.getId());
            proxyList.saveManager(model, origProxy.getManager());
        }
    }

    protected void managerAdded(ManagerProxy proxy, String model) {
        if (proxy == null || model == null) {
            return;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return;
        }
        System.out.println("managerAdded: got Proxy for " + proxy + " model " + model);
        if (!proxyList.contains(proxy) && proxy.getIndex() > -1) {
            proxy.setProxyList(proxyList);
            proxyList.addElement(proxy);
        }
    }

    protected void managerRemoved(ManagerProxy proxy, String model) {
        if (proxy == null || model == null) {
            return;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return;
        }
        if (proxyList.contains(proxy)) {
            proxyList.remove(proxy);
        }
    }

    @Override
    public void mapAdded(MapIdentifier mapId) {
        if (mapId == null) {
            return;
        }
    }

    @Override
    public void mapRemoved(MapIdentifier mapId) {
        if (mapId == null) {
            return;
        }
    }

    @Override
    public void userChanged(String user, String changeType) {
        if (ClientApp.frame() != null) {
            ClientApp.frame().printMessage(user + " has " + changeType + " the Watershed");
        } else {
            System.out.println(user + " has " + changeType + " the Watershed");
        }
    }

    public Identifier getFileIdentifier(String path) {
        return new Identifier(path);
    }

    public boolean unlockFile(Identifier id, FileLock flock) {
        try {
            return ((RmiFileManager)this._app.getFileManager().getRemote()).unlockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("unlockFile: RMI Error unlocking " + id.getPath() + " Error:" + re);
            return false;
        }
    }

    public boolean lockFile(Identifier id, FileLock flock) {
        try {
            return ((RmiFileManager)this._app.getFileManager().getRemote()).lockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("lockFile: RMI Error unlocking " + id.getPath() + " Error:" + re);
            return false;
        }
    }

    public Identifier getIdentifier() {
        if (this._wkspIdentifier == null) {
            try {
                this._wkspIdentifier = this._rmiWorkspace.getIdentifier();
            }
            catch (RemoteException re) {
                System.out.println("getIdentifier: RMI Error getting Workspace Identifier " + re);
            }
        }
        return this._wkspIdentifier;
    }

    public String toString() {
        return this.getWorkspacePath();
    }

    public DSSManager getDssFileManager() {
        RemoteWrapper wrap;
        try {
            wrap = this._rmiWorkspace.getDSSFileManager();
        }
        catch (RemoteException e) {
            System.out.println("getDssFileManager: RemoteException " + e);
            return null;
        }
        if (wrap != null) {
            return (DSSManager)wrap.getRemote();
        }
        return null;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void removeAllManagersCallbacks() {
        this._managerVector.removeAllManagersCallbacks();
        for (int i = 0; i < this._managerGroup.size(); ++i) {
            ManagerProxyList list = (ManagerProxyList)this._managerGroup.get(i);
            if (list == null) continue;
            list.removeAllManagersCallbacks();
        }
    }

    public ExportResults export(WkspExportOptions options) {
        ExportResults results;
        RmiWorkspace wksp = this.getData();
        if (wksp == null) {
            ExportResults results2 = new ExportResults();
            results2.setSuccessful(false);
            results2.addMessage("Missing RMI Workspace");
            return results2;
        }
        try {
            results = wksp.export(options);
        }
        catch (RemoteException e) {
            results = new ExportResults();
            results.setSuccessful(false);
            results.addMessage("Communication Error with server " + e);
        }
        return results;
    }

    public synchronized WatershedInfoFile getWatershedInfoFile() {
        if (this._watershedInfoFile == null) {
            this._watershedInfoFile = new WatershedInfoFile();
            Identifier identifier = this._watershedInfoFile.getWatershedInfoIdentifier();
        }
        return this._watershedInfoFile;
    }

    public String getWorkspaceVersion() {
        try {
            return this.getData().getWorkspaceVersion();
        }
        catch (RemoteException e) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("getWorkspaceVersion: RMI Error getting Workspace Version " + e);
            return null;
        }
    }
}

