/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.properties.HECProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;

public class ComputeOptionsPanel
extends DefaultJPanel {
    public static final String HTML_PROP = "client.useHtmlForLogs";
    public static final String HTML_BG_PROP = "client.html.background";
    public static final String COMPUTE_WARNING = "client.compute.warningColor";
    public static final String COMPUTE_ERROR = "client.compute.errorColor";
    public static final String COMPUTE_TEXT = "client.compute.textColor";
    public static final String[] COLORS = new String[]{"Red", "Blue", "Green", "Yellow", "Orange", "White", "Black", "Magenta", "Gray"};
    public static final String[] BGCOLORS = new String[]{"Gray", "White"};
    RmaJCheckBox useHttpForLogs;
    RmaJComboBox errorColor;
    RmaJComboBox warningColor;
    RmaJComboBox htmlBGColor;
    RmaJComboBox textColor;

    public ComputeOptionsPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Compute Window Properties:"));
        this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Compute Message Color:");
        label.setDisplayedMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        panel.add((Component)label, gbc);
        this.textColor = new RmaJComboBox((Object[])COLORS);
        label.setLabelFor((Component)this.textColor);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        panel.add((Component)this.textColor, gbc);
        label = new JLabel("Compute Warning Message Color:");
        label.setDisplayedMnemonic('w');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        panel.add((Component)label, gbc);
        this.warningColor = new RmaJComboBox((Object[])COLORS);
        label.setLabelFor((Component)this.warningColor);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        panel.add((Component)this.warningColor, gbc);
        label = new JLabel("Compute Error Message Color:");
        label.setDisplayedMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        panel.add((Component)label, gbc);
        this.errorColor = new RmaJComboBox((Object[])COLORS);
        label.setLabelFor((Component)this.warningColor);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.weighty = 1.0;
        panel.add((Component)this.errorColor, gbc);
        panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Log File Properties:"));
        this.add(panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.useHttpForLogs = new RmaJCheckBox("Use HTML for Logs");
        this.useHttpForLogs.setMnemonic('u');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        panel.add((Component)this.useHttpForLogs, gbc);
        label = new JLabel("HTML Background Color:");
        label.setDisplayedMnemonic('h');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        panel.add((Component)label, gbc);
        this.htmlBGColor = new RmaJComboBox((Object[])BGCOLORS);
        label.setLabelFor((Component)this.warningColor);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        panel.add((Component)this.htmlBGColor, gbc);
    }

    public void fillPanel() {
        JTabbedPane parent = (JTabbedPane)this.getParent();
        int idx = parent.indexOfComponent((Component)((Object)this));
        HECProperties prop = ClientApp.app().getProperties();
        if (prop == null) {
            parent.setEnabledAt(idx, false);
            return;
        }
        String s = prop.getProp(HTML_PROP);
        if (s != null) {
            if (s.equalsIgnoreCase("true")) {
                this.useHttpForLogs.setSelected(true);
            } else {
                this.useHttpForLogs.setSelected(false);
            }
        }
        s = prop.getProp(COMPUTE_TEXT, "Black");
        this.textColor.setSelectedItem((Object)s);
        s = prop.getProp(COMPUTE_ERROR, "Red");
        this.errorColor.setSelectedItem((Object)s);
        s = prop.getProp(COMPUTE_WARNING, "Orange");
        this.warningColor.setSelectedItem((Object)s);
        s = prop.getProp(HTML_BG_PROP, "White");
        this.htmlBGColor.setSelectedItem((Object)s);
        parent.setEnabledAt(idx, true);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        HECProperties prop = ClientApp.app().getProperties();
        if (prop == null) {
            return true;
        }
        String s = this.useHttpForLogs.isSelected() ? "true" : "false";
        prop.setProp(HTML_PROP, s);
        prop.setProp(COMPUTE_TEXT, (String)this.textColor.getSelectedItem());
        prop.setProp(COMPUTE_ERROR, (String)this.errorColor.getSelectedItem());
        prop.setProp(COMPUTE_WARNING, (String)this.warningColor.getSelectedItem());
        prop.setProp(HTML_BG_PROP, (String)this.htmlBGColor.getSelectedItem());
        prop.saveProperties();
        return true;
    }
}

