/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.lang.ModelReference;
import hec.lang.WorkspaceNameFactory;
import hec.map.MapGlyph;
import hec.model.AltItem;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;

public class CopySimulationRunDataDialog
extends RmaJDialog {
    private static final int CHECK_BOX_COL = 0;
    private static final int PROGRAM_NAME_COL = 1;
    private static final int MODEL_ALT_COL = 2;
    private static final int MODEL_COL = 3;
    private static final int COPY_DATA = 1;
    private static final int REFRESH_DATA = 2;
    private int _dialogMode;
    private RmaJTextField simulationTxt;
    private RmaJTextField simulationRunTxt;
    private RmaJTextField trialRunTxt;
    private RmaJTextField configurationTxt;
    private ButtonCmdPanel cmdPanel;
    private boolean _canceled = false;
    private AbstractSimulation _simulation;
    private SimulationRun _baseRun;
    private SimulationRun _newRun;
    private JPanel runListPanel;
    private RmaJTable _runTable;
    private Vector _modelOrder = null;
    private Vector _altIdList = null;
    private Vector _labelList = new Vector();
    ColumnGroup _columnGroup;
    private String _simType;

    public CopySimulationRunDataDialog(Frame parent, boolean modal, String simType) {
        super(parent, modal);
        this._simType = simType;
        this.buildControls();
    }

    public CopySimulationRunDataDialog(Frame parent, boolean modal) {
        this(parent, modal, "Simulation");
    }

    private void buildControls() {
        this._dialogMode = 1;
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Save " + this._simType + " Run Model Parameters to Base Directory");
        JLabel label = new JLabel("Configuration:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.configurationTxt = new RmaJTextField();
        this.configurationTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.configurationTxt, gbc);
        label = new JLabel(this._simType + ":", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.simulationTxt = new RmaJTextField();
        this.simulationTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.simulationTxt, gbc);
        label = new JLabel(this._simType + " Run:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.simulationRunTxt = new RmaJTextField();
        this.simulationRunTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.simulationRunTxt, gbc);
        label = new JLabel("Trial:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.trialRunTxt = new RmaJTextField();
        this.trialRunTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)sep, gbc);
        this._runTable = new RmaJTable((Component)((Object)this), new String[]{"Copy\nData", "Program", "Model " + this._simType + " \nAlternative", "Model"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this._runTable.setTableHeader((JTableHeader)new GroupableTableHeader(this._runTable.getColumnModel()));
        this._runTable.setColumnWidths(new int[]{53, 144, 200, 53});
        this._runTable.setMlHeaderRenderer();
        TableColumnModel cm = this._runTable.getColumnModel();
        this._columnGroup = new ColumnGroup("");
        this._columnGroup.add((Object)cm.getColumn(0));
        this._columnGroup.add((Object)cm.getColumn(1));
        this._columnGroup.add((Object)cm.getColumn(2));
        this._columnGroup.add((Object)cm.getColumn(3));
        this._columnGroup.setBackground(new Color(-16744320));
        this._columnGroup.setForeground(Color.white);
        GroupableTableHeader header = (GroupableTableHeader)this._runTable.getTableHeader();
        header.addColumnGroup(this._columnGroup);
        this._runTable.setCellSelectionEnabled(false);
        this._runTable.setColumnSelectionAllowed(false);
        this._runTable.setRowSelectionAllowed(true);
        this._runTable.setCheckBoxCellEditor(0);
        this._runTable.setColumnEnabled(false, 1);
        this._runTable.setColumnEnabled(false, 2);
        this._runTable.setColumnEnabled(false, 3);
        this._runTable.setPopupMenuEnabled(false);
        this._runTable.setRowHeight(20);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._runTable.getScrollPane(), gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!CopySimulationRunDataDialog.this.saveForm()) break;
                        CopySimulationRunDataDialog.this._canceled = false;
                        CopySimulationRunDataDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        CopySimulationRunDataDialog.this._canceled = true;
                        CopySimulationRunDataDialog.this._runTable.columnSizes();
                        CopySimulationRunDataDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.pack();
        this.setLocation();
    }

    public void setSimulation(SimulationPeriod f) {
        this._simulation = f;
        if (this._simulation != null) {
            this.simulationTxt.setText(f.getName());
        }
    }

    public void setForTrialUse() {
        this.setTitle("Restore " + this._simType + " Run Model Parameters from Original Alternative");
        TableColumnModel cm = this._runTable.getColumnModel();
        cm.getColumn(0).setHeaderValue("Restore\nData");
        this._runTable.setColumnWidths(new int[]{55, 146, 194, 55});
    }

    public void setRefreshData() {
        this._dialogMode = 2;
    }

    public void setSimulationRun(SimulationRun run) {
        this._baseRun = run;
        if (run != null) {
            this.trialRunTxt.setText(run.getName());
            this._columnGroup.setHeaderValue((Object)run.getUserName());
        } else {
            this.trialRunTxt.setText("");
            this._columnGroup.setHeaderValue((Object)"");
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void fillForm() {
        try {
            ClientApp.app();
            SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
            if (smWksp != null) {
                this._modelOrder = smWksp.getOrderedModels(ClientApp.app().getAppType());
            }
        }
        catch (RemoteException re) {
            System.out.println("createAlternativePanel: failed to get model execution order from Supplemental RmiWorkspace " + re);
        }
        this.buildTrialTable(this._runTable, this._baseRun);
    }

    private void buildTrialTable(RmaJTable table, SimulationRun run) {
        Vector<AltItem> altList;
        DataObject c;
        table.deleteCells();
        table.clearColors();
        if (run == null) {
            return;
        }
        this.configurationTxt.setText("");
        this.simulationRunTxt.setText(run.getUserName());
        ClientApp.app();
        CommonDataList cdl = ClientApp.Workspace().getCommonDataList("hec.watershed.model.Condition", "");
        if (cdl != null && run.getConfigurationId() != -1L && (c = cdl.findObjectById(run.getConfigurationId(), "hec.watershed.model.Condition")) != null) {
            this.configurationTxt.setText(c.getName());
        }
        if ((altList = run.getAltList()) == null || altList.size() < 1) {
            return;
        }
        AbstractSimulation wksp = this._simulation;
        boolean hasButton = false;
        int i = 0;
        Object runList = null;
        String name = this._baseRun instanceof SimulationTrialRun ? this._baseRun.getKey() : this._baseRun.getName();
        int offset = 11;
        if (this._simulation instanceof SimulationPeriod) {
            offset = ((SimulationPeriod)this._simulation).getMaxAlternativeNameLength();
        }
        for (i = 0; i < altList.size(); ++i) {
            String labelName;
            boolean rowEnabled = true;
            Vector<Object> tableRow = new Vector<Object>(3);
            AltItem altItem = altList.elementAt(i);
            if (altItem == null) continue;
            ProgramOrderItem poi = this.getProgramOrderItem(altItem);
            tableRow.add(false);
            if (poi != null) {
                labelName = poi.isStandardModel() ? poi.getDescription() + " (" + poi.toString() + ")" : poi.getName();
                tableRow.add(poi);
            } else {
                labelName = altItem.getProgram();
                rowEnabled = false;
                tableRow.add(labelName);
            }
            if (altItem.getAltIndex() == -1) {
                tableRow.add(null);
            } else {
                ModelAlt alt = (ModelAlt)wksp.openManager(ClientApp.app().getAppType(), "hec.watershed.model.ModelAlt", altItem.getAltIndex());
                if (alt != null) {
                    tableRow.add(alt);
                } else {
                    tableRow.add(null);
                }
            }
            int start = offset * i;
            int end = start + offset;
            String altName = name.substring(start, end);
            tableRow.add(altName);
            if (altName.equals("--")) {
                rowEnabled = false;
            }
            table.appendRow(tableRow);
            int row = table.getRowCount() - 1;
            table.setRowEnabled(rowEnabled, row);
            if (rowEnabled) continue;
            table.setRowBackground(row, (Color)UIManager.get("TextField.disabledBackground"));
        }
        this.pack();
    }

    public ProgramOrderItem getProgramOrderItem(AltItem altItem) {
        if (altItem == null) {
            return null;
        }
        String programName = altItem.getProgram();
        if (programName == null) {
            return null;
        }
        if (this._modelOrder == null) {
            return null;
        }
        for (int i = 0; i < this._modelOrder.size(); ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)this._modelOrder.elementAt(i);
            if (poi == null || !poi.getName().equalsIgnoreCase(programName)) continue;
            return poi;
        }
        return null;
    }

    private boolean saveForm() {
        if (this._dialogMode == 1) {
            return this.copyData();
        }
        if (this._dialogMode == 2) {
            return this.refreshData();
        }
        return false;
    }

    private boolean copyData() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (this._baseRun == null) {
            return false;
        }
        int[] rows = this.getSelectedRows();
        Vector<AltItem> runAltList = this._baseRun.getAltList();
        if (runAltList.size() != this._runTable.getRowCount()) {
            return false;
        }
        if (rows.length > 0) {
            for (int i = 0; i < rows.length; ++i) {
                ModelAlt simulationModelAlt = (ModelAlt)this._runTable.getCell(rows[i], 2);
                if (simulationModelAlt == null) {
                    System.out.println("copyData: failed to find ModelAlt in table for row " + rows[i]);
                    continue;
                }
                ModelReference ref = simulationModelAlt.getModelRef();
                if (ref == null) {
                    System.out.println("copyData: failed to find ModelReference from " + simulationModelAlt);
                    continue;
                }
                String wkspName = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName);
                Manager wkspAltMgr = wksp.openManager(wkspName, ref.className, ref.id);
                if (wkspAltMgr == null) {
                    System.out.println("copyData: failed to load Model Manager from ModelReference " + ref);
                    continue;
                }
                Manager simulationAltMgr = simulationModelAlt.getManager();
                if (simulationAltMgr == null) {
                    System.out.println("copyData: failed to get Run's Model Manager from Model Reference " + ref);
                    continue;
                }
                if (simulationAltMgr.isModified()) {
                    this._simulation.saveManager(wkspName, simulationAltMgr);
                }
                if (!wkspAltMgr.refreshData(simulationAltMgr)) {
                    System.out.println("copyData: failed to copy data to base directory");
                }
                this._simulation.unloadManager(wkspName, simulationModelAlt.getIdentifier());
                wksp.unloadManager(wkspName, wkspAltMgr.getIdentifier());
            }
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No rows selected to save", "", 2);
        return false;
    }

    private boolean copyDataOld() {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (this._baseRun == null) {
            return false;
        }
        int[] rows = this.getSelectedRows();
        Vector<AltItem> runAltList = this._baseRun.getAltList();
        if (runAltList.size() != this._runTable.getRowCount()) {
            return false;
        }
        if (rows != null || rows.length > 0) {
            for (int i = 0; i < rows.length; ++i) {
                ModelAlt alt = (ModelAlt)this._runTable.getCell(rows[i], 2);
                if (alt == null) {
                    System.out.println("copyData: failed to find ModelAlt in table for row " + rows[i]);
                    continue;
                }
                ModelReference ref = alt.getModelRef();
                if (ref == null) {
                    System.out.println("copyData: failed to find ModelReference from " + alt);
                    continue;
                }
                String wkspName = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName);
                Manager mgr = wksp.openManager(wkspName, ref.className, ref.id);
                if (mgr == null) {
                    System.out.println("copyData: failed to load Model Manager from ModelReference " + ref);
                    continue;
                }
                ProgramOrderItem poi = (ProgramOrderItem)this._runTable.getCell(rows[i], 1);
                if (poi == null) {
                    System.out.println("copyData: failed to find ProgramOrderItem in Table for row " + rows[i]);
                    continue;
                }
                AltItem runAltItem = runAltList.get(rows[i]);
                if (runAltItem == null || runAltItem.getAltIndex() == -1) {
                    System.out.println("copyData: failed to find trial AltItem for row " + rows[i]);
                    continue;
                }
                ModelAlt runAlt = (ModelAlt)this._simulation.openManager(ClientApp.app().getAppType(), "hec.clientapp.model.ModelAlt", runAltItem.getAltIndex());
                if (runAlt == null) {
                    System.out.println("copyData: failed to get ModelAlt for " + poi + " from Run " + this._baseRun);
                    continue;
                }
                ModelReference runRef = runAlt.getModelRef();
                if (runRef == null) {
                    System.out.println("copyData: failed to get ModelReference from Trial Alt " + runAlt);
                    continue;
                }
                String runWkspName = WorkspaceNameFactory.getWorkspaceName((String)runRef.wkspName);
                Manager runMgr = this._simulation.openManager(runWkspName, runRef.className, runRef.newId);
                if (runMgr == null) {
                    System.out.println("copyData: failed to get Trial's Model Manager from Model Reference " + ref);
                    continue;
                }
                this._simulation.unloadManager(runWkspName, runMgr.getIdentifier());
                this._simulation.unloadManager("cavi", runAlt.getIdentifier());
                wksp.unloadManager(wkspName, mgr.getIdentifier());
                wksp.unloadManager("cavi", alt.getIdentifier());
            }
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No rows selected to save", "", 2);
        return false;
    }

    private boolean refreshData() {
        if (this._baseRun == null) {
            return false;
        }
        int[] rows = this.getSelectedRows();
        Vector<AltItem> trialAltList = this._baseRun.getAltList();
        if (trialAltList.size() != this._runTable.getRowCount()) {
            return false;
        }
        if (rows != null || rows.length > 0) {
            for (int i = 0; i < rows.length; ++i) {
                ModelAlt alt = (ModelAlt)this._runTable.getCell(rows[i], 2);
                if (alt == null) {
                    System.out.println("refreshData: failed to find ModelAlt in table for row " + rows[i]);
                    continue;
                }
                boolean refreshedOk = this._baseRun instanceof SimulationTrialRun ? alt.refreshDataFile(this._simulation) : alt.refreshDataFile(ClientApp.Workspace());
                if (refreshedOk) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "Refresh for " + alt.getName() + " failed", "Refresh Failed", 2);
            }
            if (this._simulation instanceof SimulationPeriod) {
                SimulationPeriod simPeriod = (SimulationPeriod)this._simulation;
                simPeriod.runExtract(simPeriod.getSimulationExtract(ClientApp.Workspace()));
            }
            this.refreshMap();
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No rows selected to refresh", "", 2);
        return false;
    }

    protected void refreshMap() {
        MapGlyph rs;
        MapGlyph rsrGlyph = ClientApp.frame().getMapPanel().findGlyphOfClass("hec.rss.client.RssSimRunGlyph");
        if (rsrGlyph == null || (rs = rsrGlyph.findGlyphOfClass("hec.rss.client.RssSystemGlyph")) != null) {
            // empty if block
        }
        ClientApp.frame().getMapPanel().paintMap();
    }

    private int[] getSelectedRows() {
        int rowCnt = this._runTable.getRowCount();
        int[] allRows = new int[rowCnt];
        int idx = 0;
        for (int i = 0; i < rowCnt; ++i) {
            String s = this._runTable.getCell(i, 0).toString();
            if (!s.equalsIgnoreCase("true")) continue;
            allRows[idx++] = i;
        }
        int[] selectedRows = new int[idx];
        System.arraycopy(allRows, 0, selectedRows, 0, idx);
        return selectedRows;
    }
}

