/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.Identifier;
import hec.model.RunTimeWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.services.tz.TimeZoneComponent;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateTimeGroup;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.text.FilenameDocument;
import rma.util.RMAIO;

public class CreateSimulationDialog
extends RmaJDialog {
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    String[] timeSteps = new String[]{"15 Minutes", "30 Minutes", "1 Hour", "3 Hours", "6 Hours", "12 Hours", "1 Day"};
    protected SimulationPeriod m_simulation = null;
    protected JLabel jLabelStartDate;
    protected JLabel jLabelStartTime;
    protected RmaJ24HourTimeField jTFStartTime;
    protected RmaJCalendarField jTFStartDate;
    protected DateTimeGroup m_StartDateGroup;
    protected JLabel jLabelLookbackDate;
    protected JLabel jLabelLookbackTime;
    protected RmaJ24HourTimeField jTFLookbackTime;
    protected RmaJCalendarField jTFLookbackDate;
    protected DateTimeGroup m_lookbackDateGroup;
    protected JLabel jLabelEndTime;
    protected JLabel jLabelEndDate;
    protected RmaJ24HourTimeField jTFEndTime;
    protected RmaJCalendarField jTFEndDate;
    protected DateTimeGroup m_endDateGroup;
    protected RmaJCheckBox computeUnRegFlowCheck;
    protected RmaJCheckBox computeResHoldoutsCheck;
    JLabel jLabelName;
    protected JLabel jLTimeStep;
    RmaJTextField jTFName;
    protected RmaJDescriptionField jTFDescription;
    protected RmaJComboBox jCBTimeStep;
    protected RmaJCheckBox runNewExtractCB;
    protected ButtonCmdPanel cmdPanel;
    protected RmaJTable alternativeTable;
    protected JButton newSimRunButton;
    protected SimulationTimePanel jPanelDatesTimes;
    private boolean _canceled = false;
    protected JPanel tablePanel;
    ReflectMultiListener _listener;
    public static final int NEW_SIMULATION = 0;
    public static final int EDIT_SIMULATION = 1;
    private String _simType = "Simulation";

    public CreateSimulationDialog(Frame frame, boolean modal) {
        super(frame, modal);
        this.setTitle("Simulation Period");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelName = new JLabel("Name");
        this.jLabelName.setDisplayedMnemonic('N');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this.jLabelName, gbc);
        this.jTFName = new RmaJTextField();
        this.jLabelName.setLabelFor((Component)this.jTFName);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.jTFName, gbc);
        JLabel label = new JLabel("Description");
        this.jLabelName.setDisplayedMnemonic('D');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.jTFDescription = new RmaJDescriptionField();
        label.setLabelFor((Component)this.jTFDescription);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.jTFDescription, gbc);
        this.jPanelDatesTimes = new SimulationTimePanel(new GridBagLayout());
        this.jPanelDatesTimes.setBorder(new TitledBorder("Simulation Times"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.jPanelDatesTimes, gbc);
        this.jLabelStartDate = new JLabel("Start Date");
        this.jLabelStartDate.setDisplayedMnemonic('S');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLabelStartDate, gbc);
        this.jTFStartDate = new RmaJCalendarField("DDMMMYYYY", "");
        this.jLabelStartDate.setLabelFor((Component)this.jTFStartDate);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jTFStartDate, gbc);
        this.jLabelStartTime = new JLabel("Time");
        this.jLabelStartTime.setDisplayedMnemonic('i');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLabelStartTime, gbc);
        this.jTFStartTime = new RmaJ24HourTimeField();
        this.jTFStartTime.setColumns(5);
        this.jLabelStartTime.setLabelFor((Component)this.jTFStartTime);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.jPanelDatesTimes.add((Component)this.jTFStartTime, gbc);
        this.m_StartDateGroup = new DateTimeGroup(this.jTFStartDate, this.jTFStartTime);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.jPanelDatesTimes.add((Component)sep, gbc);
        this.jLabelLookbackDate = new JLabel("Lookback Date");
        this.jLabelLookbackDate.setDisplayedMnemonic('L');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLabelLookbackDate, gbc);
        this.jTFLookbackDate = new RmaJCalendarField("DDMMMYYYY", "");
        this.jLabelLookbackDate.setLabelFor((Component)this.jTFLookbackDate);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jTFLookbackDate, gbc);
        this.jLabelLookbackTime = new JLabel("Time");
        this.jLabelLookbackTime.setDisplayedMnemonic('m');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLabelLookbackTime, gbc);
        this.jTFLookbackTime = new RmaJ24HourTimeField();
        this.jTFLookbackTime.setColumns(5);
        this.jLabelLookbackTime.setLabelFor((Component)this.jTFLookbackTime);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.jPanelDatesTimes.add((Component)this.jTFLookbackTime, gbc);
        this.m_lookbackDateGroup = new DateTimeGroup(this.jTFLookbackDate, this.jTFLookbackTime);
        this.jLabelEndDate = new JLabel("End Date");
        this.jLabelEndDate.setDisplayedMnemonic('E');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLabelEndDate, gbc);
        this.jTFEndDate = new RmaJCalendarField("DDMMMYYYY", "");
        this.jLabelEndDate.setLabelFor((Component)this.jTFEndDate);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        this.jPanelDatesTimes.add((Component)this.jTFEndDate, gbc);
        this.jLabelEndTime = new JLabel("Time");
        this.jLabelEndTime.setDisplayedMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLabelEndTime, gbc);
        this.jTFEndTime = new RmaJ24HourTimeField();
        this.jTFEndTime.setColumns(5);
        this.jLabelEndTime.setLabelFor((Component)this.jTFEndTime);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.jPanelDatesTimes.add((Component)this.jTFEndTime, gbc);
        this.m_endDateGroup = new DateTimeGroup(this.jTFEndDate, this.jTFEndTime);
        this.jLTimeStep = new JLabel("Time Step");
        this.jLTimeStep.setDisplayedMnemonic('T');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.jPanelDatesTimes.add((Component)this.jLTimeStep, gbc);
        this.jCBTimeStep = new RmaJComboBox((Object[])this.timeSteps);
        this.jCBTimeStep.setSelectedItem((Object)this.timeSteps[2]);
        this.jLTimeStep.setLabelFor((Component)this.jCBTimeStep);
        this.jCBTimeStep.setBorder(UIManager.getBorder("TextField.border"));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.jPanelDatesTimes.add((Component)this.jCBTimeStep, gbc);
        this.runNewExtractCB = new RmaJCheckBox("Run New Extract");
        this.runNewExtractCB.setMnemonic('r');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.jPanelDatesTimes.add((Component)this.runNewExtractCB, gbc);
        JPanel defaultComputeOptions = new JPanel(new GridBagLayout());
        defaultComputeOptions.setBorder(new TitledBorder("Default Compute Options"));
        this.computeUnRegFlowCheck = new RmaJCheckBox("Compute Unregulated Flow");
        this.computeUnRegFlowCheck.setMnemonic('u');
        this.computeUnRegFlowCheck.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        defaultComputeOptions.add((Component)this.computeUnRegFlowCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)0, (int)5, (int)5, (int)5), 0, 0));
        this.computeResHoldoutsCheck = new RmaJCheckBox("Compute Reservoir Holdouts");
        this.computeResHoldoutsCheck.setMnemonic('R');
        this.computeResHoldoutsCheck.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        defaultComputeOptions.add((Component)this.computeResHoldoutsCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.insets((int)0, (int)5, (int)5, (int)5), 0, 0));
        this.tablePanel = new JPanel(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder("Alternatives"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.tablePanel, gbc);
        this.alternativeTable = this.createSimulationTable();
        new RmaJTable((Component)((Object)this), new String[]{"Select", "Name", "Description"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 150;
                return d;
            }

            public String getToolTipText(MouseEvent e) {
                int col = CreateSimulationDialog.this.alternativeTable.columnAtPoint(e.getPoint());
                if (col == 1) {
                    // empty if block
                }
                return super.getToolTipText();
            }
        };
        this.alternativeTable.setCheckBoxCellEditor(0);
        this.alternativeTable.setAddRemoveEnabled(false);
        this.alternativeTable.setColumnEnabled(false, 1);
        this.alternativeTable.setColumnEnabled(false, 2);
        this.alternativeTable.setRowHeight(20);
        this.alternativeTable.setColumnWidths(new int[]{57, 171, 153});
        this.alternativeTable.setCellSelectionEnabled(false);
        this.alternativeTable.setColumnSelectionAllowed(false);
        this.alternativeTable.setRowSelectionAllowed(true);
        this.alternativeTable.setToolTipText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        this.tablePanel.add((Component)this.alternativeTable.getScrollPane(), gbc);
        this.newSimRunButton = new JButton("New...");
        this.newSimRunButton.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        this.tablePanel.add((Component)this.newSimRunButton, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        CreateSimulationDialog.this.jBOK_actionPerformed();
                        break;
                    }
                    case 4: {
                        CreateSimulationDialog.this.jBCancel_actionPerformed();
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CreateSimulationDialog.this.jBCancel_actionPerformed();
            }
        });
        ((JComponent)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSimulationDialog.this.enterPressed();
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
        this.jTFStartTime.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    if (CreateSimulationDialog.this.jTFStartTime.getText().equals("")) {
                        RMAIO.postError((Component)((Object)CreateSimulationDialog.this), (String)"Cannot have a blank Simulation Start Time!");
                        CreateSimulationDialog.this.jTFStartTime.requestFocus();
                        return;
                    }
                    if (!CreateSimulationDialog.this.jTFName.isModified()) {
                        HecTimeArray hTimeArray = CreateSimulationDialog.this.m_StartDateGroup.getDateTime();
                        HecTime hTime = hTimeArray.element(0);
                        CreateSimulationDialog.this.buildSimulationtDir(hTime.date(4) + ", " + hTime.time());
                    }
                }
            }
        });
        this.jTFStartDate.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    if (CreateSimulationDialog.this.jTFStartDate.getText().equals("")) {
                        RMAIO.postError((Component)((Object)CreateSimulationDialog.this), (String)"Cannot have a blank Simulation Start Date!");
                        CreateSimulationDialog.this.jTFStartDate.requestFocus();
                        return;
                    }
                    if (!CreateSimulationDialog.this.jTFName.isModified()) {
                        HecTimeArray hTimeArray = CreateSimulationDialog.this.m_StartDateGroup.getDateTime();
                        HecTime hTime = hTimeArray.element(0);
                        CreateSimulationDialog.this.buildSimulationtDir(hTime.date(4) + ", " + hTime.time());
                    }
                }
            }
        });
        FocusAdapter lookbackFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String oldLookback;
                String newLookback = CreateSimulationDialog.this.getLookbackDate();
                if (CreateSimulationDialog.this.m_simulation != null && !newLookback.equalsIgnoreCase(oldLookback = CreateSimulationDialog.this.m_simulation.getLookbackDateString())) {
                    CreateSimulationDialog.this.runNewExtractCB.setSelected(true);
                }
            }
        };
        FocusAdapter endFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String oldEnd;
                String newEnd = CreateSimulationDialog.this.getEndDate();
                if (CreateSimulationDialog.this.m_simulation != null && !newEnd.equalsIgnoreCase(oldEnd = CreateSimulationDialog.this.m_simulation.getEndDateString())) {
                    CreateSimulationDialog.this.runNewExtractCB.setSelected(true);
                }
            }
        };
        this.jTFEndDate.addFocusListener((FocusListener)endFocusListener);
        this.jTFEndTime.addFocusListener((FocusListener)endFocusListener);
        this.jTFLookbackDate.addFocusListener((FocusListener)lookbackFocusListener);
        this.jTFLookbackTime.addFocusListener((FocusListener)lookbackFocusListener);
        this.pack();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    CreateSimulationDialog.this.displayPasteTimeWindowPopup(e);
                }
            }
        };
        this.jPanelDatesTimes.addMouseListener(ml);
        this.jLabelStartDate.addMouseListener(ml);
        this.jLabelStartTime.addMouseListener(ml);
        this.jLabelLookbackDate.addMouseListener(ml);
        this.jLabelLookbackTime.addMouseListener(ml);
        this.jLabelEndDate.addMouseListener(ml);
        this.jLabelEndTime.addMouseListener(ml);
    }

    protected void displayPasteTimeWindowPopup(MouseEvent e) {
        String timeWindow = this.getClipboardTimeWindow();
        if (timeWindow == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(timeWindow, "\n");
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Paste TimeWindow");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSimulationDialog.this.pasteTimeWindow();
            }
        });
        popup.add(mi);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void pasteTimeWindow() {
        String timeWindow = this.getClipboardTimeWindow();
        StringTokenizer tokenizer = new StringTokenizer(timeWindow, "\n");
        tokenizer.nextToken();
        String lookbackTime = tokenizer.nextToken();
        String startTime = tokenizer.nextToken();
        String endTime = tokenizer.nextToken();
        this.fillTimeFields(lookbackTime, this.jTFLookbackDate, this.jTFLookbackTime);
        this.fillTimeFields(startTime, this.jTFStartDate, this.jTFStartTime);
        this.fillTimeFields(endTime, this.jTFEndDate, this.jTFEndTime);
    }

    private String getClipboardTimeWindow() {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        Transferable t = cb.getContents((Object)this);
        if (t == null) {
            return null;
        }
        String timeWindow = null;
        try {
            timeWindow = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (timeWindow == null || !timeWindow.startsWith("TimeWindow:")) {
                return null;
            }
            System.out.println("getClipboardTimeWindow:timewindow=" + timeWindow);
        }
        catch (Exception e) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(timeWindow, "\n");
        if (tokenizer.countTokens() != 4) {
            return null;
        }
        return timeWindow;
    }

    private void fillTimeFields(String timeString, RmaJCalendarField dateFld, RmaJ24HourTimeField timeFld) {
        if (timeString == null) {
            return;
        }
        int idx = timeString.indexOf(",");
        if (idx == -1) {
            return;
        }
        String date = timeString.substring(0, idx);
        String time = timeString.substring(idx + 1);
        dateFld.setText(date);
        timeFld.setText(time);
    }

    protected RmaJTable createSimulationTable() {
        RmaJTable table = new RmaJTable((Component)((Object)this), new String[]{"Select", "Name", "Description"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 150;
                return d;
            }
        };
        table.setCheckBoxCellEditor(0);
        table.setAddRemoveEnabled(false);
        table.setColumnEnabled(false, 1);
        table.setColumnEnabled(false, 2);
        table.setRowHeight(20);
        table.setColumnWidths(new int[]{57, 171, 153});
        table.setCellSelectionEnabled(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setToolTipText("");
        return table;
    }

    public CreateSimulationDialog(Frame frame, boolean modal, String sTitle) {
        this(frame, modal);
        this.setTitle(sTitle);
    }

    public CreateSimulationDialog(Frame owner, String title, boolean modal) {
        this(owner, modal);
        this.setTitle(title);
    }

    public CreateSimulationDialog() {
        this(null, "", false);
    }

    public CreateSimulationDialog(Frame frame, boolean modal, String sTitle, String simType) {
        this(frame, modal);
        this._simType = simType;
        this.setTitle(sTitle);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocation();
        } else {
            this.jTFName.setModified(false);
        }
        super.setVisible(b);
    }

    public void setEditMode(int editMode) {
        if (editMode != 0 && editMode != 1) {
            System.out.println("Invalide Edit Mode (" + editMode + ") Defaulting to NEW SIMULATION MODE");
            editMode = 0;
        }
        if (editMode == 0) {
            this.runNewExtractCB.setSelected(true);
            this.runNewExtractCB.setEnabled(false);
            this.jTFStartDate.setEditable(true);
            this.jTFStartTime.setEditable(true);
            this.jTFName.setEditable(true);
            this.jTFName.setDocument((Document)new FilenameDocument());
        } else {
            this.runNewExtractCB.setSelected(false);
            this.runNewExtractCB.setEnabled(true);
            this.jTFStartDate.setEditable(false);
            this.jTFStartTime.setEditable(false);
            this.jTFName.setEditable(false);
            this.jTFName.setDocument((Document)new PlainDocument());
        }
    }

    public void setDefaultTimeStep(String timeStep) {
        if (timeStep == null) {
            this.jCBTimeStep.setSelectedIndex(-1);
        } else {
            this.jCBTimeStep.setSelectedItem((Object)timeStep);
        }
    }

    public String getStartDate() {
        HecTimeArray array = this.m_StartDateGroup.getDateTime();
        return array.element(0).date(4) + "," + RMAIO.removeChar((String)array.element(0).time(), (char)':');
    }

    public String getEndDate() {
        HecTimeArray array = this.m_endDateGroup.getDateTime();
        return array.element(0).date(4) + "," + RMAIO.removeChar((String)array.element(0).time(), (char)':');
    }

    public String getLookbackDate() {
        HecTimeArray array = this.m_lookbackDateGroup.getDateTime();
        return array.element(0).date(4) + "," + RMAIO.removeChar((String)array.element(0).time(), (char)':');
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getName() {
        return this.jTFName.getText();
    }

    public String getDescription() {
        return this.jTFDescription.getText();
    }

    public int getTimestep() {
        int idx;
        String ts = (String)this.jCBTimeStep.getSelectedItem();
        int timeStep = 1;
        if (ts != null && (idx = ts.indexOf(32)) > -1) {
            ts = ts.substring(0, idx);
            timeStep = RMAIO.parseInt((String)ts, (int)1);
        }
        return timeStep;
    }

    public int getTimeStepType() {
        int idx;
        String ts = (String)this.jCBTimeStep.getSelectedItem();
        int incType = 2;
        if (ts != null && (idx = ts.indexOf(32)) > -1) {
            if ((ts = ts.substring(idx).trim()).equalsIgnoreCase("Hour")) {
                incType = 2;
            } else if (ts.equalsIgnoreCase("Hours")) {
                incType = 2;
            } else if (ts.equalsIgnoreCase("Minute")) {
                incType = 1;
            } else if (ts.equalsIgnoreCase("Minutes")) {
                incType = 1;
            } else if (ts.equalsIgnoreCase("Day")) {
                incType = 3;
            } else if (ts.equalsIgnoreCase("Second")) {
                incType = 0;
            }
        }
        return incType;
    }

    public String[] getSelectedRuns() {
        Vector cells = this.alternativeTable.getCells();
        Vector<String> selections = new Vector<String>();
        for (int i = 0; i < cells.size(); ++i) {
            Vector row = (Vector)cells.elementAt(i);
            Object obj = row.elementAt(0);
            String shouldAddRow = obj.toString();
            if (!shouldAddRow.equalsIgnoreCase("true")) continue;
            obj = row.elementAt(1);
            if (obj instanceof ManagerProxy) {
                obj = ((ManagerProxy)obj).getName();
            } else if (obj instanceof SimulationRun) {
                obj = ((SimulationRun)((Object)obj)).getName();
            } else if (obj instanceof AltName) {
                obj = ((AltName)obj).name;
            }
            if (!(obj instanceof String)) continue;
            String runName = (String)obj;
            selections.addElement(runName);
            System.out.println("selected alt is " + runName);
        }
        selections.trimToSize();
        Object[] names = new String[selections.size()];
        selections.copyInto(names);
        return names;
    }

    public void fillForm(SimulationPeriod simulation) {
        String type;
        String simRunClass = simulation.getSimulationRunClass();
        String model = simulation.getSimulationAppType();
        if (simulation == null) {
            return;
        }
        ClientWorkspace wksp = ClientApp.Workspace();
        this.m_simulation = simulation;
        this.jTFName.setText(simulation.getName());
        this.jTFDescription.setText(simulation.getDescription());
        RunTimeWindow rtw = simulation.getRunTimeWindow();
        this.m_StartDateGroup.setDateTime(rtw.getStartTime(), simulation.getGmtOffset());
        this.m_endDateGroup.setDateTime(rtw.getEndTime(), simulation.getGmtOffset());
        this.m_lookbackDateGroup.setDateTime(rtw.getLookbackTime(), simulation.getGmtOffset());
        this.alternativeTable.setNumRows(0);
        String[] altNames = simulation.getAlternatives();
        if (Boolean.getBoolean("useSimulationManagers")) {
            Vector<Identifier> altIds = wksp.getManagerIDList(model, simRunClass);
            if (altIds == null || altIds.size() == 0) {
                return;
            }
            for (int i = 0; i < altIds.size(); ++i) {
                Identifier id = altIds.elementAt(i);
                SimulationRun alternative = (SimulationRun)wksp.openManager(model, id);
                if (alternative == null) continue;
                boolean found = false;
                for (int j = 0; altNames != null && j < altNames.length; ++j) {
                    if (altNames[j] == null || !altNames[j].equals(alternative.getName())) continue;
                    found = true;
                    break;
                }
                this.addRow(found, alternative);
                wksp.unloadManager(model, alternative.getIdentifier());
            }
        } else {
            Vector<ManagerProxy> altProxies = wksp.getManagerProxyList(model, simRunClass);
            if (altProxies == null || altProxies.size() == 0) {
                return;
            }
            for (int i = 0; i < altProxies.size(); ++i) {
                ManagerProxy proxy = altProxies.elementAt(i);
                if (proxy == null) continue;
                boolean found = false;
                for (int j = 0; altNames != null && j < altNames.length; ++j) {
                    if (altNames[j] == null || !altNames[j].equals(proxy.getName())) continue;
                    found = true;
                    break;
                }
                this.addRow(found, proxy);
            }
        }
        int time = simulation.getTimestep();
        switch (simulation.getTimeIncrementType()) {
            case 3: {
                type = time == 1 ? "Day" : "Days";
                break;
            }
            case 2: {
                type = time == 1 ? "Hour" : "Hours";
                break;
            }
            case 1: {
                type = time == 1 ? "Minute" : "Minutes";
                break;
            }
            default: {
                type = "Hour";
            }
        }
        this.jCBTimeStep.setSelectedItem((Object)(time + " " + type));
    }

    protected void addRow(boolean found, ManagerProxy proxy) {
        Vector<Object> row = new Vector<Object>(3);
        if (found) {
            row.addElement(true);
        } else {
            row.addElement(false);
        }
        AltName altName = new AltName(proxy.getName(), this.getUserName(proxy.getName()));
        row.addElement(altName);
        row.addElement(RMAIO.replace((String)proxy.getDescription(), (String)"(Simulation Run)", (String)""));
        this.alternativeTable.appendRow(row);
    }

    protected void addRow(boolean found, SimulationRun alternative) {
        Vector<Object> row = new Vector<Object>(3);
        if (found) {
            row.addElement(true);
        } else {
            row.addElement(false);
        }
        row.addElement((Object)alternative);
        row.addElement(alternative.getDescription());
        this.alternativeTable.appendRow(row);
    }

    public void fillForm(String model, String runClassName) {
        this.m_simulation = null;
        ClientWorkspace wksp = ClientApp.Workspace();
        this.jCBTimeStep.setSelectedItem((Object)this.timeSteps[2]);
        GregorianCalendar cal = new GregorianCalendar();
        int year = cal.get(1);
        String month = String.valueOf(cal.get(2) + 1);
        String day = String.valueOf(cal.get(5));
        String hours = String.valueOf(cal.get(11));
        String minutes = String.valueOf(cal.get(12));
        String time = (String)(hours.length() == 1 ? "0" + hours : hours) + (String)(minutes.length() == 1 ? "0" + minutes : minutes);
        String date = (String)(month.length() == 1 ? "0" + month : month) + "/" + (String)(day.length() == 1 ? "0" + day : day) + "/" + String.valueOf(year);
        String simDateTime = date + ", " + time;
        HecTime hTime = new HecTime(simDateTime);
        String startDate = hTime.date(4);
        String startTime = hTime.time().substring(0, 2) + "00";
        Date tempDate = new HecTime(startDate + ", " + startTime).getJavaDate(0);
        HecTime hStartDateTime = new HecTime(tempDate, 0);
        this.m_StartDateGroup.setDateTime(hStartDateTime, wksp.getTimeZone());
        this.m_lookbackDateGroup.setDateTime(hStartDateTime, wksp.getTimeZone());
        this.m_endDateGroup.setDateTime(hStartDateTime, wksp.getTimeZone());
        this.m_StartDateGroup.setDisplayTimeZone(ClientApp.app().getClientTimeZone());
        this.m_lookbackDateGroup.setDisplayTimeZone(ClientApp.app().getClientTimeZone());
        this.m_endDateGroup.setDisplayTimeZone(ClientApp.app().getClientTimeZone());
        this.buildSimulationtDir(hStartDateTime.date(4) + ", " + RMAIO.removeChar((String)hStartDateTime.time(), (char)':'));
        this.jTFDescription.setText("");
        this.alternativeTable.setNumRows(0);
        this.fillAlternativeTable(model, runClassName);
    }

    public void fillAlternativeTable(String model, String runClassName) {
        ClientWorkspace wksp = ClientApp.Workspace();
        if (Boolean.getBoolean("useSimulationManagers")) {
            Vector<Identifier> altIds = wksp.getManagerIDList(model, runClassName);
            this.alternativeTable.deleteCells();
            if (altIds == null || altIds.size() == 0) {
                return;
            }
            for (int i = 0; i < altIds.size(); ++i) {
                Identifier id = altIds.elementAt(i);
                Manager mgr = wksp.openManager(model, id);
                if (!(mgr instanceof SimulationRun)) continue;
                this.addRow(false, (SimulationRun)mgr);
                wksp.unloadManager(model, mgr.getIdentifier());
            }
        } else {
            Vector<ManagerProxy> altProxies = wksp.getManagerProxyList(model, runClassName);
            if (altProxies == null || altProxies.size() == 0) {
                return;
            }
            this.alternativeTable.deleteCells();
            for (int i = 0; i < altProxies.size(); ++i) {
                ManagerProxy proxy = altProxies.elementAt(i);
                this.addRow(false, proxy);
            }
        }
    }

    public String getUserName(String name) {
        char[] namearray = name.toCharArray();
        char[] newNamearray = new char[namearray.length];
        boolean noValidFound = true;
        for (int i = namearray.length - 1; i >= 0; --i) {
            if (namearray[i] == '-' && noValidFound) continue;
            newNamearray[i] = namearray[i];
            noValidFound = false;
        }
        int length = 0;
        for (length = 0; length < newNamearray.length && newNamearray[length] != '\u0000'; ++length) {
        }
        char[] newName = new char[length];
        System.arraycopy(newNamearray, 0, newName, 0, length);
        return new String(newName);
    }

    public void jBOK_actionPerformed() {
        if (this.validForm()) {
            this._canceled = false;
            this.setVisible(false);
        }
    }

    public void jBCancel_actionPerformed() {
        this._canceled = true;
        this.setVisible(false);
    }

    public boolean computeReservoirHoldouts() {
        return this.computeResHoldoutsCheck.isSelected();
    }

    public boolean computeUnRegulatedFlow() {
        return this.computeUnRegFlowCheck.isSelected();
    }

    public boolean runSimulationExtract() {
        return this.runNewExtractCB.isSelected();
    }

    private String getSimulationDirectory() {
        return this.jTFName.getText();
    }

    private void buildSimulationtDir(String fName) {
        HecTime hecTime = new HecTime(fName);
        String dt = Integer.toString(hecTime.isoDate());
        Object tm = Integer.toString(hecTime.isoTime() / 100);
        int tlen = ((String)tm).length();
        for (int it = 0; it < 4 - tlen; ++it) {
            tm = "0" + (String)tm;
        }
        StringBuffer sb = new StringBuffer(dt + "-" + (String)tm);
        sb.insert(4, ".");
        sb.insert(7, ".");
        this.jTFName.setText("" + sb);
    }

    private boolean validSimulationDate(String fName) {
        String msg = "Simulation Date must be the format 'ddMMMCCYY'(14Jan1999)";
        if (fName == null || fName.equals("") || fName.length() != 9) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg + "0", "Error", 0);
            return false;
        }
        block5: for (int i = 0; i < fName.length(); ++i) {
            char ch = fName.charAt(i);
            switch (i) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (Character.isDigit(ch)) continue block5;
                    JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg + "1", "Error", 0);
                    return false;
                }
                case 3: 
                case 4: {
                    continue block5;
                }
                case 2: {
                    String mon = fName.substring(2, 5);
                    for (int j = 0; j < this.months.length; ++j) {
                        if (!mon.equalsIgnoreCase(this.months[j])) continue;
                        return true;
                    }
                    JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg + "2", "Error", 0);
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validSimulationTime(String fName, String field) {
        int num;
        String msg = field + " time must be the format 'hhmm'(1300) and end on the hour";
        String msg2 = field + " time must be between 0000 and 2400";
        if (fName == null || fName.equals("") || fName.length() < 4) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg, "Error", 0);
            return false;
        }
        try {
            num = new Integer(fName);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg, "Error", 0);
            return false;
        }
        if (num < 0 || num > 2400) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg2, "Error", 0);
            return false;
        }
        if (num % 100 != 0) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), msg, "Error", 0);
            return false;
        }
        return true;
    }

    private void enterPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b == null) {
            return;
        }
        b.doClick();
    }

    protected boolean validForm() {
        if (!this.validTimeWindow()) {
            return false;
        }
        if (this.m_simulation == null) {
            Identifier id;
            String name = this.jTFName.getText();
            Vector<Identifier> idList = ClientApp.Workspace().getManagerIDList(ClientApp.app().getAppType(), "hec.clientapp.model.SimulationPeriod");
            for (int i = 0; i < idList.size(); ++i) {
                id = idList.get(i);
                if (!name.equalsIgnoreCase(id.getName())) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), this._simType + " Period " + name + " already exists.  Please enter a new name", "Duplication " + this._simType + " Name", 2);
                this.jTFName.requestFocus();
                return false;
            }
            if (name == null || name.equals("")) {
                RMAIO.postError((Component)((Object)this), (String)("Invalid " + this._simType + " Name"));
                return false;
            }
            String simulationDir = ClientApp.Workspace().getWorkspacePath().concat("/").concat(ClientApp.app().getAppType()).concat("/").concat(RMAIO.userNameToFileName((String)this.getSimulationDirectory()));
            id = new Identifier(simulationDir);
            id._directory = true;
            RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            try {
                if (fm.fileExists(id.getPath())) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Directory Structure\n\n" + simulationDir + "\n\nfor " + this._simType + " " + this.getName() + " already exists.\n\nUse " + this._simType + " Open if you want use this " + this._simType + " date/time again.", "New " + this._simType + " Error", 2);
                    return false;
                }
            }
            catch (RemoteException re) {
                System.out.println("validForm: RMI Error checking existance of directory " + id);
            }
        }
        if (this.getSelectedRuns().length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "There must be at least one alternative selected for the " + this._simType + ".", this._simType + " Error", 2);
            return false;
        }
        return true;
    }

    protected boolean validTimeWindow() {
        RunTimeWindow runtimewindow = new RunTimeWindow();
        String dateandtime = this.getLookbackDate();
        dateandtime = dateandtime.replace(',', ' ');
        runtimewindow.setLookbackTime(dateandtime);
        dateandtime = this.getStartDate();
        dateandtime = dateandtime.replace(',', ' ');
        runtimewindow.setStartTime(dateandtime);
        dateandtime = this.getEndDate();
        dateandtime = dateandtime.replace(',', ' ');
        runtimewindow.setEndTime(dateandtime);
        if (runtimewindow.getStartTime().lessThanEqualTo(runtimewindow.getLookbackTime())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Simulation Start Date must be after Lookback Date", "Time Window Error", 0);
            return false;
        }
        if (runtimewindow.getEndTime().lessThanEqualTo(runtimewindow.getStartTime())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Simulation End Date must be after Start Date", "Time Window Error", 0);
            return false;
        }
        return true;
    }

    public void setTitle(String title) {
        int idx;
        TitledBorder border;
        super.setTitle(title);
        if (this.jPanelDatesTimes != null && (border = (TitledBorder)this.jPanelDatesTimes.getBorder()) != null && (idx = title.indexOf(" ")) > -1) {
            title = title.substring(0, idx);
            border.setTitle(title + " Times");
        }
    }

    public void setTablePanelBorderTitle(String title) {
        if (title == null) {
            return;
        }
        this.tablePanel.setBorder(new TitledBorder(title));
    }

    public void configureNewSimRunButton(Object methodContainer, String method) {
        if (this._listener == null) {
            this._listener = new ReflectMultiListener();
        } else {
            this.newSimRunButton.removeActionListener((ActionListener)this._listener);
        }
        this.newSimRunButton.addActionListener((ActionListener)this._listener.add(methodContainer, (Object)this.newSimRunButton, method));
        this.newSimRunButton.setVisible(true);
        this.pack();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        CreateSimulationDialog dlg = new CreateSimulationDialog(null, true);
        dlg.setLocation(100, 100);
        dlg.setVisible(true);
        System.exit(0);
    }

    protected class SimulationTimePanel
    extends JPanel
    implements TimeZoneComponent {
        public SimulationTimePanel(LayoutManager layout) {
            super(layout);
        }

        public void setTimeZone(TimeZone tz) {
            CreateSimulationDialog.this.m_StartDateGroup.setDisplayTimeZone(tz);
            CreateSimulationDialog.this.m_lookbackDateGroup.setDisplayTimeZone(tz);
            CreateSimulationDialog.this.m_endDateGroup.setDisplayTimeZone(tz);
        }

        public TimeZone getTimeZone() {
            return null;
        }
    }

    public class AltName {
        public String name;
        public String userName;

        public AltName(String nm, String unm) {
            this.name = nm;
            this.userName = unm;
        }

        public String toString() {
            return this.userName;
        }
    }
}

