/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.TrialRun;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.lang.WorkspaceNameFactory;
import hec.model.AltItem;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.ModelConstants;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.JButtonGroup;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class CreateTrialRunDialog
extends RmaJDialog
implements ModelConstants,
ItemListener {
    protected static final String NEW_MODEL_TRIAL_ITEM = "New";
    private static final int TRIAL_NUMBER_POS = 11;
    private RmaJTextField simulationTxt;
    private RmaJTextField simulationRunTxt;
    private RmaJTextField configurationTxt;
    private RmaJTextField trialRunNameTxt;
    protected RmaJTextField trialKeyTxt;
    protected RmaJComboBox modelCombo;
    protected RmaJComboBox trialCombo;
    protected ButtonCmdPanel cmdPanel;
    protected JLabel simulationLabel;
    protected JLabel simulationRunLabel;
    protected RmaJRadioButton _newTrialRadio;
    protected JLabel _newTrialBaseLabel;
    protected RmaJRadioButton _useExistingRadio;
    private boolean _canceled = false;
    private boolean _useDefaultName = true;
    private Simulation _simulation;
    private TrialRun _baseTrial;
    private TrialRun _newTrial;
    private SimulationRun _run;
    private Vector _modelOrder = null;
    private Vector _altList = null;
    private Vector _labelList = new Vector();
    private Color _cbDisabledColor;
    private ItemListener _trialComboListener;
    private Vector _dashList = new Vector(1);
    private int _trialNumPos = 11;
    protected Vector _usedTrialList = new Vector();

    public CreateTrialRunDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this._dashList.add("--");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Create Trial Run");
        this.simulationLabel = new JLabel("Simulation:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this.simulationLabel, gbc);
        this.simulationTxt = new RmaJTextField(20);
        this.simulationTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.simulationTxt, gbc);
        this.simulationRunLabel = new JLabel("SimulationRun Run:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this.simulationRunLabel, gbc);
        this.simulationRunTxt = new RmaJTextField();
        this.simulationRunTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.simulationRunTxt, gbc);
        JLabel label = new JLabel("Configuration:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.configurationTxt = new RmaJTextField();
        this.configurationTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.configurationTxt, gbc);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)sep, gbc);
        label = new JLabel("Key:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.trialKeyTxt = new RmaJTextField();
        this.trialKeyTxt.setEditable(false);
        this.trialKeyTxt.setTrimWhiteSpace(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.trialKeyTxt, gbc);
        label = new JLabel("Trial Name:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.trialRunNameTxt = new RmaJTextField();
        this.trialRunNameTxt.setEditable(false);
        this.trialRunNameTxt.setTrimWhiteSpace(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.trialRunNameTxt, gbc);
        label = new JLabel("Model:", 4);
        label.setDisplayedMnemonic('M');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)label, gbc);
        this.modelCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false));
        label.setLabelFor((Component)this.modelCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.modelCombo, gbc);
        this._newTrialRadio = new RmaJRadioButton("New Trial based on:");
        this._newTrialRadio.setMnemonic('N');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._newTrialRadio, gbc);
        this._newTrialBaseLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)8, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._newTrialBaseLabel, gbc);
        this._useExistingRadio = new RmaJRadioButton("Use Existing Trial:");
        this._useExistingRadio.setMnemonic('E');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this._useExistingRadio, gbc);
        this.trialCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.trialCombo, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.trialRunNameTxt.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ke) {
                CreateTrialRunDialog.this._useDefaultName = false;
            }
        });
        this.trialRunNameTxt.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (CreateTrialRunDialog.this.trialRunNameTxt.getText().length() == 0) {
                    String trialName = CreateTrialRunDialog.this.getNewTrialName(false);
                    if (trialName == null) {
                        trialName = "";
                    }
                    CreateTrialRunDialog.this.trialRunNameTxt.setText(trialName);
                    CreateTrialRunDialog.this._useDefaultName = true;
                }
            }
        });
        this.modelCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                CreateTrialRunDialog.this.trialRunNameTxt.setText("");
                if (CreateTrialRunDialog.this._baseTrial != null) {
                    CreateTrialRunDialog.this.trialKeyTxt.setText(CreateTrialRunDialog.this._baseTrial.getTrialKey());
                } else {
                    CreateTrialRunDialog.this.trialKeyTxt.setText(CreateTrialRunDialog.this._run.getName());
                }
                CreateTrialRunDialog.this.updateTrialCombo();
                if (CreateTrialRunDialog.this._newTrialRadio.isSelected()) {
                    CreateTrialRunDialog.this.newTrialRadioAction();
                }
            }
        });
        this._trialComboListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                CreateTrialRunDialog.this.setTrialNameAndKey();
            }
        };
        this.trialCombo.addItemListener(this._trialComboListener);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!CreateTrialRunDialog.this.saveForm()) break;
                        CreateTrialRunDialog.this._canceled = false;
                        CreateTrialRunDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        CreateTrialRunDialog.this._canceled = true;
                        CreateTrialRunDialog.this.setVisible(false);
                    }
                }
            }
        });
        JButtonGroup bg = new JButtonGroup();
        bg.add((AbstractButton)this._useExistingRadio);
        bg.add((AbstractButton)this._newTrialRadio);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == CreateTrialRunDialog.this._newTrialRadio) {
                    CreateTrialRunDialog.this.newTrialRadioAction();
                } else if (src == CreateTrialRunDialog.this._useExistingRadio) {
                    CreateTrialRunDialog.this.useExistingRadioAction();
                }
            }
        };
        this._newTrialRadio.addActionListener(al);
        this._useExistingRadio.addActionListener(al);
        this.pack();
        this.setLocation();
    }

    public void newTrialRadioAction() {
        this.trialCombo.setEnabled(false);
        this.setTrialNameAndKey();
    }

    public void useExistingRadioAction() {
        this.trialCombo.setEnabled(true);
        this.setTrialNameAndKey();
    }

    protected void setTrialNameAndKey() {
        if (this._useDefaultName) {
            String trialName = this.getNewTrialName(false);
            if (trialName == null) {
                trialName = "";
            }
            this.trialRunNameTxt.setText(trialName);
        }
        this.setTrialKey();
    }

    public void setSimulation(Simulation f) {
        this._simulation = f;
        if (this._simulation != null) {
            this.simulationTxt.setText(f.getName());
        }
    }

    public void setBaseTrial(TrialRun trial) {
        this._baseTrial = trial;
        if (this._baseTrial != null) {
            this._run = this._baseTrial.getRunParent();
            this.trialKeyTxt.setText(this._baseTrial.getTrialKey());
            this._newTrialBaseLabel.setText(this._baseTrial.getTrialKey());
        }
    }

    public void setSimulationRun(SimulationRun run) {
        this._run = run;
        this.trialKeyTxt.setText(run.getName());
        this.modelCombo.setEnabled(true);
        this.trialCombo.setEnabled(false);
        this._trialNumPos = this._run.getModelNameLength();
        this._newTrialBaseLabel.setText(run.getKey());
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void fillForm() {
        this._useDefaultName = true;
        try {
            SupplementalRmiWorkspace smWksp = (SupplementalRmiWorkspace)ClientApp.Workspace().getChildWorkspace("supplemental");
            if (smWksp != null) {
                this._modelOrder = smWksp.getOrderedModels();
            }
        }
        catch (RemoteException re) {
            System.out.println("createAlternativePanel: failed to get model execution order from Supplemental RmiWorkspace " + re);
        }
        this.fillModelCombo(this._run);
        if (this._baseTrial != null) {
            this.modelCombo.setSelectedIndex(this._baseTrial.getTrialPosition());
            this.modelCombo.setEnabled(false);
        }
        this.cmdPanel.getButton(8).setEnabled(false);
    }

    private void fillModelCombo(SimulationRun run) {
        DataObject c;
        RmaListModel model = (RmaListModel)this.modelCombo.getModel();
        model.clear();
        if (run == null) {
            return;
        }
        this.configurationTxt.setText("");
        this.simulationRunTxt.setText(run.getUserName());
        CommonDataList cdl = ClientApp.Workspace().getCommonDataList("hec.watershed.model.Condition", "");
        if (cdl != null && run.getConfigurationId() != -1L && (c = cdl.findObjectById(run.getConfigurationId(), "hec.watershed.model.Condition")) != null) {
            this.configurationTxt.setText(c.getName());
        }
        this._altList = run.getAltList();
        if (this._altList == null || this._altList.size() < 1) {
            return;
        }
        ClientWorkspace wksp = ClientApp.Workspace();
        boolean hasButton = false;
        int i = 0;
        Object trialList = null;
        Vector<ProgramOrderItem> poiList = new Vector<ProgramOrderItem>();
        for (i = 0; i < this._altList.size(); ++i) {
            AltItem altItem = (AltItem)this._altList.elementAt(i);
            if (altItem == null) continue;
            ProgramOrderItem poi = this.getProgramOrderItem(altItem);
            Object labelName = poi != null ? (poi.isStandardModel() ? poi.getDescription() + " (" + poi.toString() + ")" : poi.getName()) : altItem.getProgram();
            if (poi == null) continue;
            poiList.addElement(poi);
        }
        model.setAll(poiList);
        if (model.getSize() == 1) {
            this.modelCombo.setSelectedIndex(0);
        }
    }

    private void updateTrialCombo() {
        Vector trialList;
        this.trialCombo.removeItemListener(this._trialComboListener);
        int idx = this.modelCombo.getSelectedIndex();
        RmaListModel model = (RmaListModel)this.trialCombo.getModel();
        model.clear();
        if (idx < 0) {
            model.addAll((Collection)this._dashList);
            this.trialCombo.setSelectedIndex(0);
            this.trialCombo.setEnabled(false);
            String trialName = this.getNewTrialName(false);
            if (trialName == null) {
                trialName = "";
            }
            this.trialRunNameTxt.setText(trialName);
            this.trialRunNameTxt.setEditable(false);
            return;
        }
        AltItem altItem = (AltItem)this._altList.elementAt(idx);
        if (altItem == null) {
            return;
        }
        if (altItem.getAltIndex() == -1) {
            trialList = this._dashList;
        } else {
            ModelAlt alt = this._run.getModelAlt(altItem.getProgram());
            if (alt != null) {
                this._usedTrialList = this._simulation.getModelTrials(altItem.getProgram(), alt.getAltId());
                trialList = this._simulation.getUnusedModelTrials(altItem.getProgram(), alt.getAltId());
            } else {
                trialList = null;
            }
        }
        model.addAll((Collection)trialList);
        if (trialList.size() == 0) {
            this._useExistingRadio.setEnabled(false);
            this._newTrialRadio.doClick(0);
            this.trialRunNameTxt.setEditable(true);
        } else if (trialList == this._dashList) {
            this.trialCombo.setSelectedIndex(0);
            this.trialCombo.setEnabled(false);
            this.trialRunNameTxt.setText("");
            this.trialRunNameTxt.setEditable(false);
        } else {
            this.trialRunNameTxt.setEditable(true);
            this.trialCombo.setSelectedIndex(-1);
            if (this._useExistingRadio.isSelected()) {
                this.cmdPanel.getButton(8).setEnabled(false);
            }
        }
        this.trialCombo.addItemListener(this._trialComboListener);
    }

    public ProgramOrderItem getProgramOrderItem(AltItem altItem) {
        if (altItem == null) {
            return null;
        }
        String programName = altItem.getProgram();
        if (programName == null) {
            return null;
        }
        if ((programName = WorkspaceNameFactory.getWorkspaceName((String)programName)).equalsIgnoreCase("RSS")) {
            return ProgramOrderItem.RSS_MODEL;
        }
        if (programName.equalsIgnoreCase("RAS")) {
            return ProgramOrderItem.RAS_MODEL;
        }
        if (programName.equalsIgnoreCase("FIA")) {
            return ProgramOrderItem.FIA_MODEL;
        }
        if (programName.equalsIgnoreCase("ResPRM")) {
            return ProgramOrderItem.RESPRM_MODEL;
        }
        if (programName.equalsIgnoreCase("rma")) {
            programName = altItem.getProgram();
            if (programName.equalsIgnoreCase(ProgramOrderItem.HEC5Q_MODEL.getName())) {
                return ProgramOrderItem.HEC5Q_MODEL;
            }
            if (programName.equalsIgnoreCase(ProgramOrderItem.RMA2_MODEL.getName())) {
                return ProgramOrderItem.RMA2_MODEL;
            }
            if (programName.equalsIgnoreCase(ProgramOrderItem.RMA11_MODEL.getName())) {
                return ProgramOrderItem.RMA11_MODEL;
            }
            return null;
        }
        if (this._modelOrder == null) {
            return null;
        }
        for (int i = 0; i < this._modelOrder.size(); ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)this._modelOrder.elementAt(i);
            if (poi == null || !poi.getName().equals(programName)) continue;
            return poi;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveForm() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Vector trialNames = this._simulation.getTrialRunNames();
            String newTrialname = this.getNewTrialName(false);
            if (newTrialname == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You have reached the maximum allowable number of trials for " + this.simulationRunTxt.getText() + ". If you would like to build another trial for this alternative, you must first delete one of the existing trials.", "Maximum Trial Limit", 2);
                boolean bl = false;
                return bl;
            }
            if (trialNames.contains(newTrialname)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "A Trial corresponding to " + newTrialname + " already exists.", "Duplicate Trial", 0);
                boolean bl = false;
                return bl;
            }
            int modelPosition = this.modelCombo.getSelectedIndex();
            ClientMode mode = ClientApp.frame().getCurrentMode();
            if (mode instanceof AbstractSimulationMode) {
                ((AbstractSimulationMode)mode).saveSimulation();
            }
            this._newTrial = this._simulation.createNewTrialRun(newTrialname, this.trialRunNameTxt.getText(), this.trialKeyTxt.getText(), this._run, this._baseTrial, modelPosition);
            boolean bl = this._newTrial != null;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public TrialRun getNewTrialRun() {
        return this._newTrial;
    }

    public SimulationRun getRun() {
        return this._run;
    }

    protected void setTrialKey() {
        int idx = this.modelCombo.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        idx *= this._trialNumPos;
        String s = this.getNewTrialName(true);
        if (s == null) {
            return;
        }
        String trialKey = this.trialKeyTxt.getText();
        if (trialKey.length() < idx + this._trialNumPos) {
            return;
        }
        char[] array = trialKey.toCharArray();
        System.out.println("setTrialKey:trialKey=[" + trialKey + "]");
        array[idx + 10] = s.charAt(this._trialNumPos - 1);
        this.trialKeyTxt.setText(new String(array));
    }

    public String getNewTrialName(boolean onlyModelPart) {
        ProgramOrderItem poi = (ProgramOrderItem)this.modelCombo.getSelectedItem();
        String selection = this._useExistingRadio.isSelected() ? (String)this.trialCombo.getSelectedItem() : NEW_MODEL_TRIAL_ITEM;
        if (poi == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select the model to create the new trial from.", "No Model Selected", 2);
            this.modelCombo.requestFocus();
            return null;
        }
        if (selection == null) {
            this.cmdPanel.getButton(8).setEnabled(false);
            this.trialCombo.requestFocus();
            return null;
        }
        this.cmdPanel.getButton(8).setEnabled(true);
        StringBuffer buf = new StringBuffer();
        if (!onlyModelPart) {
            buf.append(poi.toString());
            buf.append(" trial ");
        }
        int last = 0;
        String[] usedTrialNumbers = new String[10];
        if (this._newTrialRadio.isSelected()) {
            int size2 = this._usedTrialList.size();
            for (int ii = 0; ii < size2; ++ii) {
                String item = (String)this._usedTrialList.get(ii);
                if (item.equals(NEW_MODEL_TRIAL_ITEM)) continue;
                int curr = RMAIO.parseInt((String)item.substring(this._trialNumPos - 1));
                usedTrialNumbers[curr] = "x";
                last = Math.max(curr, last);
            }
            if (++last > 9) {
                for (int i = 0; i < usedTrialNumbers.length; ++i) {
                    if (usedTrialNumbers[i] != null) continue;
                    last = i;
                    break;
                }
                if (last > 9) {
                    return null;
                }
            }
            buf.append(this._newTrialBaseLabel.getText().substring(0, this._trialNumPos - 1) + last);
        } else {
            buf.append(selection);
        }
        return buf.toString();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        if (this._useDefaultName) {
            this.trialRunNameTxt.setText(this.getNewTrialName(false));
        }
        if (this.isVisible()) {
            this.updateComboState((JComboBox)e.getSource());
        }
    }

    private void updateComboState(JComboBox cb) {
        if (cb == null) {
            return;
        }
        Object obj = cb.getSelectedItem();
        if (obj == null) {
            return;
        }
        boolean enabled = this._useExistingRadio.isSelected();
        for (int i = 0; i < this._labelList.size(); ++i) {
            JLabel label = (JLabel)this._labelList.get(i);
            JComboBox box = (JComboBox)label.getLabelFor();
            if (box.getItemCount() <= 1 || box == cb) continue;
            box.setEnabled(enabled);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this._cbDisabledColor = UIManager.getColor("ComboBox.disabledForeground");
            UIManager.put("ComboBox.disabledForeground", Color.black);
            this._newTrialRadio.doClick(0);
        } else if (this._cbDisabledColor != null) {
            UIManager.put("ComboBox.disabledForeground", this._cbDisabledColor);
        }
        super.setVisible(b);
    }
}

