/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.util.DssDefaultFileVersionInfo;
import hec.clientapp.util.DssUtilities;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;

public class DSSPropertiesPanel
extends RmaJPanel {
    private JLabel _dssVersionLabel;
    private JLabel _dssDefaultVersionLabel;
    private JLabel _dssDateLabel;

    public DSSPropertiesPanel() {
        super((LayoutManager)new GridBagLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        JLabel dssVersionsLabel = new JLabel("DSS Version: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add(dssVersionsLabel, gbc);
        this._dssVersionLabel = new JLabel();
        dssVersionsLabel.setLabelFor(this._dssVersionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add(this._dssVersionLabel, gbc);
        JLabel dssDateLabel = new JLabel("DSS Library Date: ");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add(dssDateLabel, gbc);
        this._dssDateLabel = new JLabel();
        dssDateLabel.setLabelFor(this._dssDateLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add(this._dssDateLabel, gbc);
        JLabel dssDefaultVersionLabel = new JLabel("Default DSS Version: ");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add(dssDefaultVersionLabel, gbc);
        this._dssDefaultVersionLabel = new JLabel();
        dssDefaultVersionLabel.setLabelFor(this._dssDefaultVersionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add(this._dssDefaultVersionLabel, gbc);
    }

    public void fillPanel() {
        DssDefaultFileVersionInfo currentDSSVersion = DssUtilities.getDefaultDssFileVersion();
        this._dssDefaultVersionLabel.setText(Integer.toString(currentDSSVersion.getDssVersion().getVersionAsInt()));
        this._dssDefaultVersionLabel.setToolTipText("<html>This is the version that new DSS files will be created as.<br>Existing DSS files versions won't be changed.<br>ALLV = " + currentDSSVersion.getRawDssVersion() + "</html>");
        this._dssVersionLabel.setText(DssUtilities.getDssLibraryVersion());
        this._dssDateLabel.setText(DssUtilities.getDssLibraryDate());
    }

    public void clearForm() {
        this._dssDateLabel.setText("");
        this._dssVersionLabel.setText("");
        this._dssDefaultVersionLabel.setText("");
        this._dssDefaultVersionLabel.setToolTipText(null);
    }
}

