/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;

class DownloadWatershed
extends JDialog {
    JCheckBox _watershedToCacheDir = null;
    JLabel toDirLabel;
    RmaJTextField _watershedDir;
    JButton browseWatershedDir;
    String _dir;

    public DownloadWatershed() {
        this.build();
    }

    protected void build() {
        ClientApp.app();
        String baseDir = ClientApp.getWorkspaceDir();
        int idx = baseDir.indexOf("atershed/") - 2;
        if (idx < 0) {
            JOptionPane.showMessageDialog(null, "Directory does not follow conventions for Watershed:\n" + baseDir, "Error", 0);
            return;
        }
        this._dir = baseDir.substring(idx);
        this.setTitle("Download Watershed " + this._dir);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(20, 10, 0, 0);
        this.getContentPane().add((Component)panel, gbc);
        this._watershedToCacheDir = new JCheckBox("To Cache Directory");
        this._watershedToCacheDir.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 10, 0);
        panel.add((Component)this._watershedToCacheDir, gbc);
        JPanel p = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        panel.add((Component)p, gbc);
        this.toDirLabel = new JLabel("To Directory:");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        p.add((Component)this.toDirLabel, gbc);
        this._watershedDir = new RmaJTextField();
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        p.add((Component)this._watershedDir, gbc);
        this.browseWatershedDir = new JButton("Browse...");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS5505;
        p.add((Component)this.browseWatershedDir, gbc);
        p = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)p, gbc);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        cmdPanel.setApplyAlwaysOn(true);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints((Component)cmdPanel, gbc);
        this.getContentPane().add((Component)cmdPanel);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        DownloadWatershed.this.downloadWatershedAction();
                        break;
                    }
                    case 4: {
                        DownloadWatershed.this.dispose();
                    }
                }
            }
        });
        this.toDirLabel.setEnabled(false);
        this._watershedDir.setEnabled(false);
        this.browseWatershedDir.setEnabled(false);
        this.browseWatershedDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadWatershed.this.browseWatershedDirAction();
            }
        });
        this._watershedToCacheDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = !DownloadWatershed.this._watershedToCacheDir.isSelected();
                DownloadWatershed.this.toDirLabel.setEnabled(enabled);
                DownloadWatershed.this._watershedDir.setEnabled(enabled);
                DownloadWatershed.this.browseWatershedDir.setEnabled(enabled);
            }
        });
        this._watershedDir.setText(System.getProperty("user.home"));
        boolean enabled = !this._watershedToCacheDir.isSelected();
        this.toDirLabel.setEnabled(enabled);
        this._watershedDir.setEnabled(enabled);
        this.browseWatershedDir.setEnabled(enabled);
    }

    private void downloadWatershedAction() {
        int number = ClientApp.app().getCache().getNumberWatershedFiles();
        if (this._watershedToCacheDir.isSelected()) {
            int opt = JOptionPane.showConfirmDialog(null, "Are you sure you want to download all " + number + " watershed files to the local cache?\nCached Directory: " + ClientApp.app().getCache().getCacheWatershedDir(), "Download Watershed", 0, 3);
            if (opt == 0) {
                this.setVisible(false);
                ClientApp.app().getCache().downloadAllWithProgress();
            }
        } else {
            int opt = JOptionPane.showConfirmDialog(null, "Are you sure you want to download all " + number + " watershed files to " + this._watershedDir.getText() + this._dir, "Download Watershed", 0, 3);
            if (opt == 0) {
                boolean error = false;
                String[] names = ClientApp.app().getCache().getWatershedFiles();
                if (names != null && names.length > 0) {
                    String[] locals = new String[names.length];
                    int idx = names[0].indexOf("atershed/") - 2;
                    if (idx < 0) {
                        error = true;
                    } else {
                        for (int i = 0; i < names.length; ++i) {
                            String local = this._watershedDir.getText() + names[i].substring(idx);
                            locals[i] = local;
                        }
                        this.setVisible(false);
                        ClientApp.app().getCache().downloadWithProgress(names, locals, true);
                    }
                } else {
                    error = true;
                }
                if (error) {
                    JOptionPane.showMessageDialog(null, "Error in downloading watershed.", "Download Watershed", 2);
                } else {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this._watershedToCacheDir == null) {
                return;
            }
            this.setLocation(100, 100);
            this.setSize(580, 170);
        }
        super.setVisible(visible);
    }

    private void browseWatershedDirAction() {
        JFileChooser chooser = new JFileChooser(this._watershedDir.getText());
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonText("OK");
        chooser.showOpenDialog(this);
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        String dir = selectedFile.getAbsolutePath().replace('\\', '/');
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this._watershedDir.setText(f.getAbsolutePath().replace('\\', '/'));
    }
}

