/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class ExportWatershedDialog
extends RmaJDialog {
    private RmaJTextField _watershedNameFld;
    private RmiFileChooserField _watershedDirFld;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private boolean _overwriteOk;

    public ExportWatershedDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(350, 170);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Export Watershed");
        JLabel label = new JLabel("Watershed Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._watershedNameFld = new RmaJTextField();
        label.setLabelFor((Component)this._watershedNameFld);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._watershedNameFld, gbc);
        label = new JLabel("Watershed Folder:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)label, gbc);
        this._watershedDirFld = new RmiFileChooserField();
        label.setLabelFor((Component)this._watershedDirFld);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._watershedDirFld, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!ExportWatershedDialog.this.isValidData()) break;
                        ExportWatershedDialog.this._canceled = false;
                        ExportWatershedDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        ExportWatershedDialog.this._canceled = true;
                        ExportWatershedDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    protected boolean isValidData() {
        String path = this._watershedDirFld.getPath();
        if (path == null || path.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Watershed Folder", "Missing Watershed Folder", 1);
            return false;
        }
        String name = this._watershedNameFld.getText();
        if (name == null || name.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a Watershed Name", "Missing Watershed Name", 1);
            return false;
        }
        String wkspFile = path + "/" + RMAIO.userNameToFileName((String)name) + ".wksp";
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            if (fm.fileExists(wkspFile)) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Watershed File already exists.\nDo you want to overwrite it?", "File Exists", 0);
                if (opt != 0) {
                    this._overwriteOk = false;
                    return false;
                }
                this._overwriteOk = true;
            }
        }
        catch (RemoteException e) {
            System.out.println("isValidData: RemoteException " + e);
        }
        return true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getDirectory() {
        return this._watershedDirFld.getPath();
    }

    public String getWatershedName() {
        return this._watershedNameFld.getText();
    }

    public boolean shouldOverwrite() {
        return this._overwriteOk;
    }
}

