/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.FileOpener;
import hec.client.AboutDialog;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientCache;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.ClientPropertiesJDialog;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.DownloadWatershed;
import hec.clientapp.client.ExportWatershedDialog;
import hec.clientapp.client.HECclient;
import hec.clientapp.client.HecLayerSelector;
import hec.clientapp.client.HecStreamAlignmentDrwPro;
import hec.clientapp.client.OptionDialog;
import hec.clientapp.client.PropertyJDialog;
import hec.clientapp.client.SplashWindow;
import hec.clientapp.client.TextFieldThread;
import hec.clientapp.client.WatershedTimeZonePanel;
import hec.clientapp.properties.HECGlobalProperties;
import hec.clientapp.script.ScriptButtonFrame;
import hec.clientapp.script.ScriptEditorDialog;
import hec.clientapp.tcu.CheckForClientAppInterimTermsAction;
import hec.dataTable.HecDataTableFrame;
import hec.dataTable.TimeSeriesDataModel;
import hec.gui.AbstractEditorPanel;
import hec.gui.PanelEditor;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ApplicationProperties;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.map.GeoDialog;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapIdentifier;
import hec.map.MapPanel;
import hec.map.MapToolPanel;
import hec.map.ModeDrawingAttributeSet;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.appInterface.MapApplicationModule;
import hec.map.streamAlignment.StreamAlignmentDrwPro;
import hec.model.UserInterface;
import hec.model.WatershedLocation;
import hec.model.WkspExportOptions;
import hec.properties.HECProperties;
import hec.script.ScriptConstants;
import hec.util.ExportResults;
import hec.util.TextDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.security.HecSecurityManager;
import rma.swing.DefaultJPanel;
import rma.swing.RmaGlyphButtonInfo;
import rma.swing.RmaJAttributeToolbarButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextArea;
import rma.swing.RmaJTextField;
import rma.swing.RmaJToolbarButton;
import rma.swing.TextEditDlg;
import rma.swing.event.ReflectMultiListener;
import rma.util.MemoryMonitor;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.StatusBarMemoryMonitor;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.WorkspaceLoadTimeLoggingMarker;
import rma.util.png.PngEncoder;
import rma.util.wmf.WMF;
import rma.util.wmf.WMFGraphics2D;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class HecClientFrame
extends HECclient
implements ActionListener,
ItemListener,
UserInterface,
MapApplicationFrame,
ScriptConstants,
PropertyChangeListener {
    private static final MarkingClassLogger WORKSPACE_LOAD_TIME_LOGGER = MarkingClassLogger.forMarkingClass(WorkspaceLoadTimeLoggingMarker.class);
    public static final String UNIT_SYSTEM_PROP_KEY = "display.units";
    public static final String TIME_ZONE_PROP_KEY = "display.timezone";
    public static final String CUSTOM_TIME_ZONE_KEY = "CustomTimeZoneValue";
    protected MapPanel _mapPanel;
    protected ClientApp _app;
    protected OptionDialog _optionsDialog = null;
    protected RmaJFrame _memMonitorFrame = null;
    private JToolBar _frameToolBar = new FrameToolBar();
    private boolean _frameToolBarInitd = false;
    private ToolBarPanel _toolbarPanel = new ToolBarPanel();
    protected int _modeIndex = -1;
    protected Vector _modeMenus = null;
    protected Preferences _preferences;
    protected HecLayerSelector _layerSelector = null;
    protected GeoDialog _geoDialog = null;
    protected ScriptButtonFrame _scriptButtonFrame = null;
    protected ScriptEditorDialog _editorFrame = null;
    protected String _remoteBrowseStartDir = null;
    protected String _localBrowseStartDir = null;
    protected String _dssLogFile = null;
    protected int _dssLogUnit = 7;
    protected boolean _iconToolbarVisSet = false;
    public static final int ENGLISH_UNITS = 1;
    public static final int SI_UNITS = 2;
    public static final int AS_STORED_UNITS = 0;
    protected MessageLineUpdater _msgLineUpdater;
    public static int _unitSystem;
    public static final String AS_STORED_TIME_ZONE_STR = "As Stored";
    public static final String LOCAL_TIME_ZONE_STR = "Local";
    public static final String WATERSHED_TIME_ZONE_STR = "Watershed";
    public static final String CUSTOM_TIME_ZONE_STR = "Custom";
    public static final String UTC_TIME_ZONE_STR = "UTC";
    public static final int LOCAL_TIME_ZONE = 0;
    public static final int WATERSHED_TIME_ZONE = 1;
    public static final int CUSTOM_TIME_ZONE = 2;
    public static final int UTC_TIME_ZONE = 3;
    public static final int AS_STORED_TIME_ZONE = 4;
    private static final String RECENT_MENU_ITEM = "recentMenuItem";
    public static int _timeZone;
    String _appTitle = "";
    JPanel panelMap;
    JPanel panelCommand;
    JPanel panelToolbar;
    JPanel panelAlert;
    protected RmaJTextField textFieldAlert;
    JPanel panelStatus;
    RmaJTextField textFieldStatus;
    JTextArea textAreaMessages;
    JLabel _modeSelectorLabel;
    RmaJComboBox<ClientMode> _modeSelector = new RmaJComboBox(new DefaultComboBoxModel());
    protected JMenuBar menuBar1;
    protected JMenu menuFile;
    protected JMenuItem menuItemNew;
    protected JMenuItem menuItemOpen;
    protected JMenuItem menuItemSave;
    protected JMenuItem menuItemExport;
    protected JMenuItem menuItemSaveMap;
    protected JMenuItem menuItemExit;
    protected JMenu menuEdit;
    protected JMenu menuView;
    protected JMenuItem menuItemShowAll;
    protected JMenuItem MenuItemLayers;
    protected JMenuItem MenuItemGeoDialog;
    protected JMenuItem menuItemRestoreWindows;
    protected JCheckBoxMenuItem menuItemShowGrids;
    protected JMenu iconMenu;
    protected JCheckBoxMenuItem cbmitemDefault;
    protected JCheckBoxMenuItem cbmitemSmall;
    protected JCheckBoxMenuItem cbmitemMedium;
    protected JCheckBoxMenuItem cbmitemLarge;
    protected JMenu menuTimeZone;
    protected JCheckBoxMenuItem asStoredTimeZoneItem;
    protected JCheckBoxMenuItem localTimeZoneItem;
    protected JCheckBoxMenuItem watershedTimeZoneItem;
    protected JCheckBoxMenuItem utcTimeZoneItem;
    protected JCheckBoxMenuItem selectTimeZoneItem;
    protected int m_nextSystemViewMenu = 0;
    protected JMenu menuUnitSystem;
    protected JCheckBoxMenuItem _asStoredunitItem;
    protected JCheckBoxMenuItem _englishUnitItem;
    protected JCheckBoxMenuItem _SIUnitItem;
    protected JMenu menuHelp;
    protected JMenuItem menuItemHelpTopics;
    protected JMenuItem menuItemAbout;
    protected JMenuItem menuItemVersion;
    protected JMenu menuTools;
    protected JMenuItem menuOptions;
    protected JMenuItem scriptMenu;
    public JMenuItem scriptEditor;
    protected JMenuItem menuDssVue;
    protected JMenuItem menuMemoryMonitor;
    protected JMenuItem menuProperties;
    protected JMenu menuServerLog;
    protected JMenuItem menuDownloadServerLog;
    protected JMenuItem menuViewServerLog;
    protected JMenuItem menuDownloadServerLogs;
    protected JMenu menuUploadDownload;
    protected JMenuItem menuDownload;
    protected JMenuItem menuViewFile;
    protected JMenuItem menuEditFile;
    protected JMenuItem menuUpload;
    protected JMenuItem menuDownloadWatershed;
    protected JMenuItem menuShowConsole;
    protected JMenuItem menuShowDssLog;
    protected CheckForClientAppInterimTermsAction checkForBetaAction = new CheckForClientAppInterimTermsAction((Window)((Object)this));
    SymAction lSymAction;
    boolean _shuttingDown = false;
    Cursor _waitCursor = Cursor.getPredefinedCursor(3);
    Cursor _defaultCursor = Cursor.getDefaultCursor();
    List _projectEnabledComponents = new ArrayList();

    public HecClientFrame() {
        this.setDefaultCloseOperation(0);
        this._preferences = Preferences.userNodeForPackage(this.getClass());
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(800, 600);
        this.panelMap = new JPanel(new BorderLayout(0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.panelMap, gbc);
        this.panelCommand = new JPanel(new CardLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.panelCommand, gbc);
        this.panelToolbar = new JPanel(new CardLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.panelToolbar, gbc);
        this.panelAlert = new JPanel();
        this.panelAlert.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.panelAlert, gbc);
        this.textFieldAlert = new RmaJTextField();
        this.textFieldAlert.setEditable(false);
        this.textFieldAlert.setText(" ");
        this.textFieldAlert.setForeground(new Color(0xFF0000));
        this.panelAlert.add("North", (Component)this.textFieldAlert);
        this.panelStatus = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panelStatus, gbc);
        this.textFieldStatus = new RmaJTextField(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 250;
                return d;
            }
        };
        this.textFieldStatus.setEditable(false);
        this.textFieldStatus.setText("Status");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.panelStatus.add((Component)this.textFieldStatus, gbc);
        this.textAreaMessages = new RmaJTextArea("Messages", 1, 40);
        this.textAreaMessages.setEditable(false);
        this.textAreaMessages.setRows(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        final JScrollPane scrollPane = new JScrollPane(this.textAreaMessages, 20, 31){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.height = HecClientFrame.this.textFieldStatus.getHeight();
                return d;
            }
        };
        scrollPane.setBorder(this.textFieldStatus.getBorder());
        this.panelStatus.add((Component)scrollPane, gbc);
        this._msgLineUpdater = new MessageLineUpdater();
        JButton textMessagesButton = new JButton("..."){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = scrollPane.getPreferredSize().height;
                return d;
            }
        };
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        this.panelStatus.add((Component)textMessagesButton, gbc);
        textMessagesButton.addActionListener(new ActionListener(){
            TextEditDlg _dialog;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this._dialog == null) {
                    this._dialog = new TextEditDlg((Frame)((Object)HecClientFrame.this), "Message", false);
                    this._dialog.setSystemClosable(false);
                }
                this._dialog.setText(HecClientFrame.this.textAreaMessages.getText());
                this._dialog.setTextDocument(HecClientFrame.this.textAreaMessages.getDocument());
                this._dialog.setEditable(false);
                this._dialog.setVisible(true);
            }
        });
        if (Boolean.getBoolean("showMemoryUsage")) {
            StatusBarMemoryMonitor smm = StatusBarMemoryMonitor.getInstance();
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 2, 0, 0);
            this.panelStatus.add((Component)smm, gbc);
        }
        this._mapPanel = new MapPanel();
        this.panelMap.add((Component)this._mapPanel, "Center");
        this._mapPanel.setUserInterface((UserInterface)this);
        this.buildMenus();
    }

    protected void buildMenus() {
        block15: {
            block14: {
                this.menuBar1 = new JMenuBar();
                this.menuFile = new JMenu("File");
                this.menuFile.setName("menuFile");
                this.menuFile.setMnemonic('F');
                this.menuItemNew = new JMenuItem("New Watershed...", 78);
                this.menuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
                this.menuItemNew.setVisible(false);
                this.menuFile.add(this.menuItemNew);
                this.menuItemOpen = new JMenuItem("Open Watershed...", 79);
                this.menuItemOpen.setName("menuItemOpen");
                this.menuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
                this.menuFile.add(this.menuItemOpen);
                this.menuItemSave = new JMenuItem("Save Watershed", 83);
                this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
                this.menuFile.add(this.menuItemSave);
                this.menuItemExport = new JMenuItem("Export Watershed...", 69);
                if (Boolean.getBoolean("HasWatershedExport")) {
                    this.menuFile.add(this.menuItemExport);
                }
                this.menuItemSaveMap = new JMenuItem("Save Map As...", 77);
                this.menuFile.add(this.menuItemSaveMap);
                this.menuFile.addSeparator();
                this.menuItemExit = new JMenuItem("Exit", 88);
                this.menuItemExit.setAccelerator(KeyStroke.getKeyStroke(81, 2, false));
                this.menuFile.add(this.menuItemExit);
                this.menuFile.addSeparator();
                this.menuBar1.add(this.menuFile);
                String[] lastWorkspaceName = ClientApp.app().getLastWorkspaceNames();
                Vector wlocs = ClientApp.app().getWatershedLocations(true);
                if (lastWorkspaceName != null && lastWorkspaceName.length > 0 && lastWorkspaceName[0] != null) {
                    JMenuItem menuItemLast = null;
                    for (int i = 0; i < lastWorkspaceName.length && lastWorkspaceName[i] != null; ++i) {
                        String menuLabel = lastWorkspaceName[i];
                        boolean exists = this.menuWorkspaceExists(i, wlocs);
                        String menuToolTip = ClientApp.app().getLastWorkspacePath(i);
                        menuItemLast = this.createRecentMenuItem(menuLabel, menuToolTip, menuLabel, exists);
                        this.menuFile.add(menuItemLast);
                    }
                }
                this.menuEdit = new JMenu("Edit");
                this.menuEdit.setMnemonic('e');
                this.menuBar1.add(this.menuEdit);
                this.menuView = new JMenu("View");
                this.menuView.setMnemonic('V');
                this.menuItemShowAll = new JMenuItem("Zoom to All", 90);
                this.menuView.add(this.menuItemShowAll);
                this.menuView.addSeparator();
                this.MenuItemLayers = new JMenuItem("Layers...", 76);
                this.menuView.add(this.MenuItemLayers);
                this.menuView.addSeparator();
                this.menuUnitSystem = new JMenu("Unit System");
                this.menuUnitSystem.setMnemonic('U');
                this._asStoredunitItem = new JCheckBoxMenuItem(AS_STORED_TIME_ZONE_STR);
                this._englishUnitItem = new JCheckBoxMenuItem("English");
                this._englishUnitItem.setMnemonic(71);
                this._englishUnitItem.setName("EnglishUnits");
                this.menuUnitSystem.add(this._englishUnitItem);
                this._SIUnitItem = new JCheckBoxMenuItem("SI");
                this._SIUnitItem.setMnemonic(83);
                this._SIUnitItem.setName("SIUnits");
                this.menuUnitSystem.add(this._SIUnitItem);
                this.menuView.add(this.menuUnitSystem);
                TimeZone tz = TimeZone.getDefault();
                ReflectMultiListener rml = new ReflectMultiListener();
                this.menuTimeZone = new JMenu("Time Zone");
                this.menuTimeZone.setMnemonic('N');
                this.menuTimeZone.setVisible(false);
                this.asStoredTimeZoneItem = new JCheckBoxMenuItem(AS_STORED_TIME_ZONE_STR);
                this.asStoredTimeZoneItem.setMnemonic('S');
                this.asStoredTimeZoneItem.setName("AS_STORED_TIME_ZONE_STR");
                this.asStoredTimeZoneItem.addActionListener((ActionListener)rml.add((Object)this, (Object)this.asStoredTimeZoneItem, "menuItemAsStoredTimeZone_Action"));
                this.asStoredTimeZoneItem.setVisible(false);
                this.menuTimeZone.add(this.asStoredTimeZoneItem);
                this.localTimeZoneItem = new JCheckBoxMenuItem("Local (" + tz.getID() + ")");
                this.localTimeZoneItem.setMnemonic('O');
                this.localTimeZoneItem.setName("LocalTimeZone");
                this.localTimeZoneItem.addActionListener((ActionListener)rml.add((Object)this, (Object)this.localTimeZoneItem, "menuItemLocalTimeZone_Action"));
                this.menuTimeZone.add(this.localTimeZoneItem);
                this.watershedTimeZoneItem = new JCheckBoxMenuItem(WATERSHED_TIME_ZONE_STR);
                this.watershedTimeZoneItem.setMnemonic('A');
                this.watershedTimeZoneItem.setName("WatershedTimeZone");
                this.watershedTimeZoneItem.addActionListener((ActionListener)rml.add((Object)this, (Object)this.watershedTimeZoneItem, "menuItemWatershedTimeZone_Action"));
                this.menuTimeZone.add(this.watershedTimeZoneItem);
                this.utcTimeZoneItem = new JCheckBoxMenuItem("UTC (GMT)");
                this.utcTimeZoneItem.setMnemonic('U');
                this.utcTimeZoneItem.setName("UtcTimeZone");
                this.utcTimeZoneItem.addActionListener((ActionListener)rml.add((Object)this, (Object)this.utcTimeZoneItem, "menuItemUtcTimeZone_Action"));
                this.menuTimeZone.add(this.utcTimeZoneItem);
                this.selectTimeZoneItem = new JCheckBoxMenuItem(CUSTOM_TIME_ZONE_STR);
                this.selectTimeZoneItem.setMnemonic('C');
                this.selectTimeZoneItem.setName("SelectTimeZone");
                this.menuTimeZone.add(this.selectTimeZoneItem);
                this.selectTimeZoneItem.addActionListener((ActionListener)rml.add((Object)this, (Object)this.selectTimeZoneItem, "menuItemSelectTimeZone_Action"));
                this.menuView.add(this.menuTimeZone);
                this.m_nextSystemViewMenu = this.menuView.getMenuComponentCount();
                ButtonGroup timeZoneGroup = new ButtonGroup();
                timeZoneGroup.add(this.asStoredTimeZoneItem);
                timeZoneGroup.add(this.localTimeZoneItem);
                timeZoneGroup.add(this.watershedTimeZoneItem);
                timeZoneGroup.add(this.selectTimeZoneItem);
                timeZoneGroup.add(this.utcTimeZoneItem);
                this.localTimeZoneItem.setSelected(true);
                this.menuView.addSeparator();
                this.iconMenu = new JMenu("Icons");
                this.iconMenu.setMnemonic('I');
                this.menuView.add(this.iconMenu);
                this.cbmitemDefault = new JCheckBoxMenuItem("Default");
                this.cbmitemDefault.setMnemonic(82);
                this.iconMenu.add(this.cbmitemDefault);
                this.cbmitemSmall = new JCheckBoxMenuItem("Small Icons");
                this.cbmitemSmall.setMnemonic(83);
                this.iconMenu.add(this.cbmitemSmall);
                this.cbmitemMedium = new JCheckBoxMenuItem("Medium Icons");
                this.cbmitemMedium.setMnemonic(69);
                this.iconMenu.add(this.cbmitemMedium);
                this.cbmitemLarge = new JCheckBoxMenuItem("Large Icons");
                this.cbmitemLarge.setMnemonic(76);
                this.iconMenu.add(this.cbmitemLarge);
                this.menuItemRestoreWindows = new JMenuItem("Restore Windows", 83);
                this.menuView.add(this.menuItemRestoreWindows);
                this.menuItemShowGrids = new JCheckBoxMenuItem("Grid Lines");
                this.menuView.add(this.menuItemShowGrids);
                this.menuBar1.add(this.menuView);
                this.menuTools = new JMenu("Tools");
                this.menuTools.setMnemonic('T');
                this.menuDssVue = new JMenuItem("HEC-DSSVue...", 68);
                this.menuTools.add(this.menuDssVue);
                this.scriptMenu = new JMenuItem("Scripts...", 83);
                this.menuTools.add(this.scriptMenu);
                this.scriptEditor = new JMenuItem("Script Editor...", 69);
                this.scriptEditor.setEnabled(false);
                this.scriptEditor.setVisible(false);
                this.menuTools.add(this.scriptEditor);
                if (ClientApp.app().networked) {
                    this.menuTools.addSeparator();
                }
                this.menuMemoryMonitor = new JMenuItem("Memory Monitor...", 89);
                this.menuTools.add(this.menuMemoryMonitor);
                this.menuMemoryMonitor.setVisible(false);
                this.menuMemoryMonitor.setAccelerator(KeyStroke.getKeyStroke(77, 2, false));
                if (ClientApp.app().hasConsoleWindow()) {
                    this.menuShowConsole = new JMenuItem("Console Log...", 67);
                    this.menuTools.add(this.menuShowConsole);
                }
                this.menuShowDssLog = new JMenuItem("HEC-DSS Output...");
                this.menuTools.add(this.menuShowDssLog);
                this.menuShowDssLog.setVisible(false);
                this.menuServerLog = new JMenu("Server Log");
                this.menuViewServerLog = new JMenuItem("View Current Log...");
                this.menuServerLog.add(this.menuViewServerLog);
                this.menuDownloadServerLog = new JMenuItem("Download Current Log...");
                this.menuServerLog.add(this.menuDownloadServerLog);
                this.menuDownloadServerLogs = new JMenuItem("Download Multiple Logs...");
                this.menuServerLog.add(this.menuDownloadServerLogs);
                if (ClientApp.app().networked) {
                    this.menuTools.add(this.menuServerLog);
                }
                this.menuUploadDownload = new JMenu("Download/Upload");
                this.menuDownload = new JMenuItem("Download...");
                this.menuUploadDownload.add(this.menuDownload);
                this.menuUpload = new JMenuItem("Upload...");
                this.menuUploadDownload.add(this.menuUpload);
                this.menuDownloadWatershed = new JMenuItem("Download Watershed...");
                HecClientFrame hecClientFrame = this;
                if (hecClientFrame._app.getCacheMode() == ClientCache.NORMAL_CACHED) break block14;
                HecClientFrame hecClientFrame2 = this;
                if (hecClientFrame2._app.getCacheMode() != ClientCache.RELOAD_CACHE) break block15;
            }
            this.menuUploadDownload.add(this.menuDownloadWatershed);
        }
        this.menuViewFile = new JMenuItem("View File...");
        this.menuUploadDownload.add(this.menuViewFile);
        this.menuEditFile = new JMenuItem("Edit File...");
        this.menuUploadDownload.add(this.menuEditFile);
        if (ClientApp.app().networked) {
            this.menuTools.add(this.menuUploadDownload);
            boolean enable = false;
            if (HecSecurityManager.getSecurityManager().checkPermission("watershedConfigModule", "configure") == 4) {
                enable = true;
            }
            this.menuUpload.setEnabled(enable);
            if (HecSecurityManager.getSecurityManager().checkPermission("watershedConfigModule", "write") == 3) {
                enable = true;
            }
            this.menuDownload.setEnabled(enable);
            this.menuViewFile.setEnabled(enable);
            this.menuEditFile.setEnabled(enable);
            this.menuDownloadWatershed.setEnabled(enable);
        }
        this.menuTools.addSeparator();
        this.menuOptions = new JMenuItem("Options...", 79);
        this.menuTools.add(this.menuOptions);
        this.menuProperties = new JMenuItem("Information...", 73);
        this.menuTools.add(this.menuProperties);
        this.menuBar1.add(this.menuTools);
        this.setJMenuBar(this.menuBar1);
        this.lSymAction = new SymAction();
        this.menuHelp = this.createHelpMenu();
        this.menuBar1.add(this.menuHelp);
        this.menuItemExit.addActionListener(this.lSymAction);
        this.menuItemNew.addActionListener(this.lSymAction);
        this.menuItemOpen.addActionListener(this.lSymAction);
        this.menuItemSave.addActionListener(this.lSymAction);
        this.menuItemExport.addActionListener(this.lSymAction);
        this.menuItemSaveMap.addActionListener(this.lSymAction);
        this.menuItemShowAll.addActionListener(this.lSymAction);
        this.MenuItemLayers.addActionListener(this.lSymAction);
        this.menuItemRestoreWindows.addActionListener(this.lSymAction);
        this.menuItemShowGrids.addActionListener(this.lSymAction);
        this.menuOptions.addActionListener(this.lSymAction);
        this.menuMemoryMonitor.addActionListener(this.lSymAction);
        this.menuDssVue.addActionListener(this.lSymAction);
        this.menuProperties.addActionListener(this.lSymAction);
        if (this.menuShowConsole != null) {
            this.menuShowConsole.addActionListener(this.lSymAction);
        }
        this.menuDownloadServerLog.addActionListener(this.lSymAction);
        this.menuViewServerLog.addActionListener(this.lSymAction);
        this.menuDownloadServerLogs.addActionListener(this.lSymAction);
        this.menuShowDssLog.addActionListener(this.lSymAction);
        this.menuDownload.addActionListener(this.lSymAction);
        this.menuViewFile.addActionListener(this.lSymAction);
        this.menuEditFile.addActionListener(this.lSymAction);
        this.menuUpload.addActionListener(this.lSymAction);
        this.menuDownloadWatershed.addActionListener(this.lSymAction);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._englishUnitItem.addActionListener(this.lSymAction);
        this._SIUnitItem.addActionListener(this.lSymAction);
        this.scriptMenu.addActionListener(this.lSymAction);
        this.scriptEditor.addActionListener(this.lSymAction);
        this.setDisplayUnitSystem(1);
        this.initTimeZone();
        this.cbmitemDefault.addActionListener(this.lSymAction);
        this.cbmitemSmall.addActionListener(this.lSymAction);
        this.cbmitemMedium.addActionListener(this.lSymAction);
        this.cbmitemLarge.addActionListener(this.lSymAction);
        this.addMouseMotionListener(new FrameMouseMotionAdapter());
        this.setMenusEnabled(false);
        this._modeSelector.addItemListener((ItemListener)this);
        this.setupSignalHandler();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HecClientFrame.this.properties();
            }
        }, KeyStroke.getKeyStroke(10, 8, true), 1);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HecClientFrame.this.managerInfo();
            }
        }, KeyStroke.getKeyStroke(77, 10, true), 1);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HecClientFrame.this.memoryMonitor_Action();
            }
        }, KeyStroke.getKeyStroke(77, 2, true), 1);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HecClientFrame.this.getCurrentMode().refreshMode();
            }
        }, KeyStroke.getKeyStroke(116, 2, true), 1);
        ((JComponent)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HecClientFrame.this.nextMode();
            }
        }, KeyStroke.getKeyStroke(39, 2, true), 1);
        ((JComponent)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HecClientFrame.this.prevMode();
            }
        }, KeyStroke.getKeyStroke(37, 2, true), 1);
        if (this.checkForBetaAction.betaFileExists()) {
            this.menuHelp.add((Action)((Object)this.checkForBetaAction));
        }
    }

    private void setupSignalHandler() {
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                if (!HecClientFrame.this._shuttingDown) {
                    HecClientFrame.this._shuttingDown = true;
                    System.out.println("Shutting down");
                    HecClientFrame.this.menuItemExit_Action(null);
                } else {
                    System.out.println("Final exit");
                    System.gc();
                    System.runFinalization();
                    System.exit(1);
                }
            }
        };
        Signal.handle(new Signal("INT"), handler);
    }

    protected JMenu createHelpMenu() {
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic('H');
        this.menuItemHelpTopics = new JMenuItem("Help Topics");
        this.menuItemHelpTopics.setMnemonic('T');
        this.menuItemHelpTopics.setEnabled(false);
        this.menuItemHelpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
        menuHelp.add(this.menuItemHelpTopics);
        menuHelp.addSeparator();
        this.menuItemAbout = new JMenuItem("About");
        this.menuItemAbout.setMnemonic('A');
        menuHelp.add(this.menuItemAbout);
        this.menuItemVersion = new JMenuItem("Version");
        this.menuItemVersion.setMnemonic('V');
        this.menuBar1.add(menuHelp);
        this.menuItemAbout.addActionListener(this.lSymAction);
        this.menuItemHelpTopics.addActionListener(this.lSymAction);
        this.menuItemVersion.addActionListener(this.lSymAction);
        return menuHelp;
    }

    public JMenu getToolsMenu() {
        return this.menuTools;
    }

    public void addWorkspaceEnabledComponent(Component c) {
        if (c != null) {
            this._projectEnabledComponents.add(c);
        }
    }

    protected void initTimeZone() {
        this.watershedTimeZoneItem.setSelected(true);
        ClientApp.app().setClientTimeZone(TimeZone.getDefault());
        _timeZone = 1;
    }

    public void addDisplaySystemViewMenu(JMenuItem menu) {
        if (menu == null) {
            return;
        }
        this.menuView.insert(menu, this.m_nextSystemViewMenu++);
    }

    public void setApp(ClientApp app) {
        this._app = app;
        if (this._app != null) {
            this.menuItemHelpTopics.setEnabled(this._app.getHelpFile() != null);
        }
    }

    public void setAlertPanel(boolean on) {
        this.panelAlert.setVisible(on);
    }

    public void setToolPanel(boolean on) {
    }

    public MapPanel getMapPanel() {
        return this._mapPanel;
    }

    private void addMnemonic(Vector v, JMenu mode, JCheckBoxMenuItem item) {
        int index = 0;
        int pos = 0;
        boolean valid = false;
        if (v.isEmpty()) {
            char key = item.getText().charAt(index);
            item.setMnemonic(key);
        } else {
            for (index = 0; index < item.getText().length(); ++index) {
                char key = item.getText().charAt(index);
                while (pos < v.size()) {
                    JCheckBoxMenuItem test = (JCheckBoxMenuItem)v.elementAt(pos);
                    test.getMnemonic();
                    if (key == test.getMnemonic() || key == mode.getMnemonic()) break;
                    valid = true;
                    ++pos;
                }
                if (!valid) continue;
                item.setMnemonic(key);
                break;
            }
        }
    }

    public void removeMode(ClientMode mode) {
        if (mode == null) {
            return;
        }
        ClientMode selectedMode = this.getCurrentMode();
        mode.modeClosing();
        this._modeSelector.removeItemListener((ItemListener)this);
        ((DefaultComboBoxModel)this._modeSelector.getModel()).removeElement(mode);
        this._modeSelector.addItemListener((ItemListener)this);
        if (selectedMode == mode) {
            this.selectMode(0);
        }
    }

    public void addMode(ClientMode mode) {
        this.addMode(mode, true);
    }

    public void addMode(ClientMode mode, boolean enabled) {
        this.addMode(mode, enabled, -1);
    }

    public void addMode(ClientMode mode, boolean enabled, int position) {
        if (mode == null) {
            return;
        }
        mode.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        this._modeSelector.removeItemListener((ItemListener)this);
        if (position < 0 || position >= this._modeSelector.getItemCount()) {
            this._modeSelector.addItem((Object)mode);
        } else {
            this._modeSelector.insertItemAt((Object)mode, position);
        }
        this._modeSelector.addItemListener((ItemListener)this);
        if (this._modeIndex >= position && position != -1) {
            ++this._modeIndex;
        }
        mode.panel().setEnabled(false);
        this.panelCommand.add(mode.menuName(), mode.panel());
        this._toolbarPanel.add(mode.menuName(), mode.getToolBarItems());
        this.panelToolbar.add(mode.menuName(), this.getDefaultToolBar());
        if (this._modeSelector.getItemCount() == 1) {
            this.selectMode(0);
        }
        mode.setClientTimeZone(ClientApp.app().getClientTimeZone());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this._modeSelector && event.getStateChange() == 1) {
            EventQueue.invokeLater(() -> this.selectMode(this._modeSelector.getSelectedIndex()));
            return;
        }
    }

    protected void nextMode() {
        int i = this._modeIndex + 1;
        if (i >= this.getNumberOfModes()) {
            i = 0;
        }
        this.selectMode(i);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected void prevMode() {
        int i = this._modeIndex - 1;
        if (i < 0) {
            i = this.getNumberOfModes() - 1;
        }
        this.selectMode(i);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public boolean selectMode(String modeName) {
        if (modeName == null) {
            return false;
        }
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            String s = ((ClientMode)this._modeSelector.getItemAt(i)).getScriptableName();
            if (!s.equals(modeName)) continue;
            this._modeSelector.setSelectedIndex(i);
            return true;
        }
        System.out.println("selectMode:failed to find module named " + modeName);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectMode(int idx) {
        int numModes = this.getNumberOfModes();
        if (idx < 0 || idx >= numModes) {
            return;
        }
        ClientMode mode = (ClientMode)this._modeSelector.getItemAt(idx);
        if (mode == null) {
            return;
        }
        this.setWaitCursor();
        try {
            int i;
            List toolsMenus;
            int i2;
            List viewMenus;
            if (!mode.getWorkspaceLoaded()) {
                try {
                    mode.panel().setEnabled(ClientApp.Workspace() != null);
                    mode.resetWorkspace();
                    mode.updateFrameToolBar();
                    this._toolbarPanel.revalidate();
                    this._toolbarPanel.repaint();
                }
                catch (UnsatisfiedLinkError ule) {
                    System.out.println("error resetingWorkspace on mode " + mode.getClass() + " " + ule);
                    ule.printStackTrace();
                }
                catch (Exception e) {
                    System.out.println("error resetingWorkspace on mode " + mode.getClass() + " " + e);
                    e.printStackTrace();
                }
            }
            if (!mode.canOpen()) {
                this._modeSelector.removeItemListener((ItemListener)this);
                this._modeSelector.setSelectedIndex(this._modeIndex);
                this._modeSelector.addItemListener((ItemListener)this);
                return;
            }
            ClientMode currentMode = null;
            if (this._modeIndex >= 0 && this._modeIndex < numModes) {
                currentMode = (ClientMode)this._modeSelector.getItemAt(this._modeIndex);
                if (!currentMode.switchModeOk() || !currentMode.validateManagers()) {
                    for (int i3 = 0; i3 < numModes; ++i3) {
                        this._modeSelector.removeItemListener((ItemListener)this);
                        if (i3 == this._modeIndex) {
                            this._modeSelector.setSelectedIndex(this._modeIndex);
                        }
                        this._modeSelector.addItemListener((ItemListener)this);
                    }
                    return;
                }
                this._toolbarPanel.modeClosing();
                currentMode.modeClosing();
            }
            if (this._modeSelector.getSelectedIndex() != idx) {
                this._modeSelector.removeItemListener((ItemListener)this);
                this._modeSelector.setSelectedIndex(idx);
                this._modeSelector.addItemListener((ItemListener)this);
            }
            this._mapPanel.setPaintEnabled(false);
            if (this._modeIndex == idx) {
                mode.modeOpening();
                this._mapPanel.setPaintEnabled(true);
                mode.mapTools().forceSelectButton(mode.mapTools().getSelectedButton());
                return;
            }
            this._modeIndex = idx;
            if (this._modeMenus != null) {
                for (int i4 = 0; i4 < this._modeMenus.size(); ++i4) {
                    if (this._modeMenus.elementAt(i4) == null) continue;
                    this.menuBar1.remove((Component)this._modeMenus.elementAt(i4));
                }
            }
            this._modeMenus = mode.menus();
            int menuLength = 0;
            if (this._modeMenus != null) {
                menuLength = this._modeMenus.size();
                this.menuBar1.remove(this.menuHelp);
                this.menuBar1.remove(this.menuTools);
                for (int i5 = 0; i5 < menuLength; ++i5) {
                    if (this._modeMenus.elementAt(i5) == null) continue;
                    this.menuBar1.add((JMenu)this._modeMenus.elementAt(i5));
                }
                this.menuBar1.add(this.menuTools);
                this.menuBar1.add(this.menuHelp);
            }
            boolean enabled = ClientApp.Workspace() != null;
            for (int i6 = 0; i6 < menuLength; ++i6) {
                if (this._modeMenus.elementAt(i6) == null) continue;
                ((Component)this._modeMenus.elementAt(i6)).setEnabled(enabled);
            }
            this.menuEdit.removeAll();
            List editMenus = mode.getEditMenuItems();
            if (editMenus == null) {
                this.menuEdit.setVisible(false);
            } else {
                for (int i7 = 0; i7 < editMenus.size(); ++i7) {
                    this.menuEdit.add((JComponent)editMenus.get(i7));
                }
                this.menuEdit.setVisible(true);
                if (!enabled) {
                    this.menuEdit.setEnabled(false);
                } else {
                    this.menuEdit.setEnabled(true);
                }
                this.menuEdit.revalidate();
            }
            if (currentMode != null && (viewMenus = currentMode.getViewMenuItems()) != null) {
                for (i2 = 0; i2 < viewMenus.size(); ++i2) {
                    this.menuView.remove((Component)viewMenus.get(i2));
                }
            }
            if ((viewMenus = mode.getViewMenuItems()) != null) {
                for (i2 = 0; i2 < viewMenus.size(); ++i2) {
                    this.menuView.add((JComponent)viewMenus.get(i2));
                }
                this.menuView.revalidate();
            }
            if (currentMode != null && (toolsMenus = currentMode.getToolsMenuItems()) != null) {
                for (i = 0; i < toolsMenus.size(); ++i) {
                    this.menuTools.remove((Component)toolsMenus.get(i));
                }
            }
            if ((toolsMenus = mode.getToolsMenuItems()) != null) {
                for (i = 0; i < toolsMenus.size(); ++i) {
                    this.menuTools.add((JComponent)toolsMenus.get(i));
                }
                this.menuTools.revalidate();
            }
            this._mapPanel.setMapTools(mode.mapTools());
            mode.modeOpening();
            try {
                mode.updateManagerMaps();
            }
            catch (Exception e) {
                System.out.println("selectMode: error on updateManagerMaps " + e);
            }
            String menuName = mode.menuName();
            ((CardLayout)this.panelCommand.getLayout()).show(this.panelCommand, menuName);
            if (mode.hasCommandPanelComponents()) {
                this.panelCommand.setVisible(true);
            } else {
                this.panelCommand.setVisible(false);
            }
            ((CardLayout)this.panelToolbar.getLayout()).show(this.panelToolbar, menuName);
            ((CardLayout)this._toolbarPanel.getLayout()).show(this._toolbarPanel, menuName);
            this.menuBar1.repaint();
            this.setGlyphStateFromToolbar();
            this._mapPanel.repaint();
            this.validate();
            this._mapPanel.setPaintEnabled(true);
            this._mapPanel.paintMap();
            if (this._layerSelector != null && this._layerSelector.isVisible()) {
                this._layerSelector.closeChildDialogs();
                this._layerSelector.setMapPanel(this._mapPanel);
                this._layerSelector.modeChanged();
            }
            if (this._scriptButtonFrame != null && this._scriptButtonFrame.isVisible()) {
                this._scriptButtonFrame.updateScriptButtons();
            }
        }
        finally {
            this.setDefaultCursor();
        }
    }

    public void setGlyphStateFromToolbar() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Component[] comps = HecClientFrame.this._toolbarPanel.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    comps = ((JPanel)comps[i]).getComponents();
                    break;
                }
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!(c instanceof RmaJToolbarButton)) continue;
                    RmaJToolbarButton button = (RmaJToolbarButton)c;
                    RmaGlyphButtonInfo ginfo = button.getGlyphButtonInfo();
                    String glyphName = ginfo.getMapGlyphClass();
                    MapGlyph glyph = HecClientFrame.this._mapPanel.findGlyphOfClass(glyphName);
                    if (glyph != null) {
                        String attrName = ginfo.getAttributeSetName();
                        glyph.showMapElement(attrName, ginfo.getGlyphElement(), button.isSelected());
                        if (ginfo.getAttributeSetName() != null && !glyph.isAttributeAvailable(attrName)) {
                            button.setEnabled(false);
                            continue;
                        }
                        button.setEnabled(true);
                        continue;
                    }
                    button.setEnabled(false);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public ClientMode getModeByClass(Class cls) {
        if (cls == null) {
            return null;
        }
        ComboBoxModel model = this._modeSelector.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object mode = model.getElementAt(i);
            if (!cls.isInstance(mode)) continue;
            return (ClientMode)mode;
        }
        return null;
    }

    public void editScriptList() {
        ClientMode cm = this.getCurrentMode();
        if (cm != null) {
            cm.editScriptList();
        }
    }

    public ClientMode getCurrentMode() {
        if (this._modeSelector != null) {
            return (ClientMode)this._modeSelector.getSelectedItem();
        }
        return null;
    }

    public MapApplicationModule getCurrentModule() {
        return (MapApplicationModule)this._modeSelector.getSelectedItem();
    }

    public ClientMode[] getModes() {
        int size = this._modeSelector.getItemCount();
        ClientMode[] modes = new ClientMode[size];
        for (int i = 0; i < size; ++i) {
            modes[i] = (ClientMode)this._modeSelector.getItemAt(i);
        }
        return modes;
    }

    public void setDssLogFile(String logFile) {
        if (logFile != null && logFile.equalsIgnoreCase("nolog")) {
            return;
        }
        stringContainer name = new stringContainer();
        this._dssLogUnit = this.openDssLogFile(this._dssLogUnit, logFile, "HEC-DSS", name);
        this._dssLogFile = name.string;
        if (this._dssLogUnit != 6) {
            this.menuShowDssLog.setVisible(true);
        }
        Heclib.zset((String)"MUNIT", (String)"", (int)this._dssLogUnit);
    }

    protected int openDssLogFile(int unit, String givenName, String prefix, stringContainer finalName) {
        File f;
        String appName;
        int idx;
        String pathSeparator = System.getProperty("file.separator");
        Object tempDirectory = System.getProperty("java.io.tmpdir");
        if (!((String)tempDirectory).endsWith(pathSeparator)) {
            tempDirectory = (String)tempDirectory + pathSeparator;
        }
        if ((idx = (appName = this._app.getClass().toString()).lastIndexOf(".")) > 0) {
            appName = appName.substring(++idx);
        }
        if (!(f = new File((String)(tempDirectory = (String)tempDirectory + appName))).isDirectory()) {
            f.mkdirs();
        }
        tempDirectory = (String)tempDirectory + System.getProperty("file.separator");
        Object name = givenName == null ? (String)tempDirectory + prefix + ".log" : givenName;
        f = new File((String)name);
        if (f.exists() && !f.delete()) {
            for (int i = 0; i < 100; ++i) {
                String tryName = (String)tempDirectory + prefix + Integer.toString(i) + ".log";
                f = new File(tryName);
                if (f.exists()) {
                    if (!f.delete()) continue;
                    name = tryName;
                    break;
                }
                name = tryName;
                break;
            }
        }
        finalName.string = name;
        int stat = Heclib.fortranOpen((String)name, (int)unit);
        if (stat != 0) {
            return 6;
        }
        return unit;
    }

    public void showDssOutput() {
        if (this._dssLogFile == null) {
            return;
        }
        Heclib.fortranFlush((int)this._dssLogUnit);
        try {
            TextDialog textDialog = new TextDialog((Component)((Object)this));
            textDialog.initialize(this._dssLogFile, false);
            textDialog.setLocation(20, 20);
            textDialog.setSize(700, 500);
            textDialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to access DSS log file: " + this._dssLogFile + "\n" + e.toString(), "", 2);
        }
    }

    public boolean closeWorkspace() {
        ClientWorkspace workspace = ClientApp.Workspace();
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (this._scriptButtonFrame != null) {
            this._scriptButtonFrame.dispose();
            this._scriptButtonFrame = null;
        }
        if (workspace != null) {
            int opt = 0;
            String wkspName = workspace.getTitleName();
            if (!this.workspaceClosing()) {
                return false;
            }
            if (workspace.isModified() && this.isVisible()) {
                Object[] options = new Object[]{"Yes", "No", "Cancel"};
                opt = JOptionPane.showOptionDialog((Component)((Object)this), "Save changes to " + wkspName + "?", "", -1, 3, null, options, options[0]);
            } else {
                opt = 9;
            }
            switch (opt) {
                case 2: {
                    int numModes = this.getNumberOfModes();
                    for (int i = 0; i < numModes; ++i) {
                        MapToolPanel mapTools;
                        ClientMode currentMode = (ClientMode)this._modeSelector.getItemAt(i);
                        if (currentMode == null || (mapTools = currentMode.getMapTools()) == null) continue;
                        mapTools.setEnabled(true);
                    }
                    return false;
                }
                case 0: 
                case 9: {
                    if (!this.getCurrentMode().validateManagers()) {
                        return false;
                    }
                    if (opt != 0 || ClientApp.app().saveWorkspaceOnExit()) break;
                    Object[] options2 = new Object[]{"Yes", "No"};
                    opt = 0;
                    if (this.isVisible()) {
                        opt = JOptionPane.showOptionDialog((Component)((Object)this), "Saving  watershed " + wkspName + " failed. Continue closing watershed?", "Error", -1, 0, null, options2, options2[0]);
                    }
                    if (opt == 1) {
                        return false;
                    }
                    this.getMapPanel().removeAllMaps();
                    this.updateTitle();
                }
            }
            workspace.close();
            this.workspaceClosed();
        }
        this.unlockAll(fm);
        return true;
    }

    public void exitApplication() {
        HECGlobalProperties props;
        this.saveSizeAndLocation();
        this.saveState();
        HECProperties appProps = ClientApp.app().getPropertiesObject();
        if (appProps != null && appProps.isModified()) {
            appProps.saveProperties();
        }
        if ((props = ClientApp.app().getGlobalProperties()) != null && props.isModified()) {
            props.saveProperties(1);
        }
        if (this.closeWorkspace()) {
            System.gc();
            System.runFinalization();
            this.setVisible(false);
            System.exit(0);
        }
    }

    protected void menuItemExit_Action(ActionEvent event) {
        int opt;
        if (!(!this._app.getShowConfirmOnExit() || this._shuttingDown || ClientApp.Workspace() != null && ClientApp.Workspace().isModified() || (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Exiting Application. Ok to continue?", "Confirm Exit", 2)) != 2)) {
            return;
        }
        this.exitApp();
    }

    protected void exitApp() {
        HECGlobalProperties props;
        this.saveSizeAndLocation();
        this.saveState();
        HECProperties appProps = ClientApp.app().getPropertiesObject();
        if (appProps != null && appProps.isModified()) {
            appProps.saveProperties();
        }
        if ((props = ClientApp.app().getGlobalProperties()) != null && props.isModified()) {
            props.saveProperties(1);
        }
        if (ClientApp.canExitJVM()) {
            if (this.closeWorkspace()) {
                this.setVisible(false);
                System.gc();
                System.runFinalization();
                if (ClientApp.canExitJVM()) {
                    System.exit(0);
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    protected void menuItemNew_Action(ActionEvent event) {
        if (!ClientApp.app().newWorkspace()) {
            return;
        }
        this.updateTitle();
        this.resetWorkspace();
    }

    protected void menuItemOpen_Action(ActionEvent event) {
        if (!ClientApp.app().openWorkspace()) {
            return;
        }
    }

    protected void menuItemSave_Action(ActionEvent event) {
        if (!ClientApp.app().saveWorkspace()) {
            return;
        }
        this.updateTitle();
        this.invalidate();
    }

    void menuItemShowAll_Action(ActionEvent event) {
        this._mapPanel.showAll();
    }

    public void menuItemGeoDialog_Action(ActionEvent event) {
        if (ClientApp.Workspace() == null) {
            return;
        }
        if (this._geoDialog == null) {
            this._geoDialog = new GeoDialog((Frame)((Object)this), true);
        }
        this._geoDialog.setVisible(true);
        if (!this._geoDialog.isCanceled()) {
            this._mapPanel.updateExtents();
        }
    }

    void menuItemSetGeoExt_Action(ActionEvent event) {
        if (ClientApp.Workspace() == null) {
            return;
        }
        WorldRect ext = this._mapPanel.getCurrentExtents();
        if (ClientApp.Workspace().setExtents(ext)) {
            ClientApp.Workspace().setGrowToExtents(false);
            this._mapPanel.updateExtents();
        }
    }

    void menuItemSetAttributes_Action(ActionEvent event) {
        PropertyJDialog dlg = new PropertyJDialog((Frame)((Object)this), false);
        if (dlg.fillForm()) {
            dlg.setModified(false);
            dlg.setVisible(true);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Schematic Display Properties Available.", "Message", -1);
            System.out.println("\nNo Schematic Display Properties Available.");
        }
    }

    public void menuItemSaveMap_Action() {
        int reply;
        RMAFilenameFilter wmfFileFilter = new RMAFilenameFilter("wmf", "Windows Metafile (*.wmf)");
        RMAFilenameFilter jpegFileFilter = new RMAFilenameFilter(new String[]{"jpg", "jpeg"}, "JPEG (*.jpg, *.jpeg)");
        RMAFilenameFilter pngFileFilter = new RMAFilenameFilter(new String[]{"png"}, "Portable Network Graphics (*.png)");
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
            chooser.addChoosableFileFilter((FileFilter)wmfFileFilter);
        }
        chooser.addChoosableFileFilter((FileFilter)jpegFileFilter);
        chooser.addChoosableFileFilter((FileFilter)pngFileFilter);
        int state = chooser.showSaveDialog((Component)((Object)this));
        File file = chooser.getSelectedFile();
        if (state == 1 || state == -1) {
            return;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a file!", "File Error", 0);
            return;
        }
        if (file.exists() && (reply = RMAIO.postYesNoWarning((Component)((Object)this), (String)(file.getName() + " already exists!\n Do you want to replace it?"))) == 1) {
            return;
        }
        RMAFilenameFilter ff = (RMAFilenameFilter)chooser.getFileFilter();
        if (ff.equals(wmfFileFilter)) {
            this.saveToMetafile(file);
        } else if (ff.equals(jpegFileFilter)) {
            this.saveToJpeg(file);
        } else if (ff.equals(pngFileFilter)) {
            this.saveToPng(file);
        }
    }

    public void saveToMetafile(String fileName) {
        this.saveToMetafile(new File(fileName));
    }

    public void saveToMetafile(File file) {
        WMF wmf = new WMF();
        MapCanvas panel = this.getMapPanel().viewport();
        Dimension d = panel.getSize();
        WMFGraphics2D g = new WMFGraphics2D(wmf, d.width, d.height, panel.getForeground(), panel.getBackground());
        panel.paint((Graphics)g);
        try {
            String path = file.getPath();
            if (path.indexOf(".wmf") == -1) {
                path = path.concat(".wmf");
            }
            FileOutputStream out = new FileOutputStream(path);
            wmf.writePlaceableWMF((OutputStream)out, 0, 0, d.width, d.height, Toolkit.getDefaultToolkit().getScreenResolution());
            out.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void saveToPng(String fileName) {
        this.saveToPng(new File(fileName));
    }

    public void saveToPng(File file) {
        MapCanvas panel = this.getMapPanel().viewport();
        Dimension d = panel.getSize();
        BufferedImage bImage = new BufferedImage(d.width, d.height, 1);
        Graphics2D g = bImage.createGraphics();
        g.setColor(Color.white);
        panel.paint((Graphics)g);
        try {
            String path = file.getPath();
            if (path.indexOf(".png") == -1) {
                path = path.concat(".png");
            }
            FileOutputStream out = new FileOutputStream(path);
            PngEncoder pngEncoder = new PngEncoder((Image)bImage);
            byte[] data = pngEncoder.pngEncode();
            out.write(data);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public void saveToJpeg(String fileName) {
        this.saveToJpeg(new File(fileName));
    }

    public void saveToJpeg(File file) {
        MapCanvas panel = this.getMapPanel().viewport();
        Dimension d = panel.getSize();
        BufferedImage bImage = new BufferedImage(d.width, d.height, 1);
        Graphics2D g = bImage.createGraphics();
        g.setColor(Color.white);
        panel.paint((Graphics)g);
        try {
            String path = file.getPath();
            if (path.indexOf(".jpg") == -1 && path.indexOf(".jpeg") == -1) {
                path = path.concat(".jpg");
            }
            FileOutputStream out = new FileOutputStream(path);
            ImageIO.write((RenderedImage)bImage, "JPG", out);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    protected void menuItemLayers_Action() {
        if (this._layerSelector == null) {
            this._layerSelector = new HecLayerSelector((JFrame)((Object)this), false, this._mapPanel);
            this._layerSelector.configureLayersDialog();
            this._layerSelector.setSystemClosable(false);
        } else {
            this._layerSelector.setMapPanel(this._mapPanel);
        }
        if (!this._layerSelector.isVisible()) {
            this._layerSelector.setVisible(true);
        } else if (this._layerSelector.getState() == 1) {
            this._layerSelector.setState(0);
        }
        this._layerSelector.toFront();
    }

    void menuItemAsStoredunitItem_Action(ActionEvent event) {
        JCheckBoxMenuItem checkBox;
        Object object = event.getSource();
        if (object instanceof JCheckBoxMenuItem && (checkBox = (JCheckBoxMenuItem)object).getName().equals("StoredUnits")) {
            if (!checkBox.getState()) {
                if (_unitSystem == 0) {
                    this._asStoredunitItem.setSelected(true);
                }
                return;
            }
            this.setDisplayUnitSystem(0);
        }
    }

    void menuItemEnglishUnitItem_Action(ActionEvent event) {
        JCheckBoxMenuItem checkBox;
        Object object = event.getSource();
        if (object instanceof JCheckBoxMenuItem && (checkBox = (JCheckBoxMenuItem)object).getName().equals("EnglishUnits")) {
            if (!checkBox.getState()) {
                if (_unitSystem == 1) {
                    this._englishUnitItem.setSelected(true);
                }
                return;
            }
            this.setDisplayUnitSystem(1);
        }
    }

    void menuItemSIUnitItem_Action(ActionEvent event) {
        JCheckBoxMenuItem checkBox;
        Object object = event.getSource();
        if (object instanceof JCheckBoxMenuItem && (checkBox = (JCheckBoxMenuItem)object).getName().equals("SIUnits")) {
            if (!checkBox.getState()) {
                if (_unitSystem == 2) {
                    this._SIUnitItem.setSelected(true);
                }
                return;
            }
            this.setDisplayUnitSystem(2);
        }
    }

    public void menuItemLocalTimeZone_Action() {
        ClientApp.app().setClientTimeZone(TimeZone.getDefault());
        Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(TIME_ZONE_PROP_KEY, LOCAL_TIME_ZONE_STR);
        PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
        _timeZone = 0;
    }

    public void menuItemAsStoredTimeZone_Action() {
        ClientApp.app().setClientTimeZone(null);
        Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(TIME_ZONE_PROP_KEY, AS_STORED_TIME_ZONE_STR);
        PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
        _timeZone = 4;
    }

    public void menuItemUtcTimeZone_Action() {
        TimeZone tz = TimeZone.getTimeZone(UTC_TIME_ZONE_STR);
        ClientApp.app().setClientTimeZone(tz);
        Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(TIME_ZONE_PROP_KEY, UTC_TIME_ZONE_STR);
        PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
        _timeZone = 3;
    }

    public void menuItemWatershedTimeZone_Action() {
        Properties properties;
        if (ClientApp.Workspace() != null) {
            TimeZone tz = ClientApp.Workspace().getWatershedTimeZone();
            ClientApp.app().setClientTimeZone(tz);
        }
        if ((properties = PreferencesManager.getProperties((int)0, (String)"display.properties")) == null) {
            properties = new Properties();
        }
        properties.setProperty(TIME_ZONE_PROP_KEY, WATERSHED_TIME_ZONE_STR);
        PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
        _timeZone = 1;
    }

    public void menuItemSelectTimeZone_Action() {
        if (!this.selectTimeZoneItem.getState()) {
            return;
        }
        PanelEditor pe = new PanelEditor((Frame)((Object)this), false){

            public void cancelButtonAction() {
                super.cancelButtonAction();
                Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
                if (properties == null) {
                    return;
                }
                String timeZoneProperty = properties.getProperty(HecClientFrame.TIME_ZONE_PROP_KEY);
                if (HecClientFrame.LOCAL_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                    HecClientFrame.this.localTimeZoneItem.setSelected(true);
                } else if (HecClientFrame.AS_STORED_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                    HecClientFrame.this.asStoredTimeZoneItem.setSelected(true);
                } else if (HecClientFrame.WATERSHED_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                    HecClientFrame.this.watershedTimeZoneItem.setSelected(true);
                } else if (HecClientFrame.CUSTOM_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                    HecClientFrame.this.selectTimeZoneItem.setSelected(true);
                } else if (HecClientFrame.UTC_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                    HecClientFrame.this.utcTimeZoneItem.setSelected(true);
                }
            }
        };
        WatershedTimeZonePanel tzp = new WatershedTimeZonePanel(){

            public boolean savePanel(NamedType dobj) {
                super.savePanel();
                _timeZone = 2;
                HecClientFrame.this.selectTimeZoneItem.setText("Custom (" + ClientApp.app().getClientTimeZone().getID() + ")");
                ClientApp.app().setUserProperty(HecClientFrame.TIME_ZONE_PROP_KEY, HecClientFrame.CUSTOM_TIME_ZONE_STR);
                Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty(HecClientFrame.TIME_ZONE_PROP_KEY, HecClientFrame.CUSTOM_TIME_ZONE_STR);
                PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
                return true;
            }
        };
        pe.setLocationRelativeTo((Component)this.getMapPanel());
        pe.setTitle("Select a Time Zone");
        pe.addPanel((AbstractEditorPanel)tzp);
        pe.fillForm(null);
        pe.pack();
        pe.setVisible(true);
    }

    public void setDisplayUnitSystem(int unitSystem) {
        _unitSystem = unitSystem;
        if (_unitSystem == 0) {
            this._englishUnitItem.setSelected(false);
            this._SIUnitItem.setSelected(false);
            if (!this._asStoredunitItem.getState()) {
                this._asStoredunitItem.setSelected(true);
            }
            if (ClientApp.Workspace() != null) {
                ClientApp.app().setClientUnitSystem(ClientApp.Workspace().getUnitSystem());
            }
            if (ClientApp.Workspace() != null) {
                Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty(UNIT_SYSTEM_PROP_KEY, "AsStored");
                PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
            }
        } else if (_unitSystem == 1) {
            this._asStoredunitItem.setSelected(false);
            this._SIUnitItem.setSelected(false);
            if (!this._englishUnitItem.getState()) {
                this._englishUnitItem.setSelected(true);
            }
            ClientApp.app().setClientUnitSystem(1);
            if (ClientApp.Workspace() != null) {
                Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty(UNIT_SYSTEM_PROP_KEY, "English");
                PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
            }
        } else if (_unitSystem == 2) {
            this._asStoredunitItem.setSelected(false);
            this._englishUnitItem.setSelected(false);
            if (!this._SIUnitItem.getState()) {
                this._SIUnitItem.setSelected(true);
            }
            ClientApp.app().setClientUnitSystem(2);
            if (ClientApp.Workspace() != null) {
                Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty(UNIT_SYSTEM_PROP_KEY, "SI");
                PreferencesManager.setProperties((int)0, (String)"display.properties", (Properties)properties, (String)"");
            }
        }
    }

    void menuItemHelpTopics_Action(ActionEvent event) {
        String cmd = null;
        int osType = RMAIO.getOSType();
        if (osType == 0 || osType == 1) {
            cmd = "cmd /c \"" + System.getProperty("user.dir") + "/help/" + this._app.getHelpFile() + "\"";
        } else if (osType == 2) {
            cmd = "netscape help/" + this._app.getHelpFile();
        }
        if (this._app.getHelpFile() != null || cmd == null) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Runtime runtime = Runtime.getRuntime();
                System.out.println("Help cmd is [" + cmd + "]");
                Process process = runtime.exec(cmd);
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to launch Netscape.\n" + io, "Error", 0);
                System.out.println("\nFailed to launch Netscape. " + io);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof HecDataTableFrame) {
            String property = evt.getPropertyName();
            if (property.equals(HecDataTableFrame.DATE_STYLE)) {
                this.setDateStyle((Integer)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.QUALITY_STYLE)) {
                this.setTableQualityState((Integer)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.SHOW_COMMAS_PROPERTY)) {
                this.setTableCommasState((Boolean)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.REVERSE_ORDER_PROPERTY)) {
                this.setTableReverseOrderState((Boolean)evt.getNewValue());
            } else if (property.equals(HecDataTableFrame.SHOW_DATE_AS_TWO_COLUMNS)) {
                this.setDateTimeAsTwoColumns((Boolean)evt.getNewValue());
            }
        }
    }

    public void setTableCommasState(boolean showCommas) {
        this._preferences.putBoolean("showTableCommas", showCommas);
    }

    public void setTableReverseOrderState(boolean reverseOrder) {
        this._preferences.putBoolean("reverseOrderTable", reverseOrder);
    }

    public void setDateTimeAsTwoColumns(boolean showDateTimeAsTwoColumns) {
        this._preferences.putBoolean("showDateTimeAsTwoColumns", showDateTimeAsTwoColumns);
    }

    public void setDateStyle(int dateStyle) {
        this._preferences.putInt("dateStyle", dateStyle);
    }

    public void setTableQualityState(int qualityStyle) {
        this._preferences.putInt("showTableQuality", qualityStyle);
    }

    public void setTablePreferences(HecDataTableFrame table) {
        table.addPropertyChangeListener((PropertyChangeListener)this);
        table.setCommasState(this._preferences.getBoolean("showTableCommas", true));
        table.setReverseOrderState(this._preferences.getBoolean("reverseOrderTable", false));
        table.setDateTimeAsTwoColumnsState(this._preferences.getBoolean("showDateTimeAsTwoColumns", false));
        TimeSeriesDataModel.setDefaultDateStyle((int)this._preferences.getInt("dateStyle", 17));
        String temp = this._preferences.get("showTableQuality", null);
        if (temp != null) {
            if (temp.equals("true")) {
                table.setQualityState(1);
            } else if (temp.equals("1")) {
                table.setQualityState(1);
            } else if (temp.equals("2")) {
                table.setQualityState(2);
            } else {
                table.setQualityState(0);
            }
        }
    }

    void menuItemAbout_Action(ActionEvent event) {
        this.helpAbout();
    }

    public void helpAbout() {
    }

    public void helpAbout(String title) {
        String message;
        Properties props = RMAIO.getAppVersionProperties(this.getClass());
        String[] versionStamp = RMAIO.getVersionStamp();
        if (props == null) {
            message = title + "\nVersion " + ClientApp.getVersionString() + ", " + RMAIO.getBuildMonthYear();
            if (versionStamp[0] != null && versionStamp[1] != null) {
                message = message + "\nBuild Date: " + versionStamp[1];
            }
        } else {
            String versionDate = props.getProperty("versionDate");
            if (versionDate == null) {
                versionDate = RMAIO.getBuildMonthYear();
            }
            message = title + "\nVersion " + props.getProperty("shortVersion", "") + ", " + versionDate;
            message = message + "\nBuild: " + props.getProperty("fullVersion", "");
        }
        message = message + " \n \n";
        message = message + "\n<br><br>For more information contact:\n<br><FONT SIZE=4>Hydrologic Engineering Center</FONT>\nInstitute for Water Resources\nUS Army Corps of Engineers\n609 Second Street\nDavis, CA 95616";
        AboutDialog aboutDialog = new AboutDialog((Frame)((Object)this), true, title, message, "www.hec.usace.army.mil", this.getHelpAboutImageFilename());
        aboutDialog.setLocationRelativeTo((Component)((Object)this));
        aboutDialog.setVisible(true);
    }

    protected String getHelpAboutImageFilename() {
        return null;
    }

    public void menuItemOptions_Action(Class tabClassToSelect) {
        DefaultJPanel[] plugInPanels;
        DefaultJPanel[] modulePanels;
        if (this._optionsDialog == null) {
            this._optionsDialog = new OptionDialog((Frame)((Object)this), true);
            if (this.getAppTitle() != "") {
                this._optionsDialog.setTitle(this.getAppTitle() + " Options");
            }
        }
        this._optionsDialog.removeModelSpecificPanels();
        DefaultJPanel[] globalPanels = ClientApp.app().getGlobalPanels();
        if (globalPanels != null) {
            for (int i = 0; i < globalPanels.length; ++i) {
                this._optionsDialog.addModelSpecificPanel(globalPanels[i]);
            }
        }
        if ((modulePanels = this.getCurrentMode().getModuleOptionsPanels()) != null) {
            for (int i = 0; i < modulePanels.length; ++i) {
                this._optionsDialog.addModelSpecificPanel(modulePanels[i]);
            }
        }
        if ((plugInPanels = ClientApp.app().getOptionPanels()) != null) {
            for (int i = 0; i < plugInPanels.length; ++i) {
                this._optionsDialog.addModelSpecificPanel(plugInPanels[i]);
            }
        }
        Dimension d = this._optionsDialog.getPreferredSize();
        this._optionsDialog.setSize(d.width, 340);
        if (tabClassToSelect != null) {
            this._optionsDialog.setSelectedTab(tabClassToSelect);
        }
        this._optionsDialog.setVisible(true);
        if (!this._optionsDialog.isCanceled()) {
            // empty if block
        }
    }

    void scriptMenu_Action(ActionEvent event) {
        if (this._scriptButtonFrame == null) {
            this._scriptButtonFrame = new ScriptButtonFrame((Frame)((Object)this));
        }
        if (!this._scriptButtonFrame.isVisible()) {
            this._scriptButtonFrame.setVisible(true);
        } else if (RMAIO.getOSType() != 2) {
            this._scriptButtonFrame.toFront();
        }
    }

    protected void scriptEditor_Action(ActionEvent event) {
        if (this._editorFrame == null || "Current Watershed" != ClientApp.Workspace().getName()) {
            this._editorFrame = new ScriptEditorDialog((Frame)((Object)this), false);
        }
        this._editorFrame.clearForm();
        this._editorFrame.setSelectedNode("ClientModule:" + this.getScriptableName(), "Current Watershed");
        this._editorFrame.setVisible(true);
        this.getContentPane().repaint();
    }

    protected String getScriptableName() {
        ClientMode mode = ClientApp.frame().getCurrentMode();
        return mode.getScriptableName();
    }

    void HecClientFrame_WindowClose(WindowEvent event) {
    }

    protected void HecClientFrame_WindowClosing(WindowEvent event) {
        this.menuItemExit_Action(null);
    }

    public boolean addMap(Frame frame) {
        Vector<RMAFilenameFilter> filters = new Vector<RMAFilenameFilter>();
        filters.add(new RMAFilenameFilter("*.*", "All Files (*.*)"));
        filters.add(new RMAFilenameFilter("*.dlg", "USGS DLG (*.dlg)"));
        filters.add(new RMAFilenameFilter("*.dxf", "AutoCAD DXF (*.dxf)"));
        filters.add(new RMAFilenameFilter("*.shp", "Arc Shapefile (*.shp)"));
        filters.add(new RMAFilenameFilter("*.img", "Raster Image (*.img)"));
        filters.add(new RMAFilenameFilter("*.dem", "USGS DEM (*.dem)"));
        filters.add(new RMAFilenameFilter("*.asc", "ArcInfo DEM (*.asc)"));
        if (frame == null) {
            frame = this;
        }
        RmiFileDialog chooser = new RmiFileDialog((Frame)frame, true, ClientApp.Workspace().getWorkspacePath() + "/maps", filters);
        chooser.setOpenTitle();
        chooser.setVisible(true);
        if (chooser.isCanceled()) {
            return false;
        }
        if (chooser.getIdentifier() == null) {
            return false;
        }
        Identifier id = chooser.getIdentifier();
        MapIdentifier mapIdentifier = this.addMap(id);
        chooser.dispose();
        return true;
    }

    public MapIdentifier addMap(RMAFilenameFilter type, String dir) {
        Vector<RMAFilenameFilter> v = new Vector<RMAFilenameFilter>(1);
        v.addElement(type);
        return this.addMap(v, dir);
    }

    public MapIdentifier addMap(Vector types, String dir) {
        RmiFileDialog chooser = new RmiFileDialog((Frame)((Object)this), true, dir, (List)types);
        chooser.setOpenTitle();
        chooser.setVisible(true);
        if (chooser.getIdentifier() != null) {
            Identifier id = chooser.getIdentifier();
            MapIdentifier mapId = this.addMap(id);
            chooser.dispose();
            return mapId;
        }
        chooser.dispose();
        return null;
    }

    public MapIdentifier addMap(Identifier id) {
        try {
            id = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), id);
        }
        catch (RemoteException re) {
            System.out.println("Caught remote exception opening map " + id.getPath() + " exception " + re);
            return null;
        }
        MapIdentifier mapId = new MapIdentifier(id);
        this.setWaitCursor();
        ClientApp.Workspace().addMap(mapId);
        this.printMessage("\nMap " + id.getName() + " loaded");
        this.updateWorkspace();
        this.setDefaultCursor();
        return mapId;
    }

    public void updateWorkspace() {
        ClientMode mode;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this._layerSelector != null) {
            if (this._layerSelector.isVisible()) {
                this._layerSelector.setMapPanel(this._mapPanel);
            } else {
                this._layerSelector = null;
            }
        }
        if (ClientApp.Workspace() != null) {
            try {
                this._mapPanel.addMaps(ClientApp.Workspace().getMaps());
                this._mapPanel.updateExtents();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            mode = (ClientMode)this._modeSelector.getItemAt(i);
            if (mode == null) continue;
            mode.updateWorkspace();
        }
        mode = this.getCurrentMode();
        if (mode != null) {
            mode.updateManagerMaps();
        }
        this._mapPanel.setPaintEnabled(true);
        this._mapPanel.paintMap();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void resetWorkspace() {
        long t2;
        long t1;
        int numModes = this.getNumberOfModes();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._mapPanel.removeAllMaps();
        if (ClientApp.Workspace() != null) {
            try {
                this._app.printStatus("Loading...");
                this._app.printMessage("Loading maps ....\n");
                t1 = System.currentTimeMillis();
                this._mapPanel.addMaps(ClientApp.Workspace().getMaps());
                t2 = System.currentTimeMillis();
                ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Loading Maps took %s ms.", t2 - t1);
                this._mapPanel.resetManagerOrder(ClientApp.Workspace().getManagerOrder());
                t1 = System.currentTimeMillis();
                ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Reset Manager Order took %s ms.", t2 - t1);
                this._app.setProgress(50);
                this._app.printMessage("Loading schematic elements ....\n");
                this._app.setProgress(60);
                this._mapPanel.updateExtents();
                t2 = System.currentTimeMillis();
                ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Update Map Extents took %s ms.", t2 - t1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setMenusEnabled(true);
            StreamAlignmentDrwPro.getInstance().reset();
        } else {
            ClientMode currentMode = this.getCurrentMode();
            this.setMenusEnabled(false);
            currentMode.mapTools().setEnabled(false);
        }
        try {
            this._app.printStatus("Loading modules...");
            t1 = System.currentTimeMillis();
            for (int i = 0; i < numModes; ++i) {
                ClientMode mode = (ClientMode)this._modeSelector.getItemAt(i);
                if (mode == null) continue;
                mode.setWorkspaceLoaded(false);
            }
            this._app.setProgress(70);
            final ClientMode currentMode = this.getCurrentMode();
            ModeDrawingAttributeSet.workspaceOpening();
            t2 = System.currentTimeMillis();
            ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Cleaning up modules took %s ms.", t2 - t1);
            if (currentMode != null) {
                try {
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            HecClientFrame.this._app.setProgress(72);
                            currentMode.panel().setEnabled(ClientApp.Workspace() != null);
                            HecClientFrame.this._app.setProgress(73);
                            long t1 = System.currentTimeMillis();
                            currentMode.resetWorkspace();
                            long t2 = System.currentTimeMillis();
                            ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("ResetWorkspace on %s took: %s ms", (Object)currentMode, t2 - t1);
                            HecClientFrame.this._app.setProgress(75);
                            currentMode.updateFrameToolBar();
                            t1 = System.currentTimeMillis();
                            ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Loading toolbar %s took: %s ms", (Object)currentMode, t2 - t1);
                            HecClientFrame.this._toolbarPanel.revalidate();
                            HecClientFrame.this._toolbarPanel.repaint();
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        run.run();
                    } else {
                        SwingUtilities.invokeAndWait(run);
                    }
                    if (!currentMode.canOpen()) {
                        System.out.println("resetWorkspace: can't open mode " + currentMode);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HecClientFrame.this.unlockAll();
                                ClientApp.Workspace().close();
                                System.out.println("resetWorkspace: invokeLater setWorkspace(null) now executing, " + currentMode);
                                ClientApp.setWorkspace(null);
                                HecClientFrame.this.setMenusEnabled(false);
                                currentMode.panel().setEnabled(false);
                                currentMode.mapTools().setEnabled(false);
                                HecClientFrame.this.updateTitle();
                                HecClientFrame.this.getMapPanel().removeAllMaps();
                            }
                        });
                        return;
                    }
                    this.loadUnitsTimezone();
                    this._app.setProgress(80);
                    t1 = System.currentTimeMillis();
                    currentMode.modeOpening();
                    t2 = System.currentTimeMillis();
                    ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Opening mode %s took: %s ms", (Object)currentMode, t2 - t1);
                }
                catch (UnsatisfiedLinkError ule) {
                    System.out.println("error resetingWorkspace on mode " + currentMode.getClass() + " " + ule);
                    ule.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    System.out.println("error resetingWorkspace on mode " + currentMode.getClass() + " " + ite.getCause());
                    if (ite.getCause() != null) {
                        ite.getCause().printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.out.println("error resetingWorkspace on mode " + currentMode.getClass() + " " + e);
                    e.printStackTrace();
                }
            }
            this._app.printMessage("Updating schematic...\n");
            t1 = System.currentTimeMillis();
            if (currentMode != null) {
                currentMode.updateManagerMaps();
            }
            this._app.setProgress(85);
            this._mapPanel.setPaintEnabled(true);
            this._mapPanel.paintMap();
            t2 = System.currentTimeMillis();
            this._app.setProgress(90);
            ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("Updating schematic took: %s ms", t2 - t1);
            if (ClientApp.Workspace() != null && ClientApp.app()._openExistingWksp) {
                ClientApp.Workspace().setModified(false);
            }
        }
        catch (Exception mode) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setGlyphStateFromToolbar();
        if (this._scriptButtonFrame != null && this._scriptButtonFrame.isVisible()) {
            t1 = System.currentTimeMillis();
            this._scriptButtonFrame.updateScriptButtons();
            t2 = System.currentTimeMillis();
            ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("loading script buttons took: %s ms", t2 - t1);
        }
        if (this._optionsDialog != null) {
            this._optionsDialog.removeModelSpecificPanels();
            DefaultJPanel[] globalPanels = ClientApp.app().getGlobalPanels();
            if (globalPanels != null) {
                for (int i = 0; i < globalPanels.length; ++i) {
                    this._optionsDialog.addModelSpecificPanel(globalPanels[i]);
                }
            }
        }
        if (this._layerSelector != null) {
            if (this._layerSelector.isVisible()) {
                this._layerSelector.setMapPanel(this._mapPanel);
                this._layerSelector.updateTitle();
            } else {
                this._layerSelector = null;
            }
        }
    }

    protected void loadUnitsTimezone() {
        if (ClientApp.Workspace() != null) {
            if (ClientApp.Workspace().getUnitSystem() == 1) {
                this._englishUnitItem.setText("English (Watershed)");
                this._SIUnitItem.setText("SI");
            } else if (ClientApp.Workspace().getUnitSystem() == 2) {
                this._SIUnitItem.setText("SI (Watershed)");
                this._englishUnitItem.setText("English");
            }
            int offset = ClientApp.Workspace().getGmtOffset();
            this.watershedTimeZoneItem.setText("Watershed (GMT " + offset + ":00)");
            String timeZoneProperty = null;
            String unitSystemProperty = null;
            String customTimeZoneProperty = null;
            Properties properties = PreferencesManager.getProperties((int)0, (String)"display.properties");
            if (properties != null) {
                unitSystemProperty = properties.getProperty(UNIT_SYSTEM_PROP_KEY);
                timeZoneProperty = properties.getProperty(TIME_ZONE_PROP_KEY);
                customTimeZoneProperty = properties.getProperty(CUSTOM_TIME_ZONE_KEY);
            }
            if ("English".equals(unitSystemProperty)) {
                this.setDisplayUnitSystem(1);
            } else if ("SI".equals(unitSystemProperty)) {
                this.setDisplayUnitSystem(2);
            } else {
                this.setDisplayUnitSystem(ClientApp.Workspace().getUnitSystem());
            }
            if (LOCAL_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                this.localTimeZoneItem.setSelected(true);
                ClientApp.app().setClientTimeZone(TimeZone.getDefault());
                _timeZone = 0;
                this.selectTimeZoneItem.setText(CUSTOM_TIME_ZONE_STR);
            } else if (AS_STORED_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                this.asStoredTimeZoneItem.setSelected(true);
                ClientApp.app().setClientTimeZone(null);
                _timeZone = 4;
                this.selectTimeZoneItem.setText(CUSTOM_TIME_ZONE_STR);
            } else if (WATERSHED_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                this.watershedTimeZoneItem.setSelected(true);
                ClientApp.app().setClientTimeZone(ClientApp.Workspace().getWatershedTimeZone());
                _timeZone = 1;
                this.selectTimeZoneItem.setText(CUSTOM_TIME_ZONE_STR);
            } else if (UTC_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                this.utcTimeZoneItem.setSelected(true);
                TimeZone tz = TimeZone.getTimeZone(UTC_TIME_ZONE_STR);
                ClientApp.app().setClientTimeZone(tz);
                _timeZone = 3;
                this.selectTimeZoneItem.setText(CUSTOM_TIME_ZONE_STR);
            } else if (CUSTOM_TIME_ZONE_STR.equalsIgnoreCase(timeZoneProperty)) {
                this.selectTimeZoneItem.setSelected(true);
                TimeZone customTimeZone = null;
                customTimeZone = customTimeZoneProperty != null ? TimeZone.getTimeZone(customTimeZoneProperty) : TimeZone.getDefault();
                ClientApp.app().setClientTimeZone(customTimeZone);
                _timeZone = 2;
                this.selectTimeZoneItem.setText("Custom (" + ClientApp.app().getClientTimeZone().getID() + ")");
            } else {
                this.watershedTimeZoneItem.setSelected(true);
                ClientApp.app().setClientTimeZone(ClientApp.Workspace().getWatershedTimeZone());
                _timeZone = 1;
            }
        }
    }

    public void printMessage(String msg) {
        if (msg == null || msg.length() == 0) {
            return;
        }
        this._msgLineUpdater.setText(msg);
        if (SwingUtilities.isEventDispatchThread()) {
            this._msgLineUpdater.run();
        } else {
            SwingUtilities.invokeLater(this._msgLineUpdater);
        }
    }

    public void setAlarmMessage(String message, Color foregroundColor, Color backgroundColor) {
    }

    public void printStatus(String msg) {
        if (msg == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.textFieldStatus.setText(msg);
        } else {
            SwingUtilities.invokeLater(new TextFieldThread((JTextField)this.textFieldStatus, msg));
        }
    }

    public void printWarningMessage(String msg) {
        if (msg == null) {
            return;
        }
        this._app.errMsgBox(new Msg(msg, 3));
    }

    public void printErrorMessage(String msg) {
        if (msg == null) {
            return;
        }
        this._app.errMsgBox(new Msg(msg, 1));
    }

    public void setProgress(int i) {
        this.printStatus("Progress " + i);
    }

    public void saveState() {
        ClientApp.app().putAppProp("lastModuleAccessed", this.getCurrentMode().getScriptableName());
        String iconSizeString = null;
        if (this.cbmitemSmall.isSelected()) {
            iconSizeString = "Small";
        } else if (this.cbmitemMedium.isSelected()) {
            iconSizeString = "Medium";
        } else if (this.cbmitemLarge.isSelected()) {
            iconSizeString = "Large";
        } else if (this.cbmitemDefault.isSelected()) {
            iconSizeString = "Default";
        }
        if (iconSizeString != null) {
            ClientApp.app().putAppProp("iconSize", iconSizeString);
        }
        String unitSystem = null;
        unitSystem = _unitSystem == 1 ? "English" : (_unitSystem == 2 ? "SI" : AS_STORED_TIME_ZONE_STR);
    }

    public void computeComplete() {
        this.printStatus("Compute Complete");
    }

    public boolean isCanceled() {
        return false;
    }

    public void updateTitle() {
    }

    private boolean menuWorkspaceExists(int num, Vector wkspLocs) {
        if (wkspLocs == null) {
            return false;
        }
        String wkspPath = ClientApp.app().getLastWorkspacePath(num);
        boolean exists = false;
        if (wkspPath != null && !wkspPath.equals("")) {
            if (ClientApp.app().isStandalone()) {
                try {
                    exists = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).fileExists(wkspPath);
                }
                catch (RemoteException re) {
                    exists = false;
                }
                return exists;
            }
            for (int i = 0; i < wkspLocs.size(); ++i) {
                WatershedLocation wl = (WatershedLocation)wkspLocs.get(i);
                if (!RMAIO.isRelativePathTo((String)(wl.getDirectory() + "/"), (String)wkspPath)) continue;
                try {
                    exists = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).fileExists(wkspPath);
                }
                catch (RemoteException re) {
                    exists = false;
                }
                if (!exists) continue;
                return true;
            }
        }
        return false;
    }

    public void setSavedMenus(String[] wkspNames) {
        List<String> wkspNamesList = Arrays.asList(wkspNames);
        this.setSavedMenus(wkspNamesList);
    }

    private void openRecentWatershedAction(JMenuItem mi) {
        String lastWkspName = mi.getName();
        String wkspPath = mi.getToolTipText();
        if (wkspPath != null && !wkspPath.equals("")) {
            Identifier id = new Identifier(wkspPath);
            id.setName(lastWkspName);
            try {
                id = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), id);
            }
            catch (RemoteException re) {
                return;
            }
            if (id == null) {
                return;
            }
            ClientApp.app().openWorkspace(id);
        }
    }

    public void setSavedMenus(List<String> wkspNames) {
        Vector wlocs = ClientApp.app().getWatershedLocations(true);
        if (wkspNames != null) {
            this.removeWorkspaceReloadMenuItems();
            for (int i = 0; i < wkspNames.size() && wkspNames.get(i) != null; ++i) {
                String name;
                String menuLabel = name = wkspNames.get(i);
                boolean exists = this.menuWorkspaceExists(i, wlocs);
                String menuToolTip = ClientApp.app().getLastWorkspacePath(i);
                JMenuItem menuItemLast = this.createRecentMenuItem(menuLabel, menuToolTip, name, exists);
                this.menuFile.add(menuItemLast);
            }
        }
    }

    private JMenuItem createRecentMenuItem(String menuLabel, String menuToolTip, String name, boolean exists) {
        Identifier id = new Identifier(menuToolTip);
        Identifier openedId = null;
        RmiFileManager fileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            openedId = fileManager.openFile(UserId.getUserId(), id);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (openedId != null) {
            HecClientFrame.getWatershedFileInfo(openedId);
        }
        final Identifier fOpenId = openedId;
        JMenuItem menuItemLast = new JMenuItem(menuLabel){

            @Override
            public String getToolTipText(MouseEvent e) {
                if (fOpenId != null) {
                    String txt = "<html><b>Watershed Name:</b> " + fOpenId.getName() + "<br><b>Watershed File:</b> " + fOpenId.getPath() + "<br><b>Description:</b> " + fOpenId.getDescription() + "<br><b>Last Modified On:</b> " + new Date(fOpenId.lastModified());
                    return txt;
                }
                return super.getToolTipText(e);
            }
        };
        menuItemLast.setActionCommand(RECENT_MENU_ITEM);
        menuItemLast.addActionListener(e -> this.openRecentWatershedAction((JMenuItem)e.getSource()));
        menuItemLast.setToolTipText(menuToolTip);
        menuItemLast.setName(name);
        menuItemLast.setEnabled(exists);
        return menuItemLast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getWatershedFileInfo(Identifier fileId) {
        if (fileId == null) {
            return false;
        }
        boolean isNameFound = false;
        HecFile file = fileId.getFile();
        if (file == null) {
            return false;
        }
        fileId.setLastModified(file.lastModified());
        BufferedReader input = file.getBufferedReader();
        if (input == null) {
            return false;
        }
        try {
            String line;
            while ((line = input.readLine()) != null) {
                line = line.trim();
                String type = RMAIO.getType((String)line, (String)"=");
                String param = RMAIO.getParam((String)line, (String)"=");
                if ("WorkspaceName".equalsIgnoreCase(type)) {
                    fileId.setName(param);
                    isNameFound = true;
                } else if ("WorkspaceDescription".equals(type)) {
                    fileId.setDescription(param);
                    break;
                }
                line = input.readLine();
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)FluentLogger.forEnclosingClass().atWarning()).log("Error Reading watershed file  %s" + e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return isNameFound;
    }

    private void removeWorkspaceReloadMenuItems() {
        Component[] menus = this.menuFile.getMenuComponents();
        for (int i = menus.length - 1; i >= 0; --i) {
            JMenuItem mi;
            if (!(menus[i] instanceof JMenuItem) || !RECENT_MENU_ITEM.equals((mi = (JMenuItem)menus[i]).getActionCommand())) continue;
            this.menuFile.remove(mi);
        }
    }

    private JMenuItem getRecentWatershedMenu(int idx) {
        Component[] menus = this.menuFile.getMenuComponents();
        int cnt = -1;
        for (int i = 0; i < menus.length; ++i) {
            JMenuItem mi;
            if (!(menus[i] instanceof JMenuItem) || !RECENT_MENU_ITEM.equals((mi = (JMenuItem)menus[i]).getActionCommand()) || ++cnt != idx) continue;
            return mi;
        }
        return null;
    }

    public void unlockAll() {
        this.unlockAll((RmiFileManager)ClientApp.app().getFileManager().getRemote());
    }

    public void unlockAll(RmiFileManager fm) {
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            ClientMode mode = (ClientMode)this._modeSelector.getItemAt(i);
            if (mode == null) continue;
            mode.unlock();
        }
        if (fm == null) {
            return;
        }
        if (ClientApp.Workspace() != null && ClientApp.app().networked) {
            try {
                System.out.println("Unlocking files with filemanager");
                fm.unlockAll(ClientApp.app().getUser());
                ClientApp.Workspace().removeAllManagersCallbacks();
            }
            catch (RemoteException re) {
                System.out.println("Caught remote exception unlocking all files " + re);
            }
        }
    }

    public void workspaceOpening() {
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            ClientMode currentMode = (ClientMode)this._modeSelector.getItemAt(i);
            if (currentMode == null) continue;
            currentMode.workspaceOpening();
        }
    }

    public boolean workspaceClosing() {
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            ClientMode currentMode = (ClientMode)this._modeSelector.getItemAt(i);
            if (currentMode == null || currentMode.workspaceClosing()) continue;
            return false;
        }
        if (this._layerSelector != null && this._layerSelector.isVisible()) {
            this._layerSelector.unlock();
        }
        return true;
    }

    public void workspaceClosed() {
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            ClientMode currentMode = (ClientMode)this._modeSelector.getItemAt(i);
            if (currentMode == null) continue;
            currentMode.workspaceClosed();
        }
    }

    public String getModeName() {
        ClientMode currentMode = (ClientMode)this._modeSelector.getSelectedItem();
        if (currentMode != null) {
            return currentMode.getName();
        }
        return "";
    }

    public void setIconMenuEnabled(boolean b) {
        this.iconMenu.setEnabled(b);
    }

    public void setMenusEnabled(boolean b) {
        int i;
        this.menuEdit.setEnabled(b);
        this.menuView.setEnabled(b);
        this.scriptMenu.setEnabled(b);
        if (b && this.scriptEditor.isVisible()) {
            this.scriptEditor.setEnabled(b);
        }
        this.menuItemSave.setEnabled(b);
        this.menuItemSaveMap.setEnabled(b);
        this.menuItemExport.setEnabled(b);
        this._frameToolBar.setEnabled(b);
        if (this._modeMenus != null) {
            for (i = 0; i < this._modeMenus.size(); ++i) {
                ((Component)this._modeMenus.elementAt(i)).setEnabled(b);
            }
        }
        if (this._projectEnabledComponents != null) {
            for (i = 0; i < this._projectEnabledComponents.size(); ++i) {
                ((Component)this._projectEnabledComponents.get(i)).setEnabled(b);
            }
        }
        if (b) {
            this.menuDownloadWatershed.setEnabled(ClientApp.Workspace() != null);
        } else {
            this.menuDownloadWatershed.setEnabled(b);
        }
    }

    public JToolBar getDefaultToolBar() {
        if (!this._frameToolBarInitd) {
            this.createDefaultToolBar();
        }
        return this._frameToolBar;
    }

    private void createDefaultToolBar() {
        this._frameToolBar.setFloatable(false);
        this._frameToolBar.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(8, 5, 0, 5);
        this._modeSelectorLabel = new JLabel("Module: ");
        this._modeSelectorLabel.setDisplayedMnemonic('m');
        this._modeSelectorLabel.setLabelFor((Component)this._modeSelector);
        this._frameToolBar.add((Component)this._modeSelectorLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 0, 0, 5);
        this._frameToolBar.add((Component)this._modeSelector, gbc);
        Dimension dim = this._modeSelector.getPreferredSize();
        dim.width += 15;
        this._modeSelector.setMinimumSize(dim);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        this._frameToolBar.add((Component)new JLabel(" "), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        this._frameToolBar.add((Component)this._toolbarPanel, gbc);
        this._frameToolBarInitd = true;
    }

    public int getNumberOfModes() {
        return this._modeSelector.getItemCount();
    }

    public String[] getModeNames() {
        String[] modeNames = new String[this.getNumberOfModes()];
        for (int i = 0; i < modeNames.length; ++i) {
            modeNames[i] = ((ClientMode)this._modeSelector.getItemAt(i)).getScriptableName();
        }
        return modeNames;
    }

    public ClientMode getModeByName(String modeName) {
        int numModes = this.getNumberOfModes();
        for (int i = 0; i < numModes; ++i) {
            ClientMode mode = (ClientMode)this._modeSelector.getItemAt(i);
            if (!mode.getScriptableName().equals(modeName)) continue;
            return mode;
        }
        return null;
    }

    protected void setAppTitle(String title) {
        if (title == null) {
            return;
        }
        Properties properties = RMAIO.getAppVersionProperties(ClientApp.app().getClass());
        String version = properties == null ? ClientApp.getVersionString() : properties.getProperty("shortVersion", "");
        this._appTitle = version != null ? title + version + " " : title;
    }

    public String getAppTitle() {
        return this._appTitle;
    }

    public void setVisible(boolean visible) {
        boolean setLocation = true;
        if (visible) {
            this.setDefaultMode();
            setLocation = this.setSizeAndLocation();
        }
        super.setVisible(visible);
        SplashWindow.closeSplashWindow();
        if (visible && !setLocation) {
            this.setExtendedState(6);
        }
        if (visible) {
            SwingUtilities.invokeLater(() -> ((CheckForClientAppInterimTermsAction)this.checkForBetaAction).showIfAppropriate());
        }
    }

    protected void setDefaultMode() {
        String lastModuleString = ClientApp.app().getAppProp("lastModuleAccessed");
        if (lastModuleString != null) {
            ClientMode curMode = (ClientMode)this._modeSelector.getSelectedItem();
            if (!lastModuleString.equals(curMode.getScriptableName())) {
                this._modeSelector.setSelectedIndex(-1);
                if (!this.selectMode(lastModuleString)) {
                    this._modeSelector.setSelectedIndex(0);
                }
            }
        } else {
            this._modeSelector.setSelectedIndex(0);
        }
    }

    protected boolean setSizeAndLocation() {
        String gridLines;
        int extendedState;
        String state;
        HECProperties properties;
        String windowSize;
        int y;
        int x;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        String loc = ClientApp.app().getAppProp("mainWindow.position");
        if (loc != null && virtualBounds.contains(x = RMAIO.parseInt((String)RMAIO.getType((String)loc, (String)","), (int)0), y = RMAIO.parseInt((String)RMAIO.getParam((String)loc, (String)","), (int)0))) {
            this.setLocation(x, y);
        }
        if ((windowSize = ClientApp.app().getAppProp("mainWindow.size")) != null) {
            int height;
            int width = (int)RMAIO.parseDouble((String)RMAIO.getType((String)windowSize, (String)","), (double)-1.0);
            if (!virtualBounds.intersects(new Rectangle(width, height = (int)RMAIO.parseDouble((String)RMAIO.getParam((String)windowSize, (String)","), (double)-1.0)))) {
                return false;
            }
            if (width > -1 && height > -1) {
                this.setSize(width, height);
            }
        }
        if ((properties = ClientApp.app().getProperties()) != null && (state = properties.getProp("mainWindow.state")) != null && ((extendedState = Integer.valueOf(state).intValue()) & 6) == 6) {
            this.setExtendedState(6);
        }
        if ((gridLines = ClientApp.app().getAppProp("mainWindow.gridLines")) != null && gridLines.equals("false")) {
            this.getMapPanel().viewport().setDrawGrids(false);
        } else {
            this.menuItemShowGrids.setSelected(true);
        }
        return true;
    }

    protected void saveSizeAndLocation() {
        Point p = this.getLocation();
        Dimension d = this.getSize();
        ClientApp.app().getProperties().setProp("mainWindow.position", p.x + "," + p.y);
        ClientApp.app().getProperties().setProp("mainWindow.size", d.getWidth() + "," + d.getHeight());
        int extendedState = this.getExtendedState();
        ClientApp.app().getProperties().setProp("mainWindow.state", Integer.toString(extendedState));
    }

    public void setWaitCursor() {
        this.setCursor(this._waitCursor);
        this._mapPanel.viewport().setCursor(this._waitCursor);
    }

    public void setDefaultCursor() {
        this.setCursor(this._defaultCursor);
        this._mapPanel.viewport().setCursor(this._mapPanel.viewport().getMapMouseAdapter().getCursor());
    }

    public void properties() {
        ClientPropertiesJDialog propDialog = new ClientPropertiesJDialog((Frame)((Object)this), true);
        propDialog.fillForm(ClientApp.app());
        propDialog.setVisible(true);
    }

    public void managerInfo() {
        this.getCurrentMode().managerInfo();
    }

    public void setUnitsMenuEnabled(boolean enable) {
        this.menuUnitSystem.setEnabled(enable);
    }

    public void setTimeZoneMenuVisible(boolean visible) {
        this.menuTimeZone.setVisible(visible);
        this.initTimeZone();
    }

    public void setAsStoredTimeZoneMenuVisible(boolean visible) {
        this.asStoredTimeZoneItem.setVisible(visible);
        this.initTimeZone();
    }

    public void setAttributesMenuEnabled(boolean enable) {
    }

    public void setLayerMenuItemsEnabled(boolean enable) {
        this.MenuItemLayers.setEnabled(enable);
        if (this._layerSelector == null) {
            return;
        }
        if (!enable && this._layerSelector.isModified()) {
            Object[] options = new Object[]{"Yes", "No"};
            int opt = JOptionPane.showOptionDialog((Component)((Object)this), "Do you want to save changes made to Layers?", "Closing Layers Dialog", -1, 3, null, options, options[0]);
            switch (opt) {
                case 1: {
                    this._layerSelector.cancel();
                    break;
                }
                case 0: {
                    this._layerSelector.ok();
                }
            }
        } else {
            this._layerSelector.ok();
        }
    }

    public void restoreWindows_Action() {
        Frame[] frames = Frame.getFrames();
        if (frames == null || frames.length < 1) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] == this || frames[i] == null) continue;
            if (frames[i].getState() == 1) {
                frames[i].setState(0);
                continue;
            }
            frames[i].toFront();
        }
    }

    protected void showGrids_Action() {
        if (this.menuItemShowGrids.isSelected()) {
            this.getMapPanel().viewport().setDrawGrids(true);
            ClientApp.app().putAppProp("mainWindow.gridLines", "true");
        } else {
            this.getMapPanel().viewport().setDrawGrids(false);
            ClientApp.app().putAppProp("mainWindow.gridLines", "false");
        }
        this._mapPanel.paintMap();
    }

    public void dssVue_Action() {
        this.getCurrentMode().dssVue_Action();
    }

    public void memoryMonitor_Action() {
        if (this._memMonitorFrame == null) {
            final MemoryMonitor demo = new MemoryMonitor();
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    demo.surf.stop();
                    HecClientFrame.this._memMonitorFrame = null;
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    demo.surf.start();
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    demo.surf.start();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    demo.surf.stop();
                }
            };
            this._memMonitorFrame = new RmaJFrame("MemoryMonitor");
            this._memMonitorFrame.setSystemClosable(false);
            this._memMonitorFrame.addWindowListener((WindowListener)l);
            this._memMonitorFrame.getContentPane().add("Center", (Component)demo);
            this._memMonitorFrame.pack();
            this._memMonitorFrame.setSize(new Dimension(200, 200));
            this._memMonitorFrame.setVisible(true);
        } else if (this._memMonitorFrame.getState() == 1) {
            this._memMonitorFrame.setState(0);
        } else if (!this._memMonitorFrame.isVisible()) {
            this._memMonitorFrame.setVisible(true);
        } else {
            this._memMonitorFrame.toFront();
        }
    }

    protected void download(String directory) {
        String what;
        Object localDirectory;
        Identifier[] remoteIds = this.remoteBrowse(directory);
        if (remoteIds == null) {
            return;
        }
        if (remoteIds.length == 0) {
            return;
        }
        Identifier localDir = this.localBrowseForDirectory();
        if (localDir == null) {
            return;
        }
        Object localName = localDirectory = localDir.getPath();
        if (remoteIds.length == 1) {
            what = remoteIds[0].getPath();
            String name = RMAIO.getFileFromPath((String)what);
            localName = (String)localName + "/" + name;
            if (remoteIds[0].isDirectory()) {
                localDirectory = localName;
            }
        } else {
            what = "files";
        }
        Vector<String> remoteNames = new Vector<String>();
        Vector<String> localNames = new Vector<String>();
        ClientCache.getLocalNames(remoteIds, (String)localDirectory, remoteNames, localNames);
        StringBuffer message = new StringBuffer();
        boolean exists = false;
        for (int i = 0; i < localNames.size(); ++i) {
            File f = new File(localNames.elementAt(i));
            if (!f.exists()) continue;
            if (localNames.size() == 1) {
                message.append(localNames.elementAt(i) + " already exists.\n");
            } else {
                message.append("Files already exist.\n");
            }
            exists = true;
            break;
        }
        localDirectory = ((String)localDirectory).replace('/', '\\');
        message.append("Are you sure you want to download " + what + " to " + (String)localDirectory);
        if (exists) {
            message.append("\nand overwrite existing file(s)?");
        } else {
            message.append("?");
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), message.toString(), "Download", 0, 3);
        if (opt == 0) {
            this.setWaitCursor();
            ClientApp.app().getCache().downloadWithProgress(remoteIds, (String)localDirectory, true);
            this.setDefaultCursor();
        }
    }

    protected String getServerLogDir() {
        String cwmsHome = this._app.getApplicationProperty("CWMS_HOME");
        String logDir = cwmsHome + "/dated/logs/caviServers";
        return logDir;
    }

    protected String getServerLogName() {
        String baseDir = this.getServerLogDir();
        boolean error = false;
        String logName = null;
        try {
            String[] remoteNames;
            if (baseDir == null) {
                return null;
            }
            String[] exclude = new String[]{".bak"};
            byte[] compressedNames = ((RmiFileManager)this._app.getFileManager().getRemote()).getCompressedFileNamesAndInfo(this._app.getUser(), baseDir, exclude);
            if (compressedNames == null || compressedNames.length == 0) {
                error = true;
            }
            if ((remoteNames = ClientCache.uncompressFileNames(compressedNames, "")) == null || remoteNames.length == 0) {
                error = true;
            }
            String lastName = null;
            String currentName = null;
            if (!error) {
                for (int i = 0; i < remoteNames.length; ++i) {
                    int idx = remoteNames[i].indexOf("ervers.dy.");
                    if (idx <= 0 || (idx = remoteNames[i].indexOf("/")) <= 0) continue;
                    currentName = remoteNames[i].substring(idx + 1);
                    if (lastName != null) {
                        if (currentName.compareTo(lastName) <= 0) continue;
                        lastName = currentName;
                        continue;
                    }
                    lastName = currentName;
                }
                return lastName;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to access log file area " + e, "View Server Log", 2);
            return null;
        }
        if (error) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to access log file area ", "View Server Log", 2);
            return null;
        }
        return logName;
    }

    protected void viewServerLog() {
        try {
            String name = this.getServerLogName();
            if (name == null) {
                return;
            }
            String path = this.getServerLogDir() + "/" + name;
            File file = File.createTempFile(name, ".tmp");
            this.setWaitCursor();
            boolean success = this._app.getCache().downloadFile(path, file.getPath(), true);
            this.setDefaultCursor();
            if (success) {
                TextDialog textDialog = new TextDialog((Component)((Object)this));
                textDialog.initialize(file.getPath(), true);
                textDialog.showMenuItems(false, true, true, true);
                textDialog.setTitle(name);
                textDialog.setLocation(20, 20);
                textDialog.setSize(700, 500);
                textDialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Error on reading file " + path, "View Server Log", 2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to create temporary file " + e, "View Server Log", 2);
            return;
        }
    }

    protected void downloadCurrentServerLog() {
        String downloadedLog;
        Identifier localDir = this.localBrowseForDirectory();
        if (localDir == null) {
            return;
        }
        String name = this.getServerLogName();
        if (name == null) {
            return;
        }
        String path = this.getServerLogDir() + "/" + name;
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to download the server log\n" + path + " to\n" + (downloadedLog = localDir.getPath() + "/" + name + ".txt") + "?", "Download Server Log", 0);
        if (opt == 1) {
            return;
        }
        try {
            this.setWaitCursor();
            boolean success = this._app.getCache().downloadFile(path, downloadedLog, true);
            this.setDefaultCursor();
            if (success) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Server log file downloaded to " + downloadedLog, "Download Server log", 1);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error downloading log file " + downloadedLog + "\n" + e, "Download Server log", 2);
        }
    }

    protected void downloadServerLogs() {
        String directory = this.getServerLogDir();
        this.download(directory);
    }

    protected void viewFile(boolean edit) {
        Identifier remoteFile = this.remoteBrowse(false);
        if (remoteFile == null) {
            return;
        }
        try {
            String name = RMAIO.getFileFromPath((String)remoteFile.getPath());
            Object tmpname = name;
            if (((String)tmpname).length() < 3) {
                tmpname = "tmp" + name;
            }
            File file = File.createTempFile((String)tmpname, ".tmp");
            this.setWaitCursor();
            boolean success = this._app.getCache().downloadFile(remoteFile.getPath(), file.getPath(), true);
            this.setDefaultCursor();
            if (success) {
                TextDialog textDialog = new TextDialog((Component)((Object)this));
                textDialog.initialize(file.getPath(), true);
                if (edit) {
                    textDialog.showMenuItems(true, false, true, true);
                } else {
                    textDialog.showMenuItems(false, false, false, true);
                }
                textDialog.setEditMode(edit);
                textDialog.setTitle(name);
                textDialog.setLocation(20, 20);
                textDialog.setSize(700, 500);
                if (edit) {
                    textDialog.setModal(true);
                }
                textDialog.setVisible(true);
                if (textDialog.saved()) {
                    success = this._app.getCache().uploadFile(file.getPath(), remoteFile.getPath(), true);
                    if (success) {
                        JOptionPane.showMessageDialog((Component)((Object)this), remoteFile.getPath() + " saved.", "Edit File", 1);
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Error in attempting to save " + remoteFile.getPath(), "Edit File", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Error on reading file " + remoteFile.getPath(), "View/Edit File", 2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to create temporary file " + e, "View/Edit File", 2);
            return;
        }
    }

    protected void upload() {
        String what;
        Object remoteDirectory;
        File[] files = this.localBrowse();
        if (files == null) {
            return;
        }
        if (files.length == 0) {
            return;
        }
        Identifier remoteDir = this.remoteBrowse(true);
        if (remoteDir == null) {
            return;
        }
        Object remoteName = remoteDirectory = remoteDir.getPath();
        if (files.length == 1) {
            what = files[0].getPath();
            String name = RMAIO.getFileFromPath((String)what);
            remoteName = (String)remoteName + "/" + name;
            if (files[0].isDirectory()) {
                remoteDirectory = remoteName;
            }
        } else {
            what = "files";
        }
        boolean exists = false;
        StringBuffer message = new StringBuffer();
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (fm == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to communicate with server");
            return;
        }
        Vector<String> localNames = new Vector<String>();
        Vector<String> remoteNames = new Vector<String>();
        ClientCache.getRemoteNames(files, (String)remoteDirectory, localNames, remoteNames);
        for (int i = 0; i < remoteNames.size(); ++i) {
            try {
                if (!fm.fileExists(remoteNames.elementAt(i))) continue;
                if (remoteNames.size() == 1) {
                    message.append(remoteNames.elementAt(i) + " already exists.\n");
                } else {
                    message.append("Files already exist.\n");
                }
                exists = true;
                break;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to communicate with server\n" + e);
                System.out.println(e);
                return;
            }
        }
        message.append("Are you sure you want to upload " + what + " to " + (String)remoteName);
        if (exists) {
            message.append("\nand overwrite existing file(s)?");
        } else {
            message.append("?");
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), message.toString(), "Upload", 0, 3);
        if (opt == 0) {
            this.setWaitCursor();
            ClientApp.app().getCache().uploadWithProgress(files, (String)remoteDirectory, true);
            this.setDefaultCursor();
        }
    }

    protected Identifier remoteBrowse(boolean directory) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Vector<String> v = new Vector<String>();
        v.addElement("*.*");
        if (this._remoteBrowseStartDir == null) {
            this._remoteBrowseStartDir = this._app.getAppProp("DownloadDirectory");
        }
        if (this._remoteBrowseStartDir == null) {
            try {
                this._remoteBrowseStartDir = this._app.getServerProperty(ApplicationProperties.getAppHomeVariable());
            }
            catch (Exception re) {
                return null;
            }
        }
        if (this._remoteBrowseStartDir == null || this._remoteBrowseStartDir.equals(".")) {
            this._remoteBrowseStartDir = System.getProperty("user.dir");
        }
        RmiFileDialog fd = new RmiFileDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)), true, this._remoteBrowseStartDir, v);
        if (directory) {
            fd.setOpenDirectory();
            fd.setStartDir(this._remoteBrowseStartDir);
            fd.setTitle("Select Remote Folder");
        } else {
            fd.setTitle("Select Remote File");
        }
        fd.setFileOpener((FileOpener)this._app);
        this.setCursor(Cursor.getDefaultCursor());
        fd.setVisible(true);
        if (fd.isCanceled()) {
            return null;
        }
        Identifier id = fd.getIdentifier();
        this._remoteBrowseStartDir = fd.getDirectory();
        this._app.putAppProp("DownloadDirectory", this._remoteBrowseStartDir);
        return id;
    }

    protected Identifier[] remoteBrowse(String startDir) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Vector<String> v = new Vector<String>();
        v.addElement("*.*");
        if (this._remoteBrowseStartDir == null) {
            this._remoteBrowseStartDir = this._app.getAppProp("DownloadDirectory");
        }
        if (this._remoteBrowseStartDir == null) {
            try {
                this._remoteBrowseStartDir = this._app.getServerProperty(ApplicationProperties.getAppHomeVariable());
            }
            catch (Exception re) {
                return null;
            }
        }
        if (this._remoteBrowseStartDir == null || this._remoteBrowseStartDir.equals(".")) {
            this._remoteBrowseStartDir = System.getProperty("user.dir");
        }
        boolean startSpecified = true;
        if (startDir == null) {
            startDir = this._remoteBrowseStartDir;
            startSpecified = false;
        }
        RmiFileDialog fd = new RmiFileDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)), true, startDir, v);
        fd.setMultipleSelectionAllowed(true);
        fd.setOpenDirectoryOrFiles();
        fd.setStartDir(startDir);
        fd.setTitle("Select Remote Directory or File(s)");
        fd.setFileOpener((FileOpener)this._app);
        this.setCursor(Cursor.getDefaultCursor());
        fd.setVisible(true);
        if (fd.isCanceled()) {
            return null;
        }
        Identifier[] ids = fd.getIdentifierList();
        if (ids == null || ids.length == 0) {
            return null;
        }
        if (!startSpecified) {
            this._remoteBrowseStartDir = fd.getDirectory();
            this._app.putAppProp("DownloadDirectory", this._remoteBrowseStartDir);
        }
        return ids;
    }

    protected Identifier localBrowseForDirectory() {
        if (this._localBrowseStartDir == null) {
            this._localBrowseStartDir = this._app.getAppProp("UploadDirectory");
        }
        if (this._localBrowseStartDir == null) {
            this._localBrowseStartDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(this._localBrowseStartDir);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select Local Directory");
        int opt = chooser.showOpenDialog((Component)((Object)this));
        if (opt != 0) {
            return null;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return null;
        }
        Identifier id = new Identifier(f.getAbsolutePath());
        this._localBrowseStartDir = f.getAbsolutePath();
        this._app.putAppProp("UploadDirectory", this._localBrowseStartDir);
        return id;
    }

    protected File[] localBrowse() {
        if (this._localBrowseStartDir == null) {
            this._localBrowseStartDir = this._app.getAppProp("UploadDirectory");
        }
        if (this._localBrowseStartDir == null) {
            this._localBrowseStartDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(this._localBrowseStartDir);
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle("Select Local Directory or File(s)");
        chooser.setMultiSelectionEnabled(true);
        int opt = chooser.showDialog((Component)((Object)this), "Select");
        if (opt != 0) {
            return null;
        }
        File[] f = chooser.getSelectedFiles();
        if (f == null || f.length == 0) {
            return null;
        }
        this._localBrowseStartDir = f[0].getAbsolutePath();
        this._app.putAppProp("UploadDirectory", this._localBrowseStartDir);
        return f;
    }

    public void exportWatershed() {
        ExportWatershedDialog dlg = new ExportWatershedDialog((Frame)((Object)this), true);
        dlg.setTitle("Select Export Watershed file");
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        WkspExportOptions options = new WkspExportOptions();
        options.setExistingOk(dlg.shouldOverwrite());
        options.setWkspDirectory(dlg.getDirectory());
        options.setWkspName(dlg.getWatershedName());
        ExportResults results = ClientApp.Workspace().export(options);
        if (!results.wasSuccessful()) {
            List messages = results.getMessages();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < messages.size(); ++i) {
                buffer.append((String)messages.get(i));
                buffer.append("\n");
            }
        }
    }

    public void setNewWatershedMenuVisible(boolean b) {
        this.menuItemNew.setVisible(b);
    }

    public DefaultJPanel getWatershedDataAccessoryPanel() {
        return null;
    }

    static {
        StreamAlignmentDrwPro.setDrawPropClassname((String)HecStreamAlignmentDrwPro.class.getName());
        _unitSystem = 0;
        _timeZone = 0;
    }

    public class FrameToolBar
    extends JToolBar {
        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            Component[] c = this.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == HecClientFrame.this._modeSelector || c[i] == HecClientFrame.this._modeSelectorLabel) continue;
                c[i].setEnabled(b);
            }
        }
    }

    private class ToolBarPanel
    extends JPanel {
        public ToolBarPanel() {
            this.setLayout(new CardLayout());
        }

        @Override
        public void setEnabled(boolean b) {
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setEnabled(b);
            }
        }

        public void modeClosing() {
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                comps = ((JPanel)comps[i]).getComponents();
                break;
            }
            if (comps == null) {
                return;
            }
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!(c instanceof RmaJAttributeToolbarButton)) continue;
                RmaJAttributeToolbarButton button = (RmaJAttributeToolbarButton)c;
                button.closeDrawPropDialog();
            }
        }
    }

    public class MessageLineUpdater
    implements Runnable {
        private final StringBuilder _txt = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText(String message) {
            if (message == null || message.length() == 0) {
                return;
            }
            boolean needsNewLine = message.charAt(message.length() - 1) != '\n';
            StringBuilder stringBuilder = this._txt;
            synchronized (stringBuilder) {
                this._txt.append(message);
                if (needsNewLine) {
                    this._txt.append('\n');
                }
            }
            System.out.print(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String toAppend;
            StringBuilder stringBuilder = this._txt;
            synchronized (stringBuilder) {
                if (this._txt.length() == 0) {
                    return;
                }
                toAppend = this._txt.charAt(this._txt.length() - 1) == '\n' ? this._txt.substring(0, this._txt.length() - 1) : this._txt.toString();
                this._txt.delete(0, this._txt.length());
            }
            HecClientFrame.this.textAreaMessages.append("\n" + toAppend);
            int pos = 0;
            Document document = HecClientFrame.this.textAreaMessages.getDocument();
            if (document != null && document.getLength() > 0) {
                pos = document.getLength() - 1;
            }
            HecClientFrame.this.textAreaMessages.setCaretPosition(pos);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == HecClientFrame.this.menuItemExit) {
                HecClientFrame.this.menuItemExit_Action(event);
            } else if (object == HecClientFrame.this.menuItemNew) {
                HecClientFrame.this.menuItemNew_Action(event);
            } else if (object == HecClientFrame.this.menuItemOpen) {
                HecClientFrame.this.menuItemOpen_Action(event);
            } else if (object == HecClientFrame.this.menuItemSave) {
                HecClientFrame.this.menuItemSave_Action(event);
            } else if (object == HecClientFrame.this.menuItemSaveMap) {
                HecClientFrame.this.menuItemSaveMap_Action();
            } else if (object == HecClientFrame.this.menuItemShowAll) {
                HecClientFrame.this.menuItemShowAll_Action(event);
            } else if (object == HecClientFrame.this.MenuItemLayers) {
                HecClientFrame.this.menuItemLayers_Action();
            } else if (object == HecClientFrame.this._asStoredunitItem) {
                HecClientFrame.this.menuItemAsStoredunitItem_Action(event);
            } else if (object == HecClientFrame.this._englishUnitItem) {
                HecClientFrame.this.menuItemEnglishUnitItem_Action(event);
            } else if (object == HecClientFrame.this._SIUnitItem) {
                HecClientFrame.this.menuItemSIUnitItem_Action(event);
            } else if (object == HecClientFrame.this.menuItemHelpTopics) {
                HecClientFrame.this.menuItemHelpTopics_Action(event);
            } else if (object == HecClientFrame.this.menuItemAbout) {
                HecClientFrame.this.menuItemAbout_Action(event);
            } else if (object == HecClientFrame.this.menuOptions) {
                HecClientFrame.this.menuItemOptions_Action(null);
            } else if (object == HecClientFrame.this.scriptMenu) {
                HecClientFrame.this.scriptMenu_Action(event);
            } else if (object == HecClientFrame.this.scriptEditor) {
                HecClientFrame.this.scriptEditor_Action(event);
            } else if (object == HecClientFrame.this.menuItemRestoreWindows) {
                HecClientFrame.this.restoreWindows_Action();
            } else if (object == HecClientFrame.this.menuItemShowGrids) {
                HecClientFrame.this.showGrids_Action();
            } else if (object == HecClientFrame.this.menuDssVue) {
                HecClientFrame.this.dssVue_Action();
            } else if (object == HecClientFrame.this.menuMemoryMonitor) {
                HecClientFrame.this.memoryMonitor_Action();
            } else if (object == HecClientFrame.this.menuProperties) {
                HecClientFrame.this.properties();
            } else if (object == HecClientFrame.this.menuViewServerLog) {
                HecClientFrame.this.viewServerLog();
            } else if (object == HecClientFrame.this.menuDownloadServerLog) {
                HecClientFrame.this.downloadCurrentServerLog();
            } else if (object == HecClientFrame.this.menuDownloadServerLogs) {
                HecClientFrame.this.downloadServerLogs();
            } else if (object == HecClientFrame.this.menuDownload) {
                HecClientFrame.this.download(null);
            } else if (object == HecClientFrame.this.menuViewFile) {
                HecClientFrame.this.viewFile(false);
            } else if (object == HecClientFrame.this.menuEditFile) {
                HecClientFrame.this.viewFile(true);
            } else if (object == HecClientFrame.this.menuUpload) {
                HecClientFrame.this.upload();
            } else if (object == HecClientFrame.this.menuDownloadWatershed) {
                DownloadWatershed dload = new DownloadWatershed();
                dload.setVisible(true);
            } else if (object == HecClientFrame.this.menuShowConsole) {
                ClientApp.app().showConsole();
            } else if (object == HecClientFrame.this.menuItemExport) {
                HecClientFrame.this.exportWatershed();
            } else if (object == HecClientFrame.this.menuShowDssLog) {
                HecClientFrame.this.showDssOutput();
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == HecClientFrame.this) {
                HecClientFrame.this.HecClientFrame_WindowClosing(event);
            }
        }

        @Override
        public void windowClosed(WindowEvent event) {
            Object object = event.getSource();
            if (object == HecClientFrame.this) {
                HecClientFrame.this.HecClientFrame_WindowClose(event);
            }
        }

        @Override
        public void windowOpened(WindowEvent event) {
            JMenuItem mi;
            if (HecClientFrame.this._app.getOpenLastWatershed() && ClientApp.Workspace() == null && (mi = HecClientFrame.this.getRecentWatershedMenu(0)) != null) {
                mi.doClick(0);
            }
        }
    }

    class FrameMouseMotionAdapter
    extends MouseMotionAdapter {
        FrameMouseMotionAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            HecClientFrame.this.printStatus("Ready");
        }
    }

    class ToolButtonAction
    extends AbstractAction {
        public ToolButtonAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

