/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.gfx2d.AbstractG2dDialog;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.LineProperties;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.Group;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.model.ModelVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import mil.army.usace.hec.rmi.client.SavePreferencesDialog;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSDataFactory;
import rma.util.RMAIO;

public class HecG2dDialog
extends AbstractG2dDialog {
    Group _group = null;
    protected Vector _plotObjs;
    private static final String ALL_USERS_WATERSHED = "All Users Watershed";
    private static final String ALL_USERS_ALL_WATERSHED = "All Users";

    public HecG2dDialog(Frame owner, String title, boolean modal, Group group) {
        this(owner, title, modal, group, null);
    }

    public HecG2dDialog(Frame owner, String title, boolean modal, Group group, List<LineProperties> colorVec) {
        this(owner, title, modal);
        this.initDialog(group, colorVec);
    }

    public HecG2dDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public HecG2dDialog(Frame owner, String title, boolean modal, Vector tsProxys, ModelVariable plotVar, Vector selectedObjs) {
        this(owner, title, modal);
        this.initDialog(tsProxys, plotVar, selectedObjs, null);
    }

    public HecG2dDialog(Frame owner, String title, boolean modal, Vector containers) {
        super(owner, title, modal, containers);
    }

    public HecG2dDialog(Frame owner, String title, boolean modal, Vector containers, G2dPanelProp prop) {
        super(owner, title, modal, containers, prop);
    }

    void initDialog(Group group, List<LineProperties> colorVec) {
        this.setSize(600, 500);
        System.out.println("*********In initDialog with group");
        this.getContentPane().setLayout(new BorderLayout());
        this._gfxPanel = new G2dPanel();
        this._group = group;
        if (this._group != null) {
            this._timewindow = this._group.getTimeWindow();
        }
        System.out.println("Group name = " + group.getName() + " Group timeWindow " + group.getTimeWindow());
        Vector dssvec = this.getDssList(group.getList(), group.getTimeWindow());
        DataTypeFactory.getFactory().reset();
        if (dssvec.size() <= 0) {
            return;
        }
        if (colorVec == null) {
            colorVec = DataTypeFactory.getFactory().getLineProperties((List)dssvec);
        }
        this._gfxPanel.buildComponents((List)dssvec, colorVec);
        this.getContentPane().add((Component)this._gfxPanel, "Center");
        this.makeMenus();
    }

    void initDialog(Vector proxyList, ModelVariable plotVar, Vector selectedObjs, Manager mgr) {
        this._plotObjs = selectedObjs;
    }

    public Vector getDssList(Vector datalist, String timewindow) {
        Vector<SimpleDSSData> dssvec = new Vector<SimpleDSSData>();
        if (datalist == null) {
            return dssvec;
        }
        DSSManager dssmanager = null;
        try {
            ClientApp.app();
            dssmanager = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
        }
        catch (Exception e) {
            System.out.println("getDssList: failed to get dssfilemanager " + e);
        }
        if (dssmanager == null) {
            return dssvec;
        }
        SimpleDSSDataFactory dssFactory = new SimpleDSSDataFactory((BaseDSSManager)dssmanager);
        for (int i = 0; i < datalist.size(); ++i) {
            SimpleDSSData data;
            DataReference ref = (DataReference)datalist.get(i);
            System.out.println("ref.getFilename = " + ref.getFilename() + " ref.getPath = " + ref.getPath());
            try {
                data = dssFactory.newSimpleDSSData(ref.getFilename(), ref.getPath(), timewindow);
            }
            catch (Exception e) {
                System.out.println("getDssList: error getting data for " + ref.getFilename() + ":" + ref.getPath());
                continue;
            }
            if (data == null || data.size() <= 0) {
                System.out.println("failed to get data for " + ref.getFilename() + ":" + ref.getPath());
                continue;
            }
            data.setGmtOffset(ref.getGmtOffset());
            dssvec.addElement(data);
        }
        return dssvec;
    }

    protected Identifier getOpenIdentifier(Identifier id, String extension, boolean saving) {
        Identifier id2;
        Object buffW = null;
        String path = id.getPath();
        if (extension != null && !path.endsWith(extension)) {
            path = path.concat(extension);
            id.setPath(path);
        }
        try {
            id2 = AppDaddy.getWorkspace().openFile(id, false);
            if (id2 != null) {
                int reply;
                if (saving && (reply = RMAIO.postYesNoWarning((Component)((Object)this), (String)(id2.getName() + " already exists!\n Do you want to replace it?"))) == 1) {
                    return null;
                }
            } else {
                id2 = AppDaddy.getWorkspace().createFile(id);
            }
            if (id2 == null) {
                RMAIO.postError((Component)((Object)this), (String)("Unable to open file " + path));
                return null;
            }
        }
        catch (Exception e) {
            System.out.println("Error opening file " + id.getPath() + " Error:" + e.getMessage());
            RMAIO.postError((Component)((Object)this), (String)("Unable to open file " + path));
            return null;
        }
        return id2;
    }

    public void exportProperties() {
        SavePreferencesDialog dialog = new SavePreferencesDialog((Frame)((Object)this), true);
        dialog.setTitle("Export Plot Template...");
        dialog.addUserDefinedLocation(ALL_USERS_WATERSHED, "plots", 2);
        dialog.addUserDefinedLocation(ALL_USERS_ALL_WATERSHED, "plots", 3);
        dialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        dialog.setSubDirectory("plots");
        Vector<String> v = new Vector<String>();
        v.add("*.template");
        dialog.setFileFilters(v);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Identifier id = dialog.getIdentifier();
        if (id == null) {
            return;
        }
        this.writeRemote(id);
    }

    public void exportProperties(String templateName) {
        if (templateName == null || templateName.length() == 0) {
            this.exportProperties();
            return;
        }
        this.writeRemote(new Identifier(templateName));
    }

    public void importProperties() {
        SavePreferencesDialog dialog = new SavePreferencesDialog((Frame)((Object)this), true);
        dialog.setTitle("Import Plot Template ...");
        dialog.addUserDefinedLocation(ALL_USERS_WATERSHED, "plots", 2);
        dialog.addUserDefinedLocation(ALL_USERS_ALL_WATERSHED, "plots", 3);
        dialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        dialog.setSubDirectory("plots");
        Vector<String> v = new Vector<String>();
        v.add("*.template");
        dialog.setFileFilters(v);
        dialog.updateList();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Identifier id = dialog.getIdentifier();
        if (id == null) {
            return;
        }
        G2dPanelProp prop = this.importPropertiesRemote(id);
        if (prop != null) {
            this._gfxPanel.resetProperties(prop);
            this.updateUnitSystem((Container)this._gfxPanel);
        }
    }

    private G2dPanelProp importPropertiesRemote(Identifier id) {
        G2dPanelProp panelProp = new G2dPanelProp();
        try {
            Identifier fileId;
            String path = id.getPath();
            if (!path.endsWith(".template")) {
                path = path.concat(".template");
                id.setPath(path);
            }
            if ((fileId = AppDaddy.getApp().getWorkspace().openFile(id, false)) == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to open file " + id.getPath(), "Error Opening Properites File", 0);
                return null;
            }
            HecFile file = fileId.getFile();
            if (file == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to open file " + id.getPath(), "Error Opening Properites File", 0);
                return null;
            }
            BufferedReader buffR = file.getBufferedReader();
            panelProp.readProperties(buffR);
            buffR.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Error Opening Properites File", 0);
        }
        return panelProp;
    }

    public void writeRemote(Identifier id) {
        Identifier id2 = this.getOpenIdentifier(id, ".template", true);
        if (id2 == null) {
            return;
        }
        HecFile hfile = id2.getFile();
        if (hfile == null) {
            return;
        }
        BufferedWriter buffW = hfile.getBufferedWriter();
        if (buffW == null) {
            return;
        }
        G2dPanelProp panelProp = this._gfxPanel.getProperties();
        try {
            panelProp.writeProperties(buffW);
            buffW.flush();
            buffW.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void applyTemplate(String templateFile) {
        if (templateFile == null) {
            return;
        }
        G2dPanelProp prop = null;
        templateFile = RMAIO.parsePathName((String)templateFile);
        prop = this.importPropertiesRemote(new Identifier(templateFile));
        if (prop != null) {
            this._gfxPanel.resetProperties(prop);
            this.updateUnitSystem((Container)((Object)this));
        }
    }
}

