/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.HecLayerSelectorTreePanel;
import hec.map.JLayerSelector;
import hec.map.JLayerSelectorTreePanel;
import hec.map.MapPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import javax.swing.JFrame;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.lang.Modifiable;
import rma.util.RMAIO;

public class HecLayerSelector
extends JLayerSelector {
    public HecLayerSelector(JFrame parent, boolean modal, MapPanel panel) {
        super(parent, modal, panel);
    }

    protected JLayerSelectorTreePanel createTreePanel(MapPanel panel) {
        return new HecLayerSelectorTreePanel((JFrame)((Object)this), (Modifiable)this, (Window)((Object)this), true, panel);
    }

    protected void writeLayersConfiguration() {
        BufferedWriter writer = PreferencesManager.getBufferedWriter((int)0, (String)"layers.conf");
        if (writer != null) {
            try {
                writer.write("layersWindow.OnTop=" + this._layersPanel.isOnTop());
                writer.newLine();
                Point p = this.getLocation();
                Dimension d = this.getSize();
                writer.write("layersWindow.Location=" + p.x + "," + p.y);
                writer.newLine();
                writer.write("layersWindow.Size=" + d.getWidth() + "," + d.getHeight());
                writer.newLine();
                writer.close();
            }
            catch (Exception e) {
                System.out.println("Error writing layer configuration " + e);
            }
        }
    }

    public void configureLayersDialog() {
        BufferedReader reader = PreferencesManager.getBufferedReader((int)0, (String)"layers.conf");
        if (reader != null) {
            this.configureLayersDialog(reader);
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void configureLayersDialog(BufferedReader reader) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String type = RMAIO.getType((String)line, (String)"=");
                String param = RMAIO.getParam((String)line, (String)"=");
                if (type.equals("layersWindow.OnTop")) {
                    this._onTop = Boolean.valueOf(param);
                    continue;
                }
                if (type.equals("layersWindow.Location")) {
                    this.setLocation(param);
                    continue;
                }
                if (!type.equals("layersWindow.Size")) continue;
                this.setSize(param);
            }
        }
        catch (Exception e) {
            System.out.println("configureLayersDialog: error reading file " + e);
        }
    }

    public void updateTitle() {
        super.updateTitle();
        if (this._layersPanel == null) {
            return;
        }
        HecLayerSelectorTreePanel layerPanel = (HecLayerSelectorTreePanel)this._layersPanel;
        layerPanel.getLockFile();
    }

    public void unlock() {
        HecLayerSelectorTreePanel layerPanel = (HecLayerSelectorTreePanel)this._layersPanel;
        layerPanel.unlock();
    }

    public void lock() {
        HecLayerSelectorTreePanel layerPanel = (HecLayerSelectorTreePanel)this._layersPanel;
        layerPanel.lock();
    }
}

