/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.map.raster.dbf.CreateRasterDbf;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.JLayerSelectorTreePanel;
import hec.map.MapIdentifier;
import hec.map.MapPanel;
import hec.map.appInterface.MapWorkspace;
import hec.map.image.ImportImageAction;
import hec.map.inundation.InundationGroupEditor;
import hec.map.raster.CreateRaster;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.lang.Modifiable;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class HecLayerSelectorTreePanel
extends JLayerSelectorTreePanel
implements CallBackInterface {
    protected Identifier _id;
    protected JCheckBoxMenuItem _menuEditConfig;
    protected JMenuItem _smrmpMenuItem;
    protected JMenuItem _inundationGroupMenuItem;
    protected JMenuItem _rasterDbfMenuItem;
    protected RmiFileCallBackImpl _writeCallBack;
    protected FileOpener _fileOpener;

    public HecLayerSelectorTreePanel(JFrame parentForDialogs, Modifiable modifiableParent, Window parentForClosing, boolean okcancelEnabled, MapPanel panel) {
        super(parentForDialogs, modifiableParent, parentForClosing, okcancelEnabled, panel);
    }

    protected void buildControls(boolean okcancelEnabled, boolean addMenusToFrame) {
        super.buildControls(okcancelEnabled, true);
        this.getLockFile();
    }

    public void getLockFile() {
        Identifier id = new Identifier(AppDaddy.getWorkspace().getWorkspacePath() + "/maps/layers.lck");
        this._fileOpener = AppDaddy.getWorkspace();
        this._id = this._fileOpener.openFile(id, false);
        if (this._id == null) {
            this._id = this._fileOpener.createFile(id);
        }
        if (this._id != null) {
            System.out.println("getLockFile:layers lockfile is " + this._id.getPath());
        }
    }

    protected void buildMenus(boolean okcancelEnabled, boolean addMenuToFrame) {
        super.buildMenus(okcancelEnabled, addMenuToFrame);
        this._menuEditConfig = new JCheckBoxMenuItem("Allow Layer Editing", true);
        this._menuEditConfig.setMnemonic('A');
        this._menuEditConfig.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._menuEditConfig, "editConfiguration"));
        if (AppDaddy.getApp().getAppType().equals("fda")) {
            this.mapsMenu.addSeparator();
            this._smrmpMenuItem = new JMenuItem("Create SMRMP", 83);
            this._smrmpMenuItem.setEnabled(false);
            this._smrmpMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._smrmpMenuItem, "createRaster"));
            this._inundationGroupMenuItem = new JMenuItem("Inundation Group Editor", 73);
            this._inundationGroupMenuItem.setEnabled(false);
            this._inundationGroupMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._inundationGroupMenuItem, "editInundationGroup"));
            this._rasterDbfMenuItem = new JMenuItem("Raster Dbf Editor", 82);
            this._rasterDbfMenuItem.setEnabled(false);
            this._rasterDbfMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._rasterDbfMenuItem, "editRasterDbf"));
            this.mapsMenu.add(this._smrmpMenuItem);
            this.mapsMenu.add(this._inundationGroupMenuItem);
            this.mapsMenu.add(this._rasterDbfMenuItem);
        }
        this.updateDialogState(true);
    }

    protected boolean isLocked() {
        return true;
    }

    public void createRaster() {
        CreateRaster dialog = new CreateRaster((Frame)this._parentForDialogs, false);
        dialog.setVisible(true);
    }

    public void editRasterDbf() {
        CreateRasterDbf dialog = new CreateRasterDbf(this._parentForDialogs, false);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void editInundationGroup() {
        InundationGroupEditor dialog = new InundationGroupEditor((Frame)this._parentForDialogs, true);
        dialog.setVisible(true);
    }

    protected void lockErrorMsg() {
        new Throwable("Layer Lock Failed").printStackTrace();
        System.out.println("Failed to get FileLock for Layers for " + this._id.getPath());
        this._menuEditConfig.setSelected(false);
        int opt = JOptionPane.showOptionDialog((Component)((Object)this), "Failed to open layer dialog. Currently being edited", "Lock Failed", 0, 2, null, new Object[]{"OK", "More Info"}, "OK");
        if (opt == 0) {
            return;
        }
        FileLockInfoJDialog dialog = new FileLockInfoJDialog((Frame)this._parentForDialogs);
        dialog.setUserId(AppDaddy.getApp().getUser());
        Vector v = null;
        dialog.fillForm(this._id, v);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void editConfiguration() {
        if (this._menuEditConfig.isSelected()) {
            if (!this.setLocked(4)) {
                this._menuEditConfig.setSelected(false);
                this.lockErrorMsg();
            }
            this.updateDialogState(true);
        } else {
            this.setLocked(5);
            this.updateDialogState(false);
        }
    }

    private void updateDialogState(boolean locked) {
        TreePath path;
        this.buttonAdd.setEnabled(true);
        this.buttonImportImage.setEnabled(true);
        if (AppDaddy.getApp().getAppType().equals("fda")) {
            this._smrmpMenuItem.setEnabled(true);
            this._inundationGroupMenuItem.setEnabled(true);
            this._rasterDbfMenuItem.setEnabled(true);
        }
        if ((path = this.layersTree.getSelectionPath()) != null) {
            this.pathSelected(path.getLastPathComponent());
        }
    }

    public void closing() {
        this.setLocked(1);
        super.closing();
    }

    private boolean setLocked(int lockType) {
        FileLock flock = new FileLock(AppDaddy.getApp().getUser(), lockType);
        switch (lockType) {
            case 3: 
            case 4: {
                boolean b = this._fileOpener.lockFile(this._id, flock);
                if (b && lockType == 4) {
                    this.setCallback();
                }
                return b;
            }
            case 1: 
            case 5: {
                if (this._fileOpener.unlockFile(this._id, flock) && lockType == 5) {
                    this.removeCallback();
                }
                return true;
            }
        }
        return false;
    }

    protected void setCallback() {
        if (this._id == null || this._id.getFile() == null) {
            System.out.println("setCallback:failed to set layers file callback. No file");
            return;
        }
        try {
            this._writeCallBack = new RmiFileCallBackImpl((CallBackInterface)this);
        }
        catch (RemoteException e) {
            System.out.println("Error creating callback exception: " + e);
            e.printStackTrace();
            return;
        }
        HecFile file = this._id.getFile();
        if (file instanceof HecFileImpl) {
            RemoteWrapper wrap = this._writeCallBack.getRemoteReference();
            ((HecFileImpl)file).setCallBack(wrap);
            System.out.println("setCallback:layers callback set for " + this._id.getPath());
        }
    }

    protected void removeCallback() {
        if (this._id == null || this._id.getFile() == null || this._writeCallBack == null) {
            return;
        }
        HecFile file = this._id.getFile();
        if (file instanceof HecFileImpl) {
            RemoteWrapper wrap = this._writeCallBack.getRemoteReference();
            ((HecFileImpl)file).removeCallBack(wrap);
        }
    }

    public void notify(String msg) {
        System.out.println("LayerDialog.notify:" + msg);
        StringTokenizer tokenizer = new StringTokenizer(msg, "|");
        if (tokenizer.countTokens() == 3 && this._id != null) {
            String filename = tokenizer.nextToken();
            if (!RMAIO.pathsEqual((String)filename, (String)this._id.getPath())) {
                return;
            }
            String type = tokenizer.nextToken();
            if ("Unlocked".equals(type) && this.isLocked()) {
                this._menuEditConfig.setSelected(false);
                this.removeCallback();
                this.updateDialogState(false);
            }
        }
    }

    protected void closeChildDialogs() {
        super.closeChildDialogs();
    }

    public boolean isConfigurationLocked() {
        return true;
    }

    public boolean canOpen() {
        if (!this.setLocked(3)) {
            this.lockErrorMsg();
            return false;
        }
        return true;
    }

    public Action createImportImageAction() {
        ImportImageAction action = new ImportImageAction(){

            protected void addMaps(List<File> maps) {
                ArrayList mapObjects = new ArrayList();
                try {
                    for (int i = 0; i < maps.size(); ++i) {
                        File f = maps.get(i);
                        MapIdentifier mapId = new MapIdentifier(f.getAbsolutePath());
                        mapId.setMapShown(true);
                        MapWorkspace workspace = (MapWorkspace)AppDaddy.getWorkspace();
                        workspace.addMap(mapId);
                    }
                    ((HecClientFrame)ClientApp.app().getFrame()).updateWorkspace();
                }
                catch (RuntimeException ioe) {
                    JOptionPane.showMessageDialog(null, ioe.getMessage(), "", 0);
                }
            }

            protected File[] getImageFiles() {
                RmiFileDialog chooser = null;
                Window w = SwingUtilities.windowForComponent((Component)((Object)HecLayerSelectorTreePanel.this));
                ArrayList<RMAFilenameFilter> fileFilters = new ArrayList<RMAFilenameFilter>();
                fileFilters.add(new RMAFilenameFilter("*.gif", "GIF (*.gif)"));
                fileFilters.add(new RMAFilenameFilter("*.png", "PNG (*.png)"));
                fileFilters.add(new RMAFilenameFilter(new String[]{"*.jpg", "*.jpeg"}, "JPEG (*.jpg,*.jpeg)"));
                fileFilters.add(new RMAFilenameFilter(new String[]{"*.tif", "*.tiff"}, "TIFF (*.tif, *.tiff)"));
                fileFilters.add(new RMAFilenameFilter("*.bmp", "Bitmap(*.bmp)"));
                fileFilters.add(new RMAFilenameFilter("*.sid", "MrSid (*.sid)"));
                chooser = w instanceof JFrame ? new RmiFileDialog((Frame)w, true, AppDaddy.getWorkspace().getWorkspacePath() + "/maps", fileFilters) : new RmiFileDialog((Dialog)w, true, AppDaddy.getWorkspace().getWorkspacePath() + "/maps", fileFilters);
                chooser.setMultipleSelectionAllowed(true);
                chooser.setOpenTitle();
                chooser.setVisible(true);
                if (chooser.isCanceled()) {
                    return null;
                }
                Identifier[] idList = chooser.getIdentifierList();
                File[] fileList = null;
                if (idList != null && idList.length > 0) {
                    fileList = new File[idList.length];
                    for (int z = 0; z < idList.length; ++z) {
                        Identifier id1 = null;
                        Identifier id0 = idList[z];
                        try {
                            id1 = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), id0);
                        }
                        catch (RemoteException re) {
                            System.out.println("Caught remote exception opening map " + id0.getPath() + " exception " + re);
                            return null;
                        }
                        if (id1 == null) {
                            return null;
                        }
                        MapIdentifier mapId = new MapIdentifier(id1);
                        fileList[z] = (File)mapId.getFile();
                    }
                }
                return fileList;
            }

            protected File createFile(String path) {
                try {
                    Identifier tempId = new Identifier(path);
                    Identifier id = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).openFile(ClientApp.app().getUser(), tempId);
                    if (id == null) {
                        id = ((RmiFileManager)ClientApp.app().getFileManager().getRemote()).newFile(ClientApp.app().getUser(), tempId);
                    }
                    return (HecFileImpl)id.getFile();
                }
                catch (RemoteException re) {
                    System.out.println("Caught remote exception opening map " + path + " exception " + re);
                    return null;
                }
            }

            public BufferedReader getBufferedReader(File f) {
                return f instanceof HecFile ? ((HecFile)f).getBufferedReader() : super.getBufferedReader(f);
            }

            public InputStream getInputStream(File f) {
                if (f instanceof HecFile) {
                    return ((HecFile)f).getDataInputStream();
                }
                return super.getInputStream(f);
            }

            public BufferedWriter getBufferedWriter(File f) {
                return f instanceof HecFile ? ((HecFile)f).getBufferedWriter() : super.getBufferedWriter(f);
            }
        };
        action.setParentComponent((Component)((Object)this));
        action.setRootDirctory(AppDaddy.getWorkspace().getWorkspacePath());
        action.setMapsDirectory(AppDaddy.getWorkspace().getWorkspacePath() + "/maps");
        action.setMapPanel(this._mapPanel);
        return action;
    }

    public void unlock() {
    }

    public void lock() {
        if (!this.isLocked()) {
            this._menuEditConfig.setSelected(true);
            this.setLocked(5);
            this.updateDialogState(true);
        }
    }
}

