/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.properties.HECRemoteProperties;
import hec.map.streamAlignment.StreamAlignmentDPData;
import hec.map.streamAlignment.StreamAlignmentProps;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import rma.util.RMAIO;

public class HecStreamAlignmentDrwPro
extends HECRemoteProperties
implements StreamAlignmentProps {
    protected static final String FILE_NAME = "streamAlign.properties";
    protected static List _dataList = new ArrayList();

    public HecStreamAlignmentDrwPro() {
        super(FILE_NAME, 0);
    }

    public Properties createProperties(Properties properties) {
        properties.put("drawTicLabels", "true");
        properties.put("drawTics", "true");
        properties.put("showStreamName", "true");
        properties.put("streamWidth", "6");
        properties.put("ticLength", "7");
        properties.put("majorTicLength", "14");
        properties.put("streamColor", "-32768");
        properties.put("nodeColor", String.valueOf(new Color(0, 128, 0).getRGB()));
        properties.put("nodeOutlineColor", String.valueOf(new Color(0, 64, 0).getRGB()));
        properties.put("drawNodes", "true");
        properties.put("nodeWidth", "7");
        properties.put("junctionColor", String.valueOf(Color.GREEN.getRGB()));
        properties.put("drawJunctions", "true");
        properties.put("junctionWidth", "5");
        StreamAlignmentDPData data = new StreamAlignmentDPData(-1);
        _dataList.add(data);
        return properties;
    }

    public void read(BufferedReader input) throws IOException {
        System.out.println("read:_newFile=" + this._newFile);
        if (this._newFile) {
            String line;
            System.out.println("read:reading stream.align properties");
            _dataList.clear();
            StreamAlignmentDPData data = null;
            int scale = 0;
            while ((line = input.readLine()) != null && line.indexOf("StreamAlignDrawPropEnd") < 0) {
                String prefix;
                String type = RMAIO.getType((String)line, (String)"=");
                if (type.indexOf(".") > -1) {
                    prefix = RMAIO.getType((String)type, (String)".");
                    type = RMAIO.getParam((String)type, (String)".");
                } else {
                    prefix = "-1";
                }
                String param = RMAIO.getParam((String)line, (String)"=");
                int tmp = RMAIO.parseInt((String)prefix, (int)-1);
                if (tmp != scale) {
                    if (tmp == 0) {
                        tmp = -1;
                    }
                    data = new StreamAlignmentDPData(tmp);
                    _dataList.add(data);
                    scale = tmp;
                }
                if (type.compareTo("drawTicLabels") == 0) {
                    data.setDrawTicLabels("true".equalsIgnoreCase(param));
                    continue;
                }
                if (type.compareTo("drawTics") == 0) {
                    data.setDrawTics("true".equalsIgnoreCase(param));
                    continue;
                }
                if (type.compareTo("showStreamName") == 0) {
                    data.setShowStreamName("true".equalsIgnoreCase(param));
                    continue;
                }
                if (type.compareTo("streamWidth") == 0) {
                    data.setStreamWidth(new Integer(param).intValue());
                    continue;
                }
                if (type.compareTo("ticLength") == 0) {
                    data.setTicLength(new Integer(param).intValue());
                    continue;
                }
                if (type.compareTo("majorTicLength") == 0) {
                    data.setMajorTicLength(new Integer(param).intValue());
                    continue;
                }
                if (type.compareTo("streamColor") == 0) {
                    int rgb = Integer.parseInt(param);
                    data.setStreamColor(new Color(rgb));
                    continue;
                }
                if (type.compareTo("nodeColor") == 0) {
                    data.setNodeColor(new Color(Integer.parseInt(param)));
                    continue;
                }
                if (type.compareTo("nodeOutlineColor") == 0) {
                    data.setNodeOutlineColor(new Color(Integer.parseInt(param)));
                    continue;
                }
                if (type.compareTo("drawNodes") == 0) {
                    data.setDrawNodes("true".equalsIgnoreCase(param));
                    continue;
                }
                if (type.compareTo("nodeWidth") == 0) {
                    data.setNodeWidth(Integer.parseInt(param));
                    continue;
                }
                if (type.compareTo("junctionColor") == 0) {
                    data.setJunctionColor(new Color(Integer.parseInt(param)));
                    continue;
                }
                if (type.compareTo("drawJunctions") == 0) {
                    data.setDrawJunctions("true".equalsIgnoreCase(param));
                    continue;
                }
                if (type.compareTo("junctionWidth") != 0) continue;
                data.setJunctionWidth(Integer.parseInt(param));
            }
            Collections.sort(_dataList);
        }
    }

    public void write(BufferedWriter out) throws IOException {
    }

    public StreamAlignmentDPData getDrawingProperties() {
        int size = _dataList.size();
        if (size == 0) {
            this.createProperties(this.properties);
        }
        return (StreamAlignmentDPData)_dataList.get(size - 1);
    }

    public StreamAlignmentDPData getDrawingPropertiesForScale(int scale) {
        int size = _dataList.size();
        if (scale < 1) {
            return this.getDrawingProperties();
        }
        for (int i = 0; i < size; ++i) {
            StreamAlignmentDPData data = (StreamAlignmentDPData)_dataList.get(i);
            if (data.getMapScale() != scale) continue;
            return data;
        }
        System.out.println("getDrawingPropertiesForScale:no data found at scale " + scale);
        return null;
    }

    public StreamAlignmentDPData getDrawingProperties(int scale) {
        if (scale < 1) {
            return this.getDrawingProperties();
        }
        StreamAlignmentDPData retData = null;
        int size = _dataList.size();
        if (size == 0) {
            this.createProperties(this.properties);
            size = _dataList.size();
        }
        if (size == 1) {
            return (StreamAlignmentDPData)_dataList.get(0);
        }
        for (int i = 0; i < size; ++i) {
            StreamAlignmentDPData data = (StreamAlignmentDPData)_dataList.get(i);
            if (data.getMapScale() < scale) continue;
            retData = data;
        }
        if (retData == null) {
            retData = (StreamAlignmentDPData)_dataList.get(size - 1);
        }
        return retData;
    }

    @Override
    public void loadProperties() {
        int i;
        StreamAlignmentDPData data;
        super.loadProperties();
        int numscales = RMAIO.parseInt((String)this.getProp("numberOfScales", "0"));
        if (numscales == 0) {
            data = new StreamAlignmentDPData(-1);
            _dataList.add(data);
        } else {
            for (i = 0; i < numscales; ++i) {
                String s = this.getProp("scaleName" + i);
                if (s == null) {
                    System.out.println("load:no property found for scaleName" + i);
                    continue;
                }
                data = new StreamAlignmentDPData(RMAIO.parseInt((String)s));
                this.loadProps(data, s);
            }
        }
        Collections.sort(this.getScaleList());
        for (i = 0; i < this.getScaleList().size(); ++i) {
            data = (StreamAlignmentDPData)this.getScaleList().get(i);
            System.out.println("load:" + data.getClass().getName() + " " + i + " scale=" + data.getMapScale());
        }
    }

    protected void loadProps(StreamAlignmentDPData data, String scaleName) {
        if (scaleName != null && scaleName.length() > 0) {
            scaleName = scaleName.concat(".");
        }
        String s = this.getProp(scaleName + "drawTicLabels", "true");
        data.setDrawTicLabels("true".equalsIgnoreCase(s));
        s = this.getProp(scaleName + "drawTics", "true");
        data.setDrawTics("true".equalsIgnoreCase(s));
        s = this.getProp(scaleName + "showStreamName", "true");
        data.setShowStreamName("true".equalsIgnoreCase(s));
        s = this.getProp(scaleName + "streamWidth", "6");
        data.setStreamWidth(RMAIO.parseInt((String)s));
        s = this.getProp(scaleName + "ticLength", "7");
        data.setTicLength(RMAIO.parseInt((String)s));
        s = this.getProp(scaleName + "majorTicLength", "14");
        data.setMajorTicLength(RMAIO.parseInt((String)s));
        s = this.getProp(scaleName + "streamColor", "-32768");
        data.setStreamColor(new Color(RMAIO.parseInt((String)s, (int)Short.MIN_VALUE)));
        s = this.getProp(scaleName + "nodeColor", "-16744448");
        data.setNodeColor(new Color(RMAIO.parseInt((String)s, (int)-16744448)));
        s = this.getProp(scaleName + "nodeOutlineColor", "-16760832");
        data.setNodeOutlineColor(new Color(RMAIO.parseInt((String)s, (int)-16760832)));
        s = this.getProp(scaleName + "drawNodes", "true");
        data.setDrawNodes("true".equalsIgnoreCase(s));
        s = this.getProp(scaleName + "nodeWidth", "7");
        data.setNodeWidth(RMAIO.parseInt((String)s));
        s = this.getProp(scaleName + "junctionColor", "-16711936");
        data.setJunctionColor(new Color(RMAIO.parseInt((String)s, (int)-16711936)));
        s = this.getProp(scaleName + "drawJunctions", "true");
        data.setDrawJunctions("true".equalsIgnoreCase(s));
        s = this.getProp(scaleName + "junctionWidth", "12");
        data.setJunctionWidth(RMAIO.parseInt((String)s));
        if (!_dataList.contains(data)) {
            _dataList.add(data);
        }
    }

    public int getNumberOfScales() {
        return _dataList.size();
    }

    public List getScaleList() {
        return _dataList;
    }

    public void addDPData(StreamAlignmentDPData data) {
        _dataList.add(data);
        Collections.sort(_dataList);
    }

    @Override
    public void saveProperties(int location) {
        this.clearProperties();
        int size = _dataList.size();
        this.setProp("numberOfScales", String.valueOf(size));
        for (int i = 0; i < size; ++i) {
            String prefix;
            StreamAlignmentDPData data = (StreamAlignmentDPData)_dataList.get(i);
            if (data.getMapScale() < 1) {
                prefix = "";
                this.setProp("scaleName" + i, "");
            } else {
                prefix = String.valueOf(data.getMapScale());
                this.setProp("scaleName" + i, prefix);
                prefix = prefix.concat(".");
            }
            this.saveDataProperties(data, prefix);
        }
        super.saveProperties(location);
    }

    private void saveDataProperties(StreamAlignmentDPData data, String scaleName) {
        this.setProp(scaleName + "drawTicLabels", String.valueOf(data.isDrawTicLabels()));
        this.setProp(scaleName + "drawTics", String.valueOf(data.isDrawTics()));
        this.setProp(scaleName + "showStreamName", String.valueOf(data.isShowStreamName()));
        this.setProp(scaleName + "streamWidth", String.valueOf(data.getStreamWidth()));
        this.setProp(scaleName + "ticLength", String.valueOf(data.getTicLength()));
        this.setProp(scaleName + "majorTicLength", String.valueOf(data.getMajorTicLength()));
        this.setProp(scaleName + "streamColor", String.valueOf(data.getStreamColor().getRGB()));
        this.setProp(scaleName + "nodeColor", String.valueOf(data.getNodeColor().getRGB()));
        this.setProp(scaleName + "nodeOutlineColor", String.valueOf(data.getNodeOutlineColor().getRGB()));
        this.setProp(scaleName + "drawNodes", String.valueOf(data.isDrawNodes()));
        this.setProp(scaleName + "nodeWidth", String.valueOf(data.getNodeWidth()));
        this.setProp(scaleName + "junctionColor", String.valueOf(data.getJunctionColor().getRGB()));
        this.setProp(scaleName + "drawJunctions", String.valueOf(data.isDrawJunctions()));
        this.setProp(scaleName + "junctionWidth", String.valueOf(data.getJunctionWidth()));
    }

    public void reset() {
        this.clearProperties();
        _dataList.clear();
        this.initializeProperties();
    }
}

