/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.io.Identifier;
import hec.model.WatershedLocation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class JDialogLoadWorkspace
extends RmaJDialog {
    protected boolean _canceled = false;
    protected boolean _standAlone = false;
    protected RmiApp _rmiApp;
    JPanel jPanelCurrentWorkspace;
    RmaJTextField jTextFieldCurrentWorkspace;
    JPanel jPanelAvailableLocations;
    RmaJList jListAvailableLocations;
    ButtonCmdPanel cmdPanel;
    JPanel jPanelAvailableWorkspaces;
    RmaJTable jListAvailableWorkspaces;
    JPanel jPanel3;
    RmaJRadioButton jRadioButtonLocal;
    RmaJRadioButton jRadioButtonRemote;
    JLabel jLabelRemote;
    RmaJComboBox jComboBoxRemote;
    JPanel jPanel4;

    public void setCurrentWorkspace(String str) {
        this.jTextFieldCurrentWorkspace.setText(str);
    }

    public void setAvailableWorkspaces(Vector ids) {
        this.jListAvailableWorkspaces.deleteCells();
        if (ids == null) {
            return;
        }
        Collections.sort(ids);
        for (int i = 0; i < ids.size(); ++i) {
            Vector row = new Vector(2);
            Object id = ids.get(i);
            row.add(id);
            if (id instanceof Identifier) {
                row.add(((Identifier)id).getDescription());
            }
            this.jListAvailableWorkspaces.appendRow(row);
        }
        if (ids.size() > 0) {
            this.jListAvailableWorkspaces.updateSelection(0, 0, false, false);
            this.jListAvailableWorkspaces.requestDefaultFocus();
            this.jListAvailableWorkspaces.grabFocus();
        }
    }

    public void setAvailableBindingSites(String[] stringArray) {
        for (int ii = 0; ii < stringArray.length; ++ii) {
            this.jComboBoxRemote.addItem((Object)stringArray[ii]);
        }
        if (this.jComboBoxRemote.getItemCount() > 0) {
            this.jComboBoxRemote.setSelectedIndex(0);
        }
    }

    public void setAppServer(RmiApp app) {
        this._rmiApp = app;
        ((RmaListModel)this.jListAvailableLocations.getModel()).clear();
        if (this._rmiApp != null) {
            try {
                Vector v = ClientApp.app().getWatershedLocations(true);
                ((RmaListModel)this.jListAvailableLocations.getModel()).addAll((Collection)v);
                if (this.jListAvailableLocations.getModel().getSize() > 0) {
                    this.jListAvailableLocations.setSelectedIndex(0);
                }
            }
            catch (Exception re) {
                System.out.println("setAppServer: Error retrieving available workspace locations from app " + re);
            }
        }
    }

    public void setStandAlone(boolean tf) {
        this._standAlone = tf;
        this.setLocal(this._standAlone);
        if (this._standAlone) {
            this.jRadioButtonRemote.setEnabled(false);
            this.jRadioButtonLocal.doClick();
        }
        this.jRadioButtonRemote.setEnabled(false);
        this.jRadioButtonLocal.setEnabled(false);
    }

    public boolean getStandAlone() {
        return this._standAlone;
    }

    public boolean getCanceled() {
        return this._canceled;
    }

    public boolean getLocal() {
        return this.jRadioButtonLocal.isSelected();
    }

    public void setLocal(boolean local) {
        if (local) {
            this.jRadioButtonLocal.doClick();
        } else {
            this.jRadioButtonRemote.doClick();
        }
    }

    public Identifier getChosenWorkspace() {
        Object obj;
        int row = this.jListAvailableWorkspaces.getSelectedRow();
        if (row > -1 && (obj = this.jListAvailableWorkspaces.getCell(row, 0)) instanceof Identifier) {
            return (Identifier)obj;
        }
        return null;
    }

    public Identifier setChosenWorkspace(String workspaceName) {
        String name;
        int colon = workspaceName.indexOf(":");
        if (colon > 1) {
            String location = workspaceName.substring(0, colon);
            name = workspaceName.substring(colon + 1);
            boolean found = false;
            for (int row = 0; row < this.jListAvailableLocations.getModel().getSize(); ++row) {
                Object obj = ((RmaListModel)this.jListAvailableLocations.getModel()).elementAt(row);
                if (!(obj instanceof WatershedLocation) || !location.equals(((WatershedLocation)obj).getName())) continue;
                this.jListAvailableLocations.setSelectedIndex(row);
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        } else {
            name = workspaceName;
        }
        for (int row = 0; row < this.jListAvailableWorkspaces.getRowCount(); ++row) {
            Identifier id;
            Object obj = this.jListAvailableWorkspaces.getCell(row, 0);
            if (!(obj instanceof Identifier) || !(id = (Identifier)obj).getName().equals(name)) continue;
            ListSelectionModel sel = this.jListAvailableWorkspaces.getSelectionModel();
            sel.setLeadSelectionIndex(row);
            return id;
        }
        return null;
    }

    public String getChosenBindingSite() {
        return (String)this.jComboBoxRemote.getSelectedItem();
    }

    public String getWatershedLocation() {
        Object obj = this.jListAvailableLocations.getSelectedValue();
        if (obj instanceof WatershedLocation) {
            return ((WatershedLocation)obj).getDirectory();
        }
        return null;
    }

    void jComboBoxRemote_actionPerformed(ActionEvent event) {
        this.jRadioButtonRemote.doClick();
    }

    protected void jRadioButtonLocal_itemStateChanged() {
        if (this.jRadioButtonLocal.isSelected()) {
            this.jComboBoxRemote.setEnabled(false);
        } else if (!this.jRadioButtonLocal.isSelected()) {
            // empty if block
        }
    }

    protected void jRadioButtonRemote_itemStateChanged() {
        if (this.jRadioButtonRemote.isSelected()) {
            this.jComboBoxRemote.setEnabled(true);
        } else if (!this.jRadioButtonRemote.isSelected()) {
            // empty if block
        }
    }

    protected void jListAvailableWorkspaces_mouseClicked(MouseEvent event) {
        if (event.getClickCount() >= 2) {
            this.jButtonOpen_actionPerformed();
        }
    }

    protected void jButtonOpen_actionPerformed() {
        if (this.jListAvailableWorkspaces.getRowCount() > 0 && this.jListAvailableWorkspaces.getSelectedRow() > -1) {
            this.dispose();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must select a Watershed first.", "Error Opening Watershed", 2);
        }
    }

    protected void jButtonCancel_actionPerformed() {
        this._canceled = true;
        this.dispose();
    }

    public JDialogLoadWorkspace(Frame parent) {
        super(parent);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.setDefaultSize(600, 400);
        this.jPanelCurrentWorkspace = new JPanel(new GridBagLayout());
        this.jPanelCurrentWorkspace.setBounds(4, 4, 453, 27);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.getContentPane().add((Component)this.jPanelCurrentWorkspace, gbc);
        this.jTextFieldCurrentWorkspace = new RmaJTextField();
        this.jTextFieldCurrentWorkspace.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldCurrentWorkspace.setEditable(false);
        this.jTextFieldCurrentWorkspace.setBounds(4, 4, 445, 19);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jPanelCurrentWorkspace.add((Component)this.jTextFieldCurrentWorkspace, gbc);
        this.jPanelAvailableLocations = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.getContentPane().add((Component)this.jPanelAvailableLocations, gbc);
        this.jListAvailableLocations = new RmaJList((ListModel)new RmaListModel(true)){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 100;
                return d;
            }

            public String getToolTipText(MouseEvent e) {
                int idx = JDialogLoadWorkspace.this.jListAvailableLocations.locationToIndex(e.getPoint());
                if (idx < 0) {
                    return null;
                }
                Object obj = ((RmaListModel)JDialogLoadWorkspace.this.jListAvailableLocations.getModel()).elementAt(idx);
                if (obj instanceof WatershedLocation) {
                    return ((WatershedLocation)obj).getDirectory();
                }
                return null;
            }
        };
        this.jListAvailableLocations.setToolTipText("");
        this.jListAvailableLocations.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jPanelAvailableLocations.add((Component)new JScrollPane((Component)this.jListAvailableLocations), gbc);
        this.jPanelAvailableWorkspaces = new JPanel(new GridBagLayout());
        this.jPanelAvailableWorkspaces.setBounds(4, 39, 453, 206);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.5;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.getContentPane().add((Component)this.jPanelAvailableWorkspaces, gbc);
        this.jListAvailableWorkspaces = new RmaJTable((Component)((Object)this), new String[]{"Name", "Description"}){

            public String getToolTipText(MouseEvent e) {
                int row = JDialogLoadWorkspace.this.jListAvailableWorkspaces.rowAtPoint(e.getPoint());
                if (row < 0) {
                    return null;
                }
                int col = JDialogLoadWorkspace.this.jListAvailableWorkspaces.columnAtPoint(e.getPoint());
                if (col == 1) {
                    return (String)JDialogLoadWorkspace.this.jListAvailableWorkspaces.getCell(row, 1);
                }
                Object obj = JDialogLoadWorkspace.this.jListAvailableWorkspaces.getCell(row, 0);
                if (obj instanceof Identifier) {
                    return ((Identifier)obj).getPath();
                }
                return null;
            }

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 250;
                d.height = 100;
                return d;
            }
        };
        this.jListAvailableWorkspaces.setToolTipText("");
        this.jListAvailableWorkspaces.setCellSelectionEnabled(false);
        this.jListAvailableWorkspaces.setColumnSelectionAllowed(false);
        this.jListAvailableWorkspaces.setRowSelectionAllowed(true);
        this.jListAvailableWorkspaces.setSelectionMode(0);
        this.jListAvailableWorkspaces.setShowGrid(false);
        this.jListAvailableWorkspaces.setEditable(false);
        this.jListAvailableWorkspaces.setPopupMenuEnabled(false);
        this.jListAvailableWorkspaces.setColumnWidths(new int[]{100, 150});
        this.jListAvailableWorkspaces.getCellRenderer(0, 0);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 2.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jPanelAvailableWorkspaces.add((Component)this.jListAvailableWorkspaces.getScrollPane(), gbc);
        this.jPanel3 = new JPanel(new GridBagLayout());
        this.jPanel3.setBounds(4, 253, 453, 65);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jRadioButtonLocal = new RmaJRadioButton("Local Watershed");
        this.jRadioButtonLocal.setActionCommand("Local Watershed");
        this.jRadioButtonLocal.setHorizontalAlignment(0);
        this.jRadioButtonLocal.setBounds(4, 4, 212, 25);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jRadioButtonRemote = new RmaJRadioButton("Remote Watershed");
        this.jRadioButtonRemote.setActionCommand("Remote Watershed");
        this.jRadioButtonRemote.setHorizontalAlignment(0);
        this.jRadioButtonRemote.setBounds(224, 4, 225, 25);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jLabelRemote = new JLabel();
        this.jLabelRemote.setText("Bind Watershed to:");
        this.jLabelRemote.setHorizontalAlignment(4);
        this.jLabelRemote.setBounds(4, 41, 212, 15);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.jComboBoxRemote = new RmaJComboBox();
        this.jComboBoxRemote.setBounds(224, 37, 225, 24);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        JDialogLoadWorkspace.this.jButtonOpen_actionPerformed();
                        break;
                    }
                    case 4: {
                        JDialogLoadWorkspace.this.jButtonCancel_actionPerformed();
                    }
                }
            }
        });
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymItem lSymItem = new SymItem();
        this.jRadioButtonLocal.addItemListener((ItemListener)lSymItem);
        this.jRadioButtonRemote.addItemListener((ItemListener)lSymItem);
        SymAction lSymAction = new SymAction();
        SymMouse aSymMouse = new SymMouse();
        this.jListAvailableWorkspaces.addMouseListener((MouseListener)aSymMouse);
        this.jListAvailableWorkspaces.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JDialogLoadWorkspace.this.jListAvailableWorkspaces.getRowCount() <= 0 || JDialogLoadWorkspace.this.jListAvailableWorkspaces.getSelectedRow() > -1) {
                    // empty if block
                }
            }
        });
        this.jListAvailableLocations.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JDialogLoadWorkspace.this.jListAvailableWorkspaces.deleteCells();
                if (JDialogLoadWorkspace.this._rmiApp == null) {
                    System.out.println("null rmiapp");
                    return;
                }
                WatershedLocation wl = (WatershedLocation)JDialogLoadWorkspace.this.jListAvailableLocations.getSelectedValue();
                if (wl == null) {
                    System.out.println("no location selected");
                    return;
                }
                try {
                    JDialogLoadWorkspace.this.setCursor(Cursor.getPredefinedCursor(3));
                    String dir = wl.getDirectory();
                    String baseDir = ClientApp.app().getBaseWkspDirectory();
                    if (baseDir != null) {
                        dir = dir.concat(baseDir);
                    }
                    Vector wksps = JDialogLoadWorkspace.this._rmiApp.getWorkspaces(ClientApp.app().getUser(), dir);
                    JDialogLoadWorkspace.this.setAvailableWorkspaces(wksps);
                    JDialogLoadWorkspace.this.jListAvailableWorkspaces.updateSelection(0, 0, false, false);
                }
                catch (RemoteException re) {
                    System.out.println("RMI Error getting list of watershed from Server. " + re);
                }
                finally {
                    JDialogLoadWorkspace.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.jPanelCurrentWorkspace.setBorder(new TitledBorder("Current Watershed"));
        this.jPanelAvailableWorkspaces.setBorder(new TitledBorder("Available Watersheds"));
        this.jPanelAvailableLocations.setBorder(new TitledBorder("Available Locations"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.jRadioButtonLocal);
        buttonGroup.add((AbstractButton)this.jRadioButtonRemote);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void setVisible(boolean tf) {
        if (tf) {
            if (this.jListAvailableLocations.getModel().getSize() == 0) {
                String msg = ClientApp.app().isNetworked() ? "The System has no Watershed Locations defined.\nPlease contact the CWMS Administrator and have them configure the Watershed Locations." : "<html>There are no Watershed Locations defined.<br>Please configure the Watershed Locations under <b>Tools->Options </b> menu <b>Model Directories</b> tab";
                JOptionPane.showMessageDialog(this.getParent(), msg, "No Locations", 1);
                this._canceled = true;
                return;
            }
            this.setSize(this.getPreferredSize());
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(tf);
    }

    void JDialog1_WindowClosing(WindowEvent event) {
        this._canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    void enterPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.doClick();
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == JDialogLoadWorkspace.this) {
                JDialogLoadWorkspace.this.JDialog1_WindowClosing(event);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDialogLoadWorkspace.this.jListAvailableLocations.requestFocus();
                }
            });
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == JDialogLoadWorkspace.this.jRadioButtonLocal) {
                JDialogLoadWorkspace.this.jRadioButtonLocal_itemStateChanged();
            } else if (object == JDialogLoadWorkspace.this.jRadioButtonRemote) {
                JDialogLoadWorkspace.this.jRadioButtonRemote_itemStateChanged();
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            if (object == JDialogLoadWorkspace.this.jListAvailableWorkspaces) {
                JDialogLoadWorkspace.this.jListAvailableWorkspaces_mouseClicked(event);
            }
        }
    }
}

