/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.IdentifierTableModel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.gui.NameDescriptionPanel;
import hec.io.Identifier;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.table.WildcardRowFilter;
import rma.swing.text.FilenameDocument;
import rma.util.RMAIO;
import rma.util.RMASort;

public class ManagerChooser
extends RmaJDialog
implements ButtonCmdPanelListener {
    public static final String ALL_FILTER = ".*";
    public static final String NO_CAVI_NAMES_FILTER = "^[#_a-zA-Z0-9][^:].*";
    boolean _ok = false;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int DELETE = 2;
    public static final int NEW = 3;
    public static final int OPEN = 4;
    public static final int SAVEAS = 5;
    public static final int RENAME = 6;
    public static final long USES_TABLE = 1L;
    public static final long UNIQUE_NAME = 4L;
    String _model;
    int _mode;
    ClientWorkspace _Workspace;
    String _className;
    String _typeName;
    String _extension = "dat";
    int _selection = -1;
    String _deleteMessage = "<html>Do you really want to remove from use<br><b>";
    String _postfixMessage = "</b> ?</html>";
    long _flags;
    protected NameDescriptionPanel _namePanel;
    IdentifierTableModel _idTableModel;
    protected RmaJTable _idTable;
    JLabel label1;
    JTextField textFieldSelectManager;
    JLabel labelWorkspace;
    JLabel labelType;
    JScrollPane _existingMangersScrollPane;
    ButtonCmdPanel panelButtons;
    private Vector _allIdVector;
    protected Pattern _pattern = Pattern.compile(".*");
    private String _filter;

    public ManagerChooser(Frame parent, boolean modal, int mode, long flags) {
        super(parent, modal);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._mode = mode;
        this._flags = flags;
        this.buildDefaultComponents(2);
        this.setResizable(true);
        this.setLocation();
    }

    public ManagerChooser(Dialog parent, boolean modal, int mode, long flags) {
        super(parent, modal);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._mode = mode;
        this._flags = flags;
        this.buildDefaultComponents(2);
        this.setLocation();
    }

    public ManagerChooser(Window parent, boolean modal, int mode, long flags) {
        super(parent, modal);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._mode = mode;
        this._flags = flags;
        this.buildDefaultComponents(2);
        this.setResizable(true);
        this.setLocation();
    }

    public ManagerChooser(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildDefaultComponents(1);
    }

    protected void buildDefaultComponents(int mode) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.label1 = new JLabel("Watershed:");
        this.label1.setBounds(this.getInsets().left + 10, this.getInsets().top + 10, 76, 23);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.label1, gbc);
        this.labelWorkspace = new JLabel("Watershed name");
        this.labelWorkspace.setBounds(this.getInsets().left + 91, this.getInsets().top + 10, 259, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.labelWorkspace, gbc);
        this._idTableModel = this.createDefaultTableModel(null, mode);
        this._idTable = new RmaJTable(){

            public String getToolTipText(MouseEvent e) {
                int row = ManagerChooser.this._idTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return null;
                }
                int column = ManagerChooser.this._idTable.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return null;
                }
                Identifier id = ManagerChooser.this._idTableModel.getIdentifierAt(row);
                if (id == null) {
                    return null;
                }
                if (column == 0) {
                    return id.getPath();
                }
                if (column == 1) {
                    String desc = id.getDescription();
                    return RMAIO.toHtmlString((String)desc);
                }
                return null;
            }

            public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
                return super.getCellRect(row, column, true);
            }
        };
        this._idTable.setProcessKeyEvents(false);
        this._idTable.setModel((TableModel)this._idTableModel);
        this._idTable.setRowSelectionAllowed(true);
        this._idTable.setColumnSelectionAllowed(false);
        this._idTable.setSelectionMode(0);
        this._idTable.setPopupMenuEnabled(false);
        this._idTable.setShowGrid(false);
        this._idTable.setRowHeight(20);
        this._idTable.setEditable(false);
        this._idTable.setRowSorter(new TableRowSorter<IdentifierTableModel>(this._idTableModel));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this._existingMangersScrollPane = this._idTable.getScrollPane();
        this._existingMangersScrollPane.setVerticalScrollBarPolicy(22);
        this._existingMangersScrollPane.setHorizontalScrollBarPolicy(30);
        this._existingMangersScrollPane.setBorder(BorderFactory.createTitledBorder("Existing Managers"));
        this.getContentPane().add((Component)this._existingMangersScrollPane, gbc);
        this.textFieldSelectManager = new JTextField((Document)new FilenameDocument(), "", 20);
        this.textFieldSelectManager.setBounds(this.getInsets().left + 10, this.getInsets().top + 252, 340, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.labelType = new JLabel("manager type");
        this.labelType.setBounds(this.getInsets().left + 91, this.getInsets().top + 38, 259, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        long namepanelflags = this.getNamePanelFlags();
        this._namePanel = this.buildDescriptionPanel(namepanelflags);
        this._namePanel.setBorder(this.getNamePanelBorder(null));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._namePanel, gbc);
        this.setTitle("ManagerChooser");
        SymItem lSymItem = new SymItem();
        this._idTable.getSelectionModel().addListSelectionListener(lSymItem);
        this._idTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int row = ManagerChooser.this._idTable.getSelectedRow();
                if (event.getClickCount() == 2 && row > -1) {
                    switch (ManagerChooser.this._mode) {
                        case 6: {
                            ManagerChooser.this.panelButtons.doButtonClick(1024);
                            break;
                        }
                        case 1: 
                        case 5: {
                            ManagerChooser.this.panelButtons.doButtonClick(16);
                            break;
                        }
                        case 0: 
                        case 4: {
                            ManagerChooser.this.panelButtons.doButtonClick(32);
                            break;
                        }
                        case 2: {
                            ManagerChooser.this.panelButtons.doButtonClick(64);
                            break;
                        }
                        case 3: {
                            ManagerChooser.this.panelButtons.doButtonClick(512);
                        }
                    }
                } else if (row == -1) {
                    ManagerChooser.this._idTable.clearSelection();
                }
            }
        });
        this.setMode(this._mode);
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerChooser.this.findFilterAction();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        KeyStroke ks1 = KeyStroke.getKeyStroke(27, 0);
        KeyStroke findKs = KeyStroke.getKeyStroke(70, 128);
        this._idTable.getInputMap(1).put(ks, "none");
        this._idTable.getInputMap(1).put(ks, "none");
        this._idTable.getInputMap(1).put(ks, "none");
        this._idTable.getInputMap(1).put(ks1, "none");
        this._idTable.getInputMap(1).put(ks1, "none");
        this._idTable.getInputMap(1).put(ks1, "none");
        this.getRootPane().getInputMap(1).put(findKs, "find");
        this.getRootPane().getActionMap().put("find", findAction);
        this.setResizable(false);
        this.setSize(this.getInsets().left + this.getInsets().right + 360, this.getInsets().top + this.getInsets().bottom + 318);
        this.setDefaultSize(this.getInsets().left + this.getInsets().right + 360, this.getInsets().top + this.getInsets().bottom + 318);
    }

    protected NameDescriptionPanel buildDescriptionPanel(long namepanelflags) {
        return new NameDescriptionPanel(namepanelflags);
    }

    protected long getNamePanelFlags() {
        return this._flags;
    }

    protected void findFilterAction() {
        this._filter = JOptionPane.showInputDialog((Component)((Object)this), "Filter Table by:", this._filter);
        if (this._filter == null || this._filter.length() == 0) {
            ((TableRowSorter)this._idTable.getRowSorter()).setRowFilter(null);
        } else {
            WildcardRowFilter f = new WildcardRowFilter(this._filter, -1);
            ((TableRowSorter)this._idTable.getRowSorter()).setRowFilter(f);
        }
    }

    public Border getNamePanelBorder(String typename) {
        this._typeName = typename;
        String title = "";
        switch (this._mode) {
            case 4: {
                title = "Open";
                break;
            }
            case 0: {
                title = "Load";
                break;
            }
            case 1: {
                title = "Save";
                break;
            }
            case 2: {
                title = "Delete";
                break;
            }
            case 3: {
                title = "New";
                break;
            }
            case 5: {
                title = "Save As";
                break;
            }
            case 6: {
                title = "Rename";
            }
        }
        if (typename != null && typename.length() > 0) {
            title = title.concat(" ").concat(typename);
        }
        return BorderFactory.createTitledBorder(title);
    }

    public void buttonCmdActionPerformed(ActionEvent event) {
        switch (event.getID()) {
            case 32: {
                this.buttonOpen_Action(event);
                break;
            }
            case 16: {
                this.buttonOpen_Action(event);
                break;
            }
            case 64: {
                this.buttonOpen_Action(event);
                break;
            }
            case 512: {
                this.buttonNew_Action(event);
                break;
            }
            case 4: {
                this.buttonCancel_Action(event);
                break;
            }
            case 1024: {
                this.buttonOpen_Action(event);
            }
        }
    }

    public void setDeleteConfirmMessage(String deleteMessage, String postfixMessage) {
        this._deleteMessage = deleteMessage;
        this._postfixMessage = postfixMessage;
    }

    void buttonOpen_Action(ActionEvent event) {
        this._ok = true;
        Identifier id = this._idTableModel.getIdentifierAt(this._selection);
        if (id == null && this._mode != 5 && this._mode != 6) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select an item.", "Warning", 2);
            return;
        }
        if (this._mode == 2) {
            int retValue;
            if (this._selection < 0) {
                return;
            }
            String names = this._namePanel.getName();
            if (names.indexOf(",") > -1) {
                StringTokenizer tokenizer = new StringTokenizer(names, ",");
                StringBuffer buffer = new StringBuffer();
                while (tokenizer.hasMoreTokens()) {
                    buffer.append(tokenizer.nextToken().trim());
                    if (!tokenizer.hasMoreTokens()) continue;
                    buffer.append("<br>");
                }
                names = buffer.toString();
            }
            if ((retValue = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)(this._deleteMessage + names + this._postfixMessage))) == 2) {
                return;
            }
            this._ok = retValue != 1;
        } else if (this._mode == 5 || this._mode == 6) {
            Vector<Identifier> idList = ClientApp.Workspace().getManagerIDList(this._model, this._className);
            String name = this._namePanel.getName();
            for (int i = 0; i < idList.size(); ++i) {
                Identifier id2 = idList.get(i);
                if (!this.namesEqual(id2.getName(), name)) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "A " + this.labelType.getText() + " already exists with the name selected", "Warning", 2);
                return;
            }
            ManagerProxy proxy = null;
            ManagerProxyList proList = ClientApp.Workspace().getManagerProxyList(this._model);
            try {
                proxy = proList.getManagerProxy(this._className, this.getManagerIdentifier(name));
            }
            catch (Exception e) {
                this.setVisible(false);
            }
            if (proxy != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "A " + RMAIO.userNameToFileName((String)name) + " file already exists for the " + this._typeName + ", " + name + ".  Please enter a new name.", "Error", 0);
                return;
            }
        }
        this.setVisible(false);
    }

    protected String getFolder(String name) {
        return this._model;
    }

    protected boolean namesEqual(String name1, String name2) {
        boolean retval = false;
        if (name1 != null) {
            retval = name1.equals(name2);
        }
        return retval;
    }

    protected Identifier getManagerIdentifier(String name) {
        return ClientApp.Workspace().getManagerIdentifier(this.getFolder(name), this._className, name, this._extension);
    }

    protected void buttonNew_Action(ActionEvent event) {
        this._ok = true;
        String name = this._namePanel.getName();
        if (name == null || name.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a name.", "Warning", 2);
            return;
        }
        if (!this.nameIsUnique(name)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a unique name.", "Warning", 2);
            return;
        }
        ManagerProxy proxy = null;
        ManagerProxyList proList = ClientApp.Workspace().getManagerProxyList(this._model);
        try {
            proxy = proList.getManagerProxy(this._className, this.getManagerIdentifier(name));
        }
        catch (Exception e) {
            this.setVisible(false);
        }
        if (proxy != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "A " + RMAIO.userNameToFileName((String)name) + " file already exists for the " + this._typeName + ", " + name + ".  Please enter a new name.", "Error", 0);
            return;
        }
        this.setVisible(false);
    }

    boolean nameIsUnique(String name) {
        Comparator<String> comparator = this.getStringComparator();
        if (this._allIdVector != null) {
            for (int i = 0; i < this._allIdVector.size(); ++i) {
                Identifier id = (Identifier)this._allIdVector.get(i);
                if (0 != comparator.compare(name, id.getName())) continue;
                return false;
            }
            return true;
        }
        if (this._idTableModel == null) {
            return true;
        }
        int rowcount = this._idTableModel.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            String str = (String)this._idTableModel.getValueAt(i, 0);
            if (0 != comparator.compare(name, str)) continue;
            return false;
        }
        return true;
    }

    protected Comparator<String> getStringComparator() {
        return String::compareToIgnoreCase;
    }

    void buttonCancel_Action(ActionEvent event) {
        this._ok = false;
        this.setVisible(false);
    }

    void textFieldSelectManager_TextValueChanged(TextEvent event) {
    }

    void idTable_ItemStateChanged() {
        if (this._idTable.getSelectionModel().getSelectionMode() == 0) {
            this._selection = this._idTable.getSelectedRow();
            if (this._selection >= 0) {
                this._selection = this._idTable.convertRowIndexToModel(this._selection);
                Identifier id = this._idTableModel.getIdentifierAt(this._selection);
                if (id != null) {
                    this._namePanel.setName(id.getName());
                    this._namePanel.setDescription(id.getDescription());
                }
            }
        } else {
            int[] rows = this._idTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                this._selection = -1;
            } else {
                this._selection = this._idTable.convertRowIndexToModel(rows[0]);
                String names = "";
                for (int i = 0; i < rows.length; ++i) {
                    Identifier id = this._idTableModel.getIdentifierAt(rows[i]);
                    if (id == null) continue;
                    names = names.concat(id.getName());
                    if (i >= rows.length - 1) continue;
                    names = names.concat(", ");
                }
                this._namePanel.setName(names);
                if (rows.length == 1) {
                    this._namePanel.setDescription(this._idTableModel.getIdentifierAt(rows[0]).getDescription());
                } else {
                    this._namePanel.setDescription("");
                }
            }
        }
        int button = -1;
        boolean enableButtons = this._selection != -1;
        switch (this._mode) {
            case 1: {
                button = 16;
                break;
            }
            case 0: {
                button = 32;
                break;
            }
            case 2: {
                button = 64;
            }
        }
        if (button != -1) {
            this.panelButtons.setButtonEnable(button, enableButtons);
        }
    }

    public boolean ok() {
        return this._ok;
    }

    public void setMode(int mode) {
        this._mode = mode;
        if (this.panelButtons != null) {
            this.getContentPane().remove((Component)this.panelButtons);
            this.panelButtons.removeCmdPanelListener((ButtonCmdPanelListener)this);
        }
        switch (this._mode) {
            case 6: {
                this._idTable.setIsEditable(false);
                this.panelButtons = new ButtonCmdPanel(1028);
                this.setOKButtonSearchString("Rename");
                this._namePanel.setPanelEditable(true);
                break;
            }
            case 5: {
                this._idTable.setIsEditable(false);
            }
            case 1: {
                this.panelButtons = new ButtonCmdPanel(20);
                this.setOKButtonSearchString("Save");
                this._namePanel.setPanelEditable(true);
                break;
            }
            case 0: 
            case 4: {
                this.panelButtons = new ButtonCmdPanel(36);
                this.setOKButtonSearchString("Open");
                this._namePanel.setPanelEditable(false);
                break;
            }
            case 2: {
                this.panelButtons = new ButtonCmdPanel(68);
                this.setOKButtonSearchString("Delete");
                this._namePanel.setPanelEditable(false);
                break;
            }
            case 3: {
                this.panelButtons = new ButtonCmdPanel(516);
                this.setOKButtonSearchString("New");
                this._namePanel.setPanelEditable(true);
            }
        }
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panelButtons, gbc);
        this.panelButtons.addCmdPanelListener((ButtonCmdPanelListener)this);
    }

    public void setMultipleSelectionsAllowed(boolean multiplesAllowed) {
        if (multiplesAllowed) {
            this._idTable.setSelectionMode(2);
        } else {
            this._idTable.setSelectionMode(0);
        }
    }

    public void setManagerType(String model, String className, String typename) {
        this._model = model;
        this.setManagerType(model, className, typename, "dat");
    }

    public void setManagerType(String model, String className, String typename, String ext) {
        Vector idVector;
        this._model = model;
        this._className = className;
        this._extension = ext;
        this.labelWorkspace.setText(ClientApp.Workspace().getTitleName());
        this.labelType.setText(typename);
        if (this._existingMangersScrollPane != null) {
            Object title = "Existing ";
            if (typename != null && typename.length() > 0) {
                title = (String)title + typename + "s";
            }
            ((TitledBorder)this._existingMangersScrollPane.getBorder()).setTitle((String)title);
        }
        if (this._namePanel != null) {
            this._namePanel.setBorder(this.getNamePanelBorder(typename));
        }
        if ((idVector = ClientApp.Workspace().getManagerIDList(this._model, className)) == null) {
            return;
        }
        this._allIdVector = idVector;
        RMASort.quickSort(idVector);
        idVector = this.filterIdVector(idVector);
        if (this._idTableModel != null) {
            this._idTableModel.setIdentifierList(idVector);
        }
    }

    protected Vector filterIdVector(Vector v) {
        if (this._pattern == null) {
            return v;
        }
        Vector<Identifier> filteredVec = new Vector<Identifier>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            Identifier id = (Identifier)v.get(i);
            if (!this._pattern.matcher(id.getName()).matches()) continue;
            filteredVec.add(id);
        }
        return filteredVec;
    }

    public Identifier getIdentifier() {
        switch (this._mode) {
            case 0: 
            case 2: {
                if (this._selection < 0) break;
                return this._idTableModel.getIdentifierAt(this._selection);
            }
            case 3: {
                Identifier newid = new Identifier();
                newid.setName(this._namePanel.getName());
                newid.setDescription(this._namePanel.getDescription());
                return newid;
            }
            case 4: {
                if (this._selection >= 0) {
                    return this._idTableModel.getIdentifierAt(this._selection);
                }
                return null;
            }
            case 1: {
                String name = this.textFieldSelectManager.getText();
                if (name == null || name.length() <= 0) {
                    return null;
                }
                return this.getManagerIdentifier(name);
            }
            case 6: {
                String name = this._namePanel.getName();
                if (name == null || name.length() <= 0) {
                    return null;
                }
                Identifier newId = this.getManagerIdentifier(name);
                newId.setDescription(this._namePanel.getDescription());
                return newId;
            }
            case 5: {
                Identifier newid = new Identifier();
                newid.setName(this._namePanel.getName());
                newid.setDescription(this._namePanel.getDescription());
                if (this._selection > -1) {
                    Identifier id = this._idTableModel.getIdentifierAt(this._selection);
                    newid.setPath(id.getPath());
                }
                return newid;
            }
        }
        return null;
    }

    public Vector getIdentifierList() {
        Vector<Identifier> idList = new Vector<Identifier>();
        if (this._idTable.getSelectionModel().getSelectionMode() == 0) {
            Identifier id = this.getIdentifier();
            if (id != null) {
                idList.add(id);
            }
        } else {
            int[] rows = this._idTable.getSelectedRows();
            if (rows != null && rows.length > 0) {
                for (int i = 0; i < rows.length; ++i) {
                    idList.add(this._idTableModel.getIdentifierAt(rows[i]));
                }
            }
        }
        return idList;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.getParent());
            if ((this._mode == 0 || this._mode == 4) && this._idTable.getRowCount() > 0) {
                this._idTable.updateSelection(0, 0, false, false);
            }
        }
        super.setVisible(b);
    }

    protected IdentifierTableModel createDefaultTableModel(Vector id, int mode) {
        return new IdentifierTableModel(id, mode);
    }

    public void setName(String name) {
        this._namePanel.setName(name);
    }

    public void setDescription(String description) {
        this._namePanel.setDescription(description);
    }

    public void setAccessoryPanel(JPanel panel) {
        this.setAccessoryPanel(panel, 3);
    }

    public void setAccessoryPanel(JPanel panel, int ypos) {
        if (panel == null) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ypos;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)panel, gbc);
    }

    public void setNameFilter(String filter) {
        if (filter == null) {
            this._pattern = Pattern.compile(ALL_FILTER);
            return;
        }
        try {
            this._pattern = Pattern.compile(filter);
        }
        catch (Exception e) {
            System.out.println("setNameFilter: Error compiling filter " + filter);
            this._pattern = Pattern.compile(ALL_FILTER);
        }
    }

    public void setNameDocument(Document doc) {
        this._namePanel.setNameDocument(doc);
    }

    protected long getFlags() {
        return this._flags;
    }

    protected JLabel getLabelType() {
        return this.labelType;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            ManagerChooser.this._ok = false;
        }
    }

    class SymItem
    implements ListSelectionListener {
        SymItem() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            Object object = event.getSource();
            if (ManagerChooser.this._idTable != null && object == ManagerChooser.this._idTable.getSelectionModel()) {
                ManagerChooser.this.idTable_ItemStateChanged();
            }
        }
    }

    class SymText
    implements TextListener {
        SymText() {
        }

        @Override
        public void textValueChanged(TextEvent event) {
            Object object = event.getSource();
            if (object == ManagerChooser.this.textFieldSelectManager) {
                ManagerChooser.this.textFieldSelectManager_TextValueChanged(event);
            }
        }
    }
}

