/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.MapInfoDialog;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ManagerProxyListManager;
import hec.io.AsciiSerializable;
import hec.io.AsciiSerializerFormatter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.SerializerEditDlg;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class ManagerInfoDialog
extends RmaJDialog {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final String[] _wkspNames = new String[]{"cavi", "dssmapgui", "fda", "fia", "gridUtil", "hfp", "Main", "mfp", "ras", "rss", "resprm", "supplemental"};
    private RmaJTable _managerInfoTable;
    private JComboBox<String> _wkspNameCombo;
    private ManagerProxyListContainer _wksp;
    private JButton _saveButton;
    private JButton _mapInfoButton;
    private MapInfoDialog _mapInfoDialog;
    private JButton _closeButton;
    private JButton _openFolderButton;

    public ManagerInfoDialog(Frame parent, ManagerProxyListContainer wksp) {
        super(parent);
        this.buildControls();
        this.addListeners();
        if (wksp != null) {
            this._wksp = wksp;
            String name = "";
            if (wksp instanceof ClientWorkspace) {
                name = ((ClientWorkspace)wksp).getTitleName();
            } else if (wksp instanceof ManagerProxyListManager) {
                name = ((ManagerProxyListManager)wksp).getName();
            }
            this.setTitle("Manager Information for " + name);
            this._wkspNameCombo.setSelectedItem(ClientApp.app().getAppType());
        }
        this._mapInfoButton.setVisible(this._wksp instanceof ClientWorkspace || this._wksp instanceof ManagerProxyListManager);
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets5505 = new Insets(5, 5, 0, 5);
        JLabel label = new JLabel("Workspace:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5505;
        this.getContentPane().add((Component)label, gbc);
        this._wkspNameCombo = new JComboBox<String>(this._wkspNames);
        this._wkspNameCombo.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5505;
        this.getContentPane().add(this._wkspNameCombo, gbc);
        this._managerInfoTable = new RmaJTable((Component)((Object)this), new String[]{"Name", "Description", "Path", "Type", "Index", "Modified Time", "Ref Count", "Modified", "HashCode", "GC'd"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 200;
                d.width = ClientApp.frame().getWidth() - 70;
                return d;
            }
        };
        RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this._managerInfoTable.getModel());
        this._managerInfoTable.setModel((TableModel)sorter);
        sorter.addMouseListenerToHeaderInTable((JTable)this._managerInfoTable);
        this._managerInfoTable.setEditable(false);
        this._managerInfoTable.setHorizontalAlignment(4, 4);
        this._managerInfoTable.setHorizontalAlignment(4, 6);
        this._managerInfoTable.setHorizontalAlignment(4, 8);
        this._managerInfoTable.setColumnWidths(new int[]{150, 150, 200, 200, 50, 150, 50, 50, 50, 50});
        this._managerInfoTable.setCellSelectionEnabled(false);
        this._managerInfoTable.setColumnSelectionAllowed(false);
        this._managerInfoTable.setRowSelectionAllowed(true);
        this._managerInfoTable.setCheckBoxCellEditor(7);
        this._managerInfoTable.setCheckBoxCellEditor(9);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets5505;
        this.getContentPane().add((Component)this._managerInfoTable.getScrollPane(), gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = insets5505;
        this.getContentPane().add((Component)panel, gbc);
        this._openFolderButton = new JButton("Open Folder...");
        this._openFolderButton.setEnabled(false);
        if (RMAIO.getOSType() == 1) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 0.01;
            gbc.anchor = 16;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5555;
            panel.add((Component)this._openFolderButton, gbc);
        }
        JButton viewConfButton = new JButton("View Configuration File");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        this._mapInfoButton = new JButton("Map Manager Info");
        this._mapInfoButton.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)this._mapInfoButton, gbc);
        this._saveButton = new JButton("Save");
        this._saveButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)this._saveButton, gbc);
        this._closeButton = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)this._closeButton, gbc);
    }

    protected void addListeners() {
        this._managerInfoTable.getSelectionModel().addListSelectionListener(e -> this.tableSelectionChanged());
        this._openFolderButton.addActionListener(e -> this.openFolderAction());
        this._wkspNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerInfoDialog.this.fillForm((String)ManagerInfoDialog.this._wkspNameCombo.getSelectedItem());
            }
        });
        this._closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerInfoDialog.this.setVisible(false);
                ManagerInfoDialog.this.dispose();
            }
        });
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = ManagerInfoDialog.this._managerInfoTable.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    if (!"true".equalsIgnoreCase(ManagerInfoDialog.this._managerInfoTable.getValueAt(rows[i], 7).toString()) || !ManagerInfoDialog.this.saveManager((ManagerProxy)ManagerInfoDialog.this._managerInfoTable.getValueAt(rows[i], 0))) continue;
                    ManagerInfoDialog.this._managerInfoTable.setValueAt((Object)"false", rows[i], 7);
                }
            }
        });
        this._mapInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerInfoDialog.this.mapInfo();
            }
        });
        this._managerInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int[] rows = ManagerInfoDialog.this._managerInfoTable.getSelectedRows();
                    if (rows == null || rows.length == 0) {
                        ManagerInfoDialog.this._saveButton.setEnabled(false);
                        return;
                    }
                    for (int i = 0; i < rows.length; ++i) {
                        if (!"true".equalsIgnoreCase(ManagerInfoDialog.this._managerInfoTable.getValueAt(rows[i], 7).toString())) continue;
                        ManagerInfoDialog.this._saveButton.setEnabled(true);
                        return;
                    }
                    ManagerInfoDialog.this._saveButton.setEnabled(false);
                } else if (e.getClickCount() == 2) {
                    int row = ManagerInfoDialog.this._managerInfoTable.rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    ManagerProxy proxy = (ManagerProxy)ManagerInfoDialog.this._managerInfoTable.getValueAt(row, 0);
                    Manager mgr = proxy.getManager();
                    if (mgr == null) {
                        JOptionPane.showMessageDialog((Component)((Object)ManagerInfoDialog.this), "This ManagerProxy's manager hasn't been instantiated.");
                        return;
                    }
                    if (mgr instanceof AsciiSerializable) {
                        try {
                            StringWriter strWriter = new StringWriter();
                            BufferedWriter buffWriter = new BufferedWriter(strWriter);
                            HecAsciiSerializer serializer = new HecAsciiSerializer(buffWriter);
                            serializer.serializeObject((Object)mgr);
                            buffWriter.flush();
                            SerializerEditDlg chooserDialog = new SerializerEditDlg((Dialog)((Object)ManagerInfoDialog.this), "Serialized Object " + mgr.getName(), false);
                            AsciiSerializerFormatter formatter = new AsciiSerializerFormatter();
                            String serObject = strWriter.getBuffer().toString();
                            String text = formatter.format(serObject);
                            chooserDialog.setText(text);
                            chooserDialog.setEditable(false);
                            chooserDialog.setVisible(true);
                        }
                        catch (IOException ioe) {
                            ((FluentLogger.Api)LOGGER.atInfo()).log("IOException: Error deserializing Manager %s", (Object)ioe.getMessage());
                        }
                    }
                }
            }
        });
        this._wkspNameCombo.setSelectedItem("Main");
        this.pack();
        this.setLocation();
    }

    private void openFolderAction() {
        if (Desktop.isDesktopSupported()) {
            int row = this._managerInfoTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            String managerPath = (String)this._managerInfoTable.getValueAt(row, 2);
            String managerDir = RMAIO.getDirectoryFromPath((String)managerPath);
            File file = new File(managerDir);
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(file);
            }
            catch (IOException e) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("Failed to open explorer for %s. error %s", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            }
        }
    }

    private void tableSelectionChanged() {
        int row = this._managerInfoTable.getSelectedRow();
        this._openFolderButton.setEnabled(row != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillForm(String wkspName) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this._managerInfoTable.getRowCount() > 0) {
                this._managerInfoTable.deleteCells();
            }
            if (wkspName == null || this._wksp == null) {
                return;
            }
            ManagerProxyList list = wkspName.equals("Main") ? this._wksp.getManagerProxyList("") : this._wksp.getManagerProxyList(wkspName);
            if (list == null) {
                return;
            }
            Date dt = new Date();
            for (int i = 0; i < list.size(); ++i) {
                ManagerProxy proxy = (ManagerProxy)list.get(i);
                if (proxy == null) continue;
                Vector<Object> row = new Vector<Object>(6);
                row.add(proxy);
                row.add(proxy.getDescription());
                row.add(proxy.getId().getPath());
                row.add(proxy.getClassName());
                row.add(proxy.getIndex());
                dt.setTime(proxy.getLastModifiedTime());
                row.add(dt.toString().substring(4));
                row.add(proxy.getObserverCount());
                if (proxy.getManager() != null) {
                    row.add(String.valueOf(proxy.getManager().isModified()));
                    row.add(String.valueOf(((Object)((Object)proxy.getManager())).hashCode()));
                } else {
                    row.add("false");
                    row.add("-1");
                }
                row.add(String.valueOf(proxy.hasBeenGCd()));
                this._managerInfoTable.appendRow(row);
            }
            if (!this.isVisible()) {
                this._wkspNameCombo.setSelectedItem(ClientApp.app().getAppType());
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean saveManager(ManagerProxy managerProxy) {
        Manager mgr = managerProxy.getManager();
        if (mgr == null) {
            return false;
        }
        String model = (String)this._wkspNameCombo.getSelectedItem();
        return this._wksp.saveManager(model, mgr);
    }

    private void mapInfo() {
        if (this._mapInfoDialog == null) {
            this._mapInfoDialog = new MapInfoDialog((Frame)this.getParent(), ClientApp.frame().getMapPanel());
        }
        this._mapInfoDialog.setVisible(true);
    }

    public void setVisible(boolean b) {
        if (!b) {
            if (this._mapInfoDialog != null) {
                this._mapInfoDialog.setVisible(false);
            }
            this._managerInfoTable.deleteCells();
        }
        super.setVisible(b);
    }
}

